package iso20022.auth030.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.esma.SecuritiesTransactionPrice14Choice__1;
import iso20022.auth030.esma.SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder;
import iso20022.auth030.esma.SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1BuilderImpl;
import iso20022.auth030.esma.SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Impl;
import iso20022.auth030.esma.meta.SecuritiesTransactionPrice14Choice__1Meta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Choice to define the price of the securities transaction.
 * @version ${project.version}
 */
@RosettaDataType(value="SecuritiesTransactionPrice14Choice__1", builder=SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="SecuritiesTransactionPrice14Choice__1", model="iso20022", builder=SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1BuilderImpl.class, version="${project.version}")
public interface SecuritiesTransactionPrice14Choice__1 extends RosettaModelObject {

	SecuritiesTransactionPrice14Choice__1Meta metaData = new SecuritiesTransactionPrice14Choice__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Indicates that price is expressed as a rate, that is a percentage.
	 */
	BigDecimal getRate();

	/*********************** Build Methods  ***********************/
	SecuritiesTransactionPrice14Choice__1 build();
	
	SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder toBuilder();
	
	static SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder builder() {
		return new SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SecuritiesTransactionPrice14Choice__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SecuritiesTransactionPrice14Choice__1> getType() {
		return SecuritiesTransactionPrice14Choice__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("rate"), BigDecimal.class, getRate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SecuritiesTransactionPrice14Choice__1Builder extends SecuritiesTransactionPrice14Choice__1, RosettaModelObjectBuilder {
		SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder setRate(BigDecimal rate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("rate"), BigDecimal.class, getRate(), this);
		}
		

		SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder prune();
	}

	/*********************** Immutable Implementation of SecuritiesTransactionPrice14Choice__1  ***********************/
	class SecuritiesTransactionPrice14Choice__1Impl implements SecuritiesTransactionPrice14Choice__1 {
		private final BigDecimal rate;
		
		protected SecuritiesTransactionPrice14Choice__1Impl(SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder builder) {
			this.rate = builder.getRate();
		}
		
		@Override
		@RosettaAttribute("rate")
		@RuneAttribute("rate")
		public BigDecimal getRate() {
			return rate;
		}
		
		@Override
		public SecuritiesTransactionPrice14Choice__1 build() {
			return this;
		}
		
		@Override
		public SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder toBuilder() {
			SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder builder) {
			ofNullable(getRate()).ifPresent(builder::setRate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SecuritiesTransactionPrice14Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(rate, _that.getRate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (rate != null ? rate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SecuritiesTransactionPrice14Choice__1 {" +
				"rate=" + this.rate +
			'}';
		}
	}

	/*********************** Builder Implementation of SecuritiesTransactionPrice14Choice__1  ***********************/
	class SecuritiesTransactionPrice14Choice__1BuilderImpl implements SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder {
	
		protected BigDecimal rate;
		
		@Override
		@RosettaAttribute("rate")
		@RuneAttribute("rate")
		public BigDecimal getRate() {
			return rate;
		}
		
		@Override
		@RosettaAttribute("rate")
		@RuneAttribute("rate")
		public SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder setRate(BigDecimal _rate) {
			this.rate = _rate == null ? null : _rate;
			return this;
		}
		
		@Override
		public SecuritiesTransactionPrice14Choice__1 build() {
			return new SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Impl(this);
		}
		
		@Override
		public SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getRate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder o = (SecuritiesTransactionPrice14Choice__1.SecuritiesTransactionPrice14Choice__1Builder) other;
			
			
			merger.mergeBasic(getRate(), o.getRate(), this::setRate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SecuritiesTransactionPrice14Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(rate, _that.getRate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (rate != null ? rate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SecuritiesTransactionPrice14Choice__1Builder {" +
				"rate=" + this.rate +
			'}';
		}
	}
}
