package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.AgriculturalCommodityOilSeed2__1;
import iso20022.auth030.fca.AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder;
import iso20022.auth030.fca.AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1BuilderImpl;
import iso20022.auth030.fca.AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Impl;
import iso20022.auth030.fca.AssetClassDetailedSubProductType1Code;
import iso20022.auth030.fca.AssetClassProductType1Code;
import iso20022.auth030.fca.AssetClassSubProductType1Code;
import iso20022.auth030.fca.meta.AgriculturalCommodityOilSeed2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an agricultural derivative of type oil seed.
 * @version ${project.version}
 */
@RosettaDataType(value="AgriculturalCommodityOilSeed2__1", builder=AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="AgriculturalCommodityOilSeed2__1", model="iso20022", builder=AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1BuilderImpl.class, version="${project.version}")
public interface AgriculturalCommodityOilSeed2__1 extends RosettaModelObject {

	AgriculturalCommodityOilSeed2__1Meta metaData = new AgriculturalCommodityOilSeed2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType1Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType1Code getSubPdct();
	/**
	 * Further subproduct type related to instruments that have a non-financial instrument or commodity as underlying.
	 */
	AssetClassDetailedSubProductType1Code getAddtlSubPdct();

	/*********************** Build Methods  ***********************/
	AgriculturalCommodityOilSeed2__1 build();
	
	AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder toBuilder();
	
	static AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder builder() {
		return new AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AgriculturalCommodityOilSeed2__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AgriculturalCommodityOilSeed2__1> getType() {
		return AgriculturalCommodityOilSeed2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType1Code.class, getSubPdct(), this);
		processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType1Code.class, getAddtlSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface AgriculturalCommodityOilSeed2__1Builder extends AgriculturalCommodityOilSeed2__1, RosettaModelObjectBuilder {
		AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder setBasePdct(AssetClassProductType1Code basePdct);
		AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder setSubPdct(AssetClassSubProductType1Code subPdct);
		AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder setAddtlSubPdct(AssetClassDetailedSubProductType1Code addtlSubPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType1Code.class, getSubPdct(), this);
			processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType1Code.class, getAddtlSubPdct(), this);
		}
		

		AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder prune();
	}

	/*********************** Immutable Implementation of AgriculturalCommodityOilSeed2__1  ***********************/
	class AgriculturalCommodityOilSeed2__1Impl implements AgriculturalCommodityOilSeed2__1 {
		private final AssetClassProductType1Code basePdct;
		private final AssetClassSubProductType1Code subPdct;
		private final AssetClassDetailedSubProductType1Code addtlSubPdct;
		
		protected AgriculturalCommodityOilSeed2__1Impl(AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
			this.addtlSubPdct = builder.getAddtlSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType1Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		@RuneAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType1Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		public AgriculturalCommodityOilSeed2__1 build() {
			return this;
		}
		
		@Override
		public AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder toBuilder() {
			AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
			ofNullable(getAddtlSubPdct()).ifPresent(builder::setAddtlSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityOilSeed2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityOilSeed2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of AgriculturalCommodityOilSeed2__1  ***********************/
	class AgriculturalCommodityOilSeed2__1BuilderImpl implements AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder {
	
		protected AssetClassProductType1Code basePdct;
		protected AssetClassSubProductType1Code subPdct;
		protected AssetClassDetailedSubProductType1Code addtlSubPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType1Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		@RuneAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType1Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder setBasePdct(AssetClassProductType1Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder setSubPdct(AssetClassSubProductType1Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		@RuneAttribute("addtlSubPdct")
		public AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder setAddtlSubPdct(AssetClassDetailedSubProductType1Code _addtlSubPdct) {
			this.addtlSubPdct = _addtlSubPdct == null ? null : _addtlSubPdct;
			return this;
		}
		
		@Override
		public AgriculturalCommodityOilSeed2__1 build() {
			return new AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Impl(this);
		}
		
		@Override
		public AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			if (getAddtlSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder o = (AgriculturalCommodityOilSeed2__1.AgriculturalCommodityOilSeed2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			merger.mergeBasic(getAddtlSubPdct(), o.getAddtlSubPdct(), this::setAddtlSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityOilSeed2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityOilSeed2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}
}
