package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.CommonTradeDataReport69__7;
import iso20022.auth030.fca.CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder;
import iso20022.auth030.fca.CommonTradeDataReport69__7.CommonTradeDataReport69__7BuilderImpl;
import iso20022.auth030.fca.CommonTradeDataReport69__7.CommonTradeDataReport69__7Impl;
import iso20022.auth030.fca.ContractType14__1;
import iso20022.auth030.fca.ContractType14__1.ContractType14__1Builder;
import iso20022.auth030.fca.TradeTransaction49__7;
import iso20022.auth030.fca.TradeTransaction49__7.TradeTransaction49__7Builder;
import iso20022.auth030.fca.meta.CommonTradeDataReport69__7Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Information related to contract and transaction details.
 * @version ${project.version}
 */
@RosettaDataType(value="CommonTradeDataReport69__7", builder=CommonTradeDataReport69__7.CommonTradeDataReport69__7BuilderImpl.class, version="${project.version}")
@RuneDataType(value="CommonTradeDataReport69__7", model="iso20022", builder=CommonTradeDataReport69__7.CommonTradeDataReport69__7BuilderImpl.class, version="${project.version}")
public interface CommonTradeDataReport69__7 extends RosettaModelObject {

	CommonTradeDataReport69__7Meta metaData = new CommonTradeDataReport69__7Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Data related to a trade contract.
	 */
	ContractType14__1 getCtrctData();
	/**
	 * Data related to a trade transaction.
	 */
	TradeTransaction49__7 getTxData();

	/*********************** Build Methods  ***********************/
	CommonTradeDataReport69__7 build();
	
	CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder toBuilder();
	
	static CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder builder() {
		return new CommonTradeDataReport69__7.CommonTradeDataReport69__7BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CommonTradeDataReport69__7> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CommonTradeDataReport69__7> getType() {
		return CommonTradeDataReport69__7.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("ctrctData"), processor, ContractType14__1.class, getCtrctData());
		processRosetta(path.newSubPath("txData"), processor, TradeTransaction49__7.class, getTxData());
	}
	

	/*********************** Builder Interface  ***********************/
	interface CommonTradeDataReport69__7Builder extends CommonTradeDataReport69__7, RosettaModelObjectBuilder {
		ContractType14__1.ContractType14__1Builder getOrCreateCtrctData();
		@Override
		ContractType14__1.ContractType14__1Builder getCtrctData();
		TradeTransaction49__7.TradeTransaction49__7Builder getOrCreateTxData();
		@Override
		TradeTransaction49__7.TradeTransaction49__7Builder getTxData();
		CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder setCtrctData(ContractType14__1 ctrctData);
		CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder setTxData(TradeTransaction49__7 txData);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("ctrctData"), processor, ContractType14__1.ContractType14__1Builder.class, getCtrctData());
			processRosetta(path.newSubPath("txData"), processor, TradeTransaction49__7.TradeTransaction49__7Builder.class, getTxData());
		}
		

		CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder prune();
	}

	/*********************** Immutable Implementation of CommonTradeDataReport69__7  ***********************/
	class CommonTradeDataReport69__7Impl implements CommonTradeDataReport69__7 {
		private final ContractType14__1 ctrctData;
		private final TradeTransaction49__7 txData;
		
		protected CommonTradeDataReport69__7Impl(CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder builder) {
			this.ctrctData = ofNullable(builder.getCtrctData()).map(f->f.build()).orElse(null);
			this.txData = ofNullable(builder.getTxData()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("ctrctData")
		@RuneAttribute("ctrctData")
		public ContractType14__1 getCtrctData() {
			return ctrctData;
		}
		
		@Override
		@RosettaAttribute("txData")
		@RuneAttribute("txData")
		public TradeTransaction49__7 getTxData() {
			return txData;
		}
		
		@Override
		public CommonTradeDataReport69__7 build() {
			return this;
		}
		
		@Override
		public CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder toBuilder() {
			CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder builder) {
			ofNullable(getCtrctData()).ifPresent(builder::setCtrctData);
			ofNullable(getTxData()).ifPresent(builder::setTxData);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTradeDataReport69__7 _that = getType().cast(o);
		
			if (!Objects.equals(ctrctData, _that.getCtrctData())) return false;
			if (!Objects.equals(txData, _that.getTxData())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrctData != null ? ctrctData.hashCode() : 0);
			_result = 31 * _result + (txData != null ? txData.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTradeDataReport69__7 {" +
				"ctrctData=" + this.ctrctData + ", " +
				"txData=" + this.txData +
			'}';
		}
	}

	/*********************** Builder Implementation of CommonTradeDataReport69__7  ***********************/
	class CommonTradeDataReport69__7BuilderImpl implements CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder {
	
		protected ContractType14__1.ContractType14__1Builder ctrctData;
		protected TradeTransaction49__7.TradeTransaction49__7Builder txData;
		
		@Override
		@RosettaAttribute("ctrctData")
		@RuneAttribute("ctrctData")
		public ContractType14__1.ContractType14__1Builder getCtrctData() {
			return ctrctData;
		}
		
		@Override
		public ContractType14__1.ContractType14__1Builder getOrCreateCtrctData() {
			ContractType14__1.ContractType14__1Builder result;
			if (ctrctData!=null) {
				result = ctrctData;
			}
			else {
				result = ctrctData = ContractType14__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("txData")
		@RuneAttribute("txData")
		public TradeTransaction49__7.TradeTransaction49__7Builder getTxData() {
			return txData;
		}
		
		@Override
		public TradeTransaction49__7.TradeTransaction49__7Builder getOrCreateTxData() {
			TradeTransaction49__7.TradeTransaction49__7Builder result;
			if (txData!=null) {
				result = txData;
			}
			else {
				result = txData = TradeTransaction49__7.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("ctrctData")
		@RuneAttribute("ctrctData")
		public CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder setCtrctData(ContractType14__1 _ctrctData) {
			this.ctrctData = _ctrctData == null ? null : _ctrctData.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("txData")
		@RuneAttribute("txData")
		public CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder setTxData(TradeTransaction49__7 _txData) {
			this.txData = _txData == null ? null : _txData.toBuilder();
			return this;
		}
		
		@Override
		public CommonTradeDataReport69__7 build() {
			return new CommonTradeDataReport69__7.CommonTradeDataReport69__7Impl(this);
		}
		
		@Override
		public CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder prune() {
			if (ctrctData!=null && !ctrctData.prune().hasData()) ctrctData = null;
			if (txData!=null && !txData.prune().hasData()) txData = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCtrctData()!=null && getCtrctData().hasData()) return true;
			if (getTxData()!=null && getTxData().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder o = (CommonTradeDataReport69__7.CommonTradeDataReport69__7Builder) other;
			
			merger.mergeRosetta(getCtrctData(), o.getCtrctData(), this::setCtrctData);
			merger.mergeRosetta(getTxData(), o.getTxData(), this::setTxData);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTradeDataReport69__7 _that = getType().cast(o);
		
			if (!Objects.equals(ctrctData, _that.getCtrctData())) return false;
			if (!Objects.equals(txData, _that.getTxData())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrctData != null ? ctrctData.hashCode() : 0);
			_result = 31 * _result + (txData != null ? txData.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTradeDataReport69__7Builder {" +
				"ctrctData=" + this.ctrctData + ", " +
				"txData=" + this.txData +
			'}';
		}
	}
}
