package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.GenericIdentification175__3;
import iso20022.auth030.fca.GenericIdentification175__3.GenericIdentification175__3Builder;
import iso20022.auth030.fca.UniqueTransactionIdentifier3Choice__1;
import iso20022.auth030.fca.UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder;
import iso20022.auth030.fca.UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1BuilderImpl;
import iso20022.auth030.fca.UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Impl;
import iso20022.auth030.fca.meta.UniqueTransactionIdentifier3Choice__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Element is a choice between a standard identifier and a proprietary code.
 * @version ${project.version}
 */
@RosettaDataType(value="UniqueTransactionIdentifier3Choice__1", builder=UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="UniqueTransactionIdentifier3Choice__1", model="iso20022", builder=UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1BuilderImpl.class, version="${project.version}")
public interface UniqueTransactionIdentifier3Choice__1 extends RosettaModelObject {

	UniqueTransactionIdentifier3Choice__1Meta metaData = new UniqueTransactionIdentifier3Choice__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Unique trade identifier (UTI) as agreed with the counterparty.
	 */
	String getUnqTxIdr();
	/**
	 * Trade identifier expressed in a proprietary notation.
	 */
	GenericIdentification175__3 getPrtry();

	/*********************** Build Methods  ***********************/
	UniqueTransactionIdentifier3Choice__1 build();
	
	UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder toBuilder();
	
	static UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder() {
		return new UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends UniqueTransactionIdentifier3Choice__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends UniqueTransactionIdentifier3Choice__1> getType() {
		return UniqueTransactionIdentifier3Choice__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("unqTxIdr"), String.class, getUnqTxIdr(), this);
		processRosetta(path.newSubPath("prtry"), processor, GenericIdentification175__3.class, getPrtry());
	}
	

	/*********************** Builder Interface  ***********************/
	interface UniqueTransactionIdentifier3Choice__1Builder extends UniqueTransactionIdentifier3Choice__1, RosettaModelObjectBuilder {
		GenericIdentification175__3.GenericIdentification175__3Builder getOrCreatePrtry();
		@Override
		GenericIdentification175__3.GenericIdentification175__3Builder getPrtry();
		UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setUnqTxIdr(String unqTxIdr);
		UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setPrtry(GenericIdentification175__3 prtry);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("unqTxIdr"), String.class, getUnqTxIdr(), this);
			processRosetta(path.newSubPath("prtry"), processor, GenericIdentification175__3.GenericIdentification175__3Builder.class, getPrtry());
		}
		

		UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder prune();
	}

	/*********************** Immutable Implementation of UniqueTransactionIdentifier3Choice__1  ***********************/
	class UniqueTransactionIdentifier3Choice__1Impl implements UniqueTransactionIdentifier3Choice__1 {
		private final String unqTxIdr;
		private final GenericIdentification175__3 prtry;
		
		protected UniqueTransactionIdentifier3Choice__1Impl(UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder) {
			this.unqTxIdr = builder.getUnqTxIdr();
			this.prtry = ofNullable(builder.getPrtry()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("unqTxIdr")
		@RuneAttribute("unqTxIdr")
		public String getUnqTxIdr() {
			return unqTxIdr;
		}
		
		@Override
		@RosettaAttribute("prtry")
		@RuneAttribute("prtry")
		public GenericIdentification175__3 getPrtry() {
			return prtry;
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1 build() {
			return this;
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder toBuilder() {
			UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder builder) {
			ofNullable(getUnqTxIdr()).ifPresent(builder::setUnqTxIdr);
			ofNullable(getPrtry()).ifPresent(builder::setPrtry);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UniqueTransactionIdentifier3Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(unqTxIdr, _that.getUnqTxIdr())) return false;
			if (!Objects.equals(prtry, _that.getPrtry())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (unqTxIdr != null ? unqTxIdr.hashCode() : 0);
			_result = 31 * _result + (prtry != null ? prtry.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UniqueTransactionIdentifier3Choice__1 {" +
				"unqTxIdr=" + this.unqTxIdr + ", " +
				"prtry=" + this.prtry +
			'}';
		}
	}

	/*********************** Builder Implementation of UniqueTransactionIdentifier3Choice__1  ***********************/
	class UniqueTransactionIdentifier3Choice__1BuilderImpl implements UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder {
	
		protected String unqTxIdr;
		protected GenericIdentification175__3.GenericIdentification175__3Builder prtry;
		
		@Override
		@RosettaAttribute("unqTxIdr")
		@RuneAttribute("unqTxIdr")
		public String getUnqTxIdr() {
			return unqTxIdr;
		}
		
		@Override
		@RosettaAttribute("prtry")
		@RuneAttribute("prtry")
		public GenericIdentification175__3.GenericIdentification175__3Builder getPrtry() {
			return prtry;
		}
		
		@Override
		public GenericIdentification175__3.GenericIdentification175__3Builder getOrCreatePrtry() {
			GenericIdentification175__3.GenericIdentification175__3Builder result;
			if (prtry!=null) {
				result = prtry;
			}
			else {
				result = prtry = GenericIdentification175__3.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("unqTxIdr")
		@RuneAttribute("unqTxIdr")
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setUnqTxIdr(String _unqTxIdr) {
			this.unqTxIdr = _unqTxIdr == null ? null : _unqTxIdr;
			return this;
		}
		
		@Override
		@RosettaAttribute("prtry")
		@RuneAttribute("prtry")
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder setPrtry(GenericIdentification175__3 _prtry) {
			this.prtry = _prtry == null ? null : _prtry.toBuilder();
			return this;
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1 build() {
			return new UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Impl(this);
		}
		
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder prune() {
			if (prtry!=null && !prtry.prune().hasData()) prtry = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUnqTxIdr()!=null) return true;
			if (getPrtry()!=null && getPrtry().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder o = (UniqueTransactionIdentifier3Choice__1.UniqueTransactionIdentifier3Choice__1Builder) other;
			
			merger.mergeRosetta(getPrtry(), o.getPrtry(), this::setPrtry);
			
			merger.mergeBasic(getUnqTxIdr(), o.getUnqTxIdr(), this::setUnqTxIdr);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UniqueTransactionIdentifier3Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(unqTxIdr, _that.getUnqTxIdr())) return false;
			if (!Objects.equals(prtry, _that.getPrtry())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (unqTxIdr != null ? unqTxIdr.hashCode() : 0);
			_result = 31 * _result + (prtry != null ? prtry.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UniqueTransactionIdentifier3Choice__1Builder {" +
				"unqTxIdr=" + this.unqTxIdr + ", " +
				"prtry=" + this.prtry +
			'}';
		}
	}
}
