package iso20022.auth030.fca.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.CurrencyExchange22__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class CurrencyExchange22__1TypeFormatValidator implements Validator<CurrencyExchange22__1> {

	private List<ComparisonResult> getComparisonResults(CurrencyExchange22__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("xchgRate", o.getXchgRate(), of(18), of(13), empty(), empty()), 
				checkNumber("fwdXchgRate", o.getFwdXchgRate(), of(18), of(13), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CurrencyExchange22__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CurrencyExchange22__1", ValidationType.TYPE_FORMAT, "CurrencyExchange22__1", path, "", res.getError());
				}
				return success("CurrencyExchange22__1", ValidationType.TYPE_FORMAT, "CurrencyExchange22__1", path, "");
			})
			.collect(toList());
	}

}
