package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.AgriculturalCommodityDairy2;
import iso20022.auth030.hkma.dtcc.AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder;
import iso20022.auth030.hkma.dtcc.AgriculturalCommodityDairy2.AgriculturalCommodityDairy2BuilderImpl;
import iso20022.auth030.hkma.dtcc.AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Impl;
import iso20022.auth030.hkma.dtcc.AssetClassProductType1Code;
import iso20022.auth030.hkma.dtcc.AssetClassSubProductType20Code;
import iso20022.auth030.hkma.dtcc.meta.AgriculturalCommodityDairy2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an agricultural derivative of type dairy.
 * @version ${project.version}
 */
@RosettaDataType(value="AgriculturalCommodityDairy2", builder=AgriculturalCommodityDairy2.AgriculturalCommodityDairy2BuilderImpl.class, version="${project.version}")
@RuneDataType(value="AgriculturalCommodityDairy2", model="iso20022", builder=AgriculturalCommodityDairy2.AgriculturalCommodityDairy2BuilderImpl.class, version="${project.version}")
public interface AgriculturalCommodityDairy2 extends RosettaModelObject {

	AgriculturalCommodityDairy2Meta metaData = new AgriculturalCommodityDairy2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType1Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType20Code getSubPdct();

	/*********************** Build Methods  ***********************/
	AgriculturalCommodityDairy2 build();
	
	AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder toBuilder();
	
	static AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder builder() {
		return new AgriculturalCommodityDairy2.AgriculturalCommodityDairy2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AgriculturalCommodityDairy2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AgriculturalCommodityDairy2> getType() {
		return AgriculturalCommodityDairy2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType20Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface AgriculturalCommodityDairy2Builder extends AgriculturalCommodityDairy2, RosettaModelObjectBuilder {
		AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder setBasePdct(AssetClassProductType1Code basePdct);
		AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder setSubPdct(AssetClassSubProductType20Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType20Code.class, getSubPdct(), this);
		}
		

		AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder prune();
	}

	/*********************** Immutable Implementation of AgriculturalCommodityDairy2  ***********************/
	class AgriculturalCommodityDairy2Impl implements AgriculturalCommodityDairy2 {
		private final AssetClassProductType1Code basePdct;
		private final AssetClassSubProductType20Code subPdct;
		
		protected AgriculturalCommodityDairy2Impl(AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType20Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public AgriculturalCommodityDairy2 build() {
			return this;
		}
		
		@Override
		public AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder toBuilder() {
			AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityDairy2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityDairy2 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of AgriculturalCommodityDairy2  ***********************/
	class AgriculturalCommodityDairy2BuilderImpl implements AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder {
	
		protected AssetClassProductType1Code basePdct;
		protected AssetClassSubProductType20Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType20Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder setBasePdct(AssetClassProductType1Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder setSubPdct(AssetClassSubProductType20Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public AgriculturalCommodityDairy2 build() {
			return new AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Impl(this);
		}
		
		@Override
		public AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder o = (AgriculturalCommodityDairy2.AgriculturalCommodityDairy2Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityDairy2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityDairy2Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
