package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.AssetClassProductType2Code;
import iso20022.auth030.hkma.dtcc.AssetClassSubProductType28Code;
import iso20022.auth030.hkma.dtcc.EnergyCommodityRenewableEnergy2;
import iso20022.auth030.hkma.dtcc.EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder;
import iso20022.auth030.hkma.dtcc.EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2BuilderImpl;
import iso20022.auth030.hkma.dtcc.EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Impl;
import iso20022.auth030.hkma.dtcc.meta.EnergyCommodityRenewableEnergy2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an energy derivative of type renewable energy.
 * @version ${project.version}
 */
@RosettaDataType(value="EnergyCommodityRenewableEnergy2", builder=EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2BuilderImpl.class, version="${project.version}")
@RuneDataType(value="EnergyCommodityRenewableEnergy2", model="iso20022", builder=EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2BuilderImpl.class, version="${project.version}")
public interface EnergyCommodityRenewableEnergy2 extends RosettaModelObject {

	EnergyCommodityRenewableEnergy2Meta metaData = new EnergyCommodityRenewableEnergy2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType2Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType28Code getSubPdct();

	/*********************** Build Methods  ***********************/
	EnergyCommodityRenewableEnergy2 build();
	
	EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder toBuilder();
	
	static EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder builder() {
		return new EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EnergyCommodityRenewableEnergy2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends EnergyCommodityRenewableEnergy2> getType() {
		return EnergyCommodityRenewableEnergy2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType28Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EnergyCommodityRenewableEnergy2Builder extends EnergyCommodityRenewableEnergy2, RosettaModelObjectBuilder {
		EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder setBasePdct(AssetClassProductType2Code basePdct);
		EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder setSubPdct(AssetClassSubProductType28Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType28Code.class, getSubPdct(), this);
		}
		

		EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder prune();
	}

	/*********************** Immutable Implementation of EnergyCommodityRenewableEnergy2  ***********************/
	class EnergyCommodityRenewableEnergy2Impl implements EnergyCommodityRenewableEnergy2 {
		private final AssetClassProductType2Code basePdct;
		private final AssetClassSubProductType28Code subPdct;
		
		protected EnergyCommodityRenewableEnergy2Impl(EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType28Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public EnergyCommodityRenewableEnergy2 build() {
			return this;
		}
		
		@Override
		public EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder toBuilder() {
			EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityRenewableEnergy2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityRenewableEnergy2 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of EnergyCommodityRenewableEnergy2  ***********************/
	class EnergyCommodityRenewableEnergy2BuilderImpl implements EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder {
	
		protected AssetClassProductType2Code basePdct;
		protected AssetClassSubProductType28Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType28Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder setBasePdct(AssetClassProductType2Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder setSubPdct(AssetClassSubProductType28Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public EnergyCommodityRenewableEnergy2 build() {
			return new EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Impl(this);
		}
		
		@Override
		public EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder o = (EnergyCommodityRenewableEnergy2.EnergyCommodityRenewableEnergy2Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityRenewableEnergy2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityRenewableEnergy2Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
