package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.AssetClassProductType3Code;
import iso20022.auth030.hkma.dtcc.AssetClassSubProductType30Code;
import iso20022.auth030.hkma.dtcc.EnvironmentalCommodityWeather2;
import iso20022.auth030.hkma.dtcc.EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder;
import iso20022.auth030.hkma.dtcc.EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2BuilderImpl;
import iso20022.auth030.hkma.dtcc.EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Impl;
import iso20022.auth030.hkma.dtcc.meta.EnvironmentalCommodityWeather2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an environmental derivative of type weather.
 * @version ${project.version}
 */
@RosettaDataType(value="EnvironmentalCommodityWeather2", builder=EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2BuilderImpl.class, version="${project.version}")
@RuneDataType(value="EnvironmentalCommodityWeather2", model="iso20022", builder=EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2BuilderImpl.class, version="${project.version}")
public interface EnvironmentalCommodityWeather2 extends RosettaModelObject {

	EnvironmentalCommodityWeather2Meta metaData = new EnvironmentalCommodityWeather2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType3Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType30Code getSubPdct();

	/*********************** Build Methods  ***********************/
	EnvironmentalCommodityWeather2 build();
	
	EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder toBuilder();
	
	static EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder builder() {
		return new EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EnvironmentalCommodityWeather2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends EnvironmentalCommodityWeather2> getType() {
		return EnvironmentalCommodityWeather2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType3Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType30Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EnvironmentalCommodityWeather2Builder extends EnvironmentalCommodityWeather2, RosettaModelObjectBuilder {
		EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder setBasePdct(AssetClassProductType3Code basePdct);
		EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder setSubPdct(AssetClassSubProductType30Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType3Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType30Code.class, getSubPdct(), this);
		}
		

		EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder prune();
	}

	/*********************** Immutable Implementation of EnvironmentalCommodityWeather2  ***********************/
	class EnvironmentalCommodityWeather2Impl implements EnvironmentalCommodityWeather2 {
		private final AssetClassProductType3Code basePdct;
		private final AssetClassSubProductType30Code subPdct;
		
		protected EnvironmentalCommodityWeather2Impl(EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType3Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType30Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public EnvironmentalCommodityWeather2 build() {
			return this;
		}
		
		@Override
		public EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder toBuilder() {
			EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnvironmentalCommodityWeather2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnvironmentalCommodityWeather2 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of EnvironmentalCommodityWeather2  ***********************/
	class EnvironmentalCommodityWeather2BuilderImpl implements EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder {
	
		protected AssetClassProductType3Code basePdct;
		protected AssetClassSubProductType30Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType3Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType30Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder setBasePdct(AssetClassProductType3Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder setSubPdct(AssetClassSubProductType30Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public EnvironmentalCommodityWeather2 build() {
			return new EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Impl(this);
		}
		
		@Override
		public EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder o = (EnvironmentalCommodityWeather2.EnvironmentalCommodityWeather2Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnvironmentalCommodityWeather2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnvironmentalCommodityWeather2Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
