package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.AmountAndDirection106__1;
import iso20022.auth030.hkma.dtcc.AmountAndDirection106__1.AmountAndDirection106__1Builder;
import iso20022.auth030.hkma.dtcc.SecuritiesTransactionPrice23Choice__1;
import iso20022.auth030.hkma.dtcc.SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder;
import iso20022.auth030.hkma.dtcc.SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1BuilderImpl;
import iso20022.auth030.hkma.dtcc.SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Impl;
import iso20022.auth030.hkma.dtcc.meta.SecuritiesTransactionPrice23Choice__1Meta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Choice to define the price of the securities transaction.
 * @version ${project.version}
 */
@RosettaDataType(value="SecuritiesTransactionPrice23Choice__1", builder=SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="SecuritiesTransactionPrice23Choice__1", model="iso20022", builder=SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1BuilderImpl.class, version="${project.version}")
public interface SecuritiesTransactionPrice23Choice__1 extends RosettaModelObject {

	SecuritiesTransactionPrice23Choice__1Meta metaData = new SecuritiesTransactionPrice23Choice__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Indicates that price is expressed as a monetary value.
	 */
	AmountAndDirection106__1 getMntryVal();
	BigDecimal getDcml();

	/*********************** Build Methods  ***********************/
	SecuritiesTransactionPrice23Choice__1 build();
	
	SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder toBuilder();
	
	static SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder builder() {
		return new SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SecuritiesTransactionPrice23Choice__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SecuritiesTransactionPrice23Choice__1> getType() {
		return SecuritiesTransactionPrice23Choice__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("mntryVal"), processor, AmountAndDirection106__1.class, getMntryVal());
		processor.processBasic(path.newSubPath("dcml"), BigDecimal.class, getDcml(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SecuritiesTransactionPrice23Choice__1Builder extends SecuritiesTransactionPrice23Choice__1, RosettaModelObjectBuilder {
		AmountAndDirection106__1.AmountAndDirection106__1Builder getOrCreateMntryVal();
		@Override
		AmountAndDirection106__1.AmountAndDirection106__1Builder getMntryVal();
		SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder setMntryVal(AmountAndDirection106__1 mntryVal);
		SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder setDcml(BigDecimal dcml);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("mntryVal"), processor, AmountAndDirection106__1.AmountAndDirection106__1Builder.class, getMntryVal());
			processor.processBasic(path.newSubPath("dcml"), BigDecimal.class, getDcml(), this);
		}
		

		SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder prune();
	}

	/*********************** Immutable Implementation of SecuritiesTransactionPrice23Choice__1  ***********************/
	class SecuritiesTransactionPrice23Choice__1Impl implements SecuritiesTransactionPrice23Choice__1 {
		private final AmountAndDirection106__1 mntryVal;
		private final BigDecimal dcml;
		
		protected SecuritiesTransactionPrice23Choice__1Impl(SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder builder) {
			this.mntryVal = ofNullable(builder.getMntryVal()).map(f->f.build()).orElse(null);
			this.dcml = builder.getDcml();
		}
		
		@Override
		@RosettaAttribute("mntryVal")
		@RuneAttribute("mntryVal")
		public AmountAndDirection106__1 getMntryVal() {
			return mntryVal;
		}
		
		@Override
		@RosettaAttribute("dcml")
		@RuneAttribute("dcml")
		public BigDecimal getDcml() {
			return dcml;
		}
		
		@Override
		public SecuritiesTransactionPrice23Choice__1 build() {
			return this;
		}
		
		@Override
		public SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder toBuilder() {
			SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder builder) {
			ofNullable(getMntryVal()).ifPresent(builder::setMntryVal);
			ofNullable(getDcml()).ifPresent(builder::setDcml);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SecuritiesTransactionPrice23Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(mntryVal, _that.getMntryVal())) return false;
			if (!Objects.equals(dcml, _that.getDcml())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (mntryVal != null ? mntryVal.hashCode() : 0);
			_result = 31 * _result + (dcml != null ? dcml.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SecuritiesTransactionPrice23Choice__1 {" +
				"mntryVal=" + this.mntryVal + ", " +
				"dcml=" + this.dcml +
			'}';
		}
	}

	/*********************** Builder Implementation of SecuritiesTransactionPrice23Choice__1  ***********************/
	class SecuritiesTransactionPrice23Choice__1BuilderImpl implements SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder {
	
		protected AmountAndDirection106__1.AmountAndDirection106__1Builder mntryVal;
		protected BigDecimal dcml;
		
		@Override
		@RosettaAttribute("mntryVal")
		@RuneAttribute("mntryVal")
		public AmountAndDirection106__1.AmountAndDirection106__1Builder getMntryVal() {
			return mntryVal;
		}
		
		@Override
		public AmountAndDirection106__1.AmountAndDirection106__1Builder getOrCreateMntryVal() {
			AmountAndDirection106__1.AmountAndDirection106__1Builder result;
			if (mntryVal!=null) {
				result = mntryVal;
			}
			else {
				result = mntryVal = AmountAndDirection106__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("dcml")
		@RuneAttribute("dcml")
		public BigDecimal getDcml() {
			return dcml;
		}
		
		@Override
		@RosettaAttribute("mntryVal")
		@RuneAttribute("mntryVal")
		public SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder setMntryVal(AmountAndDirection106__1 _mntryVal) {
			this.mntryVal = _mntryVal == null ? null : _mntryVal.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("dcml")
		@RuneAttribute("dcml")
		public SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder setDcml(BigDecimal _dcml) {
			this.dcml = _dcml == null ? null : _dcml;
			return this;
		}
		
		@Override
		public SecuritiesTransactionPrice23Choice__1 build() {
			return new SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Impl(this);
		}
		
		@Override
		public SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder prune() {
			if (mntryVal!=null && !mntryVal.prune().hasData()) mntryVal = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getMntryVal()!=null && getMntryVal().hasData()) return true;
			if (getDcml()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder o = (SecuritiesTransactionPrice23Choice__1.SecuritiesTransactionPrice23Choice__1Builder) other;
			
			merger.mergeRosetta(getMntryVal(), o.getMntryVal(), this::setMntryVal);
			
			merger.mergeBasic(getDcml(), o.getDcml(), this::setDcml);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SecuritiesTransactionPrice23Choice__1 _that = getType().cast(o);
		
			if (!Objects.equals(mntryVal, _that.getMntryVal())) return false;
			if (!Objects.equals(dcml, _that.getDcml())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (mntryVal != null ? mntryVal.hashCode() : 0);
			_result = 31 * _result + (dcml != null ? dcml.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SecuritiesTransactionPrice23Choice__1Builder {" +
				"mntryVal=" + this.mntryVal + ", " +
				"dcml=" + this.dcml +
			'}';
		}
	}
}
