package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.GenericIdentification175__2;
import iso20022.auth030.hkma.dtcc.OrganisationIdentification38__2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class OrganisationIdentification38__2Validator implements Validator<OrganisationIdentification38__2> {

	private List<ComparisonResult> getComparisonResults(OrganisationIdentification38__2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("id", (GenericIdentification175__2) o.getId() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, OrganisationIdentification38__2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("OrganisationIdentification38__2", ValidationType.CARDINALITY, "OrganisationIdentification38__2", path, "", res.getError());
				}
				return success("OrganisationIdentification38__2", ValidationType.CARDINALITY, "OrganisationIdentification38__2", path, "");
			})
			.collect(toList());
	}

}
