package iso20022.auth030.hkma.tr;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.tr.AssetClassProductType2Code;
import iso20022.auth030.hkma.tr.AssetClassSubProductType24Code;
import iso20022.auth030.hkma.tr.EnergyCommodityCoal2;
import iso20022.auth030.hkma.tr.EnergyCommodityCoal2.EnergyCommodityCoal2Builder;
import iso20022.auth030.hkma.tr.EnergyCommodityCoal2.EnergyCommodityCoal2BuilderImpl;
import iso20022.auth030.hkma.tr.EnergyCommodityCoal2.EnergyCommodityCoal2Impl;
import iso20022.auth030.hkma.tr.meta.EnergyCommodityCoal2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an energy derivative of type coal.
 * @version ${project.version}
 */
@RosettaDataType(value="EnergyCommodityCoal2", builder=EnergyCommodityCoal2.EnergyCommodityCoal2BuilderImpl.class, version="${project.version}")
@RuneDataType(value="EnergyCommodityCoal2", model="iso20022", builder=EnergyCommodityCoal2.EnergyCommodityCoal2BuilderImpl.class, version="${project.version}")
public interface EnergyCommodityCoal2 extends RosettaModelObject {

	EnergyCommodityCoal2Meta metaData = new EnergyCommodityCoal2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType2Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType24Code getSubPdct();

	/*********************** Build Methods  ***********************/
	EnergyCommodityCoal2 build();
	
	EnergyCommodityCoal2.EnergyCommodityCoal2Builder toBuilder();
	
	static EnergyCommodityCoal2.EnergyCommodityCoal2Builder builder() {
		return new EnergyCommodityCoal2.EnergyCommodityCoal2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EnergyCommodityCoal2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends EnergyCommodityCoal2> getType() {
		return EnergyCommodityCoal2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType24Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EnergyCommodityCoal2Builder extends EnergyCommodityCoal2, RosettaModelObjectBuilder {
		EnergyCommodityCoal2.EnergyCommodityCoal2Builder setBasePdct(AssetClassProductType2Code basePdct);
		EnergyCommodityCoal2.EnergyCommodityCoal2Builder setSubPdct(AssetClassSubProductType24Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType24Code.class, getSubPdct(), this);
		}
		

		EnergyCommodityCoal2.EnergyCommodityCoal2Builder prune();
	}

	/*********************** Immutable Implementation of EnergyCommodityCoal2  ***********************/
	class EnergyCommodityCoal2Impl implements EnergyCommodityCoal2 {
		private final AssetClassProductType2Code basePdct;
		private final AssetClassSubProductType24Code subPdct;
		
		protected EnergyCommodityCoal2Impl(EnergyCommodityCoal2.EnergyCommodityCoal2Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType24Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public EnergyCommodityCoal2 build() {
			return this;
		}
		
		@Override
		public EnergyCommodityCoal2.EnergyCommodityCoal2Builder toBuilder() {
			EnergyCommodityCoal2.EnergyCommodityCoal2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EnergyCommodityCoal2.EnergyCommodityCoal2Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityCoal2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityCoal2 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of EnergyCommodityCoal2  ***********************/
	class EnergyCommodityCoal2BuilderImpl implements EnergyCommodityCoal2.EnergyCommodityCoal2Builder {
	
		protected AssetClassProductType2Code basePdct;
		protected AssetClassSubProductType24Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType24Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public EnergyCommodityCoal2.EnergyCommodityCoal2Builder setBasePdct(AssetClassProductType2Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public EnergyCommodityCoal2.EnergyCommodityCoal2Builder setSubPdct(AssetClassSubProductType24Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public EnergyCommodityCoal2 build() {
			return new EnergyCommodityCoal2.EnergyCommodityCoal2Impl(this);
		}
		
		@Override
		public EnergyCommodityCoal2.EnergyCommodityCoal2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityCoal2.EnergyCommodityCoal2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityCoal2.EnergyCommodityCoal2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			EnergyCommodityCoal2.EnergyCommodityCoal2Builder o = (EnergyCommodityCoal2.EnergyCommodityCoal2Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityCoal2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityCoal2Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
