package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.Tranche3;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class Tranche3Validator implements Validator<Tranche3> {

	private List<ComparisonResult> getComparisonResults(Tranche3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("attchmntPt", (BigDecimal) o.getAttchmntPt() != null ? 1 : 0, 0, 1), 
				checkCardinality("dtchmntPt", (BigDecimal) o.getDtchmntPt() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Tranche3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Tranche3", ValidationType.CARDINALITY, "Tranche3", path, "", res.getError());
				}
				return success("Tranche3", ValidationType.CARDINALITY, "Tranche3", path, "");
			})
			.collect(toList());
	}

}
