package iso20022.auth030.mas;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder;
import iso20022.auth030.mas.AmountAndDirection106__2;
import iso20022.auth030.mas.AmountAndDirection106__2.AmountAndDirection106__2Builder;
import iso20022.auth030.mas.AmountAndDirection106__2.AmountAndDirection106__2BuilderImpl;
import iso20022.auth030.mas.AmountAndDirection106__2.AmountAndDirection106__2Impl;
import iso20022.auth030.mas.meta.AmountAndDirection106__2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="AmountAndDirection106__2", builder=AmountAndDirection106__2.AmountAndDirection106__2BuilderImpl.class, version="${project.version}")
@RuneDataType(value="AmountAndDirection106__2", model="iso20022", builder=AmountAndDirection106__2.AmountAndDirection106__2BuilderImpl.class, version="${project.version}")
public interface AmountAndDirection106__2 extends RosettaModelObject {

	AmountAndDirection106__2Meta metaData = new AmountAndDirection106__2Meta();

	/*********************** Getter Methods  ***********************/
	ActiveOrHistoricCurrencyAnd5DecimalAmount getAmt();
	Boolean getSgn();

	/*********************** Build Methods  ***********************/
	AmountAndDirection106__2 build();
	
	AmountAndDirection106__2.AmountAndDirection106__2Builder toBuilder();
	
	static AmountAndDirection106__2.AmountAndDirection106__2Builder builder() {
		return new AmountAndDirection106__2.AmountAndDirection106__2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AmountAndDirection106__2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AmountAndDirection106__2> getType() {
		return AmountAndDirection106__2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("amt"), processor, ActiveOrHistoricCurrencyAnd5DecimalAmount.class, getAmt());
		processor.processBasic(path.newSubPath("sgn"), Boolean.class, getSgn(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface AmountAndDirection106__2Builder extends AmountAndDirection106__2, RosettaModelObjectBuilder {
		ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getOrCreateAmt();
		@Override
		ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getAmt();
		AmountAndDirection106__2.AmountAndDirection106__2Builder setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount amt);
		AmountAndDirection106__2.AmountAndDirection106__2Builder setSgn(Boolean sgn);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("amt"), processor, ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder.class, getAmt());
			processor.processBasic(path.newSubPath("sgn"), Boolean.class, getSgn(), this);
		}
		

		AmountAndDirection106__2.AmountAndDirection106__2Builder prune();
	}

	/*********************** Immutable Implementation of AmountAndDirection106__2  ***********************/
	class AmountAndDirection106__2Impl implements AmountAndDirection106__2 {
		private final ActiveOrHistoricCurrencyAnd5DecimalAmount amt;
		private final Boolean sgn;
		
		protected AmountAndDirection106__2Impl(AmountAndDirection106__2.AmountAndDirection106__2Builder builder) {
			this.amt = ofNullable(builder.getAmt()).map(f->f.build()).orElse(null);
			this.sgn = builder.getSgn();
		}
		
		@Override
		@RosettaAttribute("amt")
		@RuneAttribute("amt")
		public ActiveOrHistoricCurrencyAnd5DecimalAmount getAmt() {
			return amt;
		}
		
		@Override
		@RosettaAttribute("sgn")
		@RuneAttribute("sgn")
		public Boolean getSgn() {
			return sgn;
		}
		
		@Override
		public AmountAndDirection106__2 build() {
			return this;
		}
		
		@Override
		public AmountAndDirection106__2.AmountAndDirection106__2Builder toBuilder() {
			AmountAndDirection106__2.AmountAndDirection106__2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AmountAndDirection106__2.AmountAndDirection106__2Builder builder) {
			ofNullable(getAmt()).ifPresent(builder::setAmt);
			ofNullable(getSgn()).ifPresent(builder::setSgn);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AmountAndDirection106__2 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			if (!Objects.equals(sgn, _that.getSgn())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			_result = 31 * _result + (sgn != null ? sgn.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AmountAndDirection106__2 {" +
				"amt=" + this.amt + ", " +
				"sgn=" + this.sgn +
			'}';
		}
	}

	/*********************** Builder Implementation of AmountAndDirection106__2  ***********************/
	class AmountAndDirection106__2BuilderImpl implements AmountAndDirection106__2.AmountAndDirection106__2Builder {
	
		protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder amt;
		protected Boolean sgn;
		
		@Override
		@RosettaAttribute("amt")
		@RuneAttribute("amt")
		public ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getAmt() {
			return amt;
		}
		
		@Override
		public ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getOrCreateAmt() {
			ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder result;
			if (amt!=null) {
				result = amt;
			}
			else {
				result = amt = ActiveOrHistoricCurrencyAnd5DecimalAmount.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("sgn")
		@RuneAttribute("sgn")
		public Boolean getSgn() {
			return sgn;
		}
		
		@Override
		@RosettaAttribute("amt")
		@RuneAttribute("amt")
		public AmountAndDirection106__2.AmountAndDirection106__2Builder setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount _amt) {
			this.amt = _amt == null ? null : _amt.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("sgn")
		@RuneAttribute("sgn")
		public AmountAndDirection106__2.AmountAndDirection106__2Builder setSgn(Boolean _sgn) {
			this.sgn = _sgn == null ? null : _sgn;
			return this;
		}
		
		@Override
		public AmountAndDirection106__2 build() {
			return new AmountAndDirection106__2.AmountAndDirection106__2Impl(this);
		}
		
		@Override
		public AmountAndDirection106__2.AmountAndDirection106__2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AmountAndDirection106__2.AmountAndDirection106__2Builder prune() {
			if (amt!=null && !amt.prune().hasData()) amt = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAmt()!=null && getAmt().hasData()) return true;
			if (getSgn()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AmountAndDirection106__2.AmountAndDirection106__2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AmountAndDirection106__2.AmountAndDirection106__2Builder o = (AmountAndDirection106__2.AmountAndDirection106__2Builder) other;
			
			merger.mergeRosetta(getAmt(), o.getAmt(), this::setAmt);
			
			merger.mergeBasic(getSgn(), o.getSgn(), this::setSgn);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AmountAndDirection106__2 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			if (!Objects.equals(sgn, _that.getSgn())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			_result = 31 * _result + (sgn != null ? sgn.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AmountAndDirection106__2Builder {" +
				"amt=" + this.amt + ", " +
				"sgn=" + this.sgn +
			'}';
		}
	}
}
