package iso20022.auth108.fca.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.fca.CollateralPortfolioCode5Choice__1;
import iso20022.auth108.fca.CollateralisationType3Code__1;
import iso20022.auth108.fca.MarginCollateralReport4__1;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class MarginCollateralReport4__1Validator implements Validator<MarginCollateralReport4__1> {

	private List<ComparisonResult> getComparisonResults(MarginCollateralReport4__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("collPrtflCd", (CollateralPortfolioCode5Choice__1) o.getCollPrtflCd() != null ? 1 : 0, 1, 1), 
				checkCardinality("collstnCtgy", (CollateralisationType3Code__1) o.getCollstnCtgy() != null ? 1 : 0, 1, 1), 
				checkCardinality("tmStmp", (ZonedDateTime) o.getTmStmp() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MarginCollateralReport4__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MarginCollateralReport4__1", ValidationType.CARDINALITY, "MarginCollateralReport4__1", path, "", res.getError());
				}
				return success("MarginCollateralReport4__1", ValidationType.CARDINALITY, "MarginCollateralReport4__1", path, "");
			})
			.collect(toList());
	}

}
