package iso20022.dtcc.rds.harmonized;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import iso20022.dtcc.rds.harmonized.Core;
import iso20022.dtcc.rds.harmonized.Core.CoreBuilder;
import iso20022.dtcc.rds.harmonized.DataResponse;
import iso20022.dtcc.rds.harmonized.DataResponse.DataResponseBuilder;
import iso20022.dtcc.rds.harmonized.DataResponse.DataResponseBuilderImpl;
import iso20022.dtcc.rds.harmonized.DataResponse.DataResponseImpl;
import iso20022.dtcc.rds.harmonized.Error;
import iso20022.dtcc.rds.harmonized.Error.ErrorBuilder;
import iso20022.dtcc.rds.harmonized.GenericAttribute;
import iso20022.dtcc.rds.harmonized.GenericAttribute.GenericAttributeBuilder;
import iso20022.dtcc.rds.harmonized.Header;
import iso20022.dtcc.rds.harmonized.Header.HeaderBuilder;
import iso20022.dtcc.rds.harmonized.SubmissionWrapper;
import iso20022.dtcc.rds.harmonized.SubmissionWrapper.SubmissionWrapperBuilder;
import iso20022.dtcc.rds.harmonized.meta.DataResponseMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="DataResponse", builder=DataResponse.DataResponseBuilderImpl.class, version="${project.version}")
@RuneDataType(value="DataResponse", model="iso20022", builder=DataResponse.DataResponseBuilderImpl.class, version="${project.version}")
public interface DataResponse extends RosettaModelObject {

	DataResponseMeta metaData = new DataResponseMeta();

	/*********************** Getter Methods  ***********************/
	Header getHeader();
	List<? extends GenericAttribute> getSubmissionValidationStatus();
	Core getCore();
	List<? extends Error> getError();
	SubmissionWrapper getOriginalSubmission();

	/*********************** Build Methods  ***********************/
	DataResponse build();
	
	DataResponse.DataResponseBuilder toBuilder();
	
	static DataResponse.DataResponseBuilder builder() {
		return new DataResponse.DataResponseBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends DataResponse> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends DataResponse> getType() {
		return DataResponse.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("header"), processor, Header.class, getHeader());
		processRosetta(path.newSubPath("submissionValidationStatus"), processor, GenericAttribute.class, getSubmissionValidationStatus());
		processRosetta(path.newSubPath("core"), processor, Core.class, getCore());
		processRosetta(path.newSubPath("error"), processor, Error.class, getError());
		processRosetta(path.newSubPath("originalSubmission"), processor, SubmissionWrapper.class, getOriginalSubmission());
	}
	

	/*********************** Builder Interface  ***********************/
	interface DataResponseBuilder extends DataResponse, RosettaModelObjectBuilder {
		Header.HeaderBuilder getOrCreateHeader();
		@Override
		Header.HeaderBuilder getHeader();
		GenericAttribute.GenericAttributeBuilder getOrCreateSubmissionValidationStatus(int _index);
		@Override
		List<? extends GenericAttribute.GenericAttributeBuilder> getSubmissionValidationStatus();
		Core.CoreBuilder getOrCreateCore();
		@Override
		Core.CoreBuilder getCore();
		Error.ErrorBuilder getOrCreateError(int _index);
		@Override
		List<? extends Error.ErrorBuilder> getError();
		SubmissionWrapper.SubmissionWrapperBuilder getOrCreateOriginalSubmission();
		@Override
		SubmissionWrapper.SubmissionWrapperBuilder getOriginalSubmission();
		DataResponse.DataResponseBuilder setHeader(Header header);
		DataResponse.DataResponseBuilder addSubmissionValidationStatus(GenericAttribute submissionValidationStatus);
		DataResponse.DataResponseBuilder addSubmissionValidationStatus(GenericAttribute submissionValidationStatus, int _idx);
		DataResponse.DataResponseBuilder addSubmissionValidationStatus(List<? extends GenericAttribute> submissionValidationStatus);
		DataResponse.DataResponseBuilder setSubmissionValidationStatus(List<? extends GenericAttribute> submissionValidationStatus);
		DataResponse.DataResponseBuilder setCore(Core core);
		DataResponse.DataResponseBuilder addError(Error error);
		DataResponse.DataResponseBuilder addError(Error error, int _idx);
		DataResponse.DataResponseBuilder addError(List<? extends Error> error);
		DataResponse.DataResponseBuilder setError(List<? extends Error> error);
		DataResponse.DataResponseBuilder setOriginalSubmission(SubmissionWrapper originalSubmission);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("header"), processor, Header.HeaderBuilder.class, getHeader());
			processRosetta(path.newSubPath("submissionValidationStatus"), processor, GenericAttribute.GenericAttributeBuilder.class, getSubmissionValidationStatus());
			processRosetta(path.newSubPath("core"), processor, Core.CoreBuilder.class, getCore());
			processRosetta(path.newSubPath("error"), processor, Error.ErrorBuilder.class, getError());
			processRosetta(path.newSubPath("originalSubmission"), processor, SubmissionWrapper.SubmissionWrapperBuilder.class, getOriginalSubmission());
		}
		

		DataResponse.DataResponseBuilder prune();
	}

	/*********************** Immutable Implementation of DataResponse  ***********************/
	class DataResponseImpl implements DataResponse {
		private final Header header;
		private final List<? extends GenericAttribute> submissionValidationStatus;
		private final Core core;
		private final List<? extends Error> error;
		private final SubmissionWrapper originalSubmission;
		
		protected DataResponseImpl(DataResponse.DataResponseBuilder builder) {
			this.header = ofNullable(builder.getHeader()).map(f->f.build()).orElse(null);
			this.submissionValidationStatus = ofNullable(builder.getSubmissionValidationStatus()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.core = ofNullable(builder.getCore()).map(f->f.build()).orElse(null);
			this.error = ofNullable(builder.getError()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.originalSubmission = ofNullable(builder.getOriginalSubmission()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("header")
		@RuneAttribute("header")
		public Header getHeader() {
			return header;
		}
		
		@Override
		@RosettaAttribute("submissionValidationStatus")
		@RuneAttribute("submissionValidationStatus")
		public List<? extends GenericAttribute> getSubmissionValidationStatus() {
			return submissionValidationStatus;
		}
		
		@Override
		@RosettaAttribute("core")
		@RuneAttribute("core")
		public Core getCore() {
			return core;
		}
		
		@Override
		@RosettaAttribute("error")
		@RuneAttribute("error")
		public List<? extends Error> getError() {
			return error;
		}
		
		@Override
		@RosettaAttribute("originalSubmission")
		@RuneAttribute("originalSubmission")
		public SubmissionWrapper getOriginalSubmission() {
			return originalSubmission;
		}
		
		@Override
		public DataResponse build() {
			return this;
		}
		
		@Override
		public DataResponse.DataResponseBuilder toBuilder() {
			DataResponse.DataResponseBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(DataResponse.DataResponseBuilder builder) {
			ofNullable(getHeader()).ifPresent(builder::setHeader);
			ofNullable(getSubmissionValidationStatus()).ifPresent(builder::setSubmissionValidationStatus);
			ofNullable(getCore()).ifPresent(builder::setCore);
			ofNullable(getError()).ifPresent(builder::setError);
			ofNullable(getOriginalSubmission()).ifPresent(builder::setOriginalSubmission);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DataResponse _that = getType().cast(o);
		
			if (!Objects.equals(header, _that.getHeader())) return false;
			if (!ListEquals.listEquals(submissionValidationStatus, _that.getSubmissionValidationStatus())) return false;
			if (!Objects.equals(core, _that.getCore())) return false;
			if (!ListEquals.listEquals(error, _that.getError())) return false;
			if (!Objects.equals(originalSubmission, _that.getOriginalSubmission())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (header != null ? header.hashCode() : 0);
			_result = 31 * _result + (submissionValidationStatus != null ? submissionValidationStatus.hashCode() : 0);
			_result = 31 * _result + (core != null ? core.hashCode() : 0);
			_result = 31 * _result + (error != null ? error.hashCode() : 0);
			_result = 31 * _result + (originalSubmission != null ? originalSubmission.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DataResponse {" +
				"header=" + this.header + ", " +
				"submissionValidationStatus=" + this.submissionValidationStatus + ", " +
				"core=" + this.core + ", " +
				"error=" + this.error + ", " +
				"originalSubmission=" + this.originalSubmission +
			'}';
		}
	}

	/*********************** Builder Implementation of DataResponse  ***********************/
	class DataResponseBuilderImpl implements DataResponse.DataResponseBuilder {
	
		protected Header.HeaderBuilder header;
		protected List<GenericAttribute.GenericAttributeBuilder> submissionValidationStatus = new ArrayList<>();
		protected Core.CoreBuilder core;
		protected List<Error.ErrorBuilder> error = new ArrayList<>();
		protected SubmissionWrapper.SubmissionWrapperBuilder originalSubmission;
		
		@Override
		@RosettaAttribute("header")
		@RuneAttribute("header")
		public Header.HeaderBuilder getHeader() {
			return header;
		}
		
		@Override
		public Header.HeaderBuilder getOrCreateHeader() {
			Header.HeaderBuilder result;
			if (header!=null) {
				result = header;
			}
			else {
				result = header = Header.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("submissionValidationStatus")
		@RuneAttribute("submissionValidationStatus")
		public List<? extends GenericAttribute.GenericAttributeBuilder> getSubmissionValidationStatus() {
			return submissionValidationStatus;
		}
		
		@Override
		public GenericAttribute.GenericAttributeBuilder getOrCreateSubmissionValidationStatus(int _index) {
		
			if (submissionValidationStatus==null) {
				this.submissionValidationStatus = new ArrayList<>();
			}
			GenericAttribute.GenericAttributeBuilder result;
			return getIndex(submissionValidationStatus, _index, () -> {
						GenericAttribute.GenericAttributeBuilder newSubmissionValidationStatus = GenericAttribute.builder();
						return newSubmissionValidationStatus;
					});
		}
		
		@Override
		@RosettaAttribute("core")
		@RuneAttribute("core")
		public Core.CoreBuilder getCore() {
			return core;
		}
		
		@Override
		public Core.CoreBuilder getOrCreateCore() {
			Core.CoreBuilder result;
			if (core!=null) {
				result = core;
			}
			else {
				result = core = Core.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("error")
		@RuneAttribute("error")
		public List<? extends Error.ErrorBuilder> getError() {
			return error;
		}
		
		@Override
		public Error.ErrorBuilder getOrCreateError(int _index) {
		
			if (error==null) {
				this.error = new ArrayList<>();
			}
			Error.ErrorBuilder result;
			return getIndex(error, _index, () -> {
						Error.ErrorBuilder newError = Error.builder();
						return newError;
					});
		}
		
		@Override
		@RosettaAttribute("originalSubmission")
		@RuneAttribute("originalSubmission")
		public SubmissionWrapper.SubmissionWrapperBuilder getOriginalSubmission() {
			return originalSubmission;
		}
		
		@Override
		public SubmissionWrapper.SubmissionWrapperBuilder getOrCreateOriginalSubmission() {
			SubmissionWrapper.SubmissionWrapperBuilder result;
			if (originalSubmission!=null) {
				result = originalSubmission;
			}
			else {
				result = originalSubmission = SubmissionWrapper.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("header")
		@RuneAttribute("header")
		public DataResponse.DataResponseBuilder setHeader(Header _header) {
			this.header = _header == null ? null : _header.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("submissionValidationStatus")
		@RuneAttribute("submissionValidationStatus")
		public DataResponse.DataResponseBuilder addSubmissionValidationStatus(GenericAttribute _submissionValidationStatus) {
			if (_submissionValidationStatus != null) {
				this.submissionValidationStatus.add(_submissionValidationStatus.toBuilder());
			}
			return this;
		}
		
		@Override
		public DataResponse.DataResponseBuilder addSubmissionValidationStatus(GenericAttribute _submissionValidationStatus, int _idx) {
			getIndex(this.submissionValidationStatus, _idx, () -> _submissionValidationStatus.toBuilder());
			return this;
		}
		
		@Override 
		public DataResponse.DataResponseBuilder addSubmissionValidationStatus(List<? extends GenericAttribute> submissionValidationStatuss) {
			if (submissionValidationStatuss != null) {
				for (final GenericAttribute toAdd : submissionValidationStatuss) {
					this.submissionValidationStatus.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("submissionValidationStatus")
		public DataResponse.DataResponseBuilder setSubmissionValidationStatus(List<? extends GenericAttribute> submissionValidationStatuss) {
			if (submissionValidationStatuss == null) {
				this.submissionValidationStatus = new ArrayList<>();
			} else {
				this.submissionValidationStatus = submissionValidationStatuss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("core")
		@RuneAttribute("core")
		public DataResponse.DataResponseBuilder setCore(Core _core) {
			this.core = _core == null ? null : _core.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("error")
		@RuneAttribute("error")
		public DataResponse.DataResponseBuilder addError(Error _error) {
			if (_error != null) {
				this.error.add(_error.toBuilder());
			}
			return this;
		}
		
		@Override
		public DataResponse.DataResponseBuilder addError(Error _error, int _idx) {
			getIndex(this.error, _idx, () -> _error.toBuilder());
			return this;
		}
		
		@Override 
		public DataResponse.DataResponseBuilder addError(List<? extends Error> errors) {
			if (errors != null) {
				for (final Error toAdd : errors) {
					this.error.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("error")
		public DataResponse.DataResponseBuilder setError(List<? extends Error> errors) {
			if (errors == null) {
				this.error = new ArrayList<>();
			} else {
				this.error = errors.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSubmission")
		@RuneAttribute("originalSubmission")
		public DataResponse.DataResponseBuilder setOriginalSubmission(SubmissionWrapper _originalSubmission) {
			this.originalSubmission = _originalSubmission == null ? null : _originalSubmission.toBuilder();
			return this;
		}
		
		@Override
		public DataResponse build() {
			return new DataResponse.DataResponseImpl(this);
		}
		
		@Override
		public DataResponse.DataResponseBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DataResponse.DataResponseBuilder prune() {
			if (header!=null && !header.prune().hasData()) header = null;
			submissionValidationStatus = submissionValidationStatus.stream().filter(b->b!=null).<GenericAttribute.GenericAttributeBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (core!=null && !core.prune().hasData()) core = null;
			error = error.stream().filter(b->b!=null).<Error.ErrorBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (originalSubmission!=null && !originalSubmission.prune().hasData()) originalSubmission = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getHeader()!=null && getHeader().hasData()) return true;
			if (getSubmissionValidationStatus()!=null && getSubmissionValidationStatus().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getCore()!=null && getCore().hasData()) return true;
			if (getError()!=null && getError().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getOriginalSubmission()!=null && getOriginalSubmission().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DataResponse.DataResponseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			DataResponse.DataResponseBuilder o = (DataResponse.DataResponseBuilder) other;
			
			merger.mergeRosetta(getHeader(), o.getHeader(), this::setHeader);
			merger.mergeRosetta(getSubmissionValidationStatus(), o.getSubmissionValidationStatus(), this::getOrCreateSubmissionValidationStatus);
			merger.mergeRosetta(getCore(), o.getCore(), this::setCore);
			merger.mergeRosetta(getError(), o.getError(), this::getOrCreateError);
			merger.mergeRosetta(getOriginalSubmission(), o.getOriginalSubmission(), this::setOriginalSubmission);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DataResponse _that = getType().cast(o);
		
			if (!Objects.equals(header, _that.getHeader())) return false;
			if (!ListEquals.listEquals(submissionValidationStatus, _that.getSubmissionValidationStatus())) return false;
			if (!Objects.equals(core, _that.getCore())) return false;
			if (!ListEquals.listEquals(error, _that.getError())) return false;
			if (!Objects.equals(originalSubmission, _that.getOriginalSubmission())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (header != null ? header.hashCode() : 0);
			_result = 31 * _result + (submissionValidationStatus != null ? submissionValidationStatus.hashCode() : 0);
			_result = 31 * _result + (core != null ? core.hashCode() : 0);
			_result = 31 * _result + (error != null ? error.hashCode() : 0);
			_result = 31 * _result + (originalSubmission != null ? originalSubmission.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DataResponseBuilder {" +
				"header=" + this.header + ", " +
				"submissionValidationStatus=" + this.submissionValidationStatus + ", " +
				"core=" + this.core + ", " +
				"error=" + this.error + ", " +
				"originalSubmission=" + this.originalSubmission +
			'}';
		}
	}
}
