package iso20022.dtcc.rds.harmonized;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import iso20022.dtcc.rds.harmonized.HarmonizedData.HarmonizedDataBuilder;
import iso20022.dtcc.rds.harmonized.HarmonizedData.HarmonizedDataBuilderImpl;
import iso20022.dtcc.rds.harmonized.HarmonizedData.HarmonizedDataImpl;
import iso20022.dtcc.rds.harmonized.meta.HarmonizedDataMeta;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="HarmonizedData", builder=HarmonizedData.HarmonizedDataBuilderImpl.class, version="${project.version}")
@RuneDataType(value="HarmonizedData", model="iso20022", builder=HarmonizedData.HarmonizedDataBuilderImpl.class, version="${project.version}")
public interface HarmonizedData extends RosettaModelObject {

	HarmonizedDataMeta metaData = new HarmonizedDataMeta();

	/*********************** Getter Methods  ***********************/
	String getLeg2CommodityInstrumentId();
	String getLeg2CommodityUnderlyerId();
	String getLeg2CommodityUnderlyerDetails();
	String getLeg2CommodityUnitOfMeasure();
	String getLeg2CommodityCurrency();
	String getLeg2CommodityExchangeId();
	String getLeg1CommodityRateSource();
	String getLeg1CommodityRateSourcePage();
	String getLeg2SpecifiedPrice();
	Date getCommencementDateUnadjusted();
	Date getExerciseExpirationDateUnadjusted();
	Date getExpirationDateUnadjusted();
	String getLeg2NotionalQuantityFrequency();
	BigDecimal getLeg2NotionalQuantity();
	BigDecimal getLeg2TotalNotionalQuantity();
	BigDecimal getLeg2SpreadAmount();
	String getLeg2SpreadCurrency();
	Date getScheduledTerminationDateAdjusted();
	String getLeg1PartyPayer();
	String getLeg2PartyPayer();
	String getLeg1CommodityInstrumentId();
	String getLeg1CommodityUnderlyerId();
	String getLeg1CommodityUnitOfMeasure();
	String getLeg1CommodityExchangeId();
	String getLeg2CommodityRateSource();
	Date getLeg1EffectiveDateUnadjusted();
	Date getLeg2EffectiveDateUnadjusted();
	String getCoProductType();
	String getTotalQuantityUnit();
	BigDecimal getTotalQuantity();
	BigDecimal getFixedPrice();
	String getFixedPriceCurrency();
	String getLeg1NotionalQuantityUnit();
	String getLeg1NotionalQuantityFrequency();
	BigDecimal getLeg1NotionalQuantity();
	BigDecimal getLeg1TotalNotionalQuantity();
	String getLeg1CommodityCurrency();
	String getLeg1SpecifiedPrice();
	String getLeg1SpreadCurrency();
	BigDecimal getLeg1SpreadAmount();
	String getLeg2NotionalQuantityUnit();
	String getLeg2PartyReceiver();
	String getLeg1PartyReceiver();
	String getCoalSource();
	BigDecimal getLeg2Quantity();
	String getCommodityBase();
	String getCommodityDetails();
	String getInterconnectionPoint();
	String getLoadType();
	String getFixedPriceUnit();
	Date getExercisePaymentDateUnadjusted();
	Date getLeg1PaymentDatesUnadjusted();
	Date getLeg2PaymentDateUnadjusted();
	Date getSettlementDateUnadjusted();
	String getDeliveryLocation();
	String getLeg2QuantityUnit();
	String getLeg1CommodityUnderlyerDetails();
	String getLeg2CommodityRateSourcePage();
	Date getValueDate();
	String getGtrQuantityUnit();
	BigDecimal getAttachmentPoint();
	BigDecimal getExhaustionPoint();
	BigDecimal getMthToDefault();
	BigDecimal getNthToDefault();
	String getSeniority();
	BigDecimal getSeries();
	BigDecimal getCrversion();
	String getTranche();
	BigDecimal getIndexFactor();
	String getReferenceObligation();
	String getReferenceObligationIdType();
	String getUnderlyingFixedRatePayerBuyer();
	String getUnderlyingFloatRatePayerSeller();
	String getUnderlyingAssetExchangeId();
	BigDecimal getUnderlyingAssetNumberOfUnits();
	String getOptionalEarlyTerminationType();
	String getOptionalEarlyTerminationElectingPartyValue();
	Boolean getOptionalEarlyTerminationIndicator();
	String getUnderlyingAssetFloatingAmountPayer();
	String getUnderlyingAssetFloatingAmountReceiver();
	String getFloatingRateOption();
	BigDecimal getUnderlyingAssetFloatingLegSpread();
	String getLeg2DesignatedMaturityPeriod();
	BigDecimal getLeg2DesignatedMaturityPeriodMultiplier();
	String getUnderlyingAssetEquityAmountPayer();
	String getUnderlyingAssetEquityAmountReceiver();
	String getUnderlyingAssetInitialPriceCurrency();
	Date getLeg1ValuationDates();
	String getLeg1TypeOfReturn();
	Date getObservationStartDate();
	BigDecimal getVarianceAmount();
	BigDecimal getVolatilityStrikePrice();
	BigDecimal getVarianceStrikePrice();
	BigDecimal getVarianceCapFactor();
	String getReferenceCurrency();
	String getSpecialDividendsIndicator();
	String getMaterialNoncashDividendIndicator();
	BigDecimal getNumberOfSharesUnits();
	String getDividendAmountPayer();
	String getDividendAmountReceiver();
	String getFixedAmountPayer();
	String getFixedAmountReceiver();
	String getKnockInEvent();
	String getKnockOutEvent();
	BigDecimal getKnockInPrice();
	BigDecimal getKnockOutPrice();
	String getBarrierType();
	LocalTime getEarliestExecutionTime();
	BigDecimal getExchangeRate();
	String getExchangeRateBasisCurrency1();
	String getExchangeRateBasisCurrency2();
	Date getExecutionPeriodStartDate();
	String getPayoutStyle();
	String getRateQuoteBasis1();
	Date getSettlementFixingDate();
	String getSwapLinkId();
	String getTriggerCondition();
	String getTriggerCondition2();
	BigDecimal getTriggerRate();
	BigDecimal getTriggerRate2();
	String getRateQuoteBasis2();
	BigDecimal getForwardExchangeRate();
	String getBarrierType2();
	String getCancelationOptionBuyer();
	Date getCancelationOptionCommencementDate();
	String getCancelationOptionExerciseStyleType();
	Date getCancelationOptionExpirationDate();
	String getCancelationOptionInitialFeeCurrency();
	String getCancelationOptionInitialFeePayer();
	BigDecimal getCancelationOptionPremiumAmount();
	String getCancelationOptionSeller();
	BigDecimal getCapRateInitial();
	String getCouponType();
	Boolean getFinalPrincipalExchangeIndicatorAtTermination();
	BigDecimal getFloorRateInitial();
	String getFraDiscountingType();
	BigDecimal getInflationIndexInitialLevel();
	String getInflationIndexMainPublication();
	String getInflationInterpolationMethod();
	String getInflationLagDayType();
	String getInflationLagPeriod();
	String getInflationRateSourceName();
	Boolean getInitialPrincipalExchangeIndicator();
	Boolean getIntermediatePrincipalExchangeIndicator();
	String getLeg1FloatingRateIndex();
	BigDecimal getLeg1FloatingRateInitialSpread();
	BigDecimal getLeg1FloatingRateMultiplierInitialValue();
	String getLeg1FloatingRateTenorPeriod();
	BigDecimal getLeg1FloatingRateTenorPeriodMultiplier();
	BigDecimal getLeg1KnownAmount();
	String getLeg1KnownAmountCurrency();
	String getLeg1ReferenceCurrency();
	String getLeg2FloatingRateIndex();
	BigDecimal getLeg2FloatingRateInitialSpread();
	BigDecimal getLeg2FloatingRateMultiplierInitialValue();
	String getLeg2FloatingRateTenorPeriod();
	BigDecimal getLeg2FloatingRateTenorPeriodMultiplier();
	BigDecimal getLeg2KnownAmount();
	String getLeg2KnownAmountCurrency();
	String getLeg2ReferenceCurrency();
	Date getMandatoryEarlyTerminationDate();
	String getMandatoryEarlyTerminationDateTenorPeriod();
	String getMandatoryEarlyTerminationDateTenorPeriodMultiplier();
	BigDecimal getNotionalUnits();
	Date getOptionalEarlyTerminationCommencementDate();
	String getOptionalEarlyTerminationExerciseStyle();
	Date getOptionalEarlyTerminationExpirationDate();
	String getPremiumReceiver();
	BigDecimal getUnderlyingCouponRate();
	Date getUnderlyingMaturityDate();
	String getUnderlyingProductId();
	String getInflationLagPeriodMultiplier();
	String getLeg1FixedRateNotation();
	String getLeg2FixedRateNotation();
	String getSwaptionStraddleIndicator();
	String getSinglePartyEarlyTerminationBuyer();
	Date getLeg1EffectiveDate();
	String getAction();
	String getClearingStatus();
	Date getEffectiveDate1();
	String getExecutionVenueType();
	Boolean getNonStandardTradeIndicator();
	BigDecimal getNotionalAmount1();
	String getNotionalCurrency1();
	BigDecimal getPrice1Price();
	String getPrice1Type();
	String getPrice1Units();
	Date getScheduledTerminationDate1();
	Date getTradeDate();
	String getTradeParty1CollateralizationType();
	String getTradeParty1EventId();
	String getTradeParty2CollateralizationType();
	String getTradeParty2EventId();
	String getEmbeddedOptionOnSwap();
	Date getExpirationDate();
	BigDecimal getNotionalAmount2();
	String getNotionalCurrency2();
	BigDecimal getPremiumAmount();
	String getPremiumCurrency();
	String getVersion();
	String getComment1();
	String getOptionStyle();
	String getOptionType();
	String getSettlementCurrency1();
	Date getCommencementDate();
	String getDayCountFraction1();
	String getLeg2DayCountFraction();
	Date getLeg2EffectiveDate();
	String getLeg2ResetFrequencyPeriod();
	BigDecimal getLeg2ResetFrequencyPeriodMultiplier();
	String getLeg2SettlementCurrency();
	Date getLeg2ScheduledTerminationDate();
	BigDecimal getNumberOfOptions();
	BigDecimal getOptionEntitlement();
	ZonedDateTime getOriginalExecutionTimestamp();
	Date getPayment1Date();
	String getPayment1FrequencyPeriod();
	BigDecimal getPayment1FrequencyPeriodMultiplier();
	Date getPayment2Date();
	String getPayment2FrequencyPeriod();
	BigDecimal getPayment2FrequencyPeriodMultiplier();
	String getResetFrequencyPeriod1();
	BigDecimal getResetFrequencyPeriodMultiplier1();
	Date getSettlementDate();
	BigDecimal getStrikePrice();
	String getStrikePriceUnits();
	ZonedDateTime getAsOfDateTime();
	String getClearingVenueId();
	String getClearingVenueIdType();
	String getCompressedTradeIndicator();
	String getConfirmationMethod();
	String getConfirmationPlatformId();
	String getConfirmationPlatformTradeId();
	String getExecutionVenueId();
	String getExecutionVenueIdType();
	Date getPostTradeEffectiveDate();
	String getPriorUsiId();
	String getPriorUsiIdPrefix();
	String getPriorUtiId();
	String getPriorUtiIdPrefix();
	String getTradeParty1BranchLocation();
	String getTradeParty1ClearingBrokerId();
	String getTradeParty1ClearingBrokerIdType();
	String getTradeParty1DeskLocation();
	String getTradeParty1Domicile();
	String getTradeParty1IndustrialSectorType();
	String getTradeParty2BranchLocation();
	String getTradeParty2DeskLocation();
	String getTradeParty2Domicile();
	String getTradeParty2IndustrialSectorType();
	String getSellerPayer2();
	String getBuyerPayer1();
	String getTradeParty1HkCounterpartyOrigin();
	Date getLeg2SettlementDate();
	BigDecimal getLeg1FixedRateInitial();
	BigDecimal getLeg2FixedRateInitial();
	BigDecimal getPayment1Amount();
	String getPayment1Currency();
	String getPayment1Payer();
	String getPayment1Receiver();
	String getPayment2Payer();
	Date getPostTradeTransactionDate();
	String getSecondaryAssetClass();
	String getSettlementType();
	String getTradeParty1Name();
	String getTradeParty2Name();
	BigDecimal getCcpValuationAmount();
	String getCcpValuationCurrency();
	ZonedDateTime getCcpValuationDatetime();
	String getCcpValuationType();
	BigDecimal getTradeParty1ValuationAmount();
	String getTradeParty1ValuationCurrency();
	ZonedDateTime getTradeParty1ValuationDatetime();
	String getTradeParty1ValuationType();
	BigDecimal getTradeParty2ValuationAmount();
	String getTradeParty2ValuationCurrency();
	ZonedDateTime getTradeParty2ValuationDatetime();
	String getTradeParty2ValuationType();
	String getExecutionType();
	String getStrikePriceCurrency();
	BigDecimal getPayment2Amount();
	String getTradeParty2HkCounterpartyOrigin();
	String getTradeParty1CountryOfTheOtherCounterparty();
	String getTradeParty2CountryOfTheOtherCounterparty();
	String getTradeParty1BrokerId();
	String getTradeParty2BrokerId();
	String getTradeParty1BeneficiaryIdType();
	String getTradeParty1BeneficiaryId();
	String getTradeParty2BeneficiaryIdType();
	String getTradeParty2BeneficiaryId();
	String getTradeParty1CounterpartySide();
	String getTradeParty2CounterpartySide();
	String getTradeParty1CollateralPortfolioCode();
	String getTradeParty2CollateralPortfolioCode();
	String getContractType();
	String getEuUnderlyingAssetIdType();
	String getProductClassification();
	String getComplexTradeComponentId();
	BigDecimal getPriceMultiplier();
	BigDecimal getQuantity();
	String getMasterAgreementType();
	String getMasterAgreementVersion();
	ZonedDateTime getConfirmationDatetime();
	ZonedDateTime getClearingDatetime();
	Date getMaturityDateOfTheUnderlying();
	String getLevel();
	String getProductClassificationType();
	String getProductIdentificationType();
	String getProductIdentification();
	String getEuUnderlyingAssetId();
	String getReportTrackingNumber();
	String getTradeParty1BrokerIdType();
	String getTradeParty2BrokerIdType();
	String getTradeParty2ClearingBrokerIdType();
	String getTradeParty2ClearingBrokerId();
	Boolean getTradeParty1ClearingThreshold();
	Boolean getTradeParty2ClearingThreshold();
	String getTradeParty1CorporateSectorType();
	String getTradeParty2CorporateSectorType();
	String getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator();
	String getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator();
	Boolean getIntragroupIndicator();
	String getTradeParty1TradingCapacity1();
	String getTradeParty2TradingCapacity1();
	String getCurrencyOfPrice();
	String getTradeParty1CollateralPortfolio();
	String getTradeParty2CollateralPortfolio();
	String getExecutionVenueMicCode();
	String getPayment2Currency();
	String getExpirationDateTimeBusinessCenter();
	LocalTime getExpirationTime();
	String getExpirationTimeType();
	String getTradeParty1TraderLocation();
	String getTradeParty2TraderLocation();
	BigDecimal getPayment3ResetFrequencyPeriodMultiplier();
	String getPayment3ResetFrequencyPeriod();
	BigDecimal getPayment4ResetFrequencyPeriodMultiplier();
	String getPayment4ResetFrequencyPeriod();
	BigDecimal getPayment5ResetFrequencyPeriodMultiplier();
	String getPayment5ResetFrequencyPeriod();
	String getPayment1Type();
	String getPayment1Reference();
	String getPayment2Type();
	String getPayment2Reference();
	String getPayment3Payer();
	String getPayment3Reference();
	String getPayment3FrequencyPeriod();
	BigDecimal getPayment3FrequencyPeriodMultiplier();
	Date getPayment3Date();
	String getPayment4Reference();
	String getPayment4Payer();
	String getPayment4FrequencyPeriod();
	BigDecimal getPayment4FrequencyPeriodMultiplier();
	Date getPayment4Date();
	String getPayment5Reference();
	String getPayment5Payer();
	String getPayment5FrequencyPeriod();
	BigDecimal getPayment5FrequencyPeriodMultiplier();
	Date getPayment5Date();
	String getPayment3Type();
	String getPremiumPayer();
	Date getPremiumPaymentDateUnadjusted();
	String getTradeParty1NatureOfTheReportingCounterparty();
	String getTradeParty2NatureOfTheReportingCounterparty();
	String getReservedParticipantUse1();
	String getReservedParticipantUse2();
	String getReservedParticipantUse3();
	String getReservedParticipantUse4();
	String getReservedParticipantUse5();
	Date getLeg1TerminationDate();
	String getAllocationType();
	String getCalculationBasis();
	String getClearingExceptionPartyId();
	String getClearingExceptionPartyIdType();
	String getClearingExceptionType();
	String getClearingMemberClientAccountId();
	ZonedDateTime getClearingReceiptDatetime();
	String getClearingSwapSdrLeiId();
	String getClearingSwapUtiId();
	Date getCollateralReportingDate();
	ZonedDateTime getCollateralValuationDatetime();
	String getComment2();
	String getCommodityStrikePriceUnit();
	String getExecutionAgentMaskingIndicator();
	String getFeeInCurrency();
	String getFeeOutCurrency();
	BigDecimal getFloatingRatePaymentFrequencyLeg1Multiplier();
	String getFloatingRatePaymentFrequencyLeg1TimePeriod();
	BigDecimal getFloatingRatePaymentFrequencyLeg2Multiplier();
	String getFloatingRatePaymentFrequencyLeg2TimePeriod();
	String getFrequencyOfPayment();
	Boolean getInteraffiliate();
	Boolean getLargeTradeIndicator();
	Date getLeg1EffectiveDateAdjusted();
	Date getLeg1FinalValuationDate();
	String getLeg1SettlementPeriod();
	Date getLeg2EffectiveDateAdjusted();
	String getLeg2PaymentTermsFrequencyPeriod();
	BigDecimal getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier();
	String getLeg2SettlementType();
	String getLeg2UnderlyingAssetId();
	String getLeg2UnderlyingAssetIdType();
	String getLeg2UnderlyingAssetName();
	Date getMaturityDate();
	String getOptionalEarlyTerminationDate();
	String getOptionCommodityCurrency();
	String getOptionCommodityExchangeId();
	String getOptionCommodityInstrumentId();
	String getOptionCommodityRateSource();
	String getOptionCommodityRateSourcePage();
	String getOptionCommodityUnderlyerDetails();
	String getOptionCommodityUnderlyerId();
	String getOptionCommodityUnitOfMeasure();
	String getOptionSpecifiedPrice();
	BigDecimal getOptionSpreadAmount();
	String getOptionSpreadCurrency();
	String getOptionSpreadSchedule();
	String getOrigin();
	String getOriginalSwapSdrId();
	String getOriginalSwapSdrIdType();
	String getPaymentFrequencyPeriodLeg1();
	String getPaymentFrequencyPeriodLeg2();
	BigDecimal getPaymentFrequencyPeriodMultiplierLeg1();
	BigDecimal getPaymentFrequencyPeriodMultiplierLeg2();
	String getPremiumPayerPrefix();
	String getPrice1Currency();
	BigDecimal getPrice2Price();
	String getPrice2Type();
	String getPrice2Units();
	BigDecimal getPrice3Price();
	String getPrice3Type();
	String getPrice3Units();
	BigDecimal getPrice4Price();
	String getPrice4Type();
	String getPrice4Units();
	String getPricingContext();
	String getPriorUsiType();
	String getPriorUtiType();
	BigDecimal getRecoveryPrice();
	String getSendToDataCenterCode();
	String getStrikePriceType();
	String getSubAssetClassForOtherCommodity();
	String getTradeParty1CftcFinancialEntityStatus();
	BigDecimal getTradeParty1CollateralAmount();
	String getTradeParty1CollateralCurrency();
	String getTradeParty1MandatoryDelegatedReporting();
	String getTradeParty1Role();
	String getTradeParty2CftcFinancialEntityStatus();
	BigDecimal getTradeParty2CollateralAmount();
	String getTradeParty2CollateralCurrency();
	String getTradeParty2MandatoryDelegatedReporting();
	String getTradeParty2Role();
	BigDecimal getUpfrontPayment();
	String getVerificationMethod();
	String getResponsibleDataSubmitterId();
	String getResponsibleDataSubmitterIdType();
	String getOriginalSwapUsi();
	String getOriginalSwapUti();
	String getCdeReceiverIdentifierLeg2();
	Boolean getCounterparty1FederalEntityIndicator();
	Boolean getCounterparty2FederalEntityIndicator();
	Boolean getCustomBasketIndicator();
	String getNoaActionType();
	String getEventType();
	Boolean getAmendmentIndicator();
	String getEventIdentifier();
	BigDecimal getCdeCallAmountLeg1();
	BigDecimal getCdeCallAmountLeg2();
	String getCdeCallCurrencyLeg1();
	String getCdeCallCurrencyLeg2();
	BigDecimal getCdePutAmountLeg1();
	BigDecimal getCdePutAmountLeg2();
	String getCdePutCurrencyLeg1();
	String getCdePutCurrencyLeg2();
	String getLeg2QuantityFrequency();
	BigDecimal getQuantityFrequencyMultiplierLeg1();
	BigDecimal getQuantityFrequencyMultiplierLeg2();
	String getCdeQuantityUnitOfMeasureLeg1();
	String getCdeQuantityUnitOfMeasureLeg2();
	Boolean getPackageIndicator();
	String getCdePackageIdentifier();
	BigDecimal getCdePackageTransactionPrice();
	String getCdePackageTransactionPriceCurrency();
	String getCdePackageTransactionPriceNotation();
	BigDecimal getCdePackageTransactionSpread();
	String getCdePackageTransactionSpreadCurrency();
	String getCdePackageTransactionSpreadNotation();
	String getCdeFixedRateDayCountConventionLeg1();
	String getCdeFixedRateDayCountConventionLeg2();
	String getCdeFloatingRateDayCountConventionLeg1();
	String getCdeFloatingRateDayCountConventionLeg2();
	Date getFixingDateLeg1();
	Date getFixingDateLeg2();
	String getCdeFixedRatePaymentFrequencyPeriodLeg1();
	String getCdeFixedRatePaymentFrequencyPeriodLeg2();
	String getCdeFloatingRatePaymentFrequencyPeriodLeg1();
	String getCdeFloatingRatePaymentFrequencyPeriodLeg2();
	BigDecimal getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1();
	BigDecimal getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2();
	BigDecimal getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1();
	BigDecimal getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2();
	Boolean getPostPricedSwapIndicator();
	String getCdePriceCurrency();
	String getCdePriceNotation();
	String getCdeSpreadNotationLeg1();
	String getCdeSpreadNotationLeg2();
	String getCdeStrikePriceCurrency2();
	String getCdeStrikePriceNotation();
	Date getCdeFirstExerciseDate();
	Date getCdeFinalContractualSettlementDate();
	String getCdeSettlementLocationLeg1();
	String getCdeSettlementLocationLeg2();
	Date getCdeEffectiveDate();
	Date getCdeExpirationDate();
	String getCdePlatformIdentifier();
	Boolean getPrimeBrokerageTransactionIndicator();
	String getSwapReportingJurisdiction();
	String getNewSdrIdentifier();
	Date getNextFloatingReferenceResetDateLeg1();
	BigDecimal getLastFloatingReferenceValueLeg1();
	Date getLastFloatingReferenceResetDateLeg1();
	Date getNextFloatingReferenceResetDateLeg2();
	BigDecimal getLastFloatingReferenceValueLeg2();
	Date getLastFloatingReferenceResetDateLeg2();
	BigDecimal getCdeDelta();
	String getInitialMarginCollateralPortfolioCode();
	String getVariationMarginCollateralPortfolioCode();
	Boolean getLargeNotionalOffFacilitySwapElectionIndicator();
	Boolean getSefOrDcmAnonymousExecutionIndicator();
	Boolean getBlockTradeElectionIndicator();
	Boolean getSefOrDcmIndicator();
	Boolean getMandatoryClearingIndicator();
	Boolean getSdMspIndicatorCounterparty1();
	Boolean getSdMspIndicatorCounterparty2();
	Boolean getPhysicalCommodityContractIndicator();
	BigDecimal getChangeInNotionalAmount1();
	BigDecimal getChangeInNotionalAmount2();
	BigDecimal getChangeInLeg1NotionalQuantity();
	BigDecimal getChangeInLeg2NotionalQuantity();
	Boolean getCdeCryptoAssetUnderlyingIndicatorLeg1();
	Boolean getCdeCryptoAssetUnderlyingIndicatorLeg2();
	String getCdeCustomBasketCode();
	String getUnderlierIdOtherLeg1();
	String getUnderlierIdOtherLeg2();
	String getUnderlierIdOtherSourceLeg1();
	String getUnderlierIdOtherSourceLeg2();
	String getCdeUnderlyingAssetTradingPlatformIdLeg1();
	String getCdeUnderlyingAssetTradingPlatformIdLeg2();
	String getCdeUnderlyingAssetPriceSourceLeg1();
	String getCdeUnderlyingAssetPriceSourceLeg2();

	/*********************** Build Methods  ***********************/
	HarmonizedData build();
	
	HarmonizedData.HarmonizedDataBuilder toBuilder();
	
	static HarmonizedData.HarmonizedDataBuilder builder() {
		return new HarmonizedData.HarmonizedDataBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends HarmonizedData> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends HarmonizedData> getType() {
		return HarmonizedData.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("leg2CommodityInstrumentId"), String.class, getLeg2CommodityInstrumentId(), this);
		processor.processBasic(path.newSubPath("leg2CommodityUnderlyerId"), String.class, getLeg2CommodityUnderlyerId(), this);
		processor.processBasic(path.newSubPath("leg2CommodityUnderlyerDetails"), String.class, getLeg2CommodityUnderlyerDetails(), this);
		processor.processBasic(path.newSubPath("leg2CommodityUnitOfMeasure"), String.class, getLeg2CommodityUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("leg2CommodityCurrency"), String.class, getLeg2CommodityCurrency(), this);
		processor.processBasic(path.newSubPath("leg2CommodityExchangeId"), String.class, getLeg2CommodityExchangeId(), this);
		processor.processBasic(path.newSubPath("leg1CommodityRateSource"), String.class, getLeg1CommodityRateSource(), this);
		processor.processBasic(path.newSubPath("leg1CommodityRateSourcePage"), String.class, getLeg1CommodityRateSourcePage(), this);
		processor.processBasic(path.newSubPath("leg2SpecifiedPrice"), String.class, getLeg2SpecifiedPrice(), this);
		processor.processBasic(path.newSubPath("commencementDateUnadjusted"), Date.class, getCommencementDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("exerciseExpirationDateUnadjusted"), Date.class, getExerciseExpirationDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("expirationDateUnadjusted"), Date.class, getExpirationDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("leg2NotionalQuantityFrequency"), String.class, getLeg2NotionalQuantityFrequency(), this);
		processor.processBasic(path.newSubPath("leg2NotionalQuantity"), BigDecimal.class, getLeg2NotionalQuantity(), this);
		processor.processBasic(path.newSubPath("leg2TotalNotionalQuantity"), BigDecimal.class, getLeg2TotalNotionalQuantity(), this);
		processor.processBasic(path.newSubPath("leg2SpreadAmount"), BigDecimal.class, getLeg2SpreadAmount(), this);
		processor.processBasic(path.newSubPath("leg2SpreadCurrency"), String.class, getLeg2SpreadCurrency(), this);
		processor.processBasic(path.newSubPath("scheduledTerminationDateAdjusted"), Date.class, getScheduledTerminationDateAdjusted(), this);
		processor.processBasic(path.newSubPath("leg1PartyPayer"), String.class, getLeg1PartyPayer(), this);
		processor.processBasic(path.newSubPath("leg2PartyPayer"), String.class, getLeg2PartyPayer(), this);
		processor.processBasic(path.newSubPath("leg1CommodityInstrumentId"), String.class, getLeg1CommodityInstrumentId(), this);
		processor.processBasic(path.newSubPath("leg1CommodityUnderlyerId"), String.class, getLeg1CommodityUnderlyerId(), this);
		processor.processBasic(path.newSubPath("leg1CommodityUnitOfMeasure"), String.class, getLeg1CommodityUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("leg1CommodityExchangeId"), String.class, getLeg1CommodityExchangeId(), this);
		processor.processBasic(path.newSubPath("leg2CommodityRateSource"), String.class, getLeg2CommodityRateSource(), this);
		processor.processBasic(path.newSubPath("leg1EffectiveDateUnadjusted"), Date.class, getLeg1EffectiveDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("leg2EffectiveDateUnadjusted"), Date.class, getLeg2EffectiveDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("coProductType"), String.class, getCoProductType(), this);
		processor.processBasic(path.newSubPath("totalQuantityUnit"), String.class, getTotalQuantityUnit(), this);
		processor.processBasic(path.newSubPath("totalQuantity"), BigDecimal.class, getTotalQuantity(), this);
		processor.processBasic(path.newSubPath("fixedPrice"), BigDecimal.class, getFixedPrice(), this);
		processor.processBasic(path.newSubPath("fixedPriceCurrency"), String.class, getFixedPriceCurrency(), this);
		processor.processBasic(path.newSubPath("leg1NotionalQuantityUnit"), String.class, getLeg1NotionalQuantityUnit(), this);
		processor.processBasic(path.newSubPath("leg1NotionalQuantityFrequency"), String.class, getLeg1NotionalQuantityFrequency(), this);
		processor.processBasic(path.newSubPath("leg1NotionalQuantity"), BigDecimal.class, getLeg1NotionalQuantity(), this);
		processor.processBasic(path.newSubPath("leg1TotalNotionalQuantity"), BigDecimal.class, getLeg1TotalNotionalQuantity(), this);
		processor.processBasic(path.newSubPath("leg1CommodityCurrency"), String.class, getLeg1CommodityCurrency(), this);
		processor.processBasic(path.newSubPath("leg1SpecifiedPrice"), String.class, getLeg1SpecifiedPrice(), this);
		processor.processBasic(path.newSubPath("leg1SpreadCurrency"), String.class, getLeg1SpreadCurrency(), this);
		processor.processBasic(path.newSubPath("leg1SpreadAmount"), BigDecimal.class, getLeg1SpreadAmount(), this);
		processor.processBasic(path.newSubPath("leg2NotionalQuantityUnit"), String.class, getLeg2NotionalQuantityUnit(), this);
		processor.processBasic(path.newSubPath("leg2PartyReceiver"), String.class, getLeg2PartyReceiver(), this);
		processor.processBasic(path.newSubPath("leg1PartyReceiver"), String.class, getLeg1PartyReceiver(), this);
		processor.processBasic(path.newSubPath("coalSource"), String.class, getCoalSource(), this);
		processor.processBasic(path.newSubPath("leg2Quantity"), BigDecimal.class, getLeg2Quantity(), this);
		processor.processBasic(path.newSubPath("commodityBase"), String.class, getCommodityBase(), this);
		processor.processBasic(path.newSubPath("commodityDetails"), String.class, getCommodityDetails(), this);
		processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
		processor.processBasic(path.newSubPath("loadType"), String.class, getLoadType(), this);
		processor.processBasic(path.newSubPath("fixedPriceUnit"), String.class, getFixedPriceUnit(), this);
		processor.processBasic(path.newSubPath("exercisePaymentDateUnadjusted"), Date.class, getExercisePaymentDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("leg1PaymentDatesUnadjusted"), Date.class, getLeg1PaymentDatesUnadjusted(), this);
		processor.processBasic(path.newSubPath("leg2PaymentDateUnadjusted"), Date.class, getLeg2PaymentDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("settlementDateUnadjusted"), Date.class, getSettlementDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("deliveryLocation"), String.class, getDeliveryLocation(), this);
		processor.processBasic(path.newSubPath("leg2QuantityUnit"), String.class, getLeg2QuantityUnit(), this);
		processor.processBasic(path.newSubPath("leg1CommodityUnderlyerDetails"), String.class, getLeg1CommodityUnderlyerDetails(), this);
		processor.processBasic(path.newSubPath("leg2CommodityRateSourcePage"), String.class, getLeg2CommodityRateSourcePage(), this);
		processor.processBasic(path.newSubPath("valueDate"), Date.class, getValueDate(), this);
		processor.processBasic(path.newSubPath("gtrQuantityUnit"), String.class, getGtrQuantityUnit(), this);
		processor.processBasic(path.newSubPath("attachmentPoint"), BigDecimal.class, getAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("exhaustionPoint"), BigDecimal.class, getExhaustionPoint(), this);
		processor.processBasic(path.newSubPath("mthToDefault"), BigDecimal.class, getMthToDefault(), this);
		processor.processBasic(path.newSubPath("nthToDefault"), BigDecimal.class, getNthToDefault(), this);
		processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), BigDecimal.class, getSeries(), this);
		processor.processBasic(path.newSubPath("crversion"), BigDecimal.class, getCrversion(), this);
		processor.processBasic(path.newSubPath("tranche"), String.class, getTranche(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("referenceObligation"), String.class, getReferenceObligation(), this);
		processor.processBasic(path.newSubPath("referenceObligationIdType"), String.class, getReferenceObligationIdType(), this);
		processor.processBasic(path.newSubPath("underlyingFixedRatePayerBuyer"), String.class, getUnderlyingFixedRatePayerBuyer(), this);
		processor.processBasic(path.newSubPath("underlyingFloatRatePayerSeller"), String.class, getUnderlyingFloatRatePayerSeller(), this);
		processor.processBasic(path.newSubPath("underlyingAssetExchangeId"), String.class, getUnderlyingAssetExchangeId(), this);
		processor.processBasic(path.newSubPath("underlyingAssetNumberOfUnits"), BigDecimal.class, getUnderlyingAssetNumberOfUnits(), this);
		processor.processBasic(path.newSubPath("optionalEarlyTerminationType"), String.class, getOptionalEarlyTerminationType(), this);
		processor.processBasic(path.newSubPath("optionalEarlyTerminationElectingPartyValue"), String.class, getOptionalEarlyTerminationElectingPartyValue(), this);
		processor.processBasic(path.newSubPath("optionalEarlyTerminationIndicator"), Boolean.class, getOptionalEarlyTerminationIndicator(), this);
		processor.processBasic(path.newSubPath("underlyingAssetFloatingAmountPayer"), String.class, getUnderlyingAssetFloatingAmountPayer(), this);
		processor.processBasic(path.newSubPath("underlyingAssetFloatingAmountReceiver"), String.class, getUnderlyingAssetFloatingAmountReceiver(), this);
		processor.processBasic(path.newSubPath("floatingRateOption"), String.class, getFloatingRateOption(), this);
		processor.processBasic(path.newSubPath("underlyingAssetFloatingLegSpread"), BigDecimal.class, getUnderlyingAssetFloatingLegSpread(), this);
		processor.processBasic(path.newSubPath("leg2DesignatedMaturityPeriod"), String.class, getLeg2DesignatedMaturityPeriod(), this);
		processor.processBasic(path.newSubPath("leg2DesignatedMaturityPeriodMultiplier"), BigDecimal.class, getLeg2DesignatedMaturityPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("underlyingAssetEquityAmountPayer"), String.class, getUnderlyingAssetEquityAmountPayer(), this);
		processor.processBasic(path.newSubPath("underlyingAssetEquityAmountReceiver"), String.class, getUnderlyingAssetEquityAmountReceiver(), this);
		processor.processBasic(path.newSubPath("underlyingAssetInitialPriceCurrency"), String.class, getUnderlyingAssetInitialPriceCurrency(), this);
		processor.processBasic(path.newSubPath("leg1ValuationDates"), Date.class, getLeg1ValuationDates(), this);
		processor.processBasic(path.newSubPath("leg1TypeOfReturn"), String.class, getLeg1TypeOfReturn(), this);
		processor.processBasic(path.newSubPath("observationStartDate"), Date.class, getObservationStartDate(), this);
		processor.processBasic(path.newSubPath("varianceAmount"), BigDecimal.class, getVarianceAmount(), this);
		processor.processBasic(path.newSubPath("volatilityStrikePrice"), BigDecimal.class, getVolatilityStrikePrice(), this);
		processor.processBasic(path.newSubPath("varianceStrikePrice"), BigDecimal.class, getVarianceStrikePrice(), this);
		processor.processBasic(path.newSubPath("varianceCapFactor"), BigDecimal.class, getVarianceCapFactor(), this);
		processor.processBasic(path.newSubPath("referenceCurrency"), String.class, getReferenceCurrency(), this);
		processor.processBasic(path.newSubPath("specialDividendsIndicator"), String.class, getSpecialDividendsIndicator(), this);
		processor.processBasic(path.newSubPath("materialNoncashDividendIndicator"), String.class, getMaterialNoncashDividendIndicator(), this);
		processor.processBasic(path.newSubPath("numberOfSharesUnits"), BigDecimal.class, getNumberOfSharesUnits(), this);
		processor.processBasic(path.newSubPath("dividendAmountPayer"), String.class, getDividendAmountPayer(), this);
		processor.processBasic(path.newSubPath("dividendAmountReceiver"), String.class, getDividendAmountReceiver(), this);
		processor.processBasic(path.newSubPath("fixedAmountPayer"), String.class, getFixedAmountPayer(), this);
		processor.processBasic(path.newSubPath("fixedAmountReceiver"), String.class, getFixedAmountReceiver(), this);
		processor.processBasic(path.newSubPath("knockInEvent"), String.class, getKnockInEvent(), this);
		processor.processBasic(path.newSubPath("knockOutEvent"), String.class, getKnockOutEvent(), this);
		processor.processBasic(path.newSubPath("knockInPrice"), BigDecimal.class, getKnockInPrice(), this);
		processor.processBasic(path.newSubPath("knockOutPrice"), BigDecimal.class, getKnockOutPrice(), this);
		processor.processBasic(path.newSubPath("barrierType"), String.class, getBarrierType(), this);
		processor.processBasic(path.newSubPath("earliestExecutionTime"), LocalTime.class, getEarliestExecutionTime(), this);
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasisCurrency1"), String.class, getExchangeRateBasisCurrency1(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasisCurrency2"), String.class, getExchangeRateBasisCurrency2(), this);
		processor.processBasic(path.newSubPath("executionPeriodStartDate"), Date.class, getExecutionPeriodStartDate(), this);
		processor.processBasic(path.newSubPath("payoutStyle"), String.class, getPayoutStyle(), this);
		processor.processBasic(path.newSubPath("rateQuoteBasis1"), String.class, getRateQuoteBasis1(), this);
		processor.processBasic(path.newSubPath("settlementFixingDate"), Date.class, getSettlementFixingDate(), this);
		processor.processBasic(path.newSubPath("swapLinkId"), String.class, getSwapLinkId(), this);
		processor.processBasic(path.newSubPath("triggerCondition"), String.class, getTriggerCondition(), this);
		processor.processBasic(path.newSubPath("triggerCondition2"), String.class, getTriggerCondition2(), this);
		processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, getTriggerRate(), this);
		processor.processBasic(path.newSubPath("triggerRate2"), BigDecimal.class, getTriggerRate2(), this);
		processor.processBasic(path.newSubPath("rateQuoteBasis2"), String.class, getRateQuoteBasis2(), this);
		processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
		processor.processBasic(path.newSubPath("barrierType2"), String.class, getBarrierType2(), this);
		processor.processBasic(path.newSubPath("cancelationOptionBuyer"), String.class, getCancelationOptionBuyer(), this);
		processor.processBasic(path.newSubPath("cancelationOptionCommencementDate"), Date.class, getCancelationOptionCommencementDate(), this);
		processor.processBasic(path.newSubPath("cancelationOptionExerciseStyleType"), String.class, getCancelationOptionExerciseStyleType(), this);
		processor.processBasic(path.newSubPath("cancelationOptionExpirationDate"), Date.class, getCancelationOptionExpirationDate(), this);
		processor.processBasic(path.newSubPath("cancelationOptionInitialFeeCurrency"), String.class, getCancelationOptionInitialFeeCurrency(), this);
		processor.processBasic(path.newSubPath("cancelationOptionInitialFeePayer"), String.class, getCancelationOptionInitialFeePayer(), this);
		processor.processBasic(path.newSubPath("cancelationOptionPremiumAmount"), BigDecimal.class, getCancelationOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("cancelationOptionSeller"), String.class, getCancelationOptionSeller(), this);
		processor.processBasic(path.newSubPath("capRateInitial"), BigDecimal.class, getCapRateInitial(), this);
		processor.processBasic(path.newSubPath("couponType"), String.class, getCouponType(), this);
		processor.processBasic(path.newSubPath("finalPrincipalExchangeIndicatorAtTermination"), Boolean.class, getFinalPrincipalExchangeIndicatorAtTermination(), this);
		processor.processBasic(path.newSubPath("floorRateInitial"), BigDecimal.class, getFloorRateInitial(), this);
		processor.processBasic(path.newSubPath("fraDiscountingType"), String.class, getFraDiscountingType(), this);
		processor.processBasic(path.newSubPath("inflationIndexInitialLevel"), BigDecimal.class, getInflationIndexInitialLevel(), this);
		processor.processBasic(path.newSubPath("inflationIndexMainPublication"), String.class, getInflationIndexMainPublication(), this);
		processor.processBasic(path.newSubPath("inflationInterpolationMethod"), String.class, getInflationInterpolationMethod(), this);
		processor.processBasic(path.newSubPath("inflationLagDayType"), String.class, getInflationLagDayType(), this);
		processor.processBasic(path.newSubPath("inflationLagPeriod"), String.class, getInflationLagPeriod(), this);
		processor.processBasic(path.newSubPath("inflationRateSourceName"), String.class, getInflationRateSourceName(), this);
		processor.processBasic(path.newSubPath("initialPrincipalExchangeIndicator"), Boolean.class, getInitialPrincipalExchangeIndicator(), this);
		processor.processBasic(path.newSubPath("intermediatePrincipalExchangeIndicator"), Boolean.class, getIntermediatePrincipalExchangeIndicator(), this);
		processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, getLeg1FloatingRateIndex(), this);
		processor.processBasic(path.newSubPath("leg1FloatingRateInitialSpread"), BigDecimal.class, getLeg1FloatingRateInitialSpread(), this);
		processor.processBasic(path.newSubPath("leg1FloatingRateMultiplierInitialValue"), BigDecimal.class, getLeg1FloatingRateMultiplierInitialValue(), this);
		processor.processBasic(path.newSubPath("leg1FloatingRateTenorPeriod"), String.class, getLeg1FloatingRateTenorPeriod(), this);
		processor.processBasic(path.newSubPath("leg1FloatingRateTenorPeriodMultiplier"), BigDecimal.class, getLeg1FloatingRateTenorPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("leg1KnownAmount"), BigDecimal.class, getLeg1KnownAmount(), this);
		processor.processBasic(path.newSubPath("leg1KnownAmountCurrency"), String.class, getLeg1KnownAmountCurrency(), this);
		processor.processBasic(path.newSubPath("leg1ReferenceCurrency"), String.class, getLeg1ReferenceCurrency(), this);
		processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, getLeg2FloatingRateIndex(), this);
		processor.processBasic(path.newSubPath("leg2FloatingRateInitialSpread"), BigDecimal.class, getLeg2FloatingRateInitialSpread(), this);
		processor.processBasic(path.newSubPath("leg2FloatingRateMultiplierInitialValue"), BigDecimal.class, getLeg2FloatingRateMultiplierInitialValue(), this);
		processor.processBasic(path.newSubPath("leg2FloatingRateTenorPeriod"), String.class, getLeg2FloatingRateTenorPeriod(), this);
		processor.processBasic(path.newSubPath("leg2FloatingRateTenorPeriodMultiplier"), BigDecimal.class, getLeg2FloatingRateTenorPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("leg2KnownAmount"), BigDecimal.class, getLeg2KnownAmount(), this);
		processor.processBasic(path.newSubPath("leg2KnownAmountCurrency"), String.class, getLeg2KnownAmountCurrency(), this);
		processor.processBasic(path.newSubPath("leg2ReferenceCurrency"), String.class, getLeg2ReferenceCurrency(), this);
		processor.processBasic(path.newSubPath("mandatoryEarlyTerminationDate"), Date.class, getMandatoryEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("mandatoryEarlyTerminationDateTenorPeriod"), String.class, getMandatoryEarlyTerminationDateTenorPeriod(), this);
		processor.processBasic(path.newSubPath("mandatoryEarlyTerminationDateTenorPeriodMultiplier"), String.class, getMandatoryEarlyTerminationDateTenorPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("notionalUnits"), BigDecimal.class, getNotionalUnits(), this);
		processor.processBasic(path.newSubPath("optionalEarlyTerminationCommencementDate"), Date.class, getOptionalEarlyTerminationCommencementDate(), this);
		processor.processBasic(path.newSubPath("optionalEarlyTerminationExerciseStyle"), String.class, getOptionalEarlyTerminationExerciseStyle(), this);
		processor.processBasic(path.newSubPath("optionalEarlyTerminationExpirationDate"), Date.class, getOptionalEarlyTerminationExpirationDate(), this);
		processor.processBasic(path.newSubPath("premiumReceiver"), String.class, getPremiumReceiver(), this);
		processor.processBasic(path.newSubPath("underlyingCouponRate"), BigDecimal.class, getUnderlyingCouponRate(), this);
		processor.processBasic(path.newSubPath("underlyingMaturityDate"), Date.class, getUnderlyingMaturityDate(), this);
		processor.processBasic(path.newSubPath("underlyingProductId"), String.class, getUnderlyingProductId(), this);
		processor.processBasic(path.newSubPath("inflationLagPeriodMultiplier"), String.class, getInflationLagPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("leg1FixedRateNotation"), String.class, getLeg1FixedRateNotation(), this);
		processor.processBasic(path.newSubPath("leg2FixedRateNotation"), String.class, getLeg2FixedRateNotation(), this);
		processor.processBasic(path.newSubPath("swaptionStraddleIndicator"), String.class, getSwaptionStraddleIndicator(), this);
		processor.processBasic(path.newSubPath("singlePartyEarlyTerminationBuyer"), String.class, getSinglePartyEarlyTerminationBuyer(), this);
		processor.processBasic(path.newSubPath("leg1EffectiveDate"), Date.class, getLeg1EffectiveDate(), this);
		processor.processBasic(path.newSubPath("action"), String.class, getAction(), this);
		processor.processBasic(path.newSubPath("clearingStatus"), String.class, getClearingStatus(), this);
		processor.processBasic(path.newSubPath("effectiveDate1"), Date.class, getEffectiveDate1(), this);
		processor.processBasic(path.newSubPath("executionVenueType"), String.class, getExecutionVenueType(), this);
		processor.processBasic(path.newSubPath("nonStandardTradeIndicator"), Boolean.class, getNonStandardTradeIndicator(), this);
		processor.processBasic(path.newSubPath("notionalAmount1"), BigDecimal.class, getNotionalAmount1(), this);
		processor.processBasic(path.newSubPath("notionalCurrency1"), String.class, getNotionalCurrency1(), this);
		processor.processBasic(path.newSubPath("price1Price"), BigDecimal.class, getPrice1Price(), this);
		processor.processBasic(path.newSubPath("price1Type"), String.class, getPrice1Type(), this);
		processor.processBasic(path.newSubPath("price1Units"), String.class, getPrice1Units(), this);
		processor.processBasic(path.newSubPath("scheduledTerminationDate1"), Date.class, getScheduledTerminationDate1(), this);
		processor.processBasic(path.newSubPath("tradeDate"), Date.class, getTradeDate(), this);
		processor.processBasic(path.newSubPath("tradeParty1CollateralizationType"), String.class, getTradeParty1CollateralizationType(), this);
		processor.processBasic(path.newSubPath("tradeParty1EventId"), String.class, getTradeParty1EventId(), this);
		processor.processBasic(path.newSubPath("tradeParty2CollateralizationType"), String.class, getTradeParty2CollateralizationType(), this);
		processor.processBasic(path.newSubPath("tradeParty2EventId"), String.class, getTradeParty2EventId(), this);
		processor.processBasic(path.newSubPath("embeddedOptionOnSwap"), String.class, getEmbeddedOptionOnSwap(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("notionalAmount2"), BigDecimal.class, getNotionalAmount2(), this);
		processor.processBasic(path.newSubPath("notionalCurrency2"), String.class, getNotionalCurrency2(), this);
		processor.processBasic(path.newSubPath("premiumAmount"), BigDecimal.class, getPremiumAmount(), this);
		processor.processBasic(path.newSubPath("premiumCurrency"), String.class, getPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("version"), String.class, getVersion(), this);
		processor.processBasic(path.newSubPath("comment1"), String.class, getComment1(), this);
		processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("settlementCurrency1"), String.class, getSettlementCurrency1(), this);
		processor.processBasic(path.newSubPath("commencementDate"), Date.class, getCommencementDate(), this);
		processor.processBasic(path.newSubPath("dayCountFraction1"), String.class, getDayCountFraction1(), this);
		processor.processBasic(path.newSubPath("leg2DayCountFraction"), String.class, getLeg2DayCountFraction(), this);
		processor.processBasic(path.newSubPath("leg2EffectiveDate"), Date.class, getLeg2EffectiveDate(), this);
		processor.processBasic(path.newSubPath("leg2ResetFrequencyPeriod"), String.class, getLeg2ResetFrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("leg2ResetFrequencyPeriodMultiplier"), BigDecimal.class, getLeg2ResetFrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("leg2SettlementCurrency"), String.class, getLeg2SettlementCurrency(), this);
		processor.processBasic(path.newSubPath("leg2ScheduledTerminationDate"), Date.class, getLeg2ScheduledTerminationDate(), this);
		processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, getNumberOfOptions(), this);
		processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, getOptionEntitlement(), this);
		processor.processBasic(path.newSubPath("originalExecutionTimestamp"), ZonedDateTime.class, getOriginalExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("payment1Date"), Date.class, getPayment1Date(), this);
		processor.processBasic(path.newSubPath("payment1FrequencyPeriod"), String.class, getPayment1FrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment1FrequencyPeriodMultiplier"), BigDecimal.class, getPayment1FrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("payment2Date"), Date.class, getPayment2Date(), this);
		processor.processBasic(path.newSubPath("payment2FrequencyPeriod"), String.class, getPayment2FrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment2FrequencyPeriodMultiplier"), BigDecimal.class, getPayment2FrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("resetFrequencyPeriod1"), String.class, getResetFrequencyPeriod1(), this);
		processor.processBasic(path.newSubPath("resetFrequencyPeriodMultiplier1"), BigDecimal.class, getResetFrequencyPeriodMultiplier1(), this);
		processor.processBasic(path.newSubPath("settlementDate"), Date.class, getSettlementDate(), this);
		processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, getStrikePrice(), this);
		processor.processBasic(path.newSubPath("strikePriceUnits"), String.class, getStrikePriceUnits(), this);
		processor.processBasic(path.newSubPath("asOfDateTime"), ZonedDateTime.class, getAsOfDateTime(), this);
		processor.processBasic(path.newSubPath("clearingVenueId"), String.class, getClearingVenueId(), this);
		processor.processBasic(path.newSubPath("clearingVenueIdType"), String.class, getClearingVenueIdType(), this);
		processor.processBasic(path.newSubPath("compressedTradeIndicator"), String.class, getCompressedTradeIndicator(), this);
		processor.processBasic(path.newSubPath("confirmationMethod"), String.class, getConfirmationMethod(), this);
		processor.processBasic(path.newSubPath("confirmationPlatformId"), String.class, getConfirmationPlatformId(), this);
		processor.processBasic(path.newSubPath("confirmationPlatformTradeId"), String.class, getConfirmationPlatformTradeId(), this);
		processor.processBasic(path.newSubPath("executionVenueId"), String.class, getExecutionVenueId(), this);
		processor.processBasic(path.newSubPath("executionVenueIdType"), String.class, getExecutionVenueIdType(), this);
		processor.processBasic(path.newSubPath("postTradeEffectiveDate"), Date.class, getPostTradeEffectiveDate(), this);
		processor.processBasic(path.newSubPath("priorUsiId"), String.class, getPriorUsiId(), this);
		processor.processBasic(path.newSubPath("priorUsiIdPrefix"), String.class, getPriorUsiIdPrefix(), this);
		processor.processBasic(path.newSubPath("priorUtiId"), String.class, getPriorUtiId(), this);
		processor.processBasic(path.newSubPath("priorUtiIdPrefix"), String.class, getPriorUtiIdPrefix(), this);
		processor.processBasic(path.newSubPath("tradeParty1BranchLocation"), String.class, getTradeParty1BranchLocation(), this);
		processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerId"), String.class, getTradeParty1ClearingBrokerId(), this);
		processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIdType"), String.class, getTradeParty1ClearingBrokerIdType(), this);
		processor.processBasic(path.newSubPath("tradeParty1DeskLocation"), String.class, getTradeParty1DeskLocation(), this);
		processor.processBasic(path.newSubPath("tradeParty1Domicile"), String.class, getTradeParty1Domicile(), this);
		processor.processBasic(path.newSubPath("tradeParty1IndustrialSectorType"), String.class, getTradeParty1IndustrialSectorType(), this);
		processor.processBasic(path.newSubPath("tradeParty2BranchLocation"), String.class, getTradeParty2BranchLocation(), this);
		processor.processBasic(path.newSubPath("tradeParty2DeskLocation"), String.class, getTradeParty2DeskLocation(), this);
		processor.processBasic(path.newSubPath("tradeParty2Domicile"), String.class, getTradeParty2Domicile(), this);
		processor.processBasic(path.newSubPath("tradeParty2IndustrialSectorType"), String.class, getTradeParty2IndustrialSectorType(), this);
		processor.processBasic(path.newSubPath("sellerPayer2"), String.class, getSellerPayer2(), this);
		processor.processBasic(path.newSubPath("buyerPayer1"), String.class, getBuyerPayer1(), this);
		processor.processBasic(path.newSubPath("tradeParty1HkCounterpartyOrigin"), String.class, getTradeParty1HkCounterpartyOrigin(), this);
		processor.processBasic(path.newSubPath("leg2SettlementDate"), Date.class, getLeg2SettlementDate(), this);
		processor.processBasic(path.newSubPath("leg1FixedRateInitial"), BigDecimal.class, getLeg1FixedRateInitial(), this);
		processor.processBasic(path.newSubPath("leg2FixedRateInitial"), BigDecimal.class, getLeg2FixedRateInitial(), this);
		processor.processBasic(path.newSubPath("payment1Amount"), BigDecimal.class, getPayment1Amount(), this);
		processor.processBasic(path.newSubPath("payment1Currency"), String.class, getPayment1Currency(), this);
		processor.processBasic(path.newSubPath("payment1Payer"), String.class, getPayment1Payer(), this);
		processor.processBasic(path.newSubPath("payment1Receiver"), String.class, getPayment1Receiver(), this);
		processor.processBasic(path.newSubPath("payment2Payer"), String.class, getPayment2Payer(), this);
		processor.processBasic(path.newSubPath("postTradeTransactionDate"), Date.class, getPostTradeTransactionDate(), this);
		processor.processBasic(path.newSubPath("secondaryAssetClass"), String.class, getSecondaryAssetClass(), this);
		processor.processBasic(path.newSubPath("settlementType"), String.class, getSettlementType(), this);
		processor.processBasic(path.newSubPath("tradeParty1Name"), String.class, getTradeParty1Name(), this);
		processor.processBasic(path.newSubPath("tradeParty2Name"), String.class, getTradeParty2Name(), this);
		processor.processBasic(path.newSubPath("ccpValuationAmount"), BigDecimal.class, getCcpValuationAmount(), this);
		processor.processBasic(path.newSubPath("ccpValuationCurrency"), String.class, getCcpValuationCurrency(), this);
		processor.processBasic(path.newSubPath("ccpValuationDatetime"), ZonedDateTime.class, getCcpValuationDatetime(), this);
		processor.processBasic(path.newSubPath("ccpValuationType"), String.class, getCcpValuationType(), this);
		processor.processBasic(path.newSubPath("tradeParty1ValuationAmount"), BigDecimal.class, getTradeParty1ValuationAmount(), this);
		processor.processBasic(path.newSubPath("tradeParty1ValuationCurrency"), String.class, getTradeParty1ValuationCurrency(), this);
		processor.processBasic(path.newSubPath("tradeParty1ValuationDatetime"), ZonedDateTime.class, getTradeParty1ValuationDatetime(), this);
		processor.processBasic(path.newSubPath("tradeParty1ValuationType"), String.class, getTradeParty1ValuationType(), this);
		processor.processBasic(path.newSubPath("tradeParty2ValuationAmount"), BigDecimal.class, getTradeParty2ValuationAmount(), this);
		processor.processBasic(path.newSubPath("tradeParty2ValuationCurrency"), String.class, getTradeParty2ValuationCurrency(), this);
		processor.processBasic(path.newSubPath("tradeParty2ValuationDatetime"), ZonedDateTime.class, getTradeParty2ValuationDatetime(), this);
		processor.processBasic(path.newSubPath("tradeParty2ValuationType"), String.class, getTradeParty2ValuationType(), this);
		processor.processBasic(path.newSubPath("executionType"), String.class, getExecutionType(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("payment2Amount"), BigDecimal.class, getPayment2Amount(), this);
		processor.processBasic(path.newSubPath("tradeParty2HkCounterpartyOrigin"), String.class, getTradeParty2HkCounterpartyOrigin(), this);
		processor.processBasic(path.newSubPath("tradeParty1CountryOfTheOtherCounterparty"), String.class, getTradeParty1CountryOfTheOtherCounterparty(), this);
		processor.processBasic(path.newSubPath("tradeParty2CountryOfTheOtherCounterparty"), String.class, getTradeParty2CountryOfTheOtherCounterparty(), this);
		processor.processBasic(path.newSubPath("tradeParty1BrokerId"), String.class, getTradeParty1BrokerId(), this);
		processor.processBasic(path.newSubPath("tradeParty2BrokerId"), String.class, getTradeParty2BrokerId(), this);
		processor.processBasic(path.newSubPath("tradeParty1BeneficiaryIdType"), String.class, getTradeParty1BeneficiaryIdType(), this);
		processor.processBasic(path.newSubPath("tradeParty1BeneficiaryId"), String.class, getTradeParty1BeneficiaryId(), this);
		processor.processBasic(path.newSubPath("tradeParty2BeneficiaryIdType"), String.class, getTradeParty2BeneficiaryIdType(), this);
		processor.processBasic(path.newSubPath("tradeParty2BeneficiaryId"), String.class, getTradeParty2BeneficiaryId(), this);
		processor.processBasic(path.newSubPath("tradeParty1CounterpartySide"), String.class, getTradeParty1CounterpartySide(), this);
		processor.processBasic(path.newSubPath("tradeParty2CounterpartySide"), String.class, getTradeParty2CounterpartySide(), this);
		processor.processBasic(path.newSubPath("tradeParty1CollateralPortfolioCode"), String.class, getTradeParty1CollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("tradeParty2CollateralPortfolioCode"), String.class, getTradeParty2CollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
		processor.processBasic(path.newSubPath("euUnderlyingAssetIdType"), String.class, getEuUnderlyingAssetIdType(), this);
		processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
		processor.processBasic(path.newSubPath("complexTradeComponentId"), String.class, getComplexTradeComponentId(), this);
		processor.processBasic(path.newSubPath("priceMultiplier"), BigDecimal.class, getPriceMultiplier(), this);
		processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, getQuantity(), this);
		processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("masterAgreementVersion"), String.class, getMasterAgreementVersion(), this);
		processor.processBasic(path.newSubPath("confirmationDatetime"), ZonedDateTime.class, getConfirmationDatetime(), this);
		processor.processBasic(path.newSubPath("clearingDatetime"), ZonedDateTime.class, getClearingDatetime(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("level"), String.class, getLevel(), this);
		processor.processBasic(path.newSubPath("productClassificationType"), String.class, getProductClassificationType(), this);
		processor.processBasic(path.newSubPath("productIdentificationType"), String.class, getProductIdentificationType(), this);
		processor.processBasic(path.newSubPath("productIdentification"), String.class, getProductIdentification(), this);
		processor.processBasic(path.newSubPath("euUnderlyingAssetId"), String.class, getEuUnderlyingAssetId(), this);
		processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
		processor.processBasic(path.newSubPath("tradeParty1BrokerIdType"), String.class, getTradeParty1BrokerIdType(), this);
		processor.processBasic(path.newSubPath("tradeParty2BrokerIdType"), String.class, getTradeParty2BrokerIdType(), this);
		processor.processBasic(path.newSubPath("tradeParty2ClearingBrokerIdType"), String.class, getTradeParty2ClearingBrokerIdType(), this);
		processor.processBasic(path.newSubPath("tradeParty2ClearingBrokerId"), String.class, getTradeParty2ClearingBrokerId(), this);
		processor.processBasic(path.newSubPath("tradeParty1ClearingThreshold"), Boolean.class, getTradeParty1ClearingThreshold(), this);
		processor.processBasic(path.newSubPath("tradeParty2ClearingThreshold"), Boolean.class, getTradeParty2ClearingThreshold(), this);
		processor.processBasic(path.newSubPath("tradeParty1CorporateSectorType"), String.class, getTradeParty1CorporateSectorType(), this);
		processor.processBasic(path.newSubPath("tradeParty2CorporateSectorType"), String.class, getTradeParty2CorporateSectorType(), this);
		processor.processBasic(path.newSubPath("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator"), String.class, getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), this);
		processor.processBasic(path.newSubPath("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator"), String.class, getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), this);
		processor.processBasic(path.newSubPath("intragroupIndicator"), Boolean.class, getIntragroupIndicator(), this);
		processor.processBasic(path.newSubPath("tradeParty1TradingCapacity1"), String.class, getTradeParty1TradingCapacity1(), this);
		processor.processBasic(path.newSubPath("tradeParty2TradingCapacity1"), String.class, getTradeParty2TradingCapacity1(), this);
		processor.processBasic(path.newSubPath("currencyOfPrice"), String.class, getCurrencyOfPrice(), this);
		processor.processBasic(path.newSubPath("tradeParty1CollateralPortfolio"), String.class, getTradeParty1CollateralPortfolio(), this);
		processor.processBasic(path.newSubPath("tradeParty2CollateralPortfolio"), String.class, getTradeParty2CollateralPortfolio(), this);
		processor.processBasic(path.newSubPath("executionVenueMicCode"), String.class, getExecutionVenueMicCode(), this);
		processor.processBasic(path.newSubPath("payment2Currency"), String.class, getPayment2Currency(), this);
		processor.processBasic(path.newSubPath("expirationDateTimeBusinessCenter"), String.class, getExpirationDateTimeBusinessCenter(), this);
		processor.processBasic(path.newSubPath("expirationTime"), LocalTime.class, getExpirationTime(), this);
		processor.processBasic(path.newSubPath("expirationTimeType"), String.class, getExpirationTimeType(), this);
		processor.processBasic(path.newSubPath("tradeParty1TraderLocation"), String.class, getTradeParty1TraderLocation(), this);
		processor.processBasic(path.newSubPath("tradeParty2TraderLocation"), String.class, getTradeParty2TraderLocation(), this);
		processor.processBasic(path.newSubPath("payment3ResetFrequencyPeriodMultiplier"), BigDecimal.class, getPayment3ResetFrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("payment3ResetFrequencyPeriod"), String.class, getPayment3ResetFrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment4ResetFrequencyPeriodMultiplier"), BigDecimal.class, getPayment4ResetFrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("payment4ResetFrequencyPeriod"), String.class, getPayment4ResetFrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment5ResetFrequencyPeriodMultiplier"), BigDecimal.class, getPayment5ResetFrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("payment5ResetFrequencyPeriod"), String.class, getPayment5ResetFrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment1Type"), String.class, getPayment1Type(), this);
		processor.processBasic(path.newSubPath("payment1Reference"), String.class, getPayment1Reference(), this);
		processor.processBasic(path.newSubPath("payment2Type"), String.class, getPayment2Type(), this);
		processor.processBasic(path.newSubPath("payment2Reference"), String.class, getPayment2Reference(), this);
		processor.processBasic(path.newSubPath("payment3Payer"), String.class, getPayment3Payer(), this);
		processor.processBasic(path.newSubPath("payment3Reference"), String.class, getPayment3Reference(), this);
		processor.processBasic(path.newSubPath("payment3FrequencyPeriod"), String.class, getPayment3FrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment3FrequencyPeriodMultiplier"), BigDecimal.class, getPayment3FrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("payment3Date"), Date.class, getPayment3Date(), this);
		processor.processBasic(path.newSubPath("payment4Reference"), String.class, getPayment4Reference(), this);
		processor.processBasic(path.newSubPath("payment4Payer"), String.class, getPayment4Payer(), this);
		processor.processBasic(path.newSubPath("payment4FrequencyPeriod"), String.class, getPayment4FrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment4FrequencyPeriodMultiplier"), BigDecimal.class, getPayment4FrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("payment4Date"), Date.class, getPayment4Date(), this);
		processor.processBasic(path.newSubPath("payment5Reference"), String.class, getPayment5Reference(), this);
		processor.processBasic(path.newSubPath("payment5Payer"), String.class, getPayment5Payer(), this);
		processor.processBasic(path.newSubPath("payment5FrequencyPeriod"), String.class, getPayment5FrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("payment5FrequencyPeriodMultiplier"), BigDecimal.class, getPayment5FrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("payment5Date"), Date.class, getPayment5Date(), this);
		processor.processBasic(path.newSubPath("payment3Type"), String.class, getPayment3Type(), this);
		processor.processBasic(path.newSubPath("premiumPayer"), String.class, getPremiumPayer(), this);
		processor.processBasic(path.newSubPath("premiumPaymentDateUnadjusted"), Date.class, getPremiumPaymentDateUnadjusted(), this);
		processor.processBasic(path.newSubPath("tradeParty1NatureOfTheReportingCounterparty"), String.class, getTradeParty1NatureOfTheReportingCounterparty(), this);
		processor.processBasic(path.newSubPath("tradeParty2NatureOfTheReportingCounterparty"), String.class, getTradeParty2NatureOfTheReportingCounterparty(), this);
		processor.processBasic(path.newSubPath("reservedParticipantUse1"), String.class, getReservedParticipantUse1(), this);
		processor.processBasic(path.newSubPath("reservedParticipantUse2"), String.class, getReservedParticipantUse2(), this);
		processor.processBasic(path.newSubPath("reservedParticipantUse3"), String.class, getReservedParticipantUse3(), this);
		processor.processBasic(path.newSubPath("reservedParticipantUse4"), String.class, getReservedParticipantUse4(), this);
		processor.processBasic(path.newSubPath("reservedParticipantUse5"), String.class, getReservedParticipantUse5(), this);
		processor.processBasic(path.newSubPath("leg1TerminationDate"), Date.class, getLeg1TerminationDate(), this);
		processor.processBasic(path.newSubPath("allocationType"), String.class, getAllocationType(), this);
		processor.processBasic(path.newSubPath("calculationBasis"), String.class, getCalculationBasis(), this);
		processor.processBasic(path.newSubPath("clearingExceptionPartyId"), String.class, getClearingExceptionPartyId(), this);
		processor.processBasic(path.newSubPath("clearingExceptionPartyIdType"), String.class, getClearingExceptionPartyIdType(), this);
		processor.processBasic(path.newSubPath("clearingExceptionType"), String.class, getClearingExceptionType(), this);
		processor.processBasic(path.newSubPath("clearingMemberClientAccountId"), String.class, getClearingMemberClientAccountId(), this);
		processor.processBasic(path.newSubPath("clearingReceiptDatetime"), ZonedDateTime.class, getClearingReceiptDatetime(), this);
		processor.processBasic(path.newSubPath("clearingSwapSdrLeiId"), String.class, getClearingSwapSdrLeiId(), this);
		processor.processBasic(path.newSubPath("clearingSwapUtiId"), String.class, getClearingSwapUtiId(), this);
		processor.processBasic(path.newSubPath("collateralReportingDate"), Date.class, getCollateralReportingDate(), this);
		processor.processBasic(path.newSubPath("collateralValuationDatetime"), ZonedDateTime.class, getCollateralValuationDatetime(), this);
		processor.processBasic(path.newSubPath("comment2"), String.class, getComment2(), this);
		processor.processBasic(path.newSubPath("commodityStrikePriceUnit"), String.class, getCommodityStrikePriceUnit(), this);
		processor.processBasic(path.newSubPath("executionAgentMaskingIndicator"), String.class, getExecutionAgentMaskingIndicator(), this);
		processor.processBasic(path.newSubPath("feeInCurrency"), String.class, getFeeInCurrency(), this);
		processor.processBasic(path.newSubPath("feeOutCurrency"), String.class, getFeeOutCurrency(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg1Multiplier"), BigDecimal.class, getFloatingRatePaymentFrequencyLeg1Multiplier(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg1TimePeriod"), String.class, getFloatingRatePaymentFrequencyLeg1TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg2Multiplier"), BigDecimal.class, getFloatingRatePaymentFrequencyLeg2Multiplier(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg2TimePeriod"), String.class, getFloatingRatePaymentFrequencyLeg2TimePeriod(), this);
		processor.processBasic(path.newSubPath("frequencyOfPayment"), String.class, getFrequencyOfPayment(), this);
		processor.processBasic(path.newSubPath("interaffiliate"), Boolean.class, getInteraffiliate(), this);
		processor.processBasic(path.newSubPath("largeTradeIndicator"), Boolean.class, getLargeTradeIndicator(), this);
		processor.processBasic(path.newSubPath("leg1EffectiveDateAdjusted"), Date.class, getLeg1EffectiveDateAdjusted(), this);
		processor.processBasic(path.newSubPath("leg1FinalValuationDate"), Date.class, getLeg1FinalValuationDate(), this);
		processor.processBasic(path.newSubPath("leg1SettlementPeriod"), String.class, getLeg1SettlementPeriod(), this);
		processor.processBasic(path.newSubPath("leg2EffectiveDateAdjusted"), Date.class, getLeg2EffectiveDateAdjusted(), this);
		processor.processBasic(path.newSubPath("leg2PaymentTermsFrequencyPeriod"), String.class, getLeg2PaymentTermsFrequencyPeriod(), this);
		processor.processBasic(path.newSubPath("leg2PaymentTermsPaymentFrequencyPeriodMultiplier"), BigDecimal.class, getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier(), this);
		processor.processBasic(path.newSubPath("leg2SettlementType"), String.class, getLeg2SettlementType(), this);
		processor.processBasic(path.newSubPath("leg2UnderlyingAssetId"), String.class, getLeg2UnderlyingAssetId(), this);
		processor.processBasic(path.newSubPath("leg2UnderlyingAssetIdType"), String.class, getLeg2UnderlyingAssetIdType(), this);
		processor.processBasic(path.newSubPath("leg2UnderlyingAssetName"), String.class, getLeg2UnderlyingAssetName(), this);
		processor.processBasic(path.newSubPath("maturityDate"), Date.class, getMaturityDate(), this);
		processor.processBasic(path.newSubPath("optionalEarlyTerminationDate"), String.class, getOptionalEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("optionCommodityCurrency"), String.class, getOptionCommodityCurrency(), this);
		processor.processBasic(path.newSubPath("optionCommodityExchangeId"), String.class, getOptionCommodityExchangeId(), this);
		processor.processBasic(path.newSubPath("optionCommodityInstrumentId"), String.class, getOptionCommodityInstrumentId(), this);
		processor.processBasic(path.newSubPath("optionCommodityRateSource"), String.class, getOptionCommodityRateSource(), this);
		processor.processBasic(path.newSubPath("optionCommodityRateSourcePage"), String.class, getOptionCommodityRateSourcePage(), this);
		processor.processBasic(path.newSubPath("optionCommodityUnderlyerDetails"), String.class, getOptionCommodityUnderlyerDetails(), this);
		processor.processBasic(path.newSubPath("optionCommodityUnderlyerId"), String.class, getOptionCommodityUnderlyerId(), this);
		processor.processBasic(path.newSubPath("optionCommodityUnitOfMeasure"), String.class, getOptionCommodityUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionSpecifiedPrice"), String.class, getOptionSpecifiedPrice(), this);
		processor.processBasic(path.newSubPath("optionSpreadAmount"), BigDecimal.class, getOptionSpreadAmount(), this);
		processor.processBasic(path.newSubPath("optionSpreadCurrency"), String.class, getOptionSpreadCurrency(), this);
		processor.processBasic(path.newSubPath("optionSpreadSchedule"), String.class, getOptionSpreadSchedule(), this);
		processor.processBasic(path.newSubPath("origin"), String.class, getOrigin(), this);
		processor.processBasic(path.newSubPath("originalSwapSdrId"), String.class, getOriginalSwapSdrId(), this);
		processor.processBasic(path.newSubPath("originalSwapSdrIdType"), String.class, getOriginalSwapSdrIdType(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg1"), String.class, getPaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg2"), String.class, getPaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg1"), BigDecimal.class, getPaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg2"), BigDecimal.class, getPaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("premiumPayerPrefix"), String.class, getPremiumPayerPrefix(), this);
		processor.processBasic(path.newSubPath("price1Currency"), String.class, getPrice1Currency(), this);
		processor.processBasic(path.newSubPath("price2Price"), BigDecimal.class, getPrice2Price(), this);
		processor.processBasic(path.newSubPath("price2Type"), String.class, getPrice2Type(), this);
		processor.processBasic(path.newSubPath("price2Units"), String.class, getPrice2Units(), this);
		processor.processBasic(path.newSubPath("price3Price"), BigDecimal.class, getPrice3Price(), this);
		processor.processBasic(path.newSubPath("price3Type"), String.class, getPrice3Type(), this);
		processor.processBasic(path.newSubPath("price3Units"), String.class, getPrice3Units(), this);
		processor.processBasic(path.newSubPath("price4Price"), BigDecimal.class, getPrice4Price(), this);
		processor.processBasic(path.newSubPath("price4Type"), String.class, getPrice4Type(), this);
		processor.processBasic(path.newSubPath("price4Units"), String.class, getPrice4Units(), this);
		processor.processBasic(path.newSubPath("pricingContext"), String.class, getPricingContext(), this);
		processor.processBasic(path.newSubPath("priorUsiType"), String.class, getPriorUsiType(), this);
		processor.processBasic(path.newSubPath("priorUtiType"), String.class, getPriorUtiType(), this);
		processor.processBasic(path.newSubPath("recoveryPrice"), BigDecimal.class, getRecoveryPrice(), this);
		processor.processBasic(path.newSubPath("sendToDataCenterCode"), String.class, getSendToDataCenterCode(), this);
		processor.processBasic(path.newSubPath("strikePriceType"), String.class, getStrikePriceType(), this);
		processor.processBasic(path.newSubPath("subAssetClassForOtherCommodity"), String.class, getSubAssetClassForOtherCommodity(), this);
		processor.processBasic(path.newSubPath("tradeParty1CftcFinancialEntityStatus"), String.class, getTradeParty1CftcFinancialEntityStatus(), this);
		processor.processBasic(path.newSubPath("tradeParty1CollateralAmount"), BigDecimal.class, getTradeParty1CollateralAmount(), this);
		processor.processBasic(path.newSubPath("tradeParty1CollateralCurrency"), String.class, getTradeParty1CollateralCurrency(), this);
		processor.processBasic(path.newSubPath("tradeParty1MandatoryDelegatedReporting"), String.class, getTradeParty1MandatoryDelegatedReporting(), this);
		processor.processBasic(path.newSubPath("tradeParty1Role"), String.class, getTradeParty1Role(), this);
		processor.processBasic(path.newSubPath("tradeParty2CftcFinancialEntityStatus"), String.class, getTradeParty2CftcFinancialEntityStatus(), this);
		processor.processBasic(path.newSubPath("tradeParty2CollateralAmount"), BigDecimal.class, getTradeParty2CollateralAmount(), this);
		processor.processBasic(path.newSubPath("tradeParty2CollateralCurrency"), String.class, getTradeParty2CollateralCurrency(), this);
		processor.processBasic(path.newSubPath("tradeParty2MandatoryDelegatedReporting"), String.class, getTradeParty2MandatoryDelegatedReporting(), this);
		processor.processBasic(path.newSubPath("tradeParty2Role"), String.class, getTradeParty2Role(), this);
		processor.processBasic(path.newSubPath("upfrontPayment"), BigDecimal.class, getUpfrontPayment(), this);
		processor.processBasic(path.newSubPath("verificationMethod"), String.class, getVerificationMethod(), this);
		processor.processBasic(path.newSubPath("responsibleDataSubmitterId"), String.class, getResponsibleDataSubmitterId(), this);
		processor.processBasic(path.newSubPath("responsibleDataSubmitterIdType"), String.class, getResponsibleDataSubmitterIdType(), this);
		processor.processBasic(path.newSubPath("originalSwapUsi"), String.class, getOriginalSwapUsi(), this);
		processor.processBasic(path.newSubPath("originalSwapUti"), String.class, getOriginalSwapUti(), this);
		processor.processBasic(path.newSubPath("cdeReceiverIdentifierLeg2"), String.class, getCdeReceiverIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("counterparty1FederalEntityIndicator"), Boolean.class, getCounterparty1FederalEntityIndicator(), this);
		processor.processBasic(path.newSubPath("counterparty2FederalEntityIndicator"), Boolean.class, getCounterparty2FederalEntityIndicator(), this);
		processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
		processor.processBasic(path.newSubPath("noaActionType"), String.class, getNoaActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
		processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("cdeCallAmountLeg1"), BigDecimal.class, getCdeCallAmountLeg1(), this);
		processor.processBasic(path.newSubPath("cdeCallAmountLeg2"), BigDecimal.class, getCdeCallAmountLeg2(), this);
		processor.processBasic(path.newSubPath("cdeCallCurrencyLeg1"), String.class, getCdeCallCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("cdeCallCurrencyLeg2"), String.class, getCdeCallCurrencyLeg2(), this);
		processor.processBasic(path.newSubPath("cdePutAmountLeg1"), BigDecimal.class, getCdePutAmountLeg1(), this);
		processor.processBasic(path.newSubPath("cdePutAmountLeg2"), BigDecimal.class, getCdePutAmountLeg2(), this);
		processor.processBasic(path.newSubPath("cdePutCurrencyLeg1"), String.class, getCdePutCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("cdePutCurrencyLeg2"), String.class, getCdePutCurrencyLeg2(), this);
		processor.processBasic(path.newSubPath("leg2QuantityFrequency"), String.class, getLeg2QuantityFrequency(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg1"), BigDecimal.class, getQuantityFrequencyMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg2"), BigDecimal.class, getQuantityFrequencyMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("cdeQuantityUnitOfMeasureLeg1"), String.class, getCdeQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("cdeQuantityUnitOfMeasureLeg2"), String.class, getCdeQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
		processor.processBasic(path.newSubPath("cdePackageIdentifier"), String.class, getCdePackageIdentifier(), this);
		processor.processBasic(path.newSubPath("cdePackageTransactionPrice"), BigDecimal.class, getCdePackageTransactionPrice(), this);
		processor.processBasic(path.newSubPath("cdePackageTransactionPriceCurrency"), String.class, getCdePackageTransactionPriceCurrency(), this);
		processor.processBasic(path.newSubPath("cdePackageTransactionPriceNotation"), String.class, getCdePackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("cdePackageTransactionSpread"), BigDecimal.class, getCdePackageTransactionSpread(), this);
		processor.processBasic(path.newSubPath("cdePackageTransactionSpreadCurrency"), String.class, getCdePackageTransactionSpreadCurrency(), this);
		processor.processBasic(path.newSubPath("cdePackageTransactionSpreadNotation"), String.class, getCdePackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("cdeFixedRateDayCountConventionLeg1"), String.class, getCdeFixedRateDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("cdeFixedRateDayCountConventionLeg2"), String.class, getCdeFixedRateDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("cdeFloatingRateDayCountConventionLeg1"), String.class, getCdeFloatingRateDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("cdeFloatingRateDayCountConventionLeg2"), String.class, getCdeFloatingRateDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("fixingDateLeg1"), Date.class, getFixingDateLeg1(), this);
		processor.processBasic(path.newSubPath("fixingDateLeg2"), Date.class, getFixingDateLeg2(), this);
		processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodLeg1"), String.class, getCdeFixedRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodLeg2"), String.class, getCdeFixedRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodLeg1"), String.class, getCdeFloatingRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodLeg2"), String.class, getCdeFloatingRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1"), BigDecimal.class, getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2"), BigDecimal.class, getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1"), BigDecimal.class, getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2"), BigDecimal.class, getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
		processor.processBasic(path.newSubPath("cdePriceCurrency"), String.class, getCdePriceCurrency(), this);
		processor.processBasic(path.newSubPath("cdePriceNotation"), String.class, getCdePriceNotation(), this);
		processor.processBasic(path.newSubPath("cdeSpreadNotationLeg1"), String.class, getCdeSpreadNotationLeg1(), this);
		processor.processBasic(path.newSubPath("cdeSpreadNotationLeg2"), String.class, getCdeSpreadNotationLeg2(), this);
		processor.processBasic(path.newSubPath("cdeStrikePriceCurrency2"), String.class, getCdeStrikePriceCurrency2(), this);
		processor.processBasic(path.newSubPath("cdeStrikePriceNotation"), String.class, getCdeStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("cdeFirstExerciseDate"), Date.class, getCdeFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("cdeFinalContractualSettlementDate"), Date.class, getCdeFinalContractualSettlementDate(), this);
		processor.processBasic(path.newSubPath("cdeSettlementLocationLeg1"), String.class, getCdeSettlementLocationLeg1(), this);
		processor.processBasic(path.newSubPath("cdeSettlementLocationLeg2"), String.class, getCdeSettlementLocationLeg2(), this);
		processor.processBasic(path.newSubPath("cdeEffectiveDate"), Date.class, getCdeEffectiveDate(), this);
		processor.processBasic(path.newSubPath("cdeExpirationDate"), Date.class, getCdeExpirationDate(), this);
		processor.processBasic(path.newSubPath("cdePlatformIdentifier"), String.class, getCdePlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
		processor.processBasic(path.newSubPath("swapReportingJurisdiction"), String.class, getSwapReportingJurisdiction(), this);
		processor.processBasic(path.newSubPath("newSdrIdentifier"), String.class, getNewSdrIdentifier(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
		processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, getLastFloatingReferenceValueLeg1(), this);
		processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, getLastFloatingReferenceResetDateLeg1(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
		processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, getLastFloatingReferenceValueLeg2(), this);
		processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, getLastFloatingReferenceResetDateLeg2(), this);
		processor.processBasic(path.newSubPath("cdeDelta"), BigDecimal.class, getCdeDelta(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("largeNotionalOffFacilitySwapElectionIndicator"), Boolean.class, getLargeNotionalOffFacilitySwapElectionIndicator(), this);
		processor.processBasic(path.newSubPath("sefOrDcmAnonymousExecutionIndicator"), Boolean.class, getSefOrDcmAnonymousExecutionIndicator(), this);
		processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
		processor.processBasic(path.newSubPath("sefOrDcmIndicator"), Boolean.class, getSefOrDcmIndicator(), this);
		processor.processBasic(path.newSubPath("mandatoryClearingIndicator"), Boolean.class, getMandatoryClearingIndicator(), this);
		processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty1"), Boolean.class, getSdMspIndicatorCounterparty1(), this);
		processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty2"), Boolean.class, getSdMspIndicatorCounterparty2(), this);
		processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, getPhysicalCommodityContractIndicator(), this);
		processor.processBasic(path.newSubPath("changeInNotionalAmount1"), BigDecimal.class, getChangeInNotionalAmount1(), this);
		processor.processBasic(path.newSubPath("changeInNotionalAmount2"), BigDecimal.class, getChangeInNotionalAmount2(), this);
		processor.processBasic(path.newSubPath("changeInLeg1NotionalQuantity"), BigDecimal.class, getChangeInLeg1NotionalQuantity(), this);
		processor.processBasic(path.newSubPath("changeInLeg2NotionalQuantity"), BigDecimal.class, getChangeInLeg2NotionalQuantity(), this);
		processor.processBasic(path.newSubPath("cdeCryptoAssetUnderlyingIndicatorLeg1"), Boolean.class, getCdeCryptoAssetUnderlyingIndicatorLeg1(), this);
		processor.processBasic(path.newSubPath("cdeCryptoAssetUnderlyingIndicatorLeg2"), Boolean.class, getCdeCryptoAssetUnderlyingIndicatorLeg2(), this);
		processor.processBasic(path.newSubPath("cdeCustomBasketCode"), String.class, getCdeCustomBasketCode(), this);
		processor.processBasic(path.newSubPath("underlierIdOtherLeg1"), String.class, getUnderlierIdOtherLeg1(), this);
		processor.processBasic(path.newSubPath("underlierIdOtherLeg2"), String.class, getUnderlierIdOtherLeg2(), this);
		processor.processBasic(path.newSubPath("underlierIdOtherSourceLeg1"), String.class, getUnderlierIdOtherSourceLeg1(), this);
		processor.processBasic(path.newSubPath("underlierIdOtherSourceLeg2"), String.class, getUnderlierIdOtherSourceLeg2(), this);
		processor.processBasic(path.newSubPath("cdeUnderlyingAssetTradingPlatformIdLeg1"), String.class, getCdeUnderlyingAssetTradingPlatformIdLeg1(), this);
		processor.processBasic(path.newSubPath("cdeUnderlyingAssetTradingPlatformIdLeg2"), String.class, getCdeUnderlyingAssetTradingPlatformIdLeg2(), this);
		processor.processBasic(path.newSubPath("cdeUnderlyingAssetPriceSourceLeg1"), String.class, getCdeUnderlyingAssetPriceSourceLeg1(), this);
		processor.processBasic(path.newSubPath("cdeUnderlyingAssetPriceSourceLeg2"), String.class, getCdeUnderlyingAssetPriceSourceLeg2(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface HarmonizedDataBuilder extends HarmonizedData, RosettaModelObjectBuilder {
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityInstrumentId(String leg2CommodityInstrumentId);
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityUnderlyerId(String leg2CommodityUnderlyerId);
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityUnderlyerDetails(String leg2CommodityUnderlyerDetails);
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityUnitOfMeasure(String leg2CommodityUnitOfMeasure);
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityCurrency(String leg2CommodityCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityExchangeId(String leg2CommodityExchangeId);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityRateSource(String leg1CommodityRateSource);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityRateSourcePage(String leg1CommodityRateSourcePage);
		HarmonizedData.HarmonizedDataBuilder setLeg2SpecifiedPrice(String leg2SpecifiedPrice);
		HarmonizedData.HarmonizedDataBuilder setCommencementDateUnadjusted(Date commencementDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setExerciseExpirationDateUnadjusted(Date exerciseExpirationDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setExpirationDateUnadjusted(Date expirationDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setLeg2NotionalQuantityFrequency(String leg2NotionalQuantityFrequency);
		HarmonizedData.HarmonizedDataBuilder setLeg2NotionalQuantity(BigDecimal leg2NotionalQuantity);
		HarmonizedData.HarmonizedDataBuilder setLeg2TotalNotionalQuantity(BigDecimal leg2TotalNotionalQuantity);
		HarmonizedData.HarmonizedDataBuilder setLeg2SpreadAmount(BigDecimal leg2SpreadAmount);
		HarmonizedData.HarmonizedDataBuilder setLeg2SpreadCurrency(String leg2SpreadCurrency);
		HarmonizedData.HarmonizedDataBuilder setScheduledTerminationDateAdjusted(Date scheduledTerminationDateAdjusted);
		HarmonizedData.HarmonizedDataBuilder setLeg1PartyPayer(String leg1PartyPayer);
		HarmonizedData.HarmonizedDataBuilder setLeg2PartyPayer(String leg2PartyPayer);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityInstrumentId(String leg1CommodityInstrumentId);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityUnderlyerId(String leg1CommodityUnderlyerId);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityUnitOfMeasure(String leg1CommodityUnitOfMeasure);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityExchangeId(String leg1CommodityExchangeId);
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityRateSource(String leg2CommodityRateSource);
		HarmonizedData.HarmonizedDataBuilder setLeg1EffectiveDateUnadjusted(Date leg1EffectiveDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setLeg2EffectiveDateUnadjusted(Date leg2EffectiveDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setCoProductType(String coProductType);
		HarmonizedData.HarmonizedDataBuilder setTotalQuantityUnit(String totalQuantityUnit);
		HarmonizedData.HarmonizedDataBuilder setTotalQuantity(BigDecimal totalQuantity);
		HarmonizedData.HarmonizedDataBuilder setFixedPrice(BigDecimal fixedPrice);
		HarmonizedData.HarmonizedDataBuilder setFixedPriceCurrency(String fixedPriceCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg1NotionalQuantityUnit(String leg1NotionalQuantityUnit);
		HarmonizedData.HarmonizedDataBuilder setLeg1NotionalQuantityFrequency(String leg1NotionalQuantityFrequency);
		HarmonizedData.HarmonizedDataBuilder setLeg1NotionalQuantity(BigDecimal leg1NotionalQuantity);
		HarmonizedData.HarmonizedDataBuilder setLeg1TotalNotionalQuantity(BigDecimal leg1TotalNotionalQuantity);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityCurrency(String leg1CommodityCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg1SpecifiedPrice(String leg1SpecifiedPrice);
		HarmonizedData.HarmonizedDataBuilder setLeg1SpreadCurrency(String leg1SpreadCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg1SpreadAmount(BigDecimal leg1SpreadAmount);
		HarmonizedData.HarmonizedDataBuilder setLeg2NotionalQuantityUnit(String leg2NotionalQuantityUnit);
		HarmonizedData.HarmonizedDataBuilder setLeg2PartyReceiver(String leg2PartyReceiver);
		HarmonizedData.HarmonizedDataBuilder setLeg1PartyReceiver(String leg1PartyReceiver);
		HarmonizedData.HarmonizedDataBuilder setCoalSource(String coalSource);
		HarmonizedData.HarmonizedDataBuilder setLeg2Quantity(BigDecimal leg2Quantity);
		HarmonizedData.HarmonizedDataBuilder setCommodityBase(String commodityBase);
		HarmonizedData.HarmonizedDataBuilder setCommodityDetails(String commodityDetails);
		HarmonizedData.HarmonizedDataBuilder setInterconnectionPoint(String interconnectionPoint);
		HarmonizedData.HarmonizedDataBuilder setLoadType(String loadType);
		HarmonizedData.HarmonizedDataBuilder setFixedPriceUnit(String fixedPriceUnit);
		HarmonizedData.HarmonizedDataBuilder setExercisePaymentDateUnadjusted(Date exercisePaymentDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setLeg1PaymentDatesUnadjusted(Date leg1PaymentDatesUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setLeg2PaymentDateUnadjusted(Date leg2PaymentDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setSettlementDateUnadjusted(Date settlementDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setDeliveryLocation(String deliveryLocation);
		HarmonizedData.HarmonizedDataBuilder setLeg2QuantityUnit(String leg2QuantityUnit);
		HarmonizedData.HarmonizedDataBuilder setLeg1CommodityUnderlyerDetails(String leg1CommodityUnderlyerDetails);
		HarmonizedData.HarmonizedDataBuilder setLeg2CommodityRateSourcePage(String leg2CommodityRateSourcePage);
		HarmonizedData.HarmonizedDataBuilder setValueDate(Date valueDate);
		HarmonizedData.HarmonizedDataBuilder setGtrQuantityUnit(String gtrQuantityUnit);
		HarmonizedData.HarmonizedDataBuilder setAttachmentPoint(BigDecimal attachmentPoint);
		HarmonizedData.HarmonizedDataBuilder setExhaustionPoint(BigDecimal exhaustionPoint);
		HarmonizedData.HarmonizedDataBuilder setMthToDefault(BigDecimal mthToDefault);
		HarmonizedData.HarmonizedDataBuilder setNthToDefault(BigDecimal nthToDefault);
		HarmonizedData.HarmonizedDataBuilder setSeniority(String seniority);
		HarmonizedData.HarmonizedDataBuilder setSeries(BigDecimal series);
		HarmonizedData.HarmonizedDataBuilder setCrversion(BigDecimal crversion);
		HarmonizedData.HarmonizedDataBuilder setTranche(String tranche);
		HarmonizedData.HarmonizedDataBuilder setIndexFactor(BigDecimal indexFactor);
		HarmonizedData.HarmonizedDataBuilder setReferenceObligation(String referenceObligation);
		HarmonizedData.HarmonizedDataBuilder setReferenceObligationIdType(String referenceObligationIdType);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingFixedRatePayerBuyer(String underlyingFixedRatePayerBuyer);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingFloatRatePayerSeller(String underlyingFloatRatePayerSeller);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetExchangeId(String underlyingAssetExchangeId);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetNumberOfUnits(BigDecimal underlyingAssetNumberOfUnits);
		HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationType(String optionalEarlyTerminationType);
		HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationElectingPartyValue(String optionalEarlyTerminationElectingPartyValue);
		HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationIndicator(Boolean optionalEarlyTerminationIndicator);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetFloatingAmountPayer(String underlyingAssetFloatingAmountPayer);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetFloatingAmountReceiver(String underlyingAssetFloatingAmountReceiver);
		HarmonizedData.HarmonizedDataBuilder setFloatingRateOption(String floatingRateOption);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetFloatingLegSpread(BigDecimal underlyingAssetFloatingLegSpread);
		HarmonizedData.HarmonizedDataBuilder setLeg2DesignatedMaturityPeriod(String leg2DesignatedMaturityPeriod);
		HarmonizedData.HarmonizedDataBuilder setLeg2DesignatedMaturityPeriodMultiplier(BigDecimal leg2DesignatedMaturityPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetEquityAmountPayer(String underlyingAssetEquityAmountPayer);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetEquityAmountReceiver(String underlyingAssetEquityAmountReceiver);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetInitialPriceCurrency(String underlyingAssetInitialPriceCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg1ValuationDates(Date leg1ValuationDates);
		HarmonizedData.HarmonizedDataBuilder setLeg1TypeOfReturn(String leg1TypeOfReturn);
		HarmonizedData.HarmonizedDataBuilder setObservationStartDate(Date observationStartDate);
		HarmonizedData.HarmonizedDataBuilder setVarianceAmount(BigDecimal varianceAmount);
		HarmonizedData.HarmonizedDataBuilder setVolatilityStrikePrice(BigDecimal volatilityStrikePrice);
		HarmonizedData.HarmonizedDataBuilder setVarianceStrikePrice(BigDecimal varianceStrikePrice);
		HarmonizedData.HarmonizedDataBuilder setVarianceCapFactor(BigDecimal varianceCapFactor);
		HarmonizedData.HarmonizedDataBuilder setReferenceCurrency(String referenceCurrency);
		HarmonizedData.HarmonizedDataBuilder setSpecialDividendsIndicator(String specialDividendsIndicator);
		HarmonizedData.HarmonizedDataBuilder setMaterialNoncashDividendIndicator(String materialNoncashDividendIndicator);
		HarmonizedData.HarmonizedDataBuilder setNumberOfSharesUnits(BigDecimal numberOfSharesUnits);
		HarmonizedData.HarmonizedDataBuilder setDividendAmountPayer(String dividendAmountPayer);
		HarmonizedData.HarmonizedDataBuilder setDividendAmountReceiver(String dividendAmountReceiver);
		HarmonizedData.HarmonizedDataBuilder setFixedAmountPayer(String fixedAmountPayer);
		HarmonizedData.HarmonizedDataBuilder setFixedAmountReceiver(String fixedAmountReceiver);
		HarmonizedData.HarmonizedDataBuilder setKnockInEvent(String knockInEvent);
		HarmonizedData.HarmonizedDataBuilder setKnockOutEvent(String knockOutEvent);
		HarmonizedData.HarmonizedDataBuilder setKnockInPrice(BigDecimal knockInPrice);
		HarmonizedData.HarmonizedDataBuilder setKnockOutPrice(BigDecimal knockOutPrice);
		HarmonizedData.HarmonizedDataBuilder setBarrierType(String barrierType);
		HarmonizedData.HarmonizedDataBuilder setEarliestExecutionTime(LocalTime earliestExecutionTime);
		HarmonizedData.HarmonizedDataBuilder setExchangeRate(BigDecimal exchangeRate);
		HarmonizedData.HarmonizedDataBuilder setExchangeRateBasisCurrency1(String exchangeRateBasisCurrency1);
		HarmonizedData.HarmonizedDataBuilder setExchangeRateBasisCurrency2(String exchangeRateBasisCurrency2);
		HarmonizedData.HarmonizedDataBuilder setExecutionPeriodStartDate(Date executionPeriodStartDate);
		HarmonizedData.HarmonizedDataBuilder setPayoutStyle(String payoutStyle);
		HarmonizedData.HarmonizedDataBuilder setRateQuoteBasis1(String rateQuoteBasis1);
		HarmonizedData.HarmonizedDataBuilder setSettlementFixingDate(Date settlementFixingDate);
		HarmonizedData.HarmonizedDataBuilder setSwapLinkId(String swapLinkId);
		HarmonizedData.HarmonizedDataBuilder setTriggerCondition(String triggerCondition);
		HarmonizedData.HarmonizedDataBuilder setTriggerCondition2(String triggerCondition2);
		HarmonizedData.HarmonizedDataBuilder setTriggerRate(BigDecimal triggerRate);
		HarmonizedData.HarmonizedDataBuilder setTriggerRate2(BigDecimal triggerRate2);
		HarmonizedData.HarmonizedDataBuilder setRateQuoteBasis2(String rateQuoteBasis2);
		HarmonizedData.HarmonizedDataBuilder setForwardExchangeRate(BigDecimal forwardExchangeRate);
		HarmonizedData.HarmonizedDataBuilder setBarrierType2(String barrierType2);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionBuyer(String cancelationOptionBuyer);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionCommencementDate(Date cancelationOptionCommencementDate);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionExerciseStyleType(String cancelationOptionExerciseStyleType);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionExpirationDate(Date cancelationOptionExpirationDate);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionInitialFeeCurrency(String cancelationOptionInitialFeeCurrency);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionInitialFeePayer(String cancelationOptionInitialFeePayer);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionPremiumAmount(BigDecimal cancelationOptionPremiumAmount);
		HarmonizedData.HarmonizedDataBuilder setCancelationOptionSeller(String cancelationOptionSeller);
		HarmonizedData.HarmonizedDataBuilder setCapRateInitial(BigDecimal capRateInitial);
		HarmonizedData.HarmonizedDataBuilder setCouponType(String couponType);
		HarmonizedData.HarmonizedDataBuilder setFinalPrincipalExchangeIndicatorAtTermination(Boolean finalPrincipalExchangeIndicatorAtTermination);
		HarmonizedData.HarmonizedDataBuilder setFloorRateInitial(BigDecimal floorRateInitial);
		HarmonizedData.HarmonizedDataBuilder setFraDiscountingType(String fraDiscountingType);
		HarmonizedData.HarmonizedDataBuilder setInflationIndexInitialLevel(BigDecimal inflationIndexInitialLevel);
		HarmonizedData.HarmonizedDataBuilder setInflationIndexMainPublication(String inflationIndexMainPublication);
		HarmonizedData.HarmonizedDataBuilder setInflationInterpolationMethod(String inflationInterpolationMethod);
		HarmonizedData.HarmonizedDataBuilder setInflationLagDayType(String inflationLagDayType);
		HarmonizedData.HarmonizedDataBuilder setInflationLagPeriod(String inflationLagPeriod);
		HarmonizedData.HarmonizedDataBuilder setInflationRateSourceName(String inflationRateSourceName);
		HarmonizedData.HarmonizedDataBuilder setInitialPrincipalExchangeIndicator(Boolean initialPrincipalExchangeIndicator);
		HarmonizedData.HarmonizedDataBuilder setIntermediatePrincipalExchangeIndicator(Boolean intermediatePrincipalExchangeIndicator);
		HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateIndex(String leg1FloatingRateIndex);
		HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateInitialSpread(BigDecimal leg1FloatingRateInitialSpread);
		HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateMultiplierInitialValue(BigDecimal leg1FloatingRateMultiplierInitialValue);
		HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateTenorPeriod(String leg1FloatingRateTenorPeriod);
		HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateTenorPeriodMultiplier(BigDecimal leg1FloatingRateTenorPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setLeg1KnownAmount(BigDecimal leg1KnownAmount);
		HarmonizedData.HarmonizedDataBuilder setLeg1KnownAmountCurrency(String leg1KnownAmountCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg1ReferenceCurrency(String leg1ReferenceCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateIndex(String leg2FloatingRateIndex);
		HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateInitialSpread(BigDecimal leg2FloatingRateInitialSpread);
		HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateMultiplierInitialValue(BigDecimal leg2FloatingRateMultiplierInitialValue);
		HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateTenorPeriod(String leg2FloatingRateTenorPeriod);
		HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateTenorPeriodMultiplier(BigDecimal leg2FloatingRateTenorPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setLeg2KnownAmount(BigDecimal leg2KnownAmount);
		HarmonizedData.HarmonizedDataBuilder setLeg2KnownAmountCurrency(String leg2KnownAmountCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg2ReferenceCurrency(String leg2ReferenceCurrency);
		HarmonizedData.HarmonizedDataBuilder setMandatoryEarlyTerminationDate(Date mandatoryEarlyTerminationDate);
		HarmonizedData.HarmonizedDataBuilder setMandatoryEarlyTerminationDateTenorPeriod(String mandatoryEarlyTerminationDateTenorPeriod);
		HarmonizedData.HarmonizedDataBuilder setMandatoryEarlyTerminationDateTenorPeriodMultiplier(String mandatoryEarlyTerminationDateTenorPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setNotionalUnits(BigDecimal notionalUnits);
		HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationCommencementDate(Date optionalEarlyTerminationCommencementDate);
		HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationExerciseStyle(String optionalEarlyTerminationExerciseStyle);
		HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationExpirationDate(Date optionalEarlyTerminationExpirationDate);
		HarmonizedData.HarmonizedDataBuilder setPremiumReceiver(String premiumReceiver);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingCouponRate(BigDecimal underlyingCouponRate);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingMaturityDate(Date underlyingMaturityDate);
		HarmonizedData.HarmonizedDataBuilder setUnderlyingProductId(String underlyingProductId);
		HarmonizedData.HarmonizedDataBuilder setInflationLagPeriodMultiplier(String inflationLagPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setLeg1FixedRateNotation(String leg1FixedRateNotation);
		HarmonizedData.HarmonizedDataBuilder setLeg2FixedRateNotation(String leg2FixedRateNotation);
		HarmonizedData.HarmonizedDataBuilder setSwaptionStraddleIndicator(String swaptionStraddleIndicator);
		HarmonizedData.HarmonizedDataBuilder setSinglePartyEarlyTerminationBuyer(String singlePartyEarlyTerminationBuyer);
		HarmonizedData.HarmonizedDataBuilder setLeg1EffectiveDate(Date leg1EffectiveDate);
		HarmonizedData.HarmonizedDataBuilder setAction(String action);
		HarmonizedData.HarmonizedDataBuilder setClearingStatus(String clearingStatus);
		HarmonizedData.HarmonizedDataBuilder setEffectiveDate1(Date effectiveDate1);
		HarmonizedData.HarmonizedDataBuilder setExecutionVenueType(String executionVenueType);
		HarmonizedData.HarmonizedDataBuilder setNonStandardTradeIndicator(Boolean nonStandardTradeIndicator);
		HarmonizedData.HarmonizedDataBuilder setNotionalAmount1(BigDecimal notionalAmount1);
		HarmonizedData.HarmonizedDataBuilder setNotionalCurrency1(String notionalCurrency1);
		HarmonizedData.HarmonizedDataBuilder setPrice1Price(BigDecimal price1Price);
		HarmonizedData.HarmonizedDataBuilder setPrice1Type(String price1Type);
		HarmonizedData.HarmonizedDataBuilder setPrice1Units(String price1Units);
		HarmonizedData.HarmonizedDataBuilder setScheduledTerminationDate1(Date scheduledTerminationDate1);
		HarmonizedData.HarmonizedDataBuilder setTradeDate(Date tradeDate);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralizationType(String tradeParty1CollateralizationType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1EventId(String tradeParty1EventId);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralizationType(String tradeParty2CollateralizationType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2EventId(String tradeParty2EventId);
		HarmonizedData.HarmonizedDataBuilder setEmbeddedOptionOnSwap(String embeddedOptionOnSwap);
		HarmonizedData.HarmonizedDataBuilder setExpirationDate(Date expirationDate);
		HarmonizedData.HarmonizedDataBuilder setNotionalAmount2(BigDecimal notionalAmount2);
		HarmonizedData.HarmonizedDataBuilder setNotionalCurrency2(String notionalCurrency2);
		HarmonizedData.HarmonizedDataBuilder setPremiumAmount(BigDecimal premiumAmount);
		HarmonizedData.HarmonizedDataBuilder setPremiumCurrency(String premiumCurrency);
		HarmonizedData.HarmonizedDataBuilder setVersion(String version);
		HarmonizedData.HarmonizedDataBuilder setComment1(String comment1);
		HarmonizedData.HarmonizedDataBuilder setOptionStyle(String optionStyle);
		HarmonizedData.HarmonizedDataBuilder setOptionType(String optionType);
		HarmonizedData.HarmonizedDataBuilder setSettlementCurrency1(String settlementCurrency1);
		HarmonizedData.HarmonizedDataBuilder setCommencementDate(Date commencementDate);
		HarmonizedData.HarmonizedDataBuilder setDayCountFraction1(String dayCountFraction1);
		HarmonizedData.HarmonizedDataBuilder setLeg2DayCountFraction(String leg2DayCountFraction);
		HarmonizedData.HarmonizedDataBuilder setLeg2EffectiveDate(Date leg2EffectiveDate);
		HarmonizedData.HarmonizedDataBuilder setLeg2ResetFrequencyPeriod(String leg2ResetFrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setLeg2ResetFrequencyPeriodMultiplier(BigDecimal leg2ResetFrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setLeg2SettlementCurrency(String leg2SettlementCurrency);
		HarmonizedData.HarmonizedDataBuilder setLeg2ScheduledTerminationDate(Date leg2ScheduledTerminationDate);
		HarmonizedData.HarmonizedDataBuilder setNumberOfOptions(BigDecimal numberOfOptions);
		HarmonizedData.HarmonizedDataBuilder setOptionEntitlement(BigDecimal optionEntitlement);
		HarmonizedData.HarmonizedDataBuilder setOriginalExecutionTimestamp(ZonedDateTime originalExecutionTimestamp);
		HarmonizedData.HarmonizedDataBuilder setPayment1Date(Date payment1Date);
		HarmonizedData.HarmonizedDataBuilder setPayment1FrequencyPeriod(String payment1FrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment1FrequencyPeriodMultiplier(BigDecimal payment1FrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setPayment2Date(Date payment2Date);
		HarmonizedData.HarmonizedDataBuilder setPayment2FrequencyPeriod(String payment2FrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment2FrequencyPeriodMultiplier(BigDecimal payment2FrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setResetFrequencyPeriod1(String resetFrequencyPeriod1);
		HarmonizedData.HarmonizedDataBuilder setResetFrequencyPeriodMultiplier1(BigDecimal resetFrequencyPeriodMultiplier1);
		HarmonizedData.HarmonizedDataBuilder setSettlementDate(Date settlementDate);
		HarmonizedData.HarmonizedDataBuilder setStrikePrice(BigDecimal strikePrice);
		HarmonizedData.HarmonizedDataBuilder setStrikePriceUnits(String strikePriceUnits);
		HarmonizedData.HarmonizedDataBuilder setAsOfDateTime(ZonedDateTime asOfDateTime);
		HarmonizedData.HarmonizedDataBuilder setClearingVenueId(String clearingVenueId);
		HarmonizedData.HarmonizedDataBuilder setClearingVenueIdType(String clearingVenueIdType);
		HarmonizedData.HarmonizedDataBuilder setCompressedTradeIndicator(String compressedTradeIndicator);
		HarmonizedData.HarmonizedDataBuilder setConfirmationMethod(String confirmationMethod);
		HarmonizedData.HarmonizedDataBuilder setConfirmationPlatformId(String confirmationPlatformId);
		HarmonizedData.HarmonizedDataBuilder setConfirmationPlatformTradeId(String confirmationPlatformTradeId);
		HarmonizedData.HarmonizedDataBuilder setExecutionVenueId(String executionVenueId);
		HarmonizedData.HarmonizedDataBuilder setExecutionVenueIdType(String executionVenueIdType);
		HarmonizedData.HarmonizedDataBuilder setPostTradeEffectiveDate(Date postTradeEffectiveDate);
		HarmonizedData.HarmonizedDataBuilder setPriorUsiId(String priorUsiId);
		HarmonizedData.HarmonizedDataBuilder setPriorUsiIdPrefix(String priorUsiIdPrefix);
		HarmonizedData.HarmonizedDataBuilder setPriorUtiId(String priorUtiId);
		HarmonizedData.HarmonizedDataBuilder setPriorUtiIdPrefix(String priorUtiIdPrefix);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1BranchLocation(String tradeParty1BranchLocation);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1ClearingBrokerId(String tradeParty1ClearingBrokerId);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1ClearingBrokerIdType(String tradeParty1ClearingBrokerIdType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1DeskLocation(String tradeParty1DeskLocation);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1Domicile(String tradeParty1Domicile);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1IndustrialSectorType(String tradeParty1IndustrialSectorType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2BranchLocation(String tradeParty2BranchLocation);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2DeskLocation(String tradeParty2DeskLocation);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2Domicile(String tradeParty2Domicile);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2IndustrialSectorType(String tradeParty2IndustrialSectorType);
		HarmonizedData.HarmonizedDataBuilder setSellerPayer2(String sellerPayer2);
		HarmonizedData.HarmonizedDataBuilder setBuyerPayer1(String buyerPayer1);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1HkCounterpartyOrigin(String tradeParty1HkCounterpartyOrigin);
		HarmonizedData.HarmonizedDataBuilder setLeg2SettlementDate(Date leg2SettlementDate);
		HarmonizedData.HarmonizedDataBuilder setLeg1FixedRateInitial(BigDecimal leg1FixedRateInitial);
		HarmonizedData.HarmonizedDataBuilder setLeg2FixedRateInitial(BigDecimal leg2FixedRateInitial);
		HarmonizedData.HarmonizedDataBuilder setPayment1Amount(BigDecimal payment1Amount);
		HarmonizedData.HarmonizedDataBuilder setPayment1Currency(String payment1Currency);
		HarmonizedData.HarmonizedDataBuilder setPayment1Payer(String payment1Payer);
		HarmonizedData.HarmonizedDataBuilder setPayment1Receiver(String payment1Receiver);
		HarmonizedData.HarmonizedDataBuilder setPayment2Payer(String payment2Payer);
		HarmonizedData.HarmonizedDataBuilder setPostTradeTransactionDate(Date postTradeTransactionDate);
		HarmonizedData.HarmonizedDataBuilder setSecondaryAssetClass(String secondaryAssetClass);
		HarmonizedData.HarmonizedDataBuilder setSettlementType(String settlementType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1Name(String tradeParty1Name);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2Name(String tradeParty2Name);
		HarmonizedData.HarmonizedDataBuilder setCcpValuationAmount(BigDecimal ccpValuationAmount);
		HarmonizedData.HarmonizedDataBuilder setCcpValuationCurrency(String ccpValuationCurrency);
		HarmonizedData.HarmonizedDataBuilder setCcpValuationDatetime(ZonedDateTime ccpValuationDatetime);
		HarmonizedData.HarmonizedDataBuilder setCcpValuationType(String ccpValuationType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationAmount(BigDecimal tradeParty1ValuationAmount);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationCurrency(String tradeParty1ValuationCurrency);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationDatetime(ZonedDateTime tradeParty1ValuationDatetime);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationType(String tradeParty1ValuationType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationAmount(BigDecimal tradeParty2ValuationAmount);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationCurrency(String tradeParty2ValuationCurrency);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationDatetime(ZonedDateTime tradeParty2ValuationDatetime);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationType(String tradeParty2ValuationType);
		HarmonizedData.HarmonizedDataBuilder setExecutionType(String executionType);
		HarmonizedData.HarmonizedDataBuilder setStrikePriceCurrency(String strikePriceCurrency);
		HarmonizedData.HarmonizedDataBuilder setPayment2Amount(BigDecimal payment2Amount);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2HkCounterpartyOrigin(String tradeParty2HkCounterpartyOrigin);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CountryOfTheOtherCounterparty(String tradeParty1CountryOfTheOtherCounterparty);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CountryOfTheOtherCounterparty(String tradeParty2CountryOfTheOtherCounterparty);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1BrokerId(String tradeParty1BrokerId);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2BrokerId(String tradeParty2BrokerId);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1BeneficiaryIdType(String tradeParty1BeneficiaryIdType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1BeneficiaryId(String tradeParty1BeneficiaryId);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2BeneficiaryIdType(String tradeParty2BeneficiaryIdType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2BeneficiaryId(String tradeParty2BeneficiaryId);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CounterpartySide(String tradeParty1CounterpartySide);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CounterpartySide(String tradeParty2CounterpartySide);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralPortfolioCode(String tradeParty1CollateralPortfolioCode);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralPortfolioCode(String tradeParty2CollateralPortfolioCode);
		HarmonizedData.HarmonizedDataBuilder setContractType(String contractType);
		HarmonizedData.HarmonizedDataBuilder setEuUnderlyingAssetIdType(String euUnderlyingAssetIdType);
		HarmonizedData.HarmonizedDataBuilder setProductClassification(String productClassification);
		HarmonizedData.HarmonizedDataBuilder setComplexTradeComponentId(String complexTradeComponentId);
		HarmonizedData.HarmonizedDataBuilder setPriceMultiplier(BigDecimal priceMultiplier);
		HarmonizedData.HarmonizedDataBuilder setQuantity(BigDecimal quantity);
		HarmonizedData.HarmonizedDataBuilder setMasterAgreementType(String masterAgreementType);
		HarmonizedData.HarmonizedDataBuilder setMasterAgreementVersion(String masterAgreementVersion);
		HarmonizedData.HarmonizedDataBuilder setConfirmationDatetime(ZonedDateTime confirmationDatetime);
		HarmonizedData.HarmonizedDataBuilder setClearingDatetime(ZonedDateTime clearingDatetime);
		HarmonizedData.HarmonizedDataBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		HarmonizedData.HarmonizedDataBuilder setLevel(String level);
		HarmonizedData.HarmonizedDataBuilder setProductClassificationType(String productClassificationType);
		HarmonizedData.HarmonizedDataBuilder setProductIdentificationType(String productIdentificationType);
		HarmonizedData.HarmonizedDataBuilder setProductIdentification(String productIdentification);
		HarmonizedData.HarmonizedDataBuilder setEuUnderlyingAssetId(String euUnderlyingAssetId);
		HarmonizedData.HarmonizedDataBuilder setReportTrackingNumber(String reportTrackingNumber);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1BrokerIdType(String tradeParty1BrokerIdType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2BrokerIdType(String tradeParty2BrokerIdType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2ClearingBrokerIdType(String tradeParty2ClearingBrokerIdType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2ClearingBrokerId(String tradeParty2ClearingBrokerId);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1ClearingThreshold(Boolean tradeParty1ClearingThreshold);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2ClearingThreshold(Boolean tradeParty2ClearingThreshold);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CorporateSectorType(String tradeParty1CorporateSectorType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CorporateSectorType(String tradeParty2CorporateSectorType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(String tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(String tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator);
		HarmonizedData.HarmonizedDataBuilder setIntragroupIndicator(Boolean intragroupIndicator);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1TradingCapacity1(String tradeParty1TradingCapacity1);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2TradingCapacity1(String tradeParty2TradingCapacity1);
		HarmonizedData.HarmonizedDataBuilder setCurrencyOfPrice(String currencyOfPrice);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralPortfolio(String tradeParty1CollateralPortfolio);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralPortfolio(String tradeParty2CollateralPortfolio);
		HarmonizedData.HarmonizedDataBuilder setExecutionVenueMicCode(String executionVenueMicCode);
		HarmonizedData.HarmonizedDataBuilder setPayment2Currency(String payment2Currency);
		HarmonizedData.HarmonizedDataBuilder setExpirationDateTimeBusinessCenter(String expirationDateTimeBusinessCenter);
		HarmonizedData.HarmonizedDataBuilder setExpirationTime(LocalTime expirationTime);
		HarmonizedData.HarmonizedDataBuilder setExpirationTimeType(String expirationTimeType);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1TraderLocation(String tradeParty1TraderLocation);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2TraderLocation(String tradeParty2TraderLocation);
		HarmonizedData.HarmonizedDataBuilder setPayment3ResetFrequencyPeriodMultiplier(BigDecimal payment3ResetFrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setPayment3ResetFrequencyPeriod(String payment3ResetFrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment4ResetFrequencyPeriodMultiplier(BigDecimal payment4ResetFrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setPayment4ResetFrequencyPeriod(String payment4ResetFrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment5ResetFrequencyPeriodMultiplier(BigDecimal payment5ResetFrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setPayment5ResetFrequencyPeriod(String payment5ResetFrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment1Type(String payment1Type);
		HarmonizedData.HarmonizedDataBuilder setPayment1Reference(String payment1Reference);
		HarmonizedData.HarmonizedDataBuilder setPayment2Type(String payment2Type);
		HarmonizedData.HarmonizedDataBuilder setPayment2Reference(String payment2Reference);
		HarmonizedData.HarmonizedDataBuilder setPayment3Payer(String payment3Payer);
		HarmonizedData.HarmonizedDataBuilder setPayment3Reference(String payment3Reference);
		HarmonizedData.HarmonizedDataBuilder setPayment3FrequencyPeriod(String payment3FrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment3FrequencyPeriodMultiplier(BigDecimal payment3FrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setPayment3Date(Date payment3Date);
		HarmonizedData.HarmonizedDataBuilder setPayment4Reference(String payment4Reference);
		HarmonizedData.HarmonizedDataBuilder setPayment4Payer(String payment4Payer);
		HarmonizedData.HarmonizedDataBuilder setPayment4FrequencyPeriod(String payment4FrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment4FrequencyPeriodMultiplier(BigDecimal payment4FrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setPayment4Date(Date payment4Date);
		HarmonizedData.HarmonizedDataBuilder setPayment5Reference(String payment5Reference);
		HarmonizedData.HarmonizedDataBuilder setPayment5Payer(String payment5Payer);
		HarmonizedData.HarmonizedDataBuilder setPayment5FrequencyPeriod(String payment5FrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setPayment5FrequencyPeriodMultiplier(BigDecimal payment5FrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setPayment5Date(Date payment5Date);
		HarmonizedData.HarmonizedDataBuilder setPayment3Type(String payment3Type);
		HarmonizedData.HarmonizedDataBuilder setPremiumPayer(String premiumPayer);
		HarmonizedData.HarmonizedDataBuilder setPremiumPaymentDateUnadjusted(Date premiumPaymentDateUnadjusted);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1NatureOfTheReportingCounterparty(String tradeParty1NatureOfTheReportingCounterparty);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2NatureOfTheReportingCounterparty(String tradeParty2NatureOfTheReportingCounterparty);
		HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse1(String reservedParticipantUse1);
		HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse2(String reservedParticipantUse2);
		HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse3(String reservedParticipantUse3);
		HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse4(String reservedParticipantUse4);
		HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse5(String reservedParticipantUse5);
		HarmonizedData.HarmonizedDataBuilder setLeg1TerminationDate(Date leg1TerminationDate);
		HarmonizedData.HarmonizedDataBuilder setAllocationType(String allocationType);
		HarmonizedData.HarmonizedDataBuilder setCalculationBasis(String calculationBasis);
		HarmonizedData.HarmonizedDataBuilder setClearingExceptionPartyId(String clearingExceptionPartyId);
		HarmonizedData.HarmonizedDataBuilder setClearingExceptionPartyIdType(String clearingExceptionPartyIdType);
		HarmonizedData.HarmonizedDataBuilder setClearingExceptionType(String clearingExceptionType);
		HarmonizedData.HarmonizedDataBuilder setClearingMemberClientAccountId(String clearingMemberClientAccountId);
		HarmonizedData.HarmonizedDataBuilder setClearingReceiptDatetime(ZonedDateTime clearingReceiptDatetime);
		HarmonizedData.HarmonizedDataBuilder setClearingSwapSdrLeiId(String clearingSwapSdrLeiId);
		HarmonizedData.HarmonizedDataBuilder setClearingSwapUtiId(String clearingSwapUtiId);
		HarmonizedData.HarmonizedDataBuilder setCollateralReportingDate(Date collateralReportingDate);
		HarmonizedData.HarmonizedDataBuilder setCollateralValuationDatetime(ZonedDateTime collateralValuationDatetime);
		HarmonizedData.HarmonizedDataBuilder setComment2(String comment2);
		HarmonizedData.HarmonizedDataBuilder setCommodityStrikePriceUnit(String commodityStrikePriceUnit);
		HarmonizedData.HarmonizedDataBuilder setExecutionAgentMaskingIndicator(String executionAgentMaskingIndicator);
		HarmonizedData.HarmonizedDataBuilder setFeeInCurrency(String feeInCurrency);
		HarmonizedData.HarmonizedDataBuilder setFeeOutCurrency(String feeOutCurrency);
		HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg1Multiplier(BigDecimal floatingRatePaymentFrequencyLeg1Multiplier);
		HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg1TimePeriod(String floatingRatePaymentFrequencyLeg1TimePeriod);
		HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg2Multiplier(BigDecimal floatingRatePaymentFrequencyLeg2Multiplier);
		HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg2TimePeriod(String floatingRatePaymentFrequencyLeg2TimePeriod);
		HarmonizedData.HarmonizedDataBuilder setFrequencyOfPayment(String frequencyOfPayment);
		HarmonizedData.HarmonizedDataBuilder setInteraffiliate(Boolean interaffiliate);
		HarmonizedData.HarmonizedDataBuilder setLargeTradeIndicator(Boolean largeTradeIndicator);
		HarmonizedData.HarmonizedDataBuilder setLeg1EffectiveDateAdjusted(Date leg1EffectiveDateAdjusted);
		HarmonizedData.HarmonizedDataBuilder setLeg1FinalValuationDate(Date leg1FinalValuationDate);
		HarmonizedData.HarmonizedDataBuilder setLeg1SettlementPeriod(String leg1SettlementPeriod);
		HarmonizedData.HarmonizedDataBuilder setLeg2EffectiveDateAdjusted(Date leg2EffectiveDateAdjusted);
		HarmonizedData.HarmonizedDataBuilder setLeg2PaymentTermsFrequencyPeriod(String leg2PaymentTermsFrequencyPeriod);
		HarmonizedData.HarmonizedDataBuilder setLeg2PaymentTermsPaymentFrequencyPeriodMultiplier(BigDecimal leg2PaymentTermsPaymentFrequencyPeriodMultiplier);
		HarmonizedData.HarmonizedDataBuilder setLeg2SettlementType(String leg2SettlementType);
		HarmonizedData.HarmonizedDataBuilder setLeg2UnderlyingAssetId(String leg2UnderlyingAssetId);
		HarmonizedData.HarmonizedDataBuilder setLeg2UnderlyingAssetIdType(String leg2UnderlyingAssetIdType);
		HarmonizedData.HarmonizedDataBuilder setLeg2UnderlyingAssetName(String leg2UnderlyingAssetName);
		HarmonizedData.HarmonizedDataBuilder setMaturityDate(Date maturityDate);
		HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationDate(String optionalEarlyTerminationDate);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityCurrency(String optionCommodityCurrency);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityExchangeId(String optionCommodityExchangeId);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityInstrumentId(String optionCommodityInstrumentId);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityRateSource(String optionCommodityRateSource);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityRateSourcePage(String optionCommodityRateSourcePage);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityUnderlyerDetails(String optionCommodityUnderlyerDetails);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityUnderlyerId(String optionCommodityUnderlyerId);
		HarmonizedData.HarmonizedDataBuilder setOptionCommodityUnitOfMeasure(String optionCommodityUnitOfMeasure);
		HarmonizedData.HarmonizedDataBuilder setOptionSpecifiedPrice(String optionSpecifiedPrice);
		HarmonizedData.HarmonizedDataBuilder setOptionSpreadAmount(BigDecimal optionSpreadAmount);
		HarmonizedData.HarmonizedDataBuilder setOptionSpreadCurrency(String optionSpreadCurrency);
		HarmonizedData.HarmonizedDataBuilder setOptionSpreadSchedule(String optionSpreadSchedule);
		HarmonizedData.HarmonizedDataBuilder setOrigin(String origin);
		HarmonizedData.HarmonizedDataBuilder setOriginalSwapSdrId(String originalSwapSdrId);
		HarmonizedData.HarmonizedDataBuilder setOriginalSwapSdrIdType(String originalSwapSdrIdType);
		HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodLeg1(String paymentFrequencyPeriodLeg1);
		HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodLeg2(String paymentFrequencyPeriodLeg2);
		HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodMultiplierLeg1(BigDecimal paymentFrequencyPeriodMultiplierLeg1);
		HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodMultiplierLeg2(BigDecimal paymentFrequencyPeriodMultiplierLeg2);
		HarmonizedData.HarmonizedDataBuilder setPremiumPayerPrefix(String premiumPayerPrefix);
		HarmonizedData.HarmonizedDataBuilder setPrice1Currency(String price1Currency);
		HarmonizedData.HarmonizedDataBuilder setPrice2Price(BigDecimal price2Price);
		HarmonizedData.HarmonizedDataBuilder setPrice2Type(String price2Type);
		HarmonizedData.HarmonizedDataBuilder setPrice2Units(String price2Units);
		HarmonizedData.HarmonizedDataBuilder setPrice3Price(BigDecimal price3Price);
		HarmonizedData.HarmonizedDataBuilder setPrice3Type(String price3Type);
		HarmonizedData.HarmonizedDataBuilder setPrice3Units(String price3Units);
		HarmonizedData.HarmonizedDataBuilder setPrice4Price(BigDecimal price4Price);
		HarmonizedData.HarmonizedDataBuilder setPrice4Type(String price4Type);
		HarmonizedData.HarmonizedDataBuilder setPrice4Units(String price4Units);
		HarmonizedData.HarmonizedDataBuilder setPricingContext(String pricingContext);
		HarmonizedData.HarmonizedDataBuilder setPriorUsiType(String priorUsiType);
		HarmonizedData.HarmonizedDataBuilder setPriorUtiType(String priorUtiType);
		HarmonizedData.HarmonizedDataBuilder setRecoveryPrice(BigDecimal recoveryPrice);
		HarmonizedData.HarmonizedDataBuilder setSendToDataCenterCode(String sendToDataCenterCode);
		HarmonizedData.HarmonizedDataBuilder setStrikePriceType(String strikePriceType);
		HarmonizedData.HarmonizedDataBuilder setSubAssetClassForOtherCommodity(String subAssetClassForOtherCommodity);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CftcFinancialEntityStatus(String tradeParty1CftcFinancialEntityStatus);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralAmount(BigDecimal tradeParty1CollateralAmount);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralCurrency(String tradeParty1CollateralCurrency);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1MandatoryDelegatedReporting(String tradeParty1MandatoryDelegatedReporting);
		HarmonizedData.HarmonizedDataBuilder setTradeParty1Role(String tradeParty1Role);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CftcFinancialEntityStatus(String tradeParty2CftcFinancialEntityStatus);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralAmount(BigDecimal tradeParty2CollateralAmount);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralCurrency(String tradeParty2CollateralCurrency);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2MandatoryDelegatedReporting(String tradeParty2MandatoryDelegatedReporting);
		HarmonizedData.HarmonizedDataBuilder setTradeParty2Role(String tradeParty2Role);
		HarmonizedData.HarmonizedDataBuilder setUpfrontPayment(BigDecimal upfrontPayment);
		HarmonizedData.HarmonizedDataBuilder setVerificationMethod(String verificationMethod);
		HarmonizedData.HarmonizedDataBuilder setResponsibleDataSubmitterId(String responsibleDataSubmitterId);
		HarmonizedData.HarmonizedDataBuilder setResponsibleDataSubmitterIdType(String responsibleDataSubmitterIdType);
		HarmonizedData.HarmonizedDataBuilder setOriginalSwapUsi(String originalSwapUsi);
		HarmonizedData.HarmonizedDataBuilder setOriginalSwapUti(String originalSwapUti);
		HarmonizedData.HarmonizedDataBuilder setCdeReceiverIdentifierLeg2(String cdeReceiverIdentifierLeg2);
		HarmonizedData.HarmonizedDataBuilder setCounterparty1FederalEntityIndicator(Boolean counterparty1FederalEntityIndicator);
		HarmonizedData.HarmonizedDataBuilder setCounterparty2FederalEntityIndicator(Boolean counterparty2FederalEntityIndicator);
		HarmonizedData.HarmonizedDataBuilder setCustomBasketIndicator(Boolean customBasketIndicator);
		HarmonizedData.HarmonizedDataBuilder setNoaActionType(String noaActionType);
		HarmonizedData.HarmonizedDataBuilder setEventType(String eventType);
		HarmonizedData.HarmonizedDataBuilder setAmendmentIndicator(Boolean amendmentIndicator);
		HarmonizedData.HarmonizedDataBuilder setEventIdentifier(String eventIdentifier);
		HarmonizedData.HarmonizedDataBuilder setCdeCallAmountLeg1(BigDecimal cdeCallAmountLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeCallAmountLeg2(BigDecimal cdeCallAmountLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeCallCurrencyLeg1(String cdeCallCurrencyLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeCallCurrencyLeg2(String cdeCallCurrencyLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdePutAmountLeg1(BigDecimal cdePutAmountLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdePutAmountLeg2(BigDecimal cdePutAmountLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdePutCurrencyLeg1(String cdePutCurrencyLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdePutCurrencyLeg2(String cdePutCurrencyLeg2);
		HarmonizedData.HarmonizedDataBuilder setLeg2QuantityFrequency(String leg2QuantityFrequency);
		HarmonizedData.HarmonizedDataBuilder setQuantityFrequencyMultiplierLeg1(BigDecimal quantityFrequencyMultiplierLeg1);
		HarmonizedData.HarmonizedDataBuilder setQuantityFrequencyMultiplierLeg2(BigDecimal quantityFrequencyMultiplierLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeQuantityUnitOfMeasureLeg1(String cdeQuantityUnitOfMeasureLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeQuantityUnitOfMeasureLeg2(String cdeQuantityUnitOfMeasureLeg2);
		HarmonizedData.HarmonizedDataBuilder setPackageIndicator(Boolean packageIndicator);
		HarmonizedData.HarmonizedDataBuilder setCdePackageIdentifier(String cdePackageIdentifier);
		HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionPrice(BigDecimal cdePackageTransactionPrice);
		HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionPriceCurrency(String cdePackageTransactionPriceCurrency);
		HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionPriceNotation(String cdePackageTransactionPriceNotation);
		HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionSpread(BigDecimal cdePackageTransactionSpread);
		HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionSpreadCurrency(String cdePackageTransactionSpreadCurrency);
		HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionSpreadNotation(String cdePackageTransactionSpreadNotation);
		HarmonizedData.HarmonizedDataBuilder setCdeFixedRateDayCountConventionLeg1(String cdeFixedRateDayCountConventionLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeFixedRateDayCountConventionLeg2(String cdeFixedRateDayCountConventionLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeFloatingRateDayCountConventionLeg1(String cdeFloatingRateDayCountConventionLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeFloatingRateDayCountConventionLeg2(String cdeFloatingRateDayCountConventionLeg2);
		HarmonizedData.HarmonizedDataBuilder setFixingDateLeg1(Date fixingDateLeg1);
		HarmonizedData.HarmonizedDataBuilder setFixingDateLeg2(Date fixingDateLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodLeg1(String cdeFixedRatePaymentFrequencyPeriodLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodLeg2(String cdeFixedRatePaymentFrequencyPeriodLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodLeg1(String cdeFloatingRatePaymentFrequencyPeriodLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodLeg2(String cdeFloatingRatePaymentFrequencyPeriodLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(BigDecimal cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(BigDecimal cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(BigDecimal cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(BigDecimal cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
		HarmonizedData.HarmonizedDataBuilder setPostPricedSwapIndicator(Boolean postPricedSwapIndicator);
		HarmonizedData.HarmonizedDataBuilder setCdePriceCurrency(String cdePriceCurrency);
		HarmonizedData.HarmonizedDataBuilder setCdePriceNotation(String cdePriceNotation);
		HarmonizedData.HarmonizedDataBuilder setCdeSpreadNotationLeg1(String cdeSpreadNotationLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeSpreadNotationLeg2(String cdeSpreadNotationLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeStrikePriceCurrency2(String cdeStrikePriceCurrency2);
		HarmonizedData.HarmonizedDataBuilder setCdeStrikePriceNotation(String cdeStrikePriceNotation);
		HarmonizedData.HarmonizedDataBuilder setCdeFirstExerciseDate(Date cdeFirstExerciseDate);
		HarmonizedData.HarmonizedDataBuilder setCdeFinalContractualSettlementDate(Date cdeFinalContractualSettlementDate);
		HarmonizedData.HarmonizedDataBuilder setCdeSettlementLocationLeg1(String cdeSettlementLocationLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeSettlementLocationLeg2(String cdeSettlementLocationLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeEffectiveDate(Date cdeEffectiveDate);
		HarmonizedData.HarmonizedDataBuilder setCdeExpirationDate(Date cdeExpirationDate);
		HarmonizedData.HarmonizedDataBuilder setCdePlatformIdentifier(String cdePlatformIdentifier);
		HarmonizedData.HarmonizedDataBuilder setPrimeBrokerageTransactionIndicator(Boolean primeBrokerageTransactionIndicator);
		HarmonizedData.HarmonizedDataBuilder setSwapReportingJurisdiction(String swapReportingJurisdiction);
		HarmonizedData.HarmonizedDataBuilder setNewSdrIdentifier(String newSdrIdentifier);
		HarmonizedData.HarmonizedDataBuilder setNextFloatingReferenceResetDateLeg1(Date nextFloatingReferenceResetDateLeg1);
		HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceValueLeg1(BigDecimal lastFloatingReferenceValueLeg1);
		HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceResetDateLeg1(Date lastFloatingReferenceResetDateLeg1);
		HarmonizedData.HarmonizedDataBuilder setNextFloatingReferenceResetDateLeg2(Date nextFloatingReferenceResetDateLeg2);
		HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceValueLeg2(BigDecimal lastFloatingReferenceValueLeg2);
		HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceResetDateLeg2(Date lastFloatingReferenceResetDateLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeDelta(BigDecimal cdeDelta);
		HarmonizedData.HarmonizedDataBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		HarmonizedData.HarmonizedDataBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		HarmonizedData.HarmonizedDataBuilder setLargeNotionalOffFacilitySwapElectionIndicator(Boolean largeNotionalOffFacilitySwapElectionIndicator);
		HarmonizedData.HarmonizedDataBuilder setSefOrDcmAnonymousExecutionIndicator(Boolean sefOrDcmAnonymousExecutionIndicator);
		HarmonizedData.HarmonizedDataBuilder setBlockTradeElectionIndicator(Boolean blockTradeElectionIndicator);
		HarmonizedData.HarmonizedDataBuilder setSefOrDcmIndicator(Boolean sefOrDcmIndicator);
		HarmonizedData.HarmonizedDataBuilder setMandatoryClearingIndicator(Boolean mandatoryClearingIndicator);
		HarmonizedData.HarmonizedDataBuilder setSdMspIndicatorCounterparty1(Boolean sdMspIndicatorCounterparty1);
		HarmonizedData.HarmonizedDataBuilder setSdMspIndicatorCounterparty2(Boolean sdMspIndicatorCounterparty2);
		HarmonizedData.HarmonizedDataBuilder setPhysicalCommodityContractIndicator(Boolean physicalCommodityContractIndicator);
		HarmonizedData.HarmonizedDataBuilder setChangeInNotionalAmount1(BigDecimal changeInNotionalAmount1);
		HarmonizedData.HarmonizedDataBuilder setChangeInNotionalAmount2(BigDecimal changeInNotionalAmount2);
		HarmonizedData.HarmonizedDataBuilder setChangeInLeg1NotionalQuantity(BigDecimal changeInLeg1NotionalQuantity);
		HarmonizedData.HarmonizedDataBuilder setChangeInLeg2NotionalQuantity(BigDecimal changeInLeg2NotionalQuantity);
		HarmonizedData.HarmonizedDataBuilder setCdeCryptoAssetUnderlyingIndicatorLeg1(Boolean cdeCryptoAssetUnderlyingIndicatorLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeCryptoAssetUnderlyingIndicatorLeg2(Boolean cdeCryptoAssetUnderlyingIndicatorLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeCustomBasketCode(String cdeCustomBasketCode);
		HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherLeg1(String underlierIdOtherLeg1);
		HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherLeg2(String underlierIdOtherLeg2);
		HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherSourceLeg1(String underlierIdOtherSourceLeg1);
		HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherSourceLeg2(String underlierIdOtherSourceLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetTradingPlatformIdLeg1(String cdeUnderlyingAssetTradingPlatformIdLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetTradingPlatformIdLeg2(String cdeUnderlyingAssetTradingPlatformIdLeg2);
		HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetPriceSourceLeg1(String cdeUnderlyingAssetPriceSourceLeg1);
		HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetPriceSourceLeg2(String cdeUnderlyingAssetPriceSourceLeg2);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("leg2CommodityInstrumentId"), String.class, getLeg2CommodityInstrumentId(), this);
			processor.processBasic(path.newSubPath("leg2CommodityUnderlyerId"), String.class, getLeg2CommodityUnderlyerId(), this);
			processor.processBasic(path.newSubPath("leg2CommodityUnderlyerDetails"), String.class, getLeg2CommodityUnderlyerDetails(), this);
			processor.processBasic(path.newSubPath("leg2CommodityUnitOfMeasure"), String.class, getLeg2CommodityUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("leg2CommodityCurrency"), String.class, getLeg2CommodityCurrency(), this);
			processor.processBasic(path.newSubPath("leg2CommodityExchangeId"), String.class, getLeg2CommodityExchangeId(), this);
			processor.processBasic(path.newSubPath("leg1CommodityRateSource"), String.class, getLeg1CommodityRateSource(), this);
			processor.processBasic(path.newSubPath("leg1CommodityRateSourcePage"), String.class, getLeg1CommodityRateSourcePage(), this);
			processor.processBasic(path.newSubPath("leg2SpecifiedPrice"), String.class, getLeg2SpecifiedPrice(), this);
			processor.processBasic(path.newSubPath("commencementDateUnadjusted"), Date.class, getCommencementDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("exerciseExpirationDateUnadjusted"), Date.class, getExerciseExpirationDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("expirationDateUnadjusted"), Date.class, getExpirationDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("leg2NotionalQuantityFrequency"), String.class, getLeg2NotionalQuantityFrequency(), this);
			processor.processBasic(path.newSubPath("leg2NotionalQuantity"), BigDecimal.class, getLeg2NotionalQuantity(), this);
			processor.processBasic(path.newSubPath("leg2TotalNotionalQuantity"), BigDecimal.class, getLeg2TotalNotionalQuantity(), this);
			processor.processBasic(path.newSubPath("leg2SpreadAmount"), BigDecimal.class, getLeg2SpreadAmount(), this);
			processor.processBasic(path.newSubPath("leg2SpreadCurrency"), String.class, getLeg2SpreadCurrency(), this);
			processor.processBasic(path.newSubPath("scheduledTerminationDateAdjusted"), Date.class, getScheduledTerminationDateAdjusted(), this);
			processor.processBasic(path.newSubPath("leg1PartyPayer"), String.class, getLeg1PartyPayer(), this);
			processor.processBasic(path.newSubPath("leg2PartyPayer"), String.class, getLeg2PartyPayer(), this);
			processor.processBasic(path.newSubPath("leg1CommodityInstrumentId"), String.class, getLeg1CommodityInstrumentId(), this);
			processor.processBasic(path.newSubPath("leg1CommodityUnderlyerId"), String.class, getLeg1CommodityUnderlyerId(), this);
			processor.processBasic(path.newSubPath("leg1CommodityUnitOfMeasure"), String.class, getLeg1CommodityUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("leg1CommodityExchangeId"), String.class, getLeg1CommodityExchangeId(), this);
			processor.processBasic(path.newSubPath("leg2CommodityRateSource"), String.class, getLeg2CommodityRateSource(), this);
			processor.processBasic(path.newSubPath("leg1EffectiveDateUnadjusted"), Date.class, getLeg1EffectiveDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("leg2EffectiveDateUnadjusted"), Date.class, getLeg2EffectiveDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("coProductType"), String.class, getCoProductType(), this);
			processor.processBasic(path.newSubPath("totalQuantityUnit"), String.class, getTotalQuantityUnit(), this);
			processor.processBasic(path.newSubPath("totalQuantity"), BigDecimal.class, getTotalQuantity(), this);
			processor.processBasic(path.newSubPath("fixedPrice"), BigDecimal.class, getFixedPrice(), this);
			processor.processBasic(path.newSubPath("fixedPriceCurrency"), String.class, getFixedPriceCurrency(), this);
			processor.processBasic(path.newSubPath("leg1NotionalQuantityUnit"), String.class, getLeg1NotionalQuantityUnit(), this);
			processor.processBasic(path.newSubPath("leg1NotionalQuantityFrequency"), String.class, getLeg1NotionalQuantityFrequency(), this);
			processor.processBasic(path.newSubPath("leg1NotionalQuantity"), BigDecimal.class, getLeg1NotionalQuantity(), this);
			processor.processBasic(path.newSubPath("leg1TotalNotionalQuantity"), BigDecimal.class, getLeg1TotalNotionalQuantity(), this);
			processor.processBasic(path.newSubPath("leg1CommodityCurrency"), String.class, getLeg1CommodityCurrency(), this);
			processor.processBasic(path.newSubPath("leg1SpecifiedPrice"), String.class, getLeg1SpecifiedPrice(), this);
			processor.processBasic(path.newSubPath("leg1SpreadCurrency"), String.class, getLeg1SpreadCurrency(), this);
			processor.processBasic(path.newSubPath("leg1SpreadAmount"), BigDecimal.class, getLeg1SpreadAmount(), this);
			processor.processBasic(path.newSubPath("leg2NotionalQuantityUnit"), String.class, getLeg2NotionalQuantityUnit(), this);
			processor.processBasic(path.newSubPath("leg2PartyReceiver"), String.class, getLeg2PartyReceiver(), this);
			processor.processBasic(path.newSubPath("leg1PartyReceiver"), String.class, getLeg1PartyReceiver(), this);
			processor.processBasic(path.newSubPath("coalSource"), String.class, getCoalSource(), this);
			processor.processBasic(path.newSubPath("leg2Quantity"), BigDecimal.class, getLeg2Quantity(), this);
			processor.processBasic(path.newSubPath("commodityBase"), String.class, getCommodityBase(), this);
			processor.processBasic(path.newSubPath("commodityDetails"), String.class, getCommodityDetails(), this);
			processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
			processor.processBasic(path.newSubPath("loadType"), String.class, getLoadType(), this);
			processor.processBasic(path.newSubPath("fixedPriceUnit"), String.class, getFixedPriceUnit(), this);
			processor.processBasic(path.newSubPath("exercisePaymentDateUnadjusted"), Date.class, getExercisePaymentDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("leg1PaymentDatesUnadjusted"), Date.class, getLeg1PaymentDatesUnadjusted(), this);
			processor.processBasic(path.newSubPath("leg2PaymentDateUnadjusted"), Date.class, getLeg2PaymentDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("settlementDateUnadjusted"), Date.class, getSettlementDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("deliveryLocation"), String.class, getDeliveryLocation(), this);
			processor.processBasic(path.newSubPath("leg2QuantityUnit"), String.class, getLeg2QuantityUnit(), this);
			processor.processBasic(path.newSubPath("leg1CommodityUnderlyerDetails"), String.class, getLeg1CommodityUnderlyerDetails(), this);
			processor.processBasic(path.newSubPath("leg2CommodityRateSourcePage"), String.class, getLeg2CommodityRateSourcePage(), this);
			processor.processBasic(path.newSubPath("valueDate"), Date.class, getValueDate(), this);
			processor.processBasic(path.newSubPath("gtrQuantityUnit"), String.class, getGtrQuantityUnit(), this);
			processor.processBasic(path.newSubPath("attachmentPoint"), BigDecimal.class, getAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("exhaustionPoint"), BigDecimal.class, getExhaustionPoint(), this);
			processor.processBasic(path.newSubPath("mthToDefault"), BigDecimal.class, getMthToDefault(), this);
			processor.processBasic(path.newSubPath("nthToDefault"), BigDecimal.class, getNthToDefault(), this);
			processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), BigDecimal.class, getSeries(), this);
			processor.processBasic(path.newSubPath("crversion"), BigDecimal.class, getCrversion(), this);
			processor.processBasic(path.newSubPath("tranche"), String.class, getTranche(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("referenceObligation"), String.class, getReferenceObligation(), this);
			processor.processBasic(path.newSubPath("referenceObligationIdType"), String.class, getReferenceObligationIdType(), this);
			processor.processBasic(path.newSubPath("underlyingFixedRatePayerBuyer"), String.class, getUnderlyingFixedRatePayerBuyer(), this);
			processor.processBasic(path.newSubPath("underlyingFloatRatePayerSeller"), String.class, getUnderlyingFloatRatePayerSeller(), this);
			processor.processBasic(path.newSubPath("underlyingAssetExchangeId"), String.class, getUnderlyingAssetExchangeId(), this);
			processor.processBasic(path.newSubPath("underlyingAssetNumberOfUnits"), BigDecimal.class, getUnderlyingAssetNumberOfUnits(), this);
			processor.processBasic(path.newSubPath("optionalEarlyTerminationType"), String.class, getOptionalEarlyTerminationType(), this);
			processor.processBasic(path.newSubPath("optionalEarlyTerminationElectingPartyValue"), String.class, getOptionalEarlyTerminationElectingPartyValue(), this);
			processor.processBasic(path.newSubPath("optionalEarlyTerminationIndicator"), Boolean.class, getOptionalEarlyTerminationIndicator(), this);
			processor.processBasic(path.newSubPath("underlyingAssetFloatingAmountPayer"), String.class, getUnderlyingAssetFloatingAmountPayer(), this);
			processor.processBasic(path.newSubPath("underlyingAssetFloatingAmountReceiver"), String.class, getUnderlyingAssetFloatingAmountReceiver(), this);
			processor.processBasic(path.newSubPath("floatingRateOption"), String.class, getFloatingRateOption(), this);
			processor.processBasic(path.newSubPath("underlyingAssetFloatingLegSpread"), BigDecimal.class, getUnderlyingAssetFloatingLegSpread(), this);
			processor.processBasic(path.newSubPath("leg2DesignatedMaturityPeriod"), String.class, getLeg2DesignatedMaturityPeriod(), this);
			processor.processBasic(path.newSubPath("leg2DesignatedMaturityPeriodMultiplier"), BigDecimal.class, getLeg2DesignatedMaturityPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("underlyingAssetEquityAmountPayer"), String.class, getUnderlyingAssetEquityAmountPayer(), this);
			processor.processBasic(path.newSubPath("underlyingAssetEquityAmountReceiver"), String.class, getUnderlyingAssetEquityAmountReceiver(), this);
			processor.processBasic(path.newSubPath("underlyingAssetInitialPriceCurrency"), String.class, getUnderlyingAssetInitialPriceCurrency(), this);
			processor.processBasic(path.newSubPath("leg1ValuationDates"), Date.class, getLeg1ValuationDates(), this);
			processor.processBasic(path.newSubPath("leg1TypeOfReturn"), String.class, getLeg1TypeOfReturn(), this);
			processor.processBasic(path.newSubPath("observationStartDate"), Date.class, getObservationStartDate(), this);
			processor.processBasic(path.newSubPath("varianceAmount"), BigDecimal.class, getVarianceAmount(), this);
			processor.processBasic(path.newSubPath("volatilityStrikePrice"), BigDecimal.class, getVolatilityStrikePrice(), this);
			processor.processBasic(path.newSubPath("varianceStrikePrice"), BigDecimal.class, getVarianceStrikePrice(), this);
			processor.processBasic(path.newSubPath("varianceCapFactor"), BigDecimal.class, getVarianceCapFactor(), this);
			processor.processBasic(path.newSubPath("referenceCurrency"), String.class, getReferenceCurrency(), this);
			processor.processBasic(path.newSubPath("specialDividendsIndicator"), String.class, getSpecialDividendsIndicator(), this);
			processor.processBasic(path.newSubPath("materialNoncashDividendIndicator"), String.class, getMaterialNoncashDividendIndicator(), this);
			processor.processBasic(path.newSubPath("numberOfSharesUnits"), BigDecimal.class, getNumberOfSharesUnits(), this);
			processor.processBasic(path.newSubPath("dividendAmountPayer"), String.class, getDividendAmountPayer(), this);
			processor.processBasic(path.newSubPath("dividendAmountReceiver"), String.class, getDividendAmountReceiver(), this);
			processor.processBasic(path.newSubPath("fixedAmountPayer"), String.class, getFixedAmountPayer(), this);
			processor.processBasic(path.newSubPath("fixedAmountReceiver"), String.class, getFixedAmountReceiver(), this);
			processor.processBasic(path.newSubPath("knockInEvent"), String.class, getKnockInEvent(), this);
			processor.processBasic(path.newSubPath("knockOutEvent"), String.class, getKnockOutEvent(), this);
			processor.processBasic(path.newSubPath("knockInPrice"), BigDecimal.class, getKnockInPrice(), this);
			processor.processBasic(path.newSubPath("knockOutPrice"), BigDecimal.class, getKnockOutPrice(), this);
			processor.processBasic(path.newSubPath("barrierType"), String.class, getBarrierType(), this);
			processor.processBasic(path.newSubPath("earliestExecutionTime"), LocalTime.class, getEarliestExecutionTime(), this);
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasisCurrency1"), String.class, getExchangeRateBasisCurrency1(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasisCurrency2"), String.class, getExchangeRateBasisCurrency2(), this);
			processor.processBasic(path.newSubPath("executionPeriodStartDate"), Date.class, getExecutionPeriodStartDate(), this);
			processor.processBasic(path.newSubPath("payoutStyle"), String.class, getPayoutStyle(), this);
			processor.processBasic(path.newSubPath("rateQuoteBasis1"), String.class, getRateQuoteBasis1(), this);
			processor.processBasic(path.newSubPath("settlementFixingDate"), Date.class, getSettlementFixingDate(), this);
			processor.processBasic(path.newSubPath("swapLinkId"), String.class, getSwapLinkId(), this);
			processor.processBasic(path.newSubPath("triggerCondition"), String.class, getTriggerCondition(), this);
			processor.processBasic(path.newSubPath("triggerCondition2"), String.class, getTriggerCondition2(), this);
			processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, getTriggerRate(), this);
			processor.processBasic(path.newSubPath("triggerRate2"), BigDecimal.class, getTriggerRate2(), this);
			processor.processBasic(path.newSubPath("rateQuoteBasis2"), String.class, getRateQuoteBasis2(), this);
			processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
			processor.processBasic(path.newSubPath("barrierType2"), String.class, getBarrierType2(), this);
			processor.processBasic(path.newSubPath("cancelationOptionBuyer"), String.class, getCancelationOptionBuyer(), this);
			processor.processBasic(path.newSubPath("cancelationOptionCommencementDate"), Date.class, getCancelationOptionCommencementDate(), this);
			processor.processBasic(path.newSubPath("cancelationOptionExerciseStyleType"), String.class, getCancelationOptionExerciseStyleType(), this);
			processor.processBasic(path.newSubPath("cancelationOptionExpirationDate"), Date.class, getCancelationOptionExpirationDate(), this);
			processor.processBasic(path.newSubPath("cancelationOptionInitialFeeCurrency"), String.class, getCancelationOptionInitialFeeCurrency(), this);
			processor.processBasic(path.newSubPath("cancelationOptionInitialFeePayer"), String.class, getCancelationOptionInitialFeePayer(), this);
			processor.processBasic(path.newSubPath("cancelationOptionPremiumAmount"), BigDecimal.class, getCancelationOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("cancelationOptionSeller"), String.class, getCancelationOptionSeller(), this);
			processor.processBasic(path.newSubPath("capRateInitial"), BigDecimal.class, getCapRateInitial(), this);
			processor.processBasic(path.newSubPath("couponType"), String.class, getCouponType(), this);
			processor.processBasic(path.newSubPath("finalPrincipalExchangeIndicatorAtTermination"), Boolean.class, getFinalPrincipalExchangeIndicatorAtTermination(), this);
			processor.processBasic(path.newSubPath("floorRateInitial"), BigDecimal.class, getFloorRateInitial(), this);
			processor.processBasic(path.newSubPath("fraDiscountingType"), String.class, getFraDiscountingType(), this);
			processor.processBasic(path.newSubPath("inflationIndexInitialLevel"), BigDecimal.class, getInflationIndexInitialLevel(), this);
			processor.processBasic(path.newSubPath("inflationIndexMainPublication"), String.class, getInflationIndexMainPublication(), this);
			processor.processBasic(path.newSubPath("inflationInterpolationMethod"), String.class, getInflationInterpolationMethod(), this);
			processor.processBasic(path.newSubPath("inflationLagDayType"), String.class, getInflationLagDayType(), this);
			processor.processBasic(path.newSubPath("inflationLagPeriod"), String.class, getInflationLagPeriod(), this);
			processor.processBasic(path.newSubPath("inflationRateSourceName"), String.class, getInflationRateSourceName(), this);
			processor.processBasic(path.newSubPath("initialPrincipalExchangeIndicator"), Boolean.class, getInitialPrincipalExchangeIndicator(), this);
			processor.processBasic(path.newSubPath("intermediatePrincipalExchangeIndicator"), Boolean.class, getIntermediatePrincipalExchangeIndicator(), this);
			processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, getLeg1FloatingRateIndex(), this);
			processor.processBasic(path.newSubPath("leg1FloatingRateInitialSpread"), BigDecimal.class, getLeg1FloatingRateInitialSpread(), this);
			processor.processBasic(path.newSubPath("leg1FloatingRateMultiplierInitialValue"), BigDecimal.class, getLeg1FloatingRateMultiplierInitialValue(), this);
			processor.processBasic(path.newSubPath("leg1FloatingRateTenorPeriod"), String.class, getLeg1FloatingRateTenorPeriod(), this);
			processor.processBasic(path.newSubPath("leg1FloatingRateTenorPeriodMultiplier"), BigDecimal.class, getLeg1FloatingRateTenorPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("leg1KnownAmount"), BigDecimal.class, getLeg1KnownAmount(), this);
			processor.processBasic(path.newSubPath("leg1KnownAmountCurrency"), String.class, getLeg1KnownAmountCurrency(), this);
			processor.processBasic(path.newSubPath("leg1ReferenceCurrency"), String.class, getLeg1ReferenceCurrency(), this);
			processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, getLeg2FloatingRateIndex(), this);
			processor.processBasic(path.newSubPath("leg2FloatingRateInitialSpread"), BigDecimal.class, getLeg2FloatingRateInitialSpread(), this);
			processor.processBasic(path.newSubPath("leg2FloatingRateMultiplierInitialValue"), BigDecimal.class, getLeg2FloatingRateMultiplierInitialValue(), this);
			processor.processBasic(path.newSubPath("leg2FloatingRateTenorPeriod"), String.class, getLeg2FloatingRateTenorPeriod(), this);
			processor.processBasic(path.newSubPath("leg2FloatingRateTenorPeriodMultiplier"), BigDecimal.class, getLeg2FloatingRateTenorPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("leg2KnownAmount"), BigDecimal.class, getLeg2KnownAmount(), this);
			processor.processBasic(path.newSubPath("leg2KnownAmountCurrency"), String.class, getLeg2KnownAmountCurrency(), this);
			processor.processBasic(path.newSubPath("leg2ReferenceCurrency"), String.class, getLeg2ReferenceCurrency(), this);
			processor.processBasic(path.newSubPath("mandatoryEarlyTerminationDate"), Date.class, getMandatoryEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("mandatoryEarlyTerminationDateTenorPeriod"), String.class, getMandatoryEarlyTerminationDateTenorPeriod(), this);
			processor.processBasic(path.newSubPath("mandatoryEarlyTerminationDateTenorPeriodMultiplier"), String.class, getMandatoryEarlyTerminationDateTenorPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("notionalUnits"), BigDecimal.class, getNotionalUnits(), this);
			processor.processBasic(path.newSubPath("optionalEarlyTerminationCommencementDate"), Date.class, getOptionalEarlyTerminationCommencementDate(), this);
			processor.processBasic(path.newSubPath("optionalEarlyTerminationExerciseStyle"), String.class, getOptionalEarlyTerminationExerciseStyle(), this);
			processor.processBasic(path.newSubPath("optionalEarlyTerminationExpirationDate"), Date.class, getOptionalEarlyTerminationExpirationDate(), this);
			processor.processBasic(path.newSubPath("premiumReceiver"), String.class, getPremiumReceiver(), this);
			processor.processBasic(path.newSubPath("underlyingCouponRate"), BigDecimal.class, getUnderlyingCouponRate(), this);
			processor.processBasic(path.newSubPath("underlyingMaturityDate"), Date.class, getUnderlyingMaturityDate(), this);
			processor.processBasic(path.newSubPath("underlyingProductId"), String.class, getUnderlyingProductId(), this);
			processor.processBasic(path.newSubPath("inflationLagPeriodMultiplier"), String.class, getInflationLagPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("leg1FixedRateNotation"), String.class, getLeg1FixedRateNotation(), this);
			processor.processBasic(path.newSubPath("leg2FixedRateNotation"), String.class, getLeg2FixedRateNotation(), this);
			processor.processBasic(path.newSubPath("swaptionStraddleIndicator"), String.class, getSwaptionStraddleIndicator(), this);
			processor.processBasic(path.newSubPath("singlePartyEarlyTerminationBuyer"), String.class, getSinglePartyEarlyTerminationBuyer(), this);
			processor.processBasic(path.newSubPath("leg1EffectiveDate"), Date.class, getLeg1EffectiveDate(), this);
			processor.processBasic(path.newSubPath("action"), String.class, getAction(), this);
			processor.processBasic(path.newSubPath("clearingStatus"), String.class, getClearingStatus(), this);
			processor.processBasic(path.newSubPath("effectiveDate1"), Date.class, getEffectiveDate1(), this);
			processor.processBasic(path.newSubPath("executionVenueType"), String.class, getExecutionVenueType(), this);
			processor.processBasic(path.newSubPath("nonStandardTradeIndicator"), Boolean.class, getNonStandardTradeIndicator(), this);
			processor.processBasic(path.newSubPath("notionalAmount1"), BigDecimal.class, getNotionalAmount1(), this);
			processor.processBasic(path.newSubPath("notionalCurrency1"), String.class, getNotionalCurrency1(), this);
			processor.processBasic(path.newSubPath("price1Price"), BigDecimal.class, getPrice1Price(), this);
			processor.processBasic(path.newSubPath("price1Type"), String.class, getPrice1Type(), this);
			processor.processBasic(path.newSubPath("price1Units"), String.class, getPrice1Units(), this);
			processor.processBasic(path.newSubPath("scheduledTerminationDate1"), Date.class, getScheduledTerminationDate1(), this);
			processor.processBasic(path.newSubPath("tradeDate"), Date.class, getTradeDate(), this);
			processor.processBasic(path.newSubPath("tradeParty1CollateralizationType"), String.class, getTradeParty1CollateralizationType(), this);
			processor.processBasic(path.newSubPath("tradeParty1EventId"), String.class, getTradeParty1EventId(), this);
			processor.processBasic(path.newSubPath("tradeParty2CollateralizationType"), String.class, getTradeParty2CollateralizationType(), this);
			processor.processBasic(path.newSubPath("tradeParty2EventId"), String.class, getTradeParty2EventId(), this);
			processor.processBasic(path.newSubPath("embeddedOptionOnSwap"), String.class, getEmbeddedOptionOnSwap(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("notionalAmount2"), BigDecimal.class, getNotionalAmount2(), this);
			processor.processBasic(path.newSubPath("notionalCurrency2"), String.class, getNotionalCurrency2(), this);
			processor.processBasic(path.newSubPath("premiumAmount"), BigDecimal.class, getPremiumAmount(), this);
			processor.processBasic(path.newSubPath("premiumCurrency"), String.class, getPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("version"), String.class, getVersion(), this);
			processor.processBasic(path.newSubPath("comment1"), String.class, getComment1(), this);
			processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("settlementCurrency1"), String.class, getSettlementCurrency1(), this);
			processor.processBasic(path.newSubPath("commencementDate"), Date.class, getCommencementDate(), this);
			processor.processBasic(path.newSubPath("dayCountFraction1"), String.class, getDayCountFraction1(), this);
			processor.processBasic(path.newSubPath("leg2DayCountFraction"), String.class, getLeg2DayCountFraction(), this);
			processor.processBasic(path.newSubPath("leg2EffectiveDate"), Date.class, getLeg2EffectiveDate(), this);
			processor.processBasic(path.newSubPath("leg2ResetFrequencyPeriod"), String.class, getLeg2ResetFrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("leg2ResetFrequencyPeriodMultiplier"), BigDecimal.class, getLeg2ResetFrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("leg2SettlementCurrency"), String.class, getLeg2SettlementCurrency(), this);
			processor.processBasic(path.newSubPath("leg2ScheduledTerminationDate"), Date.class, getLeg2ScheduledTerminationDate(), this);
			processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, getNumberOfOptions(), this);
			processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, getOptionEntitlement(), this);
			processor.processBasic(path.newSubPath("originalExecutionTimestamp"), ZonedDateTime.class, getOriginalExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("payment1Date"), Date.class, getPayment1Date(), this);
			processor.processBasic(path.newSubPath("payment1FrequencyPeriod"), String.class, getPayment1FrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment1FrequencyPeriodMultiplier"), BigDecimal.class, getPayment1FrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("payment2Date"), Date.class, getPayment2Date(), this);
			processor.processBasic(path.newSubPath("payment2FrequencyPeriod"), String.class, getPayment2FrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment2FrequencyPeriodMultiplier"), BigDecimal.class, getPayment2FrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("resetFrequencyPeriod1"), String.class, getResetFrequencyPeriod1(), this);
			processor.processBasic(path.newSubPath("resetFrequencyPeriodMultiplier1"), BigDecimal.class, getResetFrequencyPeriodMultiplier1(), this);
			processor.processBasic(path.newSubPath("settlementDate"), Date.class, getSettlementDate(), this);
			processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, getStrikePrice(), this);
			processor.processBasic(path.newSubPath("strikePriceUnits"), String.class, getStrikePriceUnits(), this);
			processor.processBasic(path.newSubPath("asOfDateTime"), ZonedDateTime.class, getAsOfDateTime(), this);
			processor.processBasic(path.newSubPath("clearingVenueId"), String.class, getClearingVenueId(), this);
			processor.processBasic(path.newSubPath("clearingVenueIdType"), String.class, getClearingVenueIdType(), this);
			processor.processBasic(path.newSubPath("compressedTradeIndicator"), String.class, getCompressedTradeIndicator(), this);
			processor.processBasic(path.newSubPath("confirmationMethod"), String.class, getConfirmationMethod(), this);
			processor.processBasic(path.newSubPath("confirmationPlatformId"), String.class, getConfirmationPlatformId(), this);
			processor.processBasic(path.newSubPath("confirmationPlatformTradeId"), String.class, getConfirmationPlatformTradeId(), this);
			processor.processBasic(path.newSubPath("executionVenueId"), String.class, getExecutionVenueId(), this);
			processor.processBasic(path.newSubPath("executionVenueIdType"), String.class, getExecutionVenueIdType(), this);
			processor.processBasic(path.newSubPath("postTradeEffectiveDate"), Date.class, getPostTradeEffectiveDate(), this);
			processor.processBasic(path.newSubPath("priorUsiId"), String.class, getPriorUsiId(), this);
			processor.processBasic(path.newSubPath("priorUsiIdPrefix"), String.class, getPriorUsiIdPrefix(), this);
			processor.processBasic(path.newSubPath("priorUtiId"), String.class, getPriorUtiId(), this);
			processor.processBasic(path.newSubPath("priorUtiIdPrefix"), String.class, getPriorUtiIdPrefix(), this);
			processor.processBasic(path.newSubPath("tradeParty1BranchLocation"), String.class, getTradeParty1BranchLocation(), this);
			processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerId"), String.class, getTradeParty1ClearingBrokerId(), this);
			processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIdType"), String.class, getTradeParty1ClearingBrokerIdType(), this);
			processor.processBasic(path.newSubPath("tradeParty1DeskLocation"), String.class, getTradeParty1DeskLocation(), this);
			processor.processBasic(path.newSubPath("tradeParty1Domicile"), String.class, getTradeParty1Domicile(), this);
			processor.processBasic(path.newSubPath("tradeParty1IndustrialSectorType"), String.class, getTradeParty1IndustrialSectorType(), this);
			processor.processBasic(path.newSubPath("tradeParty2BranchLocation"), String.class, getTradeParty2BranchLocation(), this);
			processor.processBasic(path.newSubPath("tradeParty2DeskLocation"), String.class, getTradeParty2DeskLocation(), this);
			processor.processBasic(path.newSubPath("tradeParty2Domicile"), String.class, getTradeParty2Domicile(), this);
			processor.processBasic(path.newSubPath("tradeParty2IndustrialSectorType"), String.class, getTradeParty2IndustrialSectorType(), this);
			processor.processBasic(path.newSubPath("sellerPayer2"), String.class, getSellerPayer2(), this);
			processor.processBasic(path.newSubPath("buyerPayer1"), String.class, getBuyerPayer1(), this);
			processor.processBasic(path.newSubPath("tradeParty1HkCounterpartyOrigin"), String.class, getTradeParty1HkCounterpartyOrigin(), this);
			processor.processBasic(path.newSubPath("leg2SettlementDate"), Date.class, getLeg2SettlementDate(), this);
			processor.processBasic(path.newSubPath("leg1FixedRateInitial"), BigDecimal.class, getLeg1FixedRateInitial(), this);
			processor.processBasic(path.newSubPath("leg2FixedRateInitial"), BigDecimal.class, getLeg2FixedRateInitial(), this);
			processor.processBasic(path.newSubPath("payment1Amount"), BigDecimal.class, getPayment1Amount(), this);
			processor.processBasic(path.newSubPath("payment1Currency"), String.class, getPayment1Currency(), this);
			processor.processBasic(path.newSubPath("payment1Payer"), String.class, getPayment1Payer(), this);
			processor.processBasic(path.newSubPath("payment1Receiver"), String.class, getPayment1Receiver(), this);
			processor.processBasic(path.newSubPath("payment2Payer"), String.class, getPayment2Payer(), this);
			processor.processBasic(path.newSubPath("postTradeTransactionDate"), Date.class, getPostTradeTransactionDate(), this);
			processor.processBasic(path.newSubPath("secondaryAssetClass"), String.class, getSecondaryAssetClass(), this);
			processor.processBasic(path.newSubPath("settlementType"), String.class, getSettlementType(), this);
			processor.processBasic(path.newSubPath("tradeParty1Name"), String.class, getTradeParty1Name(), this);
			processor.processBasic(path.newSubPath("tradeParty2Name"), String.class, getTradeParty2Name(), this);
			processor.processBasic(path.newSubPath("ccpValuationAmount"), BigDecimal.class, getCcpValuationAmount(), this);
			processor.processBasic(path.newSubPath("ccpValuationCurrency"), String.class, getCcpValuationCurrency(), this);
			processor.processBasic(path.newSubPath("ccpValuationDatetime"), ZonedDateTime.class, getCcpValuationDatetime(), this);
			processor.processBasic(path.newSubPath("ccpValuationType"), String.class, getCcpValuationType(), this);
			processor.processBasic(path.newSubPath("tradeParty1ValuationAmount"), BigDecimal.class, getTradeParty1ValuationAmount(), this);
			processor.processBasic(path.newSubPath("tradeParty1ValuationCurrency"), String.class, getTradeParty1ValuationCurrency(), this);
			processor.processBasic(path.newSubPath("tradeParty1ValuationDatetime"), ZonedDateTime.class, getTradeParty1ValuationDatetime(), this);
			processor.processBasic(path.newSubPath("tradeParty1ValuationType"), String.class, getTradeParty1ValuationType(), this);
			processor.processBasic(path.newSubPath("tradeParty2ValuationAmount"), BigDecimal.class, getTradeParty2ValuationAmount(), this);
			processor.processBasic(path.newSubPath("tradeParty2ValuationCurrency"), String.class, getTradeParty2ValuationCurrency(), this);
			processor.processBasic(path.newSubPath("tradeParty2ValuationDatetime"), ZonedDateTime.class, getTradeParty2ValuationDatetime(), this);
			processor.processBasic(path.newSubPath("tradeParty2ValuationType"), String.class, getTradeParty2ValuationType(), this);
			processor.processBasic(path.newSubPath("executionType"), String.class, getExecutionType(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("payment2Amount"), BigDecimal.class, getPayment2Amount(), this);
			processor.processBasic(path.newSubPath("tradeParty2HkCounterpartyOrigin"), String.class, getTradeParty2HkCounterpartyOrigin(), this);
			processor.processBasic(path.newSubPath("tradeParty1CountryOfTheOtherCounterparty"), String.class, getTradeParty1CountryOfTheOtherCounterparty(), this);
			processor.processBasic(path.newSubPath("tradeParty2CountryOfTheOtherCounterparty"), String.class, getTradeParty2CountryOfTheOtherCounterparty(), this);
			processor.processBasic(path.newSubPath("tradeParty1BrokerId"), String.class, getTradeParty1BrokerId(), this);
			processor.processBasic(path.newSubPath("tradeParty2BrokerId"), String.class, getTradeParty2BrokerId(), this);
			processor.processBasic(path.newSubPath("tradeParty1BeneficiaryIdType"), String.class, getTradeParty1BeneficiaryIdType(), this);
			processor.processBasic(path.newSubPath("tradeParty1BeneficiaryId"), String.class, getTradeParty1BeneficiaryId(), this);
			processor.processBasic(path.newSubPath("tradeParty2BeneficiaryIdType"), String.class, getTradeParty2BeneficiaryIdType(), this);
			processor.processBasic(path.newSubPath("tradeParty2BeneficiaryId"), String.class, getTradeParty2BeneficiaryId(), this);
			processor.processBasic(path.newSubPath("tradeParty1CounterpartySide"), String.class, getTradeParty1CounterpartySide(), this);
			processor.processBasic(path.newSubPath("tradeParty2CounterpartySide"), String.class, getTradeParty2CounterpartySide(), this);
			processor.processBasic(path.newSubPath("tradeParty1CollateralPortfolioCode"), String.class, getTradeParty1CollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("tradeParty2CollateralPortfolioCode"), String.class, getTradeParty2CollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
			processor.processBasic(path.newSubPath("euUnderlyingAssetIdType"), String.class, getEuUnderlyingAssetIdType(), this);
			processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
			processor.processBasic(path.newSubPath("complexTradeComponentId"), String.class, getComplexTradeComponentId(), this);
			processor.processBasic(path.newSubPath("priceMultiplier"), BigDecimal.class, getPriceMultiplier(), this);
			processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, getQuantity(), this);
			processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("masterAgreementVersion"), String.class, getMasterAgreementVersion(), this);
			processor.processBasic(path.newSubPath("confirmationDatetime"), ZonedDateTime.class, getConfirmationDatetime(), this);
			processor.processBasic(path.newSubPath("clearingDatetime"), ZonedDateTime.class, getClearingDatetime(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("level"), String.class, getLevel(), this);
			processor.processBasic(path.newSubPath("productClassificationType"), String.class, getProductClassificationType(), this);
			processor.processBasic(path.newSubPath("productIdentificationType"), String.class, getProductIdentificationType(), this);
			processor.processBasic(path.newSubPath("productIdentification"), String.class, getProductIdentification(), this);
			processor.processBasic(path.newSubPath("euUnderlyingAssetId"), String.class, getEuUnderlyingAssetId(), this);
			processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
			processor.processBasic(path.newSubPath("tradeParty1BrokerIdType"), String.class, getTradeParty1BrokerIdType(), this);
			processor.processBasic(path.newSubPath("tradeParty2BrokerIdType"), String.class, getTradeParty2BrokerIdType(), this);
			processor.processBasic(path.newSubPath("tradeParty2ClearingBrokerIdType"), String.class, getTradeParty2ClearingBrokerIdType(), this);
			processor.processBasic(path.newSubPath("tradeParty2ClearingBrokerId"), String.class, getTradeParty2ClearingBrokerId(), this);
			processor.processBasic(path.newSubPath("tradeParty1ClearingThreshold"), Boolean.class, getTradeParty1ClearingThreshold(), this);
			processor.processBasic(path.newSubPath("tradeParty2ClearingThreshold"), Boolean.class, getTradeParty2ClearingThreshold(), this);
			processor.processBasic(path.newSubPath("tradeParty1CorporateSectorType"), String.class, getTradeParty1CorporateSectorType(), this);
			processor.processBasic(path.newSubPath("tradeParty2CorporateSectorType"), String.class, getTradeParty2CorporateSectorType(), this);
			processor.processBasic(path.newSubPath("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator"), String.class, getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), this);
			processor.processBasic(path.newSubPath("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator"), String.class, getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), this);
			processor.processBasic(path.newSubPath("intragroupIndicator"), Boolean.class, getIntragroupIndicator(), this);
			processor.processBasic(path.newSubPath("tradeParty1TradingCapacity1"), String.class, getTradeParty1TradingCapacity1(), this);
			processor.processBasic(path.newSubPath("tradeParty2TradingCapacity1"), String.class, getTradeParty2TradingCapacity1(), this);
			processor.processBasic(path.newSubPath("currencyOfPrice"), String.class, getCurrencyOfPrice(), this);
			processor.processBasic(path.newSubPath("tradeParty1CollateralPortfolio"), String.class, getTradeParty1CollateralPortfolio(), this);
			processor.processBasic(path.newSubPath("tradeParty2CollateralPortfolio"), String.class, getTradeParty2CollateralPortfolio(), this);
			processor.processBasic(path.newSubPath("executionVenueMicCode"), String.class, getExecutionVenueMicCode(), this);
			processor.processBasic(path.newSubPath("payment2Currency"), String.class, getPayment2Currency(), this);
			processor.processBasic(path.newSubPath("expirationDateTimeBusinessCenter"), String.class, getExpirationDateTimeBusinessCenter(), this);
			processor.processBasic(path.newSubPath("expirationTime"), LocalTime.class, getExpirationTime(), this);
			processor.processBasic(path.newSubPath("expirationTimeType"), String.class, getExpirationTimeType(), this);
			processor.processBasic(path.newSubPath("tradeParty1TraderLocation"), String.class, getTradeParty1TraderLocation(), this);
			processor.processBasic(path.newSubPath("tradeParty2TraderLocation"), String.class, getTradeParty2TraderLocation(), this);
			processor.processBasic(path.newSubPath("payment3ResetFrequencyPeriodMultiplier"), BigDecimal.class, getPayment3ResetFrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("payment3ResetFrequencyPeriod"), String.class, getPayment3ResetFrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment4ResetFrequencyPeriodMultiplier"), BigDecimal.class, getPayment4ResetFrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("payment4ResetFrequencyPeriod"), String.class, getPayment4ResetFrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment5ResetFrequencyPeriodMultiplier"), BigDecimal.class, getPayment5ResetFrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("payment5ResetFrequencyPeriod"), String.class, getPayment5ResetFrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment1Type"), String.class, getPayment1Type(), this);
			processor.processBasic(path.newSubPath("payment1Reference"), String.class, getPayment1Reference(), this);
			processor.processBasic(path.newSubPath("payment2Type"), String.class, getPayment2Type(), this);
			processor.processBasic(path.newSubPath("payment2Reference"), String.class, getPayment2Reference(), this);
			processor.processBasic(path.newSubPath("payment3Payer"), String.class, getPayment3Payer(), this);
			processor.processBasic(path.newSubPath("payment3Reference"), String.class, getPayment3Reference(), this);
			processor.processBasic(path.newSubPath("payment3FrequencyPeriod"), String.class, getPayment3FrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment3FrequencyPeriodMultiplier"), BigDecimal.class, getPayment3FrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("payment3Date"), Date.class, getPayment3Date(), this);
			processor.processBasic(path.newSubPath("payment4Reference"), String.class, getPayment4Reference(), this);
			processor.processBasic(path.newSubPath("payment4Payer"), String.class, getPayment4Payer(), this);
			processor.processBasic(path.newSubPath("payment4FrequencyPeriod"), String.class, getPayment4FrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment4FrequencyPeriodMultiplier"), BigDecimal.class, getPayment4FrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("payment4Date"), Date.class, getPayment4Date(), this);
			processor.processBasic(path.newSubPath("payment5Reference"), String.class, getPayment5Reference(), this);
			processor.processBasic(path.newSubPath("payment5Payer"), String.class, getPayment5Payer(), this);
			processor.processBasic(path.newSubPath("payment5FrequencyPeriod"), String.class, getPayment5FrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("payment5FrequencyPeriodMultiplier"), BigDecimal.class, getPayment5FrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("payment5Date"), Date.class, getPayment5Date(), this);
			processor.processBasic(path.newSubPath("payment3Type"), String.class, getPayment3Type(), this);
			processor.processBasic(path.newSubPath("premiumPayer"), String.class, getPremiumPayer(), this);
			processor.processBasic(path.newSubPath("premiumPaymentDateUnadjusted"), Date.class, getPremiumPaymentDateUnadjusted(), this);
			processor.processBasic(path.newSubPath("tradeParty1NatureOfTheReportingCounterparty"), String.class, getTradeParty1NatureOfTheReportingCounterparty(), this);
			processor.processBasic(path.newSubPath("tradeParty2NatureOfTheReportingCounterparty"), String.class, getTradeParty2NatureOfTheReportingCounterparty(), this);
			processor.processBasic(path.newSubPath("reservedParticipantUse1"), String.class, getReservedParticipantUse1(), this);
			processor.processBasic(path.newSubPath("reservedParticipantUse2"), String.class, getReservedParticipantUse2(), this);
			processor.processBasic(path.newSubPath("reservedParticipantUse3"), String.class, getReservedParticipantUse3(), this);
			processor.processBasic(path.newSubPath("reservedParticipantUse4"), String.class, getReservedParticipantUse4(), this);
			processor.processBasic(path.newSubPath("reservedParticipantUse5"), String.class, getReservedParticipantUse5(), this);
			processor.processBasic(path.newSubPath("leg1TerminationDate"), Date.class, getLeg1TerminationDate(), this);
			processor.processBasic(path.newSubPath("allocationType"), String.class, getAllocationType(), this);
			processor.processBasic(path.newSubPath("calculationBasis"), String.class, getCalculationBasis(), this);
			processor.processBasic(path.newSubPath("clearingExceptionPartyId"), String.class, getClearingExceptionPartyId(), this);
			processor.processBasic(path.newSubPath("clearingExceptionPartyIdType"), String.class, getClearingExceptionPartyIdType(), this);
			processor.processBasic(path.newSubPath("clearingExceptionType"), String.class, getClearingExceptionType(), this);
			processor.processBasic(path.newSubPath("clearingMemberClientAccountId"), String.class, getClearingMemberClientAccountId(), this);
			processor.processBasic(path.newSubPath("clearingReceiptDatetime"), ZonedDateTime.class, getClearingReceiptDatetime(), this);
			processor.processBasic(path.newSubPath("clearingSwapSdrLeiId"), String.class, getClearingSwapSdrLeiId(), this);
			processor.processBasic(path.newSubPath("clearingSwapUtiId"), String.class, getClearingSwapUtiId(), this);
			processor.processBasic(path.newSubPath("collateralReportingDate"), Date.class, getCollateralReportingDate(), this);
			processor.processBasic(path.newSubPath("collateralValuationDatetime"), ZonedDateTime.class, getCollateralValuationDatetime(), this);
			processor.processBasic(path.newSubPath("comment2"), String.class, getComment2(), this);
			processor.processBasic(path.newSubPath("commodityStrikePriceUnit"), String.class, getCommodityStrikePriceUnit(), this);
			processor.processBasic(path.newSubPath("executionAgentMaskingIndicator"), String.class, getExecutionAgentMaskingIndicator(), this);
			processor.processBasic(path.newSubPath("feeInCurrency"), String.class, getFeeInCurrency(), this);
			processor.processBasic(path.newSubPath("feeOutCurrency"), String.class, getFeeOutCurrency(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg1Multiplier"), BigDecimal.class, getFloatingRatePaymentFrequencyLeg1Multiplier(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg1TimePeriod"), String.class, getFloatingRatePaymentFrequencyLeg1TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg2Multiplier"), BigDecimal.class, getFloatingRatePaymentFrequencyLeg2Multiplier(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyLeg2TimePeriod"), String.class, getFloatingRatePaymentFrequencyLeg2TimePeriod(), this);
			processor.processBasic(path.newSubPath("frequencyOfPayment"), String.class, getFrequencyOfPayment(), this);
			processor.processBasic(path.newSubPath("interaffiliate"), Boolean.class, getInteraffiliate(), this);
			processor.processBasic(path.newSubPath("largeTradeIndicator"), Boolean.class, getLargeTradeIndicator(), this);
			processor.processBasic(path.newSubPath("leg1EffectiveDateAdjusted"), Date.class, getLeg1EffectiveDateAdjusted(), this);
			processor.processBasic(path.newSubPath("leg1FinalValuationDate"), Date.class, getLeg1FinalValuationDate(), this);
			processor.processBasic(path.newSubPath("leg1SettlementPeriod"), String.class, getLeg1SettlementPeriod(), this);
			processor.processBasic(path.newSubPath("leg2EffectiveDateAdjusted"), Date.class, getLeg2EffectiveDateAdjusted(), this);
			processor.processBasic(path.newSubPath("leg2PaymentTermsFrequencyPeriod"), String.class, getLeg2PaymentTermsFrequencyPeriod(), this);
			processor.processBasic(path.newSubPath("leg2PaymentTermsPaymentFrequencyPeriodMultiplier"), BigDecimal.class, getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier(), this);
			processor.processBasic(path.newSubPath("leg2SettlementType"), String.class, getLeg2SettlementType(), this);
			processor.processBasic(path.newSubPath("leg2UnderlyingAssetId"), String.class, getLeg2UnderlyingAssetId(), this);
			processor.processBasic(path.newSubPath("leg2UnderlyingAssetIdType"), String.class, getLeg2UnderlyingAssetIdType(), this);
			processor.processBasic(path.newSubPath("leg2UnderlyingAssetName"), String.class, getLeg2UnderlyingAssetName(), this);
			processor.processBasic(path.newSubPath("maturityDate"), Date.class, getMaturityDate(), this);
			processor.processBasic(path.newSubPath("optionalEarlyTerminationDate"), String.class, getOptionalEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("optionCommodityCurrency"), String.class, getOptionCommodityCurrency(), this);
			processor.processBasic(path.newSubPath("optionCommodityExchangeId"), String.class, getOptionCommodityExchangeId(), this);
			processor.processBasic(path.newSubPath("optionCommodityInstrumentId"), String.class, getOptionCommodityInstrumentId(), this);
			processor.processBasic(path.newSubPath("optionCommodityRateSource"), String.class, getOptionCommodityRateSource(), this);
			processor.processBasic(path.newSubPath("optionCommodityRateSourcePage"), String.class, getOptionCommodityRateSourcePage(), this);
			processor.processBasic(path.newSubPath("optionCommodityUnderlyerDetails"), String.class, getOptionCommodityUnderlyerDetails(), this);
			processor.processBasic(path.newSubPath("optionCommodityUnderlyerId"), String.class, getOptionCommodityUnderlyerId(), this);
			processor.processBasic(path.newSubPath("optionCommodityUnitOfMeasure"), String.class, getOptionCommodityUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionSpecifiedPrice"), String.class, getOptionSpecifiedPrice(), this);
			processor.processBasic(path.newSubPath("optionSpreadAmount"), BigDecimal.class, getOptionSpreadAmount(), this);
			processor.processBasic(path.newSubPath("optionSpreadCurrency"), String.class, getOptionSpreadCurrency(), this);
			processor.processBasic(path.newSubPath("optionSpreadSchedule"), String.class, getOptionSpreadSchedule(), this);
			processor.processBasic(path.newSubPath("origin"), String.class, getOrigin(), this);
			processor.processBasic(path.newSubPath("originalSwapSdrId"), String.class, getOriginalSwapSdrId(), this);
			processor.processBasic(path.newSubPath("originalSwapSdrIdType"), String.class, getOriginalSwapSdrIdType(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg1"), String.class, getPaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg2"), String.class, getPaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg1"), BigDecimal.class, getPaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg2"), BigDecimal.class, getPaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("premiumPayerPrefix"), String.class, getPremiumPayerPrefix(), this);
			processor.processBasic(path.newSubPath("price1Currency"), String.class, getPrice1Currency(), this);
			processor.processBasic(path.newSubPath("price2Price"), BigDecimal.class, getPrice2Price(), this);
			processor.processBasic(path.newSubPath("price2Type"), String.class, getPrice2Type(), this);
			processor.processBasic(path.newSubPath("price2Units"), String.class, getPrice2Units(), this);
			processor.processBasic(path.newSubPath("price3Price"), BigDecimal.class, getPrice3Price(), this);
			processor.processBasic(path.newSubPath("price3Type"), String.class, getPrice3Type(), this);
			processor.processBasic(path.newSubPath("price3Units"), String.class, getPrice3Units(), this);
			processor.processBasic(path.newSubPath("price4Price"), BigDecimal.class, getPrice4Price(), this);
			processor.processBasic(path.newSubPath("price4Type"), String.class, getPrice4Type(), this);
			processor.processBasic(path.newSubPath("price4Units"), String.class, getPrice4Units(), this);
			processor.processBasic(path.newSubPath("pricingContext"), String.class, getPricingContext(), this);
			processor.processBasic(path.newSubPath("priorUsiType"), String.class, getPriorUsiType(), this);
			processor.processBasic(path.newSubPath("priorUtiType"), String.class, getPriorUtiType(), this);
			processor.processBasic(path.newSubPath("recoveryPrice"), BigDecimal.class, getRecoveryPrice(), this);
			processor.processBasic(path.newSubPath("sendToDataCenterCode"), String.class, getSendToDataCenterCode(), this);
			processor.processBasic(path.newSubPath("strikePriceType"), String.class, getStrikePriceType(), this);
			processor.processBasic(path.newSubPath("subAssetClassForOtherCommodity"), String.class, getSubAssetClassForOtherCommodity(), this);
			processor.processBasic(path.newSubPath("tradeParty1CftcFinancialEntityStatus"), String.class, getTradeParty1CftcFinancialEntityStatus(), this);
			processor.processBasic(path.newSubPath("tradeParty1CollateralAmount"), BigDecimal.class, getTradeParty1CollateralAmount(), this);
			processor.processBasic(path.newSubPath("tradeParty1CollateralCurrency"), String.class, getTradeParty1CollateralCurrency(), this);
			processor.processBasic(path.newSubPath("tradeParty1MandatoryDelegatedReporting"), String.class, getTradeParty1MandatoryDelegatedReporting(), this);
			processor.processBasic(path.newSubPath("tradeParty1Role"), String.class, getTradeParty1Role(), this);
			processor.processBasic(path.newSubPath("tradeParty2CftcFinancialEntityStatus"), String.class, getTradeParty2CftcFinancialEntityStatus(), this);
			processor.processBasic(path.newSubPath("tradeParty2CollateralAmount"), BigDecimal.class, getTradeParty2CollateralAmount(), this);
			processor.processBasic(path.newSubPath("tradeParty2CollateralCurrency"), String.class, getTradeParty2CollateralCurrency(), this);
			processor.processBasic(path.newSubPath("tradeParty2MandatoryDelegatedReporting"), String.class, getTradeParty2MandatoryDelegatedReporting(), this);
			processor.processBasic(path.newSubPath("tradeParty2Role"), String.class, getTradeParty2Role(), this);
			processor.processBasic(path.newSubPath("upfrontPayment"), BigDecimal.class, getUpfrontPayment(), this);
			processor.processBasic(path.newSubPath("verificationMethod"), String.class, getVerificationMethod(), this);
			processor.processBasic(path.newSubPath("responsibleDataSubmitterId"), String.class, getResponsibleDataSubmitterId(), this);
			processor.processBasic(path.newSubPath("responsibleDataSubmitterIdType"), String.class, getResponsibleDataSubmitterIdType(), this);
			processor.processBasic(path.newSubPath("originalSwapUsi"), String.class, getOriginalSwapUsi(), this);
			processor.processBasic(path.newSubPath("originalSwapUti"), String.class, getOriginalSwapUti(), this);
			processor.processBasic(path.newSubPath("cdeReceiverIdentifierLeg2"), String.class, getCdeReceiverIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("counterparty1FederalEntityIndicator"), Boolean.class, getCounterparty1FederalEntityIndicator(), this);
			processor.processBasic(path.newSubPath("counterparty2FederalEntityIndicator"), Boolean.class, getCounterparty2FederalEntityIndicator(), this);
			processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
			processor.processBasic(path.newSubPath("noaActionType"), String.class, getNoaActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
			processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("cdeCallAmountLeg1"), BigDecimal.class, getCdeCallAmountLeg1(), this);
			processor.processBasic(path.newSubPath("cdeCallAmountLeg2"), BigDecimal.class, getCdeCallAmountLeg2(), this);
			processor.processBasic(path.newSubPath("cdeCallCurrencyLeg1"), String.class, getCdeCallCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("cdeCallCurrencyLeg2"), String.class, getCdeCallCurrencyLeg2(), this);
			processor.processBasic(path.newSubPath("cdePutAmountLeg1"), BigDecimal.class, getCdePutAmountLeg1(), this);
			processor.processBasic(path.newSubPath("cdePutAmountLeg2"), BigDecimal.class, getCdePutAmountLeg2(), this);
			processor.processBasic(path.newSubPath("cdePutCurrencyLeg1"), String.class, getCdePutCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("cdePutCurrencyLeg2"), String.class, getCdePutCurrencyLeg2(), this);
			processor.processBasic(path.newSubPath("leg2QuantityFrequency"), String.class, getLeg2QuantityFrequency(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg1"), BigDecimal.class, getQuantityFrequencyMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg2"), BigDecimal.class, getQuantityFrequencyMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("cdeQuantityUnitOfMeasureLeg1"), String.class, getCdeQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("cdeQuantityUnitOfMeasureLeg2"), String.class, getCdeQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
			processor.processBasic(path.newSubPath("cdePackageIdentifier"), String.class, getCdePackageIdentifier(), this);
			processor.processBasic(path.newSubPath("cdePackageTransactionPrice"), BigDecimal.class, getCdePackageTransactionPrice(), this);
			processor.processBasic(path.newSubPath("cdePackageTransactionPriceCurrency"), String.class, getCdePackageTransactionPriceCurrency(), this);
			processor.processBasic(path.newSubPath("cdePackageTransactionPriceNotation"), String.class, getCdePackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("cdePackageTransactionSpread"), BigDecimal.class, getCdePackageTransactionSpread(), this);
			processor.processBasic(path.newSubPath("cdePackageTransactionSpreadCurrency"), String.class, getCdePackageTransactionSpreadCurrency(), this);
			processor.processBasic(path.newSubPath("cdePackageTransactionSpreadNotation"), String.class, getCdePackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("cdeFixedRateDayCountConventionLeg1"), String.class, getCdeFixedRateDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("cdeFixedRateDayCountConventionLeg2"), String.class, getCdeFixedRateDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("cdeFloatingRateDayCountConventionLeg1"), String.class, getCdeFloatingRateDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("cdeFloatingRateDayCountConventionLeg2"), String.class, getCdeFloatingRateDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("fixingDateLeg1"), Date.class, getFixingDateLeg1(), this);
			processor.processBasic(path.newSubPath("fixingDateLeg2"), Date.class, getFixingDateLeg2(), this);
			processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodLeg1"), String.class, getCdeFixedRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodLeg2"), String.class, getCdeFixedRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodLeg1"), String.class, getCdeFloatingRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodLeg2"), String.class, getCdeFloatingRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1"), BigDecimal.class, getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2"), BigDecimal.class, getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1"), BigDecimal.class, getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2"), BigDecimal.class, getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
			processor.processBasic(path.newSubPath("cdePriceCurrency"), String.class, getCdePriceCurrency(), this);
			processor.processBasic(path.newSubPath("cdePriceNotation"), String.class, getCdePriceNotation(), this);
			processor.processBasic(path.newSubPath("cdeSpreadNotationLeg1"), String.class, getCdeSpreadNotationLeg1(), this);
			processor.processBasic(path.newSubPath("cdeSpreadNotationLeg2"), String.class, getCdeSpreadNotationLeg2(), this);
			processor.processBasic(path.newSubPath("cdeStrikePriceCurrency2"), String.class, getCdeStrikePriceCurrency2(), this);
			processor.processBasic(path.newSubPath("cdeStrikePriceNotation"), String.class, getCdeStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("cdeFirstExerciseDate"), Date.class, getCdeFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("cdeFinalContractualSettlementDate"), Date.class, getCdeFinalContractualSettlementDate(), this);
			processor.processBasic(path.newSubPath("cdeSettlementLocationLeg1"), String.class, getCdeSettlementLocationLeg1(), this);
			processor.processBasic(path.newSubPath("cdeSettlementLocationLeg2"), String.class, getCdeSettlementLocationLeg2(), this);
			processor.processBasic(path.newSubPath("cdeEffectiveDate"), Date.class, getCdeEffectiveDate(), this);
			processor.processBasic(path.newSubPath("cdeExpirationDate"), Date.class, getCdeExpirationDate(), this);
			processor.processBasic(path.newSubPath("cdePlatformIdentifier"), String.class, getCdePlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
			processor.processBasic(path.newSubPath("swapReportingJurisdiction"), String.class, getSwapReportingJurisdiction(), this);
			processor.processBasic(path.newSubPath("newSdrIdentifier"), String.class, getNewSdrIdentifier(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
			processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, getLastFloatingReferenceValueLeg1(), this);
			processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, getLastFloatingReferenceResetDateLeg1(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
			processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, getLastFloatingReferenceValueLeg2(), this);
			processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, getLastFloatingReferenceResetDateLeg2(), this);
			processor.processBasic(path.newSubPath("cdeDelta"), BigDecimal.class, getCdeDelta(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("largeNotionalOffFacilitySwapElectionIndicator"), Boolean.class, getLargeNotionalOffFacilitySwapElectionIndicator(), this);
			processor.processBasic(path.newSubPath("sefOrDcmAnonymousExecutionIndicator"), Boolean.class, getSefOrDcmAnonymousExecutionIndicator(), this);
			processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
			processor.processBasic(path.newSubPath("sefOrDcmIndicator"), Boolean.class, getSefOrDcmIndicator(), this);
			processor.processBasic(path.newSubPath("mandatoryClearingIndicator"), Boolean.class, getMandatoryClearingIndicator(), this);
			processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty1"), Boolean.class, getSdMspIndicatorCounterparty1(), this);
			processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty2"), Boolean.class, getSdMspIndicatorCounterparty2(), this);
			processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, getPhysicalCommodityContractIndicator(), this);
			processor.processBasic(path.newSubPath("changeInNotionalAmount1"), BigDecimal.class, getChangeInNotionalAmount1(), this);
			processor.processBasic(path.newSubPath("changeInNotionalAmount2"), BigDecimal.class, getChangeInNotionalAmount2(), this);
			processor.processBasic(path.newSubPath("changeInLeg1NotionalQuantity"), BigDecimal.class, getChangeInLeg1NotionalQuantity(), this);
			processor.processBasic(path.newSubPath("changeInLeg2NotionalQuantity"), BigDecimal.class, getChangeInLeg2NotionalQuantity(), this);
			processor.processBasic(path.newSubPath("cdeCryptoAssetUnderlyingIndicatorLeg1"), Boolean.class, getCdeCryptoAssetUnderlyingIndicatorLeg1(), this);
			processor.processBasic(path.newSubPath("cdeCryptoAssetUnderlyingIndicatorLeg2"), Boolean.class, getCdeCryptoAssetUnderlyingIndicatorLeg2(), this);
			processor.processBasic(path.newSubPath("cdeCustomBasketCode"), String.class, getCdeCustomBasketCode(), this);
			processor.processBasic(path.newSubPath("underlierIdOtherLeg1"), String.class, getUnderlierIdOtherLeg1(), this);
			processor.processBasic(path.newSubPath("underlierIdOtherLeg2"), String.class, getUnderlierIdOtherLeg2(), this);
			processor.processBasic(path.newSubPath("underlierIdOtherSourceLeg1"), String.class, getUnderlierIdOtherSourceLeg1(), this);
			processor.processBasic(path.newSubPath("underlierIdOtherSourceLeg2"), String.class, getUnderlierIdOtherSourceLeg2(), this);
			processor.processBasic(path.newSubPath("cdeUnderlyingAssetTradingPlatformIdLeg1"), String.class, getCdeUnderlyingAssetTradingPlatformIdLeg1(), this);
			processor.processBasic(path.newSubPath("cdeUnderlyingAssetTradingPlatformIdLeg2"), String.class, getCdeUnderlyingAssetTradingPlatformIdLeg2(), this);
			processor.processBasic(path.newSubPath("cdeUnderlyingAssetPriceSourceLeg1"), String.class, getCdeUnderlyingAssetPriceSourceLeg1(), this);
			processor.processBasic(path.newSubPath("cdeUnderlyingAssetPriceSourceLeg2"), String.class, getCdeUnderlyingAssetPriceSourceLeg2(), this);
		}
		

		HarmonizedData.HarmonizedDataBuilder prune();
	}

	/*********************** Immutable Implementation of HarmonizedData  ***********************/
	class HarmonizedDataImpl implements HarmonizedData {
		private final String leg2CommodityInstrumentId;
		private final String leg2CommodityUnderlyerId;
		private final String leg2CommodityUnderlyerDetails;
		private final String leg2CommodityUnitOfMeasure;
		private final String leg2CommodityCurrency;
		private final String leg2CommodityExchangeId;
		private final String leg1CommodityRateSource;
		private final String leg1CommodityRateSourcePage;
		private final String leg2SpecifiedPrice;
		private final Date commencementDateUnadjusted;
		private final Date exerciseExpirationDateUnadjusted;
		private final Date expirationDateUnadjusted;
		private final String leg2NotionalQuantityFrequency;
		private final BigDecimal leg2NotionalQuantity;
		private final BigDecimal leg2TotalNotionalQuantity;
		private final BigDecimal leg2SpreadAmount;
		private final String leg2SpreadCurrency;
		private final Date scheduledTerminationDateAdjusted;
		private final String leg1PartyPayer;
		private final String leg2PartyPayer;
		private final String leg1CommodityInstrumentId;
		private final String leg1CommodityUnderlyerId;
		private final String leg1CommodityUnitOfMeasure;
		private final String leg1CommodityExchangeId;
		private final String leg2CommodityRateSource;
		private final Date leg1EffectiveDateUnadjusted;
		private final Date leg2EffectiveDateUnadjusted;
		private final String coProductType;
		private final String totalQuantityUnit;
		private final BigDecimal totalQuantity;
		private final BigDecimal fixedPrice;
		private final String fixedPriceCurrency;
		private final String leg1NotionalQuantityUnit;
		private final String leg1NotionalQuantityFrequency;
		private final BigDecimal leg1NotionalQuantity;
		private final BigDecimal leg1TotalNotionalQuantity;
		private final String leg1CommodityCurrency;
		private final String leg1SpecifiedPrice;
		private final String leg1SpreadCurrency;
		private final BigDecimal leg1SpreadAmount;
		private final String leg2NotionalQuantityUnit;
		private final String leg2PartyReceiver;
		private final String leg1PartyReceiver;
		private final String coalSource;
		private final BigDecimal leg2Quantity;
		private final String commodityBase;
		private final String commodityDetails;
		private final String interconnectionPoint;
		private final String loadType;
		private final String fixedPriceUnit;
		private final Date exercisePaymentDateUnadjusted;
		private final Date leg1PaymentDatesUnadjusted;
		private final Date leg2PaymentDateUnadjusted;
		private final Date settlementDateUnadjusted;
		private final String deliveryLocation;
		private final String leg2QuantityUnit;
		private final String leg1CommodityUnderlyerDetails;
		private final String leg2CommodityRateSourcePage;
		private final Date valueDate;
		private final String gtrQuantityUnit;
		private final BigDecimal attachmentPoint;
		private final BigDecimal exhaustionPoint;
		private final BigDecimal mthToDefault;
		private final BigDecimal nthToDefault;
		private final String seniority;
		private final BigDecimal series;
		private final BigDecimal crversion;
		private final String tranche;
		private final BigDecimal indexFactor;
		private final String referenceObligation;
		private final String referenceObligationIdType;
		private final String underlyingFixedRatePayerBuyer;
		private final String underlyingFloatRatePayerSeller;
		private final String underlyingAssetExchangeId;
		private final BigDecimal underlyingAssetNumberOfUnits;
		private final String optionalEarlyTerminationType;
		private final String optionalEarlyTerminationElectingPartyValue;
		private final Boolean optionalEarlyTerminationIndicator;
		private final String underlyingAssetFloatingAmountPayer;
		private final String underlyingAssetFloatingAmountReceiver;
		private final String floatingRateOption;
		private final BigDecimal underlyingAssetFloatingLegSpread;
		private final String leg2DesignatedMaturityPeriod;
		private final BigDecimal leg2DesignatedMaturityPeriodMultiplier;
		private final String underlyingAssetEquityAmountPayer;
		private final String underlyingAssetEquityAmountReceiver;
		private final String underlyingAssetInitialPriceCurrency;
		private final Date leg1ValuationDates;
		private final String leg1TypeOfReturn;
		private final Date observationStartDate;
		private final BigDecimal varianceAmount;
		private final BigDecimal volatilityStrikePrice;
		private final BigDecimal varianceStrikePrice;
		private final BigDecimal varianceCapFactor;
		private final String referenceCurrency;
		private final String specialDividendsIndicator;
		private final String materialNoncashDividendIndicator;
		private final BigDecimal numberOfSharesUnits;
		private final String dividendAmountPayer;
		private final String dividendAmountReceiver;
		private final String fixedAmountPayer;
		private final String fixedAmountReceiver;
		private final String knockInEvent;
		private final String knockOutEvent;
		private final BigDecimal knockInPrice;
		private final BigDecimal knockOutPrice;
		private final String barrierType;
		private final LocalTime earliestExecutionTime;
		private final BigDecimal exchangeRate;
		private final String exchangeRateBasisCurrency1;
		private final String exchangeRateBasisCurrency2;
		private final Date executionPeriodStartDate;
		private final String payoutStyle;
		private final String rateQuoteBasis1;
		private final Date settlementFixingDate;
		private final String swapLinkId;
		private final String triggerCondition;
		private final String triggerCondition2;
		private final BigDecimal triggerRate;
		private final BigDecimal triggerRate2;
		private final String rateQuoteBasis2;
		private final BigDecimal forwardExchangeRate;
		private final String barrierType2;
		private final String cancelationOptionBuyer;
		private final Date cancelationOptionCommencementDate;
		private final String cancelationOptionExerciseStyleType;
		private final Date cancelationOptionExpirationDate;
		private final String cancelationOptionInitialFeeCurrency;
		private final String cancelationOptionInitialFeePayer;
		private final BigDecimal cancelationOptionPremiumAmount;
		private final String cancelationOptionSeller;
		private final BigDecimal capRateInitial;
		private final String couponType;
		private final Boolean finalPrincipalExchangeIndicatorAtTermination;
		private final BigDecimal floorRateInitial;
		private final String fraDiscountingType;
		private final BigDecimal inflationIndexInitialLevel;
		private final String inflationIndexMainPublication;
		private final String inflationInterpolationMethod;
		private final String inflationLagDayType;
		private final String inflationLagPeriod;
		private final String inflationRateSourceName;
		private final Boolean initialPrincipalExchangeIndicator;
		private final Boolean intermediatePrincipalExchangeIndicator;
		private final String leg1FloatingRateIndex;
		private final BigDecimal leg1FloatingRateInitialSpread;
		private final BigDecimal leg1FloatingRateMultiplierInitialValue;
		private final String leg1FloatingRateTenorPeriod;
		private final BigDecimal leg1FloatingRateTenorPeriodMultiplier;
		private final BigDecimal leg1KnownAmount;
		private final String leg1KnownAmountCurrency;
		private final String leg1ReferenceCurrency;
		private final String leg2FloatingRateIndex;
		private final BigDecimal leg2FloatingRateInitialSpread;
		private final BigDecimal leg2FloatingRateMultiplierInitialValue;
		private final String leg2FloatingRateTenorPeriod;
		private final BigDecimal leg2FloatingRateTenorPeriodMultiplier;
		private final BigDecimal leg2KnownAmount;
		private final String leg2KnownAmountCurrency;
		private final String leg2ReferenceCurrency;
		private final Date mandatoryEarlyTerminationDate;
		private final String mandatoryEarlyTerminationDateTenorPeriod;
		private final String mandatoryEarlyTerminationDateTenorPeriodMultiplier;
		private final BigDecimal notionalUnits;
		private final Date optionalEarlyTerminationCommencementDate;
		private final String optionalEarlyTerminationExerciseStyle;
		private final Date optionalEarlyTerminationExpirationDate;
		private final String premiumReceiver;
		private final BigDecimal underlyingCouponRate;
		private final Date underlyingMaturityDate;
		private final String underlyingProductId;
		private final String inflationLagPeriodMultiplier;
		private final String leg1FixedRateNotation;
		private final String leg2FixedRateNotation;
		private final String swaptionStraddleIndicator;
		private final String singlePartyEarlyTerminationBuyer;
		private final Date leg1EffectiveDate;
		private final String action;
		private final String clearingStatus;
		private final Date effectiveDate1;
		private final String executionVenueType;
		private final Boolean nonStandardTradeIndicator;
		private final BigDecimal notionalAmount1;
		private final String notionalCurrency1;
		private final BigDecimal price1Price;
		private final String price1Type;
		private final String price1Units;
		private final Date scheduledTerminationDate1;
		private final Date tradeDate;
		private final String tradeParty1CollateralizationType;
		private final String tradeParty1EventId;
		private final String tradeParty2CollateralizationType;
		private final String tradeParty2EventId;
		private final String embeddedOptionOnSwap;
		private final Date expirationDate;
		private final BigDecimal notionalAmount2;
		private final String notionalCurrency2;
		private final BigDecimal premiumAmount;
		private final String premiumCurrency;
		private final String version;
		private final String comment1;
		private final String optionStyle;
		private final String optionType;
		private final String settlementCurrency1;
		private final Date commencementDate;
		private final String dayCountFraction1;
		private final String leg2DayCountFraction;
		private final Date leg2EffectiveDate;
		private final String leg2ResetFrequencyPeriod;
		private final BigDecimal leg2ResetFrequencyPeriodMultiplier;
		private final String leg2SettlementCurrency;
		private final Date leg2ScheduledTerminationDate;
		private final BigDecimal numberOfOptions;
		private final BigDecimal optionEntitlement;
		private final ZonedDateTime originalExecutionTimestamp;
		private final Date payment1Date;
		private final String payment1FrequencyPeriod;
		private final BigDecimal payment1FrequencyPeriodMultiplier;
		private final Date payment2Date;
		private final String payment2FrequencyPeriod;
		private final BigDecimal payment2FrequencyPeriodMultiplier;
		private final String resetFrequencyPeriod1;
		private final BigDecimal resetFrequencyPeriodMultiplier1;
		private final Date settlementDate;
		private final BigDecimal strikePrice;
		private final String strikePriceUnits;
		private final ZonedDateTime asOfDateTime;
		private final String clearingVenueId;
		private final String clearingVenueIdType;
		private final String compressedTradeIndicator;
		private final String confirmationMethod;
		private final String confirmationPlatformId;
		private final String confirmationPlatformTradeId;
		private final String executionVenueId;
		private final String executionVenueIdType;
		private final Date postTradeEffectiveDate;
		private final String priorUsiId;
		private final String priorUsiIdPrefix;
		private final String priorUtiId;
		private final String priorUtiIdPrefix;
		private final String tradeParty1BranchLocation;
		private final String tradeParty1ClearingBrokerId;
		private final String tradeParty1ClearingBrokerIdType;
		private final String tradeParty1DeskLocation;
		private final String tradeParty1Domicile;
		private final String tradeParty1IndustrialSectorType;
		private final String tradeParty2BranchLocation;
		private final String tradeParty2DeskLocation;
		private final String tradeParty2Domicile;
		private final String tradeParty2IndustrialSectorType;
		private final String sellerPayer2;
		private final String buyerPayer1;
		private final String tradeParty1HkCounterpartyOrigin;
		private final Date leg2SettlementDate;
		private final BigDecimal leg1FixedRateInitial;
		private final BigDecimal leg2FixedRateInitial;
		private final BigDecimal payment1Amount;
		private final String payment1Currency;
		private final String payment1Payer;
		private final String payment1Receiver;
		private final String payment2Payer;
		private final Date postTradeTransactionDate;
		private final String secondaryAssetClass;
		private final String settlementType;
		private final String tradeParty1Name;
		private final String tradeParty2Name;
		private final BigDecimal ccpValuationAmount;
		private final String ccpValuationCurrency;
		private final ZonedDateTime ccpValuationDatetime;
		private final String ccpValuationType;
		private final BigDecimal tradeParty1ValuationAmount;
		private final String tradeParty1ValuationCurrency;
		private final ZonedDateTime tradeParty1ValuationDatetime;
		private final String tradeParty1ValuationType;
		private final BigDecimal tradeParty2ValuationAmount;
		private final String tradeParty2ValuationCurrency;
		private final ZonedDateTime tradeParty2ValuationDatetime;
		private final String tradeParty2ValuationType;
		private final String executionType;
		private final String strikePriceCurrency;
		private final BigDecimal payment2Amount;
		private final String tradeParty2HkCounterpartyOrigin;
		private final String tradeParty1CountryOfTheOtherCounterparty;
		private final String tradeParty2CountryOfTheOtherCounterparty;
		private final String tradeParty1BrokerId;
		private final String tradeParty2BrokerId;
		private final String tradeParty1BeneficiaryIdType;
		private final String tradeParty1BeneficiaryId;
		private final String tradeParty2BeneficiaryIdType;
		private final String tradeParty2BeneficiaryId;
		private final String tradeParty1CounterpartySide;
		private final String tradeParty2CounterpartySide;
		private final String tradeParty1CollateralPortfolioCode;
		private final String tradeParty2CollateralPortfolioCode;
		private final String contractType;
		private final String euUnderlyingAssetIdType;
		private final String productClassification;
		private final String complexTradeComponentId;
		private final BigDecimal priceMultiplier;
		private final BigDecimal quantity;
		private final String masterAgreementType;
		private final String masterAgreementVersion;
		private final ZonedDateTime confirmationDatetime;
		private final ZonedDateTime clearingDatetime;
		private final Date maturityDateOfTheUnderlying;
		private final String level;
		private final String productClassificationType;
		private final String productIdentificationType;
		private final String productIdentification;
		private final String euUnderlyingAssetId;
		private final String reportTrackingNumber;
		private final String tradeParty1BrokerIdType;
		private final String tradeParty2BrokerIdType;
		private final String tradeParty2ClearingBrokerIdType;
		private final String tradeParty2ClearingBrokerId;
		private final Boolean tradeParty1ClearingThreshold;
		private final Boolean tradeParty2ClearingThreshold;
		private final String tradeParty1CorporateSectorType;
		private final String tradeParty2CorporateSectorType;
		private final String tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		private final String tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		private final Boolean intragroupIndicator;
		private final String tradeParty1TradingCapacity1;
		private final String tradeParty2TradingCapacity1;
		private final String currencyOfPrice;
		private final String tradeParty1CollateralPortfolio;
		private final String tradeParty2CollateralPortfolio;
		private final String executionVenueMicCode;
		private final String payment2Currency;
		private final String expirationDateTimeBusinessCenter;
		private final LocalTime expirationTime;
		private final String expirationTimeType;
		private final String tradeParty1TraderLocation;
		private final String tradeParty2TraderLocation;
		private final BigDecimal payment3ResetFrequencyPeriodMultiplier;
		private final String payment3ResetFrequencyPeriod;
		private final BigDecimal payment4ResetFrequencyPeriodMultiplier;
		private final String payment4ResetFrequencyPeriod;
		private final BigDecimal payment5ResetFrequencyPeriodMultiplier;
		private final String payment5ResetFrequencyPeriod;
		private final String payment1Type;
		private final String payment1Reference;
		private final String payment2Type;
		private final String payment2Reference;
		private final String payment3Payer;
		private final String payment3Reference;
		private final String payment3FrequencyPeriod;
		private final BigDecimal payment3FrequencyPeriodMultiplier;
		private final Date payment3Date;
		private final String payment4Reference;
		private final String payment4Payer;
		private final String payment4FrequencyPeriod;
		private final BigDecimal payment4FrequencyPeriodMultiplier;
		private final Date payment4Date;
		private final String payment5Reference;
		private final String payment5Payer;
		private final String payment5FrequencyPeriod;
		private final BigDecimal payment5FrequencyPeriodMultiplier;
		private final Date payment5Date;
		private final String payment3Type;
		private final String premiumPayer;
		private final Date premiumPaymentDateUnadjusted;
		private final String tradeParty1NatureOfTheReportingCounterparty;
		private final String tradeParty2NatureOfTheReportingCounterparty;
		private final String reservedParticipantUse1;
		private final String reservedParticipantUse2;
		private final String reservedParticipantUse3;
		private final String reservedParticipantUse4;
		private final String reservedParticipantUse5;
		private final Date leg1TerminationDate;
		private final String allocationType;
		private final String calculationBasis;
		private final String clearingExceptionPartyId;
		private final String clearingExceptionPartyIdType;
		private final String clearingExceptionType;
		private final String clearingMemberClientAccountId;
		private final ZonedDateTime clearingReceiptDatetime;
		private final String clearingSwapSdrLeiId;
		private final String clearingSwapUtiId;
		private final Date collateralReportingDate;
		private final ZonedDateTime collateralValuationDatetime;
		private final String comment2;
		private final String commodityStrikePriceUnit;
		private final String executionAgentMaskingIndicator;
		private final String feeInCurrency;
		private final String feeOutCurrency;
		private final BigDecimal floatingRatePaymentFrequencyLeg1Multiplier;
		private final String floatingRatePaymentFrequencyLeg1TimePeriod;
		private final BigDecimal floatingRatePaymentFrequencyLeg2Multiplier;
		private final String floatingRatePaymentFrequencyLeg2TimePeriod;
		private final String frequencyOfPayment;
		private final Boolean interaffiliate;
		private final Boolean largeTradeIndicator;
		private final Date leg1EffectiveDateAdjusted;
		private final Date leg1FinalValuationDate;
		private final String leg1SettlementPeriod;
		private final Date leg2EffectiveDateAdjusted;
		private final String leg2PaymentTermsFrequencyPeriod;
		private final BigDecimal leg2PaymentTermsPaymentFrequencyPeriodMultiplier;
		private final String leg2SettlementType;
		private final String leg2UnderlyingAssetId;
		private final String leg2UnderlyingAssetIdType;
		private final String leg2UnderlyingAssetName;
		private final Date maturityDate;
		private final String optionalEarlyTerminationDate;
		private final String optionCommodityCurrency;
		private final String optionCommodityExchangeId;
		private final String optionCommodityInstrumentId;
		private final String optionCommodityRateSource;
		private final String optionCommodityRateSourcePage;
		private final String optionCommodityUnderlyerDetails;
		private final String optionCommodityUnderlyerId;
		private final String optionCommodityUnitOfMeasure;
		private final String optionSpecifiedPrice;
		private final BigDecimal optionSpreadAmount;
		private final String optionSpreadCurrency;
		private final String optionSpreadSchedule;
		private final String origin;
		private final String originalSwapSdrId;
		private final String originalSwapSdrIdType;
		private final String paymentFrequencyPeriodLeg1;
		private final String paymentFrequencyPeriodLeg2;
		private final BigDecimal paymentFrequencyPeriodMultiplierLeg1;
		private final BigDecimal paymentFrequencyPeriodMultiplierLeg2;
		private final String premiumPayerPrefix;
		private final String price1Currency;
		private final BigDecimal price2Price;
		private final String price2Type;
		private final String price2Units;
		private final BigDecimal price3Price;
		private final String price3Type;
		private final String price3Units;
		private final BigDecimal price4Price;
		private final String price4Type;
		private final String price4Units;
		private final String pricingContext;
		private final String priorUsiType;
		private final String priorUtiType;
		private final BigDecimal recoveryPrice;
		private final String sendToDataCenterCode;
		private final String strikePriceType;
		private final String subAssetClassForOtherCommodity;
		private final String tradeParty1CftcFinancialEntityStatus;
		private final BigDecimal tradeParty1CollateralAmount;
		private final String tradeParty1CollateralCurrency;
		private final String tradeParty1MandatoryDelegatedReporting;
		private final String tradeParty1Role;
		private final String tradeParty2CftcFinancialEntityStatus;
		private final BigDecimal tradeParty2CollateralAmount;
		private final String tradeParty2CollateralCurrency;
		private final String tradeParty2MandatoryDelegatedReporting;
		private final String tradeParty2Role;
		private final BigDecimal upfrontPayment;
		private final String verificationMethod;
		private final String responsibleDataSubmitterId;
		private final String responsibleDataSubmitterIdType;
		private final String originalSwapUsi;
		private final String originalSwapUti;
		private final String cdeReceiverIdentifierLeg2;
		private final Boolean counterparty1FederalEntityIndicator;
		private final Boolean counterparty2FederalEntityIndicator;
		private final Boolean customBasketIndicator;
		private final String noaActionType;
		private final String eventType;
		private final Boolean amendmentIndicator;
		private final String eventIdentifier;
		private final BigDecimal cdeCallAmountLeg1;
		private final BigDecimal cdeCallAmountLeg2;
		private final String cdeCallCurrencyLeg1;
		private final String cdeCallCurrencyLeg2;
		private final BigDecimal cdePutAmountLeg1;
		private final BigDecimal cdePutAmountLeg2;
		private final String cdePutCurrencyLeg1;
		private final String cdePutCurrencyLeg2;
		private final String leg2QuantityFrequency;
		private final BigDecimal quantityFrequencyMultiplierLeg1;
		private final BigDecimal quantityFrequencyMultiplierLeg2;
		private final String cdeQuantityUnitOfMeasureLeg1;
		private final String cdeQuantityUnitOfMeasureLeg2;
		private final Boolean packageIndicator;
		private final String cdePackageIdentifier;
		private final BigDecimal cdePackageTransactionPrice;
		private final String cdePackageTransactionPriceCurrency;
		private final String cdePackageTransactionPriceNotation;
		private final BigDecimal cdePackageTransactionSpread;
		private final String cdePackageTransactionSpreadCurrency;
		private final String cdePackageTransactionSpreadNotation;
		private final String cdeFixedRateDayCountConventionLeg1;
		private final String cdeFixedRateDayCountConventionLeg2;
		private final String cdeFloatingRateDayCountConventionLeg1;
		private final String cdeFloatingRateDayCountConventionLeg2;
		private final Date fixingDateLeg1;
		private final Date fixingDateLeg2;
		private final String cdeFixedRatePaymentFrequencyPeriodLeg1;
		private final String cdeFixedRatePaymentFrequencyPeriodLeg2;
		private final String cdeFloatingRatePaymentFrequencyPeriodLeg1;
		private final String cdeFloatingRatePaymentFrequencyPeriodLeg2;
		private final BigDecimal cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1;
		private final BigDecimal cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2;
		private final BigDecimal cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1;
		private final BigDecimal cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2;
		private final Boolean postPricedSwapIndicator;
		private final String cdePriceCurrency;
		private final String cdePriceNotation;
		private final String cdeSpreadNotationLeg1;
		private final String cdeSpreadNotationLeg2;
		private final String cdeStrikePriceCurrency2;
		private final String cdeStrikePriceNotation;
		private final Date cdeFirstExerciseDate;
		private final Date cdeFinalContractualSettlementDate;
		private final String cdeSettlementLocationLeg1;
		private final String cdeSettlementLocationLeg2;
		private final Date cdeEffectiveDate;
		private final Date cdeExpirationDate;
		private final String cdePlatformIdentifier;
		private final Boolean primeBrokerageTransactionIndicator;
		private final String swapReportingJurisdiction;
		private final String newSdrIdentifier;
		private final Date nextFloatingReferenceResetDateLeg1;
		private final BigDecimal lastFloatingReferenceValueLeg1;
		private final Date lastFloatingReferenceResetDateLeg1;
		private final Date nextFloatingReferenceResetDateLeg2;
		private final BigDecimal lastFloatingReferenceValueLeg2;
		private final Date lastFloatingReferenceResetDateLeg2;
		private final BigDecimal cdeDelta;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		private final Boolean largeNotionalOffFacilitySwapElectionIndicator;
		private final Boolean sefOrDcmAnonymousExecutionIndicator;
		private final Boolean blockTradeElectionIndicator;
		private final Boolean sefOrDcmIndicator;
		private final Boolean mandatoryClearingIndicator;
		private final Boolean sdMspIndicatorCounterparty1;
		private final Boolean sdMspIndicatorCounterparty2;
		private final Boolean physicalCommodityContractIndicator;
		private final BigDecimal changeInNotionalAmount1;
		private final BigDecimal changeInNotionalAmount2;
		private final BigDecimal changeInLeg1NotionalQuantity;
		private final BigDecimal changeInLeg2NotionalQuantity;
		private final Boolean cdeCryptoAssetUnderlyingIndicatorLeg1;
		private final Boolean cdeCryptoAssetUnderlyingIndicatorLeg2;
		private final String cdeCustomBasketCode;
		private final String underlierIdOtherLeg1;
		private final String underlierIdOtherLeg2;
		private final String underlierIdOtherSourceLeg1;
		private final String underlierIdOtherSourceLeg2;
		private final String cdeUnderlyingAssetTradingPlatformIdLeg1;
		private final String cdeUnderlyingAssetTradingPlatformIdLeg2;
		private final String cdeUnderlyingAssetPriceSourceLeg1;
		private final String cdeUnderlyingAssetPriceSourceLeg2;
		
		protected HarmonizedDataImpl(HarmonizedData.HarmonizedDataBuilder builder) {
			this.leg2CommodityInstrumentId = builder.getLeg2CommodityInstrumentId();
			this.leg2CommodityUnderlyerId = builder.getLeg2CommodityUnderlyerId();
			this.leg2CommodityUnderlyerDetails = builder.getLeg2CommodityUnderlyerDetails();
			this.leg2CommodityUnitOfMeasure = builder.getLeg2CommodityUnitOfMeasure();
			this.leg2CommodityCurrency = builder.getLeg2CommodityCurrency();
			this.leg2CommodityExchangeId = builder.getLeg2CommodityExchangeId();
			this.leg1CommodityRateSource = builder.getLeg1CommodityRateSource();
			this.leg1CommodityRateSourcePage = builder.getLeg1CommodityRateSourcePage();
			this.leg2SpecifiedPrice = builder.getLeg2SpecifiedPrice();
			this.commencementDateUnadjusted = builder.getCommencementDateUnadjusted();
			this.exerciseExpirationDateUnadjusted = builder.getExerciseExpirationDateUnadjusted();
			this.expirationDateUnadjusted = builder.getExpirationDateUnadjusted();
			this.leg2NotionalQuantityFrequency = builder.getLeg2NotionalQuantityFrequency();
			this.leg2NotionalQuantity = builder.getLeg2NotionalQuantity();
			this.leg2TotalNotionalQuantity = builder.getLeg2TotalNotionalQuantity();
			this.leg2SpreadAmount = builder.getLeg2SpreadAmount();
			this.leg2SpreadCurrency = builder.getLeg2SpreadCurrency();
			this.scheduledTerminationDateAdjusted = builder.getScheduledTerminationDateAdjusted();
			this.leg1PartyPayer = builder.getLeg1PartyPayer();
			this.leg2PartyPayer = builder.getLeg2PartyPayer();
			this.leg1CommodityInstrumentId = builder.getLeg1CommodityInstrumentId();
			this.leg1CommodityUnderlyerId = builder.getLeg1CommodityUnderlyerId();
			this.leg1CommodityUnitOfMeasure = builder.getLeg1CommodityUnitOfMeasure();
			this.leg1CommodityExchangeId = builder.getLeg1CommodityExchangeId();
			this.leg2CommodityRateSource = builder.getLeg2CommodityRateSource();
			this.leg1EffectiveDateUnadjusted = builder.getLeg1EffectiveDateUnadjusted();
			this.leg2EffectiveDateUnadjusted = builder.getLeg2EffectiveDateUnadjusted();
			this.coProductType = builder.getCoProductType();
			this.totalQuantityUnit = builder.getTotalQuantityUnit();
			this.totalQuantity = builder.getTotalQuantity();
			this.fixedPrice = builder.getFixedPrice();
			this.fixedPriceCurrency = builder.getFixedPriceCurrency();
			this.leg1NotionalQuantityUnit = builder.getLeg1NotionalQuantityUnit();
			this.leg1NotionalQuantityFrequency = builder.getLeg1NotionalQuantityFrequency();
			this.leg1NotionalQuantity = builder.getLeg1NotionalQuantity();
			this.leg1TotalNotionalQuantity = builder.getLeg1TotalNotionalQuantity();
			this.leg1CommodityCurrency = builder.getLeg1CommodityCurrency();
			this.leg1SpecifiedPrice = builder.getLeg1SpecifiedPrice();
			this.leg1SpreadCurrency = builder.getLeg1SpreadCurrency();
			this.leg1SpreadAmount = builder.getLeg1SpreadAmount();
			this.leg2NotionalQuantityUnit = builder.getLeg2NotionalQuantityUnit();
			this.leg2PartyReceiver = builder.getLeg2PartyReceiver();
			this.leg1PartyReceiver = builder.getLeg1PartyReceiver();
			this.coalSource = builder.getCoalSource();
			this.leg2Quantity = builder.getLeg2Quantity();
			this.commodityBase = builder.getCommodityBase();
			this.commodityDetails = builder.getCommodityDetails();
			this.interconnectionPoint = builder.getInterconnectionPoint();
			this.loadType = builder.getLoadType();
			this.fixedPriceUnit = builder.getFixedPriceUnit();
			this.exercisePaymentDateUnadjusted = builder.getExercisePaymentDateUnadjusted();
			this.leg1PaymentDatesUnadjusted = builder.getLeg1PaymentDatesUnadjusted();
			this.leg2PaymentDateUnadjusted = builder.getLeg2PaymentDateUnadjusted();
			this.settlementDateUnadjusted = builder.getSettlementDateUnadjusted();
			this.deliveryLocation = builder.getDeliveryLocation();
			this.leg2QuantityUnit = builder.getLeg2QuantityUnit();
			this.leg1CommodityUnderlyerDetails = builder.getLeg1CommodityUnderlyerDetails();
			this.leg2CommodityRateSourcePage = builder.getLeg2CommodityRateSourcePage();
			this.valueDate = builder.getValueDate();
			this.gtrQuantityUnit = builder.getGtrQuantityUnit();
			this.attachmentPoint = builder.getAttachmentPoint();
			this.exhaustionPoint = builder.getExhaustionPoint();
			this.mthToDefault = builder.getMthToDefault();
			this.nthToDefault = builder.getNthToDefault();
			this.seniority = builder.getSeniority();
			this.series = builder.getSeries();
			this.crversion = builder.getCrversion();
			this.tranche = builder.getTranche();
			this.indexFactor = builder.getIndexFactor();
			this.referenceObligation = builder.getReferenceObligation();
			this.referenceObligationIdType = builder.getReferenceObligationIdType();
			this.underlyingFixedRatePayerBuyer = builder.getUnderlyingFixedRatePayerBuyer();
			this.underlyingFloatRatePayerSeller = builder.getUnderlyingFloatRatePayerSeller();
			this.underlyingAssetExchangeId = builder.getUnderlyingAssetExchangeId();
			this.underlyingAssetNumberOfUnits = builder.getUnderlyingAssetNumberOfUnits();
			this.optionalEarlyTerminationType = builder.getOptionalEarlyTerminationType();
			this.optionalEarlyTerminationElectingPartyValue = builder.getOptionalEarlyTerminationElectingPartyValue();
			this.optionalEarlyTerminationIndicator = builder.getOptionalEarlyTerminationIndicator();
			this.underlyingAssetFloatingAmountPayer = builder.getUnderlyingAssetFloatingAmountPayer();
			this.underlyingAssetFloatingAmountReceiver = builder.getUnderlyingAssetFloatingAmountReceiver();
			this.floatingRateOption = builder.getFloatingRateOption();
			this.underlyingAssetFloatingLegSpread = builder.getUnderlyingAssetFloatingLegSpread();
			this.leg2DesignatedMaturityPeriod = builder.getLeg2DesignatedMaturityPeriod();
			this.leg2DesignatedMaturityPeriodMultiplier = builder.getLeg2DesignatedMaturityPeriodMultiplier();
			this.underlyingAssetEquityAmountPayer = builder.getUnderlyingAssetEquityAmountPayer();
			this.underlyingAssetEquityAmountReceiver = builder.getUnderlyingAssetEquityAmountReceiver();
			this.underlyingAssetInitialPriceCurrency = builder.getUnderlyingAssetInitialPriceCurrency();
			this.leg1ValuationDates = builder.getLeg1ValuationDates();
			this.leg1TypeOfReturn = builder.getLeg1TypeOfReturn();
			this.observationStartDate = builder.getObservationStartDate();
			this.varianceAmount = builder.getVarianceAmount();
			this.volatilityStrikePrice = builder.getVolatilityStrikePrice();
			this.varianceStrikePrice = builder.getVarianceStrikePrice();
			this.varianceCapFactor = builder.getVarianceCapFactor();
			this.referenceCurrency = builder.getReferenceCurrency();
			this.specialDividendsIndicator = builder.getSpecialDividendsIndicator();
			this.materialNoncashDividendIndicator = builder.getMaterialNoncashDividendIndicator();
			this.numberOfSharesUnits = builder.getNumberOfSharesUnits();
			this.dividendAmountPayer = builder.getDividendAmountPayer();
			this.dividendAmountReceiver = builder.getDividendAmountReceiver();
			this.fixedAmountPayer = builder.getFixedAmountPayer();
			this.fixedAmountReceiver = builder.getFixedAmountReceiver();
			this.knockInEvent = builder.getKnockInEvent();
			this.knockOutEvent = builder.getKnockOutEvent();
			this.knockInPrice = builder.getKnockInPrice();
			this.knockOutPrice = builder.getKnockOutPrice();
			this.barrierType = builder.getBarrierType();
			this.earliestExecutionTime = builder.getEarliestExecutionTime();
			this.exchangeRate = builder.getExchangeRate();
			this.exchangeRateBasisCurrency1 = builder.getExchangeRateBasisCurrency1();
			this.exchangeRateBasisCurrency2 = builder.getExchangeRateBasisCurrency2();
			this.executionPeriodStartDate = builder.getExecutionPeriodStartDate();
			this.payoutStyle = builder.getPayoutStyle();
			this.rateQuoteBasis1 = builder.getRateQuoteBasis1();
			this.settlementFixingDate = builder.getSettlementFixingDate();
			this.swapLinkId = builder.getSwapLinkId();
			this.triggerCondition = builder.getTriggerCondition();
			this.triggerCondition2 = builder.getTriggerCondition2();
			this.triggerRate = builder.getTriggerRate();
			this.triggerRate2 = builder.getTriggerRate2();
			this.rateQuoteBasis2 = builder.getRateQuoteBasis2();
			this.forwardExchangeRate = builder.getForwardExchangeRate();
			this.barrierType2 = builder.getBarrierType2();
			this.cancelationOptionBuyer = builder.getCancelationOptionBuyer();
			this.cancelationOptionCommencementDate = builder.getCancelationOptionCommencementDate();
			this.cancelationOptionExerciseStyleType = builder.getCancelationOptionExerciseStyleType();
			this.cancelationOptionExpirationDate = builder.getCancelationOptionExpirationDate();
			this.cancelationOptionInitialFeeCurrency = builder.getCancelationOptionInitialFeeCurrency();
			this.cancelationOptionInitialFeePayer = builder.getCancelationOptionInitialFeePayer();
			this.cancelationOptionPremiumAmount = builder.getCancelationOptionPremiumAmount();
			this.cancelationOptionSeller = builder.getCancelationOptionSeller();
			this.capRateInitial = builder.getCapRateInitial();
			this.couponType = builder.getCouponType();
			this.finalPrincipalExchangeIndicatorAtTermination = builder.getFinalPrincipalExchangeIndicatorAtTermination();
			this.floorRateInitial = builder.getFloorRateInitial();
			this.fraDiscountingType = builder.getFraDiscountingType();
			this.inflationIndexInitialLevel = builder.getInflationIndexInitialLevel();
			this.inflationIndexMainPublication = builder.getInflationIndexMainPublication();
			this.inflationInterpolationMethod = builder.getInflationInterpolationMethod();
			this.inflationLagDayType = builder.getInflationLagDayType();
			this.inflationLagPeriod = builder.getInflationLagPeriod();
			this.inflationRateSourceName = builder.getInflationRateSourceName();
			this.initialPrincipalExchangeIndicator = builder.getInitialPrincipalExchangeIndicator();
			this.intermediatePrincipalExchangeIndicator = builder.getIntermediatePrincipalExchangeIndicator();
			this.leg1FloatingRateIndex = builder.getLeg1FloatingRateIndex();
			this.leg1FloatingRateInitialSpread = builder.getLeg1FloatingRateInitialSpread();
			this.leg1FloatingRateMultiplierInitialValue = builder.getLeg1FloatingRateMultiplierInitialValue();
			this.leg1FloatingRateTenorPeriod = builder.getLeg1FloatingRateTenorPeriod();
			this.leg1FloatingRateTenorPeriodMultiplier = builder.getLeg1FloatingRateTenorPeriodMultiplier();
			this.leg1KnownAmount = builder.getLeg1KnownAmount();
			this.leg1KnownAmountCurrency = builder.getLeg1KnownAmountCurrency();
			this.leg1ReferenceCurrency = builder.getLeg1ReferenceCurrency();
			this.leg2FloatingRateIndex = builder.getLeg2FloatingRateIndex();
			this.leg2FloatingRateInitialSpread = builder.getLeg2FloatingRateInitialSpread();
			this.leg2FloatingRateMultiplierInitialValue = builder.getLeg2FloatingRateMultiplierInitialValue();
			this.leg2FloatingRateTenorPeriod = builder.getLeg2FloatingRateTenorPeriod();
			this.leg2FloatingRateTenorPeriodMultiplier = builder.getLeg2FloatingRateTenorPeriodMultiplier();
			this.leg2KnownAmount = builder.getLeg2KnownAmount();
			this.leg2KnownAmountCurrency = builder.getLeg2KnownAmountCurrency();
			this.leg2ReferenceCurrency = builder.getLeg2ReferenceCurrency();
			this.mandatoryEarlyTerminationDate = builder.getMandatoryEarlyTerminationDate();
			this.mandatoryEarlyTerminationDateTenorPeriod = builder.getMandatoryEarlyTerminationDateTenorPeriod();
			this.mandatoryEarlyTerminationDateTenorPeriodMultiplier = builder.getMandatoryEarlyTerminationDateTenorPeriodMultiplier();
			this.notionalUnits = builder.getNotionalUnits();
			this.optionalEarlyTerminationCommencementDate = builder.getOptionalEarlyTerminationCommencementDate();
			this.optionalEarlyTerminationExerciseStyle = builder.getOptionalEarlyTerminationExerciseStyle();
			this.optionalEarlyTerminationExpirationDate = builder.getOptionalEarlyTerminationExpirationDate();
			this.premiumReceiver = builder.getPremiumReceiver();
			this.underlyingCouponRate = builder.getUnderlyingCouponRate();
			this.underlyingMaturityDate = builder.getUnderlyingMaturityDate();
			this.underlyingProductId = builder.getUnderlyingProductId();
			this.inflationLagPeriodMultiplier = builder.getInflationLagPeriodMultiplier();
			this.leg1FixedRateNotation = builder.getLeg1FixedRateNotation();
			this.leg2FixedRateNotation = builder.getLeg2FixedRateNotation();
			this.swaptionStraddleIndicator = builder.getSwaptionStraddleIndicator();
			this.singlePartyEarlyTerminationBuyer = builder.getSinglePartyEarlyTerminationBuyer();
			this.leg1EffectiveDate = builder.getLeg1EffectiveDate();
			this.action = builder.getAction();
			this.clearingStatus = builder.getClearingStatus();
			this.effectiveDate1 = builder.getEffectiveDate1();
			this.executionVenueType = builder.getExecutionVenueType();
			this.nonStandardTradeIndicator = builder.getNonStandardTradeIndicator();
			this.notionalAmount1 = builder.getNotionalAmount1();
			this.notionalCurrency1 = builder.getNotionalCurrency1();
			this.price1Price = builder.getPrice1Price();
			this.price1Type = builder.getPrice1Type();
			this.price1Units = builder.getPrice1Units();
			this.scheduledTerminationDate1 = builder.getScheduledTerminationDate1();
			this.tradeDate = builder.getTradeDate();
			this.tradeParty1CollateralizationType = builder.getTradeParty1CollateralizationType();
			this.tradeParty1EventId = builder.getTradeParty1EventId();
			this.tradeParty2CollateralizationType = builder.getTradeParty2CollateralizationType();
			this.tradeParty2EventId = builder.getTradeParty2EventId();
			this.embeddedOptionOnSwap = builder.getEmbeddedOptionOnSwap();
			this.expirationDate = builder.getExpirationDate();
			this.notionalAmount2 = builder.getNotionalAmount2();
			this.notionalCurrency2 = builder.getNotionalCurrency2();
			this.premiumAmount = builder.getPremiumAmount();
			this.premiumCurrency = builder.getPremiumCurrency();
			this.version = builder.getVersion();
			this.comment1 = builder.getComment1();
			this.optionStyle = builder.getOptionStyle();
			this.optionType = builder.getOptionType();
			this.settlementCurrency1 = builder.getSettlementCurrency1();
			this.commencementDate = builder.getCommencementDate();
			this.dayCountFraction1 = builder.getDayCountFraction1();
			this.leg2DayCountFraction = builder.getLeg2DayCountFraction();
			this.leg2EffectiveDate = builder.getLeg2EffectiveDate();
			this.leg2ResetFrequencyPeriod = builder.getLeg2ResetFrequencyPeriod();
			this.leg2ResetFrequencyPeriodMultiplier = builder.getLeg2ResetFrequencyPeriodMultiplier();
			this.leg2SettlementCurrency = builder.getLeg2SettlementCurrency();
			this.leg2ScheduledTerminationDate = builder.getLeg2ScheduledTerminationDate();
			this.numberOfOptions = builder.getNumberOfOptions();
			this.optionEntitlement = builder.getOptionEntitlement();
			this.originalExecutionTimestamp = builder.getOriginalExecutionTimestamp();
			this.payment1Date = builder.getPayment1Date();
			this.payment1FrequencyPeriod = builder.getPayment1FrequencyPeriod();
			this.payment1FrequencyPeriodMultiplier = builder.getPayment1FrequencyPeriodMultiplier();
			this.payment2Date = builder.getPayment2Date();
			this.payment2FrequencyPeriod = builder.getPayment2FrequencyPeriod();
			this.payment2FrequencyPeriodMultiplier = builder.getPayment2FrequencyPeriodMultiplier();
			this.resetFrequencyPeriod1 = builder.getResetFrequencyPeriod1();
			this.resetFrequencyPeriodMultiplier1 = builder.getResetFrequencyPeriodMultiplier1();
			this.settlementDate = builder.getSettlementDate();
			this.strikePrice = builder.getStrikePrice();
			this.strikePriceUnits = builder.getStrikePriceUnits();
			this.asOfDateTime = builder.getAsOfDateTime();
			this.clearingVenueId = builder.getClearingVenueId();
			this.clearingVenueIdType = builder.getClearingVenueIdType();
			this.compressedTradeIndicator = builder.getCompressedTradeIndicator();
			this.confirmationMethod = builder.getConfirmationMethod();
			this.confirmationPlatformId = builder.getConfirmationPlatformId();
			this.confirmationPlatformTradeId = builder.getConfirmationPlatformTradeId();
			this.executionVenueId = builder.getExecutionVenueId();
			this.executionVenueIdType = builder.getExecutionVenueIdType();
			this.postTradeEffectiveDate = builder.getPostTradeEffectiveDate();
			this.priorUsiId = builder.getPriorUsiId();
			this.priorUsiIdPrefix = builder.getPriorUsiIdPrefix();
			this.priorUtiId = builder.getPriorUtiId();
			this.priorUtiIdPrefix = builder.getPriorUtiIdPrefix();
			this.tradeParty1BranchLocation = builder.getTradeParty1BranchLocation();
			this.tradeParty1ClearingBrokerId = builder.getTradeParty1ClearingBrokerId();
			this.tradeParty1ClearingBrokerIdType = builder.getTradeParty1ClearingBrokerIdType();
			this.tradeParty1DeskLocation = builder.getTradeParty1DeskLocation();
			this.tradeParty1Domicile = builder.getTradeParty1Domicile();
			this.tradeParty1IndustrialSectorType = builder.getTradeParty1IndustrialSectorType();
			this.tradeParty2BranchLocation = builder.getTradeParty2BranchLocation();
			this.tradeParty2DeskLocation = builder.getTradeParty2DeskLocation();
			this.tradeParty2Domicile = builder.getTradeParty2Domicile();
			this.tradeParty2IndustrialSectorType = builder.getTradeParty2IndustrialSectorType();
			this.sellerPayer2 = builder.getSellerPayer2();
			this.buyerPayer1 = builder.getBuyerPayer1();
			this.tradeParty1HkCounterpartyOrigin = builder.getTradeParty1HkCounterpartyOrigin();
			this.leg2SettlementDate = builder.getLeg2SettlementDate();
			this.leg1FixedRateInitial = builder.getLeg1FixedRateInitial();
			this.leg2FixedRateInitial = builder.getLeg2FixedRateInitial();
			this.payment1Amount = builder.getPayment1Amount();
			this.payment1Currency = builder.getPayment1Currency();
			this.payment1Payer = builder.getPayment1Payer();
			this.payment1Receiver = builder.getPayment1Receiver();
			this.payment2Payer = builder.getPayment2Payer();
			this.postTradeTransactionDate = builder.getPostTradeTransactionDate();
			this.secondaryAssetClass = builder.getSecondaryAssetClass();
			this.settlementType = builder.getSettlementType();
			this.tradeParty1Name = builder.getTradeParty1Name();
			this.tradeParty2Name = builder.getTradeParty2Name();
			this.ccpValuationAmount = builder.getCcpValuationAmount();
			this.ccpValuationCurrency = builder.getCcpValuationCurrency();
			this.ccpValuationDatetime = builder.getCcpValuationDatetime();
			this.ccpValuationType = builder.getCcpValuationType();
			this.tradeParty1ValuationAmount = builder.getTradeParty1ValuationAmount();
			this.tradeParty1ValuationCurrency = builder.getTradeParty1ValuationCurrency();
			this.tradeParty1ValuationDatetime = builder.getTradeParty1ValuationDatetime();
			this.tradeParty1ValuationType = builder.getTradeParty1ValuationType();
			this.tradeParty2ValuationAmount = builder.getTradeParty2ValuationAmount();
			this.tradeParty2ValuationCurrency = builder.getTradeParty2ValuationCurrency();
			this.tradeParty2ValuationDatetime = builder.getTradeParty2ValuationDatetime();
			this.tradeParty2ValuationType = builder.getTradeParty2ValuationType();
			this.executionType = builder.getExecutionType();
			this.strikePriceCurrency = builder.getStrikePriceCurrency();
			this.payment2Amount = builder.getPayment2Amount();
			this.tradeParty2HkCounterpartyOrigin = builder.getTradeParty2HkCounterpartyOrigin();
			this.tradeParty1CountryOfTheOtherCounterparty = builder.getTradeParty1CountryOfTheOtherCounterparty();
			this.tradeParty2CountryOfTheOtherCounterparty = builder.getTradeParty2CountryOfTheOtherCounterparty();
			this.tradeParty1BrokerId = builder.getTradeParty1BrokerId();
			this.tradeParty2BrokerId = builder.getTradeParty2BrokerId();
			this.tradeParty1BeneficiaryIdType = builder.getTradeParty1BeneficiaryIdType();
			this.tradeParty1BeneficiaryId = builder.getTradeParty1BeneficiaryId();
			this.tradeParty2BeneficiaryIdType = builder.getTradeParty2BeneficiaryIdType();
			this.tradeParty2BeneficiaryId = builder.getTradeParty2BeneficiaryId();
			this.tradeParty1CounterpartySide = builder.getTradeParty1CounterpartySide();
			this.tradeParty2CounterpartySide = builder.getTradeParty2CounterpartySide();
			this.tradeParty1CollateralPortfolioCode = builder.getTradeParty1CollateralPortfolioCode();
			this.tradeParty2CollateralPortfolioCode = builder.getTradeParty2CollateralPortfolioCode();
			this.contractType = builder.getContractType();
			this.euUnderlyingAssetIdType = builder.getEuUnderlyingAssetIdType();
			this.productClassification = builder.getProductClassification();
			this.complexTradeComponentId = builder.getComplexTradeComponentId();
			this.priceMultiplier = builder.getPriceMultiplier();
			this.quantity = builder.getQuantity();
			this.masterAgreementType = builder.getMasterAgreementType();
			this.masterAgreementVersion = builder.getMasterAgreementVersion();
			this.confirmationDatetime = builder.getConfirmationDatetime();
			this.clearingDatetime = builder.getClearingDatetime();
			this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
			this.level = builder.getLevel();
			this.productClassificationType = builder.getProductClassificationType();
			this.productIdentificationType = builder.getProductIdentificationType();
			this.productIdentification = builder.getProductIdentification();
			this.euUnderlyingAssetId = builder.getEuUnderlyingAssetId();
			this.reportTrackingNumber = builder.getReportTrackingNumber();
			this.tradeParty1BrokerIdType = builder.getTradeParty1BrokerIdType();
			this.tradeParty2BrokerIdType = builder.getTradeParty2BrokerIdType();
			this.tradeParty2ClearingBrokerIdType = builder.getTradeParty2ClearingBrokerIdType();
			this.tradeParty2ClearingBrokerId = builder.getTradeParty2ClearingBrokerId();
			this.tradeParty1ClearingThreshold = builder.getTradeParty1ClearingThreshold();
			this.tradeParty2ClearingThreshold = builder.getTradeParty2ClearingThreshold();
			this.tradeParty1CorporateSectorType = builder.getTradeParty1CorporateSectorType();
			this.tradeParty2CorporateSectorType = builder.getTradeParty2CorporateSectorType();
			this.tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator = builder.getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator();
			this.tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator = builder.getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator();
			this.intragroupIndicator = builder.getIntragroupIndicator();
			this.tradeParty1TradingCapacity1 = builder.getTradeParty1TradingCapacity1();
			this.tradeParty2TradingCapacity1 = builder.getTradeParty2TradingCapacity1();
			this.currencyOfPrice = builder.getCurrencyOfPrice();
			this.tradeParty1CollateralPortfolio = builder.getTradeParty1CollateralPortfolio();
			this.tradeParty2CollateralPortfolio = builder.getTradeParty2CollateralPortfolio();
			this.executionVenueMicCode = builder.getExecutionVenueMicCode();
			this.payment2Currency = builder.getPayment2Currency();
			this.expirationDateTimeBusinessCenter = builder.getExpirationDateTimeBusinessCenter();
			this.expirationTime = builder.getExpirationTime();
			this.expirationTimeType = builder.getExpirationTimeType();
			this.tradeParty1TraderLocation = builder.getTradeParty1TraderLocation();
			this.tradeParty2TraderLocation = builder.getTradeParty2TraderLocation();
			this.payment3ResetFrequencyPeriodMultiplier = builder.getPayment3ResetFrequencyPeriodMultiplier();
			this.payment3ResetFrequencyPeriod = builder.getPayment3ResetFrequencyPeriod();
			this.payment4ResetFrequencyPeriodMultiplier = builder.getPayment4ResetFrequencyPeriodMultiplier();
			this.payment4ResetFrequencyPeriod = builder.getPayment4ResetFrequencyPeriod();
			this.payment5ResetFrequencyPeriodMultiplier = builder.getPayment5ResetFrequencyPeriodMultiplier();
			this.payment5ResetFrequencyPeriod = builder.getPayment5ResetFrequencyPeriod();
			this.payment1Type = builder.getPayment1Type();
			this.payment1Reference = builder.getPayment1Reference();
			this.payment2Type = builder.getPayment2Type();
			this.payment2Reference = builder.getPayment2Reference();
			this.payment3Payer = builder.getPayment3Payer();
			this.payment3Reference = builder.getPayment3Reference();
			this.payment3FrequencyPeriod = builder.getPayment3FrequencyPeriod();
			this.payment3FrequencyPeriodMultiplier = builder.getPayment3FrequencyPeriodMultiplier();
			this.payment3Date = builder.getPayment3Date();
			this.payment4Reference = builder.getPayment4Reference();
			this.payment4Payer = builder.getPayment4Payer();
			this.payment4FrequencyPeriod = builder.getPayment4FrequencyPeriod();
			this.payment4FrequencyPeriodMultiplier = builder.getPayment4FrequencyPeriodMultiplier();
			this.payment4Date = builder.getPayment4Date();
			this.payment5Reference = builder.getPayment5Reference();
			this.payment5Payer = builder.getPayment5Payer();
			this.payment5FrequencyPeriod = builder.getPayment5FrequencyPeriod();
			this.payment5FrequencyPeriodMultiplier = builder.getPayment5FrequencyPeriodMultiplier();
			this.payment5Date = builder.getPayment5Date();
			this.payment3Type = builder.getPayment3Type();
			this.premiumPayer = builder.getPremiumPayer();
			this.premiumPaymentDateUnadjusted = builder.getPremiumPaymentDateUnadjusted();
			this.tradeParty1NatureOfTheReportingCounterparty = builder.getTradeParty1NatureOfTheReportingCounterparty();
			this.tradeParty2NatureOfTheReportingCounterparty = builder.getTradeParty2NatureOfTheReportingCounterparty();
			this.reservedParticipantUse1 = builder.getReservedParticipantUse1();
			this.reservedParticipantUse2 = builder.getReservedParticipantUse2();
			this.reservedParticipantUse3 = builder.getReservedParticipantUse3();
			this.reservedParticipantUse4 = builder.getReservedParticipantUse4();
			this.reservedParticipantUse5 = builder.getReservedParticipantUse5();
			this.leg1TerminationDate = builder.getLeg1TerminationDate();
			this.allocationType = builder.getAllocationType();
			this.calculationBasis = builder.getCalculationBasis();
			this.clearingExceptionPartyId = builder.getClearingExceptionPartyId();
			this.clearingExceptionPartyIdType = builder.getClearingExceptionPartyIdType();
			this.clearingExceptionType = builder.getClearingExceptionType();
			this.clearingMemberClientAccountId = builder.getClearingMemberClientAccountId();
			this.clearingReceiptDatetime = builder.getClearingReceiptDatetime();
			this.clearingSwapSdrLeiId = builder.getClearingSwapSdrLeiId();
			this.clearingSwapUtiId = builder.getClearingSwapUtiId();
			this.collateralReportingDate = builder.getCollateralReportingDate();
			this.collateralValuationDatetime = builder.getCollateralValuationDatetime();
			this.comment2 = builder.getComment2();
			this.commodityStrikePriceUnit = builder.getCommodityStrikePriceUnit();
			this.executionAgentMaskingIndicator = builder.getExecutionAgentMaskingIndicator();
			this.feeInCurrency = builder.getFeeInCurrency();
			this.feeOutCurrency = builder.getFeeOutCurrency();
			this.floatingRatePaymentFrequencyLeg1Multiplier = builder.getFloatingRatePaymentFrequencyLeg1Multiplier();
			this.floatingRatePaymentFrequencyLeg1TimePeriod = builder.getFloatingRatePaymentFrequencyLeg1TimePeriod();
			this.floatingRatePaymentFrequencyLeg2Multiplier = builder.getFloatingRatePaymentFrequencyLeg2Multiplier();
			this.floatingRatePaymentFrequencyLeg2TimePeriod = builder.getFloatingRatePaymentFrequencyLeg2TimePeriod();
			this.frequencyOfPayment = builder.getFrequencyOfPayment();
			this.interaffiliate = builder.getInteraffiliate();
			this.largeTradeIndicator = builder.getLargeTradeIndicator();
			this.leg1EffectiveDateAdjusted = builder.getLeg1EffectiveDateAdjusted();
			this.leg1FinalValuationDate = builder.getLeg1FinalValuationDate();
			this.leg1SettlementPeriod = builder.getLeg1SettlementPeriod();
			this.leg2EffectiveDateAdjusted = builder.getLeg2EffectiveDateAdjusted();
			this.leg2PaymentTermsFrequencyPeriod = builder.getLeg2PaymentTermsFrequencyPeriod();
			this.leg2PaymentTermsPaymentFrequencyPeriodMultiplier = builder.getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier();
			this.leg2SettlementType = builder.getLeg2SettlementType();
			this.leg2UnderlyingAssetId = builder.getLeg2UnderlyingAssetId();
			this.leg2UnderlyingAssetIdType = builder.getLeg2UnderlyingAssetIdType();
			this.leg2UnderlyingAssetName = builder.getLeg2UnderlyingAssetName();
			this.maturityDate = builder.getMaturityDate();
			this.optionalEarlyTerminationDate = builder.getOptionalEarlyTerminationDate();
			this.optionCommodityCurrency = builder.getOptionCommodityCurrency();
			this.optionCommodityExchangeId = builder.getOptionCommodityExchangeId();
			this.optionCommodityInstrumentId = builder.getOptionCommodityInstrumentId();
			this.optionCommodityRateSource = builder.getOptionCommodityRateSource();
			this.optionCommodityRateSourcePage = builder.getOptionCommodityRateSourcePage();
			this.optionCommodityUnderlyerDetails = builder.getOptionCommodityUnderlyerDetails();
			this.optionCommodityUnderlyerId = builder.getOptionCommodityUnderlyerId();
			this.optionCommodityUnitOfMeasure = builder.getOptionCommodityUnitOfMeasure();
			this.optionSpecifiedPrice = builder.getOptionSpecifiedPrice();
			this.optionSpreadAmount = builder.getOptionSpreadAmount();
			this.optionSpreadCurrency = builder.getOptionSpreadCurrency();
			this.optionSpreadSchedule = builder.getOptionSpreadSchedule();
			this.origin = builder.getOrigin();
			this.originalSwapSdrId = builder.getOriginalSwapSdrId();
			this.originalSwapSdrIdType = builder.getOriginalSwapSdrIdType();
			this.paymentFrequencyPeriodLeg1 = builder.getPaymentFrequencyPeriodLeg1();
			this.paymentFrequencyPeriodLeg2 = builder.getPaymentFrequencyPeriodLeg2();
			this.paymentFrequencyPeriodMultiplierLeg1 = builder.getPaymentFrequencyPeriodMultiplierLeg1();
			this.paymentFrequencyPeriodMultiplierLeg2 = builder.getPaymentFrequencyPeriodMultiplierLeg2();
			this.premiumPayerPrefix = builder.getPremiumPayerPrefix();
			this.price1Currency = builder.getPrice1Currency();
			this.price2Price = builder.getPrice2Price();
			this.price2Type = builder.getPrice2Type();
			this.price2Units = builder.getPrice2Units();
			this.price3Price = builder.getPrice3Price();
			this.price3Type = builder.getPrice3Type();
			this.price3Units = builder.getPrice3Units();
			this.price4Price = builder.getPrice4Price();
			this.price4Type = builder.getPrice4Type();
			this.price4Units = builder.getPrice4Units();
			this.pricingContext = builder.getPricingContext();
			this.priorUsiType = builder.getPriorUsiType();
			this.priorUtiType = builder.getPriorUtiType();
			this.recoveryPrice = builder.getRecoveryPrice();
			this.sendToDataCenterCode = builder.getSendToDataCenterCode();
			this.strikePriceType = builder.getStrikePriceType();
			this.subAssetClassForOtherCommodity = builder.getSubAssetClassForOtherCommodity();
			this.tradeParty1CftcFinancialEntityStatus = builder.getTradeParty1CftcFinancialEntityStatus();
			this.tradeParty1CollateralAmount = builder.getTradeParty1CollateralAmount();
			this.tradeParty1CollateralCurrency = builder.getTradeParty1CollateralCurrency();
			this.tradeParty1MandatoryDelegatedReporting = builder.getTradeParty1MandatoryDelegatedReporting();
			this.tradeParty1Role = builder.getTradeParty1Role();
			this.tradeParty2CftcFinancialEntityStatus = builder.getTradeParty2CftcFinancialEntityStatus();
			this.tradeParty2CollateralAmount = builder.getTradeParty2CollateralAmount();
			this.tradeParty2CollateralCurrency = builder.getTradeParty2CollateralCurrency();
			this.tradeParty2MandatoryDelegatedReporting = builder.getTradeParty2MandatoryDelegatedReporting();
			this.tradeParty2Role = builder.getTradeParty2Role();
			this.upfrontPayment = builder.getUpfrontPayment();
			this.verificationMethod = builder.getVerificationMethod();
			this.responsibleDataSubmitterId = builder.getResponsibleDataSubmitterId();
			this.responsibleDataSubmitterIdType = builder.getResponsibleDataSubmitterIdType();
			this.originalSwapUsi = builder.getOriginalSwapUsi();
			this.originalSwapUti = builder.getOriginalSwapUti();
			this.cdeReceiverIdentifierLeg2 = builder.getCdeReceiverIdentifierLeg2();
			this.counterparty1FederalEntityIndicator = builder.getCounterparty1FederalEntityIndicator();
			this.counterparty2FederalEntityIndicator = builder.getCounterparty2FederalEntityIndicator();
			this.customBasketIndicator = builder.getCustomBasketIndicator();
			this.noaActionType = builder.getNoaActionType();
			this.eventType = builder.getEventType();
			this.amendmentIndicator = builder.getAmendmentIndicator();
			this.eventIdentifier = builder.getEventIdentifier();
			this.cdeCallAmountLeg1 = builder.getCdeCallAmountLeg1();
			this.cdeCallAmountLeg2 = builder.getCdeCallAmountLeg2();
			this.cdeCallCurrencyLeg1 = builder.getCdeCallCurrencyLeg1();
			this.cdeCallCurrencyLeg2 = builder.getCdeCallCurrencyLeg2();
			this.cdePutAmountLeg1 = builder.getCdePutAmountLeg1();
			this.cdePutAmountLeg2 = builder.getCdePutAmountLeg2();
			this.cdePutCurrencyLeg1 = builder.getCdePutCurrencyLeg1();
			this.cdePutCurrencyLeg2 = builder.getCdePutCurrencyLeg2();
			this.leg2QuantityFrequency = builder.getLeg2QuantityFrequency();
			this.quantityFrequencyMultiplierLeg1 = builder.getQuantityFrequencyMultiplierLeg1();
			this.quantityFrequencyMultiplierLeg2 = builder.getQuantityFrequencyMultiplierLeg2();
			this.cdeQuantityUnitOfMeasureLeg1 = builder.getCdeQuantityUnitOfMeasureLeg1();
			this.cdeQuantityUnitOfMeasureLeg2 = builder.getCdeQuantityUnitOfMeasureLeg2();
			this.packageIndicator = builder.getPackageIndicator();
			this.cdePackageIdentifier = builder.getCdePackageIdentifier();
			this.cdePackageTransactionPrice = builder.getCdePackageTransactionPrice();
			this.cdePackageTransactionPriceCurrency = builder.getCdePackageTransactionPriceCurrency();
			this.cdePackageTransactionPriceNotation = builder.getCdePackageTransactionPriceNotation();
			this.cdePackageTransactionSpread = builder.getCdePackageTransactionSpread();
			this.cdePackageTransactionSpreadCurrency = builder.getCdePackageTransactionSpreadCurrency();
			this.cdePackageTransactionSpreadNotation = builder.getCdePackageTransactionSpreadNotation();
			this.cdeFixedRateDayCountConventionLeg1 = builder.getCdeFixedRateDayCountConventionLeg1();
			this.cdeFixedRateDayCountConventionLeg2 = builder.getCdeFixedRateDayCountConventionLeg2();
			this.cdeFloatingRateDayCountConventionLeg1 = builder.getCdeFloatingRateDayCountConventionLeg1();
			this.cdeFloatingRateDayCountConventionLeg2 = builder.getCdeFloatingRateDayCountConventionLeg2();
			this.fixingDateLeg1 = builder.getFixingDateLeg1();
			this.fixingDateLeg2 = builder.getFixingDateLeg2();
			this.cdeFixedRatePaymentFrequencyPeriodLeg1 = builder.getCdeFixedRatePaymentFrequencyPeriodLeg1();
			this.cdeFixedRatePaymentFrequencyPeriodLeg2 = builder.getCdeFixedRatePaymentFrequencyPeriodLeg2();
			this.cdeFloatingRatePaymentFrequencyPeriodLeg1 = builder.getCdeFloatingRatePaymentFrequencyPeriodLeg1();
			this.cdeFloatingRatePaymentFrequencyPeriodLeg2 = builder.getCdeFloatingRatePaymentFrequencyPeriodLeg2();
			this.cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1();
			this.cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2();
			this.cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1();
			this.cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2();
			this.postPricedSwapIndicator = builder.getPostPricedSwapIndicator();
			this.cdePriceCurrency = builder.getCdePriceCurrency();
			this.cdePriceNotation = builder.getCdePriceNotation();
			this.cdeSpreadNotationLeg1 = builder.getCdeSpreadNotationLeg1();
			this.cdeSpreadNotationLeg2 = builder.getCdeSpreadNotationLeg2();
			this.cdeStrikePriceCurrency2 = builder.getCdeStrikePriceCurrency2();
			this.cdeStrikePriceNotation = builder.getCdeStrikePriceNotation();
			this.cdeFirstExerciseDate = builder.getCdeFirstExerciseDate();
			this.cdeFinalContractualSettlementDate = builder.getCdeFinalContractualSettlementDate();
			this.cdeSettlementLocationLeg1 = builder.getCdeSettlementLocationLeg1();
			this.cdeSettlementLocationLeg2 = builder.getCdeSettlementLocationLeg2();
			this.cdeEffectiveDate = builder.getCdeEffectiveDate();
			this.cdeExpirationDate = builder.getCdeExpirationDate();
			this.cdePlatformIdentifier = builder.getCdePlatformIdentifier();
			this.primeBrokerageTransactionIndicator = builder.getPrimeBrokerageTransactionIndicator();
			this.swapReportingJurisdiction = builder.getSwapReportingJurisdiction();
			this.newSdrIdentifier = builder.getNewSdrIdentifier();
			this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
			this.lastFloatingReferenceValueLeg1 = builder.getLastFloatingReferenceValueLeg1();
			this.lastFloatingReferenceResetDateLeg1 = builder.getLastFloatingReferenceResetDateLeg1();
			this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
			this.lastFloatingReferenceValueLeg2 = builder.getLastFloatingReferenceValueLeg2();
			this.lastFloatingReferenceResetDateLeg2 = builder.getLastFloatingReferenceResetDateLeg2();
			this.cdeDelta = builder.getCdeDelta();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.largeNotionalOffFacilitySwapElectionIndicator = builder.getLargeNotionalOffFacilitySwapElectionIndicator();
			this.sefOrDcmAnonymousExecutionIndicator = builder.getSefOrDcmAnonymousExecutionIndicator();
			this.blockTradeElectionIndicator = builder.getBlockTradeElectionIndicator();
			this.sefOrDcmIndicator = builder.getSefOrDcmIndicator();
			this.mandatoryClearingIndicator = builder.getMandatoryClearingIndicator();
			this.sdMspIndicatorCounterparty1 = builder.getSdMspIndicatorCounterparty1();
			this.sdMspIndicatorCounterparty2 = builder.getSdMspIndicatorCounterparty2();
			this.physicalCommodityContractIndicator = builder.getPhysicalCommodityContractIndicator();
			this.changeInNotionalAmount1 = builder.getChangeInNotionalAmount1();
			this.changeInNotionalAmount2 = builder.getChangeInNotionalAmount2();
			this.changeInLeg1NotionalQuantity = builder.getChangeInLeg1NotionalQuantity();
			this.changeInLeg2NotionalQuantity = builder.getChangeInLeg2NotionalQuantity();
			this.cdeCryptoAssetUnderlyingIndicatorLeg1 = builder.getCdeCryptoAssetUnderlyingIndicatorLeg1();
			this.cdeCryptoAssetUnderlyingIndicatorLeg2 = builder.getCdeCryptoAssetUnderlyingIndicatorLeg2();
			this.cdeCustomBasketCode = builder.getCdeCustomBasketCode();
			this.underlierIdOtherLeg1 = builder.getUnderlierIdOtherLeg1();
			this.underlierIdOtherLeg2 = builder.getUnderlierIdOtherLeg2();
			this.underlierIdOtherSourceLeg1 = builder.getUnderlierIdOtherSourceLeg1();
			this.underlierIdOtherSourceLeg2 = builder.getUnderlierIdOtherSourceLeg2();
			this.cdeUnderlyingAssetTradingPlatformIdLeg1 = builder.getCdeUnderlyingAssetTradingPlatformIdLeg1();
			this.cdeUnderlyingAssetTradingPlatformIdLeg2 = builder.getCdeUnderlyingAssetTradingPlatformIdLeg2();
			this.cdeUnderlyingAssetPriceSourceLeg1 = builder.getCdeUnderlyingAssetPriceSourceLeg1();
			this.cdeUnderlyingAssetPriceSourceLeg2 = builder.getCdeUnderlyingAssetPriceSourceLeg2();
		}
		
		@Override
		@RosettaAttribute("leg2CommodityInstrumentId")
		@RuneAttribute("leg2CommodityInstrumentId")
		public String getLeg2CommodityInstrumentId() {
			return leg2CommodityInstrumentId;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerId")
		@RuneAttribute("leg2CommodityUnderlyerId")
		public String getLeg2CommodityUnderlyerId() {
			return leg2CommodityUnderlyerId;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerDetails")
		@RuneAttribute("leg2CommodityUnderlyerDetails")
		public String getLeg2CommodityUnderlyerDetails() {
			return leg2CommodityUnderlyerDetails;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnitOfMeasure")
		@RuneAttribute("leg2CommodityUnitOfMeasure")
		public String getLeg2CommodityUnitOfMeasure() {
			return leg2CommodityUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityCurrency")
		@RuneAttribute("leg2CommodityCurrency")
		public String getLeg2CommodityCurrency() {
			return leg2CommodityCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityExchangeId")
		@RuneAttribute("leg2CommodityExchangeId")
		public String getLeg2CommodityExchangeId() {
			return leg2CommodityExchangeId;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityRateSource")
		@RuneAttribute("leg1CommodityRateSource")
		public String getLeg1CommodityRateSource() {
			return leg1CommodityRateSource;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityRateSourcePage")
		@RuneAttribute("leg1CommodityRateSourcePage")
		public String getLeg1CommodityRateSourcePage() {
			return leg1CommodityRateSourcePage;
		}
		
		@Override
		@RosettaAttribute("leg2SpecifiedPrice")
		@RuneAttribute("leg2SpecifiedPrice")
		public String getLeg2SpecifiedPrice() {
			return leg2SpecifiedPrice;
		}
		
		@Override
		@RosettaAttribute("commencementDateUnadjusted")
		@RuneAttribute("commencementDateUnadjusted")
		public Date getCommencementDateUnadjusted() {
			return commencementDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("exerciseExpirationDateUnadjusted")
		@RuneAttribute("exerciseExpirationDateUnadjusted")
		public Date getExerciseExpirationDateUnadjusted() {
			return exerciseExpirationDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("expirationDateUnadjusted")
		@RuneAttribute("expirationDateUnadjusted")
		public Date getExpirationDateUnadjusted() {
			return expirationDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantityFrequency")
		@RuneAttribute("leg2NotionalQuantityFrequency")
		public String getLeg2NotionalQuantityFrequency() {
			return leg2NotionalQuantityFrequency;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantity")
		@RuneAttribute("leg2NotionalQuantity")
		public BigDecimal getLeg2NotionalQuantity() {
			return leg2NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg2TotalNotionalQuantity")
		@RuneAttribute("leg2TotalNotionalQuantity")
		public BigDecimal getLeg2TotalNotionalQuantity() {
			return leg2TotalNotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg2SpreadAmount")
		@RuneAttribute("leg2SpreadAmount")
		public BigDecimal getLeg2SpreadAmount() {
			return leg2SpreadAmount;
		}
		
		@Override
		@RosettaAttribute("leg2SpreadCurrency")
		@RuneAttribute("leg2SpreadCurrency")
		public String getLeg2SpreadCurrency() {
			return leg2SpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("scheduledTerminationDateAdjusted")
		@RuneAttribute("scheduledTerminationDateAdjusted")
		public Date getScheduledTerminationDateAdjusted() {
			return scheduledTerminationDateAdjusted;
		}
		
		@Override
		@RosettaAttribute("leg1PartyPayer")
		@RuneAttribute("leg1PartyPayer")
		public String getLeg1PartyPayer() {
			return leg1PartyPayer;
		}
		
		@Override
		@RosettaAttribute("leg2PartyPayer")
		@RuneAttribute("leg2PartyPayer")
		public String getLeg2PartyPayer() {
			return leg2PartyPayer;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityInstrumentId")
		@RuneAttribute("leg1CommodityInstrumentId")
		public String getLeg1CommodityInstrumentId() {
			return leg1CommodityInstrumentId;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerId")
		@RuneAttribute("leg1CommodityUnderlyerId")
		public String getLeg1CommodityUnderlyerId() {
			return leg1CommodityUnderlyerId;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnitOfMeasure")
		@RuneAttribute("leg1CommodityUnitOfMeasure")
		public String getLeg1CommodityUnitOfMeasure() {
			return leg1CommodityUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityExchangeId")
		@RuneAttribute("leg1CommodityExchangeId")
		public String getLeg1CommodityExchangeId() {
			return leg1CommodityExchangeId;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityRateSource")
		@RuneAttribute("leg2CommodityRateSource")
		public String getLeg2CommodityRateSource() {
			return leg2CommodityRateSource;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDateUnadjusted")
		@RuneAttribute("leg1EffectiveDateUnadjusted")
		public Date getLeg1EffectiveDateUnadjusted() {
			return leg1EffectiveDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDateUnadjusted")
		@RuneAttribute("leg2EffectiveDateUnadjusted")
		public Date getLeg2EffectiveDateUnadjusted() {
			return leg2EffectiveDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("coProductType")
		@RuneAttribute("coProductType")
		public String getCoProductType() {
			return coProductType;
		}
		
		@Override
		@RosettaAttribute("totalQuantityUnit")
		@RuneAttribute("totalQuantityUnit")
		public String getTotalQuantityUnit() {
			return totalQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("totalQuantity")
		@RuneAttribute("totalQuantity")
		public BigDecimal getTotalQuantity() {
			return totalQuantity;
		}
		
		@Override
		@RosettaAttribute("fixedPrice")
		@RuneAttribute("fixedPrice")
		public BigDecimal getFixedPrice() {
			return fixedPrice;
		}
		
		@Override
		@RosettaAttribute("fixedPriceCurrency")
		@RuneAttribute("fixedPriceCurrency")
		public String getFixedPriceCurrency() {
			return fixedPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantityUnit")
		@RuneAttribute("leg1NotionalQuantityUnit")
		public String getLeg1NotionalQuantityUnit() {
			return leg1NotionalQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantityFrequency")
		@RuneAttribute("leg1NotionalQuantityFrequency")
		public String getLeg1NotionalQuantityFrequency() {
			return leg1NotionalQuantityFrequency;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantity")
		@RuneAttribute("leg1NotionalQuantity")
		public BigDecimal getLeg1NotionalQuantity() {
			return leg1NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg1TotalNotionalQuantity")
		@RuneAttribute("leg1TotalNotionalQuantity")
		public BigDecimal getLeg1TotalNotionalQuantity() {
			return leg1TotalNotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityCurrency")
		@RuneAttribute("leg1CommodityCurrency")
		public String getLeg1CommodityCurrency() {
			return leg1CommodityCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1SpecifiedPrice")
		@RuneAttribute("leg1SpecifiedPrice")
		public String getLeg1SpecifiedPrice() {
			return leg1SpecifiedPrice;
		}
		
		@Override
		@RosettaAttribute("leg1SpreadCurrency")
		@RuneAttribute("leg1SpreadCurrency")
		public String getLeg1SpreadCurrency() {
			return leg1SpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1SpreadAmount")
		@RuneAttribute("leg1SpreadAmount")
		public BigDecimal getLeg1SpreadAmount() {
			return leg1SpreadAmount;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantityUnit")
		@RuneAttribute("leg2NotionalQuantityUnit")
		public String getLeg2NotionalQuantityUnit() {
			return leg2NotionalQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("leg2PartyReceiver")
		@RuneAttribute("leg2PartyReceiver")
		public String getLeg2PartyReceiver() {
			return leg2PartyReceiver;
		}
		
		@Override
		@RosettaAttribute("leg1PartyReceiver")
		@RuneAttribute("leg1PartyReceiver")
		public String getLeg1PartyReceiver() {
			return leg1PartyReceiver;
		}
		
		@Override
		@RosettaAttribute("coalSource")
		@RuneAttribute("coalSource")
		public String getCoalSource() {
			return coalSource;
		}
		
		@Override
		@RosettaAttribute("leg2Quantity")
		@RuneAttribute("leg2Quantity")
		public BigDecimal getLeg2Quantity() {
			return leg2Quantity;
		}
		
		@Override
		@RosettaAttribute("commodityBase")
		@RuneAttribute("commodityBase")
		public String getCommodityBase() {
			return commodityBase;
		}
		
		@Override
		@RosettaAttribute("commodityDetails")
		@RuneAttribute("commodityDetails")
		public String getCommodityDetails() {
			return commodityDetails;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public String getInterconnectionPoint() {
			return interconnectionPoint;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public String getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("fixedPriceUnit")
		@RuneAttribute("fixedPriceUnit")
		public String getFixedPriceUnit() {
			return fixedPriceUnit;
		}
		
		@Override
		@RosettaAttribute("exercisePaymentDateUnadjusted")
		@RuneAttribute("exercisePaymentDateUnadjusted")
		public Date getExercisePaymentDateUnadjusted() {
			return exercisePaymentDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg1PaymentDatesUnadjusted")
		@RuneAttribute("leg1PaymentDatesUnadjusted")
		public Date getLeg1PaymentDatesUnadjusted() {
			return leg1PaymentDatesUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentDateUnadjusted")
		@RuneAttribute("leg2PaymentDateUnadjusted")
		public Date getLeg2PaymentDateUnadjusted() {
			return leg2PaymentDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("settlementDateUnadjusted")
		@RuneAttribute("settlementDateUnadjusted")
		public Date getSettlementDateUnadjusted() {
			return settlementDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("deliveryLocation")
		@RuneAttribute("deliveryLocation")
		public String getDeliveryLocation() {
			return deliveryLocation;
		}
		
		@Override
		@RosettaAttribute("leg2QuantityUnit")
		@RuneAttribute("leg2QuantityUnit")
		public String getLeg2QuantityUnit() {
			return leg2QuantityUnit;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerDetails")
		@RuneAttribute("leg1CommodityUnderlyerDetails")
		public String getLeg1CommodityUnderlyerDetails() {
			return leg1CommodityUnderlyerDetails;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityRateSourcePage")
		@RuneAttribute("leg2CommodityRateSourcePage")
		public String getLeg2CommodityRateSourcePage() {
			return leg2CommodityRateSourcePage;
		}
		
		@Override
		@RosettaAttribute("valueDate")
		@RuneAttribute("valueDate")
		public Date getValueDate() {
			return valueDate;
		}
		
		@Override
		@RosettaAttribute("gtrQuantityUnit")
		@RuneAttribute("gtrQuantityUnit")
		public String getGtrQuantityUnit() {
			return gtrQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("attachmentPoint")
		@RuneAttribute("attachmentPoint")
		public BigDecimal getAttachmentPoint() {
			return attachmentPoint;
		}
		
		@Override
		@RosettaAttribute("exhaustionPoint")
		@RuneAttribute("exhaustionPoint")
		public BigDecimal getExhaustionPoint() {
			return exhaustionPoint;
		}
		
		@Override
		@RosettaAttribute("mthToDefault")
		@RuneAttribute("mthToDefault")
		public BigDecimal getMthToDefault() {
			return mthToDefault;
		}
		
		@Override
		@RosettaAttribute("nthToDefault")
		@RuneAttribute("nthToDefault")
		public BigDecimal getNthToDefault() {
			return nthToDefault;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public BigDecimal getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("crversion")
		@RuneAttribute("crversion")
		public BigDecimal getCrversion() {
			return crversion;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public String getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("referenceObligation")
		@RuneAttribute("referenceObligation")
		public String getReferenceObligation() {
			return referenceObligation;
		}
		
		@Override
		@RosettaAttribute("referenceObligationIdType")
		@RuneAttribute("referenceObligationIdType")
		public String getReferenceObligationIdType() {
			return referenceObligationIdType;
		}
		
		@Override
		@RosettaAttribute("underlyingFixedRatePayerBuyer")
		@RuneAttribute("underlyingFixedRatePayerBuyer")
		public String getUnderlyingFixedRatePayerBuyer() {
			return underlyingFixedRatePayerBuyer;
		}
		
		@Override
		@RosettaAttribute("underlyingFloatRatePayerSeller")
		@RuneAttribute("underlyingFloatRatePayerSeller")
		public String getUnderlyingFloatRatePayerSeller() {
			return underlyingFloatRatePayerSeller;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetExchangeId")
		@RuneAttribute("underlyingAssetExchangeId")
		public String getUnderlyingAssetExchangeId() {
			return underlyingAssetExchangeId;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetNumberOfUnits")
		@RuneAttribute("underlyingAssetNumberOfUnits")
		public BigDecimal getUnderlyingAssetNumberOfUnits() {
			return underlyingAssetNumberOfUnits;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationType")
		@RuneAttribute("optionalEarlyTerminationType")
		public String getOptionalEarlyTerminationType() {
			return optionalEarlyTerminationType;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationElectingPartyValue")
		@RuneAttribute("optionalEarlyTerminationElectingPartyValue")
		public String getOptionalEarlyTerminationElectingPartyValue() {
			return optionalEarlyTerminationElectingPartyValue;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationIndicator")
		@RuneAttribute("optionalEarlyTerminationIndicator")
		public Boolean getOptionalEarlyTerminationIndicator() {
			return optionalEarlyTerminationIndicator;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingAmountPayer")
		@RuneAttribute("underlyingAssetFloatingAmountPayer")
		public String getUnderlyingAssetFloatingAmountPayer() {
			return underlyingAssetFloatingAmountPayer;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingAmountReceiver")
		@RuneAttribute("underlyingAssetFloatingAmountReceiver")
		public String getUnderlyingAssetFloatingAmountReceiver() {
			return underlyingAssetFloatingAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("floatingRateOption")
		@RuneAttribute("floatingRateOption")
		public String getFloatingRateOption() {
			return floatingRateOption;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingLegSpread")
		@RuneAttribute("underlyingAssetFloatingLegSpread")
		public BigDecimal getUnderlyingAssetFloatingLegSpread() {
			return underlyingAssetFloatingLegSpread;
		}
		
		@Override
		@RosettaAttribute("leg2DesignatedMaturityPeriod")
		@RuneAttribute("leg2DesignatedMaturityPeriod")
		public String getLeg2DesignatedMaturityPeriod() {
			return leg2DesignatedMaturityPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2DesignatedMaturityPeriodMultiplier")
		@RuneAttribute("leg2DesignatedMaturityPeriodMultiplier")
		public BigDecimal getLeg2DesignatedMaturityPeriodMultiplier() {
			return leg2DesignatedMaturityPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetEquityAmountPayer")
		@RuneAttribute("underlyingAssetEquityAmountPayer")
		public String getUnderlyingAssetEquityAmountPayer() {
			return underlyingAssetEquityAmountPayer;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetEquityAmountReceiver")
		@RuneAttribute("underlyingAssetEquityAmountReceiver")
		public String getUnderlyingAssetEquityAmountReceiver() {
			return underlyingAssetEquityAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetInitialPriceCurrency")
		@RuneAttribute("underlyingAssetInitialPriceCurrency")
		public String getUnderlyingAssetInitialPriceCurrency() {
			return underlyingAssetInitialPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1ValuationDates")
		@RuneAttribute("leg1ValuationDates")
		public Date getLeg1ValuationDates() {
			return leg1ValuationDates;
		}
		
		@Override
		@RosettaAttribute("leg1TypeOfReturn")
		@RuneAttribute("leg1TypeOfReturn")
		public String getLeg1TypeOfReturn() {
			return leg1TypeOfReturn;
		}
		
		@Override
		@RosettaAttribute("observationStartDate")
		@RuneAttribute("observationStartDate")
		public Date getObservationStartDate() {
			return observationStartDate;
		}
		
		@Override
		@RosettaAttribute("varianceAmount")
		@RuneAttribute("varianceAmount")
		public BigDecimal getVarianceAmount() {
			return varianceAmount;
		}
		
		@Override
		@RosettaAttribute("volatilityStrikePrice")
		@RuneAttribute("volatilityStrikePrice")
		public BigDecimal getVolatilityStrikePrice() {
			return volatilityStrikePrice;
		}
		
		@Override
		@RosettaAttribute("varianceStrikePrice")
		@RuneAttribute("varianceStrikePrice")
		public BigDecimal getVarianceStrikePrice() {
			return varianceStrikePrice;
		}
		
		@Override
		@RosettaAttribute("varianceCapFactor")
		@RuneAttribute("varianceCapFactor")
		public BigDecimal getVarianceCapFactor() {
			return varianceCapFactor;
		}
		
		@Override
		@RosettaAttribute("referenceCurrency")
		@RuneAttribute("referenceCurrency")
		public String getReferenceCurrency() {
			return referenceCurrency;
		}
		
		@Override
		@RosettaAttribute("specialDividendsIndicator")
		@RuneAttribute("specialDividendsIndicator")
		public String getSpecialDividendsIndicator() {
			return specialDividendsIndicator;
		}
		
		@Override
		@RosettaAttribute("materialNoncashDividendIndicator")
		@RuneAttribute("materialNoncashDividendIndicator")
		public String getMaterialNoncashDividendIndicator() {
			return materialNoncashDividendIndicator;
		}
		
		@Override
		@RosettaAttribute("numberOfSharesUnits")
		@RuneAttribute("numberOfSharesUnits")
		public BigDecimal getNumberOfSharesUnits() {
			return numberOfSharesUnits;
		}
		
		@Override
		@RosettaAttribute("dividendAmountPayer")
		@RuneAttribute("dividendAmountPayer")
		public String getDividendAmountPayer() {
			return dividendAmountPayer;
		}
		
		@Override
		@RosettaAttribute("dividendAmountReceiver")
		@RuneAttribute("dividendAmountReceiver")
		public String getDividendAmountReceiver() {
			return dividendAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("fixedAmountPayer")
		@RuneAttribute("fixedAmountPayer")
		public String getFixedAmountPayer() {
			return fixedAmountPayer;
		}
		
		@Override
		@RosettaAttribute("fixedAmountReceiver")
		@RuneAttribute("fixedAmountReceiver")
		public String getFixedAmountReceiver() {
			return fixedAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("knockInEvent")
		@RuneAttribute("knockInEvent")
		public String getKnockInEvent() {
			return knockInEvent;
		}
		
		@Override
		@RosettaAttribute("knockOutEvent")
		@RuneAttribute("knockOutEvent")
		public String getKnockOutEvent() {
			return knockOutEvent;
		}
		
		@Override
		@RosettaAttribute("knockInPrice")
		@RuneAttribute("knockInPrice")
		public BigDecimal getKnockInPrice() {
			return knockInPrice;
		}
		
		@Override
		@RosettaAttribute("knockOutPrice")
		@RuneAttribute("knockOutPrice")
		public BigDecimal getKnockOutPrice() {
			return knockOutPrice;
		}
		
		@Override
		@RosettaAttribute("barrierType")
		@RuneAttribute("barrierType")
		public String getBarrierType() {
			return barrierType;
		}
		
		@Override
		@RosettaAttribute("earliestExecutionTime")
		@RuneAttribute("earliestExecutionTime")
		public LocalTime getEarliestExecutionTime() {
			return earliestExecutionTime;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisCurrency1")
		@RuneAttribute("exchangeRateBasisCurrency1")
		public String getExchangeRateBasisCurrency1() {
			return exchangeRateBasisCurrency1;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisCurrency2")
		@RuneAttribute("exchangeRateBasisCurrency2")
		public String getExchangeRateBasisCurrency2() {
			return exchangeRateBasisCurrency2;
		}
		
		@Override
		@RosettaAttribute("executionPeriodStartDate")
		@RuneAttribute("executionPeriodStartDate")
		public Date getExecutionPeriodStartDate() {
			return executionPeriodStartDate;
		}
		
		@Override
		@RosettaAttribute("payoutStyle")
		@RuneAttribute("payoutStyle")
		public String getPayoutStyle() {
			return payoutStyle;
		}
		
		@Override
		@RosettaAttribute("rateQuoteBasis1")
		@RuneAttribute("rateQuoteBasis1")
		public String getRateQuoteBasis1() {
			return rateQuoteBasis1;
		}
		
		@Override
		@RosettaAttribute("settlementFixingDate")
		@RuneAttribute("settlementFixingDate")
		public Date getSettlementFixingDate() {
			return settlementFixingDate;
		}
		
		@Override
		@RosettaAttribute("swapLinkId")
		@RuneAttribute("swapLinkId")
		public String getSwapLinkId() {
			return swapLinkId;
		}
		
		@Override
		@RosettaAttribute("triggerCondition")
		@RuneAttribute("triggerCondition")
		public String getTriggerCondition() {
			return triggerCondition;
		}
		
		@Override
		@RosettaAttribute("triggerCondition2")
		@RuneAttribute("triggerCondition2")
		public String getTriggerCondition2() {
			return triggerCondition2;
		}
		
		@Override
		@RosettaAttribute("triggerRate")
		@RuneAttribute("triggerRate")
		public BigDecimal getTriggerRate() {
			return triggerRate;
		}
		
		@Override
		@RosettaAttribute("triggerRate2")
		@RuneAttribute("triggerRate2")
		public BigDecimal getTriggerRate2() {
			return triggerRate2;
		}
		
		@Override
		@RosettaAttribute("rateQuoteBasis2")
		@RuneAttribute("rateQuoteBasis2")
		public String getRateQuoteBasis2() {
			return rateQuoteBasis2;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("barrierType2")
		@RuneAttribute("barrierType2")
		public String getBarrierType2() {
			return barrierType2;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionBuyer")
		@RuneAttribute("cancelationOptionBuyer")
		public String getCancelationOptionBuyer() {
			return cancelationOptionBuyer;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionCommencementDate")
		@RuneAttribute("cancelationOptionCommencementDate")
		public Date getCancelationOptionCommencementDate() {
			return cancelationOptionCommencementDate;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionExerciseStyleType")
		@RuneAttribute("cancelationOptionExerciseStyleType")
		public String getCancelationOptionExerciseStyleType() {
			return cancelationOptionExerciseStyleType;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionExpirationDate")
		@RuneAttribute("cancelationOptionExpirationDate")
		public Date getCancelationOptionExpirationDate() {
			return cancelationOptionExpirationDate;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionInitialFeeCurrency")
		@RuneAttribute("cancelationOptionInitialFeeCurrency")
		public String getCancelationOptionInitialFeeCurrency() {
			return cancelationOptionInitialFeeCurrency;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionInitialFeePayer")
		@RuneAttribute("cancelationOptionInitialFeePayer")
		public String getCancelationOptionInitialFeePayer() {
			return cancelationOptionInitialFeePayer;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionPremiumAmount")
		@RuneAttribute("cancelationOptionPremiumAmount")
		public BigDecimal getCancelationOptionPremiumAmount() {
			return cancelationOptionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionSeller")
		@RuneAttribute("cancelationOptionSeller")
		public String getCancelationOptionSeller() {
			return cancelationOptionSeller;
		}
		
		@Override
		@RosettaAttribute("capRateInitial")
		@RuneAttribute("capRateInitial")
		public BigDecimal getCapRateInitial() {
			return capRateInitial;
		}
		
		@Override
		@RosettaAttribute("couponType")
		@RuneAttribute("couponType")
		public String getCouponType() {
			return couponType;
		}
		
		@Override
		@RosettaAttribute("finalPrincipalExchangeIndicatorAtTermination")
		@RuneAttribute("finalPrincipalExchangeIndicatorAtTermination")
		public Boolean getFinalPrincipalExchangeIndicatorAtTermination() {
			return finalPrincipalExchangeIndicatorAtTermination;
		}
		
		@Override
		@RosettaAttribute("floorRateInitial")
		@RuneAttribute("floorRateInitial")
		public BigDecimal getFloorRateInitial() {
			return floorRateInitial;
		}
		
		@Override
		@RosettaAttribute("fraDiscountingType")
		@RuneAttribute("fraDiscountingType")
		public String getFraDiscountingType() {
			return fraDiscountingType;
		}
		
		@Override
		@RosettaAttribute("inflationIndexInitialLevel")
		@RuneAttribute("inflationIndexInitialLevel")
		public BigDecimal getInflationIndexInitialLevel() {
			return inflationIndexInitialLevel;
		}
		
		@Override
		@RosettaAttribute("inflationIndexMainPublication")
		@RuneAttribute("inflationIndexMainPublication")
		public String getInflationIndexMainPublication() {
			return inflationIndexMainPublication;
		}
		
		@Override
		@RosettaAttribute("inflationInterpolationMethod")
		@RuneAttribute("inflationInterpolationMethod")
		public String getInflationInterpolationMethod() {
			return inflationInterpolationMethod;
		}
		
		@Override
		@RosettaAttribute("inflationLagDayType")
		@RuneAttribute("inflationLagDayType")
		public String getInflationLagDayType() {
			return inflationLagDayType;
		}
		
		@Override
		@RosettaAttribute("inflationLagPeriod")
		@RuneAttribute("inflationLagPeriod")
		public String getInflationLagPeriod() {
			return inflationLagPeriod;
		}
		
		@Override
		@RosettaAttribute("inflationRateSourceName")
		@RuneAttribute("inflationRateSourceName")
		public String getInflationRateSourceName() {
			return inflationRateSourceName;
		}
		
		@Override
		@RosettaAttribute("initialPrincipalExchangeIndicator")
		@RuneAttribute("initialPrincipalExchangeIndicator")
		public Boolean getInitialPrincipalExchangeIndicator() {
			return initialPrincipalExchangeIndicator;
		}
		
		@Override
		@RosettaAttribute("intermediatePrincipalExchangeIndicator")
		@RuneAttribute("intermediatePrincipalExchangeIndicator")
		public Boolean getIntermediatePrincipalExchangeIndicator() {
			return intermediatePrincipalExchangeIndicator;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateIndex")
		@RuneAttribute("leg1FloatingRateIndex")
		public String getLeg1FloatingRateIndex() {
			return leg1FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateInitialSpread")
		@RuneAttribute("leg1FloatingRateInitialSpread")
		public BigDecimal getLeg1FloatingRateInitialSpread() {
			return leg1FloatingRateInitialSpread;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateMultiplierInitialValue")
		@RuneAttribute("leg1FloatingRateMultiplierInitialValue")
		public BigDecimal getLeg1FloatingRateMultiplierInitialValue() {
			return leg1FloatingRateMultiplierInitialValue;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateTenorPeriod")
		@RuneAttribute("leg1FloatingRateTenorPeriod")
		public String getLeg1FloatingRateTenorPeriod() {
			return leg1FloatingRateTenorPeriod;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateTenorPeriodMultiplier")
		@RuneAttribute("leg1FloatingRateTenorPeriodMultiplier")
		public BigDecimal getLeg1FloatingRateTenorPeriodMultiplier() {
			return leg1FloatingRateTenorPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg1KnownAmount")
		@RuneAttribute("leg1KnownAmount")
		public BigDecimal getLeg1KnownAmount() {
			return leg1KnownAmount;
		}
		
		@Override
		@RosettaAttribute("leg1KnownAmountCurrency")
		@RuneAttribute("leg1KnownAmountCurrency")
		public String getLeg1KnownAmountCurrency() {
			return leg1KnownAmountCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1ReferenceCurrency")
		@RuneAttribute("leg1ReferenceCurrency")
		public String getLeg1ReferenceCurrency() {
			return leg1ReferenceCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateIndex")
		@RuneAttribute("leg2FloatingRateIndex")
		public String getLeg2FloatingRateIndex() {
			return leg2FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateInitialSpread")
		@RuneAttribute("leg2FloatingRateInitialSpread")
		public BigDecimal getLeg2FloatingRateInitialSpread() {
			return leg2FloatingRateInitialSpread;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateMultiplierInitialValue")
		@RuneAttribute("leg2FloatingRateMultiplierInitialValue")
		public BigDecimal getLeg2FloatingRateMultiplierInitialValue() {
			return leg2FloatingRateMultiplierInitialValue;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateTenorPeriod")
		@RuneAttribute("leg2FloatingRateTenorPeriod")
		public String getLeg2FloatingRateTenorPeriod() {
			return leg2FloatingRateTenorPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateTenorPeriodMultiplier")
		@RuneAttribute("leg2FloatingRateTenorPeriodMultiplier")
		public BigDecimal getLeg2FloatingRateTenorPeriodMultiplier() {
			return leg2FloatingRateTenorPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg2KnownAmount")
		@RuneAttribute("leg2KnownAmount")
		public BigDecimal getLeg2KnownAmount() {
			return leg2KnownAmount;
		}
		
		@Override
		@RosettaAttribute("leg2KnownAmountCurrency")
		@RuneAttribute("leg2KnownAmountCurrency")
		public String getLeg2KnownAmountCurrency() {
			return leg2KnownAmountCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2ReferenceCurrency")
		@RuneAttribute("leg2ReferenceCurrency")
		public String getLeg2ReferenceCurrency() {
			return leg2ReferenceCurrency;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDate")
		@RuneAttribute("mandatoryEarlyTerminationDate")
		public Date getMandatoryEarlyTerminationDate() {
			return mandatoryEarlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDateTenorPeriod")
		@RuneAttribute("mandatoryEarlyTerminationDateTenorPeriod")
		public String getMandatoryEarlyTerminationDateTenorPeriod() {
			return mandatoryEarlyTerminationDateTenorPeriod;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDateTenorPeriodMultiplier")
		@RuneAttribute("mandatoryEarlyTerminationDateTenorPeriodMultiplier")
		public String getMandatoryEarlyTerminationDateTenorPeriodMultiplier() {
			return mandatoryEarlyTerminationDateTenorPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("notionalUnits")
		@RuneAttribute("notionalUnits")
		public BigDecimal getNotionalUnits() {
			return notionalUnits;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationCommencementDate")
		@RuneAttribute("optionalEarlyTerminationCommencementDate")
		public Date getOptionalEarlyTerminationCommencementDate() {
			return optionalEarlyTerminationCommencementDate;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationExerciseStyle")
		@RuneAttribute("optionalEarlyTerminationExerciseStyle")
		public String getOptionalEarlyTerminationExerciseStyle() {
			return optionalEarlyTerminationExerciseStyle;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationExpirationDate")
		@RuneAttribute("optionalEarlyTerminationExpirationDate")
		public Date getOptionalEarlyTerminationExpirationDate() {
			return optionalEarlyTerminationExpirationDate;
		}
		
		@Override
		@RosettaAttribute("premiumReceiver")
		@RuneAttribute("premiumReceiver")
		public String getPremiumReceiver() {
			return premiumReceiver;
		}
		
		@Override
		@RosettaAttribute("underlyingCouponRate")
		@RuneAttribute("underlyingCouponRate")
		public BigDecimal getUnderlyingCouponRate() {
			return underlyingCouponRate;
		}
		
		@Override
		@RosettaAttribute("underlyingMaturityDate")
		@RuneAttribute("underlyingMaturityDate")
		public Date getUnderlyingMaturityDate() {
			return underlyingMaturityDate;
		}
		
		@Override
		@RosettaAttribute("underlyingProductId")
		@RuneAttribute("underlyingProductId")
		public String getUnderlyingProductId() {
			return underlyingProductId;
		}
		
		@Override
		@RosettaAttribute("inflationLagPeriodMultiplier")
		@RuneAttribute("inflationLagPeriodMultiplier")
		public String getInflationLagPeriodMultiplier() {
			return inflationLagPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg1FixedRateNotation")
		@RuneAttribute("leg1FixedRateNotation")
		public String getLeg1FixedRateNotation() {
			return leg1FixedRateNotation;
		}
		
		@Override
		@RosettaAttribute("leg2FixedRateNotation")
		@RuneAttribute("leg2FixedRateNotation")
		public String getLeg2FixedRateNotation() {
			return leg2FixedRateNotation;
		}
		
		@Override
		@RosettaAttribute("swaptionStraddleIndicator")
		@RuneAttribute("swaptionStraddleIndicator")
		public String getSwaptionStraddleIndicator() {
			return swaptionStraddleIndicator;
		}
		
		@Override
		@RosettaAttribute("singlePartyEarlyTerminationBuyer")
		@RuneAttribute("singlePartyEarlyTerminationBuyer")
		public String getSinglePartyEarlyTerminationBuyer() {
			return singlePartyEarlyTerminationBuyer;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDate")
		@RuneAttribute("leg1EffectiveDate")
		public Date getLeg1EffectiveDate() {
			return leg1EffectiveDate;
		}
		
		@Override
		@RosettaAttribute("action")
		@RuneAttribute("action")
		public String getAction() {
			return action;
		}
		
		@Override
		@RosettaAttribute("clearingStatus")
		@RuneAttribute("clearingStatus")
		public String getClearingStatus() {
			return clearingStatus;
		}
		
		@Override
		@RosettaAttribute("effectiveDate1")
		@RuneAttribute("effectiveDate1")
		public Date getEffectiveDate1() {
			return effectiveDate1;
		}
		
		@Override
		@RosettaAttribute("executionVenueType")
		@RuneAttribute("executionVenueType")
		public String getExecutionVenueType() {
			return executionVenueType;
		}
		
		@Override
		@RosettaAttribute("nonStandardTradeIndicator")
		@RuneAttribute("nonStandardTradeIndicator")
		public Boolean getNonStandardTradeIndicator() {
			return nonStandardTradeIndicator;
		}
		
		@Override
		@RosettaAttribute("notionalAmount1")
		@RuneAttribute("notionalAmount1")
		public BigDecimal getNotionalAmount1() {
			return notionalAmount1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency1")
		@RuneAttribute("notionalCurrency1")
		public String getNotionalCurrency1() {
			return notionalCurrency1;
		}
		
		@Override
		@RosettaAttribute("price1Price")
		@RuneAttribute("price1Price")
		public BigDecimal getPrice1Price() {
			return price1Price;
		}
		
		@Override
		@RosettaAttribute("price1Type")
		@RuneAttribute("price1Type")
		public String getPrice1Type() {
			return price1Type;
		}
		
		@Override
		@RosettaAttribute("price1Units")
		@RuneAttribute("price1Units")
		public String getPrice1Units() {
			return price1Units;
		}
		
		@Override
		@RosettaAttribute("scheduledTerminationDate1")
		@RuneAttribute("scheduledTerminationDate1")
		public Date getScheduledTerminationDate1() {
			return scheduledTerminationDate1;
		}
		
		@Override
		@RosettaAttribute("tradeDate")
		@RuneAttribute("tradeDate")
		public Date getTradeDate() {
			return tradeDate;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralizationType")
		@RuneAttribute("tradeParty1CollateralizationType")
		public String getTradeParty1CollateralizationType() {
			return tradeParty1CollateralizationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1EventId")
		@RuneAttribute("tradeParty1EventId")
		public String getTradeParty1EventId() {
			return tradeParty1EventId;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralizationType")
		@RuneAttribute("tradeParty2CollateralizationType")
		public String getTradeParty2CollateralizationType() {
			return tradeParty2CollateralizationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2EventId")
		@RuneAttribute("tradeParty2EventId")
		public String getTradeParty2EventId() {
			return tradeParty2EventId;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionOnSwap")
		@RuneAttribute("embeddedOptionOnSwap")
		public String getEmbeddedOptionOnSwap() {
			return embeddedOptionOnSwap;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("notionalAmount2")
		@RuneAttribute("notionalAmount2")
		public BigDecimal getNotionalAmount2() {
			return notionalAmount2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		public String getNotionalCurrency2() {
			return notionalCurrency2;
		}
		
		@Override
		@RosettaAttribute("premiumAmount")
		@RuneAttribute("premiumAmount")
		public BigDecimal getPremiumAmount() {
			return premiumAmount;
		}
		
		@Override
		@RosettaAttribute("premiumCurrency")
		@RuneAttribute("premiumCurrency")
		public String getPremiumCurrency() {
			return premiumCurrency;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public String getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("comment1")
		@RuneAttribute("comment1")
		public String getComment1() {
			return comment1;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public String getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("commencementDate")
		@RuneAttribute("commencementDate")
		public Date getCommencementDate() {
			return commencementDate;
		}
		
		@Override
		@RosettaAttribute("dayCountFraction1")
		@RuneAttribute("dayCountFraction1")
		public String getDayCountFraction1() {
			return dayCountFraction1;
		}
		
		@Override
		@RosettaAttribute("leg2DayCountFraction")
		@RuneAttribute("leg2DayCountFraction")
		public String getLeg2DayCountFraction() {
			return leg2DayCountFraction;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDate")
		@RuneAttribute("leg2EffectiveDate")
		public Date getLeg2EffectiveDate() {
			return leg2EffectiveDate;
		}
		
		@Override
		@RosettaAttribute("leg2ResetFrequencyPeriod")
		@RuneAttribute("leg2ResetFrequencyPeriod")
		public String getLeg2ResetFrequencyPeriod() {
			return leg2ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2ResetFrequencyPeriodMultiplier")
		@RuneAttribute("leg2ResetFrequencyPeriodMultiplier")
		public BigDecimal getLeg2ResetFrequencyPeriodMultiplier() {
			return leg2ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementCurrency")
		@RuneAttribute("leg2SettlementCurrency")
		public String getLeg2SettlementCurrency() {
			return leg2SettlementCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2ScheduledTerminationDate")
		@RuneAttribute("leg2ScheduledTerminationDate")
		public Date getLeg2ScheduledTerminationDate() {
			return leg2ScheduledTerminationDate;
		}
		
		@Override
		@RosettaAttribute("numberOfOptions")
		@RuneAttribute("numberOfOptions")
		public BigDecimal getNumberOfOptions() {
			return numberOfOptions;
		}
		
		@Override
		@RosettaAttribute("optionEntitlement")
		@RuneAttribute("optionEntitlement")
		public BigDecimal getOptionEntitlement() {
			return optionEntitlement;
		}
		
		@Override
		@RosettaAttribute("originalExecutionTimestamp")
		@RuneAttribute("originalExecutionTimestamp")
		public ZonedDateTime getOriginalExecutionTimestamp() {
			return originalExecutionTimestamp;
		}
		
		@Override
		@RosettaAttribute("payment1Date")
		@RuneAttribute("payment1Date")
		public Date getPayment1Date() {
			return payment1Date;
		}
		
		@Override
		@RosettaAttribute("payment1FrequencyPeriod")
		@RuneAttribute("payment1FrequencyPeriod")
		public String getPayment1FrequencyPeriod() {
			return payment1FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment1FrequencyPeriodMultiplier")
		@RuneAttribute("payment1FrequencyPeriodMultiplier")
		public BigDecimal getPayment1FrequencyPeriodMultiplier() {
			return payment1FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment2Date")
		@RuneAttribute("payment2Date")
		public Date getPayment2Date() {
			return payment2Date;
		}
		
		@Override
		@RosettaAttribute("payment2FrequencyPeriod")
		@RuneAttribute("payment2FrequencyPeriod")
		public String getPayment2FrequencyPeriod() {
			return payment2FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment2FrequencyPeriodMultiplier")
		@RuneAttribute("payment2FrequencyPeriodMultiplier")
		public BigDecimal getPayment2FrequencyPeriodMultiplier() {
			return payment2FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("resetFrequencyPeriod1")
		@RuneAttribute("resetFrequencyPeriod1")
		public String getResetFrequencyPeriod1() {
			return resetFrequencyPeriod1;
		}
		
		@Override
		@RosettaAttribute("resetFrequencyPeriodMultiplier1")
		@RuneAttribute("resetFrequencyPeriodMultiplier1")
		public BigDecimal getResetFrequencyPeriodMultiplier1() {
			return resetFrequencyPeriodMultiplier1;
		}
		
		@Override
		@RosettaAttribute("settlementDate")
		@RuneAttribute("settlementDate")
		public Date getSettlementDate() {
			return settlementDate;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public BigDecimal getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceUnits")
		@RuneAttribute("strikePriceUnits")
		public String getStrikePriceUnits() {
			return strikePriceUnits;
		}
		
		@Override
		@RosettaAttribute("asOfDateTime")
		@RuneAttribute("asOfDateTime")
		public ZonedDateTime getAsOfDateTime() {
			return asOfDateTime;
		}
		
		@Override
		@RosettaAttribute("clearingVenueId")
		@RuneAttribute("clearingVenueId")
		public String getClearingVenueId() {
			return clearingVenueId;
		}
		
		@Override
		@RosettaAttribute("clearingVenueIdType")
		@RuneAttribute("clearingVenueIdType")
		public String getClearingVenueIdType() {
			return clearingVenueIdType;
		}
		
		@Override
		@RosettaAttribute("compressedTradeIndicator")
		@RuneAttribute("compressedTradeIndicator")
		public String getCompressedTradeIndicator() {
			return compressedTradeIndicator;
		}
		
		@Override
		@RosettaAttribute("confirmationMethod")
		@RuneAttribute("confirmationMethod")
		public String getConfirmationMethod() {
			return confirmationMethod;
		}
		
		@Override
		@RosettaAttribute("confirmationPlatformId")
		@RuneAttribute("confirmationPlatformId")
		public String getConfirmationPlatformId() {
			return confirmationPlatformId;
		}
		
		@Override
		@RosettaAttribute("confirmationPlatformTradeId")
		@RuneAttribute("confirmationPlatformTradeId")
		public String getConfirmationPlatformTradeId() {
			return confirmationPlatformTradeId;
		}
		
		@Override
		@RosettaAttribute("executionVenueId")
		@RuneAttribute("executionVenueId")
		public String getExecutionVenueId() {
			return executionVenueId;
		}
		
		@Override
		@RosettaAttribute("executionVenueIdType")
		@RuneAttribute("executionVenueIdType")
		public String getExecutionVenueIdType() {
			return executionVenueIdType;
		}
		
		@Override
		@RosettaAttribute("postTradeEffectiveDate")
		@RuneAttribute("postTradeEffectiveDate")
		public Date getPostTradeEffectiveDate() {
			return postTradeEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("priorUsiId")
		@RuneAttribute("priorUsiId")
		public String getPriorUsiId() {
			return priorUsiId;
		}
		
		@Override
		@RosettaAttribute("priorUsiIdPrefix")
		@RuneAttribute("priorUsiIdPrefix")
		public String getPriorUsiIdPrefix() {
			return priorUsiIdPrefix;
		}
		
		@Override
		@RosettaAttribute("priorUtiId")
		@RuneAttribute("priorUtiId")
		public String getPriorUtiId() {
			return priorUtiId;
		}
		
		@Override
		@RosettaAttribute("priorUtiIdPrefix")
		@RuneAttribute("priorUtiIdPrefix")
		public String getPriorUtiIdPrefix() {
			return priorUtiIdPrefix;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BranchLocation")
		@RuneAttribute("tradeParty1BranchLocation")
		public String getTradeParty1BranchLocation() {
			return tradeParty1BranchLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerId")
		@RuneAttribute("tradeParty1ClearingBrokerId")
		public String getTradeParty1ClearingBrokerId() {
			return tradeParty1ClearingBrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerIdType")
		@RuneAttribute("tradeParty1ClearingBrokerIdType")
		public String getTradeParty1ClearingBrokerIdType() {
			return tradeParty1ClearingBrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1DeskLocation")
		@RuneAttribute("tradeParty1DeskLocation")
		public String getTradeParty1DeskLocation() {
			return tradeParty1DeskLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Domicile")
		@RuneAttribute("tradeParty1Domicile")
		public String getTradeParty1Domicile() {
			return tradeParty1Domicile;
		}
		
		@Override
		@RosettaAttribute("tradeParty1IndustrialSectorType")
		@RuneAttribute("tradeParty1IndustrialSectorType")
		public String getTradeParty1IndustrialSectorType() {
			return tradeParty1IndustrialSectorType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BranchLocation")
		@RuneAttribute("tradeParty2BranchLocation")
		public String getTradeParty2BranchLocation() {
			return tradeParty2BranchLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty2DeskLocation")
		@RuneAttribute("tradeParty2DeskLocation")
		public String getTradeParty2DeskLocation() {
			return tradeParty2DeskLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Domicile")
		@RuneAttribute("tradeParty2Domicile")
		public String getTradeParty2Domicile() {
			return tradeParty2Domicile;
		}
		
		@Override
		@RosettaAttribute("tradeParty2IndustrialSectorType")
		@RuneAttribute("tradeParty2IndustrialSectorType")
		public String getTradeParty2IndustrialSectorType() {
			return tradeParty2IndustrialSectorType;
		}
		
		@Override
		@RosettaAttribute("sellerPayer2")
		@RuneAttribute("sellerPayer2")
		public String getSellerPayer2() {
			return sellerPayer2;
		}
		
		@Override
		@RosettaAttribute("buyerPayer1")
		@RuneAttribute("buyerPayer1")
		public String getBuyerPayer1() {
			return buyerPayer1;
		}
		
		@Override
		@RosettaAttribute("tradeParty1HkCounterpartyOrigin")
		@RuneAttribute("tradeParty1HkCounterpartyOrigin")
		public String getTradeParty1HkCounterpartyOrigin() {
			return tradeParty1HkCounterpartyOrigin;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementDate")
		@RuneAttribute("leg2SettlementDate")
		public Date getLeg2SettlementDate() {
			return leg2SettlementDate;
		}
		
		@Override
		@RosettaAttribute("leg1FixedRateInitial")
		@RuneAttribute("leg1FixedRateInitial")
		public BigDecimal getLeg1FixedRateInitial() {
			return leg1FixedRateInitial;
		}
		
		@Override
		@RosettaAttribute("leg2FixedRateInitial")
		@RuneAttribute("leg2FixedRateInitial")
		public BigDecimal getLeg2FixedRateInitial() {
			return leg2FixedRateInitial;
		}
		
		@Override
		@RosettaAttribute("payment1Amount")
		@RuneAttribute("payment1Amount")
		public BigDecimal getPayment1Amount() {
			return payment1Amount;
		}
		
		@Override
		@RosettaAttribute("payment1Currency")
		@RuneAttribute("payment1Currency")
		public String getPayment1Currency() {
			return payment1Currency;
		}
		
		@Override
		@RosettaAttribute("payment1Payer")
		@RuneAttribute("payment1Payer")
		public String getPayment1Payer() {
			return payment1Payer;
		}
		
		@Override
		@RosettaAttribute("payment1Receiver")
		@RuneAttribute("payment1Receiver")
		public String getPayment1Receiver() {
			return payment1Receiver;
		}
		
		@Override
		@RosettaAttribute("payment2Payer")
		@RuneAttribute("payment2Payer")
		public String getPayment2Payer() {
			return payment2Payer;
		}
		
		@Override
		@RosettaAttribute("postTradeTransactionDate")
		@RuneAttribute("postTradeTransactionDate")
		public Date getPostTradeTransactionDate() {
			return postTradeTransactionDate;
		}
		
		@Override
		@RosettaAttribute("secondaryAssetClass")
		@RuneAttribute("secondaryAssetClass")
		public String getSecondaryAssetClass() {
			return secondaryAssetClass;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public String getSettlementType() {
			return settlementType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Name")
		@RuneAttribute("tradeParty1Name")
		public String getTradeParty1Name() {
			return tradeParty1Name;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Name")
		@RuneAttribute("tradeParty2Name")
		public String getTradeParty2Name() {
			return tradeParty2Name;
		}
		
		@Override
		@RosettaAttribute("ccpValuationAmount")
		@RuneAttribute("ccpValuationAmount")
		public BigDecimal getCcpValuationAmount() {
			return ccpValuationAmount;
		}
		
		@Override
		@RosettaAttribute("ccpValuationCurrency")
		@RuneAttribute("ccpValuationCurrency")
		public String getCcpValuationCurrency() {
			return ccpValuationCurrency;
		}
		
		@Override
		@RosettaAttribute("ccpValuationDatetime")
		@RuneAttribute("ccpValuationDatetime")
		public ZonedDateTime getCcpValuationDatetime() {
			return ccpValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("ccpValuationType")
		@RuneAttribute("ccpValuationType")
		public String getCcpValuationType() {
			return ccpValuationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationAmount")
		@RuneAttribute("tradeParty1ValuationAmount")
		public BigDecimal getTradeParty1ValuationAmount() {
			return tradeParty1ValuationAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationCurrency")
		@RuneAttribute("tradeParty1ValuationCurrency")
		public String getTradeParty1ValuationCurrency() {
			return tradeParty1ValuationCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationDatetime")
		@RuneAttribute("tradeParty1ValuationDatetime")
		public ZonedDateTime getTradeParty1ValuationDatetime() {
			return tradeParty1ValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationType")
		@RuneAttribute("tradeParty1ValuationType")
		public String getTradeParty1ValuationType() {
			return tradeParty1ValuationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationAmount")
		@RuneAttribute("tradeParty2ValuationAmount")
		public BigDecimal getTradeParty2ValuationAmount() {
			return tradeParty2ValuationAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationCurrency")
		@RuneAttribute("tradeParty2ValuationCurrency")
		public String getTradeParty2ValuationCurrency() {
			return tradeParty2ValuationCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationDatetime")
		@RuneAttribute("tradeParty2ValuationDatetime")
		public ZonedDateTime getTradeParty2ValuationDatetime() {
			return tradeParty2ValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationType")
		@RuneAttribute("tradeParty2ValuationType")
		public String getTradeParty2ValuationType() {
			return tradeParty2ValuationType;
		}
		
		@Override
		@RosettaAttribute("executionType")
		@RuneAttribute("executionType")
		public String getExecutionType() {
			return executionType;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public String getStrikePriceCurrency() {
			return strikePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("payment2Amount")
		@RuneAttribute("payment2Amount")
		public BigDecimal getPayment2Amount() {
			return payment2Amount;
		}
		
		@Override
		@RosettaAttribute("tradeParty2HkCounterpartyOrigin")
		@RuneAttribute("tradeParty2HkCounterpartyOrigin")
		public String getTradeParty2HkCounterpartyOrigin() {
			return tradeParty2HkCounterpartyOrigin;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CountryOfTheOtherCounterparty")
		@RuneAttribute("tradeParty1CountryOfTheOtherCounterparty")
		public String getTradeParty1CountryOfTheOtherCounterparty() {
			return tradeParty1CountryOfTheOtherCounterparty;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CountryOfTheOtherCounterparty")
		@RuneAttribute("tradeParty2CountryOfTheOtherCounterparty")
		public String getTradeParty2CountryOfTheOtherCounterparty() {
			return tradeParty2CountryOfTheOtherCounterparty;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerId")
		@RuneAttribute("tradeParty1BrokerId")
		public String getTradeParty1BrokerId() {
			return tradeParty1BrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BrokerId")
		@RuneAttribute("tradeParty2BrokerId")
		public String getTradeParty2BrokerId() {
			return tradeParty2BrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BeneficiaryIdType")
		@RuneAttribute("tradeParty1BeneficiaryIdType")
		public String getTradeParty1BeneficiaryIdType() {
			return tradeParty1BeneficiaryIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BeneficiaryId")
		@RuneAttribute("tradeParty1BeneficiaryId")
		public String getTradeParty1BeneficiaryId() {
			return tradeParty1BeneficiaryId;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BeneficiaryIdType")
		@RuneAttribute("tradeParty2BeneficiaryIdType")
		public String getTradeParty2BeneficiaryIdType() {
			return tradeParty2BeneficiaryIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BeneficiaryId")
		@RuneAttribute("tradeParty2BeneficiaryId")
		public String getTradeParty2BeneficiaryId() {
			return tradeParty2BeneficiaryId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CounterpartySide")
		@RuneAttribute("tradeParty1CounterpartySide")
		public String getTradeParty1CounterpartySide() {
			return tradeParty1CounterpartySide;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CounterpartySide")
		@RuneAttribute("tradeParty2CounterpartySide")
		public String getTradeParty2CounterpartySide() {
			return tradeParty2CounterpartySide;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralPortfolioCode")
		@RuneAttribute("tradeParty1CollateralPortfolioCode")
		public String getTradeParty1CollateralPortfolioCode() {
			return tradeParty1CollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralPortfolioCode")
		@RuneAttribute("tradeParty2CollateralPortfolioCode")
		public String getTradeParty2CollateralPortfolioCode() {
			return tradeParty2CollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute("euUnderlyingAssetIdType")
		@RuneAttribute("euUnderlyingAssetIdType")
		public String getEuUnderlyingAssetIdType() {
			return euUnderlyingAssetIdType;
		}
		
		@Override
		@RosettaAttribute("productClassification")
		@RuneAttribute("productClassification")
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute("complexTradeComponentId")
		@RuneAttribute("complexTradeComponentId")
		public String getComplexTradeComponentId() {
			return complexTradeComponentId;
		}
		
		@Override
		@RosettaAttribute("priceMultiplier")
		@RuneAttribute("priceMultiplier")
		public BigDecimal getPriceMultiplier() {
			return priceMultiplier;
		}
		
		@Override
		@RosettaAttribute("quantity")
		@RuneAttribute("quantity")
		public BigDecimal getQuantity() {
			return quantity;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public String getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("confirmationDatetime")
		@RuneAttribute("confirmationDatetime")
		public ZonedDateTime getConfirmationDatetime() {
			return confirmationDatetime;
		}
		
		@Override
		@RosettaAttribute("clearingDatetime")
		@RuneAttribute("clearingDatetime")
		public ZonedDateTime getClearingDatetime() {
			return clearingDatetime;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public String getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute("productClassificationType")
		@RuneAttribute("productClassificationType")
		public String getProductClassificationType() {
			return productClassificationType;
		}
		
		@Override
		@RosettaAttribute("productIdentificationType")
		@RuneAttribute("productIdentificationType")
		public String getProductIdentificationType() {
			return productIdentificationType;
		}
		
		@Override
		@RosettaAttribute("productIdentification")
		@RuneAttribute("productIdentification")
		public String getProductIdentification() {
			return productIdentification;
		}
		
		@Override
		@RosettaAttribute("euUnderlyingAssetId")
		@RuneAttribute("euUnderlyingAssetId")
		public String getEuUnderlyingAssetId() {
			return euUnderlyingAssetId;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerIdType")
		@RuneAttribute("tradeParty1BrokerIdType")
		public String getTradeParty1BrokerIdType() {
			return tradeParty1BrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BrokerIdType")
		@RuneAttribute("tradeParty2BrokerIdType")
		public String getTradeParty2BrokerIdType() {
			return tradeParty2BrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingBrokerIdType")
		@RuneAttribute("tradeParty2ClearingBrokerIdType")
		public String getTradeParty2ClearingBrokerIdType() {
			return tradeParty2ClearingBrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingBrokerId")
		@RuneAttribute("tradeParty2ClearingBrokerId")
		public String getTradeParty2ClearingBrokerId() {
			return tradeParty2ClearingBrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingThreshold")
		@RuneAttribute("tradeParty1ClearingThreshold")
		public Boolean getTradeParty1ClearingThreshold() {
			return tradeParty1ClearingThreshold;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingThreshold")
		@RuneAttribute("tradeParty2ClearingThreshold")
		public Boolean getTradeParty2ClearingThreshold() {
			return tradeParty2ClearingThreshold;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CorporateSectorType")
		@RuneAttribute("tradeParty1CorporateSectorType")
		public String getTradeParty1CorporateSectorType() {
			return tradeParty1CorporateSectorType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CorporateSectorType")
		@RuneAttribute("tradeParty2CorporateSectorType")
		public String getTradeParty2CorporateSectorType() {
			return tradeParty2CorporateSectorType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		@RuneAttribute("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		public String getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator() {
			return tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		}
		
		@Override
		@RosettaAttribute("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		@RuneAttribute("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		public String getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator() {
			return tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		}
		
		@Override
		@RosettaAttribute("intragroupIndicator")
		@RuneAttribute("intragroupIndicator")
		public Boolean getIntragroupIndicator() {
			return intragroupIndicator;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TradingCapacity1")
		@RuneAttribute("tradeParty1TradingCapacity1")
		public String getTradeParty1TradingCapacity1() {
			return tradeParty1TradingCapacity1;
		}
		
		@Override
		@RosettaAttribute("tradeParty2TradingCapacity1")
		@RuneAttribute("tradeParty2TradingCapacity1")
		public String getTradeParty2TradingCapacity1() {
			return tradeParty2TradingCapacity1;
		}
		
		@Override
		@RosettaAttribute("currencyOfPrice")
		@RuneAttribute("currencyOfPrice")
		public String getCurrencyOfPrice() {
			return currencyOfPrice;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralPortfolio")
		@RuneAttribute("tradeParty1CollateralPortfolio")
		public String getTradeParty1CollateralPortfolio() {
			return tradeParty1CollateralPortfolio;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralPortfolio")
		@RuneAttribute("tradeParty2CollateralPortfolio")
		public String getTradeParty2CollateralPortfolio() {
			return tradeParty2CollateralPortfolio;
		}
		
		@Override
		@RosettaAttribute("executionVenueMicCode")
		@RuneAttribute("executionVenueMicCode")
		public String getExecutionVenueMicCode() {
			return executionVenueMicCode;
		}
		
		@Override
		@RosettaAttribute("payment2Currency")
		@RuneAttribute("payment2Currency")
		public String getPayment2Currency() {
			return payment2Currency;
		}
		
		@Override
		@RosettaAttribute("expirationDateTimeBusinessCenter")
		@RuneAttribute("expirationDateTimeBusinessCenter")
		public String getExpirationDateTimeBusinessCenter() {
			return expirationDateTimeBusinessCenter;
		}
		
		@Override
		@RosettaAttribute("expirationTime")
		@RuneAttribute("expirationTime")
		public LocalTime getExpirationTime() {
			return expirationTime;
		}
		
		@Override
		@RosettaAttribute("expirationTimeType")
		@RuneAttribute("expirationTimeType")
		public String getExpirationTimeType() {
			return expirationTimeType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TraderLocation")
		@RuneAttribute("tradeParty1TraderLocation")
		public String getTradeParty1TraderLocation() {
			return tradeParty1TraderLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty2TraderLocation")
		@RuneAttribute("tradeParty2TraderLocation")
		public String getTradeParty2TraderLocation() {
			return tradeParty2TraderLocation;
		}
		
		@Override
		@RosettaAttribute("payment3ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment3ResetFrequencyPeriodMultiplier")
		public BigDecimal getPayment3ResetFrequencyPeriodMultiplier() {
			return payment3ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment3ResetFrequencyPeriod")
		@RuneAttribute("payment3ResetFrequencyPeriod")
		public String getPayment3ResetFrequencyPeriod() {
			return payment3ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment4ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment4ResetFrequencyPeriodMultiplier")
		public BigDecimal getPayment4ResetFrequencyPeriodMultiplier() {
			return payment4ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment4ResetFrequencyPeriod")
		@RuneAttribute("payment4ResetFrequencyPeriod")
		public String getPayment4ResetFrequencyPeriod() {
			return payment4ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment5ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment5ResetFrequencyPeriodMultiplier")
		public BigDecimal getPayment5ResetFrequencyPeriodMultiplier() {
			return payment5ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment5ResetFrequencyPeriod")
		@RuneAttribute("payment5ResetFrequencyPeriod")
		public String getPayment5ResetFrequencyPeriod() {
			return payment5ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment1Type")
		@RuneAttribute("payment1Type")
		public String getPayment1Type() {
			return payment1Type;
		}
		
		@Override
		@RosettaAttribute("payment1Reference")
		@RuneAttribute("payment1Reference")
		public String getPayment1Reference() {
			return payment1Reference;
		}
		
		@Override
		@RosettaAttribute("payment2Type")
		@RuneAttribute("payment2Type")
		public String getPayment2Type() {
			return payment2Type;
		}
		
		@Override
		@RosettaAttribute("payment2Reference")
		@RuneAttribute("payment2Reference")
		public String getPayment2Reference() {
			return payment2Reference;
		}
		
		@Override
		@RosettaAttribute("payment3Payer")
		@RuneAttribute("payment3Payer")
		public String getPayment3Payer() {
			return payment3Payer;
		}
		
		@Override
		@RosettaAttribute("payment3Reference")
		@RuneAttribute("payment3Reference")
		public String getPayment3Reference() {
			return payment3Reference;
		}
		
		@Override
		@RosettaAttribute("payment3FrequencyPeriod")
		@RuneAttribute("payment3FrequencyPeriod")
		public String getPayment3FrequencyPeriod() {
			return payment3FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment3FrequencyPeriodMultiplier")
		@RuneAttribute("payment3FrequencyPeriodMultiplier")
		public BigDecimal getPayment3FrequencyPeriodMultiplier() {
			return payment3FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment3Date")
		@RuneAttribute("payment3Date")
		public Date getPayment3Date() {
			return payment3Date;
		}
		
		@Override
		@RosettaAttribute("payment4Reference")
		@RuneAttribute("payment4Reference")
		public String getPayment4Reference() {
			return payment4Reference;
		}
		
		@Override
		@RosettaAttribute("payment4Payer")
		@RuneAttribute("payment4Payer")
		public String getPayment4Payer() {
			return payment4Payer;
		}
		
		@Override
		@RosettaAttribute("payment4FrequencyPeriod")
		@RuneAttribute("payment4FrequencyPeriod")
		public String getPayment4FrequencyPeriod() {
			return payment4FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment4FrequencyPeriodMultiplier")
		@RuneAttribute("payment4FrequencyPeriodMultiplier")
		public BigDecimal getPayment4FrequencyPeriodMultiplier() {
			return payment4FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment4Date")
		@RuneAttribute("payment4Date")
		public Date getPayment4Date() {
			return payment4Date;
		}
		
		@Override
		@RosettaAttribute("payment5Reference")
		@RuneAttribute("payment5Reference")
		public String getPayment5Reference() {
			return payment5Reference;
		}
		
		@Override
		@RosettaAttribute("payment5Payer")
		@RuneAttribute("payment5Payer")
		public String getPayment5Payer() {
			return payment5Payer;
		}
		
		@Override
		@RosettaAttribute("payment5FrequencyPeriod")
		@RuneAttribute("payment5FrequencyPeriod")
		public String getPayment5FrequencyPeriod() {
			return payment5FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment5FrequencyPeriodMultiplier")
		@RuneAttribute("payment5FrequencyPeriodMultiplier")
		public BigDecimal getPayment5FrequencyPeriodMultiplier() {
			return payment5FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment5Date")
		@RuneAttribute("payment5Date")
		public Date getPayment5Date() {
			return payment5Date;
		}
		
		@Override
		@RosettaAttribute("payment3Type")
		@RuneAttribute("payment3Type")
		public String getPayment3Type() {
			return payment3Type;
		}
		
		@Override
		@RosettaAttribute("premiumPayer")
		@RuneAttribute("premiumPayer")
		public String getPremiumPayer() {
			return premiumPayer;
		}
		
		@Override
		@RosettaAttribute("premiumPaymentDateUnadjusted")
		@RuneAttribute("premiumPaymentDateUnadjusted")
		public Date getPremiumPaymentDateUnadjusted() {
			return premiumPaymentDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("tradeParty1NatureOfTheReportingCounterparty")
		@RuneAttribute("tradeParty1NatureOfTheReportingCounterparty")
		public String getTradeParty1NatureOfTheReportingCounterparty() {
			return tradeParty1NatureOfTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("tradeParty2NatureOfTheReportingCounterparty")
		@RuneAttribute("tradeParty2NatureOfTheReportingCounterparty")
		public String getTradeParty2NatureOfTheReportingCounterparty() {
			return tradeParty2NatureOfTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse1")
		@RuneAttribute("reservedParticipantUse1")
		public String getReservedParticipantUse1() {
			return reservedParticipantUse1;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse2")
		@RuneAttribute("reservedParticipantUse2")
		public String getReservedParticipantUse2() {
			return reservedParticipantUse2;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse3")
		@RuneAttribute("reservedParticipantUse3")
		public String getReservedParticipantUse3() {
			return reservedParticipantUse3;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse4")
		@RuneAttribute("reservedParticipantUse4")
		public String getReservedParticipantUse4() {
			return reservedParticipantUse4;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse5")
		@RuneAttribute("reservedParticipantUse5")
		public String getReservedParticipantUse5() {
			return reservedParticipantUse5;
		}
		
		@Override
		@RosettaAttribute("leg1TerminationDate")
		@RuneAttribute("leg1TerminationDate")
		public Date getLeg1TerminationDate() {
			return leg1TerminationDate;
		}
		
		@Override
		@RosettaAttribute("allocationType")
		@RuneAttribute("allocationType")
		public String getAllocationType() {
			return allocationType;
		}
		
		@Override
		@RosettaAttribute("calculationBasis")
		@RuneAttribute("calculationBasis")
		public String getCalculationBasis() {
			return calculationBasis;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionPartyId")
		@RuneAttribute("clearingExceptionPartyId")
		public String getClearingExceptionPartyId() {
			return clearingExceptionPartyId;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionPartyIdType")
		@RuneAttribute("clearingExceptionPartyIdType")
		public String getClearingExceptionPartyIdType() {
			return clearingExceptionPartyIdType;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionType")
		@RuneAttribute("clearingExceptionType")
		public String getClearingExceptionType() {
			return clearingExceptionType;
		}
		
		@Override
		@RosettaAttribute("clearingMemberClientAccountId")
		@RuneAttribute("clearingMemberClientAccountId")
		public String getClearingMemberClientAccountId() {
			return clearingMemberClientAccountId;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptDatetime")
		@RuneAttribute("clearingReceiptDatetime")
		public ZonedDateTime getClearingReceiptDatetime() {
			return clearingReceiptDatetime;
		}
		
		@Override
		@RosettaAttribute("clearingSwapSdrLeiId")
		@RuneAttribute("clearingSwapSdrLeiId")
		public String getClearingSwapSdrLeiId() {
			return clearingSwapSdrLeiId;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUtiId")
		@RuneAttribute("clearingSwapUtiId")
		public String getClearingSwapUtiId() {
			return clearingSwapUtiId;
		}
		
		@Override
		@RosettaAttribute("collateralReportingDate")
		@RuneAttribute("collateralReportingDate")
		public Date getCollateralReportingDate() {
			return collateralReportingDate;
		}
		
		@Override
		@RosettaAttribute("collateralValuationDatetime")
		@RuneAttribute("collateralValuationDatetime")
		public ZonedDateTime getCollateralValuationDatetime() {
			return collateralValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("comment2")
		@RuneAttribute("comment2")
		public String getComment2() {
			return comment2;
		}
		
		@Override
		@RosettaAttribute("commodityStrikePriceUnit")
		@RuneAttribute("commodityStrikePriceUnit")
		public String getCommodityStrikePriceUnit() {
			return commodityStrikePriceUnit;
		}
		
		@Override
		@RosettaAttribute("executionAgentMaskingIndicator")
		@RuneAttribute("executionAgentMaskingIndicator")
		public String getExecutionAgentMaskingIndicator() {
			return executionAgentMaskingIndicator;
		}
		
		@Override
		@RosettaAttribute("feeInCurrency")
		@RuneAttribute("feeInCurrency")
		public String getFeeInCurrency() {
			return feeInCurrency;
		}
		
		@Override
		@RosettaAttribute("feeOutCurrency")
		@RuneAttribute("feeOutCurrency")
		public String getFeeOutCurrency() {
			return feeOutCurrency;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg1Multiplier")
		@RuneAttribute("floatingRatePaymentFrequencyLeg1Multiplier")
		public BigDecimal getFloatingRatePaymentFrequencyLeg1Multiplier() {
			return floatingRatePaymentFrequencyLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg1TimePeriod")
		@RuneAttribute("floatingRatePaymentFrequencyLeg1TimePeriod")
		public String getFloatingRatePaymentFrequencyLeg1TimePeriod() {
			return floatingRatePaymentFrequencyLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg2Multiplier")
		@RuneAttribute("floatingRatePaymentFrequencyLeg2Multiplier")
		public BigDecimal getFloatingRatePaymentFrequencyLeg2Multiplier() {
			return floatingRatePaymentFrequencyLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg2TimePeriod")
		@RuneAttribute("floatingRatePaymentFrequencyLeg2TimePeriod")
		public String getFloatingRatePaymentFrequencyLeg2TimePeriod() {
			return floatingRatePaymentFrequencyLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("frequencyOfPayment")
		@RuneAttribute("frequencyOfPayment")
		public String getFrequencyOfPayment() {
			return frequencyOfPayment;
		}
		
		@Override
		@RosettaAttribute("interaffiliate")
		@RuneAttribute("interaffiliate")
		public Boolean getInteraffiliate() {
			return interaffiliate;
		}
		
		@Override
		@RosettaAttribute("largeTradeIndicator")
		@RuneAttribute("largeTradeIndicator")
		public Boolean getLargeTradeIndicator() {
			return largeTradeIndicator;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDateAdjusted")
		@RuneAttribute("leg1EffectiveDateAdjusted")
		public Date getLeg1EffectiveDateAdjusted() {
			return leg1EffectiveDateAdjusted;
		}
		
		@Override
		@RosettaAttribute("leg1FinalValuationDate")
		@RuneAttribute("leg1FinalValuationDate")
		public Date getLeg1FinalValuationDate() {
			return leg1FinalValuationDate;
		}
		
		@Override
		@RosettaAttribute("leg1SettlementPeriod")
		@RuneAttribute("leg1SettlementPeriod")
		public String getLeg1SettlementPeriod() {
			return leg1SettlementPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDateAdjusted")
		@RuneAttribute("leg2EffectiveDateAdjusted")
		public Date getLeg2EffectiveDateAdjusted() {
			return leg2EffectiveDateAdjusted;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentTermsFrequencyPeriod")
		@RuneAttribute("leg2PaymentTermsFrequencyPeriod")
		public String getLeg2PaymentTermsFrequencyPeriod() {
			return leg2PaymentTermsFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentTermsPaymentFrequencyPeriodMultiplier")
		@RuneAttribute("leg2PaymentTermsPaymentFrequencyPeriodMultiplier")
		public BigDecimal getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier() {
			return leg2PaymentTermsPaymentFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementType")
		@RuneAttribute("leg2SettlementType")
		public String getLeg2SettlementType() {
			return leg2SettlementType;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetId")
		@RuneAttribute("leg2UnderlyingAssetId")
		public String getLeg2UnderlyingAssetId() {
			return leg2UnderlyingAssetId;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetIdType")
		@RuneAttribute("leg2UnderlyingAssetIdType")
		public String getLeg2UnderlyingAssetIdType() {
			return leg2UnderlyingAssetIdType;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetName")
		@RuneAttribute("leg2UnderlyingAssetName")
		public String getLeg2UnderlyingAssetName() {
			return leg2UnderlyingAssetName;
		}
		
		@Override
		@RosettaAttribute("maturityDate")
		@RuneAttribute("maturityDate")
		public Date getMaturityDate() {
			return maturityDate;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationDate")
		@RuneAttribute("optionalEarlyTerminationDate")
		public String getOptionalEarlyTerminationDate() {
			return optionalEarlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("optionCommodityCurrency")
		@RuneAttribute("optionCommodityCurrency")
		public String getOptionCommodityCurrency() {
			return optionCommodityCurrency;
		}
		
		@Override
		@RosettaAttribute("optionCommodityExchangeId")
		@RuneAttribute("optionCommodityExchangeId")
		public String getOptionCommodityExchangeId() {
			return optionCommodityExchangeId;
		}
		
		@Override
		@RosettaAttribute("optionCommodityInstrumentId")
		@RuneAttribute("optionCommodityInstrumentId")
		public String getOptionCommodityInstrumentId() {
			return optionCommodityInstrumentId;
		}
		
		@Override
		@RosettaAttribute("optionCommodityRateSource")
		@RuneAttribute("optionCommodityRateSource")
		public String getOptionCommodityRateSource() {
			return optionCommodityRateSource;
		}
		
		@Override
		@RosettaAttribute("optionCommodityRateSourcePage")
		@RuneAttribute("optionCommodityRateSourcePage")
		public String getOptionCommodityRateSourcePage() {
			return optionCommodityRateSourcePage;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnderlyerDetails")
		@RuneAttribute("optionCommodityUnderlyerDetails")
		public String getOptionCommodityUnderlyerDetails() {
			return optionCommodityUnderlyerDetails;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnderlyerId")
		@RuneAttribute("optionCommodityUnderlyerId")
		public String getOptionCommodityUnderlyerId() {
			return optionCommodityUnderlyerId;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnitOfMeasure")
		@RuneAttribute("optionCommodityUnitOfMeasure")
		public String getOptionCommodityUnitOfMeasure() {
			return optionCommodityUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("optionSpecifiedPrice")
		@RuneAttribute("optionSpecifiedPrice")
		public String getOptionSpecifiedPrice() {
			return optionSpecifiedPrice;
		}
		
		@Override
		@RosettaAttribute("optionSpreadAmount")
		@RuneAttribute("optionSpreadAmount")
		public BigDecimal getOptionSpreadAmount() {
			return optionSpreadAmount;
		}
		
		@Override
		@RosettaAttribute("optionSpreadCurrency")
		@RuneAttribute("optionSpreadCurrency")
		public String getOptionSpreadCurrency() {
			return optionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("optionSpreadSchedule")
		@RuneAttribute("optionSpreadSchedule")
		public String getOptionSpreadSchedule() {
			return optionSpreadSchedule;
		}
		
		@Override
		@RosettaAttribute("origin")
		@RuneAttribute("origin")
		public String getOrigin() {
			return origin;
		}
		
		@Override
		@RosettaAttribute("originalSwapSdrId")
		@RuneAttribute("originalSwapSdrId")
		public String getOriginalSwapSdrId() {
			return originalSwapSdrId;
		}
		
		@Override
		@RosettaAttribute("originalSwapSdrIdType")
		@RuneAttribute("originalSwapSdrIdType")
		public String getOriginalSwapSdrIdType() {
			return originalSwapSdrIdType;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg1")
		@RuneAttribute("paymentFrequencyPeriodLeg1")
		public String getPaymentFrequencyPeriodLeg1() {
			return paymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg2")
		@RuneAttribute("paymentFrequencyPeriodLeg2")
		public String getPaymentFrequencyPeriodLeg2() {
			return paymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg1")
		public BigDecimal getPaymentFrequencyPeriodMultiplierLeg1() {
			return paymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg2")
		public BigDecimal getPaymentFrequencyPeriodMultiplierLeg2() {
			return paymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("premiumPayerPrefix")
		@RuneAttribute("premiumPayerPrefix")
		public String getPremiumPayerPrefix() {
			return premiumPayerPrefix;
		}
		
		@Override
		@RosettaAttribute("price1Currency")
		@RuneAttribute("price1Currency")
		public String getPrice1Currency() {
			return price1Currency;
		}
		
		@Override
		@RosettaAttribute("price2Price")
		@RuneAttribute("price2Price")
		public BigDecimal getPrice2Price() {
			return price2Price;
		}
		
		@Override
		@RosettaAttribute("price2Type")
		@RuneAttribute("price2Type")
		public String getPrice2Type() {
			return price2Type;
		}
		
		@Override
		@RosettaAttribute("price2Units")
		@RuneAttribute("price2Units")
		public String getPrice2Units() {
			return price2Units;
		}
		
		@Override
		@RosettaAttribute("price3Price")
		@RuneAttribute("price3Price")
		public BigDecimal getPrice3Price() {
			return price3Price;
		}
		
		@Override
		@RosettaAttribute("price3Type")
		@RuneAttribute("price3Type")
		public String getPrice3Type() {
			return price3Type;
		}
		
		@Override
		@RosettaAttribute("price3Units")
		@RuneAttribute("price3Units")
		public String getPrice3Units() {
			return price3Units;
		}
		
		@Override
		@RosettaAttribute("price4Price")
		@RuneAttribute("price4Price")
		public BigDecimal getPrice4Price() {
			return price4Price;
		}
		
		@Override
		@RosettaAttribute("price4Type")
		@RuneAttribute("price4Type")
		public String getPrice4Type() {
			return price4Type;
		}
		
		@Override
		@RosettaAttribute("price4Units")
		@RuneAttribute("price4Units")
		public String getPrice4Units() {
			return price4Units;
		}
		
		@Override
		@RosettaAttribute("pricingContext")
		@RuneAttribute("pricingContext")
		public String getPricingContext() {
			return pricingContext;
		}
		
		@Override
		@RosettaAttribute("priorUsiType")
		@RuneAttribute("priorUsiType")
		public String getPriorUsiType() {
			return priorUsiType;
		}
		
		@Override
		@RosettaAttribute("priorUtiType")
		@RuneAttribute("priorUtiType")
		public String getPriorUtiType() {
			return priorUtiType;
		}
		
		@Override
		@RosettaAttribute("recoveryPrice")
		@RuneAttribute("recoveryPrice")
		public BigDecimal getRecoveryPrice() {
			return recoveryPrice;
		}
		
		@Override
		@RosettaAttribute("sendToDataCenterCode")
		@RuneAttribute("sendToDataCenterCode")
		public String getSendToDataCenterCode() {
			return sendToDataCenterCode;
		}
		
		@Override
		@RosettaAttribute("strikePriceType")
		@RuneAttribute("strikePriceType")
		public String getStrikePriceType() {
			return strikePriceType;
		}
		
		@Override
		@RosettaAttribute("subAssetClassForOtherCommodity")
		@RuneAttribute("subAssetClassForOtherCommodity")
		public String getSubAssetClassForOtherCommodity() {
			return subAssetClassForOtherCommodity;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CftcFinancialEntityStatus")
		@RuneAttribute("tradeParty1CftcFinancialEntityStatus")
		public String getTradeParty1CftcFinancialEntityStatus() {
			return tradeParty1CftcFinancialEntityStatus;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralAmount")
		@RuneAttribute("tradeParty1CollateralAmount")
		public BigDecimal getTradeParty1CollateralAmount() {
			return tradeParty1CollateralAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralCurrency")
		@RuneAttribute("tradeParty1CollateralCurrency")
		public String getTradeParty1CollateralCurrency() {
			return tradeParty1CollateralCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty1MandatoryDelegatedReporting")
		@RuneAttribute("tradeParty1MandatoryDelegatedReporting")
		public String getTradeParty1MandatoryDelegatedReporting() {
			return tradeParty1MandatoryDelegatedReporting;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Role")
		@RuneAttribute("tradeParty1Role")
		public String getTradeParty1Role() {
			return tradeParty1Role;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CftcFinancialEntityStatus")
		@RuneAttribute("tradeParty2CftcFinancialEntityStatus")
		public String getTradeParty2CftcFinancialEntityStatus() {
			return tradeParty2CftcFinancialEntityStatus;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralAmount")
		@RuneAttribute("tradeParty2CollateralAmount")
		public BigDecimal getTradeParty2CollateralAmount() {
			return tradeParty2CollateralAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralCurrency")
		@RuneAttribute("tradeParty2CollateralCurrency")
		public String getTradeParty2CollateralCurrency() {
			return tradeParty2CollateralCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty2MandatoryDelegatedReporting")
		@RuneAttribute("tradeParty2MandatoryDelegatedReporting")
		public String getTradeParty2MandatoryDelegatedReporting() {
			return tradeParty2MandatoryDelegatedReporting;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Role")
		@RuneAttribute("tradeParty2Role")
		public String getTradeParty2Role() {
			return tradeParty2Role;
		}
		
		@Override
		@RosettaAttribute("upfrontPayment")
		@RuneAttribute("upfrontPayment")
		public BigDecimal getUpfrontPayment() {
			return upfrontPayment;
		}
		
		@Override
		@RosettaAttribute("verificationMethod")
		@RuneAttribute("verificationMethod")
		public String getVerificationMethod() {
			return verificationMethod;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterId")
		@RuneAttribute("responsibleDataSubmitterId")
		public String getResponsibleDataSubmitterId() {
			return responsibleDataSubmitterId;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterIdType")
		@RuneAttribute("responsibleDataSubmitterIdType")
		public String getResponsibleDataSubmitterIdType() {
			return responsibleDataSubmitterIdType;
		}
		
		@Override
		@RosettaAttribute("originalSwapUsi")
		@RuneAttribute("originalSwapUsi")
		public String getOriginalSwapUsi() {
			return originalSwapUsi;
		}
		
		@Override
		@RosettaAttribute("originalSwapUti")
		@RuneAttribute("originalSwapUti")
		public String getOriginalSwapUti() {
			return originalSwapUti;
		}
		
		@Override
		@RosettaAttribute("cdeReceiverIdentifierLeg2")
		@RuneAttribute("cdeReceiverIdentifierLeg2")
		public String getCdeReceiverIdentifierLeg2() {
			return cdeReceiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("counterparty1FederalEntityIndicator")
		@RuneAttribute("counterparty1FederalEntityIndicator")
		public Boolean getCounterparty1FederalEntityIndicator() {
			return counterparty1FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("counterparty2FederalEntityIndicator")
		@RuneAttribute("counterparty2FederalEntityIndicator")
		public Boolean getCounterparty2FederalEntityIndicator() {
			return counterparty2FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute("noaActionType")
		@RuneAttribute("noaActionType")
		public String getNoaActionType() {
			return noaActionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute("cdeCallAmountLeg1")
		@RuneAttribute("cdeCallAmountLeg1")
		public BigDecimal getCdeCallAmountLeg1() {
			return cdeCallAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeCallAmountLeg2")
		@RuneAttribute("cdeCallAmountLeg2")
		public BigDecimal getCdeCallAmountLeg2() {
			return cdeCallAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeCallCurrencyLeg1")
		@RuneAttribute("cdeCallCurrencyLeg1")
		public String getCdeCallCurrencyLeg1() {
			return cdeCallCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeCallCurrencyLeg2")
		@RuneAttribute("cdeCallCurrencyLeg2")
		public String getCdeCallCurrencyLeg2() {
			return cdeCallCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("cdePutAmountLeg1")
		@RuneAttribute("cdePutAmountLeg1")
		public BigDecimal getCdePutAmountLeg1() {
			return cdePutAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("cdePutAmountLeg2")
		@RuneAttribute("cdePutAmountLeg2")
		public BigDecimal getCdePutAmountLeg2() {
			return cdePutAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("cdePutCurrencyLeg1")
		@RuneAttribute("cdePutCurrencyLeg1")
		public String getCdePutCurrencyLeg1() {
			return cdePutCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("cdePutCurrencyLeg2")
		@RuneAttribute("cdePutCurrencyLeg2")
		public String getCdePutCurrencyLeg2() {
			return cdePutCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("leg2QuantityFrequency")
		@RuneAttribute("leg2QuantityFrequency")
		public String getLeg2QuantityFrequency() {
			return leg2QuantityFrequency;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg1")
		@RuneAttribute("quantityFrequencyMultiplierLeg1")
		public BigDecimal getQuantityFrequencyMultiplierLeg1() {
			return quantityFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg2")
		@RuneAttribute("quantityFrequencyMultiplierLeg2")
		public BigDecimal getQuantityFrequencyMultiplierLeg2() {
			return quantityFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeQuantityUnitOfMeasureLeg1")
		@RuneAttribute("cdeQuantityUnitOfMeasureLeg1")
		public String getCdeQuantityUnitOfMeasureLeg1() {
			return cdeQuantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeQuantityUnitOfMeasureLeg2")
		@RuneAttribute("cdeQuantityUnitOfMeasureLeg2")
		public String getCdeQuantityUnitOfMeasureLeg2() {
			return cdeQuantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("cdePackageIdentifier")
		@RuneAttribute("cdePackageIdentifier")
		public String getCdePackageIdentifier() {
			return cdePackageIdentifier;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPrice")
		@RuneAttribute("cdePackageTransactionPrice")
		public BigDecimal getCdePackageTransactionPrice() {
			return cdePackageTransactionPrice;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPriceCurrency")
		@RuneAttribute("cdePackageTransactionPriceCurrency")
		public String getCdePackageTransactionPriceCurrency() {
			return cdePackageTransactionPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPriceNotation")
		@RuneAttribute("cdePackageTransactionPriceNotation")
		public String getCdePackageTransactionPriceNotation() {
			return cdePackageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpread")
		@RuneAttribute("cdePackageTransactionSpread")
		public BigDecimal getCdePackageTransactionSpread() {
			return cdePackageTransactionSpread;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpreadCurrency")
		@RuneAttribute("cdePackageTransactionSpreadCurrency")
		public String getCdePackageTransactionSpreadCurrency() {
			return cdePackageTransactionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpreadNotation")
		@RuneAttribute("cdePackageTransactionSpreadNotation")
		public String getCdePackageTransactionSpreadNotation() {
			return cdePackageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRateDayCountConventionLeg1")
		@RuneAttribute("cdeFixedRateDayCountConventionLeg1")
		public String getCdeFixedRateDayCountConventionLeg1() {
			return cdeFixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRateDayCountConventionLeg2")
		@RuneAttribute("cdeFixedRateDayCountConventionLeg2")
		public String getCdeFixedRateDayCountConventionLeg2() {
			return cdeFixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRateDayCountConventionLeg1")
		@RuneAttribute("cdeFloatingRateDayCountConventionLeg1")
		public String getCdeFloatingRateDayCountConventionLeg1() {
			return cdeFloatingRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRateDayCountConventionLeg2")
		@RuneAttribute("cdeFloatingRateDayCountConventionLeg2")
		public String getCdeFloatingRateDayCountConventionLeg2() {
			return cdeFloatingRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		public Date getFixingDateLeg1() {
			return fixingDateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		public Date getFixingDateLeg2() {
			return fixingDateLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodLeg1")
		public String getCdeFixedRatePaymentFrequencyPeriodLeg1() {
			return cdeFixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodLeg2")
		public String getCdeFixedRatePaymentFrequencyPeriodLeg2() {
			return cdeFixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg1")
		public String getCdeFloatingRatePaymentFrequencyPeriodLeg1() {
			return cdeFloatingRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg2")
		public String getCdeFloatingRatePaymentFrequencyPeriodLeg2() {
			return cdeFloatingRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public BigDecimal getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public BigDecimal getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1")
		public BigDecimal getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
			return cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2")
		public BigDecimal getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
			return cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("postPricedSwapIndicator")
		@RuneAttribute("postPricedSwapIndicator")
		public Boolean getPostPricedSwapIndicator() {
			return postPricedSwapIndicator;
		}
		
		@Override
		@RosettaAttribute("cdePriceCurrency")
		@RuneAttribute("cdePriceCurrency")
		public String getCdePriceCurrency() {
			return cdePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("cdePriceNotation")
		@RuneAttribute("cdePriceNotation")
		public String getCdePriceNotation() {
			return cdePriceNotation;
		}
		
		@Override
		@RosettaAttribute("cdeSpreadNotationLeg1")
		@RuneAttribute("cdeSpreadNotationLeg1")
		public String getCdeSpreadNotationLeg1() {
			return cdeSpreadNotationLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeSpreadNotationLeg2")
		@RuneAttribute("cdeSpreadNotationLeg2")
		public String getCdeSpreadNotationLeg2() {
			return cdeSpreadNotationLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeStrikePriceCurrency2")
		@RuneAttribute("cdeStrikePriceCurrency2")
		public String getCdeStrikePriceCurrency2() {
			return cdeStrikePriceCurrency2;
		}
		
		@Override
		@RosettaAttribute("cdeStrikePriceNotation")
		@RuneAttribute("cdeStrikePriceNotation")
		public String getCdeStrikePriceNotation() {
			return cdeStrikePriceNotation;
		}
		
		@Override
		@RosettaAttribute("cdeFirstExerciseDate")
		@RuneAttribute("cdeFirstExerciseDate")
		public Date getCdeFirstExerciseDate() {
			return cdeFirstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("cdeFinalContractualSettlementDate")
		@RuneAttribute("cdeFinalContractualSettlementDate")
		public Date getCdeFinalContractualSettlementDate() {
			return cdeFinalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("cdeSettlementLocationLeg1")
		@RuneAttribute("cdeSettlementLocationLeg1")
		public String getCdeSettlementLocationLeg1() {
			return cdeSettlementLocationLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeSettlementLocationLeg2")
		@RuneAttribute("cdeSettlementLocationLeg2")
		public String getCdeSettlementLocationLeg2() {
			return cdeSettlementLocationLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeEffectiveDate")
		@RuneAttribute("cdeEffectiveDate")
		public Date getCdeEffectiveDate() {
			return cdeEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("cdeExpirationDate")
		@RuneAttribute("cdeExpirationDate")
		public Date getCdeExpirationDate() {
			return cdeExpirationDate;
		}
		
		@Override
		@RosettaAttribute("cdePlatformIdentifier")
		@RuneAttribute("cdePlatformIdentifier")
		public String getCdePlatformIdentifier() {
			return cdePlatformIdentifier;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public Boolean getPrimeBrokerageTransactionIndicator() {
			return primeBrokerageTransactionIndicator;
		}
		
		@Override
		@RosettaAttribute("swapReportingJurisdiction")
		@RuneAttribute("swapReportingJurisdiction")
		public String getSwapReportingJurisdiction() {
			return swapReportingJurisdiction;
		}
		
		@Override
		@RosettaAttribute("newSdrIdentifier")
		@RuneAttribute("newSdrIdentifier")
		public String getNewSdrIdentifier() {
			return newSdrIdentifier;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceValueLeg1")
		@RuneAttribute("lastFloatingReferenceValueLeg1")
		public BigDecimal getLastFloatingReferenceValueLeg1() {
			return lastFloatingReferenceValueLeg1;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceResetDateLeg1")
		@RuneAttribute("lastFloatingReferenceResetDateLeg1")
		public Date getLastFloatingReferenceResetDateLeg1() {
			return lastFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceValueLeg2")
		@RuneAttribute("lastFloatingReferenceValueLeg2")
		public BigDecimal getLastFloatingReferenceValueLeg2() {
			return lastFloatingReferenceValueLeg2;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceResetDateLeg2")
		@RuneAttribute("lastFloatingReferenceResetDateLeg2")
		public Date getLastFloatingReferenceResetDateLeg2() {
			return lastFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeDelta")
		@RuneAttribute("cdeDelta")
		public BigDecimal getCdeDelta() {
			return cdeDelta;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		@RuneAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		public Boolean getLargeNotionalOffFacilitySwapElectionIndicator() {
			return largeNotionalOffFacilitySwapElectionIndicator;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmAnonymousExecutionIndicator")
		@RuneAttribute("sefOrDcmAnonymousExecutionIndicator")
		public Boolean getSefOrDcmAnonymousExecutionIndicator() {
			return sefOrDcmAnonymousExecutionIndicator;
		}
		
		@Override
		@RosettaAttribute("blockTradeElectionIndicator")
		@RuneAttribute("blockTradeElectionIndicator")
		public Boolean getBlockTradeElectionIndicator() {
			return blockTradeElectionIndicator;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmIndicator")
		@RuneAttribute("sefOrDcmIndicator")
		public Boolean getSefOrDcmIndicator() {
			return sefOrDcmIndicator;
		}
		
		@Override
		@RosettaAttribute("mandatoryClearingIndicator")
		@RuneAttribute("mandatoryClearingIndicator")
		public Boolean getMandatoryClearingIndicator() {
			return mandatoryClearingIndicator;
		}
		
		@Override
		@RosettaAttribute("sdMspIndicatorCounterparty1")
		@RuneAttribute("sdMspIndicatorCounterparty1")
		public Boolean getSdMspIndicatorCounterparty1() {
			return sdMspIndicatorCounterparty1;
		}
		
		@Override
		@RosettaAttribute("sdMspIndicatorCounterparty2")
		@RuneAttribute("sdMspIndicatorCounterparty2")
		public Boolean getSdMspIndicatorCounterparty2() {
			return sdMspIndicatorCounterparty2;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityContractIndicator")
		@RuneAttribute("physicalCommodityContractIndicator")
		public Boolean getPhysicalCommodityContractIndicator() {
			return physicalCommodityContractIndicator;
		}
		
		@Override
		@RosettaAttribute("changeInNotionalAmount1")
		@RuneAttribute("changeInNotionalAmount1")
		public BigDecimal getChangeInNotionalAmount1() {
			return changeInNotionalAmount1;
		}
		
		@Override
		@RosettaAttribute("changeInNotionalAmount2")
		@RuneAttribute("changeInNotionalAmount2")
		public BigDecimal getChangeInNotionalAmount2() {
			return changeInNotionalAmount2;
		}
		
		@Override
		@RosettaAttribute("changeInLeg1NotionalQuantity")
		@RuneAttribute("changeInLeg1NotionalQuantity")
		public BigDecimal getChangeInLeg1NotionalQuantity() {
			return changeInLeg1NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("changeInLeg2NotionalQuantity")
		@RuneAttribute("changeInLeg2NotionalQuantity")
		public BigDecimal getChangeInLeg2NotionalQuantity() {
			return changeInLeg2NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("cdeCryptoAssetUnderlyingIndicatorLeg1")
		@RuneAttribute("cdeCryptoAssetUnderlyingIndicatorLeg1")
		public Boolean getCdeCryptoAssetUnderlyingIndicatorLeg1() {
			return cdeCryptoAssetUnderlyingIndicatorLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeCryptoAssetUnderlyingIndicatorLeg2")
		@RuneAttribute("cdeCryptoAssetUnderlyingIndicatorLeg2")
		public Boolean getCdeCryptoAssetUnderlyingIndicatorLeg2() {
			return cdeCryptoAssetUnderlyingIndicatorLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeCustomBasketCode")
		@RuneAttribute("cdeCustomBasketCode")
		public String getCdeCustomBasketCode() {
			return cdeCustomBasketCode;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherLeg1")
		@RuneAttribute("underlierIdOtherLeg1")
		public String getUnderlierIdOtherLeg1() {
			return underlierIdOtherLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherLeg2")
		@RuneAttribute("underlierIdOtherLeg2")
		public String getUnderlierIdOtherLeg2() {
			return underlierIdOtherLeg2;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherSourceLeg1")
		@RuneAttribute("underlierIdOtherSourceLeg1")
		public String getUnderlierIdOtherSourceLeg1() {
			return underlierIdOtherSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherSourceLeg2")
		@RuneAttribute("underlierIdOtherSourceLeg2")
		public String getUnderlierIdOtherSourceLeg2() {
			return underlierIdOtherSourceLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetTradingPlatformIdLeg1")
		@RuneAttribute("cdeUnderlyingAssetTradingPlatformIdLeg1")
		public String getCdeUnderlyingAssetTradingPlatformIdLeg1() {
			return cdeUnderlyingAssetTradingPlatformIdLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetTradingPlatformIdLeg2")
		@RuneAttribute("cdeUnderlyingAssetTradingPlatformIdLeg2")
		public String getCdeUnderlyingAssetTradingPlatformIdLeg2() {
			return cdeUnderlyingAssetTradingPlatformIdLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetPriceSourceLeg1")
		@RuneAttribute("cdeUnderlyingAssetPriceSourceLeg1")
		public String getCdeUnderlyingAssetPriceSourceLeg1() {
			return cdeUnderlyingAssetPriceSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetPriceSourceLeg2")
		@RuneAttribute("cdeUnderlyingAssetPriceSourceLeg2")
		public String getCdeUnderlyingAssetPriceSourceLeg2() {
			return cdeUnderlyingAssetPriceSourceLeg2;
		}
		
		@Override
		public HarmonizedData build() {
			return this;
		}
		
		@Override
		public HarmonizedData.HarmonizedDataBuilder toBuilder() {
			HarmonizedData.HarmonizedDataBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(HarmonizedData.HarmonizedDataBuilder builder) {
			ofNullable(getLeg2CommodityInstrumentId()).ifPresent(builder::setLeg2CommodityInstrumentId);
			ofNullable(getLeg2CommodityUnderlyerId()).ifPresent(builder::setLeg2CommodityUnderlyerId);
			ofNullable(getLeg2CommodityUnderlyerDetails()).ifPresent(builder::setLeg2CommodityUnderlyerDetails);
			ofNullable(getLeg2CommodityUnitOfMeasure()).ifPresent(builder::setLeg2CommodityUnitOfMeasure);
			ofNullable(getLeg2CommodityCurrency()).ifPresent(builder::setLeg2CommodityCurrency);
			ofNullable(getLeg2CommodityExchangeId()).ifPresent(builder::setLeg2CommodityExchangeId);
			ofNullable(getLeg1CommodityRateSource()).ifPresent(builder::setLeg1CommodityRateSource);
			ofNullable(getLeg1CommodityRateSourcePage()).ifPresent(builder::setLeg1CommodityRateSourcePage);
			ofNullable(getLeg2SpecifiedPrice()).ifPresent(builder::setLeg2SpecifiedPrice);
			ofNullable(getCommencementDateUnadjusted()).ifPresent(builder::setCommencementDateUnadjusted);
			ofNullable(getExerciseExpirationDateUnadjusted()).ifPresent(builder::setExerciseExpirationDateUnadjusted);
			ofNullable(getExpirationDateUnadjusted()).ifPresent(builder::setExpirationDateUnadjusted);
			ofNullable(getLeg2NotionalQuantityFrequency()).ifPresent(builder::setLeg2NotionalQuantityFrequency);
			ofNullable(getLeg2NotionalQuantity()).ifPresent(builder::setLeg2NotionalQuantity);
			ofNullable(getLeg2TotalNotionalQuantity()).ifPresent(builder::setLeg2TotalNotionalQuantity);
			ofNullable(getLeg2SpreadAmount()).ifPresent(builder::setLeg2SpreadAmount);
			ofNullable(getLeg2SpreadCurrency()).ifPresent(builder::setLeg2SpreadCurrency);
			ofNullable(getScheduledTerminationDateAdjusted()).ifPresent(builder::setScheduledTerminationDateAdjusted);
			ofNullable(getLeg1PartyPayer()).ifPresent(builder::setLeg1PartyPayer);
			ofNullable(getLeg2PartyPayer()).ifPresent(builder::setLeg2PartyPayer);
			ofNullable(getLeg1CommodityInstrumentId()).ifPresent(builder::setLeg1CommodityInstrumentId);
			ofNullable(getLeg1CommodityUnderlyerId()).ifPresent(builder::setLeg1CommodityUnderlyerId);
			ofNullable(getLeg1CommodityUnitOfMeasure()).ifPresent(builder::setLeg1CommodityUnitOfMeasure);
			ofNullable(getLeg1CommodityExchangeId()).ifPresent(builder::setLeg1CommodityExchangeId);
			ofNullable(getLeg2CommodityRateSource()).ifPresent(builder::setLeg2CommodityRateSource);
			ofNullable(getLeg1EffectiveDateUnadjusted()).ifPresent(builder::setLeg1EffectiveDateUnadjusted);
			ofNullable(getLeg2EffectiveDateUnadjusted()).ifPresent(builder::setLeg2EffectiveDateUnadjusted);
			ofNullable(getCoProductType()).ifPresent(builder::setCoProductType);
			ofNullable(getTotalQuantityUnit()).ifPresent(builder::setTotalQuantityUnit);
			ofNullable(getTotalQuantity()).ifPresent(builder::setTotalQuantity);
			ofNullable(getFixedPrice()).ifPresent(builder::setFixedPrice);
			ofNullable(getFixedPriceCurrency()).ifPresent(builder::setFixedPriceCurrency);
			ofNullable(getLeg1NotionalQuantityUnit()).ifPresent(builder::setLeg1NotionalQuantityUnit);
			ofNullable(getLeg1NotionalQuantityFrequency()).ifPresent(builder::setLeg1NotionalQuantityFrequency);
			ofNullable(getLeg1NotionalQuantity()).ifPresent(builder::setLeg1NotionalQuantity);
			ofNullable(getLeg1TotalNotionalQuantity()).ifPresent(builder::setLeg1TotalNotionalQuantity);
			ofNullable(getLeg1CommodityCurrency()).ifPresent(builder::setLeg1CommodityCurrency);
			ofNullable(getLeg1SpecifiedPrice()).ifPresent(builder::setLeg1SpecifiedPrice);
			ofNullable(getLeg1SpreadCurrency()).ifPresent(builder::setLeg1SpreadCurrency);
			ofNullable(getLeg1SpreadAmount()).ifPresent(builder::setLeg1SpreadAmount);
			ofNullable(getLeg2NotionalQuantityUnit()).ifPresent(builder::setLeg2NotionalQuantityUnit);
			ofNullable(getLeg2PartyReceiver()).ifPresent(builder::setLeg2PartyReceiver);
			ofNullable(getLeg1PartyReceiver()).ifPresent(builder::setLeg1PartyReceiver);
			ofNullable(getCoalSource()).ifPresent(builder::setCoalSource);
			ofNullable(getLeg2Quantity()).ifPresent(builder::setLeg2Quantity);
			ofNullable(getCommodityBase()).ifPresent(builder::setCommodityBase);
			ofNullable(getCommodityDetails()).ifPresent(builder::setCommodityDetails);
			ofNullable(getInterconnectionPoint()).ifPresent(builder::setInterconnectionPoint);
			ofNullable(getLoadType()).ifPresent(builder::setLoadType);
			ofNullable(getFixedPriceUnit()).ifPresent(builder::setFixedPriceUnit);
			ofNullable(getExercisePaymentDateUnadjusted()).ifPresent(builder::setExercisePaymentDateUnadjusted);
			ofNullable(getLeg1PaymentDatesUnadjusted()).ifPresent(builder::setLeg1PaymentDatesUnadjusted);
			ofNullable(getLeg2PaymentDateUnadjusted()).ifPresent(builder::setLeg2PaymentDateUnadjusted);
			ofNullable(getSettlementDateUnadjusted()).ifPresent(builder::setSettlementDateUnadjusted);
			ofNullable(getDeliveryLocation()).ifPresent(builder::setDeliveryLocation);
			ofNullable(getLeg2QuantityUnit()).ifPresent(builder::setLeg2QuantityUnit);
			ofNullable(getLeg1CommodityUnderlyerDetails()).ifPresent(builder::setLeg1CommodityUnderlyerDetails);
			ofNullable(getLeg2CommodityRateSourcePage()).ifPresent(builder::setLeg2CommodityRateSourcePage);
			ofNullable(getValueDate()).ifPresent(builder::setValueDate);
			ofNullable(getGtrQuantityUnit()).ifPresent(builder::setGtrQuantityUnit);
			ofNullable(getAttachmentPoint()).ifPresent(builder::setAttachmentPoint);
			ofNullable(getExhaustionPoint()).ifPresent(builder::setExhaustionPoint);
			ofNullable(getMthToDefault()).ifPresent(builder::setMthToDefault);
			ofNullable(getNthToDefault()).ifPresent(builder::setNthToDefault);
			ofNullable(getSeniority()).ifPresent(builder::setSeniority);
			ofNullable(getSeries()).ifPresent(builder::setSeries);
			ofNullable(getCrversion()).ifPresent(builder::setCrversion);
			ofNullable(getTranche()).ifPresent(builder::setTranche);
			ofNullable(getIndexFactor()).ifPresent(builder::setIndexFactor);
			ofNullable(getReferenceObligation()).ifPresent(builder::setReferenceObligation);
			ofNullable(getReferenceObligationIdType()).ifPresent(builder::setReferenceObligationIdType);
			ofNullable(getUnderlyingFixedRatePayerBuyer()).ifPresent(builder::setUnderlyingFixedRatePayerBuyer);
			ofNullable(getUnderlyingFloatRatePayerSeller()).ifPresent(builder::setUnderlyingFloatRatePayerSeller);
			ofNullable(getUnderlyingAssetExchangeId()).ifPresent(builder::setUnderlyingAssetExchangeId);
			ofNullable(getUnderlyingAssetNumberOfUnits()).ifPresent(builder::setUnderlyingAssetNumberOfUnits);
			ofNullable(getOptionalEarlyTerminationType()).ifPresent(builder::setOptionalEarlyTerminationType);
			ofNullable(getOptionalEarlyTerminationElectingPartyValue()).ifPresent(builder::setOptionalEarlyTerminationElectingPartyValue);
			ofNullable(getOptionalEarlyTerminationIndicator()).ifPresent(builder::setOptionalEarlyTerminationIndicator);
			ofNullable(getUnderlyingAssetFloatingAmountPayer()).ifPresent(builder::setUnderlyingAssetFloatingAmountPayer);
			ofNullable(getUnderlyingAssetFloatingAmountReceiver()).ifPresent(builder::setUnderlyingAssetFloatingAmountReceiver);
			ofNullable(getFloatingRateOption()).ifPresent(builder::setFloatingRateOption);
			ofNullable(getUnderlyingAssetFloatingLegSpread()).ifPresent(builder::setUnderlyingAssetFloatingLegSpread);
			ofNullable(getLeg2DesignatedMaturityPeriod()).ifPresent(builder::setLeg2DesignatedMaturityPeriod);
			ofNullable(getLeg2DesignatedMaturityPeriodMultiplier()).ifPresent(builder::setLeg2DesignatedMaturityPeriodMultiplier);
			ofNullable(getUnderlyingAssetEquityAmountPayer()).ifPresent(builder::setUnderlyingAssetEquityAmountPayer);
			ofNullable(getUnderlyingAssetEquityAmountReceiver()).ifPresent(builder::setUnderlyingAssetEquityAmountReceiver);
			ofNullable(getUnderlyingAssetInitialPriceCurrency()).ifPresent(builder::setUnderlyingAssetInitialPriceCurrency);
			ofNullable(getLeg1ValuationDates()).ifPresent(builder::setLeg1ValuationDates);
			ofNullable(getLeg1TypeOfReturn()).ifPresent(builder::setLeg1TypeOfReturn);
			ofNullable(getObservationStartDate()).ifPresent(builder::setObservationStartDate);
			ofNullable(getVarianceAmount()).ifPresent(builder::setVarianceAmount);
			ofNullable(getVolatilityStrikePrice()).ifPresent(builder::setVolatilityStrikePrice);
			ofNullable(getVarianceStrikePrice()).ifPresent(builder::setVarianceStrikePrice);
			ofNullable(getVarianceCapFactor()).ifPresent(builder::setVarianceCapFactor);
			ofNullable(getReferenceCurrency()).ifPresent(builder::setReferenceCurrency);
			ofNullable(getSpecialDividendsIndicator()).ifPresent(builder::setSpecialDividendsIndicator);
			ofNullable(getMaterialNoncashDividendIndicator()).ifPresent(builder::setMaterialNoncashDividendIndicator);
			ofNullable(getNumberOfSharesUnits()).ifPresent(builder::setNumberOfSharesUnits);
			ofNullable(getDividendAmountPayer()).ifPresent(builder::setDividendAmountPayer);
			ofNullable(getDividendAmountReceiver()).ifPresent(builder::setDividendAmountReceiver);
			ofNullable(getFixedAmountPayer()).ifPresent(builder::setFixedAmountPayer);
			ofNullable(getFixedAmountReceiver()).ifPresent(builder::setFixedAmountReceiver);
			ofNullable(getKnockInEvent()).ifPresent(builder::setKnockInEvent);
			ofNullable(getKnockOutEvent()).ifPresent(builder::setKnockOutEvent);
			ofNullable(getKnockInPrice()).ifPresent(builder::setKnockInPrice);
			ofNullable(getKnockOutPrice()).ifPresent(builder::setKnockOutPrice);
			ofNullable(getBarrierType()).ifPresent(builder::setBarrierType);
			ofNullable(getEarliestExecutionTime()).ifPresent(builder::setEarliestExecutionTime);
			ofNullable(getExchangeRate()).ifPresent(builder::setExchangeRate);
			ofNullable(getExchangeRateBasisCurrency1()).ifPresent(builder::setExchangeRateBasisCurrency1);
			ofNullable(getExchangeRateBasisCurrency2()).ifPresent(builder::setExchangeRateBasisCurrency2);
			ofNullable(getExecutionPeriodStartDate()).ifPresent(builder::setExecutionPeriodStartDate);
			ofNullable(getPayoutStyle()).ifPresent(builder::setPayoutStyle);
			ofNullable(getRateQuoteBasis1()).ifPresent(builder::setRateQuoteBasis1);
			ofNullable(getSettlementFixingDate()).ifPresent(builder::setSettlementFixingDate);
			ofNullable(getSwapLinkId()).ifPresent(builder::setSwapLinkId);
			ofNullable(getTriggerCondition()).ifPresent(builder::setTriggerCondition);
			ofNullable(getTriggerCondition2()).ifPresent(builder::setTriggerCondition2);
			ofNullable(getTriggerRate()).ifPresent(builder::setTriggerRate);
			ofNullable(getTriggerRate2()).ifPresent(builder::setTriggerRate2);
			ofNullable(getRateQuoteBasis2()).ifPresent(builder::setRateQuoteBasis2);
			ofNullable(getForwardExchangeRate()).ifPresent(builder::setForwardExchangeRate);
			ofNullable(getBarrierType2()).ifPresent(builder::setBarrierType2);
			ofNullable(getCancelationOptionBuyer()).ifPresent(builder::setCancelationOptionBuyer);
			ofNullable(getCancelationOptionCommencementDate()).ifPresent(builder::setCancelationOptionCommencementDate);
			ofNullable(getCancelationOptionExerciseStyleType()).ifPresent(builder::setCancelationOptionExerciseStyleType);
			ofNullable(getCancelationOptionExpirationDate()).ifPresent(builder::setCancelationOptionExpirationDate);
			ofNullable(getCancelationOptionInitialFeeCurrency()).ifPresent(builder::setCancelationOptionInitialFeeCurrency);
			ofNullable(getCancelationOptionInitialFeePayer()).ifPresent(builder::setCancelationOptionInitialFeePayer);
			ofNullable(getCancelationOptionPremiumAmount()).ifPresent(builder::setCancelationOptionPremiumAmount);
			ofNullable(getCancelationOptionSeller()).ifPresent(builder::setCancelationOptionSeller);
			ofNullable(getCapRateInitial()).ifPresent(builder::setCapRateInitial);
			ofNullable(getCouponType()).ifPresent(builder::setCouponType);
			ofNullable(getFinalPrincipalExchangeIndicatorAtTermination()).ifPresent(builder::setFinalPrincipalExchangeIndicatorAtTermination);
			ofNullable(getFloorRateInitial()).ifPresent(builder::setFloorRateInitial);
			ofNullable(getFraDiscountingType()).ifPresent(builder::setFraDiscountingType);
			ofNullable(getInflationIndexInitialLevel()).ifPresent(builder::setInflationIndexInitialLevel);
			ofNullable(getInflationIndexMainPublication()).ifPresent(builder::setInflationIndexMainPublication);
			ofNullable(getInflationInterpolationMethod()).ifPresent(builder::setInflationInterpolationMethod);
			ofNullable(getInflationLagDayType()).ifPresent(builder::setInflationLagDayType);
			ofNullable(getInflationLagPeriod()).ifPresent(builder::setInflationLagPeriod);
			ofNullable(getInflationRateSourceName()).ifPresent(builder::setInflationRateSourceName);
			ofNullable(getInitialPrincipalExchangeIndicator()).ifPresent(builder::setInitialPrincipalExchangeIndicator);
			ofNullable(getIntermediatePrincipalExchangeIndicator()).ifPresent(builder::setIntermediatePrincipalExchangeIndicator);
			ofNullable(getLeg1FloatingRateIndex()).ifPresent(builder::setLeg1FloatingRateIndex);
			ofNullable(getLeg1FloatingRateInitialSpread()).ifPresent(builder::setLeg1FloatingRateInitialSpread);
			ofNullable(getLeg1FloatingRateMultiplierInitialValue()).ifPresent(builder::setLeg1FloatingRateMultiplierInitialValue);
			ofNullable(getLeg1FloatingRateTenorPeriod()).ifPresent(builder::setLeg1FloatingRateTenorPeriod);
			ofNullable(getLeg1FloatingRateTenorPeriodMultiplier()).ifPresent(builder::setLeg1FloatingRateTenorPeriodMultiplier);
			ofNullable(getLeg1KnownAmount()).ifPresent(builder::setLeg1KnownAmount);
			ofNullable(getLeg1KnownAmountCurrency()).ifPresent(builder::setLeg1KnownAmountCurrency);
			ofNullable(getLeg1ReferenceCurrency()).ifPresent(builder::setLeg1ReferenceCurrency);
			ofNullable(getLeg2FloatingRateIndex()).ifPresent(builder::setLeg2FloatingRateIndex);
			ofNullable(getLeg2FloatingRateInitialSpread()).ifPresent(builder::setLeg2FloatingRateInitialSpread);
			ofNullable(getLeg2FloatingRateMultiplierInitialValue()).ifPresent(builder::setLeg2FloatingRateMultiplierInitialValue);
			ofNullable(getLeg2FloatingRateTenorPeriod()).ifPresent(builder::setLeg2FloatingRateTenorPeriod);
			ofNullable(getLeg2FloatingRateTenorPeriodMultiplier()).ifPresent(builder::setLeg2FloatingRateTenorPeriodMultiplier);
			ofNullable(getLeg2KnownAmount()).ifPresent(builder::setLeg2KnownAmount);
			ofNullable(getLeg2KnownAmountCurrency()).ifPresent(builder::setLeg2KnownAmountCurrency);
			ofNullable(getLeg2ReferenceCurrency()).ifPresent(builder::setLeg2ReferenceCurrency);
			ofNullable(getMandatoryEarlyTerminationDate()).ifPresent(builder::setMandatoryEarlyTerminationDate);
			ofNullable(getMandatoryEarlyTerminationDateTenorPeriod()).ifPresent(builder::setMandatoryEarlyTerminationDateTenorPeriod);
			ofNullable(getMandatoryEarlyTerminationDateTenorPeriodMultiplier()).ifPresent(builder::setMandatoryEarlyTerminationDateTenorPeriodMultiplier);
			ofNullable(getNotionalUnits()).ifPresent(builder::setNotionalUnits);
			ofNullable(getOptionalEarlyTerminationCommencementDate()).ifPresent(builder::setOptionalEarlyTerminationCommencementDate);
			ofNullable(getOptionalEarlyTerminationExerciseStyle()).ifPresent(builder::setOptionalEarlyTerminationExerciseStyle);
			ofNullable(getOptionalEarlyTerminationExpirationDate()).ifPresent(builder::setOptionalEarlyTerminationExpirationDate);
			ofNullable(getPremiumReceiver()).ifPresent(builder::setPremiumReceiver);
			ofNullable(getUnderlyingCouponRate()).ifPresent(builder::setUnderlyingCouponRate);
			ofNullable(getUnderlyingMaturityDate()).ifPresent(builder::setUnderlyingMaturityDate);
			ofNullable(getUnderlyingProductId()).ifPresent(builder::setUnderlyingProductId);
			ofNullable(getInflationLagPeriodMultiplier()).ifPresent(builder::setInflationLagPeriodMultiplier);
			ofNullable(getLeg1FixedRateNotation()).ifPresent(builder::setLeg1FixedRateNotation);
			ofNullable(getLeg2FixedRateNotation()).ifPresent(builder::setLeg2FixedRateNotation);
			ofNullable(getSwaptionStraddleIndicator()).ifPresent(builder::setSwaptionStraddleIndicator);
			ofNullable(getSinglePartyEarlyTerminationBuyer()).ifPresent(builder::setSinglePartyEarlyTerminationBuyer);
			ofNullable(getLeg1EffectiveDate()).ifPresent(builder::setLeg1EffectiveDate);
			ofNullable(getAction()).ifPresent(builder::setAction);
			ofNullable(getClearingStatus()).ifPresent(builder::setClearingStatus);
			ofNullable(getEffectiveDate1()).ifPresent(builder::setEffectiveDate1);
			ofNullable(getExecutionVenueType()).ifPresent(builder::setExecutionVenueType);
			ofNullable(getNonStandardTradeIndicator()).ifPresent(builder::setNonStandardTradeIndicator);
			ofNullable(getNotionalAmount1()).ifPresent(builder::setNotionalAmount1);
			ofNullable(getNotionalCurrency1()).ifPresent(builder::setNotionalCurrency1);
			ofNullable(getPrice1Price()).ifPresent(builder::setPrice1Price);
			ofNullable(getPrice1Type()).ifPresent(builder::setPrice1Type);
			ofNullable(getPrice1Units()).ifPresent(builder::setPrice1Units);
			ofNullable(getScheduledTerminationDate1()).ifPresent(builder::setScheduledTerminationDate1);
			ofNullable(getTradeDate()).ifPresent(builder::setTradeDate);
			ofNullable(getTradeParty1CollateralizationType()).ifPresent(builder::setTradeParty1CollateralizationType);
			ofNullable(getTradeParty1EventId()).ifPresent(builder::setTradeParty1EventId);
			ofNullable(getTradeParty2CollateralizationType()).ifPresent(builder::setTradeParty2CollateralizationType);
			ofNullable(getTradeParty2EventId()).ifPresent(builder::setTradeParty2EventId);
			ofNullable(getEmbeddedOptionOnSwap()).ifPresent(builder::setEmbeddedOptionOnSwap);
			ofNullable(getExpirationDate()).ifPresent(builder::setExpirationDate);
			ofNullable(getNotionalAmount2()).ifPresent(builder::setNotionalAmount2);
			ofNullable(getNotionalCurrency2()).ifPresent(builder::setNotionalCurrency2);
			ofNullable(getPremiumAmount()).ifPresent(builder::setPremiumAmount);
			ofNullable(getPremiumCurrency()).ifPresent(builder::setPremiumCurrency);
			ofNullable(getVersion()).ifPresent(builder::setVersion);
			ofNullable(getComment1()).ifPresent(builder::setComment1);
			ofNullable(getOptionStyle()).ifPresent(builder::setOptionStyle);
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getSettlementCurrency1()).ifPresent(builder::setSettlementCurrency1);
			ofNullable(getCommencementDate()).ifPresent(builder::setCommencementDate);
			ofNullable(getDayCountFraction1()).ifPresent(builder::setDayCountFraction1);
			ofNullable(getLeg2DayCountFraction()).ifPresent(builder::setLeg2DayCountFraction);
			ofNullable(getLeg2EffectiveDate()).ifPresent(builder::setLeg2EffectiveDate);
			ofNullable(getLeg2ResetFrequencyPeriod()).ifPresent(builder::setLeg2ResetFrequencyPeriod);
			ofNullable(getLeg2ResetFrequencyPeriodMultiplier()).ifPresent(builder::setLeg2ResetFrequencyPeriodMultiplier);
			ofNullable(getLeg2SettlementCurrency()).ifPresent(builder::setLeg2SettlementCurrency);
			ofNullable(getLeg2ScheduledTerminationDate()).ifPresent(builder::setLeg2ScheduledTerminationDate);
			ofNullable(getNumberOfOptions()).ifPresent(builder::setNumberOfOptions);
			ofNullable(getOptionEntitlement()).ifPresent(builder::setOptionEntitlement);
			ofNullable(getOriginalExecutionTimestamp()).ifPresent(builder::setOriginalExecutionTimestamp);
			ofNullable(getPayment1Date()).ifPresent(builder::setPayment1Date);
			ofNullable(getPayment1FrequencyPeriod()).ifPresent(builder::setPayment1FrequencyPeriod);
			ofNullable(getPayment1FrequencyPeriodMultiplier()).ifPresent(builder::setPayment1FrequencyPeriodMultiplier);
			ofNullable(getPayment2Date()).ifPresent(builder::setPayment2Date);
			ofNullable(getPayment2FrequencyPeriod()).ifPresent(builder::setPayment2FrequencyPeriod);
			ofNullable(getPayment2FrequencyPeriodMultiplier()).ifPresent(builder::setPayment2FrequencyPeriodMultiplier);
			ofNullable(getResetFrequencyPeriod1()).ifPresent(builder::setResetFrequencyPeriod1);
			ofNullable(getResetFrequencyPeriodMultiplier1()).ifPresent(builder::setResetFrequencyPeriodMultiplier1);
			ofNullable(getSettlementDate()).ifPresent(builder::setSettlementDate);
			ofNullable(getStrikePrice()).ifPresent(builder::setStrikePrice);
			ofNullable(getStrikePriceUnits()).ifPresent(builder::setStrikePriceUnits);
			ofNullable(getAsOfDateTime()).ifPresent(builder::setAsOfDateTime);
			ofNullable(getClearingVenueId()).ifPresent(builder::setClearingVenueId);
			ofNullable(getClearingVenueIdType()).ifPresent(builder::setClearingVenueIdType);
			ofNullable(getCompressedTradeIndicator()).ifPresent(builder::setCompressedTradeIndicator);
			ofNullable(getConfirmationMethod()).ifPresent(builder::setConfirmationMethod);
			ofNullable(getConfirmationPlatformId()).ifPresent(builder::setConfirmationPlatformId);
			ofNullable(getConfirmationPlatformTradeId()).ifPresent(builder::setConfirmationPlatformTradeId);
			ofNullable(getExecutionVenueId()).ifPresent(builder::setExecutionVenueId);
			ofNullable(getExecutionVenueIdType()).ifPresent(builder::setExecutionVenueIdType);
			ofNullable(getPostTradeEffectiveDate()).ifPresent(builder::setPostTradeEffectiveDate);
			ofNullable(getPriorUsiId()).ifPresent(builder::setPriorUsiId);
			ofNullable(getPriorUsiIdPrefix()).ifPresent(builder::setPriorUsiIdPrefix);
			ofNullable(getPriorUtiId()).ifPresent(builder::setPriorUtiId);
			ofNullable(getPriorUtiIdPrefix()).ifPresent(builder::setPriorUtiIdPrefix);
			ofNullable(getTradeParty1BranchLocation()).ifPresent(builder::setTradeParty1BranchLocation);
			ofNullable(getTradeParty1ClearingBrokerId()).ifPresent(builder::setTradeParty1ClearingBrokerId);
			ofNullable(getTradeParty1ClearingBrokerIdType()).ifPresent(builder::setTradeParty1ClearingBrokerIdType);
			ofNullable(getTradeParty1DeskLocation()).ifPresent(builder::setTradeParty1DeskLocation);
			ofNullable(getTradeParty1Domicile()).ifPresent(builder::setTradeParty1Domicile);
			ofNullable(getTradeParty1IndustrialSectorType()).ifPresent(builder::setTradeParty1IndustrialSectorType);
			ofNullable(getTradeParty2BranchLocation()).ifPresent(builder::setTradeParty2BranchLocation);
			ofNullable(getTradeParty2DeskLocation()).ifPresent(builder::setTradeParty2DeskLocation);
			ofNullable(getTradeParty2Domicile()).ifPresent(builder::setTradeParty2Domicile);
			ofNullable(getTradeParty2IndustrialSectorType()).ifPresent(builder::setTradeParty2IndustrialSectorType);
			ofNullable(getSellerPayer2()).ifPresent(builder::setSellerPayer2);
			ofNullable(getBuyerPayer1()).ifPresent(builder::setBuyerPayer1);
			ofNullable(getTradeParty1HkCounterpartyOrigin()).ifPresent(builder::setTradeParty1HkCounterpartyOrigin);
			ofNullable(getLeg2SettlementDate()).ifPresent(builder::setLeg2SettlementDate);
			ofNullable(getLeg1FixedRateInitial()).ifPresent(builder::setLeg1FixedRateInitial);
			ofNullable(getLeg2FixedRateInitial()).ifPresent(builder::setLeg2FixedRateInitial);
			ofNullable(getPayment1Amount()).ifPresent(builder::setPayment1Amount);
			ofNullable(getPayment1Currency()).ifPresent(builder::setPayment1Currency);
			ofNullable(getPayment1Payer()).ifPresent(builder::setPayment1Payer);
			ofNullable(getPayment1Receiver()).ifPresent(builder::setPayment1Receiver);
			ofNullable(getPayment2Payer()).ifPresent(builder::setPayment2Payer);
			ofNullable(getPostTradeTransactionDate()).ifPresent(builder::setPostTradeTransactionDate);
			ofNullable(getSecondaryAssetClass()).ifPresent(builder::setSecondaryAssetClass);
			ofNullable(getSettlementType()).ifPresent(builder::setSettlementType);
			ofNullable(getTradeParty1Name()).ifPresent(builder::setTradeParty1Name);
			ofNullable(getTradeParty2Name()).ifPresent(builder::setTradeParty2Name);
			ofNullable(getCcpValuationAmount()).ifPresent(builder::setCcpValuationAmount);
			ofNullable(getCcpValuationCurrency()).ifPresent(builder::setCcpValuationCurrency);
			ofNullable(getCcpValuationDatetime()).ifPresent(builder::setCcpValuationDatetime);
			ofNullable(getCcpValuationType()).ifPresent(builder::setCcpValuationType);
			ofNullable(getTradeParty1ValuationAmount()).ifPresent(builder::setTradeParty1ValuationAmount);
			ofNullable(getTradeParty1ValuationCurrency()).ifPresent(builder::setTradeParty1ValuationCurrency);
			ofNullable(getTradeParty1ValuationDatetime()).ifPresent(builder::setTradeParty1ValuationDatetime);
			ofNullable(getTradeParty1ValuationType()).ifPresent(builder::setTradeParty1ValuationType);
			ofNullable(getTradeParty2ValuationAmount()).ifPresent(builder::setTradeParty2ValuationAmount);
			ofNullable(getTradeParty2ValuationCurrency()).ifPresent(builder::setTradeParty2ValuationCurrency);
			ofNullable(getTradeParty2ValuationDatetime()).ifPresent(builder::setTradeParty2ValuationDatetime);
			ofNullable(getTradeParty2ValuationType()).ifPresent(builder::setTradeParty2ValuationType);
			ofNullable(getExecutionType()).ifPresent(builder::setExecutionType);
			ofNullable(getStrikePriceCurrency()).ifPresent(builder::setStrikePriceCurrency);
			ofNullable(getPayment2Amount()).ifPresent(builder::setPayment2Amount);
			ofNullable(getTradeParty2HkCounterpartyOrigin()).ifPresent(builder::setTradeParty2HkCounterpartyOrigin);
			ofNullable(getTradeParty1CountryOfTheOtherCounterparty()).ifPresent(builder::setTradeParty1CountryOfTheOtherCounterparty);
			ofNullable(getTradeParty2CountryOfTheOtherCounterparty()).ifPresent(builder::setTradeParty2CountryOfTheOtherCounterparty);
			ofNullable(getTradeParty1BrokerId()).ifPresent(builder::setTradeParty1BrokerId);
			ofNullable(getTradeParty2BrokerId()).ifPresent(builder::setTradeParty2BrokerId);
			ofNullable(getTradeParty1BeneficiaryIdType()).ifPresent(builder::setTradeParty1BeneficiaryIdType);
			ofNullable(getTradeParty1BeneficiaryId()).ifPresent(builder::setTradeParty1BeneficiaryId);
			ofNullable(getTradeParty2BeneficiaryIdType()).ifPresent(builder::setTradeParty2BeneficiaryIdType);
			ofNullable(getTradeParty2BeneficiaryId()).ifPresent(builder::setTradeParty2BeneficiaryId);
			ofNullable(getTradeParty1CounterpartySide()).ifPresent(builder::setTradeParty1CounterpartySide);
			ofNullable(getTradeParty2CounterpartySide()).ifPresent(builder::setTradeParty2CounterpartySide);
			ofNullable(getTradeParty1CollateralPortfolioCode()).ifPresent(builder::setTradeParty1CollateralPortfolioCode);
			ofNullable(getTradeParty2CollateralPortfolioCode()).ifPresent(builder::setTradeParty2CollateralPortfolioCode);
			ofNullable(getContractType()).ifPresent(builder::setContractType);
			ofNullable(getEuUnderlyingAssetIdType()).ifPresent(builder::setEuUnderlyingAssetIdType);
			ofNullable(getProductClassification()).ifPresent(builder::setProductClassification);
			ofNullable(getComplexTradeComponentId()).ifPresent(builder::setComplexTradeComponentId);
			ofNullable(getPriceMultiplier()).ifPresent(builder::setPriceMultiplier);
			ofNullable(getQuantity()).ifPresent(builder::setQuantity);
			ofNullable(getMasterAgreementType()).ifPresent(builder::setMasterAgreementType);
			ofNullable(getMasterAgreementVersion()).ifPresent(builder::setMasterAgreementVersion);
			ofNullable(getConfirmationDatetime()).ifPresent(builder::setConfirmationDatetime);
			ofNullable(getClearingDatetime()).ifPresent(builder::setClearingDatetime);
			ofNullable(getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
			ofNullable(getLevel()).ifPresent(builder::setLevel);
			ofNullable(getProductClassificationType()).ifPresent(builder::setProductClassificationType);
			ofNullable(getProductIdentificationType()).ifPresent(builder::setProductIdentificationType);
			ofNullable(getProductIdentification()).ifPresent(builder::setProductIdentification);
			ofNullable(getEuUnderlyingAssetId()).ifPresent(builder::setEuUnderlyingAssetId);
			ofNullable(getReportTrackingNumber()).ifPresent(builder::setReportTrackingNumber);
			ofNullable(getTradeParty1BrokerIdType()).ifPresent(builder::setTradeParty1BrokerIdType);
			ofNullable(getTradeParty2BrokerIdType()).ifPresent(builder::setTradeParty2BrokerIdType);
			ofNullable(getTradeParty2ClearingBrokerIdType()).ifPresent(builder::setTradeParty2ClearingBrokerIdType);
			ofNullable(getTradeParty2ClearingBrokerId()).ifPresent(builder::setTradeParty2ClearingBrokerId);
			ofNullable(getTradeParty1ClearingThreshold()).ifPresent(builder::setTradeParty1ClearingThreshold);
			ofNullable(getTradeParty2ClearingThreshold()).ifPresent(builder::setTradeParty2ClearingThreshold);
			ofNullable(getTradeParty1CorporateSectorType()).ifPresent(builder::setTradeParty1CorporateSectorType);
			ofNullable(getTradeParty2CorporateSectorType()).ifPresent(builder::setTradeParty2CorporateSectorType);
			ofNullable(getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator()).ifPresent(builder::setTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator);
			ofNullable(getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator()).ifPresent(builder::setTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator);
			ofNullable(getIntragroupIndicator()).ifPresent(builder::setIntragroupIndicator);
			ofNullable(getTradeParty1TradingCapacity1()).ifPresent(builder::setTradeParty1TradingCapacity1);
			ofNullable(getTradeParty2TradingCapacity1()).ifPresent(builder::setTradeParty2TradingCapacity1);
			ofNullable(getCurrencyOfPrice()).ifPresent(builder::setCurrencyOfPrice);
			ofNullable(getTradeParty1CollateralPortfolio()).ifPresent(builder::setTradeParty1CollateralPortfolio);
			ofNullable(getTradeParty2CollateralPortfolio()).ifPresent(builder::setTradeParty2CollateralPortfolio);
			ofNullable(getExecutionVenueMicCode()).ifPresent(builder::setExecutionVenueMicCode);
			ofNullable(getPayment2Currency()).ifPresent(builder::setPayment2Currency);
			ofNullable(getExpirationDateTimeBusinessCenter()).ifPresent(builder::setExpirationDateTimeBusinessCenter);
			ofNullable(getExpirationTime()).ifPresent(builder::setExpirationTime);
			ofNullable(getExpirationTimeType()).ifPresent(builder::setExpirationTimeType);
			ofNullable(getTradeParty1TraderLocation()).ifPresent(builder::setTradeParty1TraderLocation);
			ofNullable(getTradeParty2TraderLocation()).ifPresent(builder::setTradeParty2TraderLocation);
			ofNullable(getPayment3ResetFrequencyPeriodMultiplier()).ifPresent(builder::setPayment3ResetFrequencyPeriodMultiplier);
			ofNullable(getPayment3ResetFrequencyPeriod()).ifPresent(builder::setPayment3ResetFrequencyPeriod);
			ofNullable(getPayment4ResetFrequencyPeriodMultiplier()).ifPresent(builder::setPayment4ResetFrequencyPeriodMultiplier);
			ofNullable(getPayment4ResetFrequencyPeriod()).ifPresent(builder::setPayment4ResetFrequencyPeriod);
			ofNullable(getPayment5ResetFrequencyPeriodMultiplier()).ifPresent(builder::setPayment5ResetFrequencyPeriodMultiplier);
			ofNullable(getPayment5ResetFrequencyPeriod()).ifPresent(builder::setPayment5ResetFrequencyPeriod);
			ofNullable(getPayment1Type()).ifPresent(builder::setPayment1Type);
			ofNullable(getPayment1Reference()).ifPresent(builder::setPayment1Reference);
			ofNullable(getPayment2Type()).ifPresent(builder::setPayment2Type);
			ofNullable(getPayment2Reference()).ifPresent(builder::setPayment2Reference);
			ofNullable(getPayment3Payer()).ifPresent(builder::setPayment3Payer);
			ofNullable(getPayment3Reference()).ifPresent(builder::setPayment3Reference);
			ofNullable(getPayment3FrequencyPeriod()).ifPresent(builder::setPayment3FrequencyPeriod);
			ofNullable(getPayment3FrequencyPeriodMultiplier()).ifPresent(builder::setPayment3FrequencyPeriodMultiplier);
			ofNullable(getPayment3Date()).ifPresent(builder::setPayment3Date);
			ofNullable(getPayment4Reference()).ifPresent(builder::setPayment4Reference);
			ofNullable(getPayment4Payer()).ifPresent(builder::setPayment4Payer);
			ofNullable(getPayment4FrequencyPeriod()).ifPresent(builder::setPayment4FrequencyPeriod);
			ofNullable(getPayment4FrequencyPeriodMultiplier()).ifPresent(builder::setPayment4FrequencyPeriodMultiplier);
			ofNullable(getPayment4Date()).ifPresent(builder::setPayment4Date);
			ofNullable(getPayment5Reference()).ifPresent(builder::setPayment5Reference);
			ofNullable(getPayment5Payer()).ifPresent(builder::setPayment5Payer);
			ofNullable(getPayment5FrequencyPeriod()).ifPresent(builder::setPayment5FrequencyPeriod);
			ofNullable(getPayment5FrequencyPeriodMultiplier()).ifPresent(builder::setPayment5FrequencyPeriodMultiplier);
			ofNullable(getPayment5Date()).ifPresent(builder::setPayment5Date);
			ofNullable(getPayment3Type()).ifPresent(builder::setPayment3Type);
			ofNullable(getPremiumPayer()).ifPresent(builder::setPremiumPayer);
			ofNullable(getPremiumPaymentDateUnadjusted()).ifPresent(builder::setPremiumPaymentDateUnadjusted);
			ofNullable(getTradeParty1NatureOfTheReportingCounterparty()).ifPresent(builder::setTradeParty1NatureOfTheReportingCounterparty);
			ofNullable(getTradeParty2NatureOfTheReportingCounterparty()).ifPresent(builder::setTradeParty2NatureOfTheReportingCounterparty);
			ofNullable(getReservedParticipantUse1()).ifPresent(builder::setReservedParticipantUse1);
			ofNullable(getReservedParticipantUse2()).ifPresent(builder::setReservedParticipantUse2);
			ofNullable(getReservedParticipantUse3()).ifPresent(builder::setReservedParticipantUse3);
			ofNullable(getReservedParticipantUse4()).ifPresent(builder::setReservedParticipantUse4);
			ofNullable(getReservedParticipantUse5()).ifPresent(builder::setReservedParticipantUse5);
			ofNullable(getLeg1TerminationDate()).ifPresent(builder::setLeg1TerminationDate);
			ofNullable(getAllocationType()).ifPresent(builder::setAllocationType);
			ofNullable(getCalculationBasis()).ifPresent(builder::setCalculationBasis);
			ofNullable(getClearingExceptionPartyId()).ifPresent(builder::setClearingExceptionPartyId);
			ofNullable(getClearingExceptionPartyIdType()).ifPresent(builder::setClearingExceptionPartyIdType);
			ofNullable(getClearingExceptionType()).ifPresent(builder::setClearingExceptionType);
			ofNullable(getClearingMemberClientAccountId()).ifPresent(builder::setClearingMemberClientAccountId);
			ofNullable(getClearingReceiptDatetime()).ifPresent(builder::setClearingReceiptDatetime);
			ofNullable(getClearingSwapSdrLeiId()).ifPresent(builder::setClearingSwapSdrLeiId);
			ofNullable(getClearingSwapUtiId()).ifPresent(builder::setClearingSwapUtiId);
			ofNullable(getCollateralReportingDate()).ifPresent(builder::setCollateralReportingDate);
			ofNullable(getCollateralValuationDatetime()).ifPresent(builder::setCollateralValuationDatetime);
			ofNullable(getComment2()).ifPresent(builder::setComment2);
			ofNullable(getCommodityStrikePriceUnit()).ifPresent(builder::setCommodityStrikePriceUnit);
			ofNullable(getExecutionAgentMaskingIndicator()).ifPresent(builder::setExecutionAgentMaskingIndicator);
			ofNullable(getFeeInCurrency()).ifPresent(builder::setFeeInCurrency);
			ofNullable(getFeeOutCurrency()).ifPresent(builder::setFeeOutCurrency);
			ofNullable(getFloatingRatePaymentFrequencyLeg1Multiplier()).ifPresent(builder::setFloatingRatePaymentFrequencyLeg1Multiplier);
			ofNullable(getFloatingRatePaymentFrequencyLeg1TimePeriod()).ifPresent(builder::setFloatingRatePaymentFrequencyLeg1TimePeriod);
			ofNullable(getFloatingRatePaymentFrequencyLeg2Multiplier()).ifPresent(builder::setFloatingRatePaymentFrequencyLeg2Multiplier);
			ofNullable(getFloatingRatePaymentFrequencyLeg2TimePeriod()).ifPresent(builder::setFloatingRatePaymentFrequencyLeg2TimePeriod);
			ofNullable(getFrequencyOfPayment()).ifPresent(builder::setFrequencyOfPayment);
			ofNullable(getInteraffiliate()).ifPresent(builder::setInteraffiliate);
			ofNullable(getLargeTradeIndicator()).ifPresent(builder::setLargeTradeIndicator);
			ofNullable(getLeg1EffectiveDateAdjusted()).ifPresent(builder::setLeg1EffectiveDateAdjusted);
			ofNullable(getLeg1FinalValuationDate()).ifPresent(builder::setLeg1FinalValuationDate);
			ofNullable(getLeg1SettlementPeriod()).ifPresent(builder::setLeg1SettlementPeriod);
			ofNullable(getLeg2EffectiveDateAdjusted()).ifPresent(builder::setLeg2EffectiveDateAdjusted);
			ofNullable(getLeg2PaymentTermsFrequencyPeriod()).ifPresent(builder::setLeg2PaymentTermsFrequencyPeriod);
			ofNullable(getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier()).ifPresent(builder::setLeg2PaymentTermsPaymentFrequencyPeriodMultiplier);
			ofNullable(getLeg2SettlementType()).ifPresent(builder::setLeg2SettlementType);
			ofNullable(getLeg2UnderlyingAssetId()).ifPresent(builder::setLeg2UnderlyingAssetId);
			ofNullable(getLeg2UnderlyingAssetIdType()).ifPresent(builder::setLeg2UnderlyingAssetIdType);
			ofNullable(getLeg2UnderlyingAssetName()).ifPresent(builder::setLeg2UnderlyingAssetName);
			ofNullable(getMaturityDate()).ifPresent(builder::setMaturityDate);
			ofNullable(getOptionalEarlyTerminationDate()).ifPresent(builder::setOptionalEarlyTerminationDate);
			ofNullable(getOptionCommodityCurrency()).ifPresent(builder::setOptionCommodityCurrency);
			ofNullable(getOptionCommodityExchangeId()).ifPresent(builder::setOptionCommodityExchangeId);
			ofNullable(getOptionCommodityInstrumentId()).ifPresent(builder::setOptionCommodityInstrumentId);
			ofNullable(getOptionCommodityRateSource()).ifPresent(builder::setOptionCommodityRateSource);
			ofNullable(getOptionCommodityRateSourcePage()).ifPresent(builder::setOptionCommodityRateSourcePage);
			ofNullable(getOptionCommodityUnderlyerDetails()).ifPresent(builder::setOptionCommodityUnderlyerDetails);
			ofNullable(getOptionCommodityUnderlyerId()).ifPresent(builder::setOptionCommodityUnderlyerId);
			ofNullable(getOptionCommodityUnitOfMeasure()).ifPresent(builder::setOptionCommodityUnitOfMeasure);
			ofNullable(getOptionSpecifiedPrice()).ifPresent(builder::setOptionSpecifiedPrice);
			ofNullable(getOptionSpreadAmount()).ifPresent(builder::setOptionSpreadAmount);
			ofNullable(getOptionSpreadCurrency()).ifPresent(builder::setOptionSpreadCurrency);
			ofNullable(getOptionSpreadSchedule()).ifPresent(builder::setOptionSpreadSchedule);
			ofNullable(getOrigin()).ifPresent(builder::setOrigin);
			ofNullable(getOriginalSwapSdrId()).ifPresent(builder::setOriginalSwapSdrId);
			ofNullable(getOriginalSwapSdrIdType()).ifPresent(builder::setOriginalSwapSdrIdType);
			ofNullable(getPaymentFrequencyPeriodLeg1()).ifPresent(builder::setPaymentFrequencyPeriodLeg1);
			ofNullable(getPaymentFrequencyPeriodLeg2()).ifPresent(builder::setPaymentFrequencyPeriodLeg2);
			ofNullable(getPaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setPaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getPaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setPaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getPremiumPayerPrefix()).ifPresent(builder::setPremiumPayerPrefix);
			ofNullable(getPrice1Currency()).ifPresent(builder::setPrice1Currency);
			ofNullable(getPrice2Price()).ifPresent(builder::setPrice2Price);
			ofNullable(getPrice2Type()).ifPresent(builder::setPrice2Type);
			ofNullable(getPrice2Units()).ifPresent(builder::setPrice2Units);
			ofNullable(getPrice3Price()).ifPresent(builder::setPrice3Price);
			ofNullable(getPrice3Type()).ifPresent(builder::setPrice3Type);
			ofNullable(getPrice3Units()).ifPresent(builder::setPrice3Units);
			ofNullable(getPrice4Price()).ifPresent(builder::setPrice4Price);
			ofNullable(getPrice4Type()).ifPresent(builder::setPrice4Type);
			ofNullable(getPrice4Units()).ifPresent(builder::setPrice4Units);
			ofNullable(getPricingContext()).ifPresent(builder::setPricingContext);
			ofNullable(getPriorUsiType()).ifPresent(builder::setPriorUsiType);
			ofNullable(getPriorUtiType()).ifPresent(builder::setPriorUtiType);
			ofNullable(getRecoveryPrice()).ifPresent(builder::setRecoveryPrice);
			ofNullable(getSendToDataCenterCode()).ifPresent(builder::setSendToDataCenterCode);
			ofNullable(getStrikePriceType()).ifPresent(builder::setStrikePriceType);
			ofNullable(getSubAssetClassForOtherCommodity()).ifPresent(builder::setSubAssetClassForOtherCommodity);
			ofNullable(getTradeParty1CftcFinancialEntityStatus()).ifPresent(builder::setTradeParty1CftcFinancialEntityStatus);
			ofNullable(getTradeParty1CollateralAmount()).ifPresent(builder::setTradeParty1CollateralAmount);
			ofNullable(getTradeParty1CollateralCurrency()).ifPresent(builder::setTradeParty1CollateralCurrency);
			ofNullable(getTradeParty1MandatoryDelegatedReporting()).ifPresent(builder::setTradeParty1MandatoryDelegatedReporting);
			ofNullable(getTradeParty1Role()).ifPresent(builder::setTradeParty1Role);
			ofNullable(getTradeParty2CftcFinancialEntityStatus()).ifPresent(builder::setTradeParty2CftcFinancialEntityStatus);
			ofNullable(getTradeParty2CollateralAmount()).ifPresent(builder::setTradeParty2CollateralAmount);
			ofNullable(getTradeParty2CollateralCurrency()).ifPresent(builder::setTradeParty2CollateralCurrency);
			ofNullable(getTradeParty2MandatoryDelegatedReporting()).ifPresent(builder::setTradeParty2MandatoryDelegatedReporting);
			ofNullable(getTradeParty2Role()).ifPresent(builder::setTradeParty2Role);
			ofNullable(getUpfrontPayment()).ifPresent(builder::setUpfrontPayment);
			ofNullable(getVerificationMethod()).ifPresent(builder::setVerificationMethod);
			ofNullable(getResponsibleDataSubmitterId()).ifPresent(builder::setResponsibleDataSubmitterId);
			ofNullable(getResponsibleDataSubmitterIdType()).ifPresent(builder::setResponsibleDataSubmitterIdType);
			ofNullable(getOriginalSwapUsi()).ifPresent(builder::setOriginalSwapUsi);
			ofNullable(getOriginalSwapUti()).ifPresent(builder::setOriginalSwapUti);
			ofNullable(getCdeReceiverIdentifierLeg2()).ifPresent(builder::setCdeReceiverIdentifierLeg2);
			ofNullable(getCounterparty1FederalEntityIndicator()).ifPresent(builder::setCounterparty1FederalEntityIndicator);
			ofNullable(getCounterparty2FederalEntityIndicator()).ifPresent(builder::setCounterparty2FederalEntityIndicator);
			ofNullable(getCustomBasketIndicator()).ifPresent(builder::setCustomBasketIndicator);
			ofNullable(getNoaActionType()).ifPresent(builder::setNoaActionType);
			ofNullable(getEventType()).ifPresent(builder::setEventType);
			ofNullable(getAmendmentIndicator()).ifPresent(builder::setAmendmentIndicator);
			ofNullable(getEventIdentifier()).ifPresent(builder::setEventIdentifier);
			ofNullable(getCdeCallAmountLeg1()).ifPresent(builder::setCdeCallAmountLeg1);
			ofNullable(getCdeCallAmountLeg2()).ifPresent(builder::setCdeCallAmountLeg2);
			ofNullable(getCdeCallCurrencyLeg1()).ifPresent(builder::setCdeCallCurrencyLeg1);
			ofNullable(getCdeCallCurrencyLeg2()).ifPresent(builder::setCdeCallCurrencyLeg2);
			ofNullable(getCdePutAmountLeg1()).ifPresent(builder::setCdePutAmountLeg1);
			ofNullable(getCdePutAmountLeg2()).ifPresent(builder::setCdePutAmountLeg2);
			ofNullable(getCdePutCurrencyLeg1()).ifPresent(builder::setCdePutCurrencyLeg1);
			ofNullable(getCdePutCurrencyLeg2()).ifPresent(builder::setCdePutCurrencyLeg2);
			ofNullable(getLeg2QuantityFrequency()).ifPresent(builder::setLeg2QuantityFrequency);
			ofNullable(getQuantityFrequencyMultiplierLeg1()).ifPresent(builder::setQuantityFrequencyMultiplierLeg1);
			ofNullable(getQuantityFrequencyMultiplierLeg2()).ifPresent(builder::setQuantityFrequencyMultiplierLeg2);
			ofNullable(getCdeQuantityUnitOfMeasureLeg1()).ifPresent(builder::setCdeQuantityUnitOfMeasureLeg1);
			ofNullable(getCdeQuantityUnitOfMeasureLeg2()).ifPresent(builder::setCdeQuantityUnitOfMeasureLeg2);
			ofNullable(getPackageIndicator()).ifPresent(builder::setPackageIndicator);
			ofNullable(getCdePackageIdentifier()).ifPresent(builder::setCdePackageIdentifier);
			ofNullable(getCdePackageTransactionPrice()).ifPresent(builder::setCdePackageTransactionPrice);
			ofNullable(getCdePackageTransactionPriceCurrency()).ifPresent(builder::setCdePackageTransactionPriceCurrency);
			ofNullable(getCdePackageTransactionPriceNotation()).ifPresent(builder::setCdePackageTransactionPriceNotation);
			ofNullable(getCdePackageTransactionSpread()).ifPresent(builder::setCdePackageTransactionSpread);
			ofNullable(getCdePackageTransactionSpreadCurrency()).ifPresent(builder::setCdePackageTransactionSpreadCurrency);
			ofNullable(getCdePackageTransactionSpreadNotation()).ifPresent(builder::setCdePackageTransactionSpreadNotation);
			ofNullable(getCdeFixedRateDayCountConventionLeg1()).ifPresent(builder::setCdeFixedRateDayCountConventionLeg1);
			ofNullable(getCdeFixedRateDayCountConventionLeg2()).ifPresent(builder::setCdeFixedRateDayCountConventionLeg2);
			ofNullable(getCdeFloatingRateDayCountConventionLeg1()).ifPresent(builder::setCdeFloatingRateDayCountConventionLeg1);
			ofNullable(getCdeFloatingRateDayCountConventionLeg2()).ifPresent(builder::setCdeFloatingRateDayCountConventionLeg2);
			ofNullable(getFixingDateLeg1()).ifPresent(builder::setFixingDateLeg1);
			ofNullable(getFixingDateLeg2()).ifPresent(builder::setFixingDateLeg2);
			ofNullable(getCdeFixedRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setCdeFixedRatePaymentFrequencyPeriodLeg1);
			ofNullable(getCdeFixedRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setCdeFixedRatePaymentFrequencyPeriodLeg2);
			ofNullable(getCdeFloatingRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setCdeFloatingRatePaymentFrequencyPeriodLeg1);
			ofNullable(getCdeFloatingRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setCdeFloatingRatePaymentFrequencyPeriodLeg2);
			ofNullable(getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getPostPricedSwapIndicator()).ifPresent(builder::setPostPricedSwapIndicator);
			ofNullable(getCdePriceCurrency()).ifPresent(builder::setCdePriceCurrency);
			ofNullable(getCdePriceNotation()).ifPresent(builder::setCdePriceNotation);
			ofNullable(getCdeSpreadNotationLeg1()).ifPresent(builder::setCdeSpreadNotationLeg1);
			ofNullable(getCdeSpreadNotationLeg2()).ifPresent(builder::setCdeSpreadNotationLeg2);
			ofNullable(getCdeStrikePriceCurrency2()).ifPresent(builder::setCdeStrikePriceCurrency2);
			ofNullable(getCdeStrikePriceNotation()).ifPresent(builder::setCdeStrikePriceNotation);
			ofNullable(getCdeFirstExerciseDate()).ifPresent(builder::setCdeFirstExerciseDate);
			ofNullable(getCdeFinalContractualSettlementDate()).ifPresent(builder::setCdeFinalContractualSettlementDate);
			ofNullable(getCdeSettlementLocationLeg1()).ifPresent(builder::setCdeSettlementLocationLeg1);
			ofNullable(getCdeSettlementLocationLeg2()).ifPresent(builder::setCdeSettlementLocationLeg2);
			ofNullable(getCdeEffectiveDate()).ifPresent(builder::setCdeEffectiveDate);
			ofNullable(getCdeExpirationDate()).ifPresent(builder::setCdeExpirationDate);
			ofNullable(getCdePlatformIdentifier()).ifPresent(builder::setCdePlatformIdentifier);
			ofNullable(getPrimeBrokerageTransactionIndicator()).ifPresent(builder::setPrimeBrokerageTransactionIndicator);
			ofNullable(getSwapReportingJurisdiction()).ifPresent(builder::setSwapReportingJurisdiction);
			ofNullable(getNewSdrIdentifier()).ifPresent(builder::setNewSdrIdentifier);
			ofNullable(getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
			ofNullable(getLastFloatingReferenceValueLeg1()).ifPresent(builder::setLastFloatingReferenceValueLeg1);
			ofNullable(getLastFloatingReferenceResetDateLeg1()).ifPresent(builder::setLastFloatingReferenceResetDateLeg1);
			ofNullable(getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
			ofNullable(getLastFloatingReferenceValueLeg2()).ifPresent(builder::setLastFloatingReferenceValueLeg2);
			ofNullable(getLastFloatingReferenceResetDateLeg2()).ifPresent(builder::setLastFloatingReferenceResetDateLeg2);
			ofNullable(getCdeDelta()).ifPresent(builder::setCdeDelta);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getLargeNotionalOffFacilitySwapElectionIndicator()).ifPresent(builder::setLargeNotionalOffFacilitySwapElectionIndicator);
			ofNullable(getSefOrDcmAnonymousExecutionIndicator()).ifPresent(builder::setSefOrDcmAnonymousExecutionIndicator);
			ofNullable(getBlockTradeElectionIndicator()).ifPresent(builder::setBlockTradeElectionIndicator);
			ofNullable(getSefOrDcmIndicator()).ifPresent(builder::setSefOrDcmIndicator);
			ofNullable(getMandatoryClearingIndicator()).ifPresent(builder::setMandatoryClearingIndicator);
			ofNullable(getSdMspIndicatorCounterparty1()).ifPresent(builder::setSdMspIndicatorCounterparty1);
			ofNullable(getSdMspIndicatorCounterparty2()).ifPresent(builder::setSdMspIndicatorCounterparty2);
			ofNullable(getPhysicalCommodityContractIndicator()).ifPresent(builder::setPhysicalCommodityContractIndicator);
			ofNullable(getChangeInNotionalAmount1()).ifPresent(builder::setChangeInNotionalAmount1);
			ofNullable(getChangeInNotionalAmount2()).ifPresent(builder::setChangeInNotionalAmount2);
			ofNullable(getChangeInLeg1NotionalQuantity()).ifPresent(builder::setChangeInLeg1NotionalQuantity);
			ofNullable(getChangeInLeg2NotionalQuantity()).ifPresent(builder::setChangeInLeg2NotionalQuantity);
			ofNullable(getCdeCryptoAssetUnderlyingIndicatorLeg1()).ifPresent(builder::setCdeCryptoAssetUnderlyingIndicatorLeg1);
			ofNullable(getCdeCryptoAssetUnderlyingIndicatorLeg2()).ifPresent(builder::setCdeCryptoAssetUnderlyingIndicatorLeg2);
			ofNullable(getCdeCustomBasketCode()).ifPresent(builder::setCdeCustomBasketCode);
			ofNullable(getUnderlierIdOtherLeg1()).ifPresent(builder::setUnderlierIdOtherLeg1);
			ofNullable(getUnderlierIdOtherLeg2()).ifPresent(builder::setUnderlierIdOtherLeg2);
			ofNullable(getUnderlierIdOtherSourceLeg1()).ifPresent(builder::setUnderlierIdOtherSourceLeg1);
			ofNullable(getUnderlierIdOtherSourceLeg2()).ifPresent(builder::setUnderlierIdOtherSourceLeg2);
			ofNullable(getCdeUnderlyingAssetTradingPlatformIdLeg1()).ifPresent(builder::setCdeUnderlyingAssetTradingPlatformIdLeg1);
			ofNullable(getCdeUnderlyingAssetTradingPlatformIdLeg2()).ifPresent(builder::setCdeUnderlyingAssetTradingPlatformIdLeg2);
			ofNullable(getCdeUnderlyingAssetPriceSourceLeg1()).ifPresent(builder::setCdeUnderlyingAssetPriceSourceLeg1);
			ofNullable(getCdeUnderlyingAssetPriceSourceLeg2()).ifPresent(builder::setCdeUnderlyingAssetPriceSourceLeg2);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HarmonizedData _that = getType().cast(o);
		
			if (!Objects.equals(leg2CommodityInstrumentId, _that.getLeg2CommodityInstrumentId())) return false;
			if (!Objects.equals(leg2CommodityUnderlyerId, _that.getLeg2CommodityUnderlyerId())) return false;
			if (!Objects.equals(leg2CommodityUnderlyerDetails, _that.getLeg2CommodityUnderlyerDetails())) return false;
			if (!Objects.equals(leg2CommodityUnitOfMeasure, _that.getLeg2CommodityUnitOfMeasure())) return false;
			if (!Objects.equals(leg2CommodityCurrency, _that.getLeg2CommodityCurrency())) return false;
			if (!Objects.equals(leg2CommodityExchangeId, _that.getLeg2CommodityExchangeId())) return false;
			if (!Objects.equals(leg1CommodityRateSource, _that.getLeg1CommodityRateSource())) return false;
			if (!Objects.equals(leg1CommodityRateSourcePage, _that.getLeg1CommodityRateSourcePage())) return false;
			if (!Objects.equals(leg2SpecifiedPrice, _that.getLeg2SpecifiedPrice())) return false;
			if (!Objects.equals(commencementDateUnadjusted, _that.getCommencementDateUnadjusted())) return false;
			if (!Objects.equals(exerciseExpirationDateUnadjusted, _that.getExerciseExpirationDateUnadjusted())) return false;
			if (!Objects.equals(expirationDateUnadjusted, _that.getExpirationDateUnadjusted())) return false;
			if (!Objects.equals(leg2NotionalQuantityFrequency, _that.getLeg2NotionalQuantityFrequency())) return false;
			if (!Objects.equals(leg2NotionalQuantity, _that.getLeg2NotionalQuantity())) return false;
			if (!Objects.equals(leg2TotalNotionalQuantity, _that.getLeg2TotalNotionalQuantity())) return false;
			if (!Objects.equals(leg2SpreadAmount, _that.getLeg2SpreadAmount())) return false;
			if (!Objects.equals(leg2SpreadCurrency, _that.getLeg2SpreadCurrency())) return false;
			if (!Objects.equals(scheduledTerminationDateAdjusted, _that.getScheduledTerminationDateAdjusted())) return false;
			if (!Objects.equals(leg1PartyPayer, _that.getLeg1PartyPayer())) return false;
			if (!Objects.equals(leg2PartyPayer, _that.getLeg2PartyPayer())) return false;
			if (!Objects.equals(leg1CommodityInstrumentId, _that.getLeg1CommodityInstrumentId())) return false;
			if (!Objects.equals(leg1CommodityUnderlyerId, _that.getLeg1CommodityUnderlyerId())) return false;
			if (!Objects.equals(leg1CommodityUnitOfMeasure, _that.getLeg1CommodityUnitOfMeasure())) return false;
			if (!Objects.equals(leg1CommodityExchangeId, _that.getLeg1CommodityExchangeId())) return false;
			if (!Objects.equals(leg2CommodityRateSource, _that.getLeg2CommodityRateSource())) return false;
			if (!Objects.equals(leg1EffectiveDateUnadjusted, _that.getLeg1EffectiveDateUnadjusted())) return false;
			if (!Objects.equals(leg2EffectiveDateUnadjusted, _that.getLeg2EffectiveDateUnadjusted())) return false;
			if (!Objects.equals(coProductType, _that.getCoProductType())) return false;
			if (!Objects.equals(totalQuantityUnit, _that.getTotalQuantityUnit())) return false;
			if (!Objects.equals(totalQuantity, _that.getTotalQuantity())) return false;
			if (!Objects.equals(fixedPrice, _that.getFixedPrice())) return false;
			if (!Objects.equals(fixedPriceCurrency, _that.getFixedPriceCurrency())) return false;
			if (!Objects.equals(leg1NotionalQuantityUnit, _that.getLeg1NotionalQuantityUnit())) return false;
			if (!Objects.equals(leg1NotionalQuantityFrequency, _that.getLeg1NotionalQuantityFrequency())) return false;
			if (!Objects.equals(leg1NotionalQuantity, _that.getLeg1NotionalQuantity())) return false;
			if (!Objects.equals(leg1TotalNotionalQuantity, _that.getLeg1TotalNotionalQuantity())) return false;
			if (!Objects.equals(leg1CommodityCurrency, _that.getLeg1CommodityCurrency())) return false;
			if (!Objects.equals(leg1SpecifiedPrice, _that.getLeg1SpecifiedPrice())) return false;
			if (!Objects.equals(leg1SpreadCurrency, _that.getLeg1SpreadCurrency())) return false;
			if (!Objects.equals(leg1SpreadAmount, _that.getLeg1SpreadAmount())) return false;
			if (!Objects.equals(leg2NotionalQuantityUnit, _that.getLeg2NotionalQuantityUnit())) return false;
			if (!Objects.equals(leg2PartyReceiver, _that.getLeg2PartyReceiver())) return false;
			if (!Objects.equals(leg1PartyReceiver, _that.getLeg1PartyReceiver())) return false;
			if (!Objects.equals(coalSource, _that.getCoalSource())) return false;
			if (!Objects.equals(leg2Quantity, _that.getLeg2Quantity())) return false;
			if (!Objects.equals(commodityBase, _that.getCommodityBase())) return false;
			if (!Objects.equals(commodityDetails, _that.getCommodityDetails())) return false;
			if (!Objects.equals(interconnectionPoint, _that.getInterconnectionPoint())) return false;
			if (!Objects.equals(loadType, _that.getLoadType())) return false;
			if (!Objects.equals(fixedPriceUnit, _that.getFixedPriceUnit())) return false;
			if (!Objects.equals(exercisePaymentDateUnadjusted, _that.getExercisePaymentDateUnadjusted())) return false;
			if (!Objects.equals(leg1PaymentDatesUnadjusted, _that.getLeg1PaymentDatesUnadjusted())) return false;
			if (!Objects.equals(leg2PaymentDateUnadjusted, _that.getLeg2PaymentDateUnadjusted())) return false;
			if (!Objects.equals(settlementDateUnadjusted, _that.getSettlementDateUnadjusted())) return false;
			if (!Objects.equals(deliveryLocation, _that.getDeliveryLocation())) return false;
			if (!Objects.equals(leg2QuantityUnit, _that.getLeg2QuantityUnit())) return false;
			if (!Objects.equals(leg1CommodityUnderlyerDetails, _that.getLeg1CommodityUnderlyerDetails())) return false;
			if (!Objects.equals(leg2CommodityRateSourcePage, _that.getLeg2CommodityRateSourcePage())) return false;
			if (!Objects.equals(valueDate, _that.getValueDate())) return false;
			if (!Objects.equals(gtrQuantityUnit, _that.getGtrQuantityUnit())) return false;
			if (!Objects.equals(attachmentPoint, _that.getAttachmentPoint())) return false;
			if (!Objects.equals(exhaustionPoint, _that.getExhaustionPoint())) return false;
			if (!Objects.equals(mthToDefault, _that.getMthToDefault())) return false;
			if (!Objects.equals(nthToDefault, _that.getNthToDefault())) return false;
			if (!Objects.equals(seniority, _that.getSeniority())) return false;
			if (!Objects.equals(series, _that.getSeries())) return false;
			if (!Objects.equals(crversion, _that.getCrversion())) return false;
			if (!Objects.equals(tranche, _that.getTranche())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(referenceObligation, _that.getReferenceObligation())) return false;
			if (!Objects.equals(referenceObligationIdType, _that.getReferenceObligationIdType())) return false;
			if (!Objects.equals(underlyingFixedRatePayerBuyer, _that.getUnderlyingFixedRatePayerBuyer())) return false;
			if (!Objects.equals(underlyingFloatRatePayerSeller, _that.getUnderlyingFloatRatePayerSeller())) return false;
			if (!Objects.equals(underlyingAssetExchangeId, _that.getUnderlyingAssetExchangeId())) return false;
			if (!Objects.equals(underlyingAssetNumberOfUnits, _that.getUnderlyingAssetNumberOfUnits())) return false;
			if (!Objects.equals(optionalEarlyTerminationType, _that.getOptionalEarlyTerminationType())) return false;
			if (!Objects.equals(optionalEarlyTerminationElectingPartyValue, _that.getOptionalEarlyTerminationElectingPartyValue())) return false;
			if (!Objects.equals(optionalEarlyTerminationIndicator, _that.getOptionalEarlyTerminationIndicator())) return false;
			if (!Objects.equals(underlyingAssetFloatingAmountPayer, _that.getUnderlyingAssetFloatingAmountPayer())) return false;
			if (!Objects.equals(underlyingAssetFloatingAmountReceiver, _that.getUnderlyingAssetFloatingAmountReceiver())) return false;
			if (!Objects.equals(floatingRateOption, _that.getFloatingRateOption())) return false;
			if (!Objects.equals(underlyingAssetFloatingLegSpread, _that.getUnderlyingAssetFloatingLegSpread())) return false;
			if (!Objects.equals(leg2DesignatedMaturityPeriod, _that.getLeg2DesignatedMaturityPeriod())) return false;
			if (!Objects.equals(leg2DesignatedMaturityPeriodMultiplier, _that.getLeg2DesignatedMaturityPeriodMultiplier())) return false;
			if (!Objects.equals(underlyingAssetEquityAmountPayer, _that.getUnderlyingAssetEquityAmountPayer())) return false;
			if (!Objects.equals(underlyingAssetEquityAmountReceiver, _that.getUnderlyingAssetEquityAmountReceiver())) return false;
			if (!Objects.equals(underlyingAssetInitialPriceCurrency, _that.getUnderlyingAssetInitialPriceCurrency())) return false;
			if (!Objects.equals(leg1ValuationDates, _that.getLeg1ValuationDates())) return false;
			if (!Objects.equals(leg1TypeOfReturn, _that.getLeg1TypeOfReturn())) return false;
			if (!Objects.equals(observationStartDate, _that.getObservationStartDate())) return false;
			if (!Objects.equals(varianceAmount, _that.getVarianceAmount())) return false;
			if (!Objects.equals(volatilityStrikePrice, _that.getVolatilityStrikePrice())) return false;
			if (!Objects.equals(varianceStrikePrice, _that.getVarianceStrikePrice())) return false;
			if (!Objects.equals(varianceCapFactor, _that.getVarianceCapFactor())) return false;
			if (!Objects.equals(referenceCurrency, _that.getReferenceCurrency())) return false;
			if (!Objects.equals(specialDividendsIndicator, _that.getSpecialDividendsIndicator())) return false;
			if (!Objects.equals(materialNoncashDividendIndicator, _that.getMaterialNoncashDividendIndicator())) return false;
			if (!Objects.equals(numberOfSharesUnits, _that.getNumberOfSharesUnits())) return false;
			if (!Objects.equals(dividendAmountPayer, _that.getDividendAmountPayer())) return false;
			if (!Objects.equals(dividendAmountReceiver, _that.getDividendAmountReceiver())) return false;
			if (!Objects.equals(fixedAmountPayer, _that.getFixedAmountPayer())) return false;
			if (!Objects.equals(fixedAmountReceiver, _that.getFixedAmountReceiver())) return false;
			if (!Objects.equals(knockInEvent, _that.getKnockInEvent())) return false;
			if (!Objects.equals(knockOutEvent, _that.getKnockOutEvent())) return false;
			if (!Objects.equals(knockInPrice, _that.getKnockInPrice())) return false;
			if (!Objects.equals(knockOutPrice, _that.getKnockOutPrice())) return false;
			if (!Objects.equals(barrierType, _that.getBarrierType())) return false;
			if (!Objects.equals(earliestExecutionTime, _that.getEarliestExecutionTime())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasisCurrency1, _that.getExchangeRateBasisCurrency1())) return false;
			if (!Objects.equals(exchangeRateBasisCurrency2, _that.getExchangeRateBasisCurrency2())) return false;
			if (!Objects.equals(executionPeriodStartDate, _that.getExecutionPeriodStartDate())) return false;
			if (!Objects.equals(payoutStyle, _that.getPayoutStyle())) return false;
			if (!Objects.equals(rateQuoteBasis1, _that.getRateQuoteBasis1())) return false;
			if (!Objects.equals(settlementFixingDate, _that.getSettlementFixingDate())) return false;
			if (!Objects.equals(swapLinkId, _that.getSwapLinkId())) return false;
			if (!Objects.equals(triggerCondition, _that.getTriggerCondition())) return false;
			if (!Objects.equals(triggerCondition2, _that.getTriggerCondition2())) return false;
			if (!Objects.equals(triggerRate, _that.getTriggerRate())) return false;
			if (!Objects.equals(triggerRate2, _that.getTriggerRate2())) return false;
			if (!Objects.equals(rateQuoteBasis2, _that.getRateQuoteBasis2())) return false;
			if (!Objects.equals(forwardExchangeRate, _that.getForwardExchangeRate())) return false;
			if (!Objects.equals(barrierType2, _that.getBarrierType2())) return false;
			if (!Objects.equals(cancelationOptionBuyer, _that.getCancelationOptionBuyer())) return false;
			if (!Objects.equals(cancelationOptionCommencementDate, _that.getCancelationOptionCommencementDate())) return false;
			if (!Objects.equals(cancelationOptionExerciseStyleType, _that.getCancelationOptionExerciseStyleType())) return false;
			if (!Objects.equals(cancelationOptionExpirationDate, _that.getCancelationOptionExpirationDate())) return false;
			if (!Objects.equals(cancelationOptionInitialFeeCurrency, _that.getCancelationOptionInitialFeeCurrency())) return false;
			if (!Objects.equals(cancelationOptionInitialFeePayer, _that.getCancelationOptionInitialFeePayer())) return false;
			if (!Objects.equals(cancelationOptionPremiumAmount, _that.getCancelationOptionPremiumAmount())) return false;
			if (!Objects.equals(cancelationOptionSeller, _that.getCancelationOptionSeller())) return false;
			if (!Objects.equals(capRateInitial, _that.getCapRateInitial())) return false;
			if (!Objects.equals(couponType, _that.getCouponType())) return false;
			if (!Objects.equals(finalPrincipalExchangeIndicatorAtTermination, _that.getFinalPrincipalExchangeIndicatorAtTermination())) return false;
			if (!Objects.equals(floorRateInitial, _that.getFloorRateInitial())) return false;
			if (!Objects.equals(fraDiscountingType, _that.getFraDiscountingType())) return false;
			if (!Objects.equals(inflationIndexInitialLevel, _that.getInflationIndexInitialLevel())) return false;
			if (!Objects.equals(inflationIndexMainPublication, _that.getInflationIndexMainPublication())) return false;
			if (!Objects.equals(inflationInterpolationMethod, _that.getInflationInterpolationMethod())) return false;
			if (!Objects.equals(inflationLagDayType, _that.getInflationLagDayType())) return false;
			if (!Objects.equals(inflationLagPeriod, _that.getInflationLagPeriod())) return false;
			if (!Objects.equals(inflationRateSourceName, _that.getInflationRateSourceName())) return false;
			if (!Objects.equals(initialPrincipalExchangeIndicator, _that.getInitialPrincipalExchangeIndicator())) return false;
			if (!Objects.equals(intermediatePrincipalExchangeIndicator, _that.getIntermediatePrincipalExchangeIndicator())) return false;
			if (!Objects.equals(leg1FloatingRateIndex, _that.getLeg1FloatingRateIndex())) return false;
			if (!Objects.equals(leg1FloatingRateInitialSpread, _that.getLeg1FloatingRateInitialSpread())) return false;
			if (!Objects.equals(leg1FloatingRateMultiplierInitialValue, _that.getLeg1FloatingRateMultiplierInitialValue())) return false;
			if (!Objects.equals(leg1FloatingRateTenorPeriod, _that.getLeg1FloatingRateTenorPeriod())) return false;
			if (!Objects.equals(leg1FloatingRateTenorPeriodMultiplier, _that.getLeg1FloatingRateTenorPeriodMultiplier())) return false;
			if (!Objects.equals(leg1KnownAmount, _that.getLeg1KnownAmount())) return false;
			if (!Objects.equals(leg1KnownAmountCurrency, _that.getLeg1KnownAmountCurrency())) return false;
			if (!Objects.equals(leg1ReferenceCurrency, _that.getLeg1ReferenceCurrency())) return false;
			if (!Objects.equals(leg2FloatingRateIndex, _that.getLeg2FloatingRateIndex())) return false;
			if (!Objects.equals(leg2FloatingRateInitialSpread, _that.getLeg2FloatingRateInitialSpread())) return false;
			if (!Objects.equals(leg2FloatingRateMultiplierInitialValue, _that.getLeg2FloatingRateMultiplierInitialValue())) return false;
			if (!Objects.equals(leg2FloatingRateTenorPeriod, _that.getLeg2FloatingRateTenorPeriod())) return false;
			if (!Objects.equals(leg2FloatingRateTenorPeriodMultiplier, _that.getLeg2FloatingRateTenorPeriodMultiplier())) return false;
			if (!Objects.equals(leg2KnownAmount, _that.getLeg2KnownAmount())) return false;
			if (!Objects.equals(leg2KnownAmountCurrency, _that.getLeg2KnownAmountCurrency())) return false;
			if (!Objects.equals(leg2ReferenceCurrency, _that.getLeg2ReferenceCurrency())) return false;
			if (!Objects.equals(mandatoryEarlyTerminationDate, _that.getMandatoryEarlyTerminationDate())) return false;
			if (!Objects.equals(mandatoryEarlyTerminationDateTenorPeriod, _that.getMandatoryEarlyTerminationDateTenorPeriod())) return false;
			if (!Objects.equals(mandatoryEarlyTerminationDateTenorPeriodMultiplier, _that.getMandatoryEarlyTerminationDateTenorPeriodMultiplier())) return false;
			if (!Objects.equals(notionalUnits, _that.getNotionalUnits())) return false;
			if (!Objects.equals(optionalEarlyTerminationCommencementDate, _that.getOptionalEarlyTerminationCommencementDate())) return false;
			if (!Objects.equals(optionalEarlyTerminationExerciseStyle, _that.getOptionalEarlyTerminationExerciseStyle())) return false;
			if (!Objects.equals(optionalEarlyTerminationExpirationDate, _that.getOptionalEarlyTerminationExpirationDate())) return false;
			if (!Objects.equals(premiumReceiver, _that.getPremiumReceiver())) return false;
			if (!Objects.equals(underlyingCouponRate, _that.getUnderlyingCouponRate())) return false;
			if (!Objects.equals(underlyingMaturityDate, _that.getUnderlyingMaturityDate())) return false;
			if (!Objects.equals(underlyingProductId, _that.getUnderlyingProductId())) return false;
			if (!Objects.equals(inflationLagPeriodMultiplier, _that.getInflationLagPeriodMultiplier())) return false;
			if (!Objects.equals(leg1FixedRateNotation, _that.getLeg1FixedRateNotation())) return false;
			if (!Objects.equals(leg2FixedRateNotation, _that.getLeg2FixedRateNotation())) return false;
			if (!Objects.equals(swaptionStraddleIndicator, _that.getSwaptionStraddleIndicator())) return false;
			if (!Objects.equals(singlePartyEarlyTerminationBuyer, _that.getSinglePartyEarlyTerminationBuyer())) return false;
			if (!Objects.equals(leg1EffectiveDate, _that.getLeg1EffectiveDate())) return false;
			if (!Objects.equals(action, _that.getAction())) return false;
			if (!Objects.equals(clearingStatus, _that.getClearingStatus())) return false;
			if (!Objects.equals(effectiveDate1, _that.getEffectiveDate1())) return false;
			if (!Objects.equals(executionVenueType, _that.getExecutionVenueType())) return false;
			if (!Objects.equals(nonStandardTradeIndicator, _that.getNonStandardTradeIndicator())) return false;
			if (!Objects.equals(notionalAmount1, _that.getNotionalAmount1())) return false;
			if (!Objects.equals(notionalCurrency1, _that.getNotionalCurrency1())) return false;
			if (!Objects.equals(price1Price, _that.getPrice1Price())) return false;
			if (!Objects.equals(price1Type, _that.getPrice1Type())) return false;
			if (!Objects.equals(price1Units, _that.getPrice1Units())) return false;
			if (!Objects.equals(scheduledTerminationDate1, _that.getScheduledTerminationDate1())) return false;
			if (!Objects.equals(tradeDate, _that.getTradeDate())) return false;
			if (!Objects.equals(tradeParty1CollateralizationType, _that.getTradeParty1CollateralizationType())) return false;
			if (!Objects.equals(tradeParty1EventId, _that.getTradeParty1EventId())) return false;
			if (!Objects.equals(tradeParty2CollateralizationType, _that.getTradeParty2CollateralizationType())) return false;
			if (!Objects.equals(tradeParty2EventId, _that.getTradeParty2EventId())) return false;
			if (!Objects.equals(embeddedOptionOnSwap, _that.getEmbeddedOptionOnSwap())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(notionalAmount2, _that.getNotionalAmount2())) return false;
			if (!Objects.equals(notionalCurrency2, _that.getNotionalCurrency2())) return false;
			if (!Objects.equals(premiumAmount, _that.getPremiumAmount())) return false;
			if (!Objects.equals(premiumCurrency, _that.getPremiumCurrency())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(comment1, _that.getComment1())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(settlementCurrency1, _that.getSettlementCurrency1())) return false;
			if (!Objects.equals(commencementDate, _that.getCommencementDate())) return false;
			if (!Objects.equals(dayCountFraction1, _that.getDayCountFraction1())) return false;
			if (!Objects.equals(leg2DayCountFraction, _that.getLeg2DayCountFraction())) return false;
			if (!Objects.equals(leg2EffectiveDate, _that.getLeg2EffectiveDate())) return false;
			if (!Objects.equals(leg2ResetFrequencyPeriod, _that.getLeg2ResetFrequencyPeriod())) return false;
			if (!Objects.equals(leg2ResetFrequencyPeriodMultiplier, _that.getLeg2ResetFrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(leg2SettlementCurrency, _that.getLeg2SettlementCurrency())) return false;
			if (!Objects.equals(leg2ScheduledTerminationDate, _that.getLeg2ScheduledTerminationDate())) return false;
			if (!Objects.equals(numberOfOptions, _that.getNumberOfOptions())) return false;
			if (!Objects.equals(optionEntitlement, _that.getOptionEntitlement())) return false;
			if (!Objects.equals(originalExecutionTimestamp, _that.getOriginalExecutionTimestamp())) return false;
			if (!Objects.equals(payment1Date, _that.getPayment1Date())) return false;
			if (!Objects.equals(payment1FrequencyPeriod, _that.getPayment1FrequencyPeriod())) return false;
			if (!Objects.equals(payment1FrequencyPeriodMultiplier, _that.getPayment1FrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(payment2Date, _that.getPayment2Date())) return false;
			if (!Objects.equals(payment2FrequencyPeriod, _that.getPayment2FrequencyPeriod())) return false;
			if (!Objects.equals(payment2FrequencyPeriodMultiplier, _that.getPayment2FrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(resetFrequencyPeriod1, _that.getResetFrequencyPeriod1())) return false;
			if (!Objects.equals(resetFrequencyPeriodMultiplier1, _that.getResetFrequencyPeriodMultiplier1())) return false;
			if (!Objects.equals(settlementDate, _that.getSettlementDate())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!Objects.equals(strikePriceUnits, _that.getStrikePriceUnits())) return false;
			if (!Objects.equals(asOfDateTime, _that.getAsOfDateTime())) return false;
			if (!Objects.equals(clearingVenueId, _that.getClearingVenueId())) return false;
			if (!Objects.equals(clearingVenueIdType, _that.getClearingVenueIdType())) return false;
			if (!Objects.equals(compressedTradeIndicator, _that.getCompressedTradeIndicator())) return false;
			if (!Objects.equals(confirmationMethod, _that.getConfirmationMethod())) return false;
			if (!Objects.equals(confirmationPlatformId, _that.getConfirmationPlatformId())) return false;
			if (!Objects.equals(confirmationPlatformTradeId, _that.getConfirmationPlatformTradeId())) return false;
			if (!Objects.equals(executionVenueId, _that.getExecutionVenueId())) return false;
			if (!Objects.equals(executionVenueIdType, _that.getExecutionVenueIdType())) return false;
			if (!Objects.equals(postTradeEffectiveDate, _that.getPostTradeEffectiveDate())) return false;
			if (!Objects.equals(priorUsiId, _that.getPriorUsiId())) return false;
			if (!Objects.equals(priorUsiIdPrefix, _that.getPriorUsiIdPrefix())) return false;
			if (!Objects.equals(priorUtiId, _that.getPriorUtiId())) return false;
			if (!Objects.equals(priorUtiIdPrefix, _that.getPriorUtiIdPrefix())) return false;
			if (!Objects.equals(tradeParty1BranchLocation, _that.getTradeParty1BranchLocation())) return false;
			if (!Objects.equals(tradeParty1ClearingBrokerId, _that.getTradeParty1ClearingBrokerId())) return false;
			if (!Objects.equals(tradeParty1ClearingBrokerIdType, _that.getTradeParty1ClearingBrokerIdType())) return false;
			if (!Objects.equals(tradeParty1DeskLocation, _that.getTradeParty1DeskLocation())) return false;
			if (!Objects.equals(tradeParty1Domicile, _that.getTradeParty1Domicile())) return false;
			if (!Objects.equals(tradeParty1IndustrialSectorType, _that.getTradeParty1IndustrialSectorType())) return false;
			if (!Objects.equals(tradeParty2BranchLocation, _that.getTradeParty2BranchLocation())) return false;
			if (!Objects.equals(tradeParty2DeskLocation, _that.getTradeParty2DeskLocation())) return false;
			if (!Objects.equals(tradeParty2Domicile, _that.getTradeParty2Domicile())) return false;
			if (!Objects.equals(tradeParty2IndustrialSectorType, _that.getTradeParty2IndustrialSectorType())) return false;
			if (!Objects.equals(sellerPayer2, _that.getSellerPayer2())) return false;
			if (!Objects.equals(buyerPayer1, _that.getBuyerPayer1())) return false;
			if (!Objects.equals(tradeParty1HkCounterpartyOrigin, _that.getTradeParty1HkCounterpartyOrigin())) return false;
			if (!Objects.equals(leg2SettlementDate, _that.getLeg2SettlementDate())) return false;
			if (!Objects.equals(leg1FixedRateInitial, _that.getLeg1FixedRateInitial())) return false;
			if (!Objects.equals(leg2FixedRateInitial, _that.getLeg2FixedRateInitial())) return false;
			if (!Objects.equals(payment1Amount, _that.getPayment1Amount())) return false;
			if (!Objects.equals(payment1Currency, _that.getPayment1Currency())) return false;
			if (!Objects.equals(payment1Payer, _that.getPayment1Payer())) return false;
			if (!Objects.equals(payment1Receiver, _that.getPayment1Receiver())) return false;
			if (!Objects.equals(payment2Payer, _that.getPayment2Payer())) return false;
			if (!Objects.equals(postTradeTransactionDate, _that.getPostTradeTransactionDate())) return false;
			if (!Objects.equals(secondaryAssetClass, _that.getSecondaryAssetClass())) return false;
			if (!Objects.equals(settlementType, _that.getSettlementType())) return false;
			if (!Objects.equals(tradeParty1Name, _that.getTradeParty1Name())) return false;
			if (!Objects.equals(tradeParty2Name, _that.getTradeParty2Name())) return false;
			if (!Objects.equals(ccpValuationAmount, _that.getCcpValuationAmount())) return false;
			if (!Objects.equals(ccpValuationCurrency, _that.getCcpValuationCurrency())) return false;
			if (!Objects.equals(ccpValuationDatetime, _that.getCcpValuationDatetime())) return false;
			if (!Objects.equals(ccpValuationType, _that.getCcpValuationType())) return false;
			if (!Objects.equals(tradeParty1ValuationAmount, _that.getTradeParty1ValuationAmount())) return false;
			if (!Objects.equals(tradeParty1ValuationCurrency, _that.getTradeParty1ValuationCurrency())) return false;
			if (!Objects.equals(tradeParty1ValuationDatetime, _that.getTradeParty1ValuationDatetime())) return false;
			if (!Objects.equals(tradeParty1ValuationType, _that.getTradeParty1ValuationType())) return false;
			if (!Objects.equals(tradeParty2ValuationAmount, _that.getTradeParty2ValuationAmount())) return false;
			if (!Objects.equals(tradeParty2ValuationCurrency, _that.getTradeParty2ValuationCurrency())) return false;
			if (!Objects.equals(tradeParty2ValuationDatetime, _that.getTradeParty2ValuationDatetime())) return false;
			if (!Objects.equals(tradeParty2ValuationType, _that.getTradeParty2ValuationType())) return false;
			if (!Objects.equals(executionType, _that.getExecutionType())) return false;
			if (!Objects.equals(strikePriceCurrency, _that.getStrikePriceCurrency())) return false;
			if (!Objects.equals(payment2Amount, _that.getPayment2Amount())) return false;
			if (!Objects.equals(tradeParty2HkCounterpartyOrigin, _that.getTradeParty2HkCounterpartyOrigin())) return false;
			if (!Objects.equals(tradeParty1CountryOfTheOtherCounterparty, _that.getTradeParty1CountryOfTheOtherCounterparty())) return false;
			if (!Objects.equals(tradeParty2CountryOfTheOtherCounterparty, _that.getTradeParty2CountryOfTheOtherCounterparty())) return false;
			if (!Objects.equals(tradeParty1BrokerId, _that.getTradeParty1BrokerId())) return false;
			if (!Objects.equals(tradeParty2BrokerId, _that.getTradeParty2BrokerId())) return false;
			if (!Objects.equals(tradeParty1BeneficiaryIdType, _that.getTradeParty1BeneficiaryIdType())) return false;
			if (!Objects.equals(tradeParty1BeneficiaryId, _that.getTradeParty1BeneficiaryId())) return false;
			if (!Objects.equals(tradeParty2BeneficiaryIdType, _that.getTradeParty2BeneficiaryIdType())) return false;
			if (!Objects.equals(tradeParty2BeneficiaryId, _that.getTradeParty2BeneficiaryId())) return false;
			if (!Objects.equals(tradeParty1CounterpartySide, _that.getTradeParty1CounterpartySide())) return false;
			if (!Objects.equals(tradeParty2CounterpartySide, _that.getTradeParty2CounterpartySide())) return false;
			if (!Objects.equals(tradeParty1CollateralPortfolioCode, _that.getTradeParty1CollateralPortfolioCode())) return false;
			if (!Objects.equals(tradeParty2CollateralPortfolioCode, _that.getTradeParty2CollateralPortfolioCode())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(euUnderlyingAssetIdType, _that.getEuUnderlyingAssetIdType())) return false;
			if (!Objects.equals(productClassification, _that.getProductClassification())) return false;
			if (!Objects.equals(complexTradeComponentId, _that.getComplexTradeComponentId())) return false;
			if (!Objects.equals(priceMultiplier, _that.getPriceMultiplier())) return false;
			if (!Objects.equals(quantity, _that.getQuantity())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(confirmationDatetime, _that.getConfirmationDatetime())) return false;
			if (!Objects.equals(clearingDatetime, _that.getClearingDatetime())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			if (!Objects.equals(productClassificationType, _that.getProductClassificationType())) return false;
			if (!Objects.equals(productIdentificationType, _that.getProductIdentificationType())) return false;
			if (!Objects.equals(productIdentification, _that.getProductIdentification())) return false;
			if (!Objects.equals(euUnderlyingAssetId, _that.getEuUnderlyingAssetId())) return false;
			if (!Objects.equals(reportTrackingNumber, _that.getReportTrackingNumber())) return false;
			if (!Objects.equals(tradeParty1BrokerIdType, _that.getTradeParty1BrokerIdType())) return false;
			if (!Objects.equals(tradeParty2BrokerIdType, _that.getTradeParty2BrokerIdType())) return false;
			if (!Objects.equals(tradeParty2ClearingBrokerIdType, _that.getTradeParty2ClearingBrokerIdType())) return false;
			if (!Objects.equals(tradeParty2ClearingBrokerId, _that.getTradeParty2ClearingBrokerId())) return false;
			if (!Objects.equals(tradeParty1ClearingThreshold, _that.getTradeParty1ClearingThreshold())) return false;
			if (!Objects.equals(tradeParty2ClearingThreshold, _that.getTradeParty2ClearingThreshold())) return false;
			if (!Objects.equals(tradeParty1CorporateSectorType, _that.getTradeParty1CorporateSectorType())) return false;
			if (!Objects.equals(tradeParty2CorporateSectorType, _that.getTradeParty2CorporateSectorType())) return false;
			if (!Objects.equals(tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator, _that.getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator())) return false;
			if (!Objects.equals(tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator, _that.getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator())) return false;
			if (!Objects.equals(intragroupIndicator, _that.getIntragroupIndicator())) return false;
			if (!Objects.equals(tradeParty1TradingCapacity1, _that.getTradeParty1TradingCapacity1())) return false;
			if (!Objects.equals(tradeParty2TradingCapacity1, _that.getTradeParty2TradingCapacity1())) return false;
			if (!Objects.equals(currencyOfPrice, _that.getCurrencyOfPrice())) return false;
			if (!Objects.equals(tradeParty1CollateralPortfolio, _that.getTradeParty1CollateralPortfolio())) return false;
			if (!Objects.equals(tradeParty2CollateralPortfolio, _that.getTradeParty2CollateralPortfolio())) return false;
			if (!Objects.equals(executionVenueMicCode, _that.getExecutionVenueMicCode())) return false;
			if (!Objects.equals(payment2Currency, _that.getPayment2Currency())) return false;
			if (!Objects.equals(expirationDateTimeBusinessCenter, _that.getExpirationDateTimeBusinessCenter())) return false;
			if (!Objects.equals(expirationTime, _that.getExpirationTime())) return false;
			if (!Objects.equals(expirationTimeType, _that.getExpirationTimeType())) return false;
			if (!Objects.equals(tradeParty1TraderLocation, _that.getTradeParty1TraderLocation())) return false;
			if (!Objects.equals(tradeParty2TraderLocation, _that.getTradeParty2TraderLocation())) return false;
			if (!Objects.equals(payment3ResetFrequencyPeriodMultiplier, _that.getPayment3ResetFrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(payment3ResetFrequencyPeriod, _that.getPayment3ResetFrequencyPeriod())) return false;
			if (!Objects.equals(payment4ResetFrequencyPeriodMultiplier, _that.getPayment4ResetFrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(payment4ResetFrequencyPeriod, _that.getPayment4ResetFrequencyPeriod())) return false;
			if (!Objects.equals(payment5ResetFrequencyPeriodMultiplier, _that.getPayment5ResetFrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(payment5ResetFrequencyPeriod, _that.getPayment5ResetFrequencyPeriod())) return false;
			if (!Objects.equals(payment1Type, _that.getPayment1Type())) return false;
			if (!Objects.equals(payment1Reference, _that.getPayment1Reference())) return false;
			if (!Objects.equals(payment2Type, _that.getPayment2Type())) return false;
			if (!Objects.equals(payment2Reference, _that.getPayment2Reference())) return false;
			if (!Objects.equals(payment3Payer, _that.getPayment3Payer())) return false;
			if (!Objects.equals(payment3Reference, _that.getPayment3Reference())) return false;
			if (!Objects.equals(payment3FrequencyPeriod, _that.getPayment3FrequencyPeriod())) return false;
			if (!Objects.equals(payment3FrequencyPeriodMultiplier, _that.getPayment3FrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(payment3Date, _that.getPayment3Date())) return false;
			if (!Objects.equals(payment4Reference, _that.getPayment4Reference())) return false;
			if (!Objects.equals(payment4Payer, _that.getPayment4Payer())) return false;
			if (!Objects.equals(payment4FrequencyPeriod, _that.getPayment4FrequencyPeriod())) return false;
			if (!Objects.equals(payment4FrequencyPeriodMultiplier, _that.getPayment4FrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(payment4Date, _that.getPayment4Date())) return false;
			if (!Objects.equals(payment5Reference, _that.getPayment5Reference())) return false;
			if (!Objects.equals(payment5Payer, _that.getPayment5Payer())) return false;
			if (!Objects.equals(payment5FrequencyPeriod, _that.getPayment5FrequencyPeriod())) return false;
			if (!Objects.equals(payment5FrequencyPeriodMultiplier, _that.getPayment5FrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(payment5Date, _that.getPayment5Date())) return false;
			if (!Objects.equals(payment3Type, _that.getPayment3Type())) return false;
			if (!Objects.equals(premiumPayer, _that.getPremiumPayer())) return false;
			if (!Objects.equals(premiumPaymentDateUnadjusted, _that.getPremiumPaymentDateUnadjusted())) return false;
			if (!Objects.equals(tradeParty1NatureOfTheReportingCounterparty, _that.getTradeParty1NatureOfTheReportingCounterparty())) return false;
			if (!Objects.equals(tradeParty2NatureOfTheReportingCounterparty, _that.getTradeParty2NatureOfTheReportingCounterparty())) return false;
			if (!Objects.equals(reservedParticipantUse1, _that.getReservedParticipantUse1())) return false;
			if (!Objects.equals(reservedParticipantUse2, _that.getReservedParticipantUse2())) return false;
			if (!Objects.equals(reservedParticipantUse3, _that.getReservedParticipantUse3())) return false;
			if (!Objects.equals(reservedParticipantUse4, _that.getReservedParticipantUse4())) return false;
			if (!Objects.equals(reservedParticipantUse5, _that.getReservedParticipantUse5())) return false;
			if (!Objects.equals(leg1TerminationDate, _that.getLeg1TerminationDate())) return false;
			if (!Objects.equals(allocationType, _that.getAllocationType())) return false;
			if (!Objects.equals(calculationBasis, _that.getCalculationBasis())) return false;
			if (!Objects.equals(clearingExceptionPartyId, _that.getClearingExceptionPartyId())) return false;
			if (!Objects.equals(clearingExceptionPartyIdType, _that.getClearingExceptionPartyIdType())) return false;
			if (!Objects.equals(clearingExceptionType, _that.getClearingExceptionType())) return false;
			if (!Objects.equals(clearingMemberClientAccountId, _that.getClearingMemberClientAccountId())) return false;
			if (!Objects.equals(clearingReceiptDatetime, _that.getClearingReceiptDatetime())) return false;
			if (!Objects.equals(clearingSwapSdrLeiId, _that.getClearingSwapSdrLeiId())) return false;
			if (!Objects.equals(clearingSwapUtiId, _that.getClearingSwapUtiId())) return false;
			if (!Objects.equals(collateralReportingDate, _that.getCollateralReportingDate())) return false;
			if (!Objects.equals(collateralValuationDatetime, _that.getCollateralValuationDatetime())) return false;
			if (!Objects.equals(comment2, _that.getComment2())) return false;
			if (!Objects.equals(commodityStrikePriceUnit, _that.getCommodityStrikePriceUnit())) return false;
			if (!Objects.equals(executionAgentMaskingIndicator, _that.getExecutionAgentMaskingIndicator())) return false;
			if (!Objects.equals(feeInCurrency, _that.getFeeInCurrency())) return false;
			if (!Objects.equals(feeOutCurrency, _that.getFeeOutCurrency())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyLeg1Multiplier, _that.getFloatingRatePaymentFrequencyLeg1Multiplier())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyLeg1TimePeriod, _that.getFloatingRatePaymentFrequencyLeg1TimePeriod())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyLeg2Multiplier, _that.getFloatingRatePaymentFrequencyLeg2Multiplier())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyLeg2TimePeriod, _that.getFloatingRatePaymentFrequencyLeg2TimePeriod())) return false;
			if (!Objects.equals(frequencyOfPayment, _that.getFrequencyOfPayment())) return false;
			if (!Objects.equals(interaffiliate, _that.getInteraffiliate())) return false;
			if (!Objects.equals(largeTradeIndicator, _that.getLargeTradeIndicator())) return false;
			if (!Objects.equals(leg1EffectiveDateAdjusted, _that.getLeg1EffectiveDateAdjusted())) return false;
			if (!Objects.equals(leg1FinalValuationDate, _that.getLeg1FinalValuationDate())) return false;
			if (!Objects.equals(leg1SettlementPeriod, _that.getLeg1SettlementPeriod())) return false;
			if (!Objects.equals(leg2EffectiveDateAdjusted, _that.getLeg2EffectiveDateAdjusted())) return false;
			if (!Objects.equals(leg2PaymentTermsFrequencyPeriod, _that.getLeg2PaymentTermsFrequencyPeriod())) return false;
			if (!Objects.equals(leg2PaymentTermsPaymentFrequencyPeriodMultiplier, _that.getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier())) return false;
			if (!Objects.equals(leg2SettlementType, _that.getLeg2SettlementType())) return false;
			if (!Objects.equals(leg2UnderlyingAssetId, _that.getLeg2UnderlyingAssetId())) return false;
			if (!Objects.equals(leg2UnderlyingAssetIdType, _that.getLeg2UnderlyingAssetIdType())) return false;
			if (!Objects.equals(leg2UnderlyingAssetName, _that.getLeg2UnderlyingAssetName())) return false;
			if (!Objects.equals(maturityDate, _that.getMaturityDate())) return false;
			if (!Objects.equals(optionalEarlyTerminationDate, _that.getOptionalEarlyTerminationDate())) return false;
			if (!Objects.equals(optionCommodityCurrency, _that.getOptionCommodityCurrency())) return false;
			if (!Objects.equals(optionCommodityExchangeId, _that.getOptionCommodityExchangeId())) return false;
			if (!Objects.equals(optionCommodityInstrumentId, _that.getOptionCommodityInstrumentId())) return false;
			if (!Objects.equals(optionCommodityRateSource, _that.getOptionCommodityRateSource())) return false;
			if (!Objects.equals(optionCommodityRateSourcePage, _that.getOptionCommodityRateSourcePage())) return false;
			if (!Objects.equals(optionCommodityUnderlyerDetails, _that.getOptionCommodityUnderlyerDetails())) return false;
			if (!Objects.equals(optionCommodityUnderlyerId, _that.getOptionCommodityUnderlyerId())) return false;
			if (!Objects.equals(optionCommodityUnitOfMeasure, _that.getOptionCommodityUnitOfMeasure())) return false;
			if (!Objects.equals(optionSpecifiedPrice, _that.getOptionSpecifiedPrice())) return false;
			if (!Objects.equals(optionSpreadAmount, _that.getOptionSpreadAmount())) return false;
			if (!Objects.equals(optionSpreadCurrency, _that.getOptionSpreadCurrency())) return false;
			if (!Objects.equals(optionSpreadSchedule, _that.getOptionSpreadSchedule())) return false;
			if (!Objects.equals(origin, _that.getOrigin())) return false;
			if (!Objects.equals(originalSwapSdrId, _that.getOriginalSwapSdrId())) return false;
			if (!Objects.equals(originalSwapSdrIdType, _that.getOriginalSwapSdrIdType())) return false;
			if (!Objects.equals(paymentFrequencyPeriodLeg1, _that.getPaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(paymentFrequencyPeriodLeg2, _that.getPaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(paymentFrequencyPeriodMultiplierLeg1, _that.getPaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(paymentFrequencyPeriodMultiplierLeg2, _that.getPaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(premiumPayerPrefix, _that.getPremiumPayerPrefix())) return false;
			if (!Objects.equals(price1Currency, _that.getPrice1Currency())) return false;
			if (!Objects.equals(price2Price, _that.getPrice2Price())) return false;
			if (!Objects.equals(price2Type, _that.getPrice2Type())) return false;
			if (!Objects.equals(price2Units, _that.getPrice2Units())) return false;
			if (!Objects.equals(price3Price, _that.getPrice3Price())) return false;
			if (!Objects.equals(price3Type, _that.getPrice3Type())) return false;
			if (!Objects.equals(price3Units, _that.getPrice3Units())) return false;
			if (!Objects.equals(price4Price, _that.getPrice4Price())) return false;
			if (!Objects.equals(price4Type, _that.getPrice4Type())) return false;
			if (!Objects.equals(price4Units, _that.getPrice4Units())) return false;
			if (!Objects.equals(pricingContext, _that.getPricingContext())) return false;
			if (!Objects.equals(priorUsiType, _that.getPriorUsiType())) return false;
			if (!Objects.equals(priorUtiType, _that.getPriorUtiType())) return false;
			if (!Objects.equals(recoveryPrice, _that.getRecoveryPrice())) return false;
			if (!Objects.equals(sendToDataCenterCode, _that.getSendToDataCenterCode())) return false;
			if (!Objects.equals(strikePriceType, _that.getStrikePriceType())) return false;
			if (!Objects.equals(subAssetClassForOtherCommodity, _that.getSubAssetClassForOtherCommodity())) return false;
			if (!Objects.equals(tradeParty1CftcFinancialEntityStatus, _that.getTradeParty1CftcFinancialEntityStatus())) return false;
			if (!Objects.equals(tradeParty1CollateralAmount, _that.getTradeParty1CollateralAmount())) return false;
			if (!Objects.equals(tradeParty1CollateralCurrency, _that.getTradeParty1CollateralCurrency())) return false;
			if (!Objects.equals(tradeParty1MandatoryDelegatedReporting, _that.getTradeParty1MandatoryDelegatedReporting())) return false;
			if (!Objects.equals(tradeParty1Role, _that.getTradeParty1Role())) return false;
			if (!Objects.equals(tradeParty2CftcFinancialEntityStatus, _that.getTradeParty2CftcFinancialEntityStatus())) return false;
			if (!Objects.equals(tradeParty2CollateralAmount, _that.getTradeParty2CollateralAmount())) return false;
			if (!Objects.equals(tradeParty2CollateralCurrency, _that.getTradeParty2CollateralCurrency())) return false;
			if (!Objects.equals(tradeParty2MandatoryDelegatedReporting, _that.getTradeParty2MandatoryDelegatedReporting())) return false;
			if (!Objects.equals(tradeParty2Role, _that.getTradeParty2Role())) return false;
			if (!Objects.equals(upfrontPayment, _that.getUpfrontPayment())) return false;
			if (!Objects.equals(verificationMethod, _that.getVerificationMethod())) return false;
			if (!Objects.equals(responsibleDataSubmitterId, _that.getResponsibleDataSubmitterId())) return false;
			if (!Objects.equals(responsibleDataSubmitterIdType, _that.getResponsibleDataSubmitterIdType())) return false;
			if (!Objects.equals(originalSwapUsi, _that.getOriginalSwapUsi())) return false;
			if (!Objects.equals(originalSwapUti, _that.getOriginalSwapUti())) return false;
			if (!Objects.equals(cdeReceiverIdentifierLeg2, _that.getCdeReceiverIdentifierLeg2())) return false;
			if (!Objects.equals(counterparty1FederalEntityIndicator, _that.getCounterparty1FederalEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FederalEntityIndicator, _that.getCounterparty2FederalEntityIndicator())) return false;
			if (!Objects.equals(customBasketIndicator, _that.getCustomBasketIndicator())) return false;
			if (!Objects.equals(noaActionType, _that.getNoaActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(amendmentIndicator, _that.getAmendmentIndicator())) return false;
			if (!Objects.equals(eventIdentifier, _that.getEventIdentifier())) return false;
			if (!Objects.equals(cdeCallAmountLeg1, _that.getCdeCallAmountLeg1())) return false;
			if (!Objects.equals(cdeCallAmountLeg2, _that.getCdeCallAmountLeg2())) return false;
			if (!Objects.equals(cdeCallCurrencyLeg1, _that.getCdeCallCurrencyLeg1())) return false;
			if (!Objects.equals(cdeCallCurrencyLeg2, _that.getCdeCallCurrencyLeg2())) return false;
			if (!Objects.equals(cdePutAmountLeg1, _that.getCdePutAmountLeg1())) return false;
			if (!Objects.equals(cdePutAmountLeg2, _that.getCdePutAmountLeg2())) return false;
			if (!Objects.equals(cdePutCurrencyLeg1, _that.getCdePutCurrencyLeg1())) return false;
			if (!Objects.equals(cdePutCurrencyLeg2, _that.getCdePutCurrencyLeg2())) return false;
			if (!Objects.equals(leg2QuantityFrequency, _that.getLeg2QuantityFrequency())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierLeg1, _that.getQuantityFrequencyMultiplierLeg1())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierLeg2, _that.getQuantityFrequencyMultiplierLeg2())) return false;
			if (!Objects.equals(cdeQuantityUnitOfMeasureLeg1, _that.getCdeQuantityUnitOfMeasureLeg1())) return false;
			if (!Objects.equals(cdeQuantityUnitOfMeasureLeg2, _that.getCdeQuantityUnitOfMeasureLeg2())) return false;
			if (!Objects.equals(packageIndicator, _that.getPackageIndicator())) return false;
			if (!Objects.equals(cdePackageIdentifier, _that.getCdePackageIdentifier())) return false;
			if (!Objects.equals(cdePackageTransactionPrice, _that.getCdePackageTransactionPrice())) return false;
			if (!Objects.equals(cdePackageTransactionPriceCurrency, _that.getCdePackageTransactionPriceCurrency())) return false;
			if (!Objects.equals(cdePackageTransactionPriceNotation, _that.getCdePackageTransactionPriceNotation())) return false;
			if (!Objects.equals(cdePackageTransactionSpread, _that.getCdePackageTransactionSpread())) return false;
			if (!Objects.equals(cdePackageTransactionSpreadCurrency, _that.getCdePackageTransactionSpreadCurrency())) return false;
			if (!Objects.equals(cdePackageTransactionSpreadNotation, _that.getCdePackageTransactionSpreadNotation())) return false;
			if (!Objects.equals(cdeFixedRateDayCountConventionLeg1, _that.getCdeFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(cdeFixedRateDayCountConventionLeg2, _that.getCdeFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(cdeFloatingRateDayCountConventionLeg1, _that.getCdeFloatingRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(cdeFloatingRateDayCountConventionLeg2, _that.getCdeFloatingRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(fixingDateLeg1, _that.getFixingDateLeg1())) return false;
			if (!Objects.equals(fixingDateLeg2, _that.getFixingDateLeg2())) return false;
			if (!Objects.equals(cdeFixedRatePaymentFrequencyPeriodLeg1, _that.getCdeFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(cdeFixedRatePaymentFrequencyPeriodLeg2, _that.getCdeFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(cdeFloatingRatePaymentFrequencyPeriodLeg1, _that.getCdeFloatingRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(cdeFloatingRatePaymentFrequencyPeriodLeg2, _that.getCdeFloatingRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1, _that.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2, _that.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(postPricedSwapIndicator, _that.getPostPricedSwapIndicator())) return false;
			if (!Objects.equals(cdePriceCurrency, _that.getCdePriceCurrency())) return false;
			if (!Objects.equals(cdePriceNotation, _that.getCdePriceNotation())) return false;
			if (!Objects.equals(cdeSpreadNotationLeg1, _that.getCdeSpreadNotationLeg1())) return false;
			if (!Objects.equals(cdeSpreadNotationLeg2, _that.getCdeSpreadNotationLeg2())) return false;
			if (!Objects.equals(cdeStrikePriceCurrency2, _that.getCdeStrikePriceCurrency2())) return false;
			if (!Objects.equals(cdeStrikePriceNotation, _that.getCdeStrikePriceNotation())) return false;
			if (!Objects.equals(cdeFirstExerciseDate, _that.getCdeFirstExerciseDate())) return false;
			if (!Objects.equals(cdeFinalContractualSettlementDate, _that.getCdeFinalContractualSettlementDate())) return false;
			if (!Objects.equals(cdeSettlementLocationLeg1, _that.getCdeSettlementLocationLeg1())) return false;
			if (!Objects.equals(cdeSettlementLocationLeg2, _that.getCdeSettlementLocationLeg2())) return false;
			if (!Objects.equals(cdeEffectiveDate, _that.getCdeEffectiveDate())) return false;
			if (!Objects.equals(cdeExpirationDate, _that.getCdeExpirationDate())) return false;
			if (!Objects.equals(cdePlatformIdentifier, _that.getCdePlatformIdentifier())) return false;
			if (!Objects.equals(primeBrokerageTransactionIndicator, _that.getPrimeBrokerageTransactionIndicator())) return false;
			if (!Objects.equals(swapReportingJurisdiction, _that.getSwapReportingJurisdiction())) return false;
			if (!Objects.equals(newSdrIdentifier, _that.getNewSdrIdentifier())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(lastFloatingReferenceValueLeg1, _that.getLastFloatingReferenceValueLeg1())) return false;
			if (!Objects.equals(lastFloatingReferenceResetDateLeg1, _that.getLastFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) return false;
			if (!Objects.equals(lastFloatingReferenceValueLeg2, _that.getLastFloatingReferenceValueLeg2())) return false;
			if (!Objects.equals(lastFloatingReferenceResetDateLeg2, _that.getLastFloatingReferenceResetDateLeg2())) return false;
			if (!Objects.equals(cdeDelta, _that.getCdeDelta())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(largeNotionalOffFacilitySwapElectionIndicator, _that.getLargeNotionalOffFacilitySwapElectionIndicator())) return false;
			if (!Objects.equals(sefOrDcmAnonymousExecutionIndicator, _that.getSefOrDcmAnonymousExecutionIndicator())) return false;
			if (!Objects.equals(blockTradeElectionIndicator, _that.getBlockTradeElectionIndicator())) return false;
			if (!Objects.equals(sefOrDcmIndicator, _that.getSefOrDcmIndicator())) return false;
			if (!Objects.equals(mandatoryClearingIndicator, _that.getMandatoryClearingIndicator())) return false;
			if (!Objects.equals(sdMspIndicatorCounterparty1, _that.getSdMspIndicatorCounterparty1())) return false;
			if (!Objects.equals(sdMspIndicatorCounterparty2, _that.getSdMspIndicatorCounterparty2())) return false;
			if (!Objects.equals(physicalCommodityContractIndicator, _that.getPhysicalCommodityContractIndicator())) return false;
			if (!Objects.equals(changeInNotionalAmount1, _that.getChangeInNotionalAmount1())) return false;
			if (!Objects.equals(changeInNotionalAmount2, _that.getChangeInNotionalAmount2())) return false;
			if (!Objects.equals(changeInLeg1NotionalQuantity, _that.getChangeInLeg1NotionalQuantity())) return false;
			if (!Objects.equals(changeInLeg2NotionalQuantity, _that.getChangeInLeg2NotionalQuantity())) return false;
			if (!Objects.equals(cdeCryptoAssetUnderlyingIndicatorLeg1, _that.getCdeCryptoAssetUnderlyingIndicatorLeg1())) return false;
			if (!Objects.equals(cdeCryptoAssetUnderlyingIndicatorLeg2, _that.getCdeCryptoAssetUnderlyingIndicatorLeg2())) return false;
			if (!Objects.equals(cdeCustomBasketCode, _that.getCdeCustomBasketCode())) return false;
			if (!Objects.equals(underlierIdOtherLeg1, _that.getUnderlierIdOtherLeg1())) return false;
			if (!Objects.equals(underlierIdOtherLeg2, _that.getUnderlierIdOtherLeg2())) return false;
			if (!Objects.equals(underlierIdOtherSourceLeg1, _that.getUnderlierIdOtherSourceLeg1())) return false;
			if (!Objects.equals(underlierIdOtherSourceLeg2, _that.getUnderlierIdOtherSourceLeg2())) return false;
			if (!Objects.equals(cdeUnderlyingAssetTradingPlatformIdLeg1, _that.getCdeUnderlyingAssetTradingPlatformIdLeg1())) return false;
			if (!Objects.equals(cdeUnderlyingAssetTradingPlatformIdLeg2, _that.getCdeUnderlyingAssetTradingPlatformIdLeg2())) return false;
			if (!Objects.equals(cdeUnderlyingAssetPriceSourceLeg1, _that.getCdeUnderlyingAssetPriceSourceLeg1())) return false;
			if (!Objects.equals(cdeUnderlyingAssetPriceSourceLeg2, _that.getCdeUnderlyingAssetPriceSourceLeg2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (leg2CommodityInstrumentId != null ? leg2CommodityInstrumentId.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityUnderlyerId != null ? leg2CommodityUnderlyerId.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityUnderlyerDetails != null ? leg2CommodityUnderlyerDetails.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityUnitOfMeasure != null ? leg2CommodityUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityCurrency != null ? leg2CommodityCurrency.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityExchangeId != null ? leg2CommodityExchangeId.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityRateSource != null ? leg1CommodityRateSource.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityRateSourcePage != null ? leg1CommodityRateSourcePage.hashCode() : 0);
			_result = 31 * _result + (leg2SpecifiedPrice != null ? leg2SpecifiedPrice.hashCode() : 0);
			_result = 31 * _result + (commencementDateUnadjusted != null ? commencementDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (exerciseExpirationDateUnadjusted != null ? exerciseExpirationDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (expirationDateUnadjusted != null ? expirationDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (leg2NotionalQuantityFrequency != null ? leg2NotionalQuantityFrequency.hashCode() : 0);
			_result = 31 * _result + (leg2NotionalQuantity != null ? leg2NotionalQuantity.hashCode() : 0);
			_result = 31 * _result + (leg2TotalNotionalQuantity != null ? leg2TotalNotionalQuantity.hashCode() : 0);
			_result = 31 * _result + (leg2SpreadAmount != null ? leg2SpreadAmount.hashCode() : 0);
			_result = 31 * _result + (leg2SpreadCurrency != null ? leg2SpreadCurrency.hashCode() : 0);
			_result = 31 * _result + (scheduledTerminationDateAdjusted != null ? scheduledTerminationDateAdjusted.hashCode() : 0);
			_result = 31 * _result + (leg1PartyPayer != null ? leg1PartyPayer.hashCode() : 0);
			_result = 31 * _result + (leg2PartyPayer != null ? leg2PartyPayer.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityInstrumentId != null ? leg1CommodityInstrumentId.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityUnderlyerId != null ? leg1CommodityUnderlyerId.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityUnitOfMeasure != null ? leg1CommodityUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityExchangeId != null ? leg1CommodityExchangeId.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityRateSource != null ? leg2CommodityRateSource.hashCode() : 0);
			_result = 31 * _result + (leg1EffectiveDateUnadjusted != null ? leg1EffectiveDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (leg2EffectiveDateUnadjusted != null ? leg2EffectiveDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (coProductType != null ? coProductType.hashCode() : 0);
			_result = 31 * _result + (totalQuantityUnit != null ? totalQuantityUnit.hashCode() : 0);
			_result = 31 * _result + (totalQuantity != null ? totalQuantity.hashCode() : 0);
			_result = 31 * _result + (fixedPrice != null ? fixedPrice.hashCode() : 0);
			_result = 31 * _result + (fixedPriceCurrency != null ? fixedPriceCurrency.hashCode() : 0);
			_result = 31 * _result + (leg1NotionalQuantityUnit != null ? leg1NotionalQuantityUnit.hashCode() : 0);
			_result = 31 * _result + (leg1NotionalQuantityFrequency != null ? leg1NotionalQuantityFrequency.hashCode() : 0);
			_result = 31 * _result + (leg1NotionalQuantity != null ? leg1NotionalQuantity.hashCode() : 0);
			_result = 31 * _result + (leg1TotalNotionalQuantity != null ? leg1TotalNotionalQuantity.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityCurrency != null ? leg1CommodityCurrency.hashCode() : 0);
			_result = 31 * _result + (leg1SpecifiedPrice != null ? leg1SpecifiedPrice.hashCode() : 0);
			_result = 31 * _result + (leg1SpreadCurrency != null ? leg1SpreadCurrency.hashCode() : 0);
			_result = 31 * _result + (leg1SpreadAmount != null ? leg1SpreadAmount.hashCode() : 0);
			_result = 31 * _result + (leg2NotionalQuantityUnit != null ? leg2NotionalQuantityUnit.hashCode() : 0);
			_result = 31 * _result + (leg2PartyReceiver != null ? leg2PartyReceiver.hashCode() : 0);
			_result = 31 * _result + (leg1PartyReceiver != null ? leg1PartyReceiver.hashCode() : 0);
			_result = 31 * _result + (coalSource != null ? coalSource.hashCode() : 0);
			_result = 31 * _result + (leg2Quantity != null ? leg2Quantity.hashCode() : 0);
			_result = 31 * _result + (commodityBase != null ? commodityBase.hashCode() : 0);
			_result = 31 * _result + (commodityDetails != null ? commodityDetails.hashCode() : 0);
			_result = 31 * _result + (interconnectionPoint != null ? interconnectionPoint.hashCode() : 0);
			_result = 31 * _result + (loadType != null ? loadType.hashCode() : 0);
			_result = 31 * _result + (fixedPriceUnit != null ? fixedPriceUnit.hashCode() : 0);
			_result = 31 * _result + (exercisePaymentDateUnadjusted != null ? exercisePaymentDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (leg1PaymentDatesUnadjusted != null ? leg1PaymentDatesUnadjusted.hashCode() : 0);
			_result = 31 * _result + (leg2PaymentDateUnadjusted != null ? leg2PaymentDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (settlementDateUnadjusted != null ? settlementDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (deliveryLocation != null ? deliveryLocation.hashCode() : 0);
			_result = 31 * _result + (leg2QuantityUnit != null ? leg2QuantityUnit.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityUnderlyerDetails != null ? leg1CommodityUnderlyerDetails.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityRateSourcePage != null ? leg2CommodityRateSourcePage.hashCode() : 0);
			_result = 31 * _result + (valueDate != null ? valueDate.hashCode() : 0);
			_result = 31 * _result + (gtrQuantityUnit != null ? gtrQuantityUnit.hashCode() : 0);
			_result = 31 * _result + (attachmentPoint != null ? attachmentPoint.hashCode() : 0);
			_result = 31 * _result + (exhaustionPoint != null ? exhaustionPoint.hashCode() : 0);
			_result = 31 * _result + (mthToDefault != null ? mthToDefault.hashCode() : 0);
			_result = 31 * _result + (nthToDefault != null ? nthToDefault.hashCode() : 0);
			_result = 31 * _result + (seniority != null ? seniority.hashCode() : 0);
			_result = 31 * _result + (series != null ? series.hashCode() : 0);
			_result = 31 * _result + (crversion != null ? crversion.hashCode() : 0);
			_result = 31 * _result + (tranche != null ? tranche.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (referenceObligation != null ? referenceObligation.hashCode() : 0);
			_result = 31 * _result + (referenceObligationIdType != null ? referenceObligationIdType.hashCode() : 0);
			_result = 31 * _result + (underlyingFixedRatePayerBuyer != null ? underlyingFixedRatePayerBuyer.hashCode() : 0);
			_result = 31 * _result + (underlyingFloatRatePayerSeller != null ? underlyingFloatRatePayerSeller.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetExchangeId != null ? underlyingAssetExchangeId.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetNumberOfUnits != null ? underlyingAssetNumberOfUnits.hashCode() : 0);
			_result = 31 * _result + (optionalEarlyTerminationType != null ? optionalEarlyTerminationType.hashCode() : 0);
			_result = 31 * _result + (optionalEarlyTerminationElectingPartyValue != null ? optionalEarlyTerminationElectingPartyValue.hashCode() : 0);
			_result = 31 * _result + (optionalEarlyTerminationIndicator != null ? optionalEarlyTerminationIndicator.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetFloatingAmountPayer != null ? underlyingAssetFloatingAmountPayer.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetFloatingAmountReceiver != null ? underlyingAssetFloatingAmountReceiver.hashCode() : 0);
			_result = 31 * _result + (floatingRateOption != null ? floatingRateOption.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetFloatingLegSpread != null ? underlyingAssetFloatingLegSpread.hashCode() : 0);
			_result = 31 * _result + (leg2DesignatedMaturityPeriod != null ? leg2DesignatedMaturityPeriod.hashCode() : 0);
			_result = 31 * _result + (leg2DesignatedMaturityPeriodMultiplier != null ? leg2DesignatedMaturityPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetEquityAmountPayer != null ? underlyingAssetEquityAmountPayer.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetEquityAmountReceiver != null ? underlyingAssetEquityAmountReceiver.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetInitialPriceCurrency != null ? underlyingAssetInitialPriceCurrency.hashCode() : 0);
			_result = 31 * _result + (leg1ValuationDates != null ? leg1ValuationDates.hashCode() : 0);
			_result = 31 * _result + (leg1TypeOfReturn != null ? leg1TypeOfReturn.hashCode() : 0);
			_result = 31 * _result + (observationStartDate != null ? observationStartDate.hashCode() : 0);
			_result = 31 * _result + (varianceAmount != null ? varianceAmount.hashCode() : 0);
			_result = 31 * _result + (volatilityStrikePrice != null ? volatilityStrikePrice.hashCode() : 0);
			_result = 31 * _result + (varianceStrikePrice != null ? varianceStrikePrice.hashCode() : 0);
			_result = 31 * _result + (varianceCapFactor != null ? varianceCapFactor.hashCode() : 0);
			_result = 31 * _result + (referenceCurrency != null ? referenceCurrency.hashCode() : 0);
			_result = 31 * _result + (specialDividendsIndicator != null ? specialDividendsIndicator.hashCode() : 0);
			_result = 31 * _result + (materialNoncashDividendIndicator != null ? materialNoncashDividendIndicator.hashCode() : 0);
			_result = 31 * _result + (numberOfSharesUnits != null ? numberOfSharesUnits.hashCode() : 0);
			_result = 31 * _result + (dividendAmountPayer != null ? dividendAmountPayer.hashCode() : 0);
			_result = 31 * _result + (dividendAmountReceiver != null ? dividendAmountReceiver.hashCode() : 0);
			_result = 31 * _result + (fixedAmountPayer != null ? fixedAmountPayer.hashCode() : 0);
			_result = 31 * _result + (fixedAmountReceiver != null ? fixedAmountReceiver.hashCode() : 0);
			_result = 31 * _result + (knockInEvent != null ? knockInEvent.hashCode() : 0);
			_result = 31 * _result + (knockOutEvent != null ? knockOutEvent.hashCode() : 0);
			_result = 31 * _result + (knockInPrice != null ? knockInPrice.hashCode() : 0);
			_result = 31 * _result + (knockOutPrice != null ? knockOutPrice.hashCode() : 0);
			_result = 31 * _result + (barrierType != null ? barrierType.hashCode() : 0);
			_result = 31 * _result + (earliestExecutionTime != null ? earliestExecutionTime.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasisCurrency1 != null ? exchangeRateBasisCurrency1.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasisCurrency2 != null ? exchangeRateBasisCurrency2.hashCode() : 0);
			_result = 31 * _result + (executionPeriodStartDate != null ? executionPeriodStartDate.hashCode() : 0);
			_result = 31 * _result + (payoutStyle != null ? payoutStyle.hashCode() : 0);
			_result = 31 * _result + (rateQuoteBasis1 != null ? rateQuoteBasis1.hashCode() : 0);
			_result = 31 * _result + (settlementFixingDate != null ? settlementFixingDate.hashCode() : 0);
			_result = 31 * _result + (swapLinkId != null ? swapLinkId.hashCode() : 0);
			_result = 31 * _result + (triggerCondition != null ? triggerCondition.hashCode() : 0);
			_result = 31 * _result + (triggerCondition2 != null ? triggerCondition2.hashCode() : 0);
			_result = 31 * _result + (triggerRate != null ? triggerRate.hashCode() : 0);
			_result = 31 * _result + (triggerRate2 != null ? triggerRate2.hashCode() : 0);
			_result = 31 * _result + (rateQuoteBasis2 != null ? rateQuoteBasis2.hashCode() : 0);
			_result = 31 * _result + (forwardExchangeRate != null ? forwardExchangeRate.hashCode() : 0);
			_result = 31 * _result + (barrierType2 != null ? barrierType2.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionBuyer != null ? cancelationOptionBuyer.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionCommencementDate != null ? cancelationOptionCommencementDate.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionExerciseStyleType != null ? cancelationOptionExerciseStyleType.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionExpirationDate != null ? cancelationOptionExpirationDate.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionInitialFeeCurrency != null ? cancelationOptionInitialFeeCurrency.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionInitialFeePayer != null ? cancelationOptionInitialFeePayer.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionPremiumAmount != null ? cancelationOptionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (cancelationOptionSeller != null ? cancelationOptionSeller.hashCode() : 0);
			_result = 31 * _result + (capRateInitial != null ? capRateInitial.hashCode() : 0);
			_result = 31 * _result + (couponType != null ? couponType.hashCode() : 0);
			_result = 31 * _result + (finalPrincipalExchangeIndicatorAtTermination != null ? finalPrincipalExchangeIndicatorAtTermination.hashCode() : 0);
			_result = 31 * _result + (floorRateInitial != null ? floorRateInitial.hashCode() : 0);
			_result = 31 * _result + (fraDiscountingType != null ? fraDiscountingType.hashCode() : 0);
			_result = 31 * _result + (inflationIndexInitialLevel != null ? inflationIndexInitialLevel.hashCode() : 0);
			_result = 31 * _result + (inflationIndexMainPublication != null ? inflationIndexMainPublication.hashCode() : 0);
			_result = 31 * _result + (inflationInterpolationMethod != null ? inflationInterpolationMethod.hashCode() : 0);
			_result = 31 * _result + (inflationLagDayType != null ? inflationLagDayType.hashCode() : 0);
			_result = 31 * _result + (inflationLagPeriod != null ? inflationLagPeriod.hashCode() : 0);
			_result = 31 * _result + (inflationRateSourceName != null ? inflationRateSourceName.hashCode() : 0);
			_result = 31 * _result + (initialPrincipalExchangeIndicator != null ? initialPrincipalExchangeIndicator.hashCode() : 0);
			_result = 31 * _result + (intermediatePrincipalExchangeIndicator != null ? intermediatePrincipalExchangeIndicator.hashCode() : 0);
			_result = 31 * _result + (leg1FloatingRateIndex != null ? leg1FloatingRateIndex.hashCode() : 0);
			_result = 31 * _result + (leg1FloatingRateInitialSpread != null ? leg1FloatingRateInitialSpread.hashCode() : 0);
			_result = 31 * _result + (leg1FloatingRateMultiplierInitialValue != null ? leg1FloatingRateMultiplierInitialValue.hashCode() : 0);
			_result = 31 * _result + (leg1FloatingRateTenorPeriod != null ? leg1FloatingRateTenorPeriod.hashCode() : 0);
			_result = 31 * _result + (leg1FloatingRateTenorPeriodMultiplier != null ? leg1FloatingRateTenorPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (leg1KnownAmount != null ? leg1KnownAmount.hashCode() : 0);
			_result = 31 * _result + (leg1KnownAmountCurrency != null ? leg1KnownAmountCurrency.hashCode() : 0);
			_result = 31 * _result + (leg1ReferenceCurrency != null ? leg1ReferenceCurrency.hashCode() : 0);
			_result = 31 * _result + (leg2FloatingRateIndex != null ? leg2FloatingRateIndex.hashCode() : 0);
			_result = 31 * _result + (leg2FloatingRateInitialSpread != null ? leg2FloatingRateInitialSpread.hashCode() : 0);
			_result = 31 * _result + (leg2FloatingRateMultiplierInitialValue != null ? leg2FloatingRateMultiplierInitialValue.hashCode() : 0);
			_result = 31 * _result + (leg2FloatingRateTenorPeriod != null ? leg2FloatingRateTenorPeriod.hashCode() : 0);
			_result = 31 * _result + (leg2FloatingRateTenorPeriodMultiplier != null ? leg2FloatingRateTenorPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (leg2KnownAmount != null ? leg2KnownAmount.hashCode() : 0);
			_result = 31 * _result + (leg2KnownAmountCurrency != null ? leg2KnownAmountCurrency.hashCode() : 0);
			_result = 31 * _result + (leg2ReferenceCurrency != null ? leg2ReferenceCurrency.hashCode() : 0);
			_result = 31 * _result + (mandatoryEarlyTerminationDate != null ? mandatoryEarlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (mandatoryEarlyTerminationDateTenorPeriod != null ? mandatoryEarlyTerminationDateTenorPeriod.hashCode() : 0);
			_result = 31 * _result + (mandatoryEarlyTerminationDateTenorPeriodMultiplier != null ? mandatoryEarlyTerminationDateTenorPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (notionalUnits != null ? notionalUnits.hashCode() : 0);
			_result = 31 * _result + (optionalEarlyTerminationCommencementDate != null ? optionalEarlyTerminationCommencementDate.hashCode() : 0);
			_result = 31 * _result + (optionalEarlyTerminationExerciseStyle != null ? optionalEarlyTerminationExerciseStyle.hashCode() : 0);
			_result = 31 * _result + (optionalEarlyTerminationExpirationDate != null ? optionalEarlyTerminationExpirationDate.hashCode() : 0);
			_result = 31 * _result + (premiumReceiver != null ? premiumReceiver.hashCode() : 0);
			_result = 31 * _result + (underlyingCouponRate != null ? underlyingCouponRate.hashCode() : 0);
			_result = 31 * _result + (underlyingMaturityDate != null ? underlyingMaturityDate.hashCode() : 0);
			_result = 31 * _result + (underlyingProductId != null ? underlyingProductId.hashCode() : 0);
			_result = 31 * _result + (inflationLagPeriodMultiplier != null ? inflationLagPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (leg1FixedRateNotation != null ? leg1FixedRateNotation.hashCode() : 0);
			_result = 31 * _result + (leg2FixedRateNotation != null ? leg2FixedRateNotation.hashCode() : 0);
			_result = 31 * _result + (swaptionStraddleIndicator != null ? swaptionStraddleIndicator.hashCode() : 0);
			_result = 31 * _result + (singlePartyEarlyTerminationBuyer != null ? singlePartyEarlyTerminationBuyer.hashCode() : 0);
			_result = 31 * _result + (leg1EffectiveDate != null ? leg1EffectiveDate.hashCode() : 0);
			_result = 31 * _result + (action != null ? action.hashCode() : 0);
			_result = 31 * _result + (clearingStatus != null ? clearingStatus.hashCode() : 0);
			_result = 31 * _result + (effectiveDate1 != null ? effectiveDate1.hashCode() : 0);
			_result = 31 * _result + (executionVenueType != null ? executionVenueType.hashCode() : 0);
			_result = 31 * _result + (nonStandardTradeIndicator != null ? nonStandardTradeIndicator.hashCode() : 0);
			_result = 31 * _result + (notionalAmount1 != null ? notionalAmount1.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency1 != null ? notionalCurrency1.hashCode() : 0);
			_result = 31 * _result + (price1Price != null ? price1Price.hashCode() : 0);
			_result = 31 * _result + (price1Type != null ? price1Type.hashCode() : 0);
			_result = 31 * _result + (price1Units != null ? price1Units.hashCode() : 0);
			_result = 31 * _result + (scheduledTerminationDate1 != null ? scheduledTerminationDate1.hashCode() : 0);
			_result = 31 * _result + (tradeDate != null ? tradeDate.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CollateralizationType != null ? tradeParty1CollateralizationType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1EventId != null ? tradeParty1EventId.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CollateralizationType != null ? tradeParty2CollateralizationType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2EventId != null ? tradeParty2EventId.hashCode() : 0);
			_result = 31 * _result + (embeddedOptionOnSwap != null ? embeddedOptionOnSwap.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (notionalAmount2 != null ? notionalAmount2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency2 != null ? notionalCurrency2.hashCode() : 0);
			_result = 31 * _result + (premiumAmount != null ? premiumAmount.hashCode() : 0);
			_result = 31 * _result + (premiumCurrency != null ? premiumCurrency.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (comment1 != null ? comment1.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency1 != null ? settlementCurrency1.hashCode() : 0);
			_result = 31 * _result + (commencementDate != null ? commencementDate.hashCode() : 0);
			_result = 31 * _result + (dayCountFraction1 != null ? dayCountFraction1.hashCode() : 0);
			_result = 31 * _result + (leg2DayCountFraction != null ? leg2DayCountFraction.hashCode() : 0);
			_result = 31 * _result + (leg2EffectiveDate != null ? leg2EffectiveDate.hashCode() : 0);
			_result = 31 * _result + (leg2ResetFrequencyPeriod != null ? leg2ResetFrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (leg2ResetFrequencyPeriodMultiplier != null ? leg2ResetFrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (leg2SettlementCurrency != null ? leg2SettlementCurrency.hashCode() : 0);
			_result = 31 * _result + (leg2ScheduledTerminationDate != null ? leg2ScheduledTerminationDate.hashCode() : 0);
			_result = 31 * _result + (numberOfOptions != null ? numberOfOptions.hashCode() : 0);
			_result = 31 * _result + (optionEntitlement != null ? optionEntitlement.hashCode() : 0);
			_result = 31 * _result + (originalExecutionTimestamp != null ? originalExecutionTimestamp.hashCode() : 0);
			_result = 31 * _result + (payment1Date != null ? payment1Date.hashCode() : 0);
			_result = 31 * _result + (payment1FrequencyPeriod != null ? payment1FrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment1FrequencyPeriodMultiplier != null ? payment1FrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (payment2Date != null ? payment2Date.hashCode() : 0);
			_result = 31 * _result + (payment2FrequencyPeriod != null ? payment2FrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment2FrequencyPeriodMultiplier != null ? payment2FrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (resetFrequencyPeriod1 != null ? resetFrequencyPeriod1.hashCode() : 0);
			_result = 31 * _result + (resetFrequencyPeriodMultiplier1 != null ? resetFrequencyPeriodMultiplier1.hashCode() : 0);
			_result = 31 * _result + (settlementDate != null ? settlementDate.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceUnits != null ? strikePriceUnits.hashCode() : 0);
			_result = 31 * _result + (asOfDateTime != null ? asOfDateTime.hashCode() : 0);
			_result = 31 * _result + (clearingVenueId != null ? clearingVenueId.hashCode() : 0);
			_result = 31 * _result + (clearingVenueIdType != null ? clearingVenueIdType.hashCode() : 0);
			_result = 31 * _result + (compressedTradeIndicator != null ? compressedTradeIndicator.hashCode() : 0);
			_result = 31 * _result + (confirmationMethod != null ? confirmationMethod.hashCode() : 0);
			_result = 31 * _result + (confirmationPlatformId != null ? confirmationPlatformId.hashCode() : 0);
			_result = 31 * _result + (confirmationPlatformTradeId != null ? confirmationPlatformTradeId.hashCode() : 0);
			_result = 31 * _result + (executionVenueId != null ? executionVenueId.hashCode() : 0);
			_result = 31 * _result + (executionVenueIdType != null ? executionVenueIdType.hashCode() : 0);
			_result = 31 * _result + (postTradeEffectiveDate != null ? postTradeEffectiveDate.hashCode() : 0);
			_result = 31 * _result + (priorUsiId != null ? priorUsiId.hashCode() : 0);
			_result = 31 * _result + (priorUsiIdPrefix != null ? priorUsiIdPrefix.hashCode() : 0);
			_result = 31 * _result + (priorUtiId != null ? priorUtiId.hashCode() : 0);
			_result = 31 * _result + (priorUtiIdPrefix != null ? priorUtiIdPrefix.hashCode() : 0);
			_result = 31 * _result + (tradeParty1BranchLocation != null ? tradeParty1BranchLocation.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ClearingBrokerId != null ? tradeParty1ClearingBrokerId.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ClearingBrokerIdType != null ? tradeParty1ClearingBrokerIdType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1DeskLocation != null ? tradeParty1DeskLocation.hashCode() : 0);
			_result = 31 * _result + (tradeParty1Domicile != null ? tradeParty1Domicile.hashCode() : 0);
			_result = 31 * _result + (tradeParty1IndustrialSectorType != null ? tradeParty1IndustrialSectorType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2BranchLocation != null ? tradeParty2BranchLocation.hashCode() : 0);
			_result = 31 * _result + (tradeParty2DeskLocation != null ? tradeParty2DeskLocation.hashCode() : 0);
			_result = 31 * _result + (tradeParty2Domicile != null ? tradeParty2Domicile.hashCode() : 0);
			_result = 31 * _result + (tradeParty2IndustrialSectorType != null ? tradeParty2IndustrialSectorType.hashCode() : 0);
			_result = 31 * _result + (sellerPayer2 != null ? sellerPayer2.hashCode() : 0);
			_result = 31 * _result + (buyerPayer1 != null ? buyerPayer1.hashCode() : 0);
			_result = 31 * _result + (tradeParty1HkCounterpartyOrigin != null ? tradeParty1HkCounterpartyOrigin.hashCode() : 0);
			_result = 31 * _result + (leg2SettlementDate != null ? leg2SettlementDate.hashCode() : 0);
			_result = 31 * _result + (leg1FixedRateInitial != null ? leg1FixedRateInitial.hashCode() : 0);
			_result = 31 * _result + (leg2FixedRateInitial != null ? leg2FixedRateInitial.hashCode() : 0);
			_result = 31 * _result + (payment1Amount != null ? payment1Amount.hashCode() : 0);
			_result = 31 * _result + (payment1Currency != null ? payment1Currency.hashCode() : 0);
			_result = 31 * _result + (payment1Payer != null ? payment1Payer.hashCode() : 0);
			_result = 31 * _result + (payment1Receiver != null ? payment1Receiver.hashCode() : 0);
			_result = 31 * _result + (payment2Payer != null ? payment2Payer.hashCode() : 0);
			_result = 31 * _result + (postTradeTransactionDate != null ? postTradeTransactionDate.hashCode() : 0);
			_result = 31 * _result + (secondaryAssetClass != null ? secondaryAssetClass.hashCode() : 0);
			_result = 31 * _result + (settlementType != null ? settlementType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1Name != null ? tradeParty1Name.hashCode() : 0);
			_result = 31 * _result + (tradeParty2Name != null ? tradeParty2Name.hashCode() : 0);
			_result = 31 * _result + (ccpValuationAmount != null ? ccpValuationAmount.hashCode() : 0);
			_result = 31 * _result + (ccpValuationCurrency != null ? ccpValuationCurrency.hashCode() : 0);
			_result = 31 * _result + (ccpValuationDatetime != null ? ccpValuationDatetime.hashCode() : 0);
			_result = 31 * _result + (ccpValuationType != null ? ccpValuationType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ValuationAmount != null ? tradeParty1ValuationAmount.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ValuationCurrency != null ? tradeParty1ValuationCurrency.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ValuationDatetime != null ? tradeParty1ValuationDatetime.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ValuationType != null ? tradeParty1ValuationType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ValuationAmount != null ? tradeParty2ValuationAmount.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ValuationCurrency != null ? tradeParty2ValuationCurrency.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ValuationDatetime != null ? tradeParty2ValuationDatetime.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ValuationType != null ? tradeParty2ValuationType.hashCode() : 0);
			_result = 31 * _result + (executionType != null ? executionType.hashCode() : 0);
			_result = 31 * _result + (strikePriceCurrency != null ? strikePriceCurrency.hashCode() : 0);
			_result = 31 * _result + (payment2Amount != null ? payment2Amount.hashCode() : 0);
			_result = 31 * _result + (tradeParty2HkCounterpartyOrigin != null ? tradeParty2HkCounterpartyOrigin.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CountryOfTheOtherCounterparty != null ? tradeParty1CountryOfTheOtherCounterparty.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CountryOfTheOtherCounterparty != null ? tradeParty2CountryOfTheOtherCounterparty.hashCode() : 0);
			_result = 31 * _result + (tradeParty1BrokerId != null ? tradeParty1BrokerId.hashCode() : 0);
			_result = 31 * _result + (tradeParty2BrokerId != null ? tradeParty2BrokerId.hashCode() : 0);
			_result = 31 * _result + (tradeParty1BeneficiaryIdType != null ? tradeParty1BeneficiaryIdType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1BeneficiaryId != null ? tradeParty1BeneficiaryId.hashCode() : 0);
			_result = 31 * _result + (tradeParty2BeneficiaryIdType != null ? tradeParty2BeneficiaryIdType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2BeneficiaryId != null ? tradeParty2BeneficiaryId.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CounterpartySide != null ? tradeParty1CounterpartySide.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CounterpartySide != null ? tradeParty2CounterpartySide.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CollateralPortfolioCode != null ? tradeParty1CollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CollateralPortfolioCode != null ? tradeParty2CollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (euUnderlyingAssetIdType != null ? euUnderlyingAssetIdType.hashCode() : 0);
			_result = 31 * _result + (productClassification != null ? productClassification.hashCode() : 0);
			_result = 31 * _result + (complexTradeComponentId != null ? complexTradeComponentId.hashCode() : 0);
			_result = 31 * _result + (priceMultiplier != null ? priceMultiplier.hashCode() : 0);
			_result = 31 * _result + (quantity != null ? quantity.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (confirmationDatetime != null ? confirmationDatetime.hashCode() : 0);
			_result = 31 * _result + (clearingDatetime != null ? clearingDatetime.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.hashCode() : 0);
			_result = 31 * _result + (productClassificationType != null ? productClassificationType.hashCode() : 0);
			_result = 31 * _result + (productIdentificationType != null ? productIdentificationType.hashCode() : 0);
			_result = 31 * _result + (productIdentification != null ? productIdentification.hashCode() : 0);
			_result = 31 * _result + (euUnderlyingAssetId != null ? euUnderlyingAssetId.hashCode() : 0);
			_result = 31 * _result + (reportTrackingNumber != null ? reportTrackingNumber.hashCode() : 0);
			_result = 31 * _result + (tradeParty1BrokerIdType != null ? tradeParty1BrokerIdType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2BrokerIdType != null ? tradeParty2BrokerIdType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ClearingBrokerIdType != null ? tradeParty2ClearingBrokerIdType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ClearingBrokerId != null ? tradeParty2ClearingBrokerId.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ClearingThreshold != null ? tradeParty1ClearingThreshold.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ClearingThreshold != null ? tradeParty2ClearingThreshold.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CorporateSectorType != null ? tradeParty1CorporateSectorType.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CorporateSectorType != null ? tradeParty2CorporateSectorType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator != null ? tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator.hashCode() : 0);
			_result = 31 * _result + (tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator != null ? tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator.hashCode() : 0);
			_result = 31 * _result + (intragroupIndicator != null ? intragroupIndicator.hashCode() : 0);
			_result = 31 * _result + (tradeParty1TradingCapacity1 != null ? tradeParty1TradingCapacity1.hashCode() : 0);
			_result = 31 * _result + (tradeParty2TradingCapacity1 != null ? tradeParty2TradingCapacity1.hashCode() : 0);
			_result = 31 * _result + (currencyOfPrice != null ? currencyOfPrice.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CollateralPortfolio != null ? tradeParty1CollateralPortfolio.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CollateralPortfolio != null ? tradeParty2CollateralPortfolio.hashCode() : 0);
			_result = 31 * _result + (executionVenueMicCode != null ? executionVenueMicCode.hashCode() : 0);
			_result = 31 * _result + (payment2Currency != null ? payment2Currency.hashCode() : 0);
			_result = 31 * _result + (expirationDateTimeBusinessCenter != null ? expirationDateTimeBusinessCenter.hashCode() : 0);
			_result = 31 * _result + (expirationTime != null ? expirationTime.hashCode() : 0);
			_result = 31 * _result + (expirationTimeType != null ? expirationTimeType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1TraderLocation != null ? tradeParty1TraderLocation.hashCode() : 0);
			_result = 31 * _result + (tradeParty2TraderLocation != null ? tradeParty2TraderLocation.hashCode() : 0);
			_result = 31 * _result + (payment3ResetFrequencyPeriodMultiplier != null ? payment3ResetFrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (payment3ResetFrequencyPeriod != null ? payment3ResetFrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment4ResetFrequencyPeriodMultiplier != null ? payment4ResetFrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (payment4ResetFrequencyPeriod != null ? payment4ResetFrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment5ResetFrequencyPeriodMultiplier != null ? payment5ResetFrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (payment5ResetFrequencyPeriod != null ? payment5ResetFrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment1Type != null ? payment1Type.hashCode() : 0);
			_result = 31 * _result + (payment1Reference != null ? payment1Reference.hashCode() : 0);
			_result = 31 * _result + (payment2Type != null ? payment2Type.hashCode() : 0);
			_result = 31 * _result + (payment2Reference != null ? payment2Reference.hashCode() : 0);
			_result = 31 * _result + (payment3Payer != null ? payment3Payer.hashCode() : 0);
			_result = 31 * _result + (payment3Reference != null ? payment3Reference.hashCode() : 0);
			_result = 31 * _result + (payment3FrequencyPeriod != null ? payment3FrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment3FrequencyPeriodMultiplier != null ? payment3FrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (payment3Date != null ? payment3Date.hashCode() : 0);
			_result = 31 * _result + (payment4Reference != null ? payment4Reference.hashCode() : 0);
			_result = 31 * _result + (payment4Payer != null ? payment4Payer.hashCode() : 0);
			_result = 31 * _result + (payment4FrequencyPeriod != null ? payment4FrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment4FrequencyPeriodMultiplier != null ? payment4FrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (payment4Date != null ? payment4Date.hashCode() : 0);
			_result = 31 * _result + (payment5Reference != null ? payment5Reference.hashCode() : 0);
			_result = 31 * _result + (payment5Payer != null ? payment5Payer.hashCode() : 0);
			_result = 31 * _result + (payment5FrequencyPeriod != null ? payment5FrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (payment5FrequencyPeriodMultiplier != null ? payment5FrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (payment5Date != null ? payment5Date.hashCode() : 0);
			_result = 31 * _result + (payment3Type != null ? payment3Type.hashCode() : 0);
			_result = 31 * _result + (premiumPayer != null ? premiumPayer.hashCode() : 0);
			_result = 31 * _result + (premiumPaymentDateUnadjusted != null ? premiumPaymentDateUnadjusted.hashCode() : 0);
			_result = 31 * _result + (tradeParty1NatureOfTheReportingCounterparty != null ? tradeParty1NatureOfTheReportingCounterparty.hashCode() : 0);
			_result = 31 * _result + (tradeParty2NatureOfTheReportingCounterparty != null ? tradeParty2NatureOfTheReportingCounterparty.hashCode() : 0);
			_result = 31 * _result + (reservedParticipantUse1 != null ? reservedParticipantUse1.hashCode() : 0);
			_result = 31 * _result + (reservedParticipantUse2 != null ? reservedParticipantUse2.hashCode() : 0);
			_result = 31 * _result + (reservedParticipantUse3 != null ? reservedParticipantUse3.hashCode() : 0);
			_result = 31 * _result + (reservedParticipantUse4 != null ? reservedParticipantUse4.hashCode() : 0);
			_result = 31 * _result + (reservedParticipantUse5 != null ? reservedParticipantUse5.hashCode() : 0);
			_result = 31 * _result + (leg1TerminationDate != null ? leg1TerminationDate.hashCode() : 0);
			_result = 31 * _result + (allocationType != null ? allocationType.hashCode() : 0);
			_result = 31 * _result + (calculationBasis != null ? calculationBasis.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionPartyId != null ? clearingExceptionPartyId.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionPartyIdType != null ? clearingExceptionPartyIdType.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionType != null ? clearingExceptionType.hashCode() : 0);
			_result = 31 * _result + (clearingMemberClientAccountId != null ? clearingMemberClientAccountId.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptDatetime != null ? clearingReceiptDatetime.hashCode() : 0);
			_result = 31 * _result + (clearingSwapSdrLeiId != null ? clearingSwapSdrLeiId.hashCode() : 0);
			_result = 31 * _result + (clearingSwapUtiId != null ? clearingSwapUtiId.hashCode() : 0);
			_result = 31 * _result + (collateralReportingDate != null ? collateralReportingDate.hashCode() : 0);
			_result = 31 * _result + (collateralValuationDatetime != null ? collateralValuationDatetime.hashCode() : 0);
			_result = 31 * _result + (comment2 != null ? comment2.hashCode() : 0);
			_result = 31 * _result + (commodityStrikePriceUnit != null ? commodityStrikePriceUnit.hashCode() : 0);
			_result = 31 * _result + (executionAgentMaskingIndicator != null ? executionAgentMaskingIndicator.hashCode() : 0);
			_result = 31 * _result + (feeInCurrency != null ? feeInCurrency.hashCode() : 0);
			_result = 31 * _result + (feeOutCurrency != null ? feeOutCurrency.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyLeg1Multiplier != null ? floatingRatePaymentFrequencyLeg1Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyLeg1TimePeriod != null ? floatingRatePaymentFrequencyLeg1TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyLeg2Multiplier != null ? floatingRatePaymentFrequencyLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyLeg2TimePeriod != null ? floatingRatePaymentFrequencyLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (frequencyOfPayment != null ? frequencyOfPayment.hashCode() : 0);
			_result = 31 * _result + (interaffiliate != null ? interaffiliate.hashCode() : 0);
			_result = 31 * _result + (largeTradeIndicator != null ? largeTradeIndicator.hashCode() : 0);
			_result = 31 * _result + (leg1EffectiveDateAdjusted != null ? leg1EffectiveDateAdjusted.hashCode() : 0);
			_result = 31 * _result + (leg1FinalValuationDate != null ? leg1FinalValuationDate.hashCode() : 0);
			_result = 31 * _result + (leg1SettlementPeriod != null ? leg1SettlementPeriod.hashCode() : 0);
			_result = 31 * _result + (leg2EffectiveDateAdjusted != null ? leg2EffectiveDateAdjusted.hashCode() : 0);
			_result = 31 * _result + (leg2PaymentTermsFrequencyPeriod != null ? leg2PaymentTermsFrequencyPeriod.hashCode() : 0);
			_result = 31 * _result + (leg2PaymentTermsPaymentFrequencyPeriodMultiplier != null ? leg2PaymentTermsPaymentFrequencyPeriodMultiplier.hashCode() : 0);
			_result = 31 * _result + (leg2SettlementType != null ? leg2SettlementType.hashCode() : 0);
			_result = 31 * _result + (leg2UnderlyingAssetId != null ? leg2UnderlyingAssetId.hashCode() : 0);
			_result = 31 * _result + (leg2UnderlyingAssetIdType != null ? leg2UnderlyingAssetIdType.hashCode() : 0);
			_result = 31 * _result + (leg2UnderlyingAssetName != null ? leg2UnderlyingAssetName.hashCode() : 0);
			_result = 31 * _result + (maturityDate != null ? maturityDate.hashCode() : 0);
			_result = 31 * _result + (optionalEarlyTerminationDate != null ? optionalEarlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (optionCommodityCurrency != null ? optionCommodityCurrency.hashCode() : 0);
			_result = 31 * _result + (optionCommodityExchangeId != null ? optionCommodityExchangeId.hashCode() : 0);
			_result = 31 * _result + (optionCommodityInstrumentId != null ? optionCommodityInstrumentId.hashCode() : 0);
			_result = 31 * _result + (optionCommodityRateSource != null ? optionCommodityRateSource.hashCode() : 0);
			_result = 31 * _result + (optionCommodityRateSourcePage != null ? optionCommodityRateSourcePage.hashCode() : 0);
			_result = 31 * _result + (optionCommodityUnderlyerDetails != null ? optionCommodityUnderlyerDetails.hashCode() : 0);
			_result = 31 * _result + (optionCommodityUnderlyerId != null ? optionCommodityUnderlyerId.hashCode() : 0);
			_result = 31 * _result + (optionCommodityUnitOfMeasure != null ? optionCommodityUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (optionSpecifiedPrice != null ? optionSpecifiedPrice.hashCode() : 0);
			_result = 31 * _result + (optionSpreadAmount != null ? optionSpreadAmount.hashCode() : 0);
			_result = 31 * _result + (optionSpreadCurrency != null ? optionSpreadCurrency.hashCode() : 0);
			_result = 31 * _result + (optionSpreadSchedule != null ? optionSpreadSchedule.hashCode() : 0);
			_result = 31 * _result + (origin != null ? origin.hashCode() : 0);
			_result = 31 * _result + (originalSwapSdrId != null ? originalSwapSdrId.hashCode() : 0);
			_result = 31 * _result + (originalSwapSdrIdType != null ? originalSwapSdrIdType.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodLeg1 != null ? paymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodLeg2 != null ? paymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodMultiplierLeg1 != null ? paymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodMultiplierLeg2 != null ? paymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (premiumPayerPrefix != null ? premiumPayerPrefix.hashCode() : 0);
			_result = 31 * _result + (price1Currency != null ? price1Currency.hashCode() : 0);
			_result = 31 * _result + (price2Price != null ? price2Price.hashCode() : 0);
			_result = 31 * _result + (price2Type != null ? price2Type.hashCode() : 0);
			_result = 31 * _result + (price2Units != null ? price2Units.hashCode() : 0);
			_result = 31 * _result + (price3Price != null ? price3Price.hashCode() : 0);
			_result = 31 * _result + (price3Type != null ? price3Type.hashCode() : 0);
			_result = 31 * _result + (price3Units != null ? price3Units.hashCode() : 0);
			_result = 31 * _result + (price4Price != null ? price4Price.hashCode() : 0);
			_result = 31 * _result + (price4Type != null ? price4Type.hashCode() : 0);
			_result = 31 * _result + (price4Units != null ? price4Units.hashCode() : 0);
			_result = 31 * _result + (pricingContext != null ? pricingContext.hashCode() : 0);
			_result = 31 * _result + (priorUsiType != null ? priorUsiType.hashCode() : 0);
			_result = 31 * _result + (priorUtiType != null ? priorUtiType.hashCode() : 0);
			_result = 31 * _result + (recoveryPrice != null ? recoveryPrice.hashCode() : 0);
			_result = 31 * _result + (sendToDataCenterCode != null ? sendToDataCenterCode.hashCode() : 0);
			_result = 31 * _result + (strikePriceType != null ? strikePriceType.hashCode() : 0);
			_result = 31 * _result + (subAssetClassForOtherCommodity != null ? subAssetClassForOtherCommodity.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CftcFinancialEntityStatus != null ? tradeParty1CftcFinancialEntityStatus.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CollateralAmount != null ? tradeParty1CollateralAmount.hashCode() : 0);
			_result = 31 * _result + (tradeParty1CollateralCurrency != null ? tradeParty1CollateralCurrency.hashCode() : 0);
			_result = 31 * _result + (tradeParty1MandatoryDelegatedReporting != null ? tradeParty1MandatoryDelegatedReporting.hashCode() : 0);
			_result = 31 * _result + (tradeParty1Role != null ? tradeParty1Role.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CftcFinancialEntityStatus != null ? tradeParty2CftcFinancialEntityStatus.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CollateralAmount != null ? tradeParty2CollateralAmount.hashCode() : 0);
			_result = 31 * _result + (tradeParty2CollateralCurrency != null ? tradeParty2CollateralCurrency.hashCode() : 0);
			_result = 31 * _result + (tradeParty2MandatoryDelegatedReporting != null ? tradeParty2MandatoryDelegatedReporting.hashCode() : 0);
			_result = 31 * _result + (tradeParty2Role != null ? tradeParty2Role.hashCode() : 0);
			_result = 31 * _result + (upfrontPayment != null ? upfrontPayment.hashCode() : 0);
			_result = 31 * _result + (verificationMethod != null ? verificationMethod.hashCode() : 0);
			_result = 31 * _result + (responsibleDataSubmitterId != null ? responsibleDataSubmitterId.hashCode() : 0);
			_result = 31 * _result + (responsibleDataSubmitterIdType != null ? responsibleDataSubmitterIdType.hashCode() : 0);
			_result = 31 * _result + (originalSwapUsi != null ? originalSwapUsi.hashCode() : 0);
			_result = 31 * _result + (originalSwapUti != null ? originalSwapUti.hashCode() : 0);
			_result = 31 * _result + (cdeReceiverIdentifierLeg2 != null ? cdeReceiverIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (counterparty1FederalEntityIndicator != null ? counterparty1FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FederalEntityIndicator != null ? counterparty2FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (customBasketIndicator != null ? customBasketIndicator.hashCode() : 0);
			_result = 31 * _result + (noaActionType != null ? noaActionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (amendmentIndicator != null ? amendmentIndicator.hashCode() : 0);
			_result = 31 * _result + (eventIdentifier != null ? eventIdentifier.hashCode() : 0);
			_result = 31 * _result + (cdeCallAmountLeg1 != null ? cdeCallAmountLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeCallAmountLeg2 != null ? cdeCallAmountLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeCallCurrencyLeg1 != null ? cdeCallCurrencyLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeCallCurrencyLeg2 != null ? cdeCallCurrencyLeg2.hashCode() : 0);
			_result = 31 * _result + (cdePutAmountLeg1 != null ? cdePutAmountLeg1.hashCode() : 0);
			_result = 31 * _result + (cdePutAmountLeg2 != null ? cdePutAmountLeg2.hashCode() : 0);
			_result = 31 * _result + (cdePutCurrencyLeg1 != null ? cdePutCurrencyLeg1.hashCode() : 0);
			_result = 31 * _result + (cdePutCurrencyLeg2 != null ? cdePutCurrencyLeg2.hashCode() : 0);
			_result = 31 * _result + (leg2QuantityFrequency != null ? leg2QuantityFrequency.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierLeg1 != null ? quantityFrequencyMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierLeg2 != null ? quantityFrequencyMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeQuantityUnitOfMeasureLeg1 != null ? cdeQuantityUnitOfMeasureLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeQuantityUnitOfMeasureLeg2 != null ? cdeQuantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (packageIndicator != null ? packageIndicator.hashCode() : 0);
			_result = 31 * _result + (cdePackageIdentifier != null ? cdePackageIdentifier.hashCode() : 0);
			_result = 31 * _result + (cdePackageTransactionPrice != null ? cdePackageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (cdePackageTransactionPriceCurrency != null ? cdePackageTransactionPriceCurrency.hashCode() : 0);
			_result = 31 * _result + (cdePackageTransactionPriceNotation != null ? cdePackageTransactionPriceNotation.hashCode() : 0);
			_result = 31 * _result + (cdePackageTransactionSpread != null ? cdePackageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (cdePackageTransactionSpreadCurrency != null ? cdePackageTransactionSpreadCurrency.hashCode() : 0);
			_result = 31 * _result + (cdePackageTransactionSpreadNotation != null ? cdePackageTransactionSpreadNotation.hashCode() : 0);
			_result = 31 * _result + (cdeFixedRateDayCountConventionLeg1 != null ? cdeFixedRateDayCountConventionLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeFixedRateDayCountConventionLeg2 != null ? cdeFixedRateDayCountConventionLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeFloatingRateDayCountConventionLeg1 != null ? cdeFloatingRateDayCountConventionLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeFloatingRateDayCountConventionLeg2 != null ? cdeFloatingRateDayCountConventionLeg2.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg1 != null ? fixingDateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg2 != null ? fixingDateLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeFixedRatePaymentFrequencyPeriodLeg1 != null ? cdeFixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeFixedRatePaymentFrequencyPeriodLeg2 != null ? cdeFixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeFloatingRatePaymentFrequencyPeriodLeg1 != null ? cdeFloatingRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeFloatingRatePaymentFrequencyPeriodLeg2 != null ? cdeFloatingRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1 != null ? cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2 != null ? cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (postPricedSwapIndicator != null ? postPricedSwapIndicator.hashCode() : 0);
			_result = 31 * _result + (cdePriceCurrency != null ? cdePriceCurrency.hashCode() : 0);
			_result = 31 * _result + (cdePriceNotation != null ? cdePriceNotation.hashCode() : 0);
			_result = 31 * _result + (cdeSpreadNotationLeg1 != null ? cdeSpreadNotationLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeSpreadNotationLeg2 != null ? cdeSpreadNotationLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeStrikePriceCurrency2 != null ? cdeStrikePriceCurrency2.hashCode() : 0);
			_result = 31 * _result + (cdeStrikePriceNotation != null ? cdeStrikePriceNotation.hashCode() : 0);
			_result = 31 * _result + (cdeFirstExerciseDate != null ? cdeFirstExerciseDate.hashCode() : 0);
			_result = 31 * _result + (cdeFinalContractualSettlementDate != null ? cdeFinalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (cdeSettlementLocationLeg1 != null ? cdeSettlementLocationLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeSettlementLocationLeg2 != null ? cdeSettlementLocationLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeEffectiveDate != null ? cdeEffectiveDate.hashCode() : 0);
			_result = 31 * _result + (cdeExpirationDate != null ? cdeExpirationDate.hashCode() : 0);
			_result = 31 * _result + (cdePlatformIdentifier != null ? cdePlatformIdentifier.hashCode() : 0);
			_result = 31 * _result + (primeBrokerageTransactionIndicator != null ? primeBrokerageTransactionIndicator.hashCode() : 0);
			_result = 31 * _result + (swapReportingJurisdiction != null ? swapReportingJurisdiction.hashCode() : 0);
			_result = 31 * _result + (newSdrIdentifier != null ? newSdrIdentifier.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg1 != null ? nextFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (lastFloatingReferenceValueLeg1 != null ? lastFloatingReferenceValueLeg1.hashCode() : 0);
			_result = 31 * _result + (lastFloatingReferenceResetDateLeg1 != null ? lastFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg2 != null ? nextFloatingReferenceResetDateLeg2.hashCode() : 0);
			_result = 31 * _result + (lastFloatingReferenceValueLeg2 != null ? lastFloatingReferenceValueLeg2.hashCode() : 0);
			_result = 31 * _result + (lastFloatingReferenceResetDateLeg2 != null ? lastFloatingReferenceResetDateLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeDelta != null ? cdeDelta.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (largeNotionalOffFacilitySwapElectionIndicator != null ? largeNotionalOffFacilitySwapElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (sefOrDcmAnonymousExecutionIndicator != null ? sefOrDcmAnonymousExecutionIndicator.hashCode() : 0);
			_result = 31 * _result + (blockTradeElectionIndicator != null ? blockTradeElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (sefOrDcmIndicator != null ? sefOrDcmIndicator.hashCode() : 0);
			_result = 31 * _result + (mandatoryClearingIndicator != null ? mandatoryClearingIndicator.hashCode() : 0);
			_result = 31 * _result + (sdMspIndicatorCounterparty1 != null ? sdMspIndicatorCounterparty1.hashCode() : 0);
			_result = 31 * _result + (sdMspIndicatorCounterparty2 != null ? sdMspIndicatorCounterparty2.hashCode() : 0);
			_result = 31 * _result + (physicalCommodityContractIndicator != null ? physicalCommodityContractIndicator.hashCode() : 0);
			_result = 31 * _result + (changeInNotionalAmount1 != null ? changeInNotionalAmount1.hashCode() : 0);
			_result = 31 * _result + (changeInNotionalAmount2 != null ? changeInNotionalAmount2.hashCode() : 0);
			_result = 31 * _result + (changeInLeg1NotionalQuantity != null ? changeInLeg1NotionalQuantity.hashCode() : 0);
			_result = 31 * _result + (changeInLeg2NotionalQuantity != null ? changeInLeg2NotionalQuantity.hashCode() : 0);
			_result = 31 * _result + (cdeCryptoAssetUnderlyingIndicatorLeg1 != null ? cdeCryptoAssetUnderlyingIndicatorLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeCryptoAssetUnderlyingIndicatorLeg2 != null ? cdeCryptoAssetUnderlyingIndicatorLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeCustomBasketCode != null ? cdeCustomBasketCode.hashCode() : 0);
			_result = 31 * _result + (underlierIdOtherLeg1 != null ? underlierIdOtherLeg1.hashCode() : 0);
			_result = 31 * _result + (underlierIdOtherLeg2 != null ? underlierIdOtherLeg2.hashCode() : 0);
			_result = 31 * _result + (underlierIdOtherSourceLeg1 != null ? underlierIdOtherSourceLeg1.hashCode() : 0);
			_result = 31 * _result + (underlierIdOtherSourceLeg2 != null ? underlierIdOtherSourceLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeUnderlyingAssetTradingPlatformIdLeg1 != null ? cdeUnderlyingAssetTradingPlatformIdLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeUnderlyingAssetTradingPlatformIdLeg2 != null ? cdeUnderlyingAssetTradingPlatformIdLeg2.hashCode() : 0);
			_result = 31 * _result + (cdeUnderlyingAssetPriceSourceLeg1 != null ? cdeUnderlyingAssetPriceSourceLeg1.hashCode() : 0);
			_result = 31 * _result + (cdeUnderlyingAssetPriceSourceLeg2 != null ? cdeUnderlyingAssetPriceSourceLeg2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HarmonizedData {" +
				"leg2CommodityInstrumentId=" + this.leg2CommodityInstrumentId + ", " +
				"leg2CommodityUnderlyerId=" + this.leg2CommodityUnderlyerId + ", " +
				"leg2CommodityUnderlyerDetails=" + this.leg2CommodityUnderlyerDetails + ", " +
				"leg2CommodityUnitOfMeasure=" + this.leg2CommodityUnitOfMeasure + ", " +
				"leg2CommodityCurrency=" + this.leg2CommodityCurrency + ", " +
				"leg2CommodityExchangeId=" + this.leg2CommodityExchangeId + ", " +
				"leg1CommodityRateSource=" + this.leg1CommodityRateSource + ", " +
				"leg1CommodityRateSourcePage=" + this.leg1CommodityRateSourcePage + ", " +
				"leg2SpecifiedPrice=" + this.leg2SpecifiedPrice + ", " +
				"commencementDateUnadjusted=" + this.commencementDateUnadjusted + ", " +
				"exerciseExpirationDateUnadjusted=" + this.exerciseExpirationDateUnadjusted + ", " +
				"expirationDateUnadjusted=" + this.expirationDateUnadjusted + ", " +
				"leg2NotionalQuantityFrequency=" + this.leg2NotionalQuantityFrequency + ", " +
				"leg2NotionalQuantity=" + this.leg2NotionalQuantity + ", " +
				"leg2TotalNotionalQuantity=" + this.leg2TotalNotionalQuantity + ", " +
				"leg2SpreadAmount=" + this.leg2SpreadAmount + ", " +
				"leg2SpreadCurrency=" + this.leg2SpreadCurrency + ", " +
				"scheduledTerminationDateAdjusted=" + this.scheduledTerminationDateAdjusted + ", " +
				"leg1PartyPayer=" + this.leg1PartyPayer + ", " +
				"leg2PartyPayer=" + this.leg2PartyPayer + ", " +
				"leg1CommodityInstrumentId=" + this.leg1CommodityInstrumentId + ", " +
				"leg1CommodityUnderlyerId=" + this.leg1CommodityUnderlyerId + ", " +
				"leg1CommodityUnitOfMeasure=" + this.leg1CommodityUnitOfMeasure + ", " +
				"leg1CommodityExchangeId=" + this.leg1CommodityExchangeId + ", " +
				"leg2CommodityRateSource=" + this.leg2CommodityRateSource + ", " +
				"leg1EffectiveDateUnadjusted=" + this.leg1EffectiveDateUnadjusted + ", " +
				"leg2EffectiveDateUnadjusted=" + this.leg2EffectiveDateUnadjusted + ", " +
				"coProductType=" + this.coProductType + ", " +
				"totalQuantityUnit=" + this.totalQuantityUnit + ", " +
				"totalQuantity=" + this.totalQuantity + ", " +
				"fixedPrice=" + this.fixedPrice + ", " +
				"fixedPriceCurrency=" + this.fixedPriceCurrency + ", " +
				"leg1NotionalQuantityUnit=" + this.leg1NotionalQuantityUnit + ", " +
				"leg1NotionalQuantityFrequency=" + this.leg1NotionalQuantityFrequency + ", " +
				"leg1NotionalQuantity=" + this.leg1NotionalQuantity + ", " +
				"leg1TotalNotionalQuantity=" + this.leg1TotalNotionalQuantity + ", " +
				"leg1CommodityCurrency=" + this.leg1CommodityCurrency + ", " +
				"leg1SpecifiedPrice=" + this.leg1SpecifiedPrice + ", " +
				"leg1SpreadCurrency=" + this.leg1SpreadCurrency + ", " +
				"leg1SpreadAmount=" + this.leg1SpreadAmount + ", " +
				"leg2NotionalQuantityUnit=" + this.leg2NotionalQuantityUnit + ", " +
				"leg2PartyReceiver=" + this.leg2PartyReceiver + ", " +
				"leg1PartyReceiver=" + this.leg1PartyReceiver + ", " +
				"coalSource=" + this.coalSource + ", " +
				"leg2Quantity=" + this.leg2Quantity + ", " +
				"commodityBase=" + this.commodityBase + ", " +
				"commodityDetails=" + this.commodityDetails + ", " +
				"interconnectionPoint=" + this.interconnectionPoint + ", " +
				"loadType=" + this.loadType + ", " +
				"fixedPriceUnit=" + this.fixedPriceUnit + ", " +
				"exercisePaymentDateUnadjusted=" + this.exercisePaymentDateUnadjusted + ", " +
				"leg1PaymentDatesUnadjusted=" + this.leg1PaymentDatesUnadjusted + ", " +
				"leg2PaymentDateUnadjusted=" + this.leg2PaymentDateUnadjusted + ", " +
				"settlementDateUnadjusted=" + this.settlementDateUnadjusted + ", " +
				"deliveryLocation=" + this.deliveryLocation + ", " +
				"leg2QuantityUnit=" + this.leg2QuantityUnit + ", " +
				"leg1CommodityUnderlyerDetails=" + this.leg1CommodityUnderlyerDetails + ", " +
				"leg2CommodityRateSourcePage=" + this.leg2CommodityRateSourcePage + ", " +
				"valueDate=" + this.valueDate + ", " +
				"gtrQuantityUnit=" + this.gtrQuantityUnit + ", " +
				"attachmentPoint=" + this.attachmentPoint + ", " +
				"exhaustionPoint=" + this.exhaustionPoint + ", " +
				"mthToDefault=" + this.mthToDefault + ", " +
				"nthToDefault=" + this.nthToDefault + ", " +
				"seniority=" + this.seniority + ", " +
				"series=" + this.series + ", " +
				"crversion=" + this.crversion + ", " +
				"tranche=" + this.tranche + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"referenceObligation=" + this.referenceObligation + ", " +
				"referenceObligationIdType=" + this.referenceObligationIdType + ", " +
				"underlyingFixedRatePayerBuyer=" + this.underlyingFixedRatePayerBuyer + ", " +
				"underlyingFloatRatePayerSeller=" + this.underlyingFloatRatePayerSeller + ", " +
				"underlyingAssetExchangeId=" + this.underlyingAssetExchangeId + ", " +
				"underlyingAssetNumberOfUnits=" + this.underlyingAssetNumberOfUnits + ", " +
				"optionalEarlyTerminationType=" + this.optionalEarlyTerminationType + ", " +
				"optionalEarlyTerminationElectingPartyValue=" + this.optionalEarlyTerminationElectingPartyValue + ", " +
				"optionalEarlyTerminationIndicator=" + this.optionalEarlyTerminationIndicator + ", " +
				"underlyingAssetFloatingAmountPayer=" + this.underlyingAssetFloatingAmountPayer + ", " +
				"underlyingAssetFloatingAmountReceiver=" + this.underlyingAssetFloatingAmountReceiver + ", " +
				"floatingRateOption=" + this.floatingRateOption + ", " +
				"underlyingAssetFloatingLegSpread=" + this.underlyingAssetFloatingLegSpread + ", " +
				"leg2DesignatedMaturityPeriod=" + this.leg2DesignatedMaturityPeriod + ", " +
				"leg2DesignatedMaturityPeriodMultiplier=" + this.leg2DesignatedMaturityPeriodMultiplier + ", " +
				"underlyingAssetEquityAmountPayer=" + this.underlyingAssetEquityAmountPayer + ", " +
				"underlyingAssetEquityAmountReceiver=" + this.underlyingAssetEquityAmountReceiver + ", " +
				"underlyingAssetInitialPriceCurrency=" + this.underlyingAssetInitialPriceCurrency + ", " +
				"leg1ValuationDates=" + this.leg1ValuationDates + ", " +
				"leg1TypeOfReturn=" + this.leg1TypeOfReturn + ", " +
				"observationStartDate=" + this.observationStartDate + ", " +
				"varianceAmount=" + this.varianceAmount + ", " +
				"volatilityStrikePrice=" + this.volatilityStrikePrice + ", " +
				"varianceStrikePrice=" + this.varianceStrikePrice + ", " +
				"varianceCapFactor=" + this.varianceCapFactor + ", " +
				"referenceCurrency=" + this.referenceCurrency + ", " +
				"specialDividendsIndicator=" + this.specialDividendsIndicator + ", " +
				"materialNoncashDividendIndicator=" + this.materialNoncashDividendIndicator + ", " +
				"numberOfSharesUnits=" + this.numberOfSharesUnits + ", " +
				"dividendAmountPayer=" + this.dividendAmountPayer + ", " +
				"dividendAmountReceiver=" + this.dividendAmountReceiver + ", " +
				"fixedAmountPayer=" + this.fixedAmountPayer + ", " +
				"fixedAmountReceiver=" + this.fixedAmountReceiver + ", " +
				"knockInEvent=" + this.knockInEvent + ", " +
				"knockOutEvent=" + this.knockOutEvent + ", " +
				"knockInPrice=" + this.knockInPrice + ", " +
				"knockOutPrice=" + this.knockOutPrice + ", " +
				"barrierType=" + this.barrierType + ", " +
				"earliestExecutionTime=" + this.earliestExecutionTime + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"exchangeRateBasisCurrency1=" + this.exchangeRateBasisCurrency1 + ", " +
				"exchangeRateBasisCurrency2=" + this.exchangeRateBasisCurrency2 + ", " +
				"executionPeriodStartDate=" + this.executionPeriodStartDate + ", " +
				"payoutStyle=" + this.payoutStyle + ", " +
				"rateQuoteBasis1=" + this.rateQuoteBasis1 + ", " +
				"settlementFixingDate=" + this.settlementFixingDate + ", " +
				"swapLinkId=" + this.swapLinkId + ", " +
				"triggerCondition=" + this.triggerCondition + ", " +
				"triggerCondition2=" + this.triggerCondition2 + ", " +
				"triggerRate=" + this.triggerRate + ", " +
				"triggerRate2=" + this.triggerRate2 + ", " +
				"rateQuoteBasis2=" + this.rateQuoteBasis2 + ", " +
				"forwardExchangeRate=" + this.forwardExchangeRate + ", " +
				"barrierType2=" + this.barrierType2 + ", " +
				"cancelationOptionBuyer=" + this.cancelationOptionBuyer + ", " +
				"cancelationOptionCommencementDate=" + this.cancelationOptionCommencementDate + ", " +
				"cancelationOptionExerciseStyleType=" + this.cancelationOptionExerciseStyleType + ", " +
				"cancelationOptionExpirationDate=" + this.cancelationOptionExpirationDate + ", " +
				"cancelationOptionInitialFeeCurrency=" + this.cancelationOptionInitialFeeCurrency + ", " +
				"cancelationOptionInitialFeePayer=" + this.cancelationOptionInitialFeePayer + ", " +
				"cancelationOptionPremiumAmount=" + this.cancelationOptionPremiumAmount + ", " +
				"cancelationOptionSeller=" + this.cancelationOptionSeller + ", " +
				"capRateInitial=" + this.capRateInitial + ", " +
				"couponType=" + this.couponType + ", " +
				"finalPrincipalExchangeIndicatorAtTermination=" + this.finalPrincipalExchangeIndicatorAtTermination + ", " +
				"floorRateInitial=" + this.floorRateInitial + ", " +
				"fraDiscountingType=" + this.fraDiscountingType + ", " +
				"inflationIndexInitialLevel=" + this.inflationIndexInitialLevel + ", " +
				"inflationIndexMainPublication=" + this.inflationIndexMainPublication + ", " +
				"inflationInterpolationMethod=" + this.inflationInterpolationMethod + ", " +
				"inflationLagDayType=" + this.inflationLagDayType + ", " +
				"inflationLagPeriod=" + this.inflationLagPeriod + ", " +
				"inflationRateSourceName=" + this.inflationRateSourceName + ", " +
				"initialPrincipalExchangeIndicator=" + this.initialPrincipalExchangeIndicator + ", " +
				"intermediatePrincipalExchangeIndicator=" + this.intermediatePrincipalExchangeIndicator + ", " +
				"leg1FloatingRateIndex=" + this.leg1FloatingRateIndex + ", " +
				"leg1FloatingRateInitialSpread=" + this.leg1FloatingRateInitialSpread + ", " +
				"leg1FloatingRateMultiplierInitialValue=" + this.leg1FloatingRateMultiplierInitialValue + ", " +
				"leg1FloatingRateTenorPeriod=" + this.leg1FloatingRateTenorPeriod + ", " +
				"leg1FloatingRateTenorPeriodMultiplier=" + this.leg1FloatingRateTenorPeriodMultiplier + ", " +
				"leg1KnownAmount=" + this.leg1KnownAmount + ", " +
				"leg1KnownAmountCurrency=" + this.leg1KnownAmountCurrency + ", " +
				"leg1ReferenceCurrency=" + this.leg1ReferenceCurrency + ", " +
				"leg2FloatingRateIndex=" + this.leg2FloatingRateIndex + ", " +
				"leg2FloatingRateInitialSpread=" + this.leg2FloatingRateInitialSpread + ", " +
				"leg2FloatingRateMultiplierInitialValue=" + this.leg2FloatingRateMultiplierInitialValue + ", " +
				"leg2FloatingRateTenorPeriod=" + this.leg2FloatingRateTenorPeriod + ", " +
				"leg2FloatingRateTenorPeriodMultiplier=" + this.leg2FloatingRateTenorPeriodMultiplier + ", " +
				"leg2KnownAmount=" + this.leg2KnownAmount + ", " +
				"leg2KnownAmountCurrency=" + this.leg2KnownAmountCurrency + ", " +
				"leg2ReferenceCurrency=" + this.leg2ReferenceCurrency + ", " +
				"mandatoryEarlyTerminationDate=" + this.mandatoryEarlyTerminationDate + ", " +
				"mandatoryEarlyTerminationDateTenorPeriod=" + this.mandatoryEarlyTerminationDateTenorPeriod + ", " +
				"mandatoryEarlyTerminationDateTenorPeriodMultiplier=" + this.mandatoryEarlyTerminationDateTenorPeriodMultiplier + ", " +
				"notionalUnits=" + this.notionalUnits + ", " +
				"optionalEarlyTerminationCommencementDate=" + this.optionalEarlyTerminationCommencementDate + ", " +
				"optionalEarlyTerminationExerciseStyle=" + this.optionalEarlyTerminationExerciseStyle + ", " +
				"optionalEarlyTerminationExpirationDate=" + this.optionalEarlyTerminationExpirationDate + ", " +
				"premiumReceiver=" + this.premiumReceiver + ", " +
				"underlyingCouponRate=" + this.underlyingCouponRate + ", " +
				"underlyingMaturityDate=" + this.underlyingMaturityDate + ", " +
				"underlyingProductId=" + this.underlyingProductId + ", " +
				"inflationLagPeriodMultiplier=" + this.inflationLagPeriodMultiplier + ", " +
				"leg1FixedRateNotation=" + this.leg1FixedRateNotation + ", " +
				"leg2FixedRateNotation=" + this.leg2FixedRateNotation + ", " +
				"swaptionStraddleIndicator=" + this.swaptionStraddleIndicator + ", " +
				"singlePartyEarlyTerminationBuyer=" + this.singlePartyEarlyTerminationBuyer + ", " +
				"leg1EffectiveDate=" + this.leg1EffectiveDate + ", " +
				"action=" + this.action + ", " +
				"clearingStatus=" + this.clearingStatus + ", " +
				"effectiveDate1=" + this.effectiveDate1 + ", " +
				"executionVenueType=" + this.executionVenueType + ", " +
				"nonStandardTradeIndicator=" + this.nonStandardTradeIndicator + ", " +
				"notionalAmount1=" + this.notionalAmount1 + ", " +
				"notionalCurrency1=" + this.notionalCurrency1 + ", " +
				"price1Price=" + this.price1Price + ", " +
				"price1Type=" + this.price1Type + ", " +
				"price1Units=" + this.price1Units + ", " +
				"scheduledTerminationDate1=" + this.scheduledTerminationDate1 + ", " +
				"tradeDate=" + this.tradeDate + ", " +
				"tradeParty1CollateralizationType=" + this.tradeParty1CollateralizationType + ", " +
				"tradeParty1EventId=" + this.tradeParty1EventId + ", " +
				"tradeParty2CollateralizationType=" + this.tradeParty2CollateralizationType + ", " +
				"tradeParty2EventId=" + this.tradeParty2EventId + ", " +
				"embeddedOptionOnSwap=" + this.embeddedOptionOnSwap + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"notionalAmount2=" + this.notionalAmount2 + ", " +
				"notionalCurrency2=" + this.notionalCurrency2 + ", " +
				"premiumAmount=" + this.premiumAmount + ", " +
				"premiumCurrency=" + this.premiumCurrency + ", " +
				"version=" + this.version + ", " +
				"comment1=" + this.comment1 + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"optionType=" + this.optionType + ", " +
				"settlementCurrency1=" + this.settlementCurrency1 + ", " +
				"commencementDate=" + this.commencementDate + ", " +
				"dayCountFraction1=" + this.dayCountFraction1 + ", " +
				"leg2DayCountFraction=" + this.leg2DayCountFraction + ", " +
				"leg2EffectiveDate=" + this.leg2EffectiveDate + ", " +
				"leg2ResetFrequencyPeriod=" + this.leg2ResetFrequencyPeriod + ", " +
				"leg2ResetFrequencyPeriodMultiplier=" + this.leg2ResetFrequencyPeriodMultiplier + ", " +
				"leg2SettlementCurrency=" + this.leg2SettlementCurrency + ", " +
				"leg2ScheduledTerminationDate=" + this.leg2ScheduledTerminationDate + ", " +
				"numberOfOptions=" + this.numberOfOptions + ", " +
				"optionEntitlement=" + this.optionEntitlement + ", " +
				"originalExecutionTimestamp=" + this.originalExecutionTimestamp + ", " +
				"payment1Date=" + this.payment1Date + ", " +
				"payment1FrequencyPeriod=" + this.payment1FrequencyPeriod + ", " +
				"payment1FrequencyPeriodMultiplier=" + this.payment1FrequencyPeriodMultiplier + ", " +
				"payment2Date=" + this.payment2Date + ", " +
				"payment2FrequencyPeriod=" + this.payment2FrequencyPeriod + ", " +
				"payment2FrequencyPeriodMultiplier=" + this.payment2FrequencyPeriodMultiplier + ", " +
				"resetFrequencyPeriod1=" + this.resetFrequencyPeriod1 + ", " +
				"resetFrequencyPeriodMultiplier1=" + this.resetFrequencyPeriodMultiplier1 + ", " +
				"settlementDate=" + this.settlementDate + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceUnits=" + this.strikePriceUnits + ", " +
				"asOfDateTime=" + this.asOfDateTime + ", " +
				"clearingVenueId=" + this.clearingVenueId + ", " +
				"clearingVenueIdType=" + this.clearingVenueIdType + ", " +
				"compressedTradeIndicator=" + this.compressedTradeIndicator + ", " +
				"confirmationMethod=" + this.confirmationMethod + ", " +
				"confirmationPlatformId=" + this.confirmationPlatformId + ", " +
				"confirmationPlatformTradeId=" + this.confirmationPlatformTradeId + ", " +
				"executionVenueId=" + this.executionVenueId + ", " +
				"executionVenueIdType=" + this.executionVenueIdType + ", " +
				"postTradeEffectiveDate=" + this.postTradeEffectiveDate + ", " +
				"priorUsiId=" + this.priorUsiId + ", " +
				"priorUsiIdPrefix=" + this.priorUsiIdPrefix + ", " +
				"priorUtiId=" + this.priorUtiId + ", " +
				"priorUtiIdPrefix=" + this.priorUtiIdPrefix + ", " +
				"tradeParty1BranchLocation=" + this.tradeParty1BranchLocation + ", " +
				"tradeParty1ClearingBrokerId=" + this.tradeParty1ClearingBrokerId + ", " +
				"tradeParty1ClearingBrokerIdType=" + this.tradeParty1ClearingBrokerIdType + ", " +
				"tradeParty1DeskLocation=" + this.tradeParty1DeskLocation + ", " +
				"tradeParty1Domicile=" + this.tradeParty1Domicile + ", " +
				"tradeParty1IndustrialSectorType=" + this.tradeParty1IndustrialSectorType + ", " +
				"tradeParty2BranchLocation=" + this.tradeParty2BranchLocation + ", " +
				"tradeParty2DeskLocation=" + this.tradeParty2DeskLocation + ", " +
				"tradeParty2Domicile=" + this.tradeParty2Domicile + ", " +
				"tradeParty2IndustrialSectorType=" + this.tradeParty2IndustrialSectorType + ", " +
				"sellerPayer2=" + this.sellerPayer2 + ", " +
				"buyerPayer1=" + this.buyerPayer1 + ", " +
				"tradeParty1HkCounterpartyOrigin=" + this.tradeParty1HkCounterpartyOrigin + ", " +
				"leg2SettlementDate=" + this.leg2SettlementDate + ", " +
				"leg1FixedRateInitial=" + this.leg1FixedRateInitial + ", " +
				"leg2FixedRateInitial=" + this.leg2FixedRateInitial + ", " +
				"payment1Amount=" + this.payment1Amount + ", " +
				"payment1Currency=" + this.payment1Currency + ", " +
				"payment1Payer=" + this.payment1Payer + ", " +
				"payment1Receiver=" + this.payment1Receiver + ", " +
				"payment2Payer=" + this.payment2Payer + ", " +
				"postTradeTransactionDate=" + this.postTradeTransactionDate + ", " +
				"secondaryAssetClass=" + this.secondaryAssetClass + ", " +
				"settlementType=" + this.settlementType + ", " +
				"tradeParty1Name=" + this.tradeParty1Name + ", " +
				"tradeParty2Name=" + this.tradeParty2Name + ", " +
				"ccpValuationAmount=" + this.ccpValuationAmount + ", " +
				"ccpValuationCurrency=" + this.ccpValuationCurrency + ", " +
				"ccpValuationDatetime=" + this.ccpValuationDatetime + ", " +
				"ccpValuationType=" + this.ccpValuationType + ", " +
				"tradeParty1ValuationAmount=" + this.tradeParty1ValuationAmount + ", " +
				"tradeParty1ValuationCurrency=" + this.tradeParty1ValuationCurrency + ", " +
				"tradeParty1ValuationDatetime=" + this.tradeParty1ValuationDatetime + ", " +
				"tradeParty1ValuationType=" + this.tradeParty1ValuationType + ", " +
				"tradeParty2ValuationAmount=" + this.tradeParty2ValuationAmount + ", " +
				"tradeParty2ValuationCurrency=" + this.tradeParty2ValuationCurrency + ", " +
				"tradeParty2ValuationDatetime=" + this.tradeParty2ValuationDatetime + ", " +
				"tradeParty2ValuationType=" + this.tradeParty2ValuationType + ", " +
				"executionType=" + this.executionType + ", " +
				"strikePriceCurrency=" + this.strikePriceCurrency + ", " +
				"payment2Amount=" + this.payment2Amount + ", " +
				"tradeParty2HkCounterpartyOrigin=" + this.tradeParty2HkCounterpartyOrigin + ", " +
				"tradeParty1CountryOfTheOtherCounterparty=" + this.tradeParty1CountryOfTheOtherCounterparty + ", " +
				"tradeParty2CountryOfTheOtherCounterparty=" + this.tradeParty2CountryOfTheOtherCounterparty + ", " +
				"tradeParty1BrokerId=" + this.tradeParty1BrokerId + ", " +
				"tradeParty2BrokerId=" + this.tradeParty2BrokerId + ", " +
				"tradeParty1BeneficiaryIdType=" + this.tradeParty1BeneficiaryIdType + ", " +
				"tradeParty1BeneficiaryId=" + this.tradeParty1BeneficiaryId + ", " +
				"tradeParty2BeneficiaryIdType=" + this.tradeParty2BeneficiaryIdType + ", " +
				"tradeParty2BeneficiaryId=" + this.tradeParty2BeneficiaryId + ", " +
				"tradeParty1CounterpartySide=" + this.tradeParty1CounterpartySide + ", " +
				"tradeParty2CounterpartySide=" + this.tradeParty2CounterpartySide + ", " +
				"tradeParty1CollateralPortfolioCode=" + this.tradeParty1CollateralPortfolioCode + ", " +
				"tradeParty2CollateralPortfolioCode=" + this.tradeParty2CollateralPortfolioCode + ", " +
				"contractType=" + this.contractType + ", " +
				"euUnderlyingAssetIdType=" + this.euUnderlyingAssetIdType + ", " +
				"productClassification=" + this.productClassification + ", " +
				"complexTradeComponentId=" + this.complexTradeComponentId + ", " +
				"priceMultiplier=" + this.priceMultiplier + ", " +
				"quantity=" + this.quantity + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"confirmationDatetime=" + this.confirmationDatetime + ", " +
				"clearingDatetime=" + this.clearingDatetime + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"level=" + this.level + ", " +
				"productClassificationType=" + this.productClassificationType + ", " +
				"productIdentificationType=" + this.productIdentificationType + ", " +
				"productIdentification=" + this.productIdentification + ", " +
				"euUnderlyingAssetId=" + this.euUnderlyingAssetId + ", " +
				"reportTrackingNumber=" + this.reportTrackingNumber + ", " +
				"tradeParty1BrokerIdType=" + this.tradeParty1BrokerIdType + ", " +
				"tradeParty2BrokerIdType=" + this.tradeParty2BrokerIdType + ", " +
				"tradeParty2ClearingBrokerIdType=" + this.tradeParty2ClearingBrokerIdType + ", " +
				"tradeParty2ClearingBrokerId=" + this.tradeParty2ClearingBrokerId + ", " +
				"tradeParty1ClearingThreshold=" + this.tradeParty1ClearingThreshold + ", " +
				"tradeParty2ClearingThreshold=" + this.tradeParty2ClearingThreshold + ", " +
				"tradeParty1CorporateSectorType=" + this.tradeParty1CorporateSectorType + ", " +
				"tradeParty2CorporateSectorType=" + this.tradeParty2CorporateSectorType + ", " +
				"tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator=" + this.tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator + ", " +
				"tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator=" + this.tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator + ", " +
				"intragroupIndicator=" + this.intragroupIndicator + ", " +
				"tradeParty1TradingCapacity1=" + this.tradeParty1TradingCapacity1 + ", " +
				"tradeParty2TradingCapacity1=" + this.tradeParty2TradingCapacity1 + ", " +
				"currencyOfPrice=" + this.currencyOfPrice + ", " +
				"tradeParty1CollateralPortfolio=" + this.tradeParty1CollateralPortfolio + ", " +
				"tradeParty2CollateralPortfolio=" + this.tradeParty2CollateralPortfolio + ", " +
				"executionVenueMicCode=" + this.executionVenueMicCode + ", " +
				"payment2Currency=" + this.payment2Currency + ", " +
				"expirationDateTimeBusinessCenter=" + this.expirationDateTimeBusinessCenter + ", " +
				"expirationTime=" + this.expirationTime + ", " +
				"expirationTimeType=" + this.expirationTimeType + ", " +
				"tradeParty1TraderLocation=" + this.tradeParty1TraderLocation + ", " +
				"tradeParty2TraderLocation=" + this.tradeParty2TraderLocation + ", " +
				"payment3ResetFrequencyPeriodMultiplier=" + this.payment3ResetFrequencyPeriodMultiplier + ", " +
				"payment3ResetFrequencyPeriod=" + this.payment3ResetFrequencyPeriod + ", " +
				"payment4ResetFrequencyPeriodMultiplier=" + this.payment4ResetFrequencyPeriodMultiplier + ", " +
				"payment4ResetFrequencyPeriod=" + this.payment4ResetFrequencyPeriod + ", " +
				"payment5ResetFrequencyPeriodMultiplier=" + this.payment5ResetFrequencyPeriodMultiplier + ", " +
				"payment5ResetFrequencyPeriod=" + this.payment5ResetFrequencyPeriod + ", " +
				"payment1Type=" + this.payment1Type + ", " +
				"payment1Reference=" + this.payment1Reference + ", " +
				"payment2Type=" + this.payment2Type + ", " +
				"payment2Reference=" + this.payment2Reference + ", " +
				"payment3Payer=" + this.payment3Payer + ", " +
				"payment3Reference=" + this.payment3Reference + ", " +
				"payment3FrequencyPeriod=" + this.payment3FrequencyPeriod + ", " +
				"payment3FrequencyPeriodMultiplier=" + this.payment3FrequencyPeriodMultiplier + ", " +
				"payment3Date=" + this.payment3Date + ", " +
				"payment4Reference=" + this.payment4Reference + ", " +
				"payment4Payer=" + this.payment4Payer + ", " +
				"payment4FrequencyPeriod=" + this.payment4FrequencyPeriod + ", " +
				"payment4FrequencyPeriodMultiplier=" + this.payment4FrequencyPeriodMultiplier + ", " +
				"payment4Date=" + this.payment4Date + ", " +
				"payment5Reference=" + this.payment5Reference + ", " +
				"payment5Payer=" + this.payment5Payer + ", " +
				"payment5FrequencyPeriod=" + this.payment5FrequencyPeriod + ", " +
				"payment5FrequencyPeriodMultiplier=" + this.payment5FrequencyPeriodMultiplier + ", " +
				"payment5Date=" + this.payment5Date + ", " +
				"payment3Type=" + this.payment3Type + ", " +
				"premiumPayer=" + this.premiumPayer + ", " +
				"premiumPaymentDateUnadjusted=" + this.premiumPaymentDateUnadjusted + ", " +
				"tradeParty1NatureOfTheReportingCounterparty=" + this.tradeParty1NatureOfTheReportingCounterparty + ", " +
				"tradeParty2NatureOfTheReportingCounterparty=" + this.tradeParty2NatureOfTheReportingCounterparty + ", " +
				"reservedParticipantUse1=" + this.reservedParticipantUse1 + ", " +
				"reservedParticipantUse2=" + this.reservedParticipantUse2 + ", " +
				"reservedParticipantUse3=" + this.reservedParticipantUse3 + ", " +
				"reservedParticipantUse4=" + this.reservedParticipantUse4 + ", " +
				"reservedParticipantUse5=" + this.reservedParticipantUse5 + ", " +
				"leg1TerminationDate=" + this.leg1TerminationDate + ", " +
				"allocationType=" + this.allocationType + ", " +
				"calculationBasis=" + this.calculationBasis + ", " +
				"clearingExceptionPartyId=" + this.clearingExceptionPartyId + ", " +
				"clearingExceptionPartyIdType=" + this.clearingExceptionPartyIdType + ", " +
				"clearingExceptionType=" + this.clearingExceptionType + ", " +
				"clearingMemberClientAccountId=" + this.clearingMemberClientAccountId + ", " +
				"clearingReceiptDatetime=" + this.clearingReceiptDatetime + ", " +
				"clearingSwapSdrLeiId=" + this.clearingSwapSdrLeiId + ", " +
				"clearingSwapUtiId=" + this.clearingSwapUtiId + ", " +
				"collateralReportingDate=" + this.collateralReportingDate + ", " +
				"collateralValuationDatetime=" + this.collateralValuationDatetime + ", " +
				"comment2=" + this.comment2 + ", " +
				"commodityStrikePriceUnit=" + this.commodityStrikePriceUnit + ", " +
				"executionAgentMaskingIndicator=" + this.executionAgentMaskingIndicator + ", " +
				"feeInCurrency=" + this.feeInCurrency + ", " +
				"feeOutCurrency=" + this.feeOutCurrency + ", " +
				"floatingRatePaymentFrequencyLeg1Multiplier=" + this.floatingRatePaymentFrequencyLeg1Multiplier + ", " +
				"floatingRatePaymentFrequencyLeg1TimePeriod=" + this.floatingRatePaymentFrequencyLeg1TimePeriod + ", " +
				"floatingRatePaymentFrequencyLeg2Multiplier=" + this.floatingRatePaymentFrequencyLeg2Multiplier + ", " +
				"floatingRatePaymentFrequencyLeg2TimePeriod=" + this.floatingRatePaymentFrequencyLeg2TimePeriod + ", " +
				"frequencyOfPayment=" + this.frequencyOfPayment + ", " +
				"interaffiliate=" + this.interaffiliate + ", " +
				"largeTradeIndicator=" + this.largeTradeIndicator + ", " +
				"leg1EffectiveDateAdjusted=" + this.leg1EffectiveDateAdjusted + ", " +
				"leg1FinalValuationDate=" + this.leg1FinalValuationDate + ", " +
				"leg1SettlementPeriod=" + this.leg1SettlementPeriod + ", " +
				"leg2EffectiveDateAdjusted=" + this.leg2EffectiveDateAdjusted + ", " +
				"leg2PaymentTermsFrequencyPeriod=" + this.leg2PaymentTermsFrequencyPeriod + ", " +
				"leg2PaymentTermsPaymentFrequencyPeriodMultiplier=" + this.leg2PaymentTermsPaymentFrequencyPeriodMultiplier + ", " +
				"leg2SettlementType=" + this.leg2SettlementType + ", " +
				"leg2UnderlyingAssetId=" + this.leg2UnderlyingAssetId + ", " +
				"leg2UnderlyingAssetIdType=" + this.leg2UnderlyingAssetIdType + ", " +
				"leg2UnderlyingAssetName=" + this.leg2UnderlyingAssetName + ", " +
				"maturityDate=" + this.maturityDate + ", " +
				"optionalEarlyTerminationDate=" + this.optionalEarlyTerminationDate + ", " +
				"optionCommodityCurrency=" + this.optionCommodityCurrency + ", " +
				"optionCommodityExchangeId=" + this.optionCommodityExchangeId + ", " +
				"optionCommodityInstrumentId=" + this.optionCommodityInstrumentId + ", " +
				"optionCommodityRateSource=" + this.optionCommodityRateSource + ", " +
				"optionCommodityRateSourcePage=" + this.optionCommodityRateSourcePage + ", " +
				"optionCommodityUnderlyerDetails=" + this.optionCommodityUnderlyerDetails + ", " +
				"optionCommodityUnderlyerId=" + this.optionCommodityUnderlyerId + ", " +
				"optionCommodityUnitOfMeasure=" + this.optionCommodityUnitOfMeasure + ", " +
				"optionSpecifiedPrice=" + this.optionSpecifiedPrice + ", " +
				"optionSpreadAmount=" + this.optionSpreadAmount + ", " +
				"optionSpreadCurrency=" + this.optionSpreadCurrency + ", " +
				"optionSpreadSchedule=" + this.optionSpreadSchedule + ", " +
				"origin=" + this.origin + ", " +
				"originalSwapSdrId=" + this.originalSwapSdrId + ", " +
				"originalSwapSdrIdType=" + this.originalSwapSdrIdType + ", " +
				"paymentFrequencyPeriodLeg1=" + this.paymentFrequencyPeriodLeg1 + ", " +
				"paymentFrequencyPeriodLeg2=" + this.paymentFrequencyPeriodLeg2 + ", " +
				"paymentFrequencyPeriodMultiplierLeg1=" + this.paymentFrequencyPeriodMultiplierLeg1 + ", " +
				"paymentFrequencyPeriodMultiplierLeg2=" + this.paymentFrequencyPeriodMultiplierLeg2 + ", " +
				"premiumPayerPrefix=" + this.premiumPayerPrefix + ", " +
				"price1Currency=" + this.price1Currency + ", " +
				"price2Price=" + this.price2Price + ", " +
				"price2Type=" + this.price2Type + ", " +
				"price2Units=" + this.price2Units + ", " +
				"price3Price=" + this.price3Price + ", " +
				"price3Type=" + this.price3Type + ", " +
				"price3Units=" + this.price3Units + ", " +
				"price4Price=" + this.price4Price + ", " +
				"price4Type=" + this.price4Type + ", " +
				"price4Units=" + this.price4Units + ", " +
				"pricingContext=" + this.pricingContext + ", " +
				"priorUsiType=" + this.priorUsiType + ", " +
				"priorUtiType=" + this.priorUtiType + ", " +
				"recoveryPrice=" + this.recoveryPrice + ", " +
				"sendToDataCenterCode=" + this.sendToDataCenterCode + ", " +
				"strikePriceType=" + this.strikePriceType + ", " +
				"subAssetClassForOtherCommodity=" + this.subAssetClassForOtherCommodity + ", " +
				"tradeParty1CftcFinancialEntityStatus=" + this.tradeParty1CftcFinancialEntityStatus + ", " +
				"tradeParty1CollateralAmount=" + this.tradeParty1CollateralAmount + ", " +
				"tradeParty1CollateralCurrency=" + this.tradeParty1CollateralCurrency + ", " +
				"tradeParty1MandatoryDelegatedReporting=" + this.tradeParty1MandatoryDelegatedReporting + ", " +
				"tradeParty1Role=" + this.tradeParty1Role + ", " +
				"tradeParty2CftcFinancialEntityStatus=" + this.tradeParty2CftcFinancialEntityStatus + ", " +
				"tradeParty2CollateralAmount=" + this.tradeParty2CollateralAmount + ", " +
				"tradeParty2CollateralCurrency=" + this.tradeParty2CollateralCurrency + ", " +
				"tradeParty2MandatoryDelegatedReporting=" + this.tradeParty2MandatoryDelegatedReporting + ", " +
				"tradeParty2Role=" + this.tradeParty2Role + ", " +
				"upfrontPayment=" + this.upfrontPayment + ", " +
				"verificationMethod=" + this.verificationMethod + ", " +
				"responsibleDataSubmitterId=" + this.responsibleDataSubmitterId + ", " +
				"responsibleDataSubmitterIdType=" + this.responsibleDataSubmitterIdType + ", " +
				"originalSwapUsi=" + this.originalSwapUsi + ", " +
				"originalSwapUti=" + this.originalSwapUti + ", " +
				"cdeReceiverIdentifierLeg2=" + this.cdeReceiverIdentifierLeg2 + ", " +
				"counterparty1FederalEntityIndicator=" + this.counterparty1FederalEntityIndicator + ", " +
				"counterparty2FederalEntityIndicator=" + this.counterparty2FederalEntityIndicator + ", " +
				"customBasketIndicator=" + this.customBasketIndicator + ", " +
				"noaActionType=" + this.noaActionType + ", " +
				"eventType=" + this.eventType + ", " +
				"amendmentIndicator=" + this.amendmentIndicator + ", " +
				"eventIdentifier=" + this.eventIdentifier + ", " +
				"cdeCallAmountLeg1=" + this.cdeCallAmountLeg1 + ", " +
				"cdeCallAmountLeg2=" + this.cdeCallAmountLeg2 + ", " +
				"cdeCallCurrencyLeg1=" + this.cdeCallCurrencyLeg1 + ", " +
				"cdeCallCurrencyLeg2=" + this.cdeCallCurrencyLeg2 + ", " +
				"cdePutAmountLeg1=" + this.cdePutAmountLeg1 + ", " +
				"cdePutAmountLeg2=" + this.cdePutAmountLeg2 + ", " +
				"cdePutCurrencyLeg1=" + this.cdePutCurrencyLeg1 + ", " +
				"cdePutCurrencyLeg2=" + this.cdePutCurrencyLeg2 + ", " +
				"leg2QuantityFrequency=" + this.leg2QuantityFrequency + ", " +
				"quantityFrequencyMultiplierLeg1=" + this.quantityFrequencyMultiplierLeg1 + ", " +
				"quantityFrequencyMultiplierLeg2=" + this.quantityFrequencyMultiplierLeg2 + ", " +
				"cdeQuantityUnitOfMeasureLeg1=" + this.cdeQuantityUnitOfMeasureLeg1 + ", " +
				"cdeQuantityUnitOfMeasureLeg2=" + this.cdeQuantityUnitOfMeasureLeg2 + ", " +
				"packageIndicator=" + this.packageIndicator + ", " +
				"cdePackageIdentifier=" + this.cdePackageIdentifier + ", " +
				"cdePackageTransactionPrice=" + this.cdePackageTransactionPrice + ", " +
				"cdePackageTransactionPriceCurrency=" + this.cdePackageTransactionPriceCurrency + ", " +
				"cdePackageTransactionPriceNotation=" + this.cdePackageTransactionPriceNotation + ", " +
				"cdePackageTransactionSpread=" + this.cdePackageTransactionSpread + ", " +
				"cdePackageTransactionSpreadCurrency=" + this.cdePackageTransactionSpreadCurrency + ", " +
				"cdePackageTransactionSpreadNotation=" + this.cdePackageTransactionSpreadNotation + ", " +
				"cdeFixedRateDayCountConventionLeg1=" + this.cdeFixedRateDayCountConventionLeg1 + ", " +
				"cdeFixedRateDayCountConventionLeg2=" + this.cdeFixedRateDayCountConventionLeg2 + ", " +
				"cdeFloatingRateDayCountConventionLeg1=" + this.cdeFloatingRateDayCountConventionLeg1 + ", " +
				"cdeFloatingRateDayCountConventionLeg2=" + this.cdeFloatingRateDayCountConventionLeg2 + ", " +
				"fixingDateLeg1=" + this.fixingDateLeg1 + ", " +
				"fixingDateLeg2=" + this.fixingDateLeg2 + ", " +
				"cdeFixedRatePaymentFrequencyPeriodLeg1=" + this.cdeFixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"cdeFixedRatePaymentFrequencyPeriodLeg2=" + this.cdeFixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"cdeFloatingRatePaymentFrequencyPeriodLeg1=" + this.cdeFloatingRatePaymentFrequencyPeriodLeg1 + ", " +
				"cdeFloatingRatePaymentFrequencyPeriodLeg2=" + this.cdeFloatingRatePaymentFrequencyPeriodLeg2 + ", " +
				"cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1=" + this.cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2=" + this.cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"postPricedSwapIndicator=" + this.postPricedSwapIndicator + ", " +
				"cdePriceCurrency=" + this.cdePriceCurrency + ", " +
				"cdePriceNotation=" + this.cdePriceNotation + ", " +
				"cdeSpreadNotationLeg1=" + this.cdeSpreadNotationLeg1 + ", " +
				"cdeSpreadNotationLeg2=" + this.cdeSpreadNotationLeg2 + ", " +
				"cdeStrikePriceCurrency2=" + this.cdeStrikePriceCurrency2 + ", " +
				"cdeStrikePriceNotation=" + this.cdeStrikePriceNotation + ", " +
				"cdeFirstExerciseDate=" + this.cdeFirstExerciseDate + ", " +
				"cdeFinalContractualSettlementDate=" + this.cdeFinalContractualSettlementDate + ", " +
				"cdeSettlementLocationLeg1=" + this.cdeSettlementLocationLeg1 + ", " +
				"cdeSettlementLocationLeg2=" + this.cdeSettlementLocationLeg2 + ", " +
				"cdeEffectiveDate=" + this.cdeEffectiveDate + ", " +
				"cdeExpirationDate=" + this.cdeExpirationDate + ", " +
				"cdePlatformIdentifier=" + this.cdePlatformIdentifier + ", " +
				"primeBrokerageTransactionIndicator=" + this.primeBrokerageTransactionIndicator + ", " +
				"swapReportingJurisdiction=" + this.swapReportingJurisdiction + ", " +
				"newSdrIdentifier=" + this.newSdrIdentifier + ", " +
				"nextFloatingReferenceResetDateLeg1=" + this.nextFloatingReferenceResetDateLeg1 + ", " +
				"lastFloatingReferenceValueLeg1=" + this.lastFloatingReferenceValueLeg1 + ", " +
				"lastFloatingReferenceResetDateLeg1=" + this.lastFloatingReferenceResetDateLeg1 + ", " +
				"nextFloatingReferenceResetDateLeg2=" + this.nextFloatingReferenceResetDateLeg2 + ", " +
				"lastFloatingReferenceValueLeg2=" + this.lastFloatingReferenceValueLeg2 + ", " +
				"lastFloatingReferenceResetDateLeg2=" + this.lastFloatingReferenceResetDateLeg2 + ", " +
				"cdeDelta=" + this.cdeDelta + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"largeNotionalOffFacilitySwapElectionIndicator=" + this.largeNotionalOffFacilitySwapElectionIndicator + ", " +
				"sefOrDcmAnonymousExecutionIndicator=" + this.sefOrDcmAnonymousExecutionIndicator + ", " +
				"blockTradeElectionIndicator=" + this.blockTradeElectionIndicator + ", " +
				"sefOrDcmIndicator=" + this.sefOrDcmIndicator + ", " +
				"mandatoryClearingIndicator=" + this.mandatoryClearingIndicator + ", " +
				"sdMspIndicatorCounterparty1=" + this.sdMspIndicatorCounterparty1 + ", " +
				"sdMspIndicatorCounterparty2=" + this.sdMspIndicatorCounterparty2 + ", " +
				"physicalCommodityContractIndicator=" + this.physicalCommodityContractIndicator + ", " +
				"changeInNotionalAmount1=" + this.changeInNotionalAmount1 + ", " +
				"changeInNotionalAmount2=" + this.changeInNotionalAmount2 + ", " +
				"changeInLeg1NotionalQuantity=" + this.changeInLeg1NotionalQuantity + ", " +
				"changeInLeg2NotionalQuantity=" + this.changeInLeg2NotionalQuantity + ", " +
				"cdeCryptoAssetUnderlyingIndicatorLeg1=" + this.cdeCryptoAssetUnderlyingIndicatorLeg1 + ", " +
				"cdeCryptoAssetUnderlyingIndicatorLeg2=" + this.cdeCryptoAssetUnderlyingIndicatorLeg2 + ", " +
				"cdeCustomBasketCode=" + this.cdeCustomBasketCode + ", " +
				"underlierIdOtherLeg1=" + this.underlierIdOtherLeg1 + ", " +
				"underlierIdOtherLeg2=" + this.underlierIdOtherLeg2 + ", " +
				"underlierIdOtherSourceLeg1=" + this.underlierIdOtherSourceLeg1 + ", " +
				"underlierIdOtherSourceLeg2=" + this.underlierIdOtherSourceLeg2 + ", " +
				"cdeUnderlyingAssetTradingPlatformIdLeg1=" + this.cdeUnderlyingAssetTradingPlatformIdLeg1 + ", " +
				"cdeUnderlyingAssetTradingPlatformIdLeg2=" + this.cdeUnderlyingAssetTradingPlatformIdLeg2 + ", " +
				"cdeUnderlyingAssetPriceSourceLeg1=" + this.cdeUnderlyingAssetPriceSourceLeg1 + ", " +
				"cdeUnderlyingAssetPriceSourceLeg2=" + this.cdeUnderlyingAssetPriceSourceLeg2 +
			'}';
		}
	}

	/*********************** Builder Implementation of HarmonizedData  ***********************/
	class HarmonizedDataBuilderImpl implements HarmonizedData.HarmonizedDataBuilder {
	
		protected String leg2CommodityInstrumentId;
		protected String leg2CommodityUnderlyerId;
		protected String leg2CommodityUnderlyerDetails;
		protected String leg2CommodityUnitOfMeasure;
		protected String leg2CommodityCurrency;
		protected String leg2CommodityExchangeId;
		protected String leg1CommodityRateSource;
		protected String leg1CommodityRateSourcePage;
		protected String leg2SpecifiedPrice;
		protected Date commencementDateUnadjusted;
		protected Date exerciseExpirationDateUnadjusted;
		protected Date expirationDateUnadjusted;
		protected String leg2NotionalQuantityFrequency;
		protected BigDecimal leg2NotionalQuantity;
		protected BigDecimal leg2TotalNotionalQuantity;
		protected BigDecimal leg2SpreadAmount;
		protected String leg2SpreadCurrency;
		protected Date scheduledTerminationDateAdjusted;
		protected String leg1PartyPayer;
		protected String leg2PartyPayer;
		protected String leg1CommodityInstrumentId;
		protected String leg1CommodityUnderlyerId;
		protected String leg1CommodityUnitOfMeasure;
		protected String leg1CommodityExchangeId;
		protected String leg2CommodityRateSource;
		protected Date leg1EffectiveDateUnadjusted;
		protected Date leg2EffectiveDateUnadjusted;
		protected String coProductType;
		protected String totalQuantityUnit;
		protected BigDecimal totalQuantity;
		protected BigDecimal fixedPrice;
		protected String fixedPriceCurrency;
		protected String leg1NotionalQuantityUnit;
		protected String leg1NotionalQuantityFrequency;
		protected BigDecimal leg1NotionalQuantity;
		protected BigDecimal leg1TotalNotionalQuantity;
		protected String leg1CommodityCurrency;
		protected String leg1SpecifiedPrice;
		protected String leg1SpreadCurrency;
		protected BigDecimal leg1SpreadAmount;
		protected String leg2NotionalQuantityUnit;
		protected String leg2PartyReceiver;
		protected String leg1PartyReceiver;
		protected String coalSource;
		protected BigDecimal leg2Quantity;
		protected String commodityBase;
		protected String commodityDetails;
		protected String interconnectionPoint;
		protected String loadType;
		protected String fixedPriceUnit;
		protected Date exercisePaymentDateUnadjusted;
		protected Date leg1PaymentDatesUnadjusted;
		protected Date leg2PaymentDateUnadjusted;
		protected Date settlementDateUnadjusted;
		protected String deliveryLocation;
		protected String leg2QuantityUnit;
		protected String leg1CommodityUnderlyerDetails;
		protected String leg2CommodityRateSourcePage;
		protected Date valueDate;
		protected String gtrQuantityUnit;
		protected BigDecimal attachmentPoint;
		protected BigDecimal exhaustionPoint;
		protected BigDecimal mthToDefault;
		protected BigDecimal nthToDefault;
		protected String seniority;
		protected BigDecimal series;
		protected BigDecimal crversion;
		protected String tranche;
		protected BigDecimal indexFactor;
		protected String referenceObligation;
		protected String referenceObligationIdType;
		protected String underlyingFixedRatePayerBuyer;
		protected String underlyingFloatRatePayerSeller;
		protected String underlyingAssetExchangeId;
		protected BigDecimal underlyingAssetNumberOfUnits;
		protected String optionalEarlyTerminationType;
		protected String optionalEarlyTerminationElectingPartyValue;
		protected Boolean optionalEarlyTerminationIndicator;
		protected String underlyingAssetFloatingAmountPayer;
		protected String underlyingAssetFloatingAmountReceiver;
		protected String floatingRateOption;
		protected BigDecimal underlyingAssetFloatingLegSpread;
		protected String leg2DesignatedMaturityPeriod;
		protected BigDecimal leg2DesignatedMaturityPeriodMultiplier;
		protected String underlyingAssetEquityAmountPayer;
		protected String underlyingAssetEquityAmountReceiver;
		protected String underlyingAssetInitialPriceCurrency;
		protected Date leg1ValuationDates;
		protected String leg1TypeOfReturn;
		protected Date observationStartDate;
		protected BigDecimal varianceAmount;
		protected BigDecimal volatilityStrikePrice;
		protected BigDecimal varianceStrikePrice;
		protected BigDecimal varianceCapFactor;
		protected String referenceCurrency;
		protected String specialDividendsIndicator;
		protected String materialNoncashDividendIndicator;
		protected BigDecimal numberOfSharesUnits;
		protected String dividendAmountPayer;
		protected String dividendAmountReceiver;
		protected String fixedAmountPayer;
		protected String fixedAmountReceiver;
		protected String knockInEvent;
		protected String knockOutEvent;
		protected BigDecimal knockInPrice;
		protected BigDecimal knockOutPrice;
		protected String barrierType;
		protected LocalTime earliestExecutionTime;
		protected BigDecimal exchangeRate;
		protected String exchangeRateBasisCurrency1;
		protected String exchangeRateBasisCurrency2;
		protected Date executionPeriodStartDate;
		protected String payoutStyle;
		protected String rateQuoteBasis1;
		protected Date settlementFixingDate;
		protected String swapLinkId;
		protected String triggerCondition;
		protected String triggerCondition2;
		protected BigDecimal triggerRate;
		protected BigDecimal triggerRate2;
		protected String rateQuoteBasis2;
		protected BigDecimal forwardExchangeRate;
		protected String barrierType2;
		protected String cancelationOptionBuyer;
		protected Date cancelationOptionCommencementDate;
		protected String cancelationOptionExerciseStyleType;
		protected Date cancelationOptionExpirationDate;
		protected String cancelationOptionInitialFeeCurrency;
		protected String cancelationOptionInitialFeePayer;
		protected BigDecimal cancelationOptionPremiumAmount;
		protected String cancelationOptionSeller;
		protected BigDecimal capRateInitial;
		protected String couponType;
		protected Boolean finalPrincipalExchangeIndicatorAtTermination;
		protected BigDecimal floorRateInitial;
		protected String fraDiscountingType;
		protected BigDecimal inflationIndexInitialLevel;
		protected String inflationIndexMainPublication;
		protected String inflationInterpolationMethod;
		protected String inflationLagDayType;
		protected String inflationLagPeriod;
		protected String inflationRateSourceName;
		protected Boolean initialPrincipalExchangeIndicator;
		protected Boolean intermediatePrincipalExchangeIndicator;
		protected String leg1FloatingRateIndex;
		protected BigDecimal leg1FloatingRateInitialSpread;
		protected BigDecimal leg1FloatingRateMultiplierInitialValue;
		protected String leg1FloatingRateTenorPeriod;
		protected BigDecimal leg1FloatingRateTenorPeriodMultiplier;
		protected BigDecimal leg1KnownAmount;
		protected String leg1KnownAmountCurrency;
		protected String leg1ReferenceCurrency;
		protected String leg2FloatingRateIndex;
		protected BigDecimal leg2FloatingRateInitialSpread;
		protected BigDecimal leg2FloatingRateMultiplierInitialValue;
		protected String leg2FloatingRateTenorPeriod;
		protected BigDecimal leg2FloatingRateTenorPeriodMultiplier;
		protected BigDecimal leg2KnownAmount;
		protected String leg2KnownAmountCurrency;
		protected String leg2ReferenceCurrency;
		protected Date mandatoryEarlyTerminationDate;
		protected String mandatoryEarlyTerminationDateTenorPeriod;
		protected String mandatoryEarlyTerminationDateTenorPeriodMultiplier;
		protected BigDecimal notionalUnits;
		protected Date optionalEarlyTerminationCommencementDate;
		protected String optionalEarlyTerminationExerciseStyle;
		protected Date optionalEarlyTerminationExpirationDate;
		protected String premiumReceiver;
		protected BigDecimal underlyingCouponRate;
		protected Date underlyingMaturityDate;
		protected String underlyingProductId;
		protected String inflationLagPeriodMultiplier;
		protected String leg1FixedRateNotation;
		protected String leg2FixedRateNotation;
		protected String swaptionStraddleIndicator;
		protected String singlePartyEarlyTerminationBuyer;
		protected Date leg1EffectiveDate;
		protected String action;
		protected String clearingStatus;
		protected Date effectiveDate1;
		protected String executionVenueType;
		protected Boolean nonStandardTradeIndicator;
		protected BigDecimal notionalAmount1;
		protected String notionalCurrency1;
		protected BigDecimal price1Price;
		protected String price1Type;
		protected String price1Units;
		protected Date scheduledTerminationDate1;
		protected Date tradeDate;
		protected String tradeParty1CollateralizationType;
		protected String tradeParty1EventId;
		protected String tradeParty2CollateralizationType;
		protected String tradeParty2EventId;
		protected String embeddedOptionOnSwap;
		protected Date expirationDate;
		protected BigDecimal notionalAmount2;
		protected String notionalCurrency2;
		protected BigDecimal premiumAmount;
		protected String premiumCurrency;
		protected String version;
		protected String comment1;
		protected String optionStyle;
		protected String optionType;
		protected String settlementCurrency1;
		protected Date commencementDate;
		protected String dayCountFraction1;
		protected String leg2DayCountFraction;
		protected Date leg2EffectiveDate;
		protected String leg2ResetFrequencyPeriod;
		protected BigDecimal leg2ResetFrequencyPeriodMultiplier;
		protected String leg2SettlementCurrency;
		protected Date leg2ScheduledTerminationDate;
		protected BigDecimal numberOfOptions;
		protected BigDecimal optionEntitlement;
		protected ZonedDateTime originalExecutionTimestamp;
		protected Date payment1Date;
		protected String payment1FrequencyPeriod;
		protected BigDecimal payment1FrequencyPeriodMultiplier;
		protected Date payment2Date;
		protected String payment2FrequencyPeriod;
		protected BigDecimal payment2FrequencyPeriodMultiplier;
		protected String resetFrequencyPeriod1;
		protected BigDecimal resetFrequencyPeriodMultiplier1;
		protected Date settlementDate;
		protected BigDecimal strikePrice;
		protected String strikePriceUnits;
		protected ZonedDateTime asOfDateTime;
		protected String clearingVenueId;
		protected String clearingVenueIdType;
		protected String compressedTradeIndicator;
		protected String confirmationMethod;
		protected String confirmationPlatformId;
		protected String confirmationPlatformTradeId;
		protected String executionVenueId;
		protected String executionVenueIdType;
		protected Date postTradeEffectiveDate;
		protected String priorUsiId;
		protected String priorUsiIdPrefix;
		protected String priorUtiId;
		protected String priorUtiIdPrefix;
		protected String tradeParty1BranchLocation;
		protected String tradeParty1ClearingBrokerId;
		protected String tradeParty1ClearingBrokerIdType;
		protected String tradeParty1DeskLocation;
		protected String tradeParty1Domicile;
		protected String tradeParty1IndustrialSectorType;
		protected String tradeParty2BranchLocation;
		protected String tradeParty2DeskLocation;
		protected String tradeParty2Domicile;
		protected String tradeParty2IndustrialSectorType;
		protected String sellerPayer2;
		protected String buyerPayer1;
		protected String tradeParty1HkCounterpartyOrigin;
		protected Date leg2SettlementDate;
		protected BigDecimal leg1FixedRateInitial;
		protected BigDecimal leg2FixedRateInitial;
		protected BigDecimal payment1Amount;
		protected String payment1Currency;
		protected String payment1Payer;
		protected String payment1Receiver;
		protected String payment2Payer;
		protected Date postTradeTransactionDate;
		protected String secondaryAssetClass;
		protected String settlementType;
		protected String tradeParty1Name;
		protected String tradeParty2Name;
		protected BigDecimal ccpValuationAmount;
		protected String ccpValuationCurrency;
		protected ZonedDateTime ccpValuationDatetime;
		protected String ccpValuationType;
		protected BigDecimal tradeParty1ValuationAmount;
		protected String tradeParty1ValuationCurrency;
		protected ZonedDateTime tradeParty1ValuationDatetime;
		protected String tradeParty1ValuationType;
		protected BigDecimal tradeParty2ValuationAmount;
		protected String tradeParty2ValuationCurrency;
		protected ZonedDateTime tradeParty2ValuationDatetime;
		protected String tradeParty2ValuationType;
		protected String executionType;
		protected String strikePriceCurrency;
		protected BigDecimal payment2Amount;
		protected String tradeParty2HkCounterpartyOrigin;
		protected String tradeParty1CountryOfTheOtherCounterparty;
		protected String tradeParty2CountryOfTheOtherCounterparty;
		protected String tradeParty1BrokerId;
		protected String tradeParty2BrokerId;
		protected String tradeParty1BeneficiaryIdType;
		protected String tradeParty1BeneficiaryId;
		protected String tradeParty2BeneficiaryIdType;
		protected String tradeParty2BeneficiaryId;
		protected String tradeParty1CounterpartySide;
		protected String tradeParty2CounterpartySide;
		protected String tradeParty1CollateralPortfolioCode;
		protected String tradeParty2CollateralPortfolioCode;
		protected String contractType;
		protected String euUnderlyingAssetIdType;
		protected String productClassification;
		protected String complexTradeComponentId;
		protected BigDecimal priceMultiplier;
		protected BigDecimal quantity;
		protected String masterAgreementType;
		protected String masterAgreementVersion;
		protected ZonedDateTime confirmationDatetime;
		protected ZonedDateTime clearingDatetime;
		protected Date maturityDateOfTheUnderlying;
		protected String level;
		protected String productClassificationType;
		protected String productIdentificationType;
		protected String productIdentification;
		protected String euUnderlyingAssetId;
		protected String reportTrackingNumber;
		protected String tradeParty1BrokerIdType;
		protected String tradeParty2BrokerIdType;
		protected String tradeParty2ClearingBrokerIdType;
		protected String tradeParty2ClearingBrokerId;
		protected Boolean tradeParty1ClearingThreshold;
		protected Boolean tradeParty2ClearingThreshold;
		protected String tradeParty1CorporateSectorType;
		protected String tradeParty2CorporateSectorType;
		protected String tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		protected String tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		protected Boolean intragroupIndicator;
		protected String tradeParty1TradingCapacity1;
		protected String tradeParty2TradingCapacity1;
		protected String currencyOfPrice;
		protected String tradeParty1CollateralPortfolio;
		protected String tradeParty2CollateralPortfolio;
		protected String executionVenueMicCode;
		protected String payment2Currency;
		protected String expirationDateTimeBusinessCenter;
		protected LocalTime expirationTime;
		protected String expirationTimeType;
		protected String tradeParty1TraderLocation;
		protected String tradeParty2TraderLocation;
		protected BigDecimal payment3ResetFrequencyPeriodMultiplier;
		protected String payment3ResetFrequencyPeriod;
		protected BigDecimal payment4ResetFrequencyPeriodMultiplier;
		protected String payment4ResetFrequencyPeriod;
		protected BigDecimal payment5ResetFrequencyPeriodMultiplier;
		protected String payment5ResetFrequencyPeriod;
		protected String payment1Type;
		protected String payment1Reference;
		protected String payment2Type;
		protected String payment2Reference;
		protected String payment3Payer;
		protected String payment3Reference;
		protected String payment3FrequencyPeriod;
		protected BigDecimal payment3FrequencyPeriodMultiplier;
		protected Date payment3Date;
		protected String payment4Reference;
		protected String payment4Payer;
		protected String payment4FrequencyPeriod;
		protected BigDecimal payment4FrequencyPeriodMultiplier;
		protected Date payment4Date;
		protected String payment5Reference;
		protected String payment5Payer;
		protected String payment5FrequencyPeriod;
		protected BigDecimal payment5FrequencyPeriodMultiplier;
		protected Date payment5Date;
		protected String payment3Type;
		protected String premiumPayer;
		protected Date premiumPaymentDateUnadjusted;
		protected String tradeParty1NatureOfTheReportingCounterparty;
		protected String tradeParty2NatureOfTheReportingCounterparty;
		protected String reservedParticipantUse1;
		protected String reservedParticipantUse2;
		protected String reservedParticipantUse3;
		protected String reservedParticipantUse4;
		protected String reservedParticipantUse5;
		protected Date leg1TerminationDate;
		protected String allocationType;
		protected String calculationBasis;
		protected String clearingExceptionPartyId;
		protected String clearingExceptionPartyIdType;
		protected String clearingExceptionType;
		protected String clearingMemberClientAccountId;
		protected ZonedDateTime clearingReceiptDatetime;
		protected String clearingSwapSdrLeiId;
		protected String clearingSwapUtiId;
		protected Date collateralReportingDate;
		protected ZonedDateTime collateralValuationDatetime;
		protected String comment2;
		protected String commodityStrikePriceUnit;
		protected String executionAgentMaskingIndicator;
		protected String feeInCurrency;
		protected String feeOutCurrency;
		protected BigDecimal floatingRatePaymentFrequencyLeg1Multiplier;
		protected String floatingRatePaymentFrequencyLeg1TimePeriod;
		protected BigDecimal floatingRatePaymentFrequencyLeg2Multiplier;
		protected String floatingRatePaymentFrequencyLeg2TimePeriod;
		protected String frequencyOfPayment;
		protected Boolean interaffiliate;
		protected Boolean largeTradeIndicator;
		protected Date leg1EffectiveDateAdjusted;
		protected Date leg1FinalValuationDate;
		protected String leg1SettlementPeriod;
		protected Date leg2EffectiveDateAdjusted;
		protected String leg2PaymentTermsFrequencyPeriod;
		protected BigDecimal leg2PaymentTermsPaymentFrequencyPeriodMultiplier;
		protected String leg2SettlementType;
		protected String leg2UnderlyingAssetId;
		protected String leg2UnderlyingAssetIdType;
		protected String leg2UnderlyingAssetName;
		protected Date maturityDate;
		protected String optionalEarlyTerminationDate;
		protected String optionCommodityCurrency;
		protected String optionCommodityExchangeId;
		protected String optionCommodityInstrumentId;
		protected String optionCommodityRateSource;
		protected String optionCommodityRateSourcePage;
		protected String optionCommodityUnderlyerDetails;
		protected String optionCommodityUnderlyerId;
		protected String optionCommodityUnitOfMeasure;
		protected String optionSpecifiedPrice;
		protected BigDecimal optionSpreadAmount;
		protected String optionSpreadCurrency;
		protected String optionSpreadSchedule;
		protected String origin;
		protected String originalSwapSdrId;
		protected String originalSwapSdrIdType;
		protected String paymentFrequencyPeriodLeg1;
		protected String paymentFrequencyPeriodLeg2;
		protected BigDecimal paymentFrequencyPeriodMultiplierLeg1;
		protected BigDecimal paymentFrequencyPeriodMultiplierLeg2;
		protected String premiumPayerPrefix;
		protected String price1Currency;
		protected BigDecimal price2Price;
		protected String price2Type;
		protected String price2Units;
		protected BigDecimal price3Price;
		protected String price3Type;
		protected String price3Units;
		protected BigDecimal price4Price;
		protected String price4Type;
		protected String price4Units;
		protected String pricingContext;
		protected String priorUsiType;
		protected String priorUtiType;
		protected BigDecimal recoveryPrice;
		protected String sendToDataCenterCode;
		protected String strikePriceType;
		protected String subAssetClassForOtherCommodity;
		protected String tradeParty1CftcFinancialEntityStatus;
		protected BigDecimal tradeParty1CollateralAmount;
		protected String tradeParty1CollateralCurrency;
		protected String tradeParty1MandatoryDelegatedReporting;
		protected String tradeParty1Role;
		protected String tradeParty2CftcFinancialEntityStatus;
		protected BigDecimal tradeParty2CollateralAmount;
		protected String tradeParty2CollateralCurrency;
		protected String tradeParty2MandatoryDelegatedReporting;
		protected String tradeParty2Role;
		protected BigDecimal upfrontPayment;
		protected String verificationMethod;
		protected String responsibleDataSubmitterId;
		protected String responsibleDataSubmitterIdType;
		protected String originalSwapUsi;
		protected String originalSwapUti;
		protected String cdeReceiverIdentifierLeg2;
		protected Boolean counterparty1FederalEntityIndicator;
		protected Boolean counterparty2FederalEntityIndicator;
		protected Boolean customBasketIndicator;
		protected String noaActionType;
		protected String eventType;
		protected Boolean amendmentIndicator;
		protected String eventIdentifier;
		protected BigDecimal cdeCallAmountLeg1;
		protected BigDecimal cdeCallAmountLeg2;
		protected String cdeCallCurrencyLeg1;
		protected String cdeCallCurrencyLeg2;
		protected BigDecimal cdePutAmountLeg1;
		protected BigDecimal cdePutAmountLeg2;
		protected String cdePutCurrencyLeg1;
		protected String cdePutCurrencyLeg2;
		protected String leg2QuantityFrequency;
		protected BigDecimal quantityFrequencyMultiplierLeg1;
		protected BigDecimal quantityFrequencyMultiplierLeg2;
		protected String cdeQuantityUnitOfMeasureLeg1;
		protected String cdeQuantityUnitOfMeasureLeg2;
		protected Boolean packageIndicator;
		protected String cdePackageIdentifier;
		protected BigDecimal cdePackageTransactionPrice;
		protected String cdePackageTransactionPriceCurrency;
		protected String cdePackageTransactionPriceNotation;
		protected BigDecimal cdePackageTransactionSpread;
		protected String cdePackageTransactionSpreadCurrency;
		protected String cdePackageTransactionSpreadNotation;
		protected String cdeFixedRateDayCountConventionLeg1;
		protected String cdeFixedRateDayCountConventionLeg2;
		protected String cdeFloatingRateDayCountConventionLeg1;
		protected String cdeFloatingRateDayCountConventionLeg2;
		protected Date fixingDateLeg1;
		protected Date fixingDateLeg2;
		protected String cdeFixedRatePaymentFrequencyPeriodLeg1;
		protected String cdeFixedRatePaymentFrequencyPeriodLeg2;
		protected String cdeFloatingRatePaymentFrequencyPeriodLeg1;
		protected String cdeFloatingRatePaymentFrequencyPeriodLeg2;
		protected BigDecimal cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1;
		protected BigDecimal cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2;
		protected BigDecimal cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1;
		protected BigDecimal cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2;
		protected Boolean postPricedSwapIndicator;
		protected String cdePriceCurrency;
		protected String cdePriceNotation;
		protected String cdeSpreadNotationLeg1;
		protected String cdeSpreadNotationLeg2;
		protected String cdeStrikePriceCurrency2;
		protected String cdeStrikePriceNotation;
		protected Date cdeFirstExerciseDate;
		protected Date cdeFinalContractualSettlementDate;
		protected String cdeSettlementLocationLeg1;
		protected String cdeSettlementLocationLeg2;
		protected Date cdeEffectiveDate;
		protected Date cdeExpirationDate;
		protected String cdePlatformIdentifier;
		protected Boolean primeBrokerageTransactionIndicator;
		protected String swapReportingJurisdiction;
		protected String newSdrIdentifier;
		protected Date nextFloatingReferenceResetDateLeg1;
		protected BigDecimal lastFloatingReferenceValueLeg1;
		protected Date lastFloatingReferenceResetDateLeg1;
		protected Date nextFloatingReferenceResetDateLeg2;
		protected BigDecimal lastFloatingReferenceValueLeg2;
		protected Date lastFloatingReferenceResetDateLeg2;
		protected BigDecimal cdeDelta;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		protected Boolean largeNotionalOffFacilitySwapElectionIndicator;
		protected Boolean sefOrDcmAnonymousExecutionIndicator;
		protected Boolean blockTradeElectionIndicator;
		protected Boolean sefOrDcmIndicator;
		protected Boolean mandatoryClearingIndicator;
		protected Boolean sdMspIndicatorCounterparty1;
		protected Boolean sdMspIndicatorCounterparty2;
		protected Boolean physicalCommodityContractIndicator;
		protected BigDecimal changeInNotionalAmount1;
		protected BigDecimal changeInNotionalAmount2;
		protected BigDecimal changeInLeg1NotionalQuantity;
		protected BigDecimal changeInLeg2NotionalQuantity;
		protected Boolean cdeCryptoAssetUnderlyingIndicatorLeg1;
		protected Boolean cdeCryptoAssetUnderlyingIndicatorLeg2;
		protected String cdeCustomBasketCode;
		protected String underlierIdOtherLeg1;
		protected String underlierIdOtherLeg2;
		protected String underlierIdOtherSourceLeg1;
		protected String underlierIdOtherSourceLeg2;
		protected String cdeUnderlyingAssetTradingPlatformIdLeg1;
		protected String cdeUnderlyingAssetTradingPlatformIdLeg2;
		protected String cdeUnderlyingAssetPriceSourceLeg1;
		protected String cdeUnderlyingAssetPriceSourceLeg2;
		
		@Override
		@RosettaAttribute("leg2CommodityInstrumentId")
		@RuneAttribute("leg2CommodityInstrumentId")
		public String getLeg2CommodityInstrumentId() {
			return leg2CommodityInstrumentId;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerId")
		@RuneAttribute("leg2CommodityUnderlyerId")
		public String getLeg2CommodityUnderlyerId() {
			return leg2CommodityUnderlyerId;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerDetails")
		@RuneAttribute("leg2CommodityUnderlyerDetails")
		public String getLeg2CommodityUnderlyerDetails() {
			return leg2CommodityUnderlyerDetails;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnitOfMeasure")
		@RuneAttribute("leg2CommodityUnitOfMeasure")
		public String getLeg2CommodityUnitOfMeasure() {
			return leg2CommodityUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityCurrency")
		@RuneAttribute("leg2CommodityCurrency")
		public String getLeg2CommodityCurrency() {
			return leg2CommodityCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityExchangeId")
		@RuneAttribute("leg2CommodityExchangeId")
		public String getLeg2CommodityExchangeId() {
			return leg2CommodityExchangeId;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityRateSource")
		@RuneAttribute("leg1CommodityRateSource")
		public String getLeg1CommodityRateSource() {
			return leg1CommodityRateSource;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityRateSourcePage")
		@RuneAttribute("leg1CommodityRateSourcePage")
		public String getLeg1CommodityRateSourcePage() {
			return leg1CommodityRateSourcePage;
		}
		
		@Override
		@RosettaAttribute("leg2SpecifiedPrice")
		@RuneAttribute("leg2SpecifiedPrice")
		public String getLeg2SpecifiedPrice() {
			return leg2SpecifiedPrice;
		}
		
		@Override
		@RosettaAttribute("commencementDateUnadjusted")
		@RuneAttribute("commencementDateUnadjusted")
		public Date getCommencementDateUnadjusted() {
			return commencementDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("exerciseExpirationDateUnadjusted")
		@RuneAttribute("exerciseExpirationDateUnadjusted")
		public Date getExerciseExpirationDateUnadjusted() {
			return exerciseExpirationDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("expirationDateUnadjusted")
		@RuneAttribute("expirationDateUnadjusted")
		public Date getExpirationDateUnadjusted() {
			return expirationDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantityFrequency")
		@RuneAttribute("leg2NotionalQuantityFrequency")
		public String getLeg2NotionalQuantityFrequency() {
			return leg2NotionalQuantityFrequency;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantity")
		@RuneAttribute("leg2NotionalQuantity")
		public BigDecimal getLeg2NotionalQuantity() {
			return leg2NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg2TotalNotionalQuantity")
		@RuneAttribute("leg2TotalNotionalQuantity")
		public BigDecimal getLeg2TotalNotionalQuantity() {
			return leg2TotalNotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg2SpreadAmount")
		@RuneAttribute("leg2SpreadAmount")
		public BigDecimal getLeg2SpreadAmount() {
			return leg2SpreadAmount;
		}
		
		@Override
		@RosettaAttribute("leg2SpreadCurrency")
		@RuneAttribute("leg2SpreadCurrency")
		public String getLeg2SpreadCurrency() {
			return leg2SpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("scheduledTerminationDateAdjusted")
		@RuneAttribute("scheduledTerminationDateAdjusted")
		public Date getScheduledTerminationDateAdjusted() {
			return scheduledTerminationDateAdjusted;
		}
		
		@Override
		@RosettaAttribute("leg1PartyPayer")
		@RuneAttribute("leg1PartyPayer")
		public String getLeg1PartyPayer() {
			return leg1PartyPayer;
		}
		
		@Override
		@RosettaAttribute("leg2PartyPayer")
		@RuneAttribute("leg2PartyPayer")
		public String getLeg2PartyPayer() {
			return leg2PartyPayer;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityInstrumentId")
		@RuneAttribute("leg1CommodityInstrumentId")
		public String getLeg1CommodityInstrumentId() {
			return leg1CommodityInstrumentId;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerId")
		@RuneAttribute("leg1CommodityUnderlyerId")
		public String getLeg1CommodityUnderlyerId() {
			return leg1CommodityUnderlyerId;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnitOfMeasure")
		@RuneAttribute("leg1CommodityUnitOfMeasure")
		public String getLeg1CommodityUnitOfMeasure() {
			return leg1CommodityUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityExchangeId")
		@RuneAttribute("leg1CommodityExchangeId")
		public String getLeg1CommodityExchangeId() {
			return leg1CommodityExchangeId;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityRateSource")
		@RuneAttribute("leg2CommodityRateSource")
		public String getLeg2CommodityRateSource() {
			return leg2CommodityRateSource;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDateUnadjusted")
		@RuneAttribute("leg1EffectiveDateUnadjusted")
		public Date getLeg1EffectiveDateUnadjusted() {
			return leg1EffectiveDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDateUnadjusted")
		@RuneAttribute("leg2EffectiveDateUnadjusted")
		public Date getLeg2EffectiveDateUnadjusted() {
			return leg2EffectiveDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("coProductType")
		@RuneAttribute("coProductType")
		public String getCoProductType() {
			return coProductType;
		}
		
		@Override
		@RosettaAttribute("totalQuantityUnit")
		@RuneAttribute("totalQuantityUnit")
		public String getTotalQuantityUnit() {
			return totalQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("totalQuantity")
		@RuneAttribute("totalQuantity")
		public BigDecimal getTotalQuantity() {
			return totalQuantity;
		}
		
		@Override
		@RosettaAttribute("fixedPrice")
		@RuneAttribute("fixedPrice")
		public BigDecimal getFixedPrice() {
			return fixedPrice;
		}
		
		@Override
		@RosettaAttribute("fixedPriceCurrency")
		@RuneAttribute("fixedPriceCurrency")
		public String getFixedPriceCurrency() {
			return fixedPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantityUnit")
		@RuneAttribute("leg1NotionalQuantityUnit")
		public String getLeg1NotionalQuantityUnit() {
			return leg1NotionalQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantityFrequency")
		@RuneAttribute("leg1NotionalQuantityFrequency")
		public String getLeg1NotionalQuantityFrequency() {
			return leg1NotionalQuantityFrequency;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantity")
		@RuneAttribute("leg1NotionalQuantity")
		public BigDecimal getLeg1NotionalQuantity() {
			return leg1NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg1TotalNotionalQuantity")
		@RuneAttribute("leg1TotalNotionalQuantity")
		public BigDecimal getLeg1TotalNotionalQuantity() {
			return leg1TotalNotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityCurrency")
		@RuneAttribute("leg1CommodityCurrency")
		public String getLeg1CommodityCurrency() {
			return leg1CommodityCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1SpecifiedPrice")
		@RuneAttribute("leg1SpecifiedPrice")
		public String getLeg1SpecifiedPrice() {
			return leg1SpecifiedPrice;
		}
		
		@Override
		@RosettaAttribute("leg1SpreadCurrency")
		@RuneAttribute("leg1SpreadCurrency")
		public String getLeg1SpreadCurrency() {
			return leg1SpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1SpreadAmount")
		@RuneAttribute("leg1SpreadAmount")
		public BigDecimal getLeg1SpreadAmount() {
			return leg1SpreadAmount;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantityUnit")
		@RuneAttribute("leg2NotionalQuantityUnit")
		public String getLeg2NotionalQuantityUnit() {
			return leg2NotionalQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("leg2PartyReceiver")
		@RuneAttribute("leg2PartyReceiver")
		public String getLeg2PartyReceiver() {
			return leg2PartyReceiver;
		}
		
		@Override
		@RosettaAttribute("leg1PartyReceiver")
		@RuneAttribute("leg1PartyReceiver")
		public String getLeg1PartyReceiver() {
			return leg1PartyReceiver;
		}
		
		@Override
		@RosettaAttribute("coalSource")
		@RuneAttribute("coalSource")
		public String getCoalSource() {
			return coalSource;
		}
		
		@Override
		@RosettaAttribute("leg2Quantity")
		@RuneAttribute("leg2Quantity")
		public BigDecimal getLeg2Quantity() {
			return leg2Quantity;
		}
		
		@Override
		@RosettaAttribute("commodityBase")
		@RuneAttribute("commodityBase")
		public String getCommodityBase() {
			return commodityBase;
		}
		
		@Override
		@RosettaAttribute("commodityDetails")
		@RuneAttribute("commodityDetails")
		public String getCommodityDetails() {
			return commodityDetails;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public String getInterconnectionPoint() {
			return interconnectionPoint;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public String getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("fixedPriceUnit")
		@RuneAttribute("fixedPriceUnit")
		public String getFixedPriceUnit() {
			return fixedPriceUnit;
		}
		
		@Override
		@RosettaAttribute("exercisePaymentDateUnadjusted")
		@RuneAttribute("exercisePaymentDateUnadjusted")
		public Date getExercisePaymentDateUnadjusted() {
			return exercisePaymentDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg1PaymentDatesUnadjusted")
		@RuneAttribute("leg1PaymentDatesUnadjusted")
		public Date getLeg1PaymentDatesUnadjusted() {
			return leg1PaymentDatesUnadjusted;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentDateUnadjusted")
		@RuneAttribute("leg2PaymentDateUnadjusted")
		public Date getLeg2PaymentDateUnadjusted() {
			return leg2PaymentDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("settlementDateUnadjusted")
		@RuneAttribute("settlementDateUnadjusted")
		public Date getSettlementDateUnadjusted() {
			return settlementDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("deliveryLocation")
		@RuneAttribute("deliveryLocation")
		public String getDeliveryLocation() {
			return deliveryLocation;
		}
		
		@Override
		@RosettaAttribute("leg2QuantityUnit")
		@RuneAttribute("leg2QuantityUnit")
		public String getLeg2QuantityUnit() {
			return leg2QuantityUnit;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerDetails")
		@RuneAttribute("leg1CommodityUnderlyerDetails")
		public String getLeg1CommodityUnderlyerDetails() {
			return leg1CommodityUnderlyerDetails;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityRateSourcePage")
		@RuneAttribute("leg2CommodityRateSourcePage")
		public String getLeg2CommodityRateSourcePage() {
			return leg2CommodityRateSourcePage;
		}
		
		@Override
		@RosettaAttribute("valueDate")
		@RuneAttribute("valueDate")
		public Date getValueDate() {
			return valueDate;
		}
		
		@Override
		@RosettaAttribute("gtrQuantityUnit")
		@RuneAttribute("gtrQuantityUnit")
		public String getGtrQuantityUnit() {
			return gtrQuantityUnit;
		}
		
		@Override
		@RosettaAttribute("attachmentPoint")
		@RuneAttribute("attachmentPoint")
		public BigDecimal getAttachmentPoint() {
			return attachmentPoint;
		}
		
		@Override
		@RosettaAttribute("exhaustionPoint")
		@RuneAttribute("exhaustionPoint")
		public BigDecimal getExhaustionPoint() {
			return exhaustionPoint;
		}
		
		@Override
		@RosettaAttribute("mthToDefault")
		@RuneAttribute("mthToDefault")
		public BigDecimal getMthToDefault() {
			return mthToDefault;
		}
		
		@Override
		@RosettaAttribute("nthToDefault")
		@RuneAttribute("nthToDefault")
		public BigDecimal getNthToDefault() {
			return nthToDefault;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public BigDecimal getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("crversion")
		@RuneAttribute("crversion")
		public BigDecimal getCrversion() {
			return crversion;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public String getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("referenceObligation")
		@RuneAttribute("referenceObligation")
		public String getReferenceObligation() {
			return referenceObligation;
		}
		
		@Override
		@RosettaAttribute("referenceObligationIdType")
		@RuneAttribute("referenceObligationIdType")
		public String getReferenceObligationIdType() {
			return referenceObligationIdType;
		}
		
		@Override
		@RosettaAttribute("underlyingFixedRatePayerBuyer")
		@RuneAttribute("underlyingFixedRatePayerBuyer")
		public String getUnderlyingFixedRatePayerBuyer() {
			return underlyingFixedRatePayerBuyer;
		}
		
		@Override
		@RosettaAttribute("underlyingFloatRatePayerSeller")
		@RuneAttribute("underlyingFloatRatePayerSeller")
		public String getUnderlyingFloatRatePayerSeller() {
			return underlyingFloatRatePayerSeller;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetExchangeId")
		@RuneAttribute("underlyingAssetExchangeId")
		public String getUnderlyingAssetExchangeId() {
			return underlyingAssetExchangeId;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetNumberOfUnits")
		@RuneAttribute("underlyingAssetNumberOfUnits")
		public BigDecimal getUnderlyingAssetNumberOfUnits() {
			return underlyingAssetNumberOfUnits;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationType")
		@RuneAttribute("optionalEarlyTerminationType")
		public String getOptionalEarlyTerminationType() {
			return optionalEarlyTerminationType;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationElectingPartyValue")
		@RuneAttribute("optionalEarlyTerminationElectingPartyValue")
		public String getOptionalEarlyTerminationElectingPartyValue() {
			return optionalEarlyTerminationElectingPartyValue;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationIndicator")
		@RuneAttribute("optionalEarlyTerminationIndicator")
		public Boolean getOptionalEarlyTerminationIndicator() {
			return optionalEarlyTerminationIndicator;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingAmountPayer")
		@RuneAttribute("underlyingAssetFloatingAmountPayer")
		public String getUnderlyingAssetFloatingAmountPayer() {
			return underlyingAssetFloatingAmountPayer;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingAmountReceiver")
		@RuneAttribute("underlyingAssetFloatingAmountReceiver")
		public String getUnderlyingAssetFloatingAmountReceiver() {
			return underlyingAssetFloatingAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("floatingRateOption")
		@RuneAttribute("floatingRateOption")
		public String getFloatingRateOption() {
			return floatingRateOption;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingLegSpread")
		@RuneAttribute("underlyingAssetFloatingLegSpread")
		public BigDecimal getUnderlyingAssetFloatingLegSpread() {
			return underlyingAssetFloatingLegSpread;
		}
		
		@Override
		@RosettaAttribute("leg2DesignatedMaturityPeriod")
		@RuneAttribute("leg2DesignatedMaturityPeriod")
		public String getLeg2DesignatedMaturityPeriod() {
			return leg2DesignatedMaturityPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2DesignatedMaturityPeriodMultiplier")
		@RuneAttribute("leg2DesignatedMaturityPeriodMultiplier")
		public BigDecimal getLeg2DesignatedMaturityPeriodMultiplier() {
			return leg2DesignatedMaturityPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetEquityAmountPayer")
		@RuneAttribute("underlyingAssetEquityAmountPayer")
		public String getUnderlyingAssetEquityAmountPayer() {
			return underlyingAssetEquityAmountPayer;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetEquityAmountReceiver")
		@RuneAttribute("underlyingAssetEquityAmountReceiver")
		public String getUnderlyingAssetEquityAmountReceiver() {
			return underlyingAssetEquityAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetInitialPriceCurrency")
		@RuneAttribute("underlyingAssetInitialPriceCurrency")
		public String getUnderlyingAssetInitialPriceCurrency() {
			return underlyingAssetInitialPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1ValuationDates")
		@RuneAttribute("leg1ValuationDates")
		public Date getLeg1ValuationDates() {
			return leg1ValuationDates;
		}
		
		@Override
		@RosettaAttribute("leg1TypeOfReturn")
		@RuneAttribute("leg1TypeOfReturn")
		public String getLeg1TypeOfReturn() {
			return leg1TypeOfReturn;
		}
		
		@Override
		@RosettaAttribute("observationStartDate")
		@RuneAttribute("observationStartDate")
		public Date getObservationStartDate() {
			return observationStartDate;
		}
		
		@Override
		@RosettaAttribute("varianceAmount")
		@RuneAttribute("varianceAmount")
		public BigDecimal getVarianceAmount() {
			return varianceAmount;
		}
		
		@Override
		@RosettaAttribute("volatilityStrikePrice")
		@RuneAttribute("volatilityStrikePrice")
		public BigDecimal getVolatilityStrikePrice() {
			return volatilityStrikePrice;
		}
		
		@Override
		@RosettaAttribute("varianceStrikePrice")
		@RuneAttribute("varianceStrikePrice")
		public BigDecimal getVarianceStrikePrice() {
			return varianceStrikePrice;
		}
		
		@Override
		@RosettaAttribute("varianceCapFactor")
		@RuneAttribute("varianceCapFactor")
		public BigDecimal getVarianceCapFactor() {
			return varianceCapFactor;
		}
		
		@Override
		@RosettaAttribute("referenceCurrency")
		@RuneAttribute("referenceCurrency")
		public String getReferenceCurrency() {
			return referenceCurrency;
		}
		
		@Override
		@RosettaAttribute("specialDividendsIndicator")
		@RuneAttribute("specialDividendsIndicator")
		public String getSpecialDividendsIndicator() {
			return specialDividendsIndicator;
		}
		
		@Override
		@RosettaAttribute("materialNoncashDividendIndicator")
		@RuneAttribute("materialNoncashDividendIndicator")
		public String getMaterialNoncashDividendIndicator() {
			return materialNoncashDividendIndicator;
		}
		
		@Override
		@RosettaAttribute("numberOfSharesUnits")
		@RuneAttribute("numberOfSharesUnits")
		public BigDecimal getNumberOfSharesUnits() {
			return numberOfSharesUnits;
		}
		
		@Override
		@RosettaAttribute("dividendAmountPayer")
		@RuneAttribute("dividendAmountPayer")
		public String getDividendAmountPayer() {
			return dividendAmountPayer;
		}
		
		@Override
		@RosettaAttribute("dividendAmountReceiver")
		@RuneAttribute("dividendAmountReceiver")
		public String getDividendAmountReceiver() {
			return dividendAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("fixedAmountPayer")
		@RuneAttribute("fixedAmountPayer")
		public String getFixedAmountPayer() {
			return fixedAmountPayer;
		}
		
		@Override
		@RosettaAttribute("fixedAmountReceiver")
		@RuneAttribute("fixedAmountReceiver")
		public String getFixedAmountReceiver() {
			return fixedAmountReceiver;
		}
		
		@Override
		@RosettaAttribute("knockInEvent")
		@RuneAttribute("knockInEvent")
		public String getKnockInEvent() {
			return knockInEvent;
		}
		
		@Override
		@RosettaAttribute("knockOutEvent")
		@RuneAttribute("knockOutEvent")
		public String getKnockOutEvent() {
			return knockOutEvent;
		}
		
		@Override
		@RosettaAttribute("knockInPrice")
		@RuneAttribute("knockInPrice")
		public BigDecimal getKnockInPrice() {
			return knockInPrice;
		}
		
		@Override
		@RosettaAttribute("knockOutPrice")
		@RuneAttribute("knockOutPrice")
		public BigDecimal getKnockOutPrice() {
			return knockOutPrice;
		}
		
		@Override
		@RosettaAttribute("barrierType")
		@RuneAttribute("barrierType")
		public String getBarrierType() {
			return barrierType;
		}
		
		@Override
		@RosettaAttribute("earliestExecutionTime")
		@RuneAttribute("earliestExecutionTime")
		public LocalTime getEarliestExecutionTime() {
			return earliestExecutionTime;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisCurrency1")
		@RuneAttribute("exchangeRateBasisCurrency1")
		public String getExchangeRateBasisCurrency1() {
			return exchangeRateBasisCurrency1;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisCurrency2")
		@RuneAttribute("exchangeRateBasisCurrency2")
		public String getExchangeRateBasisCurrency2() {
			return exchangeRateBasisCurrency2;
		}
		
		@Override
		@RosettaAttribute("executionPeriodStartDate")
		@RuneAttribute("executionPeriodStartDate")
		public Date getExecutionPeriodStartDate() {
			return executionPeriodStartDate;
		}
		
		@Override
		@RosettaAttribute("payoutStyle")
		@RuneAttribute("payoutStyle")
		public String getPayoutStyle() {
			return payoutStyle;
		}
		
		@Override
		@RosettaAttribute("rateQuoteBasis1")
		@RuneAttribute("rateQuoteBasis1")
		public String getRateQuoteBasis1() {
			return rateQuoteBasis1;
		}
		
		@Override
		@RosettaAttribute("settlementFixingDate")
		@RuneAttribute("settlementFixingDate")
		public Date getSettlementFixingDate() {
			return settlementFixingDate;
		}
		
		@Override
		@RosettaAttribute("swapLinkId")
		@RuneAttribute("swapLinkId")
		public String getSwapLinkId() {
			return swapLinkId;
		}
		
		@Override
		@RosettaAttribute("triggerCondition")
		@RuneAttribute("triggerCondition")
		public String getTriggerCondition() {
			return triggerCondition;
		}
		
		@Override
		@RosettaAttribute("triggerCondition2")
		@RuneAttribute("triggerCondition2")
		public String getTriggerCondition2() {
			return triggerCondition2;
		}
		
		@Override
		@RosettaAttribute("triggerRate")
		@RuneAttribute("triggerRate")
		public BigDecimal getTriggerRate() {
			return triggerRate;
		}
		
		@Override
		@RosettaAttribute("triggerRate2")
		@RuneAttribute("triggerRate2")
		public BigDecimal getTriggerRate2() {
			return triggerRate2;
		}
		
		@Override
		@RosettaAttribute("rateQuoteBasis2")
		@RuneAttribute("rateQuoteBasis2")
		public String getRateQuoteBasis2() {
			return rateQuoteBasis2;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("barrierType2")
		@RuneAttribute("barrierType2")
		public String getBarrierType2() {
			return barrierType2;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionBuyer")
		@RuneAttribute("cancelationOptionBuyer")
		public String getCancelationOptionBuyer() {
			return cancelationOptionBuyer;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionCommencementDate")
		@RuneAttribute("cancelationOptionCommencementDate")
		public Date getCancelationOptionCommencementDate() {
			return cancelationOptionCommencementDate;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionExerciseStyleType")
		@RuneAttribute("cancelationOptionExerciseStyleType")
		public String getCancelationOptionExerciseStyleType() {
			return cancelationOptionExerciseStyleType;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionExpirationDate")
		@RuneAttribute("cancelationOptionExpirationDate")
		public Date getCancelationOptionExpirationDate() {
			return cancelationOptionExpirationDate;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionInitialFeeCurrency")
		@RuneAttribute("cancelationOptionInitialFeeCurrency")
		public String getCancelationOptionInitialFeeCurrency() {
			return cancelationOptionInitialFeeCurrency;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionInitialFeePayer")
		@RuneAttribute("cancelationOptionInitialFeePayer")
		public String getCancelationOptionInitialFeePayer() {
			return cancelationOptionInitialFeePayer;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionPremiumAmount")
		@RuneAttribute("cancelationOptionPremiumAmount")
		public BigDecimal getCancelationOptionPremiumAmount() {
			return cancelationOptionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionSeller")
		@RuneAttribute("cancelationOptionSeller")
		public String getCancelationOptionSeller() {
			return cancelationOptionSeller;
		}
		
		@Override
		@RosettaAttribute("capRateInitial")
		@RuneAttribute("capRateInitial")
		public BigDecimal getCapRateInitial() {
			return capRateInitial;
		}
		
		@Override
		@RosettaAttribute("couponType")
		@RuneAttribute("couponType")
		public String getCouponType() {
			return couponType;
		}
		
		@Override
		@RosettaAttribute("finalPrincipalExchangeIndicatorAtTermination")
		@RuneAttribute("finalPrincipalExchangeIndicatorAtTermination")
		public Boolean getFinalPrincipalExchangeIndicatorAtTermination() {
			return finalPrincipalExchangeIndicatorAtTermination;
		}
		
		@Override
		@RosettaAttribute("floorRateInitial")
		@RuneAttribute("floorRateInitial")
		public BigDecimal getFloorRateInitial() {
			return floorRateInitial;
		}
		
		@Override
		@RosettaAttribute("fraDiscountingType")
		@RuneAttribute("fraDiscountingType")
		public String getFraDiscountingType() {
			return fraDiscountingType;
		}
		
		@Override
		@RosettaAttribute("inflationIndexInitialLevel")
		@RuneAttribute("inflationIndexInitialLevel")
		public BigDecimal getInflationIndexInitialLevel() {
			return inflationIndexInitialLevel;
		}
		
		@Override
		@RosettaAttribute("inflationIndexMainPublication")
		@RuneAttribute("inflationIndexMainPublication")
		public String getInflationIndexMainPublication() {
			return inflationIndexMainPublication;
		}
		
		@Override
		@RosettaAttribute("inflationInterpolationMethod")
		@RuneAttribute("inflationInterpolationMethod")
		public String getInflationInterpolationMethod() {
			return inflationInterpolationMethod;
		}
		
		@Override
		@RosettaAttribute("inflationLagDayType")
		@RuneAttribute("inflationLagDayType")
		public String getInflationLagDayType() {
			return inflationLagDayType;
		}
		
		@Override
		@RosettaAttribute("inflationLagPeriod")
		@RuneAttribute("inflationLagPeriod")
		public String getInflationLagPeriod() {
			return inflationLagPeriod;
		}
		
		@Override
		@RosettaAttribute("inflationRateSourceName")
		@RuneAttribute("inflationRateSourceName")
		public String getInflationRateSourceName() {
			return inflationRateSourceName;
		}
		
		@Override
		@RosettaAttribute("initialPrincipalExchangeIndicator")
		@RuneAttribute("initialPrincipalExchangeIndicator")
		public Boolean getInitialPrincipalExchangeIndicator() {
			return initialPrincipalExchangeIndicator;
		}
		
		@Override
		@RosettaAttribute("intermediatePrincipalExchangeIndicator")
		@RuneAttribute("intermediatePrincipalExchangeIndicator")
		public Boolean getIntermediatePrincipalExchangeIndicator() {
			return intermediatePrincipalExchangeIndicator;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateIndex")
		@RuneAttribute("leg1FloatingRateIndex")
		public String getLeg1FloatingRateIndex() {
			return leg1FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateInitialSpread")
		@RuneAttribute("leg1FloatingRateInitialSpread")
		public BigDecimal getLeg1FloatingRateInitialSpread() {
			return leg1FloatingRateInitialSpread;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateMultiplierInitialValue")
		@RuneAttribute("leg1FloatingRateMultiplierInitialValue")
		public BigDecimal getLeg1FloatingRateMultiplierInitialValue() {
			return leg1FloatingRateMultiplierInitialValue;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateTenorPeriod")
		@RuneAttribute("leg1FloatingRateTenorPeriod")
		public String getLeg1FloatingRateTenorPeriod() {
			return leg1FloatingRateTenorPeriod;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateTenorPeriodMultiplier")
		@RuneAttribute("leg1FloatingRateTenorPeriodMultiplier")
		public BigDecimal getLeg1FloatingRateTenorPeriodMultiplier() {
			return leg1FloatingRateTenorPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg1KnownAmount")
		@RuneAttribute("leg1KnownAmount")
		public BigDecimal getLeg1KnownAmount() {
			return leg1KnownAmount;
		}
		
		@Override
		@RosettaAttribute("leg1KnownAmountCurrency")
		@RuneAttribute("leg1KnownAmountCurrency")
		public String getLeg1KnownAmountCurrency() {
			return leg1KnownAmountCurrency;
		}
		
		@Override
		@RosettaAttribute("leg1ReferenceCurrency")
		@RuneAttribute("leg1ReferenceCurrency")
		public String getLeg1ReferenceCurrency() {
			return leg1ReferenceCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateIndex")
		@RuneAttribute("leg2FloatingRateIndex")
		public String getLeg2FloatingRateIndex() {
			return leg2FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateInitialSpread")
		@RuneAttribute("leg2FloatingRateInitialSpread")
		public BigDecimal getLeg2FloatingRateInitialSpread() {
			return leg2FloatingRateInitialSpread;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateMultiplierInitialValue")
		@RuneAttribute("leg2FloatingRateMultiplierInitialValue")
		public BigDecimal getLeg2FloatingRateMultiplierInitialValue() {
			return leg2FloatingRateMultiplierInitialValue;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateTenorPeriod")
		@RuneAttribute("leg2FloatingRateTenorPeriod")
		public String getLeg2FloatingRateTenorPeriod() {
			return leg2FloatingRateTenorPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateTenorPeriodMultiplier")
		@RuneAttribute("leg2FloatingRateTenorPeriodMultiplier")
		public BigDecimal getLeg2FloatingRateTenorPeriodMultiplier() {
			return leg2FloatingRateTenorPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg2KnownAmount")
		@RuneAttribute("leg2KnownAmount")
		public BigDecimal getLeg2KnownAmount() {
			return leg2KnownAmount;
		}
		
		@Override
		@RosettaAttribute("leg2KnownAmountCurrency")
		@RuneAttribute("leg2KnownAmountCurrency")
		public String getLeg2KnownAmountCurrency() {
			return leg2KnownAmountCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2ReferenceCurrency")
		@RuneAttribute("leg2ReferenceCurrency")
		public String getLeg2ReferenceCurrency() {
			return leg2ReferenceCurrency;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDate")
		@RuneAttribute("mandatoryEarlyTerminationDate")
		public Date getMandatoryEarlyTerminationDate() {
			return mandatoryEarlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDateTenorPeriod")
		@RuneAttribute("mandatoryEarlyTerminationDateTenorPeriod")
		public String getMandatoryEarlyTerminationDateTenorPeriod() {
			return mandatoryEarlyTerminationDateTenorPeriod;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDateTenorPeriodMultiplier")
		@RuneAttribute("mandatoryEarlyTerminationDateTenorPeriodMultiplier")
		public String getMandatoryEarlyTerminationDateTenorPeriodMultiplier() {
			return mandatoryEarlyTerminationDateTenorPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("notionalUnits")
		@RuneAttribute("notionalUnits")
		public BigDecimal getNotionalUnits() {
			return notionalUnits;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationCommencementDate")
		@RuneAttribute("optionalEarlyTerminationCommencementDate")
		public Date getOptionalEarlyTerminationCommencementDate() {
			return optionalEarlyTerminationCommencementDate;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationExerciseStyle")
		@RuneAttribute("optionalEarlyTerminationExerciseStyle")
		public String getOptionalEarlyTerminationExerciseStyle() {
			return optionalEarlyTerminationExerciseStyle;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationExpirationDate")
		@RuneAttribute("optionalEarlyTerminationExpirationDate")
		public Date getOptionalEarlyTerminationExpirationDate() {
			return optionalEarlyTerminationExpirationDate;
		}
		
		@Override
		@RosettaAttribute("premiumReceiver")
		@RuneAttribute("premiumReceiver")
		public String getPremiumReceiver() {
			return premiumReceiver;
		}
		
		@Override
		@RosettaAttribute("underlyingCouponRate")
		@RuneAttribute("underlyingCouponRate")
		public BigDecimal getUnderlyingCouponRate() {
			return underlyingCouponRate;
		}
		
		@Override
		@RosettaAttribute("underlyingMaturityDate")
		@RuneAttribute("underlyingMaturityDate")
		public Date getUnderlyingMaturityDate() {
			return underlyingMaturityDate;
		}
		
		@Override
		@RosettaAttribute("underlyingProductId")
		@RuneAttribute("underlyingProductId")
		public String getUnderlyingProductId() {
			return underlyingProductId;
		}
		
		@Override
		@RosettaAttribute("inflationLagPeriodMultiplier")
		@RuneAttribute("inflationLagPeriodMultiplier")
		public String getInflationLagPeriodMultiplier() {
			return inflationLagPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg1FixedRateNotation")
		@RuneAttribute("leg1FixedRateNotation")
		public String getLeg1FixedRateNotation() {
			return leg1FixedRateNotation;
		}
		
		@Override
		@RosettaAttribute("leg2FixedRateNotation")
		@RuneAttribute("leg2FixedRateNotation")
		public String getLeg2FixedRateNotation() {
			return leg2FixedRateNotation;
		}
		
		@Override
		@RosettaAttribute("swaptionStraddleIndicator")
		@RuneAttribute("swaptionStraddleIndicator")
		public String getSwaptionStraddleIndicator() {
			return swaptionStraddleIndicator;
		}
		
		@Override
		@RosettaAttribute("singlePartyEarlyTerminationBuyer")
		@RuneAttribute("singlePartyEarlyTerminationBuyer")
		public String getSinglePartyEarlyTerminationBuyer() {
			return singlePartyEarlyTerminationBuyer;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDate")
		@RuneAttribute("leg1EffectiveDate")
		public Date getLeg1EffectiveDate() {
			return leg1EffectiveDate;
		}
		
		@Override
		@RosettaAttribute("action")
		@RuneAttribute("action")
		public String getAction() {
			return action;
		}
		
		@Override
		@RosettaAttribute("clearingStatus")
		@RuneAttribute("clearingStatus")
		public String getClearingStatus() {
			return clearingStatus;
		}
		
		@Override
		@RosettaAttribute("effectiveDate1")
		@RuneAttribute("effectiveDate1")
		public Date getEffectiveDate1() {
			return effectiveDate1;
		}
		
		@Override
		@RosettaAttribute("executionVenueType")
		@RuneAttribute("executionVenueType")
		public String getExecutionVenueType() {
			return executionVenueType;
		}
		
		@Override
		@RosettaAttribute("nonStandardTradeIndicator")
		@RuneAttribute("nonStandardTradeIndicator")
		public Boolean getNonStandardTradeIndicator() {
			return nonStandardTradeIndicator;
		}
		
		@Override
		@RosettaAttribute("notionalAmount1")
		@RuneAttribute("notionalAmount1")
		public BigDecimal getNotionalAmount1() {
			return notionalAmount1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency1")
		@RuneAttribute("notionalCurrency1")
		public String getNotionalCurrency1() {
			return notionalCurrency1;
		}
		
		@Override
		@RosettaAttribute("price1Price")
		@RuneAttribute("price1Price")
		public BigDecimal getPrice1Price() {
			return price1Price;
		}
		
		@Override
		@RosettaAttribute("price1Type")
		@RuneAttribute("price1Type")
		public String getPrice1Type() {
			return price1Type;
		}
		
		@Override
		@RosettaAttribute("price1Units")
		@RuneAttribute("price1Units")
		public String getPrice1Units() {
			return price1Units;
		}
		
		@Override
		@RosettaAttribute("scheduledTerminationDate1")
		@RuneAttribute("scheduledTerminationDate1")
		public Date getScheduledTerminationDate1() {
			return scheduledTerminationDate1;
		}
		
		@Override
		@RosettaAttribute("tradeDate")
		@RuneAttribute("tradeDate")
		public Date getTradeDate() {
			return tradeDate;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralizationType")
		@RuneAttribute("tradeParty1CollateralizationType")
		public String getTradeParty1CollateralizationType() {
			return tradeParty1CollateralizationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1EventId")
		@RuneAttribute("tradeParty1EventId")
		public String getTradeParty1EventId() {
			return tradeParty1EventId;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralizationType")
		@RuneAttribute("tradeParty2CollateralizationType")
		public String getTradeParty2CollateralizationType() {
			return tradeParty2CollateralizationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2EventId")
		@RuneAttribute("tradeParty2EventId")
		public String getTradeParty2EventId() {
			return tradeParty2EventId;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionOnSwap")
		@RuneAttribute("embeddedOptionOnSwap")
		public String getEmbeddedOptionOnSwap() {
			return embeddedOptionOnSwap;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("notionalAmount2")
		@RuneAttribute("notionalAmount2")
		public BigDecimal getNotionalAmount2() {
			return notionalAmount2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		public String getNotionalCurrency2() {
			return notionalCurrency2;
		}
		
		@Override
		@RosettaAttribute("premiumAmount")
		@RuneAttribute("premiumAmount")
		public BigDecimal getPremiumAmount() {
			return premiumAmount;
		}
		
		@Override
		@RosettaAttribute("premiumCurrency")
		@RuneAttribute("premiumCurrency")
		public String getPremiumCurrency() {
			return premiumCurrency;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public String getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("comment1")
		@RuneAttribute("comment1")
		public String getComment1() {
			return comment1;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public String getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("commencementDate")
		@RuneAttribute("commencementDate")
		public Date getCommencementDate() {
			return commencementDate;
		}
		
		@Override
		@RosettaAttribute("dayCountFraction1")
		@RuneAttribute("dayCountFraction1")
		public String getDayCountFraction1() {
			return dayCountFraction1;
		}
		
		@Override
		@RosettaAttribute("leg2DayCountFraction")
		@RuneAttribute("leg2DayCountFraction")
		public String getLeg2DayCountFraction() {
			return leg2DayCountFraction;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDate")
		@RuneAttribute("leg2EffectiveDate")
		public Date getLeg2EffectiveDate() {
			return leg2EffectiveDate;
		}
		
		@Override
		@RosettaAttribute("leg2ResetFrequencyPeriod")
		@RuneAttribute("leg2ResetFrequencyPeriod")
		public String getLeg2ResetFrequencyPeriod() {
			return leg2ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2ResetFrequencyPeriodMultiplier")
		@RuneAttribute("leg2ResetFrequencyPeriodMultiplier")
		public BigDecimal getLeg2ResetFrequencyPeriodMultiplier() {
			return leg2ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementCurrency")
		@RuneAttribute("leg2SettlementCurrency")
		public String getLeg2SettlementCurrency() {
			return leg2SettlementCurrency;
		}
		
		@Override
		@RosettaAttribute("leg2ScheduledTerminationDate")
		@RuneAttribute("leg2ScheduledTerminationDate")
		public Date getLeg2ScheduledTerminationDate() {
			return leg2ScheduledTerminationDate;
		}
		
		@Override
		@RosettaAttribute("numberOfOptions")
		@RuneAttribute("numberOfOptions")
		public BigDecimal getNumberOfOptions() {
			return numberOfOptions;
		}
		
		@Override
		@RosettaAttribute("optionEntitlement")
		@RuneAttribute("optionEntitlement")
		public BigDecimal getOptionEntitlement() {
			return optionEntitlement;
		}
		
		@Override
		@RosettaAttribute("originalExecutionTimestamp")
		@RuneAttribute("originalExecutionTimestamp")
		public ZonedDateTime getOriginalExecutionTimestamp() {
			return originalExecutionTimestamp;
		}
		
		@Override
		@RosettaAttribute("payment1Date")
		@RuneAttribute("payment1Date")
		public Date getPayment1Date() {
			return payment1Date;
		}
		
		@Override
		@RosettaAttribute("payment1FrequencyPeriod")
		@RuneAttribute("payment1FrequencyPeriod")
		public String getPayment1FrequencyPeriod() {
			return payment1FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment1FrequencyPeriodMultiplier")
		@RuneAttribute("payment1FrequencyPeriodMultiplier")
		public BigDecimal getPayment1FrequencyPeriodMultiplier() {
			return payment1FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment2Date")
		@RuneAttribute("payment2Date")
		public Date getPayment2Date() {
			return payment2Date;
		}
		
		@Override
		@RosettaAttribute("payment2FrequencyPeriod")
		@RuneAttribute("payment2FrequencyPeriod")
		public String getPayment2FrequencyPeriod() {
			return payment2FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment2FrequencyPeriodMultiplier")
		@RuneAttribute("payment2FrequencyPeriodMultiplier")
		public BigDecimal getPayment2FrequencyPeriodMultiplier() {
			return payment2FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("resetFrequencyPeriod1")
		@RuneAttribute("resetFrequencyPeriod1")
		public String getResetFrequencyPeriod1() {
			return resetFrequencyPeriod1;
		}
		
		@Override
		@RosettaAttribute("resetFrequencyPeriodMultiplier1")
		@RuneAttribute("resetFrequencyPeriodMultiplier1")
		public BigDecimal getResetFrequencyPeriodMultiplier1() {
			return resetFrequencyPeriodMultiplier1;
		}
		
		@Override
		@RosettaAttribute("settlementDate")
		@RuneAttribute("settlementDate")
		public Date getSettlementDate() {
			return settlementDate;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public BigDecimal getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceUnits")
		@RuneAttribute("strikePriceUnits")
		public String getStrikePriceUnits() {
			return strikePriceUnits;
		}
		
		@Override
		@RosettaAttribute("asOfDateTime")
		@RuneAttribute("asOfDateTime")
		public ZonedDateTime getAsOfDateTime() {
			return asOfDateTime;
		}
		
		@Override
		@RosettaAttribute("clearingVenueId")
		@RuneAttribute("clearingVenueId")
		public String getClearingVenueId() {
			return clearingVenueId;
		}
		
		@Override
		@RosettaAttribute("clearingVenueIdType")
		@RuneAttribute("clearingVenueIdType")
		public String getClearingVenueIdType() {
			return clearingVenueIdType;
		}
		
		@Override
		@RosettaAttribute("compressedTradeIndicator")
		@RuneAttribute("compressedTradeIndicator")
		public String getCompressedTradeIndicator() {
			return compressedTradeIndicator;
		}
		
		@Override
		@RosettaAttribute("confirmationMethod")
		@RuneAttribute("confirmationMethod")
		public String getConfirmationMethod() {
			return confirmationMethod;
		}
		
		@Override
		@RosettaAttribute("confirmationPlatformId")
		@RuneAttribute("confirmationPlatformId")
		public String getConfirmationPlatformId() {
			return confirmationPlatformId;
		}
		
		@Override
		@RosettaAttribute("confirmationPlatformTradeId")
		@RuneAttribute("confirmationPlatformTradeId")
		public String getConfirmationPlatformTradeId() {
			return confirmationPlatformTradeId;
		}
		
		@Override
		@RosettaAttribute("executionVenueId")
		@RuneAttribute("executionVenueId")
		public String getExecutionVenueId() {
			return executionVenueId;
		}
		
		@Override
		@RosettaAttribute("executionVenueIdType")
		@RuneAttribute("executionVenueIdType")
		public String getExecutionVenueIdType() {
			return executionVenueIdType;
		}
		
		@Override
		@RosettaAttribute("postTradeEffectiveDate")
		@RuneAttribute("postTradeEffectiveDate")
		public Date getPostTradeEffectiveDate() {
			return postTradeEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("priorUsiId")
		@RuneAttribute("priorUsiId")
		public String getPriorUsiId() {
			return priorUsiId;
		}
		
		@Override
		@RosettaAttribute("priorUsiIdPrefix")
		@RuneAttribute("priorUsiIdPrefix")
		public String getPriorUsiIdPrefix() {
			return priorUsiIdPrefix;
		}
		
		@Override
		@RosettaAttribute("priorUtiId")
		@RuneAttribute("priorUtiId")
		public String getPriorUtiId() {
			return priorUtiId;
		}
		
		@Override
		@RosettaAttribute("priorUtiIdPrefix")
		@RuneAttribute("priorUtiIdPrefix")
		public String getPriorUtiIdPrefix() {
			return priorUtiIdPrefix;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BranchLocation")
		@RuneAttribute("tradeParty1BranchLocation")
		public String getTradeParty1BranchLocation() {
			return tradeParty1BranchLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerId")
		@RuneAttribute("tradeParty1ClearingBrokerId")
		public String getTradeParty1ClearingBrokerId() {
			return tradeParty1ClearingBrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerIdType")
		@RuneAttribute("tradeParty1ClearingBrokerIdType")
		public String getTradeParty1ClearingBrokerIdType() {
			return tradeParty1ClearingBrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1DeskLocation")
		@RuneAttribute("tradeParty1DeskLocation")
		public String getTradeParty1DeskLocation() {
			return tradeParty1DeskLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Domicile")
		@RuneAttribute("tradeParty1Domicile")
		public String getTradeParty1Domicile() {
			return tradeParty1Domicile;
		}
		
		@Override
		@RosettaAttribute("tradeParty1IndustrialSectorType")
		@RuneAttribute("tradeParty1IndustrialSectorType")
		public String getTradeParty1IndustrialSectorType() {
			return tradeParty1IndustrialSectorType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BranchLocation")
		@RuneAttribute("tradeParty2BranchLocation")
		public String getTradeParty2BranchLocation() {
			return tradeParty2BranchLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty2DeskLocation")
		@RuneAttribute("tradeParty2DeskLocation")
		public String getTradeParty2DeskLocation() {
			return tradeParty2DeskLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Domicile")
		@RuneAttribute("tradeParty2Domicile")
		public String getTradeParty2Domicile() {
			return tradeParty2Domicile;
		}
		
		@Override
		@RosettaAttribute("tradeParty2IndustrialSectorType")
		@RuneAttribute("tradeParty2IndustrialSectorType")
		public String getTradeParty2IndustrialSectorType() {
			return tradeParty2IndustrialSectorType;
		}
		
		@Override
		@RosettaAttribute("sellerPayer2")
		@RuneAttribute("sellerPayer2")
		public String getSellerPayer2() {
			return sellerPayer2;
		}
		
		@Override
		@RosettaAttribute("buyerPayer1")
		@RuneAttribute("buyerPayer1")
		public String getBuyerPayer1() {
			return buyerPayer1;
		}
		
		@Override
		@RosettaAttribute("tradeParty1HkCounterpartyOrigin")
		@RuneAttribute("tradeParty1HkCounterpartyOrigin")
		public String getTradeParty1HkCounterpartyOrigin() {
			return tradeParty1HkCounterpartyOrigin;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementDate")
		@RuneAttribute("leg2SettlementDate")
		public Date getLeg2SettlementDate() {
			return leg2SettlementDate;
		}
		
		@Override
		@RosettaAttribute("leg1FixedRateInitial")
		@RuneAttribute("leg1FixedRateInitial")
		public BigDecimal getLeg1FixedRateInitial() {
			return leg1FixedRateInitial;
		}
		
		@Override
		@RosettaAttribute("leg2FixedRateInitial")
		@RuneAttribute("leg2FixedRateInitial")
		public BigDecimal getLeg2FixedRateInitial() {
			return leg2FixedRateInitial;
		}
		
		@Override
		@RosettaAttribute("payment1Amount")
		@RuneAttribute("payment1Amount")
		public BigDecimal getPayment1Amount() {
			return payment1Amount;
		}
		
		@Override
		@RosettaAttribute("payment1Currency")
		@RuneAttribute("payment1Currency")
		public String getPayment1Currency() {
			return payment1Currency;
		}
		
		@Override
		@RosettaAttribute("payment1Payer")
		@RuneAttribute("payment1Payer")
		public String getPayment1Payer() {
			return payment1Payer;
		}
		
		@Override
		@RosettaAttribute("payment1Receiver")
		@RuneAttribute("payment1Receiver")
		public String getPayment1Receiver() {
			return payment1Receiver;
		}
		
		@Override
		@RosettaAttribute("payment2Payer")
		@RuneAttribute("payment2Payer")
		public String getPayment2Payer() {
			return payment2Payer;
		}
		
		@Override
		@RosettaAttribute("postTradeTransactionDate")
		@RuneAttribute("postTradeTransactionDate")
		public Date getPostTradeTransactionDate() {
			return postTradeTransactionDate;
		}
		
		@Override
		@RosettaAttribute("secondaryAssetClass")
		@RuneAttribute("secondaryAssetClass")
		public String getSecondaryAssetClass() {
			return secondaryAssetClass;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public String getSettlementType() {
			return settlementType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Name")
		@RuneAttribute("tradeParty1Name")
		public String getTradeParty1Name() {
			return tradeParty1Name;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Name")
		@RuneAttribute("tradeParty2Name")
		public String getTradeParty2Name() {
			return tradeParty2Name;
		}
		
		@Override
		@RosettaAttribute("ccpValuationAmount")
		@RuneAttribute("ccpValuationAmount")
		public BigDecimal getCcpValuationAmount() {
			return ccpValuationAmount;
		}
		
		@Override
		@RosettaAttribute("ccpValuationCurrency")
		@RuneAttribute("ccpValuationCurrency")
		public String getCcpValuationCurrency() {
			return ccpValuationCurrency;
		}
		
		@Override
		@RosettaAttribute("ccpValuationDatetime")
		@RuneAttribute("ccpValuationDatetime")
		public ZonedDateTime getCcpValuationDatetime() {
			return ccpValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("ccpValuationType")
		@RuneAttribute("ccpValuationType")
		public String getCcpValuationType() {
			return ccpValuationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationAmount")
		@RuneAttribute("tradeParty1ValuationAmount")
		public BigDecimal getTradeParty1ValuationAmount() {
			return tradeParty1ValuationAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationCurrency")
		@RuneAttribute("tradeParty1ValuationCurrency")
		public String getTradeParty1ValuationCurrency() {
			return tradeParty1ValuationCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationDatetime")
		@RuneAttribute("tradeParty1ValuationDatetime")
		public ZonedDateTime getTradeParty1ValuationDatetime() {
			return tradeParty1ValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationType")
		@RuneAttribute("tradeParty1ValuationType")
		public String getTradeParty1ValuationType() {
			return tradeParty1ValuationType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationAmount")
		@RuneAttribute("tradeParty2ValuationAmount")
		public BigDecimal getTradeParty2ValuationAmount() {
			return tradeParty2ValuationAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationCurrency")
		@RuneAttribute("tradeParty2ValuationCurrency")
		public String getTradeParty2ValuationCurrency() {
			return tradeParty2ValuationCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationDatetime")
		@RuneAttribute("tradeParty2ValuationDatetime")
		public ZonedDateTime getTradeParty2ValuationDatetime() {
			return tradeParty2ValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationType")
		@RuneAttribute("tradeParty2ValuationType")
		public String getTradeParty2ValuationType() {
			return tradeParty2ValuationType;
		}
		
		@Override
		@RosettaAttribute("executionType")
		@RuneAttribute("executionType")
		public String getExecutionType() {
			return executionType;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public String getStrikePriceCurrency() {
			return strikePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("payment2Amount")
		@RuneAttribute("payment2Amount")
		public BigDecimal getPayment2Amount() {
			return payment2Amount;
		}
		
		@Override
		@RosettaAttribute("tradeParty2HkCounterpartyOrigin")
		@RuneAttribute("tradeParty2HkCounterpartyOrigin")
		public String getTradeParty2HkCounterpartyOrigin() {
			return tradeParty2HkCounterpartyOrigin;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CountryOfTheOtherCounterparty")
		@RuneAttribute("tradeParty1CountryOfTheOtherCounterparty")
		public String getTradeParty1CountryOfTheOtherCounterparty() {
			return tradeParty1CountryOfTheOtherCounterparty;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CountryOfTheOtherCounterparty")
		@RuneAttribute("tradeParty2CountryOfTheOtherCounterparty")
		public String getTradeParty2CountryOfTheOtherCounterparty() {
			return tradeParty2CountryOfTheOtherCounterparty;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerId")
		@RuneAttribute("tradeParty1BrokerId")
		public String getTradeParty1BrokerId() {
			return tradeParty1BrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BrokerId")
		@RuneAttribute("tradeParty2BrokerId")
		public String getTradeParty2BrokerId() {
			return tradeParty2BrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BeneficiaryIdType")
		@RuneAttribute("tradeParty1BeneficiaryIdType")
		public String getTradeParty1BeneficiaryIdType() {
			return tradeParty1BeneficiaryIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BeneficiaryId")
		@RuneAttribute("tradeParty1BeneficiaryId")
		public String getTradeParty1BeneficiaryId() {
			return tradeParty1BeneficiaryId;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BeneficiaryIdType")
		@RuneAttribute("tradeParty2BeneficiaryIdType")
		public String getTradeParty2BeneficiaryIdType() {
			return tradeParty2BeneficiaryIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BeneficiaryId")
		@RuneAttribute("tradeParty2BeneficiaryId")
		public String getTradeParty2BeneficiaryId() {
			return tradeParty2BeneficiaryId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CounterpartySide")
		@RuneAttribute("tradeParty1CounterpartySide")
		public String getTradeParty1CounterpartySide() {
			return tradeParty1CounterpartySide;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CounterpartySide")
		@RuneAttribute("tradeParty2CounterpartySide")
		public String getTradeParty2CounterpartySide() {
			return tradeParty2CounterpartySide;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralPortfolioCode")
		@RuneAttribute("tradeParty1CollateralPortfolioCode")
		public String getTradeParty1CollateralPortfolioCode() {
			return tradeParty1CollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralPortfolioCode")
		@RuneAttribute("tradeParty2CollateralPortfolioCode")
		public String getTradeParty2CollateralPortfolioCode() {
			return tradeParty2CollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute("euUnderlyingAssetIdType")
		@RuneAttribute("euUnderlyingAssetIdType")
		public String getEuUnderlyingAssetIdType() {
			return euUnderlyingAssetIdType;
		}
		
		@Override
		@RosettaAttribute("productClassification")
		@RuneAttribute("productClassification")
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute("complexTradeComponentId")
		@RuneAttribute("complexTradeComponentId")
		public String getComplexTradeComponentId() {
			return complexTradeComponentId;
		}
		
		@Override
		@RosettaAttribute("priceMultiplier")
		@RuneAttribute("priceMultiplier")
		public BigDecimal getPriceMultiplier() {
			return priceMultiplier;
		}
		
		@Override
		@RosettaAttribute("quantity")
		@RuneAttribute("quantity")
		public BigDecimal getQuantity() {
			return quantity;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public String getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("confirmationDatetime")
		@RuneAttribute("confirmationDatetime")
		public ZonedDateTime getConfirmationDatetime() {
			return confirmationDatetime;
		}
		
		@Override
		@RosettaAttribute("clearingDatetime")
		@RuneAttribute("clearingDatetime")
		public ZonedDateTime getClearingDatetime() {
			return clearingDatetime;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public String getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute("productClassificationType")
		@RuneAttribute("productClassificationType")
		public String getProductClassificationType() {
			return productClassificationType;
		}
		
		@Override
		@RosettaAttribute("productIdentificationType")
		@RuneAttribute("productIdentificationType")
		public String getProductIdentificationType() {
			return productIdentificationType;
		}
		
		@Override
		@RosettaAttribute("productIdentification")
		@RuneAttribute("productIdentification")
		public String getProductIdentification() {
			return productIdentification;
		}
		
		@Override
		@RosettaAttribute("euUnderlyingAssetId")
		@RuneAttribute("euUnderlyingAssetId")
		public String getEuUnderlyingAssetId() {
			return euUnderlyingAssetId;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerIdType")
		@RuneAttribute("tradeParty1BrokerIdType")
		public String getTradeParty1BrokerIdType() {
			return tradeParty1BrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BrokerIdType")
		@RuneAttribute("tradeParty2BrokerIdType")
		public String getTradeParty2BrokerIdType() {
			return tradeParty2BrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingBrokerIdType")
		@RuneAttribute("tradeParty2ClearingBrokerIdType")
		public String getTradeParty2ClearingBrokerIdType() {
			return tradeParty2ClearingBrokerIdType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingBrokerId")
		@RuneAttribute("tradeParty2ClearingBrokerId")
		public String getTradeParty2ClearingBrokerId() {
			return tradeParty2ClearingBrokerId;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingThreshold")
		@RuneAttribute("tradeParty1ClearingThreshold")
		public Boolean getTradeParty1ClearingThreshold() {
			return tradeParty1ClearingThreshold;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingThreshold")
		@RuneAttribute("tradeParty2ClearingThreshold")
		public Boolean getTradeParty2ClearingThreshold() {
			return tradeParty2ClearingThreshold;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CorporateSectorType")
		@RuneAttribute("tradeParty1CorporateSectorType")
		public String getTradeParty1CorporateSectorType() {
			return tradeParty1CorporateSectorType;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CorporateSectorType")
		@RuneAttribute("tradeParty2CorporateSectorType")
		public String getTradeParty2CorporateSectorType() {
			return tradeParty2CorporateSectorType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		@RuneAttribute("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		public String getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator() {
			return tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		}
		
		@Override
		@RosettaAttribute("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		@RuneAttribute("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		public String getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator() {
			return tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
		}
		
		@Override
		@RosettaAttribute("intragroupIndicator")
		@RuneAttribute("intragroupIndicator")
		public Boolean getIntragroupIndicator() {
			return intragroupIndicator;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TradingCapacity1")
		@RuneAttribute("tradeParty1TradingCapacity1")
		public String getTradeParty1TradingCapacity1() {
			return tradeParty1TradingCapacity1;
		}
		
		@Override
		@RosettaAttribute("tradeParty2TradingCapacity1")
		@RuneAttribute("tradeParty2TradingCapacity1")
		public String getTradeParty2TradingCapacity1() {
			return tradeParty2TradingCapacity1;
		}
		
		@Override
		@RosettaAttribute("currencyOfPrice")
		@RuneAttribute("currencyOfPrice")
		public String getCurrencyOfPrice() {
			return currencyOfPrice;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralPortfolio")
		@RuneAttribute("tradeParty1CollateralPortfolio")
		public String getTradeParty1CollateralPortfolio() {
			return tradeParty1CollateralPortfolio;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralPortfolio")
		@RuneAttribute("tradeParty2CollateralPortfolio")
		public String getTradeParty2CollateralPortfolio() {
			return tradeParty2CollateralPortfolio;
		}
		
		@Override
		@RosettaAttribute("executionVenueMicCode")
		@RuneAttribute("executionVenueMicCode")
		public String getExecutionVenueMicCode() {
			return executionVenueMicCode;
		}
		
		@Override
		@RosettaAttribute("payment2Currency")
		@RuneAttribute("payment2Currency")
		public String getPayment2Currency() {
			return payment2Currency;
		}
		
		@Override
		@RosettaAttribute("expirationDateTimeBusinessCenter")
		@RuneAttribute("expirationDateTimeBusinessCenter")
		public String getExpirationDateTimeBusinessCenter() {
			return expirationDateTimeBusinessCenter;
		}
		
		@Override
		@RosettaAttribute("expirationTime")
		@RuneAttribute("expirationTime")
		public LocalTime getExpirationTime() {
			return expirationTime;
		}
		
		@Override
		@RosettaAttribute("expirationTimeType")
		@RuneAttribute("expirationTimeType")
		public String getExpirationTimeType() {
			return expirationTimeType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TraderLocation")
		@RuneAttribute("tradeParty1TraderLocation")
		public String getTradeParty1TraderLocation() {
			return tradeParty1TraderLocation;
		}
		
		@Override
		@RosettaAttribute("tradeParty2TraderLocation")
		@RuneAttribute("tradeParty2TraderLocation")
		public String getTradeParty2TraderLocation() {
			return tradeParty2TraderLocation;
		}
		
		@Override
		@RosettaAttribute("payment3ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment3ResetFrequencyPeriodMultiplier")
		public BigDecimal getPayment3ResetFrequencyPeriodMultiplier() {
			return payment3ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment3ResetFrequencyPeriod")
		@RuneAttribute("payment3ResetFrequencyPeriod")
		public String getPayment3ResetFrequencyPeriod() {
			return payment3ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment4ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment4ResetFrequencyPeriodMultiplier")
		public BigDecimal getPayment4ResetFrequencyPeriodMultiplier() {
			return payment4ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment4ResetFrequencyPeriod")
		@RuneAttribute("payment4ResetFrequencyPeriod")
		public String getPayment4ResetFrequencyPeriod() {
			return payment4ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment5ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment5ResetFrequencyPeriodMultiplier")
		public BigDecimal getPayment5ResetFrequencyPeriodMultiplier() {
			return payment5ResetFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment5ResetFrequencyPeriod")
		@RuneAttribute("payment5ResetFrequencyPeriod")
		public String getPayment5ResetFrequencyPeriod() {
			return payment5ResetFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment1Type")
		@RuneAttribute("payment1Type")
		public String getPayment1Type() {
			return payment1Type;
		}
		
		@Override
		@RosettaAttribute("payment1Reference")
		@RuneAttribute("payment1Reference")
		public String getPayment1Reference() {
			return payment1Reference;
		}
		
		@Override
		@RosettaAttribute("payment2Type")
		@RuneAttribute("payment2Type")
		public String getPayment2Type() {
			return payment2Type;
		}
		
		@Override
		@RosettaAttribute("payment2Reference")
		@RuneAttribute("payment2Reference")
		public String getPayment2Reference() {
			return payment2Reference;
		}
		
		@Override
		@RosettaAttribute("payment3Payer")
		@RuneAttribute("payment3Payer")
		public String getPayment3Payer() {
			return payment3Payer;
		}
		
		@Override
		@RosettaAttribute("payment3Reference")
		@RuneAttribute("payment3Reference")
		public String getPayment3Reference() {
			return payment3Reference;
		}
		
		@Override
		@RosettaAttribute("payment3FrequencyPeriod")
		@RuneAttribute("payment3FrequencyPeriod")
		public String getPayment3FrequencyPeriod() {
			return payment3FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment3FrequencyPeriodMultiplier")
		@RuneAttribute("payment3FrequencyPeriodMultiplier")
		public BigDecimal getPayment3FrequencyPeriodMultiplier() {
			return payment3FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment3Date")
		@RuneAttribute("payment3Date")
		public Date getPayment3Date() {
			return payment3Date;
		}
		
		@Override
		@RosettaAttribute("payment4Reference")
		@RuneAttribute("payment4Reference")
		public String getPayment4Reference() {
			return payment4Reference;
		}
		
		@Override
		@RosettaAttribute("payment4Payer")
		@RuneAttribute("payment4Payer")
		public String getPayment4Payer() {
			return payment4Payer;
		}
		
		@Override
		@RosettaAttribute("payment4FrequencyPeriod")
		@RuneAttribute("payment4FrequencyPeriod")
		public String getPayment4FrequencyPeriod() {
			return payment4FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment4FrequencyPeriodMultiplier")
		@RuneAttribute("payment4FrequencyPeriodMultiplier")
		public BigDecimal getPayment4FrequencyPeriodMultiplier() {
			return payment4FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment4Date")
		@RuneAttribute("payment4Date")
		public Date getPayment4Date() {
			return payment4Date;
		}
		
		@Override
		@RosettaAttribute("payment5Reference")
		@RuneAttribute("payment5Reference")
		public String getPayment5Reference() {
			return payment5Reference;
		}
		
		@Override
		@RosettaAttribute("payment5Payer")
		@RuneAttribute("payment5Payer")
		public String getPayment5Payer() {
			return payment5Payer;
		}
		
		@Override
		@RosettaAttribute("payment5FrequencyPeriod")
		@RuneAttribute("payment5FrequencyPeriod")
		public String getPayment5FrequencyPeriod() {
			return payment5FrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("payment5FrequencyPeriodMultiplier")
		@RuneAttribute("payment5FrequencyPeriodMultiplier")
		public BigDecimal getPayment5FrequencyPeriodMultiplier() {
			return payment5FrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("payment5Date")
		@RuneAttribute("payment5Date")
		public Date getPayment5Date() {
			return payment5Date;
		}
		
		@Override
		@RosettaAttribute("payment3Type")
		@RuneAttribute("payment3Type")
		public String getPayment3Type() {
			return payment3Type;
		}
		
		@Override
		@RosettaAttribute("premiumPayer")
		@RuneAttribute("premiumPayer")
		public String getPremiumPayer() {
			return premiumPayer;
		}
		
		@Override
		@RosettaAttribute("premiumPaymentDateUnadjusted")
		@RuneAttribute("premiumPaymentDateUnadjusted")
		public Date getPremiumPaymentDateUnadjusted() {
			return premiumPaymentDateUnadjusted;
		}
		
		@Override
		@RosettaAttribute("tradeParty1NatureOfTheReportingCounterparty")
		@RuneAttribute("tradeParty1NatureOfTheReportingCounterparty")
		public String getTradeParty1NatureOfTheReportingCounterparty() {
			return tradeParty1NatureOfTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("tradeParty2NatureOfTheReportingCounterparty")
		@RuneAttribute("tradeParty2NatureOfTheReportingCounterparty")
		public String getTradeParty2NatureOfTheReportingCounterparty() {
			return tradeParty2NatureOfTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse1")
		@RuneAttribute("reservedParticipantUse1")
		public String getReservedParticipantUse1() {
			return reservedParticipantUse1;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse2")
		@RuneAttribute("reservedParticipantUse2")
		public String getReservedParticipantUse2() {
			return reservedParticipantUse2;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse3")
		@RuneAttribute("reservedParticipantUse3")
		public String getReservedParticipantUse3() {
			return reservedParticipantUse3;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse4")
		@RuneAttribute("reservedParticipantUse4")
		public String getReservedParticipantUse4() {
			return reservedParticipantUse4;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse5")
		@RuneAttribute("reservedParticipantUse5")
		public String getReservedParticipantUse5() {
			return reservedParticipantUse5;
		}
		
		@Override
		@RosettaAttribute("leg1TerminationDate")
		@RuneAttribute("leg1TerminationDate")
		public Date getLeg1TerminationDate() {
			return leg1TerminationDate;
		}
		
		@Override
		@RosettaAttribute("allocationType")
		@RuneAttribute("allocationType")
		public String getAllocationType() {
			return allocationType;
		}
		
		@Override
		@RosettaAttribute("calculationBasis")
		@RuneAttribute("calculationBasis")
		public String getCalculationBasis() {
			return calculationBasis;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionPartyId")
		@RuneAttribute("clearingExceptionPartyId")
		public String getClearingExceptionPartyId() {
			return clearingExceptionPartyId;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionPartyIdType")
		@RuneAttribute("clearingExceptionPartyIdType")
		public String getClearingExceptionPartyIdType() {
			return clearingExceptionPartyIdType;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionType")
		@RuneAttribute("clearingExceptionType")
		public String getClearingExceptionType() {
			return clearingExceptionType;
		}
		
		@Override
		@RosettaAttribute("clearingMemberClientAccountId")
		@RuneAttribute("clearingMemberClientAccountId")
		public String getClearingMemberClientAccountId() {
			return clearingMemberClientAccountId;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptDatetime")
		@RuneAttribute("clearingReceiptDatetime")
		public ZonedDateTime getClearingReceiptDatetime() {
			return clearingReceiptDatetime;
		}
		
		@Override
		@RosettaAttribute("clearingSwapSdrLeiId")
		@RuneAttribute("clearingSwapSdrLeiId")
		public String getClearingSwapSdrLeiId() {
			return clearingSwapSdrLeiId;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUtiId")
		@RuneAttribute("clearingSwapUtiId")
		public String getClearingSwapUtiId() {
			return clearingSwapUtiId;
		}
		
		@Override
		@RosettaAttribute("collateralReportingDate")
		@RuneAttribute("collateralReportingDate")
		public Date getCollateralReportingDate() {
			return collateralReportingDate;
		}
		
		@Override
		@RosettaAttribute("collateralValuationDatetime")
		@RuneAttribute("collateralValuationDatetime")
		public ZonedDateTime getCollateralValuationDatetime() {
			return collateralValuationDatetime;
		}
		
		@Override
		@RosettaAttribute("comment2")
		@RuneAttribute("comment2")
		public String getComment2() {
			return comment2;
		}
		
		@Override
		@RosettaAttribute("commodityStrikePriceUnit")
		@RuneAttribute("commodityStrikePriceUnit")
		public String getCommodityStrikePriceUnit() {
			return commodityStrikePriceUnit;
		}
		
		@Override
		@RosettaAttribute("executionAgentMaskingIndicator")
		@RuneAttribute("executionAgentMaskingIndicator")
		public String getExecutionAgentMaskingIndicator() {
			return executionAgentMaskingIndicator;
		}
		
		@Override
		@RosettaAttribute("feeInCurrency")
		@RuneAttribute("feeInCurrency")
		public String getFeeInCurrency() {
			return feeInCurrency;
		}
		
		@Override
		@RosettaAttribute("feeOutCurrency")
		@RuneAttribute("feeOutCurrency")
		public String getFeeOutCurrency() {
			return feeOutCurrency;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg1Multiplier")
		@RuneAttribute("floatingRatePaymentFrequencyLeg1Multiplier")
		public BigDecimal getFloatingRatePaymentFrequencyLeg1Multiplier() {
			return floatingRatePaymentFrequencyLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg1TimePeriod")
		@RuneAttribute("floatingRatePaymentFrequencyLeg1TimePeriod")
		public String getFloatingRatePaymentFrequencyLeg1TimePeriod() {
			return floatingRatePaymentFrequencyLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg2Multiplier")
		@RuneAttribute("floatingRatePaymentFrequencyLeg2Multiplier")
		public BigDecimal getFloatingRatePaymentFrequencyLeg2Multiplier() {
			return floatingRatePaymentFrequencyLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg2TimePeriod")
		@RuneAttribute("floatingRatePaymentFrequencyLeg2TimePeriod")
		public String getFloatingRatePaymentFrequencyLeg2TimePeriod() {
			return floatingRatePaymentFrequencyLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("frequencyOfPayment")
		@RuneAttribute("frequencyOfPayment")
		public String getFrequencyOfPayment() {
			return frequencyOfPayment;
		}
		
		@Override
		@RosettaAttribute("interaffiliate")
		@RuneAttribute("interaffiliate")
		public Boolean getInteraffiliate() {
			return interaffiliate;
		}
		
		@Override
		@RosettaAttribute("largeTradeIndicator")
		@RuneAttribute("largeTradeIndicator")
		public Boolean getLargeTradeIndicator() {
			return largeTradeIndicator;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDateAdjusted")
		@RuneAttribute("leg1EffectiveDateAdjusted")
		public Date getLeg1EffectiveDateAdjusted() {
			return leg1EffectiveDateAdjusted;
		}
		
		@Override
		@RosettaAttribute("leg1FinalValuationDate")
		@RuneAttribute("leg1FinalValuationDate")
		public Date getLeg1FinalValuationDate() {
			return leg1FinalValuationDate;
		}
		
		@Override
		@RosettaAttribute("leg1SettlementPeriod")
		@RuneAttribute("leg1SettlementPeriod")
		public String getLeg1SettlementPeriod() {
			return leg1SettlementPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDateAdjusted")
		@RuneAttribute("leg2EffectiveDateAdjusted")
		public Date getLeg2EffectiveDateAdjusted() {
			return leg2EffectiveDateAdjusted;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentTermsFrequencyPeriod")
		@RuneAttribute("leg2PaymentTermsFrequencyPeriod")
		public String getLeg2PaymentTermsFrequencyPeriod() {
			return leg2PaymentTermsFrequencyPeriod;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentTermsPaymentFrequencyPeriodMultiplier")
		@RuneAttribute("leg2PaymentTermsPaymentFrequencyPeriodMultiplier")
		public BigDecimal getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier() {
			return leg2PaymentTermsPaymentFrequencyPeriodMultiplier;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementType")
		@RuneAttribute("leg2SettlementType")
		public String getLeg2SettlementType() {
			return leg2SettlementType;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetId")
		@RuneAttribute("leg2UnderlyingAssetId")
		public String getLeg2UnderlyingAssetId() {
			return leg2UnderlyingAssetId;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetIdType")
		@RuneAttribute("leg2UnderlyingAssetIdType")
		public String getLeg2UnderlyingAssetIdType() {
			return leg2UnderlyingAssetIdType;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetName")
		@RuneAttribute("leg2UnderlyingAssetName")
		public String getLeg2UnderlyingAssetName() {
			return leg2UnderlyingAssetName;
		}
		
		@Override
		@RosettaAttribute("maturityDate")
		@RuneAttribute("maturityDate")
		public Date getMaturityDate() {
			return maturityDate;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationDate")
		@RuneAttribute("optionalEarlyTerminationDate")
		public String getOptionalEarlyTerminationDate() {
			return optionalEarlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("optionCommodityCurrency")
		@RuneAttribute("optionCommodityCurrency")
		public String getOptionCommodityCurrency() {
			return optionCommodityCurrency;
		}
		
		@Override
		@RosettaAttribute("optionCommodityExchangeId")
		@RuneAttribute("optionCommodityExchangeId")
		public String getOptionCommodityExchangeId() {
			return optionCommodityExchangeId;
		}
		
		@Override
		@RosettaAttribute("optionCommodityInstrumentId")
		@RuneAttribute("optionCommodityInstrumentId")
		public String getOptionCommodityInstrumentId() {
			return optionCommodityInstrumentId;
		}
		
		@Override
		@RosettaAttribute("optionCommodityRateSource")
		@RuneAttribute("optionCommodityRateSource")
		public String getOptionCommodityRateSource() {
			return optionCommodityRateSource;
		}
		
		@Override
		@RosettaAttribute("optionCommodityRateSourcePage")
		@RuneAttribute("optionCommodityRateSourcePage")
		public String getOptionCommodityRateSourcePage() {
			return optionCommodityRateSourcePage;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnderlyerDetails")
		@RuneAttribute("optionCommodityUnderlyerDetails")
		public String getOptionCommodityUnderlyerDetails() {
			return optionCommodityUnderlyerDetails;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnderlyerId")
		@RuneAttribute("optionCommodityUnderlyerId")
		public String getOptionCommodityUnderlyerId() {
			return optionCommodityUnderlyerId;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnitOfMeasure")
		@RuneAttribute("optionCommodityUnitOfMeasure")
		public String getOptionCommodityUnitOfMeasure() {
			return optionCommodityUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("optionSpecifiedPrice")
		@RuneAttribute("optionSpecifiedPrice")
		public String getOptionSpecifiedPrice() {
			return optionSpecifiedPrice;
		}
		
		@Override
		@RosettaAttribute("optionSpreadAmount")
		@RuneAttribute("optionSpreadAmount")
		public BigDecimal getOptionSpreadAmount() {
			return optionSpreadAmount;
		}
		
		@Override
		@RosettaAttribute("optionSpreadCurrency")
		@RuneAttribute("optionSpreadCurrency")
		public String getOptionSpreadCurrency() {
			return optionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("optionSpreadSchedule")
		@RuneAttribute("optionSpreadSchedule")
		public String getOptionSpreadSchedule() {
			return optionSpreadSchedule;
		}
		
		@Override
		@RosettaAttribute("origin")
		@RuneAttribute("origin")
		public String getOrigin() {
			return origin;
		}
		
		@Override
		@RosettaAttribute("originalSwapSdrId")
		@RuneAttribute("originalSwapSdrId")
		public String getOriginalSwapSdrId() {
			return originalSwapSdrId;
		}
		
		@Override
		@RosettaAttribute("originalSwapSdrIdType")
		@RuneAttribute("originalSwapSdrIdType")
		public String getOriginalSwapSdrIdType() {
			return originalSwapSdrIdType;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg1")
		@RuneAttribute("paymentFrequencyPeriodLeg1")
		public String getPaymentFrequencyPeriodLeg1() {
			return paymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg2")
		@RuneAttribute("paymentFrequencyPeriodLeg2")
		public String getPaymentFrequencyPeriodLeg2() {
			return paymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg1")
		public BigDecimal getPaymentFrequencyPeriodMultiplierLeg1() {
			return paymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg2")
		public BigDecimal getPaymentFrequencyPeriodMultiplierLeg2() {
			return paymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("premiumPayerPrefix")
		@RuneAttribute("premiumPayerPrefix")
		public String getPremiumPayerPrefix() {
			return premiumPayerPrefix;
		}
		
		@Override
		@RosettaAttribute("price1Currency")
		@RuneAttribute("price1Currency")
		public String getPrice1Currency() {
			return price1Currency;
		}
		
		@Override
		@RosettaAttribute("price2Price")
		@RuneAttribute("price2Price")
		public BigDecimal getPrice2Price() {
			return price2Price;
		}
		
		@Override
		@RosettaAttribute("price2Type")
		@RuneAttribute("price2Type")
		public String getPrice2Type() {
			return price2Type;
		}
		
		@Override
		@RosettaAttribute("price2Units")
		@RuneAttribute("price2Units")
		public String getPrice2Units() {
			return price2Units;
		}
		
		@Override
		@RosettaAttribute("price3Price")
		@RuneAttribute("price3Price")
		public BigDecimal getPrice3Price() {
			return price3Price;
		}
		
		@Override
		@RosettaAttribute("price3Type")
		@RuneAttribute("price3Type")
		public String getPrice3Type() {
			return price3Type;
		}
		
		@Override
		@RosettaAttribute("price3Units")
		@RuneAttribute("price3Units")
		public String getPrice3Units() {
			return price3Units;
		}
		
		@Override
		@RosettaAttribute("price4Price")
		@RuneAttribute("price4Price")
		public BigDecimal getPrice4Price() {
			return price4Price;
		}
		
		@Override
		@RosettaAttribute("price4Type")
		@RuneAttribute("price4Type")
		public String getPrice4Type() {
			return price4Type;
		}
		
		@Override
		@RosettaAttribute("price4Units")
		@RuneAttribute("price4Units")
		public String getPrice4Units() {
			return price4Units;
		}
		
		@Override
		@RosettaAttribute("pricingContext")
		@RuneAttribute("pricingContext")
		public String getPricingContext() {
			return pricingContext;
		}
		
		@Override
		@RosettaAttribute("priorUsiType")
		@RuneAttribute("priorUsiType")
		public String getPriorUsiType() {
			return priorUsiType;
		}
		
		@Override
		@RosettaAttribute("priorUtiType")
		@RuneAttribute("priorUtiType")
		public String getPriorUtiType() {
			return priorUtiType;
		}
		
		@Override
		@RosettaAttribute("recoveryPrice")
		@RuneAttribute("recoveryPrice")
		public BigDecimal getRecoveryPrice() {
			return recoveryPrice;
		}
		
		@Override
		@RosettaAttribute("sendToDataCenterCode")
		@RuneAttribute("sendToDataCenterCode")
		public String getSendToDataCenterCode() {
			return sendToDataCenterCode;
		}
		
		@Override
		@RosettaAttribute("strikePriceType")
		@RuneAttribute("strikePriceType")
		public String getStrikePriceType() {
			return strikePriceType;
		}
		
		@Override
		@RosettaAttribute("subAssetClassForOtherCommodity")
		@RuneAttribute("subAssetClassForOtherCommodity")
		public String getSubAssetClassForOtherCommodity() {
			return subAssetClassForOtherCommodity;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CftcFinancialEntityStatus")
		@RuneAttribute("tradeParty1CftcFinancialEntityStatus")
		public String getTradeParty1CftcFinancialEntityStatus() {
			return tradeParty1CftcFinancialEntityStatus;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralAmount")
		@RuneAttribute("tradeParty1CollateralAmount")
		public BigDecimal getTradeParty1CollateralAmount() {
			return tradeParty1CollateralAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralCurrency")
		@RuneAttribute("tradeParty1CollateralCurrency")
		public String getTradeParty1CollateralCurrency() {
			return tradeParty1CollateralCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty1MandatoryDelegatedReporting")
		@RuneAttribute("tradeParty1MandatoryDelegatedReporting")
		public String getTradeParty1MandatoryDelegatedReporting() {
			return tradeParty1MandatoryDelegatedReporting;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Role")
		@RuneAttribute("tradeParty1Role")
		public String getTradeParty1Role() {
			return tradeParty1Role;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CftcFinancialEntityStatus")
		@RuneAttribute("tradeParty2CftcFinancialEntityStatus")
		public String getTradeParty2CftcFinancialEntityStatus() {
			return tradeParty2CftcFinancialEntityStatus;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralAmount")
		@RuneAttribute("tradeParty2CollateralAmount")
		public BigDecimal getTradeParty2CollateralAmount() {
			return tradeParty2CollateralAmount;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralCurrency")
		@RuneAttribute("tradeParty2CollateralCurrency")
		public String getTradeParty2CollateralCurrency() {
			return tradeParty2CollateralCurrency;
		}
		
		@Override
		@RosettaAttribute("tradeParty2MandatoryDelegatedReporting")
		@RuneAttribute("tradeParty2MandatoryDelegatedReporting")
		public String getTradeParty2MandatoryDelegatedReporting() {
			return tradeParty2MandatoryDelegatedReporting;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Role")
		@RuneAttribute("tradeParty2Role")
		public String getTradeParty2Role() {
			return tradeParty2Role;
		}
		
		@Override
		@RosettaAttribute("upfrontPayment")
		@RuneAttribute("upfrontPayment")
		public BigDecimal getUpfrontPayment() {
			return upfrontPayment;
		}
		
		@Override
		@RosettaAttribute("verificationMethod")
		@RuneAttribute("verificationMethod")
		public String getVerificationMethod() {
			return verificationMethod;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterId")
		@RuneAttribute("responsibleDataSubmitterId")
		public String getResponsibleDataSubmitterId() {
			return responsibleDataSubmitterId;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterIdType")
		@RuneAttribute("responsibleDataSubmitterIdType")
		public String getResponsibleDataSubmitterIdType() {
			return responsibleDataSubmitterIdType;
		}
		
		@Override
		@RosettaAttribute("originalSwapUsi")
		@RuneAttribute("originalSwapUsi")
		public String getOriginalSwapUsi() {
			return originalSwapUsi;
		}
		
		@Override
		@RosettaAttribute("originalSwapUti")
		@RuneAttribute("originalSwapUti")
		public String getOriginalSwapUti() {
			return originalSwapUti;
		}
		
		@Override
		@RosettaAttribute("cdeReceiverIdentifierLeg2")
		@RuneAttribute("cdeReceiverIdentifierLeg2")
		public String getCdeReceiverIdentifierLeg2() {
			return cdeReceiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("counterparty1FederalEntityIndicator")
		@RuneAttribute("counterparty1FederalEntityIndicator")
		public Boolean getCounterparty1FederalEntityIndicator() {
			return counterparty1FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("counterparty2FederalEntityIndicator")
		@RuneAttribute("counterparty2FederalEntityIndicator")
		public Boolean getCounterparty2FederalEntityIndicator() {
			return counterparty2FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute("noaActionType")
		@RuneAttribute("noaActionType")
		public String getNoaActionType() {
			return noaActionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute("cdeCallAmountLeg1")
		@RuneAttribute("cdeCallAmountLeg1")
		public BigDecimal getCdeCallAmountLeg1() {
			return cdeCallAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeCallAmountLeg2")
		@RuneAttribute("cdeCallAmountLeg2")
		public BigDecimal getCdeCallAmountLeg2() {
			return cdeCallAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeCallCurrencyLeg1")
		@RuneAttribute("cdeCallCurrencyLeg1")
		public String getCdeCallCurrencyLeg1() {
			return cdeCallCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeCallCurrencyLeg2")
		@RuneAttribute("cdeCallCurrencyLeg2")
		public String getCdeCallCurrencyLeg2() {
			return cdeCallCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("cdePutAmountLeg1")
		@RuneAttribute("cdePutAmountLeg1")
		public BigDecimal getCdePutAmountLeg1() {
			return cdePutAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("cdePutAmountLeg2")
		@RuneAttribute("cdePutAmountLeg2")
		public BigDecimal getCdePutAmountLeg2() {
			return cdePutAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("cdePutCurrencyLeg1")
		@RuneAttribute("cdePutCurrencyLeg1")
		public String getCdePutCurrencyLeg1() {
			return cdePutCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("cdePutCurrencyLeg2")
		@RuneAttribute("cdePutCurrencyLeg2")
		public String getCdePutCurrencyLeg2() {
			return cdePutCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("leg2QuantityFrequency")
		@RuneAttribute("leg2QuantityFrequency")
		public String getLeg2QuantityFrequency() {
			return leg2QuantityFrequency;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg1")
		@RuneAttribute("quantityFrequencyMultiplierLeg1")
		public BigDecimal getQuantityFrequencyMultiplierLeg1() {
			return quantityFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg2")
		@RuneAttribute("quantityFrequencyMultiplierLeg2")
		public BigDecimal getQuantityFrequencyMultiplierLeg2() {
			return quantityFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeQuantityUnitOfMeasureLeg1")
		@RuneAttribute("cdeQuantityUnitOfMeasureLeg1")
		public String getCdeQuantityUnitOfMeasureLeg1() {
			return cdeQuantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeQuantityUnitOfMeasureLeg2")
		@RuneAttribute("cdeQuantityUnitOfMeasureLeg2")
		public String getCdeQuantityUnitOfMeasureLeg2() {
			return cdeQuantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("cdePackageIdentifier")
		@RuneAttribute("cdePackageIdentifier")
		public String getCdePackageIdentifier() {
			return cdePackageIdentifier;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPrice")
		@RuneAttribute("cdePackageTransactionPrice")
		public BigDecimal getCdePackageTransactionPrice() {
			return cdePackageTransactionPrice;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPriceCurrency")
		@RuneAttribute("cdePackageTransactionPriceCurrency")
		public String getCdePackageTransactionPriceCurrency() {
			return cdePackageTransactionPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPriceNotation")
		@RuneAttribute("cdePackageTransactionPriceNotation")
		public String getCdePackageTransactionPriceNotation() {
			return cdePackageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpread")
		@RuneAttribute("cdePackageTransactionSpread")
		public BigDecimal getCdePackageTransactionSpread() {
			return cdePackageTransactionSpread;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpreadCurrency")
		@RuneAttribute("cdePackageTransactionSpreadCurrency")
		public String getCdePackageTransactionSpreadCurrency() {
			return cdePackageTransactionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpreadNotation")
		@RuneAttribute("cdePackageTransactionSpreadNotation")
		public String getCdePackageTransactionSpreadNotation() {
			return cdePackageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRateDayCountConventionLeg1")
		@RuneAttribute("cdeFixedRateDayCountConventionLeg1")
		public String getCdeFixedRateDayCountConventionLeg1() {
			return cdeFixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRateDayCountConventionLeg2")
		@RuneAttribute("cdeFixedRateDayCountConventionLeg2")
		public String getCdeFixedRateDayCountConventionLeg2() {
			return cdeFixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRateDayCountConventionLeg1")
		@RuneAttribute("cdeFloatingRateDayCountConventionLeg1")
		public String getCdeFloatingRateDayCountConventionLeg1() {
			return cdeFloatingRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRateDayCountConventionLeg2")
		@RuneAttribute("cdeFloatingRateDayCountConventionLeg2")
		public String getCdeFloatingRateDayCountConventionLeg2() {
			return cdeFloatingRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		public Date getFixingDateLeg1() {
			return fixingDateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		public Date getFixingDateLeg2() {
			return fixingDateLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodLeg1")
		public String getCdeFixedRatePaymentFrequencyPeriodLeg1() {
			return cdeFixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodLeg2")
		public String getCdeFixedRatePaymentFrequencyPeriodLeg2() {
			return cdeFixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg1")
		public String getCdeFloatingRatePaymentFrequencyPeriodLeg1() {
			return cdeFloatingRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg2")
		public String getCdeFloatingRatePaymentFrequencyPeriodLeg2() {
			return cdeFloatingRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public BigDecimal getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public BigDecimal getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1")
		public BigDecimal getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
			return cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2")
		public BigDecimal getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
			return cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("postPricedSwapIndicator")
		@RuneAttribute("postPricedSwapIndicator")
		public Boolean getPostPricedSwapIndicator() {
			return postPricedSwapIndicator;
		}
		
		@Override
		@RosettaAttribute("cdePriceCurrency")
		@RuneAttribute("cdePriceCurrency")
		public String getCdePriceCurrency() {
			return cdePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("cdePriceNotation")
		@RuneAttribute("cdePriceNotation")
		public String getCdePriceNotation() {
			return cdePriceNotation;
		}
		
		@Override
		@RosettaAttribute("cdeSpreadNotationLeg1")
		@RuneAttribute("cdeSpreadNotationLeg1")
		public String getCdeSpreadNotationLeg1() {
			return cdeSpreadNotationLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeSpreadNotationLeg2")
		@RuneAttribute("cdeSpreadNotationLeg2")
		public String getCdeSpreadNotationLeg2() {
			return cdeSpreadNotationLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeStrikePriceCurrency2")
		@RuneAttribute("cdeStrikePriceCurrency2")
		public String getCdeStrikePriceCurrency2() {
			return cdeStrikePriceCurrency2;
		}
		
		@Override
		@RosettaAttribute("cdeStrikePriceNotation")
		@RuneAttribute("cdeStrikePriceNotation")
		public String getCdeStrikePriceNotation() {
			return cdeStrikePriceNotation;
		}
		
		@Override
		@RosettaAttribute("cdeFirstExerciseDate")
		@RuneAttribute("cdeFirstExerciseDate")
		public Date getCdeFirstExerciseDate() {
			return cdeFirstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("cdeFinalContractualSettlementDate")
		@RuneAttribute("cdeFinalContractualSettlementDate")
		public Date getCdeFinalContractualSettlementDate() {
			return cdeFinalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("cdeSettlementLocationLeg1")
		@RuneAttribute("cdeSettlementLocationLeg1")
		public String getCdeSettlementLocationLeg1() {
			return cdeSettlementLocationLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeSettlementLocationLeg2")
		@RuneAttribute("cdeSettlementLocationLeg2")
		public String getCdeSettlementLocationLeg2() {
			return cdeSettlementLocationLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeEffectiveDate")
		@RuneAttribute("cdeEffectiveDate")
		public Date getCdeEffectiveDate() {
			return cdeEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("cdeExpirationDate")
		@RuneAttribute("cdeExpirationDate")
		public Date getCdeExpirationDate() {
			return cdeExpirationDate;
		}
		
		@Override
		@RosettaAttribute("cdePlatformIdentifier")
		@RuneAttribute("cdePlatformIdentifier")
		public String getCdePlatformIdentifier() {
			return cdePlatformIdentifier;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public Boolean getPrimeBrokerageTransactionIndicator() {
			return primeBrokerageTransactionIndicator;
		}
		
		@Override
		@RosettaAttribute("swapReportingJurisdiction")
		@RuneAttribute("swapReportingJurisdiction")
		public String getSwapReportingJurisdiction() {
			return swapReportingJurisdiction;
		}
		
		@Override
		@RosettaAttribute("newSdrIdentifier")
		@RuneAttribute("newSdrIdentifier")
		public String getNewSdrIdentifier() {
			return newSdrIdentifier;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceValueLeg1")
		@RuneAttribute("lastFloatingReferenceValueLeg1")
		public BigDecimal getLastFloatingReferenceValueLeg1() {
			return lastFloatingReferenceValueLeg1;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceResetDateLeg1")
		@RuneAttribute("lastFloatingReferenceResetDateLeg1")
		public Date getLastFloatingReferenceResetDateLeg1() {
			return lastFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceValueLeg2")
		@RuneAttribute("lastFloatingReferenceValueLeg2")
		public BigDecimal getLastFloatingReferenceValueLeg2() {
			return lastFloatingReferenceValueLeg2;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceResetDateLeg2")
		@RuneAttribute("lastFloatingReferenceResetDateLeg2")
		public Date getLastFloatingReferenceResetDateLeg2() {
			return lastFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeDelta")
		@RuneAttribute("cdeDelta")
		public BigDecimal getCdeDelta() {
			return cdeDelta;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		@RuneAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		public Boolean getLargeNotionalOffFacilitySwapElectionIndicator() {
			return largeNotionalOffFacilitySwapElectionIndicator;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmAnonymousExecutionIndicator")
		@RuneAttribute("sefOrDcmAnonymousExecutionIndicator")
		public Boolean getSefOrDcmAnonymousExecutionIndicator() {
			return sefOrDcmAnonymousExecutionIndicator;
		}
		
		@Override
		@RosettaAttribute("blockTradeElectionIndicator")
		@RuneAttribute("blockTradeElectionIndicator")
		public Boolean getBlockTradeElectionIndicator() {
			return blockTradeElectionIndicator;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmIndicator")
		@RuneAttribute("sefOrDcmIndicator")
		public Boolean getSefOrDcmIndicator() {
			return sefOrDcmIndicator;
		}
		
		@Override
		@RosettaAttribute("mandatoryClearingIndicator")
		@RuneAttribute("mandatoryClearingIndicator")
		public Boolean getMandatoryClearingIndicator() {
			return mandatoryClearingIndicator;
		}
		
		@Override
		@RosettaAttribute("sdMspIndicatorCounterparty1")
		@RuneAttribute("sdMspIndicatorCounterparty1")
		public Boolean getSdMspIndicatorCounterparty1() {
			return sdMspIndicatorCounterparty1;
		}
		
		@Override
		@RosettaAttribute("sdMspIndicatorCounterparty2")
		@RuneAttribute("sdMspIndicatorCounterparty2")
		public Boolean getSdMspIndicatorCounterparty2() {
			return sdMspIndicatorCounterparty2;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityContractIndicator")
		@RuneAttribute("physicalCommodityContractIndicator")
		public Boolean getPhysicalCommodityContractIndicator() {
			return physicalCommodityContractIndicator;
		}
		
		@Override
		@RosettaAttribute("changeInNotionalAmount1")
		@RuneAttribute("changeInNotionalAmount1")
		public BigDecimal getChangeInNotionalAmount1() {
			return changeInNotionalAmount1;
		}
		
		@Override
		@RosettaAttribute("changeInNotionalAmount2")
		@RuneAttribute("changeInNotionalAmount2")
		public BigDecimal getChangeInNotionalAmount2() {
			return changeInNotionalAmount2;
		}
		
		@Override
		@RosettaAttribute("changeInLeg1NotionalQuantity")
		@RuneAttribute("changeInLeg1NotionalQuantity")
		public BigDecimal getChangeInLeg1NotionalQuantity() {
			return changeInLeg1NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("changeInLeg2NotionalQuantity")
		@RuneAttribute("changeInLeg2NotionalQuantity")
		public BigDecimal getChangeInLeg2NotionalQuantity() {
			return changeInLeg2NotionalQuantity;
		}
		
		@Override
		@RosettaAttribute("cdeCryptoAssetUnderlyingIndicatorLeg1")
		@RuneAttribute("cdeCryptoAssetUnderlyingIndicatorLeg1")
		public Boolean getCdeCryptoAssetUnderlyingIndicatorLeg1() {
			return cdeCryptoAssetUnderlyingIndicatorLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeCryptoAssetUnderlyingIndicatorLeg2")
		@RuneAttribute("cdeCryptoAssetUnderlyingIndicatorLeg2")
		public Boolean getCdeCryptoAssetUnderlyingIndicatorLeg2() {
			return cdeCryptoAssetUnderlyingIndicatorLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeCustomBasketCode")
		@RuneAttribute("cdeCustomBasketCode")
		public String getCdeCustomBasketCode() {
			return cdeCustomBasketCode;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherLeg1")
		@RuneAttribute("underlierIdOtherLeg1")
		public String getUnderlierIdOtherLeg1() {
			return underlierIdOtherLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherLeg2")
		@RuneAttribute("underlierIdOtherLeg2")
		public String getUnderlierIdOtherLeg2() {
			return underlierIdOtherLeg2;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherSourceLeg1")
		@RuneAttribute("underlierIdOtherSourceLeg1")
		public String getUnderlierIdOtherSourceLeg1() {
			return underlierIdOtherSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherSourceLeg2")
		@RuneAttribute("underlierIdOtherSourceLeg2")
		public String getUnderlierIdOtherSourceLeg2() {
			return underlierIdOtherSourceLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetTradingPlatformIdLeg1")
		@RuneAttribute("cdeUnderlyingAssetTradingPlatformIdLeg1")
		public String getCdeUnderlyingAssetTradingPlatformIdLeg1() {
			return cdeUnderlyingAssetTradingPlatformIdLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetTradingPlatformIdLeg2")
		@RuneAttribute("cdeUnderlyingAssetTradingPlatformIdLeg2")
		public String getCdeUnderlyingAssetTradingPlatformIdLeg2() {
			return cdeUnderlyingAssetTradingPlatformIdLeg2;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetPriceSourceLeg1")
		@RuneAttribute("cdeUnderlyingAssetPriceSourceLeg1")
		public String getCdeUnderlyingAssetPriceSourceLeg1() {
			return cdeUnderlyingAssetPriceSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetPriceSourceLeg2")
		@RuneAttribute("cdeUnderlyingAssetPriceSourceLeg2")
		public String getCdeUnderlyingAssetPriceSourceLeg2() {
			return cdeUnderlyingAssetPriceSourceLeg2;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityInstrumentId")
		@RuneAttribute("leg2CommodityInstrumentId")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityInstrumentId(String _leg2CommodityInstrumentId) {
			this.leg2CommodityInstrumentId = _leg2CommodityInstrumentId == null ? null : _leg2CommodityInstrumentId;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerId")
		@RuneAttribute("leg2CommodityUnderlyerId")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityUnderlyerId(String _leg2CommodityUnderlyerId) {
			this.leg2CommodityUnderlyerId = _leg2CommodityUnderlyerId == null ? null : _leg2CommodityUnderlyerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerDetails")
		@RuneAttribute("leg2CommodityUnderlyerDetails")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityUnderlyerDetails(String _leg2CommodityUnderlyerDetails) {
			this.leg2CommodityUnderlyerDetails = _leg2CommodityUnderlyerDetails == null ? null : _leg2CommodityUnderlyerDetails;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnitOfMeasure")
		@RuneAttribute("leg2CommodityUnitOfMeasure")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityUnitOfMeasure(String _leg2CommodityUnitOfMeasure) {
			this.leg2CommodityUnitOfMeasure = _leg2CommodityUnitOfMeasure == null ? null : _leg2CommodityUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityCurrency")
		@RuneAttribute("leg2CommodityCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityCurrency(String _leg2CommodityCurrency) {
			this.leg2CommodityCurrency = _leg2CommodityCurrency == null ? null : _leg2CommodityCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityExchangeId")
		@RuneAttribute("leg2CommodityExchangeId")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityExchangeId(String _leg2CommodityExchangeId) {
			this.leg2CommodityExchangeId = _leg2CommodityExchangeId == null ? null : _leg2CommodityExchangeId;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityRateSource")
		@RuneAttribute("leg1CommodityRateSource")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityRateSource(String _leg1CommodityRateSource) {
			this.leg1CommodityRateSource = _leg1CommodityRateSource == null ? null : _leg1CommodityRateSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityRateSourcePage")
		@RuneAttribute("leg1CommodityRateSourcePage")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityRateSourcePage(String _leg1CommodityRateSourcePage) {
			this.leg1CommodityRateSourcePage = _leg1CommodityRateSourcePage == null ? null : _leg1CommodityRateSourcePage;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2SpecifiedPrice")
		@RuneAttribute("leg2SpecifiedPrice")
		public HarmonizedData.HarmonizedDataBuilder setLeg2SpecifiedPrice(String _leg2SpecifiedPrice) {
			this.leg2SpecifiedPrice = _leg2SpecifiedPrice == null ? null : _leg2SpecifiedPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("commencementDateUnadjusted")
		@RuneAttribute("commencementDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setCommencementDateUnadjusted(Date _commencementDateUnadjusted) {
			this.commencementDateUnadjusted = _commencementDateUnadjusted == null ? null : _commencementDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("exerciseExpirationDateUnadjusted")
		@RuneAttribute("exerciseExpirationDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setExerciseExpirationDateUnadjusted(Date _exerciseExpirationDateUnadjusted) {
			this.exerciseExpirationDateUnadjusted = _exerciseExpirationDateUnadjusted == null ? null : _exerciseExpirationDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDateUnadjusted")
		@RuneAttribute("expirationDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setExpirationDateUnadjusted(Date _expirationDateUnadjusted) {
			this.expirationDateUnadjusted = _expirationDateUnadjusted == null ? null : _expirationDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantityFrequency")
		@RuneAttribute("leg2NotionalQuantityFrequency")
		public HarmonizedData.HarmonizedDataBuilder setLeg2NotionalQuantityFrequency(String _leg2NotionalQuantityFrequency) {
			this.leg2NotionalQuantityFrequency = _leg2NotionalQuantityFrequency == null ? null : _leg2NotionalQuantityFrequency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantity")
		@RuneAttribute("leg2NotionalQuantity")
		public HarmonizedData.HarmonizedDataBuilder setLeg2NotionalQuantity(BigDecimal _leg2NotionalQuantity) {
			this.leg2NotionalQuantity = _leg2NotionalQuantity == null ? null : _leg2NotionalQuantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2TotalNotionalQuantity")
		@RuneAttribute("leg2TotalNotionalQuantity")
		public HarmonizedData.HarmonizedDataBuilder setLeg2TotalNotionalQuantity(BigDecimal _leg2TotalNotionalQuantity) {
			this.leg2TotalNotionalQuantity = _leg2TotalNotionalQuantity == null ? null : _leg2TotalNotionalQuantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2SpreadAmount")
		@RuneAttribute("leg2SpreadAmount")
		public HarmonizedData.HarmonizedDataBuilder setLeg2SpreadAmount(BigDecimal _leg2SpreadAmount) {
			this.leg2SpreadAmount = _leg2SpreadAmount == null ? null : _leg2SpreadAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2SpreadCurrency")
		@RuneAttribute("leg2SpreadCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg2SpreadCurrency(String _leg2SpreadCurrency) {
			this.leg2SpreadCurrency = _leg2SpreadCurrency == null ? null : _leg2SpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("scheduledTerminationDateAdjusted")
		@RuneAttribute("scheduledTerminationDateAdjusted")
		public HarmonizedData.HarmonizedDataBuilder setScheduledTerminationDateAdjusted(Date _scheduledTerminationDateAdjusted) {
			this.scheduledTerminationDateAdjusted = _scheduledTerminationDateAdjusted == null ? null : _scheduledTerminationDateAdjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1PartyPayer")
		@RuneAttribute("leg1PartyPayer")
		public HarmonizedData.HarmonizedDataBuilder setLeg1PartyPayer(String _leg1PartyPayer) {
			this.leg1PartyPayer = _leg1PartyPayer == null ? null : _leg1PartyPayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2PartyPayer")
		@RuneAttribute("leg2PartyPayer")
		public HarmonizedData.HarmonizedDataBuilder setLeg2PartyPayer(String _leg2PartyPayer) {
			this.leg2PartyPayer = _leg2PartyPayer == null ? null : _leg2PartyPayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityInstrumentId")
		@RuneAttribute("leg1CommodityInstrumentId")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityInstrumentId(String _leg1CommodityInstrumentId) {
			this.leg1CommodityInstrumentId = _leg1CommodityInstrumentId == null ? null : _leg1CommodityInstrumentId;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerId")
		@RuneAttribute("leg1CommodityUnderlyerId")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityUnderlyerId(String _leg1CommodityUnderlyerId) {
			this.leg1CommodityUnderlyerId = _leg1CommodityUnderlyerId == null ? null : _leg1CommodityUnderlyerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnitOfMeasure")
		@RuneAttribute("leg1CommodityUnitOfMeasure")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityUnitOfMeasure(String _leg1CommodityUnitOfMeasure) {
			this.leg1CommodityUnitOfMeasure = _leg1CommodityUnitOfMeasure == null ? null : _leg1CommodityUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityExchangeId")
		@RuneAttribute("leg1CommodityExchangeId")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityExchangeId(String _leg1CommodityExchangeId) {
			this.leg1CommodityExchangeId = _leg1CommodityExchangeId == null ? null : _leg1CommodityExchangeId;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityRateSource")
		@RuneAttribute("leg2CommodityRateSource")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityRateSource(String _leg2CommodityRateSource) {
			this.leg2CommodityRateSource = _leg2CommodityRateSource == null ? null : _leg2CommodityRateSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDateUnadjusted")
		@RuneAttribute("leg1EffectiveDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setLeg1EffectiveDateUnadjusted(Date _leg1EffectiveDateUnadjusted) {
			this.leg1EffectiveDateUnadjusted = _leg1EffectiveDateUnadjusted == null ? null : _leg1EffectiveDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDateUnadjusted")
		@RuneAttribute("leg2EffectiveDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setLeg2EffectiveDateUnadjusted(Date _leg2EffectiveDateUnadjusted) {
			this.leg2EffectiveDateUnadjusted = _leg2EffectiveDateUnadjusted == null ? null : _leg2EffectiveDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("coProductType")
		@RuneAttribute("coProductType")
		public HarmonizedData.HarmonizedDataBuilder setCoProductType(String _coProductType) {
			this.coProductType = _coProductType == null ? null : _coProductType;
			return this;
		}
		
		@Override
		@RosettaAttribute("totalQuantityUnit")
		@RuneAttribute("totalQuantityUnit")
		public HarmonizedData.HarmonizedDataBuilder setTotalQuantityUnit(String _totalQuantityUnit) {
			this.totalQuantityUnit = _totalQuantityUnit == null ? null : _totalQuantityUnit;
			return this;
		}
		
		@Override
		@RosettaAttribute("totalQuantity")
		@RuneAttribute("totalQuantity")
		public HarmonizedData.HarmonizedDataBuilder setTotalQuantity(BigDecimal _totalQuantity) {
			this.totalQuantity = _totalQuantity == null ? null : _totalQuantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("fixedPrice")
		@RuneAttribute("fixedPrice")
		public HarmonizedData.HarmonizedDataBuilder setFixedPrice(BigDecimal _fixedPrice) {
			this.fixedPrice = _fixedPrice == null ? null : _fixedPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("fixedPriceCurrency")
		@RuneAttribute("fixedPriceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setFixedPriceCurrency(String _fixedPriceCurrency) {
			this.fixedPriceCurrency = _fixedPriceCurrency == null ? null : _fixedPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantityUnit")
		@RuneAttribute("leg1NotionalQuantityUnit")
		public HarmonizedData.HarmonizedDataBuilder setLeg1NotionalQuantityUnit(String _leg1NotionalQuantityUnit) {
			this.leg1NotionalQuantityUnit = _leg1NotionalQuantityUnit == null ? null : _leg1NotionalQuantityUnit;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantityFrequency")
		@RuneAttribute("leg1NotionalQuantityFrequency")
		public HarmonizedData.HarmonizedDataBuilder setLeg1NotionalQuantityFrequency(String _leg1NotionalQuantityFrequency) {
			this.leg1NotionalQuantityFrequency = _leg1NotionalQuantityFrequency == null ? null : _leg1NotionalQuantityFrequency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1NotionalQuantity")
		@RuneAttribute("leg1NotionalQuantity")
		public HarmonizedData.HarmonizedDataBuilder setLeg1NotionalQuantity(BigDecimal _leg1NotionalQuantity) {
			this.leg1NotionalQuantity = _leg1NotionalQuantity == null ? null : _leg1NotionalQuantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1TotalNotionalQuantity")
		@RuneAttribute("leg1TotalNotionalQuantity")
		public HarmonizedData.HarmonizedDataBuilder setLeg1TotalNotionalQuantity(BigDecimal _leg1TotalNotionalQuantity) {
			this.leg1TotalNotionalQuantity = _leg1TotalNotionalQuantity == null ? null : _leg1TotalNotionalQuantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityCurrency")
		@RuneAttribute("leg1CommodityCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityCurrency(String _leg1CommodityCurrency) {
			this.leg1CommodityCurrency = _leg1CommodityCurrency == null ? null : _leg1CommodityCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1SpecifiedPrice")
		@RuneAttribute("leg1SpecifiedPrice")
		public HarmonizedData.HarmonizedDataBuilder setLeg1SpecifiedPrice(String _leg1SpecifiedPrice) {
			this.leg1SpecifiedPrice = _leg1SpecifiedPrice == null ? null : _leg1SpecifiedPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1SpreadCurrency")
		@RuneAttribute("leg1SpreadCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg1SpreadCurrency(String _leg1SpreadCurrency) {
			this.leg1SpreadCurrency = _leg1SpreadCurrency == null ? null : _leg1SpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1SpreadAmount")
		@RuneAttribute("leg1SpreadAmount")
		public HarmonizedData.HarmonizedDataBuilder setLeg1SpreadAmount(BigDecimal _leg1SpreadAmount) {
			this.leg1SpreadAmount = _leg1SpreadAmount == null ? null : _leg1SpreadAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2NotionalQuantityUnit")
		@RuneAttribute("leg2NotionalQuantityUnit")
		public HarmonizedData.HarmonizedDataBuilder setLeg2NotionalQuantityUnit(String _leg2NotionalQuantityUnit) {
			this.leg2NotionalQuantityUnit = _leg2NotionalQuantityUnit == null ? null : _leg2NotionalQuantityUnit;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2PartyReceiver")
		@RuneAttribute("leg2PartyReceiver")
		public HarmonizedData.HarmonizedDataBuilder setLeg2PartyReceiver(String _leg2PartyReceiver) {
			this.leg2PartyReceiver = _leg2PartyReceiver == null ? null : _leg2PartyReceiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1PartyReceiver")
		@RuneAttribute("leg1PartyReceiver")
		public HarmonizedData.HarmonizedDataBuilder setLeg1PartyReceiver(String _leg1PartyReceiver) {
			this.leg1PartyReceiver = _leg1PartyReceiver == null ? null : _leg1PartyReceiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("coalSource")
		@RuneAttribute("coalSource")
		public HarmonizedData.HarmonizedDataBuilder setCoalSource(String _coalSource) {
			this.coalSource = _coalSource == null ? null : _coalSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2Quantity")
		@RuneAttribute("leg2Quantity")
		public HarmonizedData.HarmonizedDataBuilder setLeg2Quantity(BigDecimal _leg2Quantity) {
			this.leg2Quantity = _leg2Quantity == null ? null : _leg2Quantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("commodityBase")
		@RuneAttribute("commodityBase")
		public HarmonizedData.HarmonizedDataBuilder setCommodityBase(String _commodityBase) {
			this.commodityBase = _commodityBase == null ? null : _commodityBase;
			return this;
		}
		
		@Override
		@RosettaAttribute("commodityDetails")
		@RuneAttribute("commodityDetails")
		public HarmonizedData.HarmonizedDataBuilder setCommodityDetails(String _commodityDetails) {
			this.commodityDetails = _commodityDetails == null ? null : _commodityDetails;
			return this;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public HarmonizedData.HarmonizedDataBuilder setInterconnectionPoint(String _interconnectionPoint) {
			this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public HarmonizedData.HarmonizedDataBuilder setLoadType(String _loadType) {
			this.loadType = _loadType == null ? null : _loadType;
			return this;
		}
		
		@Override
		@RosettaAttribute("fixedPriceUnit")
		@RuneAttribute("fixedPriceUnit")
		public HarmonizedData.HarmonizedDataBuilder setFixedPriceUnit(String _fixedPriceUnit) {
			this.fixedPriceUnit = _fixedPriceUnit == null ? null : _fixedPriceUnit;
			return this;
		}
		
		@Override
		@RosettaAttribute("exercisePaymentDateUnadjusted")
		@RuneAttribute("exercisePaymentDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setExercisePaymentDateUnadjusted(Date _exercisePaymentDateUnadjusted) {
			this.exercisePaymentDateUnadjusted = _exercisePaymentDateUnadjusted == null ? null : _exercisePaymentDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1PaymentDatesUnadjusted")
		@RuneAttribute("leg1PaymentDatesUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setLeg1PaymentDatesUnadjusted(Date _leg1PaymentDatesUnadjusted) {
			this.leg1PaymentDatesUnadjusted = _leg1PaymentDatesUnadjusted == null ? null : _leg1PaymentDatesUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentDateUnadjusted")
		@RuneAttribute("leg2PaymentDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setLeg2PaymentDateUnadjusted(Date _leg2PaymentDateUnadjusted) {
			this.leg2PaymentDateUnadjusted = _leg2PaymentDateUnadjusted == null ? null : _leg2PaymentDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementDateUnadjusted")
		@RuneAttribute("settlementDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setSettlementDateUnadjusted(Date _settlementDateUnadjusted) {
			this.settlementDateUnadjusted = _settlementDateUnadjusted == null ? null : _settlementDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryLocation")
		@RuneAttribute("deliveryLocation")
		public HarmonizedData.HarmonizedDataBuilder setDeliveryLocation(String _deliveryLocation) {
			this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2QuantityUnit")
		@RuneAttribute("leg2QuantityUnit")
		public HarmonizedData.HarmonizedDataBuilder setLeg2QuantityUnit(String _leg2QuantityUnit) {
			this.leg2QuantityUnit = _leg2QuantityUnit == null ? null : _leg2QuantityUnit;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerDetails")
		@RuneAttribute("leg1CommodityUnderlyerDetails")
		public HarmonizedData.HarmonizedDataBuilder setLeg1CommodityUnderlyerDetails(String _leg1CommodityUnderlyerDetails) {
			this.leg1CommodityUnderlyerDetails = _leg1CommodityUnderlyerDetails == null ? null : _leg1CommodityUnderlyerDetails;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityRateSourcePage")
		@RuneAttribute("leg2CommodityRateSourcePage")
		public HarmonizedData.HarmonizedDataBuilder setLeg2CommodityRateSourcePage(String _leg2CommodityRateSourcePage) {
			this.leg2CommodityRateSourcePage = _leg2CommodityRateSourcePage == null ? null : _leg2CommodityRateSourcePage;
			return this;
		}
		
		@Override
		@RosettaAttribute("valueDate")
		@RuneAttribute("valueDate")
		public HarmonizedData.HarmonizedDataBuilder setValueDate(Date _valueDate) {
			this.valueDate = _valueDate == null ? null : _valueDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("gtrQuantityUnit")
		@RuneAttribute("gtrQuantityUnit")
		public HarmonizedData.HarmonizedDataBuilder setGtrQuantityUnit(String _gtrQuantityUnit) {
			this.gtrQuantityUnit = _gtrQuantityUnit == null ? null : _gtrQuantityUnit;
			return this;
		}
		
		@Override
		@RosettaAttribute("attachmentPoint")
		@RuneAttribute("attachmentPoint")
		public HarmonizedData.HarmonizedDataBuilder setAttachmentPoint(BigDecimal _attachmentPoint) {
			this.attachmentPoint = _attachmentPoint == null ? null : _attachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("exhaustionPoint")
		@RuneAttribute("exhaustionPoint")
		public HarmonizedData.HarmonizedDataBuilder setExhaustionPoint(BigDecimal _exhaustionPoint) {
			this.exhaustionPoint = _exhaustionPoint == null ? null : _exhaustionPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("mthToDefault")
		@RuneAttribute("mthToDefault")
		public HarmonizedData.HarmonizedDataBuilder setMthToDefault(BigDecimal _mthToDefault) {
			this.mthToDefault = _mthToDefault == null ? null : _mthToDefault;
			return this;
		}
		
		@Override
		@RosettaAttribute("nthToDefault")
		@RuneAttribute("nthToDefault")
		public HarmonizedData.HarmonizedDataBuilder setNthToDefault(BigDecimal _nthToDefault) {
			this.nthToDefault = _nthToDefault == null ? null : _nthToDefault;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public HarmonizedData.HarmonizedDataBuilder setSeniority(String _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public HarmonizedData.HarmonizedDataBuilder setSeries(BigDecimal _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("crversion")
		@RuneAttribute("crversion")
		public HarmonizedData.HarmonizedDataBuilder setCrversion(BigDecimal _crversion) {
			this.crversion = _crversion == null ? null : _crversion;
			return this;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public HarmonizedData.HarmonizedDataBuilder setTranche(String _tranche) {
			this.tranche = _tranche == null ? null : _tranche;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public HarmonizedData.HarmonizedDataBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceObligation")
		@RuneAttribute("referenceObligation")
		public HarmonizedData.HarmonizedDataBuilder setReferenceObligation(String _referenceObligation) {
			this.referenceObligation = _referenceObligation == null ? null : _referenceObligation;
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceObligationIdType")
		@RuneAttribute("referenceObligationIdType")
		public HarmonizedData.HarmonizedDataBuilder setReferenceObligationIdType(String _referenceObligationIdType) {
			this.referenceObligationIdType = _referenceObligationIdType == null ? null : _referenceObligationIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingFixedRatePayerBuyer")
		@RuneAttribute("underlyingFixedRatePayerBuyer")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingFixedRatePayerBuyer(String _underlyingFixedRatePayerBuyer) {
			this.underlyingFixedRatePayerBuyer = _underlyingFixedRatePayerBuyer == null ? null : _underlyingFixedRatePayerBuyer;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingFloatRatePayerSeller")
		@RuneAttribute("underlyingFloatRatePayerSeller")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingFloatRatePayerSeller(String _underlyingFloatRatePayerSeller) {
			this.underlyingFloatRatePayerSeller = _underlyingFloatRatePayerSeller == null ? null : _underlyingFloatRatePayerSeller;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetExchangeId")
		@RuneAttribute("underlyingAssetExchangeId")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetExchangeId(String _underlyingAssetExchangeId) {
			this.underlyingAssetExchangeId = _underlyingAssetExchangeId == null ? null : _underlyingAssetExchangeId;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetNumberOfUnits")
		@RuneAttribute("underlyingAssetNumberOfUnits")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetNumberOfUnits(BigDecimal _underlyingAssetNumberOfUnits) {
			this.underlyingAssetNumberOfUnits = _underlyingAssetNumberOfUnits == null ? null : _underlyingAssetNumberOfUnits;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationType")
		@RuneAttribute("optionalEarlyTerminationType")
		public HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationType(String _optionalEarlyTerminationType) {
			this.optionalEarlyTerminationType = _optionalEarlyTerminationType == null ? null : _optionalEarlyTerminationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationElectingPartyValue")
		@RuneAttribute("optionalEarlyTerminationElectingPartyValue")
		public HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationElectingPartyValue(String _optionalEarlyTerminationElectingPartyValue) {
			this.optionalEarlyTerminationElectingPartyValue = _optionalEarlyTerminationElectingPartyValue == null ? null : _optionalEarlyTerminationElectingPartyValue;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationIndicator")
		@RuneAttribute("optionalEarlyTerminationIndicator")
		public HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationIndicator(Boolean _optionalEarlyTerminationIndicator) {
			this.optionalEarlyTerminationIndicator = _optionalEarlyTerminationIndicator == null ? null : _optionalEarlyTerminationIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingAmountPayer")
		@RuneAttribute("underlyingAssetFloatingAmountPayer")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetFloatingAmountPayer(String _underlyingAssetFloatingAmountPayer) {
			this.underlyingAssetFloatingAmountPayer = _underlyingAssetFloatingAmountPayer == null ? null : _underlyingAssetFloatingAmountPayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingAmountReceiver")
		@RuneAttribute("underlyingAssetFloatingAmountReceiver")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetFloatingAmountReceiver(String _underlyingAssetFloatingAmountReceiver) {
			this.underlyingAssetFloatingAmountReceiver = _underlyingAssetFloatingAmountReceiver == null ? null : _underlyingAssetFloatingAmountReceiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("floatingRateOption")
		@RuneAttribute("floatingRateOption")
		public HarmonizedData.HarmonizedDataBuilder setFloatingRateOption(String _floatingRateOption) {
			this.floatingRateOption = _floatingRateOption == null ? null : _floatingRateOption;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetFloatingLegSpread")
		@RuneAttribute("underlyingAssetFloatingLegSpread")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetFloatingLegSpread(BigDecimal _underlyingAssetFloatingLegSpread) {
			this.underlyingAssetFloatingLegSpread = _underlyingAssetFloatingLegSpread == null ? null : _underlyingAssetFloatingLegSpread;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2DesignatedMaturityPeriod")
		@RuneAttribute("leg2DesignatedMaturityPeriod")
		public HarmonizedData.HarmonizedDataBuilder setLeg2DesignatedMaturityPeriod(String _leg2DesignatedMaturityPeriod) {
			this.leg2DesignatedMaturityPeriod = _leg2DesignatedMaturityPeriod == null ? null : _leg2DesignatedMaturityPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2DesignatedMaturityPeriodMultiplier")
		@RuneAttribute("leg2DesignatedMaturityPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setLeg2DesignatedMaturityPeriodMultiplier(BigDecimal _leg2DesignatedMaturityPeriodMultiplier) {
			this.leg2DesignatedMaturityPeriodMultiplier = _leg2DesignatedMaturityPeriodMultiplier == null ? null : _leg2DesignatedMaturityPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetEquityAmountPayer")
		@RuneAttribute("underlyingAssetEquityAmountPayer")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetEquityAmountPayer(String _underlyingAssetEquityAmountPayer) {
			this.underlyingAssetEquityAmountPayer = _underlyingAssetEquityAmountPayer == null ? null : _underlyingAssetEquityAmountPayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetEquityAmountReceiver")
		@RuneAttribute("underlyingAssetEquityAmountReceiver")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetEquityAmountReceiver(String _underlyingAssetEquityAmountReceiver) {
			this.underlyingAssetEquityAmountReceiver = _underlyingAssetEquityAmountReceiver == null ? null : _underlyingAssetEquityAmountReceiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetInitialPriceCurrency")
		@RuneAttribute("underlyingAssetInitialPriceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingAssetInitialPriceCurrency(String _underlyingAssetInitialPriceCurrency) {
			this.underlyingAssetInitialPriceCurrency = _underlyingAssetInitialPriceCurrency == null ? null : _underlyingAssetInitialPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1ValuationDates")
		@RuneAttribute("leg1ValuationDates")
		public HarmonizedData.HarmonizedDataBuilder setLeg1ValuationDates(Date _leg1ValuationDates) {
			this.leg1ValuationDates = _leg1ValuationDates == null ? null : _leg1ValuationDates;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1TypeOfReturn")
		@RuneAttribute("leg1TypeOfReturn")
		public HarmonizedData.HarmonizedDataBuilder setLeg1TypeOfReturn(String _leg1TypeOfReturn) {
			this.leg1TypeOfReturn = _leg1TypeOfReturn == null ? null : _leg1TypeOfReturn;
			return this;
		}
		
		@Override
		@RosettaAttribute("observationStartDate")
		@RuneAttribute("observationStartDate")
		public HarmonizedData.HarmonizedDataBuilder setObservationStartDate(Date _observationStartDate) {
			this.observationStartDate = _observationStartDate == null ? null : _observationStartDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("varianceAmount")
		@RuneAttribute("varianceAmount")
		public HarmonizedData.HarmonizedDataBuilder setVarianceAmount(BigDecimal _varianceAmount) {
			this.varianceAmount = _varianceAmount == null ? null : _varianceAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("volatilityStrikePrice")
		@RuneAttribute("volatilityStrikePrice")
		public HarmonizedData.HarmonizedDataBuilder setVolatilityStrikePrice(BigDecimal _volatilityStrikePrice) {
			this.volatilityStrikePrice = _volatilityStrikePrice == null ? null : _volatilityStrikePrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("varianceStrikePrice")
		@RuneAttribute("varianceStrikePrice")
		public HarmonizedData.HarmonizedDataBuilder setVarianceStrikePrice(BigDecimal _varianceStrikePrice) {
			this.varianceStrikePrice = _varianceStrikePrice == null ? null : _varianceStrikePrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("varianceCapFactor")
		@RuneAttribute("varianceCapFactor")
		public HarmonizedData.HarmonizedDataBuilder setVarianceCapFactor(BigDecimal _varianceCapFactor) {
			this.varianceCapFactor = _varianceCapFactor == null ? null : _varianceCapFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceCurrency")
		@RuneAttribute("referenceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setReferenceCurrency(String _referenceCurrency) {
			this.referenceCurrency = _referenceCurrency == null ? null : _referenceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("specialDividendsIndicator")
		@RuneAttribute("specialDividendsIndicator")
		public HarmonizedData.HarmonizedDataBuilder setSpecialDividendsIndicator(String _specialDividendsIndicator) {
			this.specialDividendsIndicator = _specialDividendsIndicator == null ? null : _specialDividendsIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("materialNoncashDividendIndicator")
		@RuneAttribute("materialNoncashDividendIndicator")
		public HarmonizedData.HarmonizedDataBuilder setMaterialNoncashDividendIndicator(String _materialNoncashDividendIndicator) {
			this.materialNoncashDividendIndicator = _materialNoncashDividendIndicator == null ? null : _materialNoncashDividendIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("numberOfSharesUnits")
		@RuneAttribute("numberOfSharesUnits")
		public HarmonizedData.HarmonizedDataBuilder setNumberOfSharesUnits(BigDecimal _numberOfSharesUnits) {
			this.numberOfSharesUnits = _numberOfSharesUnits == null ? null : _numberOfSharesUnits;
			return this;
		}
		
		@Override
		@RosettaAttribute("dividendAmountPayer")
		@RuneAttribute("dividendAmountPayer")
		public HarmonizedData.HarmonizedDataBuilder setDividendAmountPayer(String _dividendAmountPayer) {
			this.dividendAmountPayer = _dividendAmountPayer == null ? null : _dividendAmountPayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("dividendAmountReceiver")
		@RuneAttribute("dividendAmountReceiver")
		public HarmonizedData.HarmonizedDataBuilder setDividendAmountReceiver(String _dividendAmountReceiver) {
			this.dividendAmountReceiver = _dividendAmountReceiver == null ? null : _dividendAmountReceiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("fixedAmountPayer")
		@RuneAttribute("fixedAmountPayer")
		public HarmonizedData.HarmonizedDataBuilder setFixedAmountPayer(String _fixedAmountPayer) {
			this.fixedAmountPayer = _fixedAmountPayer == null ? null : _fixedAmountPayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("fixedAmountReceiver")
		@RuneAttribute("fixedAmountReceiver")
		public HarmonizedData.HarmonizedDataBuilder setFixedAmountReceiver(String _fixedAmountReceiver) {
			this.fixedAmountReceiver = _fixedAmountReceiver == null ? null : _fixedAmountReceiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("knockInEvent")
		@RuneAttribute("knockInEvent")
		public HarmonizedData.HarmonizedDataBuilder setKnockInEvent(String _knockInEvent) {
			this.knockInEvent = _knockInEvent == null ? null : _knockInEvent;
			return this;
		}
		
		@Override
		@RosettaAttribute("knockOutEvent")
		@RuneAttribute("knockOutEvent")
		public HarmonizedData.HarmonizedDataBuilder setKnockOutEvent(String _knockOutEvent) {
			this.knockOutEvent = _knockOutEvent == null ? null : _knockOutEvent;
			return this;
		}
		
		@Override
		@RosettaAttribute("knockInPrice")
		@RuneAttribute("knockInPrice")
		public HarmonizedData.HarmonizedDataBuilder setKnockInPrice(BigDecimal _knockInPrice) {
			this.knockInPrice = _knockInPrice == null ? null : _knockInPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("knockOutPrice")
		@RuneAttribute("knockOutPrice")
		public HarmonizedData.HarmonizedDataBuilder setKnockOutPrice(BigDecimal _knockOutPrice) {
			this.knockOutPrice = _knockOutPrice == null ? null : _knockOutPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrierType")
		@RuneAttribute("barrierType")
		public HarmonizedData.HarmonizedDataBuilder setBarrierType(String _barrierType) {
			this.barrierType = _barrierType == null ? null : _barrierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("earliestExecutionTime")
		@RuneAttribute("earliestExecutionTime")
		public HarmonizedData.HarmonizedDataBuilder setEarliestExecutionTime(LocalTime _earliestExecutionTime) {
			this.earliestExecutionTime = _earliestExecutionTime == null ? null : _earliestExecutionTime;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public HarmonizedData.HarmonizedDataBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisCurrency1")
		@RuneAttribute("exchangeRateBasisCurrency1")
		public HarmonizedData.HarmonizedDataBuilder setExchangeRateBasisCurrency1(String _exchangeRateBasisCurrency1) {
			this.exchangeRateBasisCurrency1 = _exchangeRateBasisCurrency1 == null ? null : _exchangeRateBasisCurrency1;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisCurrency2")
		@RuneAttribute("exchangeRateBasisCurrency2")
		public HarmonizedData.HarmonizedDataBuilder setExchangeRateBasisCurrency2(String _exchangeRateBasisCurrency2) {
			this.exchangeRateBasisCurrency2 = _exchangeRateBasisCurrency2 == null ? null : _exchangeRateBasisCurrency2;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionPeriodStartDate")
		@RuneAttribute("executionPeriodStartDate")
		public HarmonizedData.HarmonizedDataBuilder setExecutionPeriodStartDate(Date _executionPeriodStartDate) {
			this.executionPeriodStartDate = _executionPeriodStartDate == null ? null : _executionPeriodStartDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("payoutStyle")
		@RuneAttribute("payoutStyle")
		public HarmonizedData.HarmonizedDataBuilder setPayoutStyle(String _payoutStyle) {
			this.payoutStyle = _payoutStyle == null ? null : _payoutStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("rateQuoteBasis1")
		@RuneAttribute("rateQuoteBasis1")
		public HarmonizedData.HarmonizedDataBuilder setRateQuoteBasis1(String _rateQuoteBasis1) {
			this.rateQuoteBasis1 = _rateQuoteBasis1 == null ? null : _rateQuoteBasis1;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementFixingDate")
		@RuneAttribute("settlementFixingDate")
		public HarmonizedData.HarmonizedDataBuilder setSettlementFixingDate(Date _settlementFixingDate) {
			this.settlementFixingDate = _settlementFixingDate == null ? null : _settlementFixingDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("swapLinkId")
		@RuneAttribute("swapLinkId")
		public HarmonizedData.HarmonizedDataBuilder setSwapLinkId(String _swapLinkId) {
			this.swapLinkId = _swapLinkId == null ? null : _swapLinkId;
			return this;
		}
		
		@Override
		@RosettaAttribute("triggerCondition")
		@RuneAttribute("triggerCondition")
		public HarmonizedData.HarmonizedDataBuilder setTriggerCondition(String _triggerCondition) {
			this.triggerCondition = _triggerCondition == null ? null : _triggerCondition;
			return this;
		}
		
		@Override
		@RosettaAttribute("triggerCondition2")
		@RuneAttribute("triggerCondition2")
		public HarmonizedData.HarmonizedDataBuilder setTriggerCondition2(String _triggerCondition2) {
			this.triggerCondition2 = _triggerCondition2 == null ? null : _triggerCondition2;
			return this;
		}
		
		@Override
		@RosettaAttribute("triggerRate")
		@RuneAttribute("triggerRate")
		public HarmonizedData.HarmonizedDataBuilder setTriggerRate(BigDecimal _triggerRate) {
			this.triggerRate = _triggerRate == null ? null : _triggerRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("triggerRate2")
		@RuneAttribute("triggerRate2")
		public HarmonizedData.HarmonizedDataBuilder setTriggerRate2(BigDecimal _triggerRate2) {
			this.triggerRate2 = _triggerRate2 == null ? null : _triggerRate2;
			return this;
		}
		
		@Override
		@RosettaAttribute("rateQuoteBasis2")
		@RuneAttribute("rateQuoteBasis2")
		public HarmonizedData.HarmonizedDataBuilder setRateQuoteBasis2(String _rateQuoteBasis2) {
			this.rateQuoteBasis2 = _rateQuoteBasis2 == null ? null : _rateQuoteBasis2;
			return this;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public HarmonizedData.HarmonizedDataBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
			this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrierType2")
		@RuneAttribute("barrierType2")
		public HarmonizedData.HarmonizedDataBuilder setBarrierType2(String _barrierType2) {
			this.barrierType2 = _barrierType2 == null ? null : _barrierType2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionBuyer")
		@RuneAttribute("cancelationOptionBuyer")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionBuyer(String _cancelationOptionBuyer) {
			this.cancelationOptionBuyer = _cancelationOptionBuyer == null ? null : _cancelationOptionBuyer;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionCommencementDate")
		@RuneAttribute("cancelationOptionCommencementDate")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionCommencementDate(Date _cancelationOptionCommencementDate) {
			this.cancelationOptionCommencementDate = _cancelationOptionCommencementDate == null ? null : _cancelationOptionCommencementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionExerciseStyleType")
		@RuneAttribute("cancelationOptionExerciseStyleType")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionExerciseStyleType(String _cancelationOptionExerciseStyleType) {
			this.cancelationOptionExerciseStyleType = _cancelationOptionExerciseStyleType == null ? null : _cancelationOptionExerciseStyleType;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionExpirationDate")
		@RuneAttribute("cancelationOptionExpirationDate")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionExpirationDate(Date _cancelationOptionExpirationDate) {
			this.cancelationOptionExpirationDate = _cancelationOptionExpirationDate == null ? null : _cancelationOptionExpirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionInitialFeeCurrency")
		@RuneAttribute("cancelationOptionInitialFeeCurrency")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionInitialFeeCurrency(String _cancelationOptionInitialFeeCurrency) {
			this.cancelationOptionInitialFeeCurrency = _cancelationOptionInitialFeeCurrency == null ? null : _cancelationOptionInitialFeeCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionInitialFeePayer")
		@RuneAttribute("cancelationOptionInitialFeePayer")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionInitialFeePayer(String _cancelationOptionInitialFeePayer) {
			this.cancelationOptionInitialFeePayer = _cancelationOptionInitialFeePayer == null ? null : _cancelationOptionInitialFeePayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionPremiumAmount")
		@RuneAttribute("cancelationOptionPremiumAmount")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionPremiumAmount(BigDecimal _cancelationOptionPremiumAmount) {
			this.cancelationOptionPremiumAmount = _cancelationOptionPremiumAmount == null ? null : _cancelationOptionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("cancelationOptionSeller")
		@RuneAttribute("cancelationOptionSeller")
		public HarmonizedData.HarmonizedDataBuilder setCancelationOptionSeller(String _cancelationOptionSeller) {
			this.cancelationOptionSeller = _cancelationOptionSeller == null ? null : _cancelationOptionSeller;
			return this;
		}
		
		@Override
		@RosettaAttribute("capRateInitial")
		@RuneAttribute("capRateInitial")
		public HarmonizedData.HarmonizedDataBuilder setCapRateInitial(BigDecimal _capRateInitial) {
			this.capRateInitial = _capRateInitial == null ? null : _capRateInitial;
			return this;
		}
		
		@Override
		@RosettaAttribute("couponType")
		@RuneAttribute("couponType")
		public HarmonizedData.HarmonizedDataBuilder setCouponType(String _couponType) {
			this.couponType = _couponType == null ? null : _couponType;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalPrincipalExchangeIndicatorAtTermination")
		@RuneAttribute("finalPrincipalExchangeIndicatorAtTermination")
		public HarmonizedData.HarmonizedDataBuilder setFinalPrincipalExchangeIndicatorAtTermination(Boolean _finalPrincipalExchangeIndicatorAtTermination) {
			this.finalPrincipalExchangeIndicatorAtTermination = _finalPrincipalExchangeIndicatorAtTermination == null ? null : _finalPrincipalExchangeIndicatorAtTermination;
			return this;
		}
		
		@Override
		@RosettaAttribute("floorRateInitial")
		@RuneAttribute("floorRateInitial")
		public HarmonizedData.HarmonizedDataBuilder setFloorRateInitial(BigDecimal _floorRateInitial) {
			this.floorRateInitial = _floorRateInitial == null ? null : _floorRateInitial;
			return this;
		}
		
		@Override
		@RosettaAttribute("fraDiscountingType")
		@RuneAttribute("fraDiscountingType")
		public HarmonizedData.HarmonizedDataBuilder setFraDiscountingType(String _fraDiscountingType) {
			this.fraDiscountingType = _fraDiscountingType == null ? null : _fraDiscountingType;
			return this;
		}
		
		@Override
		@RosettaAttribute("inflationIndexInitialLevel")
		@RuneAttribute("inflationIndexInitialLevel")
		public HarmonizedData.HarmonizedDataBuilder setInflationIndexInitialLevel(BigDecimal _inflationIndexInitialLevel) {
			this.inflationIndexInitialLevel = _inflationIndexInitialLevel == null ? null : _inflationIndexInitialLevel;
			return this;
		}
		
		@Override
		@RosettaAttribute("inflationIndexMainPublication")
		@RuneAttribute("inflationIndexMainPublication")
		public HarmonizedData.HarmonizedDataBuilder setInflationIndexMainPublication(String _inflationIndexMainPublication) {
			this.inflationIndexMainPublication = _inflationIndexMainPublication == null ? null : _inflationIndexMainPublication;
			return this;
		}
		
		@Override
		@RosettaAttribute("inflationInterpolationMethod")
		@RuneAttribute("inflationInterpolationMethod")
		public HarmonizedData.HarmonizedDataBuilder setInflationInterpolationMethod(String _inflationInterpolationMethod) {
			this.inflationInterpolationMethod = _inflationInterpolationMethod == null ? null : _inflationInterpolationMethod;
			return this;
		}
		
		@Override
		@RosettaAttribute("inflationLagDayType")
		@RuneAttribute("inflationLagDayType")
		public HarmonizedData.HarmonizedDataBuilder setInflationLagDayType(String _inflationLagDayType) {
			this.inflationLagDayType = _inflationLagDayType == null ? null : _inflationLagDayType;
			return this;
		}
		
		@Override
		@RosettaAttribute("inflationLagPeriod")
		@RuneAttribute("inflationLagPeriod")
		public HarmonizedData.HarmonizedDataBuilder setInflationLagPeriod(String _inflationLagPeriod) {
			this.inflationLagPeriod = _inflationLagPeriod == null ? null : _inflationLagPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("inflationRateSourceName")
		@RuneAttribute("inflationRateSourceName")
		public HarmonizedData.HarmonizedDataBuilder setInflationRateSourceName(String _inflationRateSourceName) {
			this.inflationRateSourceName = _inflationRateSourceName == null ? null : _inflationRateSourceName;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialPrincipalExchangeIndicator")
		@RuneAttribute("initialPrincipalExchangeIndicator")
		public HarmonizedData.HarmonizedDataBuilder setInitialPrincipalExchangeIndicator(Boolean _initialPrincipalExchangeIndicator) {
			this.initialPrincipalExchangeIndicator = _initialPrincipalExchangeIndicator == null ? null : _initialPrincipalExchangeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("intermediatePrincipalExchangeIndicator")
		@RuneAttribute("intermediatePrincipalExchangeIndicator")
		public HarmonizedData.HarmonizedDataBuilder setIntermediatePrincipalExchangeIndicator(Boolean _intermediatePrincipalExchangeIndicator) {
			this.intermediatePrincipalExchangeIndicator = _intermediatePrincipalExchangeIndicator == null ? null : _intermediatePrincipalExchangeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateIndex")
		@RuneAttribute("leg1FloatingRateIndex")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateIndex(String _leg1FloatingRateIndex) {
			this.leg1FloatingRateIndex = _leg1FloatingRateIndex == null ? null : _leg1FloatingRateIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateInitialSpread")
		@RuneAttribute("leg1FloatingRateInitialSpread")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateInitialSpread(BigDecimal _leg1FloatingRateInitialSpread) {
			this.leg1FloatingRateInitialSpread = _leg1FloatingRateInitialSpread == null ? null : _leg1FloatingRateInitialSpread;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateMultiplierInitialValue")
		@RuneAttribute("leg1FloatingRateMultiplierInitialValue")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateMultiplierInitialValue(BigDecimal _leg1FloatingRateMultiplierInitialValue) {
			this.leg1FloatingRateMultiplierInitialValue = _leg1FloatingRateMultiplierInitialValue == null ? null : _leg1FloatingRateMultiplierInitialValue;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateTenorPeriod")
		@RuneAttribute("leg1FloatingRateTenorPeriod")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateTenorPeriod(String _leg1FloatingRateTenorPeriod) {
			this.leg1FloatingRateTenorPeriod = _leg1FloatingRateTenorPeriod == null ? null : _leg1FloatingRateTenorPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateTenorPeriodMultiplier")
		@RuneAttribute("leg1FloatingRateTenorPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FloatingRateTenorPeriodMultiplier(BigDecimal _leg1FloatingRateTenorPeriodMultiplier) {
			this.leg1FloatingRateTenorPeriodMultiplier = _leg1FloatingRateTenorPeriodMultiplier == null ? null : _leg1FloatingRateTenorPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1KnownAmount")
		@RuneAttribute("leg1KnownAmount")
		public HarmonizedData.HarmonizedDataBuilder setLeg1KnownAmount(BigDecimal _leg1KnownAmount) {
			this.leg1KnownAmount = _leg1KnownAmount == null ? null : _leg1KnownAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1KnownAmountCurrency")
		@RuneAttribute("leg1KnownAmountCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg1KnownAmountCurrency(String _leg1KnownAmountCurrency) {
			this.leg1KnownAmountCurrency = _leg1KnownAmountCurrency == null ? null : _leg1KnownAmountCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1ReferenceCurrency")
		@RuneAttribute("leg1ReferenceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg1ReferenceCurrency(String _leg1ReferenceCurrency) {
			this.leg1ReferenceCurrency = _leg1ReferenceCurrency == null ? null : _leg1ReferenceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateIndex")
		@RuneAttribute("leg2FloatingRateIndex")
		public HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateIndex(String _leg2FloatingRateIndex) {
			this.leg2FloatingRateIndex = _leg2FloatingRateIndex == null ? null : _leg2FloatingRateIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateInitialSpread")
		@RuneAttribute("leg2FloatingRateInitialSpread")
		public HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateInitialSpread(BigDecimal _leg2FloatingRateInitialSpread) {
			this.leg2FloatingRateInitialSpread = _leg2FloatingRateInitialSpread == null ? null : _leg2FloatingRateInitialSpread;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateMultiplierInitialValue")
		@RuneAttribute("leg2FloatingRateMultiplierInitialValue")
		public HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateMultiplierInitialValue(BigDecimal _leg2FloatingRateMultiplierInitialValue) {
			this.leg2FloatingRateMultiplierInitialValue = _leg2FloatingRateMultiplierInitialValue == null ? null : _leg2FloatingRateMultiplierInitialValue;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateTenorPeriod")
		@RuneAttribute("leg2FloatingRateTenorPeriod")
		public HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateTenorPeriod(String _leg2FloatingRateTenorPeriod) {
			this.leg2FloatingRateTenorPeriod = _leg2FloatingRateTenorPeriod == null ? null : _leg2FloatingRateTenorPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateTenorPeriodMultiplier")
		@RuneAttribute("leg2FloatingRateTenorPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setLeg2FloatingRateTenorPeriodMultiplier(BigDecimal _leg2FloatingRateTenorPeriodMultiplier) {
			this.leg2FloatingRateTenorPeriodMultiplier = _leg2FloatingRateTenorPeriodMultiplier == null ? null : _leg2FloatingRateTenorPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2KnownAmount")
		@RuneAttribute("leg2KnownAmount")
		public HarmonizedData.HarmonizedDataBuilder setLeg2KnownAmount(BigDecimal _leg2KnownAmount) {
			this.leg2KnownAmount = _leg2KnownAmount == null ? null : _leg2KnownAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2KnownAmountCurrency")
		@RuneAttribute("leg2KnownAmountCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg2KnownAmountCurrency(String _leg2KnownAmountCurrency) {
			this.leg2KnownAmountCurrency = _leg2KnownAmountCurrency == null ? null : _leg2KnownAmountCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2ReferenceCurrency")
		@RuneAttribute("leg2ReferenceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg2ReferenceCurrency(String _leg2ReferenceCurrency) {
			this.leg2ReferenceCurrency = _leg2ReferenceCurrency == null ? null : _leg2ReferenceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDate")
		@RuneAttribute("mandatoryEarlyTerminationDate")
		public HarmonizedData.HarmonizedDataBuilder setMandatoryEarlyTerminationDate(Date _mandatoryEarlyTerminationDate) {
			this.mandatoryEarlyTerminationDate = _mandatoryEarlyTerminationDate == null ? null : _mandatoryEarlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDateTenorPeriod")
		@RuneAttribute("mandatoryEarlyTerminationDateTenorPeriod")
		public HarmonizedData.HarmonizedDataBuilder setMandatoryEarlyTerminationDateTenorPeriod(String _mandatoryEarlyTerminationDateTenorPeriod) {
			this.mandatoryEarlyTerminationDateTenorPeriod = _mandatoryEarlyTerminationDateTenorPeriod == null ? null : _mandatoryEarlyTerminationDateTenorPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("mandatoryEarlyTerminationDateTenorPeriodMultiplier")
		@RuneAttribute("mandatoryEarlyTerminationDateTenorPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setMandatoryEarlyTerminationDateTenorPeriodMultiplier(String _mandatoryEarlyTerminationDateTenorPeriodMultiplier) {
			this.mandatoryEarlyTerminationDateTenorPeriodMultiplier = _mandatoryEarlyTerminationDateTenorPeriodMultiplier == null ? null : _mandatoryEarlyTerminationDateTenorPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalUnits")
		@RuneAttribute("notionalUnits")
		public HarmonizedData.HarmonizedDataBuilder setNotionalUnits(BigDecimal _notionalUnits) {
			this.notionalUnits = _notionalUnits == null ? null : _notionalUnits;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationCommencementDate")
		@RuneAttribute("optionalEarlyTerminationCommencementDate")
		public HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationCommencementDate(Date _optionalEarlyTerminationCommencementDate) {
			this.optionalEarlyTerminationCommencementDate = _optionalEarlyTerminationCommencementDate == null ? null : _optionalEarlyTerminationCommencementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationExerciseStyle")
		@RuneAttribute("optionalEarlyTerminationExerciseStyle")
		public HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationExerciseStyle(String _optionalEarlyTerminationExerciseStyle) {
			this.optionalEarlyTerminationExerciseStyle = _optionalEarlyTerminationExerciseStyle == null ? null : _optionalEarlyTerminationExerciseStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationExpirationDate")
		@RuneAttribute("optionalEarlyTerminationExpirationDate")
		public HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationExpirationDate(Date _optionalEarlyTerminationExpirationDate) {
			this.optionalEarlyTerminationExpirationDate = _optionalEarlyTerminationExpirationDate == null ? null : _optionalEarlyTerminationExpirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("premiumReceiver")
		@RuneAttribute("premiumReceiver")
		public HarmonizedData.HarmonizedDataBuilder setPremiumReceiver(String _premiumReceiver) {
			this.premiumReceiver = _premiumReceiver == null ? null : _premiumReceiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingCouponRate")
		@RuneAttribute("underlyingCouponRate")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingCouponRate(BigDecimal _underlyingCouponRate) {
			this.underlyingCouponRate = _underlyingCouponRate == null ? null : _underlyingCouponRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingMaturityDate")
		@RuneAttribute("underlyingMaturityDate")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingMaturityDate(Date _underlyingMaturityDate) {
			this.underlyingMaturityDate = _underlyingMaturityDate == null ? null : _underlyingMaturityDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingProductId")
		@RuneAttribute("underlyingProductId")
		public HarmonizedData.HarmonizedDataBuilder setUnderlyingProductId(String _underlyingProductId) {
			this.underlyingProductId = _underlyingProductId == null ? null : _underlyingProductId;
			return this;
		}
		
		@Override
		@RosettaAttribute("inflationLagPeriodMultiplier")
		@RuneAttribute("inflationLagPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setInflationLagPeriodMultiplier(String _inflationLagPeriodMultiplier) {
			this.inflationLagPeriodMultiplier = _inflationLagPeriodMultiplier == null ? null : _inflationLagPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FixedRateNotation")
		@RuneAttribute("leg1FixedRateNotation")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FixedRateNotation(String _leg1FixedRateNotation) {
			this.leg1FixedRateNotation = _leg1FixedRateNotation == null ? null : _leg1FixedRateNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FixedRateNotation")
		@RuneAttribute("leg2FixedRateNotation")
		public HarmonizedData.HarmonizedDataBuilder setLeg2FixedRateNotation(String _leg2FixedRateNotation) {
			this.leg2FixedRateNotation = _leg2FixedRateNotation == null ? null : _leg2FixedRateNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("swaptionStraddleIndicator")
		@RuneAttribute("swaptionStraddleIndicator")
		public HarmonizedData.HarmonizedDataBuilder setSwaptionStraddleIndicator(String _swaptionStraddleIndicator) {
			this.swaptionStraddleIndicator = _swaptionStraddleIndicator == null ? null : _swaptionStraddleIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("singlePartyEarlyTerminationBuyer")
		@RuneAttribute("singlePartyEarlyTerminationBuyer")
		public HarmonizedData.HarmonizedDataBuilder setSinglePartyEarlyTerminationBuyer(String _singlePartyEarlyTerminationBuyer) {
			this.singlePartyEarlyTerminationBuyer = _singlePartyEarlyTerminationBuyer == null ? null : _singlePartyEarlyTerminationBuyer;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDate")
		@RuneAttribute("leg1EffectiveDate")
		public HarmonizedData.HarmonizedDataBuilder setLeg1EffectiveDate(Date _leg1EffectiveDate) {
			this.leg1EffectiveDate = _leg1EffectiveDate == null ? null : _leg1EffectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("action")
		@RuneAttribute("action")
		public HarmonizedData.HarmonizedDataBuilder setAction(String _action) {
			this.action = _action == null ? null : _action;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingStatus")
		@RuneAttribute("clearingStatus")
		public HarmonizedData.HarmonizedDataBuilder setClearingStatus(String _clearingStatus) {
			this.clearingStatus = _clearingStatus == null ? null : _clearingStatus;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate1")
		@RuneAttribute("effectiveDate1")
		public HarmonizedData.HarmonizedDataBuilder setEffectiveDate1(Date _effectiveDate1) {
			this.effectiveDate1 = _effectiveDate1 == null ? null : _effectiveDate1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionVenueType")
		@RuneAttribute("executionVenueType")
		public HarmonizedData.HarmonizedDataBuilder setExecutionVenueType(String _executionVenueType) {
			this.executionVenueType = _executionVenueType == null ? null : _executionVenueType;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonStandardTradeIndicator")
		@RuneAttribute("nonStandardTradeIndicator")
		public HarmonizedData.HarmonizedDataBuilder setNonStandardTradeIndicator(Boolean _nonStandardTradeIndicator) {
			this.nonStandardTradeIndicator = _nonStandardTradeIndicator == null ? null : _nonStandardTradeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalAmount1")
		@RuneAttribute("notionalAmount1")
		public HarmonizedData.HarmonizedDataBuilder setNotionalAmount1(BigDecimal _notionalAmount1) {
			this.notionalAmount1 = _notionalAmount1 == null ? null : _notionalAmount1;
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency1")
		@RuneAttribute("notionalCurrency1")
		public HarmonizedData.HarmonizedDataBuilder setNotionalCurrency1(String _notionalCurrency1) {
			this.notionalCurrency1 = _notionalCurrency1 == null ? null : _notionalCurrency1;
			return this;
		}
		
		@Override
		@RosettaAttribute("price1Price")
		@RuneAttribute("price1Price")
		public HarmonizedData.HarmonizedDataBuilder setPrice1Price(BigDecimal _price1Price) {
			this.price1Price = _price1Price == null ? null : _price1Price;
			return this;
		}
		
		@Override
		@RosettaAttribute("price1Type")
		@RuneAttribute("price1Type")
		public HarmonizedData.HarmonizedDataBuilder setPrice1Type(String _price1Type) {
			this.price1Type = _price1Type == null ? null : _price1Type;
			return this;
		}
		
		@Override
		@RosettaAttribute("price1Units")
		@RuneAttribute("price1Units")
		public HarmonizedData.HarmonizedDataBuilder setPrice1Units(String _price1Units) {
			this.price1Units = _price1Units == null ? null : _price1Units;
			return this;
		}
		
		@Override
		@RosettaAttribute("scheduledTerminationDate1")
		@RuneAttribute("scheduledTerminationDate1")
		public HarmonizedData.HarmonizedDataBuilder setScheduledTerminationDate1(Date _scheduledTerminationDate1) {
			this.scheduledTerminationDate1 = _scheduledTerminationDate1 == null ? null : _scheduledTerminationDate1;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeDate")
		@RuneAttribute("tradeDate")
		public HarmonizedData.HarmonizedDataBuilder setTradeDate(Date _tradeDate) {
			this.tradeDate = _tradeDate == null ? null : _tradeDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralizationType")
		@RuneAttribute("tradeParty1CollateralizationType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralizationType(String _tradeParty1CollateralizationType) {
			this.tradeParty1CollateralizationType = _tradeParty1CollateralizationType == null ? null : _tradeParty1CollateralizationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1EventId")
		@RuneAttribute("tradeParty1EventId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1EventId(String _tradeParty1EventId) {
			this.tradeParty1EventId = _tradeParty1EventId == null ? null : _tradeParty1EventId;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralizationType")
		@RuneAttribute("tradeParty2CollateralizationType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralizationType(String _tradeParty2CollateralizationType) {
			this.tradeParty2CollateralizationType = _tradeParty2CollateralizationType == null ? null : _tradeParty2CollateralizationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2EventId")
		@RuneAttribute("tradeParty2EventId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2EventId(String _tradeParty2EventId) {
			this.tradeParty2EventId = _tradeParty2EventId == null ? null : _tradeParty2EventId;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionOnSwap")
		@RuneAttribute("embeddedOptionOnSwap")
		public HarmonizedData.HarmonizedDataBuilder setEmbeddedOptionOnSwap(String _embeddedOptionOnSwap) {
			this.embeddedOptionOnSwap = _embeddedOptionOnSwap == null ? null : _embeddedOptionOnSwap;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public HarmonizedData.HarmonizedDataBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalAmount2")
		@RuneAttribute("notionalAmount2")
		public HarmonizedData.HarmonizedDataBuilder setNotionalAmount2(BigDecimal _notionalAmount2) {
			this.notionalAmount2 = _notionalAmount2 == null ? null : _notionalAmount2;
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		public HarmonizedData.HarmonizedDataBuilder setNotionalCurrency2(String _notionalCurrency2) {
			this.notionalCurrency2 = _notionalCurrency2 == null ? null : _notionalCurrency2;
			return this;
		}
		
		@Override
		@RosettaAttribute("premiumAmount")
		@RuneAttribute("premiumAmount")
		public HarmonizedData.HarmonizedDataBuilder setPremiumAmount(BigDecimal _premiumAmount) {
			this.premiumAmount = _premiumAmount == null ? null : _premiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("premiumCurrency")
		@RuneAttribute("premiumCurrency")
		public HarmonizedData.HarmonizedDataBuilder setPremiumCurrency(String _premiumCurrency) {
			this.premiumCurrency = _premiumCurrency == null ? null : _premiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public HarmonizedData.HarmonizedDataBuilder setVersion(String _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@Override
		@RosettaAttribute("comment1")
		@RuneAttribute("comment1")
		public HarmonizedData.HarmonizedDataBuilder setComment1(String _comment1) {
			this.comment1 = _comment1 == null ? null : _comment1;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public HarmonizedData.HarmonizedDataBuilder setOptionStyle(String _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public HarmonizedData.HarmonizedDataBuilder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public HarmonizedData.HarmonizedDataBuilder setSettlementCurrency1(String _settlementCurrency1) {
			this.settlementCurrency1 = _settlementCurrency1 == null ? null : _settlementCurrency1;
			return this;
		}
		
		@Override
		@RosettaAttribute("commencementDate")
		@RuneAttribute("commencementDate")
		public HarmonizedData.HarmonizedDataBuilder setCommencementDate(Date _commencementDate) {
			this.commencementDate = _commencementDate == null ? null : _commencementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("dayCountFraction1")
		@RuneAttribute("dayCountFraction1")
		public HarmonizedData.HarmonizedDataBuilder setDayCountFraction1(String _dayCountFraction1) {
			this.dayCountFraction1 = _dayCountFraction1 == null ? null : _dayCountFraction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2DayCountFraction")
		@RuneAttribute("leg2DayCountFraction")
		public HarmonizedData.HarmonizedDataBuilder setLeg2DayCountFraction(String _leg2DayCountFraction) {
			this.leg2DayCountFraction = _leg2DayCountFraction == null ? null : _leg2DayCountFraction;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDate")
		@RuneAttribute("leg2EffectiveDate")
		public HarmonizedData.HarmonizedDataBuilder setLeg2EffectiveDate(Date _leg2EffectiveDate) {
			this.leg2EffectiveDate = _leg2EffectiveDate == null ? null : _leg2EffectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2ResetFrequencyPeriod")
		@RuneAttribute("leg2ResetFrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setLeg2ResetFrequencyPeriod(String _leg2ResetFrequencyPeriod) {
			this.leg2ResetFrequencyPeriod = _leg2ResetFrequencyPeriod == null ? null : _leg2ResetFrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2ResetFrequencyPeriodMultiplier")
		@RuneAttribute("leg2ResetFrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setLeg2ResetFrequencyPeriodMultiplier(BigDecimal _leg2ResetFrequencyPeriodMultiplier) {
			this.leg2ResetFrequencyPeriodMultiplier = _leg2ResetFrequencyPeriodMultiplier == null ? null : _leg2ResetFrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementCurrency")
		@RuneAttribute("leg2SettlementCurrency")
		public HarmonizedData.HarmonizedDataBuilder setLeg2SettlementCurrency(String _leg2SettlementCurrency) {
			this.leg2SettlementCurrency = _leg2SettlementCurrency == null ? null : _leg2SettlementCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2ScheduledTerminationDate")
		@RuneAttribute("leg2ScheduledTerminationDate")
		public HarmonizedData.HarmonizedDataBuilder setLeg2ScheduledTerminationDate(Date _leg2ScheduledTerminationDate) {
			this.leg2ScheduledTerminationDate = _leg2ScheduledTerminationDate == null ? null : _leg2ScheduledTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("numberOfOptions")
		@RuneAttribute("numberOfOptions")
		public HarmonizedData.HarmonizedDataBuilder setNumberOfOptions(BigDecimal _numberOfOptions) {
			this.numberOfOptions = _numberOfOptions == null ? null : _numberOfOptions;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionEntitlement")
		@RuneAttribute("optionEntitlement")
		public HarmonizedData.HarmonizedDataBuilder setOptionEntitlement(BigDecimal _optionEntitlement) {
			this.optionEntitlement = _optionEntitlement == null ? null : _optionEntitlement;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalExecutionTimestamp")
		@RuneAttribute("originalExecutionTimestamp")
		public HarmonizedData.HarmonizedDataBuilder setOriginalExecutionTimestamp(ZonedDateTime _originalExecutionTimestamp) {
			this.originalExecutionTimestamp = _originalExecutionTimestamp == null ? null : _originalExecutionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1Date")
		@RuneAttribute("payment1Date")
		public HarmonizedData.HarmonizedDataBuilder setPayment1Date(Date _payment1Date) {
			this.payment1Date = _payment1Date == null ? null : _payment1Date;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1FrequencyPeriod")
		@RuneAttribute("payment1FrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment1FrequencyPeriod(String _payment1FrequencyPeriod) {
			this.payment1FrequencyPeriod = _payment1FrequencyPeriod == null ? null : _payment1FrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1FrequencyPeriodMultiplier")
		@RuneAttribute("payment1FrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment1FrequencyPeriodMultiplier(BigDecimal _payment1FrequencyPeriodMultiplier) {
			this.payment1FrequencyPeriodMultiplier = _payment1FrequencyPeriodMultiplier == null ? null : _payment1FrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2Date")
		@RuneAttribute("payment2Date")
		public HarmonizedData.HarmonizedDataBuilder setPayment2Date(Date _payment2Date) {
			this.payment2Date = _payment2Date == null ? null : _payment2Date;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2FrequencyPeriod")
		@RuneAttribute("payment2FrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment2FrequencyPeriod(String _payment2FrequencyPeriod) {
			this.payment2FrequencyPeriod = _payment2FrequencyPeriod == null ? null : _payment2FrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2FrequencyPeriodMultiplier")
		@RuneAttribute("payment2FrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment2FrequencyPeriodMultiplier(BigDecimal _payment2FrequencyPeriodMultiplier) {
			this.payment2FrequencyPeriodMultiplier = _payment2FrequencyPeriodMultiplier == null ? null : _payment2FrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("resetFrequencyPeriod1")
		@RuneAttribute("resetFrequencyPeriod1")
		public HarmonizedData.HarmonizedDataBuilder setResetFrequencyPeriod1(String _resetFrequencyPeriod1) {
			this.resetFrequencyPeriod1 = _resetFrequencyPeriod1 == null ? null : _resetFrequencyPeriod1;
			return this;
		}
		
		@Override
		@RosettaAttribute("resetFrequencyPeriodMultiplier1")
		@RuneAttribute("resetFrequencyPeriodMultiplier1")
		public HarmonizedData.HarmonizedDataBuilder setResetFrequencyPeriodMultiplier1(BigDecimal _resetFrequencyPeriodMultiplier1) {
			this.resetFrequencyPeriodMultiplier1 = _resetFrequencyPeriodMultiplier1 == null ? null : _resetFrequencyPeriodMultiplier1;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementDate")
		@RuneAttribute("settlementDate")
		public HarmonizedData.HarmonizedDataBuilder setSettlementDate(Date _settlementDate) {
			this.settlementDate = _settlementDate == null ? null : _settlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public HarmonizedData.HarmonizedDataBuilder setStrikePrice(BigDecimal _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceUnits")
		@RuneAttribute("strikePriceUnits")
		public HarmonizedData.HarmonizedDataBuilder setStrikePriceUnits(String _strikePriceUnits) {
			this.strikePriceUnits = _strikePriceUnits == null ? null : _strikePriceUnits;
			return this;
		}
		
		@Override
		@RosettaAttribute("asOfDateTime")
		@RuneAttribute("asOfDateTime")
		public HarmonizedData.HarmonizedDataBuilder setAsOfDateTime(ZonedDateTime _asOfDateTime) {
			this.asOfDateTime = _asOfDateTime == null ? null : _asOfDateTime;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingVenueId")
		@RuneAttribute("clearingVenueId")
		public HarmonizedData.HarmonizedDataBuilder setClearingVenueId(String _clearingVenueId) {
			this.clearingVenueId = _clearingVenueId == null ? null : _clearingVenueId;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingVenueIdType")
		@RuneAttribute("clearingVenueIdType")
		public HarmonizedData.HarmonizedDataBuilder setClearingVenueIdType(String _clearingVenueIdType) {
			this.clearingVenueIdType = _clearingVenueIdType == null ? null : _clearingVenueIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("compressedTradeIndicator")
		@RuneAttribute("compressedTradeIndicator")
		public HarmonizedData.HarmonizedDataBuilder setCompressedTradeIndicator(String _compressedTradeIndicator) {
			this.compressedTradeIndicator = _compressedTradeIndicator == null ? null : _compressedTradeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmationMethod")
		@RuneAttribute("confirmationMethod")
		public HarmonizedData.HarmonizedDataBuilder setConfirmationMethod(String _confirmationMethod) {
			this.confirmationMethod = _confirmationMethod == null ? null : _confirmationMethod;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmationPlatformId")
		@RuneAttribute("confirmationPlatformId")
		public HarmonizedData.HarmonizedDataBuilder setConfirmationPlatformId(String _confirmationPlatformId) {
			this.confirmationPlatformId = _confirmationPlatformId == null ? null : _confirmationPlatformId;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmationPlatformTradeId")
		@RuneAttribute("confirmationPlatformTradeId")
		public HarmonizedData.HarmonizedDataBuilder setConfirmationPlatformTradeId(String _confirmationPlatformTradeId) {
			this.confirmationPlatformTradeId = _confirmationPlatformTradeId == null ? null : _confirmationPlatformTradeId;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionVenueId")
		@RuneAttribute("executionVenueId")
		public HarmonizedData.HarmonizedDataBuilder setExecutionVenueId(String _executionVenueId) {
			this.executionVenueId = _executionVenueId == null ? null : _executionVenueId;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionVenueIdType")
		@RuneAttribute("executionVenueIdType")
		public HarmonizedData.HarmonizedDataBuilder setExecutionVenueIdType(String _executionVenueIdType) {
			this.executionVenueIdType = _executionVenueIdType == null ? null : _executionVenueIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("postTradeEffectiveDate")
		@RuneAttribute("postTradeEffectiveDate")
		public HarmonizedData.HarmonizedDataBuilder setPostTradeEffectiveDate(Date _postTradeEffectiveDate) {
			this.postTradeEffectiveDate = _postTradeEffectiveDate == null ? null : _postTradeEffectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUsiId")
		@RuneAttribute("priorUsiId")
		public HarmonizedData.HarmonizedDataBuilder setPriorUsiId(String _priorUsiId) {
			this.priorUsiId = _priorUsiId == null ? null : _priorUsiId;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUsiIdPrefix")
		@RuneAttribute("priorUsiIdPrefix")
		public HarmonizedData.HarmonizedDataBuilder setPriorUsiIdPrefix(String _priorUsiIdPrefix) {
			this.priorUsiIdPrefix = _priorUsiIdPrefix == null ? null : _priorUsiIdPrefix;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUtiId")
		@RuneAttribute("priorUtiId")
		public HarmonizedData.HarmonizedDataBuilder setPriorUtiId(String _priorUtiId) {
			this.priorUtiId = _priorUtiId == null ? null : _priorUtiId;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUtiIdPrefix")
		@RuneAttribute("priorUtiIdPrefix")
		public HarmonizedData.HarmonizedDataBuilder setPriorUtiIdPrefix(String _priorUtiIdPrefix) {
			this.priorUtiIdPrefix = _priorUtiIdPrefix == null ? null : _priorUtiIdPrefix;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BranchLocation")
		@RuneAttribute("tradeParty1BranchLocation")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1BranchLocation(String _tradeParty1BranchLocation) {
			this.tradeParty1BranchLocation = _tradeParty1BranchLocation == null ? null : _tradeParty1BranchLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerId")
		@RuneAttribute("tradeParty1ClearingBrokerId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1ClearingBrokerId(String _tradeParty1ClearingBrokerId) {
			this.tradeParty1ClearingBrokerId = _tradeParty1ClearingBrokerId == null ? null : _tradeParty1ClearingBrokerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerIdType")
		@RuneAttribute("tradeParty1ClearingBrokerIdType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1ClearingBrokerIdType(String _tradeParty1ClearingBrokerIdType) {
			this.tradeParty1ClearingBrokerIdType = _tradeParty1ClearingBrokerIdType == null ? null : _tradeParty1ClearingBrokerIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1DeskLocation")
		@RuneAttribute("tradeParty1DeskLocation")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1DeskLocation(String _tradeParty1DeskLocation) {
			this.tradeParty1DeskLocation = _tradeParty1DeskLocation == null ? null : _tradeParty1DeskLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Domicile")
		@RuneAttribute("tradeParty1Domicile")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1Domicile(String _tradeParty1Domicile) {
			this.tradeParty1Domicile = _tradeParty1Domicile == null ? null : _tradeParty1Domicile;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1IndustrialSectorType")
		@RuneAttribute("tradeParty1IndustrialSectorType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1IndustrialSectorType(String _tradeParty1IndustrialSectorType) {
			this.tradeParty1IndustrialSectorType = _tradeParty1IndustrialSectorType == null ? null : _tradeParty1IndustrialSectorType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BranchLocation")
		@RuneAttribute("tradeParty2BranchLocation")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2BranchLocation(String _tradeParty2BranchLocation) {
			this.tradeParty2BranchLocation = _tradeParty2BranchLocation == null ? null : _tradeParty2BranchLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2DeskLocation")
		@RuneAttribute("tradeParty2DeskLocation")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2DeskLocation(String _tradeParty2DeskLocation) {
			this.tradeParty2DeskLocation = _tradeParty2DeskLocation == null ? null : _tradeParty2DeskLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Domicile")
		@RuneAttribute("tradeParty2Domicile")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2Domicile(String _tradeParty2Domicile) {
			this.tradeParty2Domicile = _tradeParty2Domicile == null ? null : _tradeParty2Domicile;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2IndustrialSectorType")
		@RuneAttribute("tradeParty2IndustrialSectorType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2IndustrialSectorType(String _tradeParty2IndustrialSectorType) {
			this.tradeParty2IndustrialSectorType = _tradeParty2IndustrialSectorType == null ? null : _tradeParty2IndustrialSectorType;
			return this;
		}
		
		@Override
		@RosettaAttribute("sellerPayer2")
		@RuneAttribute("sellerPayer2")
		public HarmonizedData.HarmonizedDataBuilder setSellerPayer2(String _sellerPayer2) {
			this.sellerPayer2 = _sellerPayer2 == null ? null : _sellerPayer2;
			return this;
		}
		
		@Override
		@RosettaAttribute("buyerPayer1")
		@RuneAttribute("buyerPayer1")
		public HarmonizedData.HarmonizedDataBuilder setBuyerPayer1(String _buyerPayer1) {
			this.buyerPayer1 = _buyerPayer1 == null ? null : _buyerPayer1;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1HkCounterpartyOrigin")
		@RuneAttribute("tradeParty1HkCounterpartyOrigin")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1HkCounterpartyOrigin(String _tradeParty1HkCounterpartyOrigin) {
			this.tradeParty1HkCounterpartyOrigin = _tradeParty1HkCounterpartyOrigin == null ? null : _tradeParty1HkCounterpartyOrigin;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementDate")
		@RuneAttribute("leg2SettlementDate")
		public HarmonizedData.HarmonizedDataBuilder setLeg2SettlementDate(Date _leg2SettlementDate) {
			this.leg2SettlementDate = _leg2SettlementDate == null ? null : _leg2SettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FixedRateInitial")
		@RuneAttribute("leg1FixedRateInitial")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FixedRateInitial(BigDecimal _leg1FixedRateInitial) {
			this.leg1FixedRateInitial = _leg1FixedRateInitial == null ? null : _leg1FixedRateInitial;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FixedRateInitial")
		@RuneAttribute("leg2FixedRateInitial")
		public HarmonizedData.HarmonizedDataBuilder setLeg2FixedRateInitial(BigDecimal _leg2FixedRateInitial) {
			this.leg2FixedRateInitial = _leg2FixedRateInitial == null ? null : _leg2FixedRateInitial;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1Amount")
		@RuneAttribute("payment1Amount")
		public HarmonizedData.HarmonizedDataBuilder setPayment1Amount(BigDecimal _payment1Amount) {
			this.payment1Amount = _payment1Amount == null ? null : _payment1Amount;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1Currency")
		@RuneAttribute("payment1Currency")
		public HarmonizedData.HarmonizedDataBuilder setPayment1Currency(String _payment1Currency) {
			this.payment1Currency = _payment1Currency == null ? null : _payment1Currency;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1Payer")
		@RuneAttribute("payment1Payer")
		public HarmonizedData.HarmonizedDataBuilder setPayment1Payer(String _payment1Payer) {
			this.payment1Payer = _payment1Payer == null ? null : _payment1Payer;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1Receiver")
		@RuneAttribute("payment1Receiver")
		public HarmonizedData.HarmonizedDataBuilder setPayment1Receiver(String _payment1Receiver) {
			this.payment1Receiver = _payment1Receiver == null ? null : _payment1Receiver;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2Payer")
		@RuneAttribute("payment2Payer")
		public HarmonizedData.HarmonizedDataBuilder setPayment2Payer(String _payment2Payer) {
			this.payment2Payer = _payment2Payer == null ? null : _payment2Payer;
			return this;
		}
		
		@Override
		@RosettaAttribute("postTradeTransactionDate")
		@RuneAttribute("postTradeTransactionDate")
		public HarmonizedData.HarmonizedDataBuilder setPostTradeTransactionDate(Date _postTradeTransactionDate) {
			this.postTradeTransactionDate = _postTradeTransactionDate == null ? null : _postTradeTransactionDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("secondaryAssetClass")
		@RuneAttribute("secondaryAssetClass")
		public HarmonizedData.HarmonizedDataBuilder setSecondaryAssetClass(String _secondaryAssetClass) {
			this.secondaryAssetClass = _secondaryAssetClass == null ? null : _secondaryAssetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public HarmonizedData.HarmonizedDataBuilder setSettlementType(String _settlementType) {
			this.settlementType = _settlementType == null ? null : _settlementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Name")
		@RuneAttribute("tradeParty1Name")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1Name(String _tradeParty1Name) {
			this.tradeParty1Name = _tradeParty1Name == null ? null : _tradeParty1Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Name")
		@RuneAttribute("tradeParty2Name")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2Name(String _tradeParty2Name) {
			this.tradeParty2Name = _tradeParty2Name == null ? null : _tradeParty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("ccpValuationAmount")
		@RuneAttribute("ccpValuationAmount")
		public HarmonizedData.HarmonizedDataBuilder setCcpValuationAmount(BigDecimal _ccpValuationAmount) {
			this.ccpValuationAmount = _ccpValuationAmount == null ? null : _ccpValuationAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("ccpValuationCurrency")
		@RuneAttribute("ccpValuationCurrency")
		public HarmonizedData.HarmonizedDataBuilder setCcpValuationCurrency(String _ccpValuationCurrency) {
			this.ccpValuationCurrency = _ccpValuationCurrency == null ? null : _ccpValuationCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("ccpValuationDatetime")
		@RuneAttribute("ccpValuationDatetime")
		public HarmonizedData.HarmonizedDataBuilder setCcpValuationDatetime(ZonedDateTime _ccpValuationDatetime) {
			this.ccpValuationDatetime = _ccpValuationDatetime == null ? null : _ccpValuationDatetime;
			return this;
		}
		
		@Override
		@RosettaAttribute("ccpValuationType")
		@RuneAttribute("ccpValuationType")
		public HarmonizedData.HarmonizedDataBuilder setCcpValuationType(String _ccpValuationType) {
			this.ccpValuationType = _ccpValuationType == null ? null : _ccpValuationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationAmount")
		@RuneAttribute("tradeParty1ValuationAmount")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationAmount(BigDecimal _tradeParty1ValuationAmount) {
			this.tradeParty1ValuationAmount = _tradeParty1ValuationAmount == null ? null : _tradeParty1ValuationAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationCurrency")
		@RuneAttribute("tradeParty1ValuationCurrency")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationCurrency(String _tradeParty1ValuationCurrency) {
			this.tradeParty1ValuationCurrency = _tradeParty1ValuationCurrency == null ? null : _tradeParty1ValuationCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationDatetime")
		@RuneAttribute("tradeParty1ValuationDatetime")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationDatetime(ZonedDateTime _tradeParty1ValuationDatetime) {
			this.tradeParty1ValuationDatetime = _tradeParty1ValuationDatetime == null ? null : _tradeParty1ValuationDatetime;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ValuationType")
		@RuneAttribute("tradeParty1ValuationType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1ValuationType(String _tradeParty1ValuationType) {
			this.tradeParty1ValuationType = _tradeParty1ValuationType == null ? null : _tradeParty1ValuationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationAmount")
		@RuneAttribute("tradeParty2ValuationAmount")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationAmount(BigDecimal _tradeParty2ValuationAmount) {
			this.tradeParty2ValuationAmount = _tradeParty2ValuationAmount == null ? null : _tradeParty2ValuationAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationCurrency")
		@RuneAttribute("tradeParty2ValuationCurrency")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationCurrency(String _tradeParty2ValuationCurrency) {
			this.tradeParty2ValuationCurrency = _tradeParty2ValuationCurrency == null ? null : _tradeParty2ValuationCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationDatetime")
		@RuneAttribute("tradeParty2ValuationDatetime")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationDatetime(ZonedDateTime _tradeParty2ValuationDatetime) {
			this.tradeParty2ValuationDatetime = _tradeParty2ValuationDatetime == null ? null : _tradeParty2ValuationDatetime;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ValuationType")
		@RuneAttribute("tradeParty2ValuationType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2ValuationType(String _tradeParty2ValuationType) {
			this.tradeParty2ValuationType = _tradeParty2ValuationType == null ? null : _tradeParty2ValuationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionType")
		@RuneAttribute("executionType")
		public HarmonizedData.HarmonizedDataBuilder setExecutionType(String _executionType) {
			this.executionType = _executionType == null ? null : _executionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2Amount")
		@RuneAttribute("payment2Amount")
		public HarmonizedData.HarmonizedDataBuilder setPayment2Amount(BigDecimal _payment2Amount) {
			this.payment2Amount = _payment2Amount == null ? null : _payment2Amount;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2HkCounterpartyOrigin")
		@RuneAttribute("tradeParty2HkCounterpartyOrigin")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2HkCounterpartyOrigin(String _tradeParty2HkCounterpartyOrigin) {
			this.tradeParty2HkCounterpartyOrigin = _tradeParty2HkCounterpartyOrigin == null ? null : _tradeParty2HkCounterpartyOrigin;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CountryOfTheOtherCounterparty")
		@RuneAttribute("tradeParty1CountryOfTheOtherCounterparty")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CountryOfTheOtherCounterparty(String _tradeParty1CountryOfTheOtherCounterparty) {
			this.tradeParty1CountryOfTheOtherCounterparty = _tradeParty1CountryOfTheOtherCounterparty == null ? null : _tradeParty1CountryOfTheOtherCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CountryOfTheOtherCounterparty")
		@RuneAttribute("tradeParty2CountryOfTheOtherCounterparty")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CountryOfTheOtherCounterparty(String _tradeParty2CountryOfTheOtherCounterparty) {
			this.tradeParty2CountryOfTheOtherCounterparty = _tradeParty2CountryOfTheOtherCounterparty == null ? null : _tradeParty2CountryOfTheOtherCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerId")
		@RuneAttribute("tradeParty1BrokerId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1BrokerId(String _tradeParty1BrokerId) {
			this.tradeParty1BrokerId = _tradeParty1BrokerId == null ? null : _tradeParty1BrokerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BrokerId")
		@RuneAttribute("tradeParty2BrokerId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2BrokerId(String _tradeParty2BrokerId) {
			this.tradeParty2BrokerId = _tradeParty2BrokerId == null ? null : _tradeParty2BrokerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BeneficiaryIdType")
		@RuneAttribute("tradeParty1BeneficiaryIdType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1BeneficiaryIdType(String _tradeParty1BeneficiaryIdType) {
			this.tradeParty1BeneficiaryIdType = _tradeParty1BeneficiaryIdType == null ? null : _tradeParty1BeneficiaryIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BeneficiaryId")
		@RuneAttribute("tradeParty1BeneficiaryId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1BeneficiaryId(String _tradeParty1BeneficiaryId) {
			this.tradeParty1BeneficiaryId = _tradeParty1BeneficiaryId == null ? null : _tradeParty1BeneficiaryId;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BeneficiaryIdType")
		@RuneAttribute("tradeParty2BeneficiaryIdType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2BeneficiaryIdType(String _tradeParty2BeneficiaryIdType) {
			this.tradeParty2BeneficiaryIdType = _tradeParty2BeneficiaryIdType == null ? null : _tradeParty2BeneficiaryIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BeneficiaryId")
		@RuneAttribute("tradeParty2BeneficiaryId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2BeneficiaryId(String _tradeParty2BeneficiaryId) {
			this.tradeParty2BeneficiaryId = _tradeParty2BeneficiaryId == null ? null : _tradeParty2BeneficiaryId;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CounterpartySide")
		@RuneAttribute("tradeParty1CounterpartySide")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CounterpartySide(String _tradeParty1CounterpartySide) {
			this.tradeParty1CounterpartySide = _tradeParty1CounterpartySide == null ? null : _tradeParty1CounterpartySide;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CounterpartySide")
		@RuneAttribute("tradeParty2CounterpartySide")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CounterpartySide(String _tradeParty2CounterpartySide) {
			this.tradeParty2CounterpartySide = _tradeParty2CounterpartySide == null ? null : _tradeParty2CounterpartySide;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralPortfolioCode")
		@RuneAttribute("tradeParty1CollateralPortfolioCode")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralPortfolioCode(String _tradeParty1CollateralPortfolioCode) {
			this.tradeParty1CollateralPortfolioCode = _tradeParty1CollateralPortfolioCode == null ? null : _tradeParty1CollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralPortfolioCode")
		@RuneAttribute("tradeParty2CollateralPortfolioCode")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralPortfolioCode(String _tradeParty2CollateralPortfolioCode) {
			this.tradeParty2CollateralPortfolioCode = _tradeParty2CollateralPortfolioCode == null ? null : _tradeParty2CollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public HarmonizedData.HarmonizedDataBuilder setContractType(String _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("euUnderlyingAssetIdType")
		@RuneAttribute("euUnderlyingAssetIdType")
		public HarmonizedData.HarmonizedDataBuilder setEuUnderlyingAssetIdType(String _euUnderlyingAssetIdType) {
			this.euUnderlyingAssetIdType = _euUnderlyingAssetIdType == null ? null : _euUnderlyingAssetIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("productClassification")
		@RuneAttribute("productClassification")
		public HarmonizedData.HarmonizedDataBuilder setProductClassification(String _productClassification) {
			this.productClassification = _productClassification == null ? null : _productClassification;
			return this;
		}
		
		@Override
		@RosettaAttribute("complexTradeComponentId")
		@RuneAttribute("complexTradeComponentId")
		public HarmonizedData.HarmonizedDataBuilder setComplexTradeComponentId(String _complexTradeComponentId) {
			this.complexTradeComponentId = _complexTradeComponentId == null ? null : _complexTradeComponentId;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceMultiplier")
		@RuneAttribute("priceMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPriceMultiplier(BigDecimal _priceMultiplier) {
			this.priceMultiplier = _priceMultiplier == null ? null : _priceMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantity")
		@RuneAttribute("quantity")
		public HarmonizedData.HarmonizedDataBuilder setQuantity(BigDecimal _quantity) {
			this.quantity = _quantity == null ? null : _quantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public HarmonizedData.HarmonizedDataBuilder setMasterAgreementType(String _masterAgreementType) {
			this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public HarmonizedData.HarmonizedDataBuilder setMasterAgreementVersion(String _masterAgreementVersion) {
			this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmationDatetime")
		@RuneAttribute("confirmationDatetime")
		public HarmonizedData.HarmonizedDataBuilder setConfirmationDatetime(ZonedDateTime _confirmationDatetime) {
			this.confirmationDatetime = _confirmationDatetime == null ? null : _confirmationDatetime;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingDatetime")
		@RuneAttribute("clearingDatetime")
		public HarmonizedData.HarmonizedDataBuilder setClearingDatetime(ZonedDateTime _clearingDatetime) {
			this.clearingDatetime = _clearingDatetime == null ? null : _clearingDatetime;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public HarmonizedData.HarmonizedDataBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public HarmonizedData.HarmonizedDataBuilder setLevel(String _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@Override
		@RosettaAttribute("productClassificationType")
		@RuneAttribute("productClassificationType")
		public HarmonizedData.HarmonizedDataBuilder setProductClassificationType(String _productClassificationType) {
			this.productClassificationType = _productClassificationType == null ? null : _productClassificationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("productIdentificationType")
		@RuneAttribute("productIdentificationType")
		public HarmonizedData.HarmonizedDataBuilder setProductIdentificationType(String _productIdentificationType) {
			this.productIdentificationType = _productIdentificationType == null ? null : _productIdentificationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("productIdentification")
		@RuneAttribute("productIdentification")
		public HarmonizedData.HarmonizedDataBuilder setProductIdentification(String _productIdentification) {
			this.productIdentification = _productIdentification == null ? null : _productIdentification;
			return this;
		}
		
		@Override
		@RosettaAttribute("euUnderlyingAssetId")
		@RuneAttribute("euUnderlyingAssetId")
		public HarmonizedData.HarmonizedDataBuilder setEuUnderlyingAssetId(String _euUnderlyingAssetId) {
			this.euUnderlyingAssetId = _euUnderlyingAssetId == null ? null : _euUnderlyingAssetId;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public HarmonizedData.HarmonizedDataBuilder setReportTrackingNumber(String _reportTrackingNumber) {
			this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerIdType")
		@RuneAttribute("tradeParty1BrokerIdType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1BrokerIdType(String _tradeParty1BrokerIdType) {
			this.tradeParty1BrokerIdType = _tradeParty1BrokerIdType == null ? null : _tradeParty1BrokerIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2BrokerIdType")
		@RuneAttribute("tradeParty2BrokerIdType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2BrokerIdType(String _tradeParty2BrokerIdType) {
			this.tradeParty2BrokerIdType = _tradeParty2BrokerIdType == null ? null : _tradeParty2BrokerIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingBrokerIdType")
		@RuneAttribute("tradeParty2ClearingBrokerIdType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2ClearingBrokerIdType(String _tradeParty2ClearingBrokerIdType) {
			this.tradeParty2ClearingBrokerIdType = _tradeParty2ClearingBrokerIdType == null ? null : _tradeParty2ClearingBrokerIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingBrokerId")
		@RuneAttribute("tradeParty2ClearingBrokerId")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2ClearingBrokerId(String _tradeParty2ClearingBrokerId) {
			this.tradeParty2ClearingBrokerId = _tradeParty2ClearingBrokerId == null ? null : _tradeParty2ClearingBrokerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingThreshold")
		@RuneAttribute("tradeParty1ClearingThreshold")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1ClearingThreshold(Boolean _tradeParty1ClearingThreshold) {
			this.tradeParty1ClearingThreshold = _tradeParty1ClearingThreshold == null ? null : _tradeParty1ClearingThreshold;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ClearingThreshold")
		@RuneAttribute("tradeParty2ClearingThreshold")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2ClearingThreshold(Boolean _tradeParty2ClearingThreshold) {
			this.tradeParty2ClearingThreshold = _tradeParty2ClearingThreshold == null ? null : _tradeParty2ClearingThreshold;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CorporateSectorType")
		@RuneAttribute("tradeParty1CorporateSectorType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CorporateSectorType(String _tradeParty1CorporateSectorType) {
			this.tradeParty1CorporateSectorType = _tradeParty1CorporateSectorType == null ? null : _tradeParty1CorporateSectorType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CorporateSectorType")
		@RuneAttribute("tradeParty2CorporateSectorType")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CorporateSectorType(String _tradeParty2CorporateSectorType) {
			this.tradeParty2CorporateSectorType = _tradeParty2CorporateSectorType == null ? null : _tradeParty2CorporateSectorType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		@RuneAttribute("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(String _tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator) {
			this.tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator = _tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator == null ? null : _tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		@RuneAttribute("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(String _tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator) {
			this.tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator = _tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator == null ? null : _tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("intragroupIndicator")
		@RuneAttribute("intragroupIndicator")
		public HarmonizedData.HarmonizedDataBuilder setIntragroupIndicator(Boolean _intragroupIndicator) {
			this.intragroupIndicator = _intragroupIndicator == null ? null : _intragroupIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TradingCapacity1")
		@RuneAttribute("tradeParty1TradingCapacity1")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1TradingCapacity1(String _tradeParty1TradingCapacity1) {
			this.tradeParty1TradingCapacity1 = _tradeParty1TradingCapacity1 == null ? null : _tradeParty1TradingCapacity1;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2TradingCapacity1")
		@RuneAttribute("tradeParty2TradingCapacity1")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2TradingCapacity1(String _tradeParty2TradingCapacity1) {
			this.tradeParty2TradingCapacity1 = _tradeParty2TradingCapacity1 == null ? null : _tradeParty2TradingCapacity1;
			return this;
		}
		
		@Override
		@RosettaAttribute("currencyOfPrice")
		@RuneAttribute("currencyOfPrice")
		public HarmonizedData.HarmonizedDataBuilder setCurrencyOfPrice(String _currencyOfPrice) {
			this.currencyOfPrice = _currencyOfPrice == null ? null : _currencyOfPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralPortfolio")
		@RuneAttribute("tradeParty1CollateralPortfolio")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralPortfolio(String _tradeParty1CollateralPortfolio) {
			this.tradeParty1CollateralPortfolio = _tradeParty1CollateralPortfolio == null ? null : _tradeParty1CollateralPortfolio;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralPortfolio")
		@RuneAttribute("tradeParty2CollateralPortfolio")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralPortfolio(String _tradeParty2CollateralPortfolio) {
			this.tradeParty2CollateralPortfolio = _tradeParty2CollateralPortfolio == null ? null : _tradeParty2CollateralPortfolio;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionVenueMicCode")
		@RuneAttribute("executionVenueMicCode")
		public HarmonizedData.HarmonizedDataBuilder setExecutionVenueMicCode(String _executionVenueMicCode) {
			this.executionVenueMicCode = _executionVenueMicCode == null ? null : _executionVenueMicCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2Currency")
		@RuneAttribute("payment2Currency")
		public HarmonizedData.HarmonizedDataBuilder setPayment2Currency(String _payment2Currency) {
			this.payment2Currency = _payment2Currency == null ? null : _payment2Currency;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDateTimeBusinessCenter")
		@RuneAttribute("expirationDateTimeBusinessCenter")
		public HarmonizedData.HarmonizedDataBuilder setExpirationDateTimeBusinessCenter(String _expirationDateTimeBusinessCenter) {
			this.expirationDateTimeBusinessCenter = _expirationDateTimeBusinessCenter == null ? null : _expirationDateTimeBusinessCenter;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationTime")
		@RuneAttribute("expirationTime")
		public HarmonizedData.HarmonizedDataBuilder setExpirationTime(LocalTime _expirationTime) {
			this.expirationTime = _expirationTime == null ? null : _expirationTime;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationTimeType")
		@RuneAttribute("expirationTimeType")
		public HarmonizedData.HarmonizedDataBuilder setExpirationTimeType(String _expirationTimeType) {
			this.expirationTimeType = _expirationTimeType == null ? null : _expirationTimeType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TraderLocation")
		@RuneAttribute("tradeParty1TraderLocation")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1TraderLocation(String _tradeParty1TraderLocation) {
			this.tradeParty1TraderLocation = _tradeParty1TraderLocation == null ? null : _tradeParty1TraderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2TraderLocation")
		@RuneAttribute("tradeParty2TraderLocation")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2TraderLocation(String _tradeParty2TraderLocation) {
			this.tradeParty2TraderLocation = _tradeParty2TraderLocation == null ? null : _tradeParty2TraderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment3ResetFrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment3ResetFrequencyPeriodMultiplier(BigDecimal _payment3ResetFrequencyPeriodMultiplier) {
			this.payment3ResetFrequencyPeriodMultiplier = _payment3ResetFrequencyPeriodMultiplier == null ? null : _payment3ResetFrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3ResetFrequencyPeriod")
		@RuneAttribute("payment3ResetFrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment3ResetFrequencyPeriod(String _payment3ResetFrequencyPeriod) {
			this.payment3ResetFrequencyPeriod = _payment3ResetFrequencyPeriod == null ? null : _payment3ResetFrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment4ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment4ResetFrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment4ResetFrequencyPeriodMultiplier(BigDecimal _payment4ResetFrequencyPeriodMultiplier) {
			this.payment4ResetFrequencyPeriodMultiplier = _payment4ResetFrequencyPeriodMultiplier == null ? null : _payment4ResetFrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment4ResetFrequencyPeriod")
		@RuneAttribute("payment4ResetFrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment4ResetFrequencyPeriod(String _payment4ResetFrequencyPeriod) {
			this.payment4ResetFrequencyPeriod = _payment4ResetFrequencyPeriod == null ? null : _payment4ResetFrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment5ResetFrequencyPeriodMultiplier")
		@RuneAttribute("payment5ResetFrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment5ResetFrequencyPeriodMultiplier(BigDecimal _payment5ResetFrequencyPeriodMultiplier) {
			this.payment5ResetFrequencyPeriodMultiplier = _payment5ResetFrequencyPeriodMultiplier == null ? null : _payment5ResetFrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment5ResetFrequencyPeriod")
		@RuneAttribute("payment5ResetFrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment5ResetFrequencyPeriod(String _payment5ResetFrequencyPeriod) {
			this.payment5ResetFrequencyPeriod = _payment5ResetFrequencyPeriod == null ? null : _payment5ResetFrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1Type")
		@RuneAttribute("payment1Type")
		public HarmonizedData.HarmonizedDataBuilder setPayment1Type(String _payment1Type) {
			this.payment1Type = _payment1Type == null ? null : _payment1Type;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment1Reference")
		@RuneAttribute("payment1Reference")
		public HarmonizedData.HarmonizedDataBuilder setPayment1Reference(String _payment1Reference) {
			this.payment1Reference = _payment1Reference == null ? null : _payment1Reference;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2Type")
		@RuneAttribute("payment2Type")
		public HarmonizedData.HarmonizedDataBuilder setPayment2Type(String _payment2Type) {
			this.payment2Type = _payment2Type == null ? null : _payment2Type;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment2Reference")
		@RuneAttribute("payment2Reference")
		public HarmonizedData.HarmonizedDataBuilder setPayment2Reference(String _payment2Reference) {
			this.payment2Reference = _payment2Reference == null ? null : _payment2Reference;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3Payer")
		@RuneAttribute("payment3Payer")
		public HarmonizedData.HarmonizedDataBuilder setPayment3Payer(String _payment3Payer) {
			this.payment3Payer = _payment3Payer == null ? null : _payment3Payer;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3Reference")
		@RuneAttribute("payment3Reference")
		public HarmonizedData.HarmonizedDataBuilder setPayment3Reference(String _payment3Reference) {
			this.payment3Reference = _payment3Reference == null ? null : _payment3Reference;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3FrequencyPeriod")
		@RuneAttribute("payment3FrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment3FrequencyPeriod(String _payment3FrequencyPeriod) {
			this.payment3FrequencyPeriod = _payment3FrequencyPeriod == null ? null : _payment3FrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3FrequencyPeriodMultiplier")
		@RuneAttribute("payment3FrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment3FrequencyPeriodMultiplier(BigDecimal _payment3FrequencyPeriodMultiplier) {
			this.payment3FrequencyPeriodMultiplier = _payment3FrequencyPeriodMultiplier == null ? null : _payment3FrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3Date")
		@RuneAttribute("payment3Date")
		public HarmonizedData.HarmonizedDataBuilder setPayment3Date(Date _payment3Date) {
			this.payment3Date = _payment3Date == null ? null : _payment3Date;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment4Reference")
		@RuneAttribute("payment4Reference")
		public HarmonizedData.HarmonizedDataBuilder setPayment4Reference(String _payment4Reference) {
			this.payment4Reference = _payment4Reference == null ? null : _payment4Reference;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment4Payer")
		@RuneAttribute("payment4Payer")
		public HarmonizedData.HarmonizedDataBuilder setPayment4Payer(String _payment4Payer) {
			this.payment4Payer = _payment4Payer == null ? null : _payment4Payer;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment4FrequencyPeriod")
		@RuneAttribute("payment4FrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment4FrequencyPeriod(String _payment4FrequencyPeriod) {
			this.payment4FrequencyPeriod = _payment4FrequencyPeriod == null ? null : _payment4FrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment4FrequencyPeriodMultiplier")
		@RuneAttribute("payment4FrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment4FrequencyPeriodMultiplier(BigDecimal _payment4FrequencyPeriodMultiplier) {
			this.payment4FrequencyPeriodMultiplier = _payment4FrequencyPeriodMultiplier == null ? null : _payment4FrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment4Date")
		@RuneAttribute("payment4Date")
		public HarmonizedData.HarmonizedDataBuilder setPayment4Date(Date _payment4Date) {
			this.payment4Date = _payment4Date == null ? null : _payment4Date;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment5Reference")
		@RuneAttribute("payment5Reference")
		public HarmonizedData.HarmonizedDataBuilder setPayment5Reference(String _payment5Reference) {
			this.payment5Reference = _payment5Reference == null ? null : _payment5Reference;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment5Payer")
		@RuneAttribute("payment5Payer")
		public HarmonizedData.HarmonizedDataBuilder setPayment5Payer(String _payment5Payer) {
			this.payment5Payer = _payment5Payer == null ? null : _payment5Payer;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment5FrequencyPeriod")
		@RuneAttribute("payment5FrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setPayment5FrequencyPeriod(String _payment5FrequencyPeriod) {
			this.payment5FrequencyPeriod = _payment5FrequencyPeriod == null ? null : _payment5FrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment5FrequencyPeriodMultiplier")
		@RuneAttribute("payment5FrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setPayment5FrequencyPeriodMultiplier(BigDecimal _payment5FrequencyPeriodMultiplier) {
			this.payment5FrequencyPeriodMultiplier = _payment5FrequencyPeriodMultiplier == null ? null : _payment5FrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment5Date")
		@RuneAttribute("payment5Date")
		public HarmonizedData.HarmonizedDataBuilder setPayment5Date(Date _payment5Date) {
			this.payment5Date = _payment5Date == null ? null : _payment5Date;
			return this;
		}
		
		@Override
		@RosettaAttribute("payment3Type")
		@RuneAttribute("payment3Type")
		public HarmonizedData.HarmonizedDataBuilder setPayment3Type(String _payment3Type) {
			this.payment3Type = _payment3Type == null ? null : _payment3Type;
			return this;
		}
		
		@Override
		@RosettaAttribute("premiumPayer")
		@RuneAttribute("premiumPayer")
		public HarmonizedData.HarmonizedDataBuilder setPremiumPayer(String _premiumPayer) {
			this.premiumPayer = _premiumPayer == null ? null : _premiumPayer;
			return this;
		}
		
		@Override
		@RosettaAttribute("premiumPaymentDateUnadjusted")
		@RuneAttribute("premiumPaymentDateUnadjusted")
		public HarmonizedData.HarmonizedDataBuilder setPremiumPaymentDateUnadjusted(Date _premiumPaymentDateUnadjusted) {
			this.premiumPaymentDateUnadjusted = _premiumPaymentDateUnadjusted == null ? null : _premiumPaymentDateUnadjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1NatureOfTheReportingCounterparty")
		@RuneAttribute("tradeParty1NatureOfTheReportingCounterparty")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1NatureOfTheReportingCounterparty(String _tradeParty1NatureOfTheReportingCounterparty) {
			this.tradeParty1NatureOfTheReportingCounterparty = _tradeParty1NatureOfTheReportingCounterparty == null ? null : _tradeParty1NatureOfTheReportingCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2NatureOfTheReportingCounterparty")
		@RuneAttribute("tradeParty2NatureOfTheReportingCounterparty")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2NatureOfTheReportingCounterparty(String _tradeParty2NatureOfTheReportingCounterparty) {
			this.tradeParty2NatureOfTheReportingCounterparty = _tradeParty2NatureOfTheReportingCounterparty == null ? null : _tradeParty2NatureOfTheReportingCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse1")
		@RuneAttribute("reservedParticipantUse1")
		public HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse1(String _reservedParticipantUse1) {
			this.reservedParticipantUse1 = _reservedParticipantUse1 == null ? null : _reservedParticipantUse1;
			return this;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse2")
		@RuneAttribute("reservedParticipantUse2")
		public HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse2(String _reservedParticipantUse2) {
			this.reservedParticipantUse2 = _reservedParticipantUse2 == null ? null : _reservedParticipantUse2;
			return this;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse3")
		@RuneAttribute("reservedParticipantUse3")
		public HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse3(String _reservedParticipantUse3) {
			this.reservedParticipantUse3 = _reservedParticipantUse3 == null ? null : _reservedParticipantUse3;
			return this;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse4")
		@RuneAttribute("reservedParticipantUse4")
		public HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse4(String _reservedParticipantUse4) {
			this.reservedParticipantUse4 = _reservedParticipantUse4 == null ? null : _reservedParticipantUse4;
			return this;
		}
		
		@Override
		@RosettaAttribute("reservedParticipantUse5")
		@RuneAttribute("reservedParticipantUse5")
		public HarmonizedData.HarmonizedDataBuilder setReservedParticipantUse5(String _reservedParticipantUse5) {
			this.reservedParticipantUse5 = _reservedParticipantUse5 == null ? null : _reservedParticipantUse5;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1TerminationDate")
		@RuneAttribute("leg1TerminationDate")
		public HarmonizedData.HarmonizedDataBuilder setLeg1TerminationDate(Date _leg1TerminationDate) {
			this.leg1TerminationDate = _leg1TerminationDate == null ? null : _leg1TerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("allocationType")
		@RuneAttribute("allocationType")
		public HarmonizedData.HarmonizedDataBuilder setAllocationType(String _allocationType) {
			this.allocationType = _allocationType == null ? null : _allocationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("calculationBasis")
		@RuneAttribute("calculationBasis")
		public HarmonizedData.HarmonizedDataBuilder setCalculationBasis(String _calculationBasis) {
			this.calculationBasis = _calculationBasis == null ? null : _calculationBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionPartyId")
		@RuneAttribute("clearingExceptionPartyId")
		public HarmonizedData.HarmonizedDataBuilder setClearingExceptionPartyId(String _clearingExceptionPartyId) {
			this.clearingExceptionPartyId = _clearingExceptionPartyId == null ? null : _clearingExceptionPartyId;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionPartyIdType")
		@RuneAttribute("clearingExceptionPartyIdType")
		public HarmonizedData.HarmonizedDataBuilder setClearingExceptionPartyIdType(String _clearingExceptionPartyIdType) {
			this.clearingExceptionPartyIdType = _clearingExceptionPartyIdType == null ? null : _clearingExceptionPartyIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionType")
		@RuneAttribute("clearingExceptionType")
		public HarmonizedData.HarmonizedDataBuilder setClearingExceptionType(String _clearingExceptionType) {
			this.clearingExceptionType = _clearingExceptionType == null ? null : _clearingExceptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMemberClientAccountId")
		@RuneAttribute("clearingMemberClientAccountId")
		public HarmonizedData.HarmonizedDataBuilder setClearingMemberClientAccountId(String _clearingMemberClientAccountId) {
			this.clearingMemberClientAccountId = _clearingMemberClientAccountId == null ? null : _clearingMemberClientAccountId;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptDatetime")
		@RuneAttribute("clearingReceiptDatetime")
		public HarmonizedData.HarmonizedDataBuilder setClearingReceiptDatetime(ZonedDateTime _clearingReceiptDatetime) {
			this.clearingReceiptDatetime = _clearingReceiptDatetime == null ? null : _clearingReceiptDatetime;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingSwapSdrLeiId")
		@RuneAttribute("clearingSwapSdrLeiId")
		public HarmonizedData.HarmonizedDataBuilder setClearingSwapSdrLeiId(String _clearingSwapSdrLeiId) {
			this.clearingSwapSdrLeiId = _clearingSwapSdrLeiId == null ? null : _clearingSwapSdrLeiId;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUtiId")
		@RuneAttribute("clearingSwapUtiId")
		public HarmonizedData.HarmonizedDataBuilder setClearingSwapUtiId(String _clearingSwapUtiId) {
			this.clearingSwapUtiId = _clearingSwapUtiId == null ? null : _clearingSwapUtiId;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralReportingDate")
		@RuneAttribute("collateralReportingDate")
		public HarmonizedData.HarmonizedDataBuilder setCollateralReportingDate(Date _collateralReportingDate) {
			this.collateralReportingDate = _collateralReportingDate == null ? null : _collateralReportingDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralValuationDatetime")
		@RuneAttribute("collateralValuationDatetime")
		public HarmonizedData.HarmonizedDataBuilder setCollateralValuationDatetime(ZonedDateTime _collateralValuationDatetime) {
			this.collateralValuationDatetime = _collateralValuationDatetime == null ? null : _collateralValuationDatetime;
			return this;
		}
		
		@Override
		@RosettaAttribute("comment2")
		@RuneAttribute("comment2")
		public HarmonizedData.HarmonizedDataBuilder setComment2(String _comment2) {
			this.comment2 = _comment2 == null ? null : _comment2;
			return this;
		}
		
		@Override
		@RosettaAttribute("commodityStrikePriceUnit")
		@RuneAttribute("commodityStrikePriceUnit")
		public HarmonizedData.HarmonizedDataBuilder setCommodityStrikePriceUnit(String _commodityStrikePriceUnit) {
			this.commodityStrikePriceUnit = _commodityStrikePriceUnit == null ? null : _commodityStrikePriceUnit;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentMaskingIndicator")
		@RuneAttribute("executionAgentMaskingIndicator")
		public HarmonizedData.HarmonizedDataBuilder setExecutionAgentMaskingIndicator(String _executionAgentMaskingIndicator) {
			this.executionAgentMaskingIndicator = _executionAgentMaskingIndicator == null ? null : _executionAgentMaskingIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("feeInCurrency")
		@RuneAttribute("feeInCurrency")
		public HarmonizedData.HarmonizedDataBuilder setFeeInCurrency(String _feeInCurrency) {
			this.feeInCurrency = _feeInCurrency == null ? null : _feeInCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("feeOutCurrency")
		@RuneAttribute("feeOutCurrency")
		public HarmonizedData.HarmonizedDataBuilder setFeeOutCurrency(String _feeOutCurrency) {
			this.feeOutCurrency = _feeOutCurrency == null ? null : _feeOutCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg1Multiplier")
		@RuneAttribute("floatingRatePaymentFrequencyLeg1Multiplier")
		public HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg1Multiplier(BigDecimal _floatingRatePaymentFrequencyLeg1Multiplier) {
			this.floatingRatePaymentFrequencyLeg1Multiplier = _floatingRatePaymentFrequencyLeg1Multiplier == null ? null : _floatingRatePaymentFrequencyLeg1Multiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg1TimePeriod")
		@RuneAttribute("floatingRatePaymentFrequencyLeg1TimePeriod")
		public HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg1TimePeriod(String _floatingRatePaymentFrequencyLeg1TimePeriod) {
			this.floatingRatePaymentFrequencyLeg1TimePeriod = _floatingRatePaymentFrequencyLeg1TimePeriod == null ? null : _floatingRatePaymentFrequencyLeg1TimePeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg2Multiplier")
		@RuneAttribute("floatingRatePaymentFrequencyLeg2Multiplier")
		public HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg2Multiplier(BigDecimal _floatingRatePaymentFrequencyLeg2Multiplier) {
			this.floatingRatePaymentFrequencyLeg2Multiplier = _floatingRatePaymentFrequencyLeg2Multiplier == null ? null : _floatingRatePaymentFrequencyLeg2Multiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyLeg2TimePeriod")
		@RuneAttribute("floatingRatePaymentFrequencyLeg2TimePeriod")
		public HarmonizedData.HarmonizedDataBuilder setFloatingRatePaymentFrequencyLeg2TimePeriod(String _floatingRatePaymentFrequencyLeg2TimePeriod) {
			this.floatingRatePaymentFrequencyLeg2TimePeriod = _floatingRatePaymentFrequencyLeg2TimePeriod == null ? null : _floatingRatePaymentFrequencyLeg2TimePeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("frequencyOfPayment")
		@RuneAttribute("frequencyOfPayment")
		public HarmonizedData.HarmonizedDataBuilder setFrequencyOfPayment(String _frequencyOfPayment) {
			this.frequencyOfPayment = _frequencyOfPayment == null ? null : _frequencyOfPayment;
			return this;
		}
		
		@Override
		@RosettaAttribute("interaffiliate")
		@RuneAttribute("interaffiliate")
		public HarmonizedData.HarmonizedDataBuilder setInteraffiliate(Boolean _interaffiliate) {
			this.interaffiliate = _interaffiliate == null ? null : _interaffiliate;
			return this;
		}
		
		@Override
		@RosettaAttribute("largeTradeIndicator")
		@RuneAttribute("largeTradeIndicator")
		public HarmonizedData.HarmonizedDataBuilder setLargeTradeIndicator(Boolean _largeTradeIndicator) {
			this.largeTradeIndicator = _largeTradeIndicator == null ? null : _largeTradeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1EffectiveDateAdjusted")
		@RuneAttribute("leg1EffectiveDateAdjusted")
		public HarmonizedData.HarmonizedDataBuilder setLeg1EffectiveDateAdjusted(Date _leg1EffectiveDateAdjusted) {
			this.leg1EffectiveDateAdjusted = _leg1EffectiveDateAdjusted == null ? null : _leg1EffectiveDateAdjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FinalValuationDate")
		@RuneAttribute("leg1FinalValuationDate")
		public HarmonizedData.HarmonizedDataBuilder setLeg1FinalValuationDate(Date _leg1FinalValuationDate) {
			this.leg1FinalValuationDate = _leg1FinalValuationDate == null ? null : _leg1FinalValuationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1SettlementPeriod")
		@RuneAttribute("leg1SettlementPeriod")
		public HarmonizedData.HarmonizedDataBuilder setLeg1SettlementPeriod(String _leg1SettlementPeriod) {
			this.leg1SettlementPeriod = _leg1SettlementPeriod == null ? null : _leg1SettlementPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2EffectiveDateAdjusted")
		@RuneAttribute("leg2EffectiveDateAdjusted")
		public HarmonizedData.HarmonizedDataBuilder setLeg2EffectiveDateAdjusted(Date _leg2EffectiveDateAdjusted) {
			this.leg2EffectiveDateAdjusted = _leg2EffectiveDateAdjusted == null ? null : _leg2EffectiveDateAdjusted;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentTermsFrequencyPeriod")
		@RuneAttribute("leg2PaymentTermsFrequencyPeriod")
		public HarmonizedData.HarmonizedDataBuilder setLeg2PaymentTermsFrequencyPeriod(String _leg2PaymentTermsFrequencyPeriod) {
			this.leg2PaymentTermsFrequencyPeriod = _leg2PaymentTermsFrequencyPeriod == null ? null : _leg2PaymentTermsFrequencyPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2PaymentTermsPaymentFrequencyPeriodMultiplier")
		@RuneAttribute("leg2PaymentTermsPaymentFrequencyPeriodMultiplier")
		public HarmonizedData.HarmonizedDataBuilder setLeg2PaymentTermsPaymentFrequencyPeriodMultiplier(BigDecimal _leg2PaymentTermsPaymentFrequencyPeriodMultiplier) {
			this.leg2PaymentTermsPaymentFrequencyPeriodMultiplier = _leg2PaymentTermsPaymentFrequencyPeriodMultiplier == null ? null : _leg2PaymentTermsPaymentFrequencyPeriodMultiplier;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2SettlementType")
		@RuneAttribute("leg2SettlementType")
		public HarmonizedData.HarmonizedDataBuilder setLeg2SettlementType(String _leg2SettlementType) {
			this.leg2SettlementType = _leg2SettlementType == null ? null : _leg2SettlementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetId")
		@RuneAttribute("leg2UnderlyingAssetId")
		public HarmonizedData.HarmonizedDataBuilder setLeg2UnderlyingAssetId(String _leg2UnderlyingAssetId) {
			this.leg2UnderlyingAssetId = _leg2UnderlyingAssetId == null ? null : _leg2UnderlyingAssetId;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetIdType")
		@RuneAttribute("leg2UnderlyingAssetIdType")
		public HarmonizedData.HarmonizedDataBuilder setLeg2UnderlyingAssetIdType(String _leg2UnderlyingAssetIdType) {
			this.leg2UnderlyingAssetIdType = _leg2UnderlyingAssetIdType == null ? null : _leg2UnderlyingAssetIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2UnderlyingAssetName")
		@RuneAttribute("leg2UnderlyingAssetName")
		public HarmonizedData.HarmonizedDataBuilder setLeg2UnderlyingAssetName(String _leg2UnderlyingAssetName) {
			this.leg2UnderlyingAssetName = _leg2UnderlyingAssetName == null ? null : _leg2UnderlyingAssetName;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDate")
		@RuneAttribute("maturityDate")
		public HarmonizedData.HarmonizedDataBuilder setMaturityDate(Date _maturityDate) {
			this.maturityDate = _maturityDate == null ? null : _maturityDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionalEarlyTerminationDate")
		@RuneAttribute("optionalEarlyTerminationDate")
		public HarmonizedData.HarmonizedDataBuilder setOptionalEarlyTerminationDate(String _optionalEarlyTerminationDate) {
			this.optionalEarlyTerminationDate = _optionalEarlyTerminationDate == null ? null : _optionalEarlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityCurrency")
		@RuneAttribute("optionCommodityCurrency")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityCurrency(String _optionCommodityCurrency) {
			this.optionCommodityCurrency = _optionCommodityCurrency == null ? null : _optionCommodityCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityExchangeId")
		@RuneAttribute("optionCommodityExchangeId")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityExchangeId(String _optionCommodityExchangeId) {
			this.optionCommodityExchangeId = _optionCommodityExchangeId == null ? null : _optionCommodityExchangeId;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityInstrumentId")
		@RuneAttribute("optionCommodityInstrumentId")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityInstrumentId(String _optionCommodityInstrumentId) {
			this.optionCommodityInstrumentId = _optionCommodityInstrumentId == null ? null : _optionCommodityInstrumentId;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityRateSource")
		@RuneAttribute("optionCommodityRateSource")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityRateSource(String _optionCommodityRateSource) {
			this.optionCommodityRateSource = _optionCommodityRateSource == null ? null : _optionCommodityRateSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityRateSourcePage")
		@RuneAttribute("optionCommodityRateSourcePage")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityRateSourcePage(String _optionCommodityRateSourcePage) {
			this.optionCommodityRateSourcePage = _optionCommodityRateSourcePage == null ? null : _optionCommodityRateSourcePage;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnderlyerDetails")
		@RuneAttribute("optionCommodityUnderlyerDetails")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityUnderlyerDetails(String _optionCommodityUnderlyerDetails) {
			this.optionCommodityUnderlyerDetails = _optionCommodityUnderlyerDetails == null ? null : _optionCommodityUnderlyerDetails;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnderlyerId")
		@RuneAttribute("optionCommodityUnderlyerId")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityUnderlyerId(String _optionCommodityUnderlyerId) {
			this.optionCommodityUnderlyerId = _optionCommodityUnderlyerId == null ? null : _optionCommodityUnderlyerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionCommodityUnitOfMeasure")
		@RuneAttribute("optionCommodityUnitOfMeasure")
		public HarmonizedData.HarmonizedDataBuilder setOptionCommodityUnitOfMeasure(String _optionCommodityUnitOfMeasure) {
			this.optionCommodityUnitOfMeasure = _optionCommodityUnitOfMeasure == null ? null : _optionCommodityUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionSpecifiedPrice")
		@RuneAttribute("optionSpecifiedPrice")
		public HarmonizedData.HarmonizedDataBuilder setOptionSpecifiedPrice(String _optionSpecifiedPrice) {
			this.optionSpecifiedPrice = _optionSpecifiedPrice == null ? null : _optionSpecifiedPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionSpreadAmount")
		@RuneAttribute("optionSpreadAmount")
		public HarmonizedData.HarmonizedDataBuilder setOptionSpreadAmount(BigDecimal _optionSpreadAmount) {
			this.optionSpreadAmount = _optionSpreadAmount == null ? null : _optionSpreadAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionSpreadCurrency")
		@RuneAttribute("optionSpreadCurrency")
		public HarmonizedData.HarmonizedDataBuilder setOptionSpreadCurrency(String _optionSpreadCurrency) {
			this.optionSpreadCurrency = _optionSpreadCurrency == null ? null : _optionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionSpreadSchedule")
		@RuneAttribute("optionSpreadSchedule")
		public HarmonizedData.HarmonizedDataBuilder setOptionSpreadSchedule(String _optionSpreadSchedule) {
			this.optionSpreadSchedule = _optionSpreadSchedule == null ? null : _optionSpreadSchedule;
			return this;
		}
		
		@Override
		@RosettaAttribute("origin")
		@RuneAttribute("origin")
		public HarmonizedData.HarmonizedDataBuilder setOrigin(String _origin) {
			this.origin = _origin == null ? null : _origin;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapSdrId")
		@RuneAttribute("originalSwapSdrId")
		public HarmonizedData.HarmonizedDataBuilder setOriginalSwapSdrId(String _originalSwapSdrId) {
			this.originalSwapSdrId = _originalSwapSdrId == null ? null : _originalSwapSdrId;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapSdrIdType")
		@RuneAttribute("originalSwapSdrIdType")
		public HarmonizedData.HarmonizedDataBuilder setOriginalSwapSdrIdType(String _originalSwapSdrIdType) {
			this.originalSwapSdrIdType = _originalSwapSdrIdType == null ? null : _originalSwapSdrIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg1")
		@RuneAttribute("paymentFrequencyPeriodLeg1")
		public HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodLeg1(String _paymentFrequencyPeriodLeg1) {
			this.paymentFrequencyPeriodLeg1 = _paymentFrequencyPeriodLeg1 == null ? null : _paymentFrequencyPeriodLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg2")
		@RuneAttribute("paymentFrequencyPeriodLeg2")
		public HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodLeg2(String _paymentFrequencyPeriodLeg2) {
			this.paymentFrequencyPeriodLeg2 = _paymentFrequencyPeriodLeg2 == null ? null : _paymentFrequencyPeriodLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg1")
		public HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodMultiplierLeg1(BigDecimal _paymentFrequencyPeriodMultiplierLeg1) {
			this.paymentFrequencyPeriodMultiplierLeg1 = _paymentFrequencyPeriodMultiplierLeg1 == null ? null : _paymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg2")
		public HarmonizedData.HarmonizedDataBuilder setPaymentFrequencyPeriodMultiplierLeg2(BigDecimal _paymentFrequencyPeriodMultiplierLeg2) {
			this.paymentFrequencyPeriodMultiplierLeg2 = _paymentFrequencyPeriodMultiplierLeg2 == null ? null : _paymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("premiumPayerPrefix")
		@RuneAttribute("premiumPayerPrefix")
		public HarmonizedData.HarmonizedDataBuilder setPremiumPayerPrefix(String _premiumPayerPrefix) {
			this.premiumPayerPrefix = _premiumPayerPrefix == null ? null : _premiumPayerPrefix;
			return this;
		}
		
		@Override
		@RosettaAttribute("price1Currency")
		@RuneAttribute("price1Currency")
		public HarmonizedData.HarmonizedDataBuilder setPrice1Currency(String _price1Currency) {
			this.price1Currency = _price1Currency == null ? null : _price1Currency;
			return this;
		}
		
		@Override
		@RosettaAttribute("price2Price")
		@RuneAttribute("price2Price")
		public HarmonizedData.HarmonizedDataBuilder setPrice2Price(BigDecimal _price2Price) {
			this.price2Price = _price2Price == null ? null : _price2Price;
			return this;
		}
		
		@Override
		@RosettaAttribute("price2Type")
		@RuneAttribute("price2Type")
		public HarmonizedData.HarmonizedDataBuilder setPrice2Type(String _price2Type) {
			this.price2Type = _price2Type == null ? null : _price2Type;
			return this;
		}
		
		@Override
		@RosettaAttribute("price2Units")
		@RuneAttribute("price2Units")
		public HarmonizedData.HarmonizedDataBuilder setPrice2Units(String _price2Units) {
			this.price2Units = _price2Units == null ? null : _price2Units;
			return this;
		}
		
		@Override
		@RosettaAttribute("price3Price")
		@RuneAttribute("price3Price")
		public HarmonizedData.HarmonizedDataBuilder setPrice3Price(BigDecimal _price3Price) {
			this.price3Price = _price3Price == null ? null : _price3Price;
			return this;
		}
		
		@Override
		@RosettaAttribute("price3Type")
		@RuneAttribute("price3Type")
		public HarmonizedData.HarmonizedDataBuilder setPrice3Type(String _price3Type) {
			this.price3Type = _price3Type == null ? null : _price3Type;
			return this;
		}
		
		@Override
		@RosettaAttribute("price3Units")
		@RuneAttribute("price3Units")
		public HarmonizedData.HarmonizedDataBuilder setPrice3Units(String _price3Units) {
			this.price3Units = _price3Units == null ? null : _price3Units;
			return this;
		}
		
		@Override
		@RosettaAttribute("price4Price")
		@RuneAttribute("price4Price")
		public HarmonizedData.HarmonizedDataBuilder setPrice4Price(BigDecimal _price4Price) {
			this.price4Price = _price4Price == null ? null : _price4Price;
			return this;
		}
		
		@Override
		@RosettaAttribute("price4Type")
		@RuneAttribute("price4Type")
		public HarmonizedData.HarmonizedDataBuilder setPrice4Type(String _price4Type) {
			this.price4Type = _price4Type == null ? null : _price4Type;
			return this;
		}
		
		@Override
		@RosettaAttribute("price4Units")
		@RuneAttribute("price4Units")
		public HarmonizedData.HarmonizedDataBuilder setPrice4Units(String _price4Units) {
			this.price4Units = _price4Units == null ? null : _price4Units;
			return this;
		}
		
		@Override
		@RosettaAttribute("pricingContext")
		@RuneAttribute("pricingContext")
		public HarmonizedData.HarmonizedDataBuilder setPricingContext(String _pricingContext) {
			this.pricingContext = _pricingContext == null ? null : _pricingContext;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUsiType")
		@RuneAttribute("priorUsiType")
		public HarmonizedData.HarmonizedDataBuilder setPriorUsiType(String _priorUsiType) {
			this.priorUsiType = _priorUsiType == null ? null : _priorUsiType;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUtiType")
		@RuneAttribute("priorUtiType")
		public HarmonizedData.HarmonizedDataBuilder setPriorUtiType(String _priorUtiType) {
			this.priorUtiType = _priorUtiType == null ? null : _priorUtiType;
			return this;
		}
		
		@Override
		@RosettaAttribute("recoveryPrice")
		@RuneAttribute("recoveryPrice")
		public HarmonizedData.HarmonizedDataBuilder setRecoveryPrice(BigDecimal _recoveryPrice) {
			this.recoveryPrice = _recoveryPrice == null ? null : _recoveryPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("sendToDataCenterCode")
		@RuneAttribute("sendToDataCenterCode")
		public HarmonizedData.HarmonizedDataBuilder setSendToDataCenterCode(String _sendToDataCenterCode) {
			this.sendToDataCenterCode = _sendToDataCenterCode == null ? null : _sendToDataCenterCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceType")
		@RuneAttribute("strikePriceType")
		public HarmonizedData.HarmonizedDataBuilder setStrikePriceType(String _strikePriceType) {
			this.strikePriceType = _strikePriceType == null ? null : _strikePriceType;
			return this;
		}
		
		@Override
		@RosettaAttribute("subAssetClassForOtherCommodity")
		@RuneAttribute("subAssetClassForOtherCommodity")
		public HarmonizedData.HarmonizedDataBuilder setSubAssetClassForOtherCommodity(String _subAssetClassForOtherCommodity) {
			this.subAssetClassForOtherCommodity = _subAssetClassForOtherCommodity == null ? null : _subAssetClassForOtherCommodity;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CftcFinancialEntityStatus")
		@RuneAttribute("tradeParty1CftcFinancialEntityStatus")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CftcFinancialEntityStatus(String _tradeParty1CftcFinancialEntityStatus) {
			this.tradeParty1CftcFinancialEntityStatus = _tradeParty1CftcFinancialEntityStatus == null ? null : _tradeParty1CftcFinancialEntityStatus;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralAmount")
		@RuneAttribute("tradeParty1CollateralAmount")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralAmount(BigDecimal _tradeParty1CollateralAmount) {
			this.tradeParty1CollateralAmount = _tradeParty1CollateralAmount == null ? null : _tradeParty1CollateralAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1CollateralCurrency")
		@RuneAttribute("tradeParty1CollateralCurrency")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1CollateralCurrency(String _tradeParty1CollateralCurrency) {
			this.tradeParty1CollateralCurrency = _tradeParty1CollateralCurrency == null ? null : _tradeParty1CollateralCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1MandatoryDelegatedReporting")
		@RuneAttribute("tradeParty1MandatoryDelegatedReporting")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1MandatoryDelegatedReporting(String _tradeParty1MandatoryDelegatedReporting) {
			this.tradeParty1MandatoryDelegatedReporting = _tradeParty1MandatoryDelegatedReporting == null ? null : _tradeParty1MandatoryDelegatedReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1Role")
		@RuneAttribute("tradeParty1Role")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty1Role(String _tradeParty1Role) {
			this.tradeParty1Role = _tradeParty1Role == null ? null : _tradeParty1Role;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CftcFinancialEntityStatus")
		@RuneAttribute("tradeParty2CftcFinancialEntityStatus")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CftcFinancialEntityStatus(String _tradeParty2CftcFinancialEntityStatus) {
			this.tradeParty2CftcFinancialEntityStatus = _tradeParty2CftcFinancialEntityStatus == null ? null : _tradeParty2CftcFinancialEntityStatus;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralAmount")
		@RuneAttribute("tradeParty2CollateralAmount")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralAmount(BigDecimal _tradeParty2CollateralAmount) {
			this.tradeParty2CollateralAmount = _tradeParty2CollateralAmount == null ? null : _tradeParty2CollateralAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2CollateralCurrency")
		@RuneAttribute("tradeParty2CollateralCurrency")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2CollateralCurrency(String _tradeParty2CollateralCurrency) {
			this.tradeParty2CollateralCurrency = _tradeParty2CollateralCurrency == null ? null : _tradeParty2CollateralCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2MandatoryDelegatedReporting")
		@RuneAttribute("tradeParty2MandatoryDelegatedReporting")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2MandatoryDelegatedReporting(String _tradeParty2MandatoryDelegatedReporting) {
			this.tradeParty2MandatoryDelegatedReporting = _tradeParty2MandatoryDelegatedReporting == null ? null : _tradeParty2MandatoryDelegatedReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2Role")
		@RuneAttribute("tradeParty2Role")
		public HarmonizedData.HarmonizedDataBuilder setTradeParty2Role(String _tradeParty2Role) {
			this.tradeParty2Role = _tradeParty2Role == null ? null : _tradeParty2Role;
			return this;
		}
		
		@Override
		@RosettaAttribute("upfrontPayment")
		@RuneAttribute("upfrontPayment")
		public HarmonizedData.HarmonizedDataBuilder setUpfrontPayment(BigDecimal _upfrontPayment) {
			this.upfrontPayment = _upfrontPayment == null ? null : _upfrontPayment;
			return this;
		}
		
		@Override
		@RosettaAttribute("verificationMethod")
		@RuneAttribute("verificationMethod")
		public HarmonizedData.HarmonizedDataBuilder setVerificationMethod(String _verificationMethod) {
			this.verificationMethod = _verificationMethod == null ? null : _verificationMethod;
			return this;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterId")
		@RuneAttribute("responsibleDataSubmitterId")
		public HarmonizedData.HarmonizedDataBuilder setResponsibleDataSubmitterId(String _responsibleDataSubmitterId) {
			this.responsibleDataSubmitterId = _responsibleDataSubmitterId == null ? null : _responsibleDataSubmitterId;
			return this;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterIdType")
		@RuneAttribute("responsibleDataSubmitterIdType")
		public HarmonizedData.HarmonizedDataBuilder setResponsibleDataSubmitterIdType(String _responsibleDataSubmitterIdType) {
			this.responsibleDataSubmitterIdType = _responsibleDataSubmitterIdType == null ? null : _responsibleDataSubmitterIdType;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapUsi")
		@RuneAttribute("originalSwapUsi")
		public HarmonizedData.HarmonizedDataBuilder setOriginalSwapUsi(String _originalSwapUsi) {
			this.originalSwapUsi = _originalSwapUsi == null ? null : _originalSwapUsi;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapUti")
		@RuneAttribute("originalSwapUti")
		public HarmonizedData.HarmonizedDataBuilder setOriginalSwapUti(String _originalSwapUti) {
			this.originalSwapUti = _originalSwapUti == null ? null : _originalSwapUti;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeReceiverIdentifierLeg2")
		@RuneAttribute("cdeReceiverIdentifierLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeReceiverIdentifierLeg2(String _cdeReceiverIdentifierLeg2) {
			this.cdeReceiverIdentifierLeg2 = _cdeReceiverIdentifierLeg2 == null ? null : _cdeReceiverIdentifierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1FederalEntityIndicator")
		@RuneAttribute("counterparty1FederalEntityIndicator")
		public HarmonizedData.HarmonizedDataBuilder setCounterparty1FederalEntityIndicator(Boolean _counterparty1FederalEntityIndicator) {
			this.counterparty1FederalEntityIndicator = _counterparty1FederalEntityIndicator == null ? null : _counterparty1FederalEntityIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2FederalEntityIndicator")
		@RuneAttribute("counterparty2FederalEntityIndicator")
		public HarmonizedData.HarmonizedDataBuilder setCounterparty2FederalEntityIndicator(Boolean _counterparty2FederalEntityIndicator) {
			this.counterparty2FederalEntityIndicator = _counterparty2FederalEntityIndicator == null ? null : _counterparty2FederalEntityIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public HarmonizedData.HarmonizedDataBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
			this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("noaActionType")
		@RuneAttribute("noaActionType")
		public HarmonizedData.HarmonizedDataBuilder setNoaActionType(String _noaActionType) {
			this.noaActionType = _noaActionType == null ? null : _noaActionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public HarmonizedData.HarmonizedDataBuilder setEventType(String _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public HarmonizedData.HarmonizedDataBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
			this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public HarmonizedData.HarmonizedDataBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeCallAmountLeg1")
		@RuneAttribute("cdeCallAmountLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeCallAmountLeg1(BigDecimal _cdeCallAmountLeg1) {
			this.cdeCallAmountLeg1 = _cdeCallAmountLeg1 == null ? null : _cdeCallAmountLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeCallAmountLeg2")
		@RuneAttribute("cdeCallAmountLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeCallAmountLeg2(BigDecimal _cdeCallAmountLeg2) {
			this.cdeCallAmountLeg2 = _cdeCallAmountLeg2 == null ? null : _cdeCallAmountLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeCallCurrencyLeg1")
		@RuneAttribute("cdeCallCurrencyLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeCallCurrencyLeg1(String _cdeCallCurrencyLeg1) {
			this.cdeCallCurrencyLeg1 = _cdeCallCurrencyLeg1 == null ? null : _cdeCallCurrencyLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeCallCurrencyLeg2")
		@RuneAttribute("cdeCallCurrencyLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeCallCurrencyLeg2(String _cdeCallCurrencyLeg2) {
			this.cdeCallCurrencyLeg2 = _cdeCallCurrencyLeg2 == null ? null : _cdeCallCurrencyLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePutAmountLeg1")
		@RuneAttribute("cdePutAmountLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdePutAmountLeg1(BigDecimal _cdePutAmountLeg1) {
			this.cdePutAmountLeg1 = _cdePutAmountLeg1 == null ? null : _cdePutAmountLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePutAmountLeg2")
		@RuneAttribute("cdePutAmountLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdePutAmountLeg2(BigDecimal _cdePutAmountLeg2) {
			this.cdePutAmountLeg2 = _cdePutAmountLeg2 == null ? null : _cdePutAmountLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePutCurrencyLeg1")
		@RuneAttribute("cdePutCurrencyLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdePutCurrencyLeg1(String _cdePutCurrencyLeg1) {
			this.cdePutCurrencyLeg1 = _cdePutCurrencyLeg1 == null ? null : _cdePutCurrencyLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePutCurrencyLeg2")
		@RuneAttribute("cdePutCurrencyLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdePutCurrencyLeg2(String _cdePutCurrencyLeg2) {
			this.cdePutCurrencyLeg2 = _cdePutCurrencyLeg2 == null ? null : _cdePutCurrencyLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2QuantityFrequency")
		@RuneAttribute("leg2QuantityFrequency")
		public HarmonizedData.HarmonizedDataBuilder setLeg2QuantityFrequency(String _leg2QuantityFrequency) {
			this.leg2QuantityFrequency = _leg2QuantityFrequency == null ? null : _leg2QuantityFrequency;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg1")
		@RuneAttribute("quantityFrequencyMultiplierLeg1")
		public HarmonizedData.HarmonizedDataBuilder setQuantityFrequencyMultiplierLeg1(BigDecimal _quantityFrequencyMultiplierLeg1) {
			this.quantityFrequencyMultiplierLeg1 = _quantityFrequencyMultiplierLeg1 == null ? null : _quantityFrequencyMultiplierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg2")
		@RuneAttribute("quantityFrequencyMultiplierLeg2")
		public HarmonizedData.HarmonizedDataBuilder setQuantityFrequencyMultiplierLeg2(BigDecimal _quantityFrequencyMultiplierLeg2) {
			this.quantityFrequencyMultiplierLeg2 = _quantityFrequencyMultiplierLeg2 == null ? null : _quantityFrequencyMultiplierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeQuantityUnitOfMeasureLeg1")
		@RuneAttribute("cdeQuantityUnitOfMeasureLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeQuantityUnitOfMeasureLeg1(String _cdeQuantityUnitOfMeasureLeg1) {
			this.cdeQuantityUnitOfMeasureLeg1 = _cdeQuantityUnitOfMeasureLeg1 == null ? null : _cdeQuantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeQuantityUnitOfMeasureLeg2")
		@RuneAttribute("cdeQuantityUnitOfMeasureLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeQuantityUnitOfMeasureLeg2(String _cdeQuantityUnitOfMeasureLeg2) {
			this.cdeQuantityUnitOfMeasureLeg2 = _cdeQuantityUnitOfMeasureLeg2 == null ? null : _cdeQuantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public HarmonizedData.HarmonizedDataBuilder setPackageIndicator(Boolean _packageIndicator) {
			this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePackageIdentifier")
		@RuneAttribute("cdePackageIdentifier")
		public HarmonizedData.HarmonizedDataBuilder setCdePackageIdentifier(String _cdePackageIdentifier) {
			this.cdePackageIdentifier = _cdePackageIdentifier == null ? null : _cdePackageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPrice")
		@RuneAttribute("cdePackageTransactionPrice")
		public HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionPrice(BigDecimal _cdePackageTransactionPrice) {
			this.cdePackageTransactionPrice = _cdePackageTransactionPrice == null ? null : _cdePackageTransactionPrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPriceCurrency")
		@RuneAttribute("cdePackageTransactionPriceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionPriceCurrency(String _cdePackageTransactionPriceCurrency) {
			this.cdePackageTransactionPriceCurrency = _cdePackageTransactionPriceCurrency == null ? null : _cdePackageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionPriceNotation")
		@RuneAttribute("cdePackageTransactionPriceNotation")
		public HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionPriceNotation(String _cdePackageTransactionPriceNotation) {
			this.cdePackageTransactionPriceNotation = _cdePackageTransactionPriceNotation == null ? null : _cdePackageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpread")
		@RuneAttribute("cdePackageTransactionSpread")
		public HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionSpread(BigDecimal _cdePackageTransactionSpread) {
			this.cdePackageTransactionSpread = _cdePackageTransactionSpread == null ? null : _cdePackageTransactionSpread;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpreadCurrency")
		@RuneAttribute("cdePackageTransactionSpreadCurrency")
		public HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionSpreadCurrency(String _cdePackageTransactionSpreadCurrency) {
			this.cdePackageTransactionSpreadCurrency = _cdePackageTransactionSpreadCurrency == null ? null : _cdePackageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePackageTransactionSpreadNotation")
		@RuneAttribute("cdePackageTransactionSpreadNotation")
		public HarmonizedData.HarmonizedDataBuilder setCdePackageTransactionSpreadNotation(String _cdePackageTransactionSpreadNotation) {
			this.cdePackageTransactionSpreadNotation = _cdePackageTransactionSpreadNotation == null ? null : _cdePackageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRateDayCountConventionLeg1")
		@RuneAttribute("cdeFixedRateDayCountConventionLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeFixedRateDayCountConventionLeg1(String _cdeFixedRateDayCountConventionLeg1) {
			this.cdeFixedRateDayCountConventionLeg1 = _cdeFixedRateDayCountConventionLeg1 == null ? null : _cdeFixedRateDayCountConventionLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRateDayCountConventionLeg2")
		@RuneAttribute("cdeFixedRateDayCountConventionLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeFixedRateDayCountConventionLeg2(String _cdeFixedRateDayCountConventionLeg2) {
			this.cdeFixedRateDayCountConventionLeg2 = _cdeFixedRateDayCountConventionLeg2 == null ? null : _cdeFixedRateDayCountConventionLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRateDayCountConventionLeg1")
		@RuneAttribute("cdeFloatingRateDayCountConventionLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeFloatingRateDayCountConventionLeg1(String _cdeFloatingRateDayCountConventionLeg1) {
			this.cdeFloatingRateDayCountConventionLeg1 = _cdeFloatingRateDayCountConventionLeg1 == null ? null : _cdeFloatingRateDayCountConventionLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRateDayCountConventionLeg2")
		@RuneAttribute("cdeFloatingRateDayCountConventionLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeFloatingRateDayCountConventionLeg2(String _cdeFloatingRateDayCountConventionLeg2) {
			this.cdeFloatingRateDayCountConventionLeg2 = _cdeFloatingRateDayCountConventionLeg2 == null ? null : _cdeFloatingRateDayCountConventionLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		public HarmonizedData.HarmonizedDataBuilder setFixingDateLeg1(Date _fixingDateLeg1) {
			this.fixingDateLeg1 = _fixingDateLeg1 == null ? null : _fixingDateLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		public HarmonizedData.HarmonizedDataBuilder setFixingDateLeg2(Date _fixingDateLeg2) {
			this.fixingDateLeg2 = _fixingDateLeg2 == null ? null : _fixingDateLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodLeg1(String _cdeFixedRatePaymentFrequencyPeriodLeg1) {
			this.cdeFixedRatePaymentFrequencyPeriodLeg1 = _cdeFixedRatePaymentFrequencyPeriodLeg1 == null ? null : _cdeFixedRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodLeg2(String _cdeFixedRatePaymentFrequencyPeriodLeg2) {
			this.cdeFixedRatePaymentFrequencyPeriodLeg2 = _cdeFixedRatePaymentFrequencyPeriodLeg2 == null ? null : _cdeFixedRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodLeg1(String _cdeFloatingRatePaymentFrequencyPeriodLeg1) {
			this.cdeFloatingRatePaymentFrequencyPeriodLeg1 = _cdeFloatingRatePaymentFrequencyPeriodLeg1 == null ? null : _cdeFloatingRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodLeg2(String _cdeFloatingRatePaymentFrequencyPeriodLeg2) {
			this.cdeFloatingRatePaymentFrequencyPeriodLeg2 = _cdeFloatingRatePaymentFrequencyPeriodLeg2 == null ? null : _cdeFloatingRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(BigDecimal _cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1 = _cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(BigDecimal _cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2 = _cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(BigDecimal _cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1 = _cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(BigDecimal _cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2 = _cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("postPricedSwapIndicator")
		@RuneAttribute("postPricedSwapIndicator")
		public HarmonizedData.HarmonizedDataBuilder setPostPricedSwapIndicator(Boolean _postPricedSwapIndicator) {
			this.postPricedSwapIndicator = _postPricedSwapIndicator == null ? null : _postPricedSwapIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePriceCurrency")
		@RuneAttribute("cdePriceCurrency")
		public HarmonizedData.HarmonizedDataBuilder setCdePriceCurrency(String _cdePriceCurrency) {
			this.cdePriceCurrency = _cdePriceCurrency == null ? null : _cdePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePriceNotation")
		@RuneAttribute("cdePriceNotation")
		public HarmonizedData.HarmonizedDataBuilder setCdePriceNotation(String _cdePriceNotation) {
			this.cdePriceNotation = _cdePriceNotation == null ? null : _cdePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeSpreadNotationLeg1")
		@RuneAttribute("cdeSpreadNotationLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeSpreadNotationLeg1(String _cdeSpreadNotationLeg1) {
			this.cdeSpreadNotationLeg1 = _cdeSpreadNotationLeg1 == null ? null : _cdeSpreadNotationLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeSpreadNotationLeg2")
		@RuneAttribute("cdeSpreadNotationLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeSpreadNotationLeg2(String _cdeSpreadNotationLeg2) {
			this.cdeSpreadNotationLeg2 = _cdeSpreadNotationLeg2 == null ? null : _cdeSpreadNotationLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeStrikePriceCurrency2")
		@RuneAttribute("cdeStrikePriceCurrency2")
		public HarmonizedData.HarmonizedDataBuilder setCdeStrikePriceCurrency2(String _cdeStrikePriceCurrency2) {
			this.cdeStrikePriceCurrency2 = _cdeStrikePriceCurrency2 == null ? null : _cdeStrikePriceCurrency2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeStrikePriceNotation")
		@RuneAttribute("cdeStrikePriceNotation")
		public HarmonizedData.HarmonizedDataBuilder setCdeStrikePriceNotation(String _cdeStrikePriceNotation) {
			this.cdeStrikePriceNotation = _cdeStrikePriceNotation == null ? null : _cdeStrikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFirstExerciseDate")
		@RuneAttribute("cdeFirstExerciseDate")
		public HarmonizedData.HarmonizedDataBuilder setCdeFirstExerciseDate(Date _cdeFirstExerciseDate) {
			this.cdeFirstExerciseDate = _cdeFirstExerciseDate == null ? null : _cdeFirstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeFinalContractualSettlementDate")
		@RuneAttribute("cdeFinalContractualSettlementDate")
		public HarmonizedData.HarmonizedDataBuilder setCdeFinalContractualSettlementDate(Date _cdeFinalContractualSettlementDate) {
			this.cdeFinalContractualSettlementDate = _cdeFinalContractualSettlementDate == null ? null : _cdeFinalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeSettlementLocationLeg1")
		@RuneAttribute("cdeSettlementLocationLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeSettlementLocationLeg1(String _cdeSettlementLocationLeg1) {
			this.cdeSettlementLocationLeg1 = _cdeSettlementLocationLeg1 == null ? null : _cdeSettlementLocationLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeSettlementLocationLeg2")
		@RuneAttribute("cdeSettlementLocationLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeSettlementLocationLeg2(String _cdeSettlementLocationLeg2) {
			this.cdeSettlementLocationLeg2 = _cdeSettlementLocationLeg2 == null ? null : _cdeSettlementLocationLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeEffectiveDate")
		@RuneAttribute("cdeEffectiveDate")
		public HarmonizedData.HarmonizedDataBuilder setCdeEffectiveDate(Date _cdeEffectiveDate) {
			this.cdeEffectiveDate = _cdeEffectiveDate == null ? null : _cdeEffectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeExpirationDate")
		@RuneAttribute("cdeExpirationDate")
		public HarmonizedData.HarmonizedDataBuilder setCdeExpirationDate(Date _cdeExpirationDate) {
			this.cdeExpirationDate = _cdeExpirationDate == null ? null : _cdeExpirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdePlatformIdentifier")
		@RuneAttribute("cdePlatformIdentifier")
		public HarmonizedData.HarmonizedDataBuilder setCdePlatformIdentifier(String _cdePlatformIdentifier) {
			this.cdePlatformIdentifier = _cdePlatformIdentifier == null ? null : _cdePlatformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public HarmonizedData.HarmonizedDataBuilder setPrimeBrokerageTransactionIndicator(Boolean _primeBrokerageTransactionIndicator) {
			this.primeBrokerageTransactionIndicator = _primeBrokerageTransactionIndicator == null ? null : _primeBrokerageTransactionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("swapReportingJurisdiction")
		@RuneAttribute("swapReportingJurisdiction")
		public HarmonizedData.HarmonizedDataBuilder setSwapReportingJurisdiction(String _swapReportingJurisdiction) {
			this.swapReportingJurisdiction = _swapReportingJurisdiction == null ? null : _swapReportingJurisdiction;
			return this;
		}
		
		@Override
		@RosettaAttribute("newSdrIdentifier")
		@RuneAttribute("newSdrIdentifier")
		public HarmonizedData.HarmonizedDataBuilder setNewSdrIdentifier(String _newSdrIdentifier) {
			this.newSdrIdentifier = _newSdrIdentifier == null ? null : _newSdrIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public HarmonizedData.HarmonizedDataBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
			this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceValueLeg1")
		@RuneAttribute("lastFloatingReferenceValueLeg1")
		public HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceValueLeg1(BigDecimal _lastFloatingReferenceValueLeg1) {
			this.lastFloatingReferenceValueLeg1 = _lastFloatingReferenceValueLeg1 == null ? null : _lastFloatingReferenceValueLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceResetDateLeg1")
		@RuneAttribute("lastFloatingReferenceResetDateLeg1")
		public HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceResetDateLeg1(Date _lastFloatingReferenceResetDateLeg1) {
			this.lastFloatingReferenceResetDateLeg1 = _lastFloatingReferenceResetDateLeg1 == null ? null : _lastFloatingReferenceResetDateLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public HarmonizedData.HarmonizedDataBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
			this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceValueLeg2")
		@RuneAttribute("lastFloatingReferenceValueLeg2")
		public HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceValueLeg2(BigDecimal _lastFloatingReferenceValueLeg2) {
			this.lastFloatingReferenceValueLeg2 = _lastFloatingReferenceValueLeg2 == null ? null : _lastFloatingReferenceValueLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("lastFloatingReferenceResetDateLeg2")
		@RuneAttribute("lastFloatingReferenceResetDateLeg2")
		public HarmonizedData.HarmonizedDataBuilder setLastFloatingReferenceResetDateLeg2(Date _lastFloatingReferenceResetDateLeg2) {
			this.lastFloatingReferenceResetDateLeg2 = _lastFloatingReferenceResetDateLeg2 == null ? null : _lastFloatingReferenceResetDateLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeDelta")
		@RuneAttribute("cdeDelta")
		public HarmonizedData.HarmonizedDataBuilder setCdeDelta(BigDecimal _cdeDelta) {
			this.cdeDelta = _cdeDelta == null ? null : _cdeDelta;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public HarmonizedData.HarmonizedDataBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public HarmonizedData.HarmonizedDataBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		@RuneAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		public HarmonizedData.HarmonizedDataBuilder setLargeNotionalOffFacilitySwapElectionIndicator(Boolean _largeNotionalOffFacilitySwapElectionIndicator) {
			this.largeNotionalOffFacilitySwapElectionIndicator = _largeNotionalOffFacilitySwapElectionIndicator == null ? null : _largeNotionalOffFacilitySwapElectionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmAnonymousExecutionIndicator")
		@RuneAttribute("sefOrDcmAnonymousExecutionIndicator")
		public HarmonizedData.HarmonizedDataBuilder setSefOrDcmAnonymousExecutionIndicator(Boolean _sefOrDcmAnonymousExecutionIndicator) {
			this.sefOrDcmAnonymousExecutionIndicator = _sefOrDcmAnonymousExecutionIndicator == null ? null : _sefOrDcmAnonymousExecutionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("blockTradeElectionIndicator")
		@RuneAttribute("blockTradeElectionIndicator")
		public HarmonizedData.HarmonizedDataBuilder setBlockTradeElectionIndicator(Boolean _blockTradeElectionIndicator) {
			this.blockTradeElectionIndicator = _blockTradeElectionIndicator == null ? null : _blockTradeElectionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmIndicator")
		@RuneAttribute("sefOrDcmIndicator")
		public HarmonizedData.HarmonizedDataBuilder setSefOrDcmIndicator(Boolean _sefOrDcmIndicator) {
			this.sefOrDcmIndicator = _sefOrDcmIndicator == null ? null : _sefOrDcmIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("mandatoryClearingIndicator")
		@RuneAttribute("mandatoryClearingIndicator")
		public HarmonizedData.HarmonizedDataBuilder setMandatoryClearingIndicator(Boolean _mandatoryClearingIndicator) {
			this.mandatoryClearingIndicator = _mandatoryClearingIndicator == null ? null : _mandatoryClearingIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("sdMspIndicatorCounterparty1")
		@RuneAttribute("sdMspIndicatorCounterparty1")
		public HarmonizedData.HarmonizedDataBuilder setSdMspIndicatorCounterparty1(Boolean _sdMspIndicatorCounterparty1) {
			this.sdMspIndicatorCounterparty1 = _sdMspIndicatorCounterparty1 == null ? null : _sdMspIndicatorCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("sdMspIndicatorCounterparty2")
		@RuneAttribute("sdMspIndicatorCounterparty2")
		public HarmonizedData.HarmonizedDataBuilder setSdMspIndicatorCounterparty2(Boolean _sdMspIndicatorCounterparty2) {
			this.sdMspIndicatorCounterparty2 = _sdMspIndicatorCounterparty2 == null ? null : _sdMspIndicatorCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityContractIndicator")
		@RuneAttribute("physicalCommodityContractIndicator")
		public HarmonizedData.HarmonizedDataBuilder setPhysicalCommodityContractIndicator(Boolean _physicalCommodityContractIndicator) {
			this.physicalCommodityContractIndicator = _physicalCommodityContractIndicator == null ? null : _physicalCommodityContractIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("changeInNotionalAmount1")
		@RuneAttribute("changeInNotionalAmount1")
		public HarmonizedData.HarmonizedDataBuilder setChangeInNotionalAmount1(BigDecimal _changeInNotionalAmount1) {
			this.changeInNotionalAmount1 = _changeInNotionalAmount1 == null ? null : _changeInNotionalAmount1;
			return this;
		}
		
		@Override
		@RosettaAttribute("changeInNotionalAmount2")
		@RuneAttribute("changeInNotionalAmount2")
		public HarmonizedData.HarmonizedDataBuilder setChangeInNotionalAmount2(BigDecimal _changeInNotionalAmount2) {
			this.changeInNotionalAmount2 = _changeInNotionalAmount2 == null ? null : _changeInNotionalAmount2;
			return this;
		}
		
		@Override
		@RosettaAttribute("changeInLeg1NotionalQuantity")
		@RuneAttribute("changeInLeg1NotionalQuantity")
		public HarmonizedData.HarmonizedDataBuilder setChangeInLeg1NotionalQuantity(BigDecimal _changeInLeg1NotionalQuantity) {
			this.changeInLeg1NotionalQuantity = _changeInLeg1NotionalQuantity == null ? null : _changeInLeg1NotionalQuantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("changeInLeg2NotionalQuantity")
		@RuneAttribute("changeInLeg2NotionalQuantity")
		public HarmonizedData.HarmonizedDataBuilder setChangeInLeg2NotionalQuantity(BigDecimal _changeInLeg2NotionalQuantity) {
			this.changeInLeg2NotionalQuantity = _changeInLeg2NotionalQuantity == null ? null : _changeInLeg2NotionalQuantity;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeCryptoAssetUnderlyingIndicatorLeg1")
		@RuneAttribute("cdeCryptoAssetUnderlyingIndicatorLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeCryptoAssetUnderlyingIndicatorLeg1(Boolean _cdeCryptoAssetUnderlyingIndicatorLeg1) {
			this.cdeCryptoAssetUnderlyingIndicatorLeg1 = _cdeCryptoAssetUnderlyingIndicatorLeg1 == null ? null : _cdeCryptoAssetUnderlyingIndicatorLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeCryptoAssetUnderlyingIndicatorLeg2")
		@RuneAttribute("cdeCryptoAssetUnderlyingIndicatorLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeCryptoAssetUnderlyingIndicatorLeg2(Boolean _cdeCryptoAssetUnderlyingIndicatorLeg2) {
			this.cdeCryptoAssetUnderlyingIndicatorLeg2 = _cdeCryptoAssetUnderlyingIndicatorLeg2 == null ? null : _cdeCryptoAssetUnderlyingIndicatorLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeCustomBasketCode")
		@RuneAttribute("cdeCustomBasketCode")
		public HarmonizedData.HarmonizedDataBuilder setCdeCustomBasketCode(String _cdeCustomBasketCode) {
			this.cdeCustomBasketCode = _cdeCustomBasketCode == null ? null : _cdeCustomBasketCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherLeg1")
		@RuneAttribute("underlierIdOtherLeg1")
		public HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherLeg1(String _underlierIdOtherLeg1) {
			this.underlierIdOtherLeg1 = _underlierIdOtherLeg1 == null ? null : _underlierIdOtherLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherLeg2")
		@RuneAttribute("underlierIdOtherLeg2")
		public HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherLeg2(String _underlierIdOtherLeg2) {
			this.underlierIdOtherLeg2 = _underlierIdOtherLeg2 == null ? null : _underlierIdOtherLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherSourceLeg1")
		@RuneAttribute("underlierIdOtherSourceLeg1")
		public HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherSourceLeg1(String _underlierIdOtherSourceLeg1) {
			this.underlierIdOtherSourceLeg1 = _underlierIdOtherSourceLeg1 == null ? null : _underlierIdOtherSourceLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIdOtherSourceLeg2")
		@RuneAttribute("underlierIdOtherSourceLeg2")
		public HarmonizedData.HarmonizedDataBuilder setUnderlierIdOtherSourceLeg2(String _underlierIdOtherSourceLeg2) {
			this.underlierIdOtherSourceLeg2 = _underlierIdOtherSourceLeg2 == null ? null : _underlierIdOtherSourceLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetTradingPlatformIdLeg1")
		@RuneAttribute("cdeUnderlyingAssetTradingPlatformIdLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetTradingPlatformIdLeg1(String _cdeUnderlyingAssetTradingPlatformIdLeg1) {
			this.cdeUnderlyingAssetTradingPlatformIdLeg1 = _cdeUnderlyingAssetTradingPlatformIdLeg1 == null ? null : _cdeUnderlyingAssetTradingPlatformIdLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetTradingPlatformIdLeg2")
		@RuneAttribute("cdeUnderlyingAssetTradingPlatformIdLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetTradingPlatformIdLeg2(String _cdeUnderlyingAssetTradingPlatformIdLeg2) {
			this.cdeUnderlyingAssetTradingPlatformIdLeg2 = _cdeUnderlyingAssetTradingPlatformIdLeg2 == null ? null : _cdeUnderlyingAssetTradingPlatformIdLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetPriceSourceLeg1")
		@RuneAttribute("cdeUnderlyingAssetPriceSourceLeg1")
		public HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetPriceSourceLeg1(String _cdeUnderlyingAssetPriceSourceLeg1) {
			this.cdeUnderlyingAssetPriceSourceLeg1 = _cdeUnderlyingAssetPriceSourceLeg1 == null ? null : _cdeUnderlyingAssetPriceSourceLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdeUnderlyingAssetPriceSourceLeg2")
		@RuneAttribute("cdeUnderlyingAssetPriceSourceLeg2")
		public HarmonizedData.HarmonizedDataBuilder setCdeUnderlyingAssetPriceSourceLeg2(String _cdeUnderlyingAssetPriceSourceLeg2) {
			this.cdeUnderlyingAssetPriceSourceLeg2 = _cdeUnderlyingAssetPriceSourceLeg2 == null ? null : _cdeUnderlyingAssetPriceSourceLeg2;
			return this;
		}
		
		@Override
		public HarmonizedData build() {
			return new HarmonizedData.HarmonizedDataImpl(this);
		}
		
		@Override
		public HarmonizedData.HarmonizedDataBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HarmonizedData.HarmonizedDataBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getLeg2CommodityInstrumentId()!=null) return true;
			if (getLeg2CommodityUnderlyerId()!=null) return true;
			if (getLeg2CommodityUnderlyerDetails()!=null) return true;
			if (getLeg2CommodityUnitOfMeasure()!=null) return true;
			if (getLeg2CommodityCurrency()!=null) return true;
			if (getLeg2CommodityExchangeId()!=null) return true;
			if (getLeg1CommodityRateSource()!=null) return true;
			if (getLeg1CommodityRateSourcePage()!=null) return true;
			if (getLeg2SpecifiedPrice()!=null) return true;
			if (getCommencementDateUnadjusted()!=null) return true;
			if (getExerciseExpirationDateUnadjusted()!=null) return true;
			if (getExpirationDateUnadjusted()!=null) return true;
			if (getLeg2NotionalQuantityFrequency()!=null) return true;
			if (getLeg2NotionalQuantity()!=null) return true;
			if (getLeg2TotalNotionalQuantity()!=null) return true;
			if (getLeg2SpreadAmount()!=null) return true;
			if (getLeg2SpreadCurrency()!=null) return true;
			if (getScheduledTerminationDateAdjusted()!=null) return true;
			if (getLeg1PartyPayer()!=null) return true;
			if (getLeg2PartyPayer()!=null) return true;
			if (getLeg1CommodityInstrumentId()!=null) return true;
			if (getLeg1CommodityUnderlyerId()!=null) return true;
			if (getLeg1CommodityUnitOfMeasure()!=null) return true;
			if (getLeg1CommodityExchangeId()!=null) return true;
			if (getLeg2CommodityRateSource()!=null) return true;
			if (getLeg1EffectiveDateUnadjusted()!=null) return true;
			if (getLeg2EffectiveDateUnadjusted()!=null) return true;
			if (getCoProductType()!=null) return true;
			if (getTotalQuantityUnit()!=null) return true;
			if (getTotalQuantity()!=null) return true;
			if (getFixedPrice()!=null) return true;
			if (getFixedPriceCurrency()!=null) return true;
			if (getLeg1NotionalQuantityUnit()!=null) return true;
			if (getLeg1NotionalQuantityFrequency()!=null) return true;
			if (getLeg1NotionalQuantity()!=null) return true;
			if (getLeg1TotalNotionalQuantity()!=null) return true;
			if (getLeg1CommodityCurrency()!=null) return true;
			if (getLeg1SpecifiedPrice()!=null) return true;
			if (getLeg1SpreadCurrency()!=null) return true;
			if (getLeg1SpreadAmount()!=null) return true;
			if (getLeg2NotionalQuantityUnit()!=null) return true;
			if (getLeg2PartyReceiver()!=null) return true;
			if (getLeg1PartyReceiver()!=null) return true;
			if (getCoalSource()!=null) return true;
			if (getLeg2Quantity()!=null) return true;
			if (getCommodityBase()!=null) return true;
			if (getCommodityDetails()!=null) return true;
			if (getInterconnectionPoint()!=null) return true;
			if (getLoadType()!=null) return true;
			if (getFixedPriceUnit()!=null) return true;
			if (getExercisePaymentDateUnadjusted()!=null) return true;
			if (getLeg1PaymentDatesUnadjusted()!=null) return true;
			if (getLeg2PaymentDateUnadjusted()!=null) return true;
			if (getSettlementDateUnadjusted()!=null) return true;
			if (getDeliveryLocation()!=null) return true;
			if (getLeg2QuantityUnit()!=null) return true;
			if (getLeg1CommodityUnderlyerDetails()!=null) return true;
			if (getLeg2CommodityRateSourcePage()!=null) return true;
			if (getValueDate()!=null) return true;
			if (getGtrQuantityUnit()!=null) return true;
			if (getAttachmentPoint()!=null) return true;
			if (getExhaustionPoint()!=null) return true;
			if (getMthToDefault()!=null) return true;
			if (getNthToDefault()!=null) return true;
			if (getSeniority()!=null) return true;
			if (getSeries()!=null) return true;
			if (getCrversion()!=null) return true;
			if (getTranche()!=null) return true;
			if (getIndexFactor()!=null) return true;
			if (getReferenceObligation()!=null) return true;
			if (getReferenceObligationIdType()!=null) return true;
			if (getUnderlyingFixedRatePayerBuyer()!=null) return true;
			if (getUnderlyingFloatRatePayerSeller()!=null) return true;
			if (getUnderlyingAssetExchangeId()!=null) return true;
			if (getUnderlyingAssetNumberOfUnits()!=null) return true;
			if (getOptionalEarlyTerminationType()!=null) return true;
			if (getOptionalEarlyTerminationElectingPartyValue()!=null) return true;
			if (getOptionalEarlyTerminationIndicator()!=null) return true;
			if (getUnderlyingAssetFloatingAmountPayer()!=null) return true;
			if (getUnderlyingAssetFloatingAmountReceiver()!=null) return true;
			if (getFloatingRateOption()!=null) return true;
			if (getUnderlyingAssetFloatingLegSpread()!=null) return true;
			if (getLeg2DesignatedMaturityPeriod()!=null) return true;
			if (getLeg2DesignatedMaturityPeriodMultiplier()!=null) return true;
			if (getUnderlyingAssetEquityAmountPayer()!=null) return true;
			if (getUnderlyingAssetEquityAmountReceiver()!=null) return true;
			if (getUnderlyingAssetInitialPriceCurrency()!=null) return true;
			if (getLeg1ValuationDates()!=null) return true;
			if (getLeg1TypeOfReturn()!=null) return true;
			if (getObservationStartDate()!=null) return true;
			if (getVarianceAmount()!=null) return true;
			if (getVolatilityStrikePrice()!=null) return true;
			if (getVarianceStrikePrice()!=null) return true;
			if (getVarianceCapFactor()!=null) return true;
			if (getReferenceCurrency()!=null) return true;
			if (getSpecialDividendsIndicator()!=null) return true;
			if (getMaterialNoncashDividendIndicator()!=null) return true;
			if (getNumberOfSharesUnits()!=null) return true;
			if (getDividendAmountPayer()!=null) return true;
			if (getDividendAmountReceiver()!=null) return true;
			if (getFixedAmountPayer()!=null) return true;
			if (getFixedAmountReceiver()!=null) return true;
			if (getKnockInEvent()!=null) return true;
			if (getKnockOutEvent()!=null) return true;
			if (getKnockInPrice()!=null) return true;
			if (getKnockOutPrice()!=null) return true;
			if (getBarrierType()!=null) return true;
			if (getEarliestExecutionTime()!=null) return true;
			if (getExchangeRate()!=null) return true;
			if (getExchangeRateBasisCurrency1()!=null) return true;
			if (getExchangeRateBasisCurrency2()!=null) return true;
			if (getExecutionPeriodStartDate()!=null) return true;
			if (getPayoutStyle()!=null) return true;
			if (getRateQuoteBasis1()!=null) return true;
			if (getSettlementFixingDate()!=null) return true;
			if (getSwapLinkId()!=null) return true;
			if (getTriggerCondition()!=null) return true;
			if (getTriggerCondition2()!=null) return true;
			if (getTriggerRate()!=null) return true;
			if (getTriggerRate2()!=null) return true;
			if (getRateQuoteBasis2()!=null) return true;
			if (getForwardExchangeRate()!=null) return true;
			if (getBarrierType2()!=null) return true;
			if (getCancelationOptionBuyer()!=null) return true;
			if (getCancelationOptionCommencementDate()!=null) return true;
			if (getCancelationOptionExerciseStyleType()!=null) return true;
			if (getCancelationOptionExpirationDate()!=null) return true;
			if (getCancelationOptionInitialFeeCurrency()!=null) return true;
			if (getCancelationOptionInitialFeePayer()!=null) return true;
			if (getCancelationOptionPremiumAmount()!=null) return true;
			if (getCancelationOptionSeller()!=null) return true;
			if (getCapRateInitial()!=null) return true;
			if (getCouponType()!=null) return true;
			if (getFinalPrincipalExchangeIndicatorAtTermination()!=null) return true;
			if (getFloorRateInitial()!=null) return true;
			if (getFraDiscountingType()!=null) return true;
			if (getInflationIndexInitialLevel()!=null) return true;
			if (getInflationIndexMainPublication()!=null) return true;
			if (getInflationInterpolationMethod()!=null) return true;
			if (getInflationLagDayType()!=null) return true;
			if (getInflationLagPeriod()!=null) return true;
			if (getInflationRateSourceName()!=null) return true;
			if (getInitialPrincipalExchangeIndicator()!=null) return true;
			if (getIntermediatePrincipalExchangeIndicator()!=null) return true;
			if (getLeg1FloatingRateIndex()!=null) return true;
			if (getLeg1FloatingRateInitialSpread()!=null) return true;
			if (getLeg1FloatingRateMultiplierInitialValue()!=null) return true;
			if (getLeg1FloatingRateTenorPeriod()!=null) return true;
			if (getLeg1FloatingRateTenorPeriodMultiplier()!=null) return true;
			if (getLeg1KnownAmount()!=null) return true;
			if (getLeg1KnownAmountCurrency()!=null) return true;
			if (getLeg1ReferenceCurrency()!=null) return true;
			if (getLeg2FloatingRateIndex()!=null) return true;
			if (getLeg2FloatingRateInitialSpread()!=null) return true;
			if (getLeg2FloatingRateMultiplierInitialValue()!=null) return true;
			if (getLeg2FloatingRateTenorPeriod()!=null) return true;
			if (getLeg2FloatingRateTenorPeriodMultiplier()!=null) return true;
			if (getLeg2KnownAmount()!=null) return true;
			if (getLeg2KnownAmountCurrency()!=null) return true;
			if (getLeg2ReferenceCurrency()!=null) return true;
			if (getMandatoryEarlyTerminationDate()!=null) return true;
			if (getMandatoryEarlyTerminationDateTenorPeriod()!=null) return true;
			if (getMandatoryEarlyTerminationDateTenorPeriodMultiplier()!=null) return true;
			if (getNotionalUnits()!=null) return true;
			if (getOptionalEarlyTerminationCommencementDate()!=null) return true;
			if (getOptionalEarlyTerminationExerciseStyle()!=null) return true;
			if (getOptionalEarlyTerminationExpirationDate()!=null) return true;
			if (getPremiumReceiver()!=null) return true;
			if (getUnderlyingCouponRate()!=null) return true;
			if (getUnderlyingMaturityDate()!=null) return true;
			if (getUnderlyingProductId()!=null) return true;
			if (getInflationLagPeriodMultiplier()!=null) return true;
			if (getLeg1FixedRateNotation()!=null) return true;
			if (getLeg2FixedRateNotation()!=null) return true;
			if (getSwaptionStraddleIndicator()!=null) return true;
			if (getSinglePartyEarlyTerminationBuyer()!=null) return true;
			if (getLeg1EffectiveDate()!=null) return true;
			if (getAction()!=null) return true;
			if (getClearingStatus()!=null) return true;
			if (getEffectiveDate1()!=null) return true;
			if (getExecutionVenueType()!=null) return true;
			if (getNonStandardTradeIndicator()!=null) return true;
			if (getNotionalAmount1()!=null) return true;
			if (getNotionalCurrency1()!=null) return true;
			if (getPrice1Price()!=null) return true;
			if (getPrice1Type()!=null) return true;
			if (getPrice1Units()!=null) return true;
			if (getScheduledTerminationDate1()!=null) return true;
			if (getTradeDate()!=null) return true;
			if (getTradeParty1CollateralizationType()!=null) return true;
			if (getTradeParty1EventId()!=null) return true;
			if (getTradeParty2CollateralizationType()!=null) return true;
			if (getTradeParty2EventId()!=null) return true;
			if (getEmbeddedOptionOnSwap()!=null) return true;
			if (getExpirationDate()!=null) return true;
			if (getNotionalAmount2()!=null) return true;
			if (getNotionalCurrency2()!=null) return true;
			if (getPremiumAmount()!=null) return true;
			if (getPremiumCurrency()!=null) return true;
			if (getVersion()!=null) return true;
			if (getComment1()!=null) return true;
			if (getOptionStyle()!=null) return true;
			if (getOptionType()!=null) return true;
			if (getSettlementCurrency1()!=null) return true;
			if (getCommencementDate()!=null) return true;
			if (getDayCountFraction1()!=null) return true;
			if (getLeg2DayCountFraction()!=null) return true;
			if (getLeg2EffectiveDate()!=null) return true;
			if (getLeg2ResetFrequencyPeriod()!=null) return true;
			if (getLeg2ResetFrequencyPeriodMultiplier()!=null) return true;
			if (getLeg2SettlementCurrency()!=null) return true;
			if (getLeg2ScheduledTerminationDate()!=null) return true;
			if (getNumberOfOptions()!=null) return true;
			if (getOptionEntitlement()!=null) return true;
			if (getOriginalExecutionTimestamp()!=null) return true;
			if (getPayment1Date()!=null) return true;
			if (getPayment1FrequencyPeriod()!=null) return true;
			if (getPayment1FrequencyPeriodMultiplier()!=null) return true;
			if (getPayment2Date()!=null) return true;
			if (getPayment2FrequencyPeriod()!=null) return true;
			if (getPayment2FrequencyPeriodMultiplier()!=null) return true;
			if (getResetFrequencyPeriod1()!=null) return true;
			if (getResetFrequencyPeriodMultiplier1()!=null) return true;
			if (getSettlementDate()!=null) return true;
			if (getStrikePrice()!=null) return true;
			if (getStrikePriceUnits()!=null) return true;
			if (getAsOfDateTime()!=null) return true;
			if (getClearingVenueId()!=null) return true;
			if (getClearingVenueIdType()!=null) return true;
			if (getCompressedTradeIndicator()!=null) return true;
			if (getConfirmationMethod()!=null) return true;
			if (getConfirmationPlatformId()!=null) return true;
			if (getConfirmationPlatformTradeId()!=null) return true;
			if (getExecutionVenueId()!=null) return true;
			if (getExecutionVenueIdType()!=null) return true;
			if (getPostTradeEffectiveDate()!=null) return true;
			if (getPriorUsiId()!=null) return true;
			if (getPriorUsiIdPrefix()!=null) return true;
			if (getPriorUtiId()!=null) return true;
			if (getPriorUtiIdPrefix()!=null) return true;
			if (getTradeParty1BranchLocation()!=null) return true;
			if (getTradeParty1ClearingBrokerId()!=null) return true;
			if (getTradeParty1ClearingBrokerIdType()!=null) return true;
			if (getTradeParty1DeskLocation()!=null) return true;
			if (getTradeParty1Domicile()!=null) return true;
			if (getTradeParty1IndustrialSectorType()!=null) return true;
			if (getTradeParty2BranchLocation()!=null) return true;
			if (getTradeParty2DeskLocation()!=null) return true;
			if (getTradeParty2Domicile()!=null) return true;
			if (getTradeParty2IndustrialSectorType()!=null) return true;
			if (getSellerPayer2()!=null) return true;
			if (getBuyerPayer1()!=null) return true;
			if (getTradeParty1HkCounterpartyOrigin()!=null) return true;
			if (getLeg2SettlementDate()!=null) return true;
			if (getLeg1FixedRateInitial()!=null) return true;
			if (getLeg2FixedRateInitial()!=null) return true;
			if (getPayment1Amount()!=null) return true;
			if (getPayment1Currency()!=null) return true;
			if (getPayment1Payer()!=null) return true;
			if (getPayment1Receiver()!=null) return true;
			if (getPayment2Payer()!=null) return true;
			if (getPostTradeTransactionDate()!=null) return true;
			if (getSecondaryAssetClass()!=null) return true;
			if (getSettlementType()!=null) return true;
			if (getTradeParty1Name()!=null) return true;
			if (getTradeParty2Name()!=null) return true;
			if (getCcpValuationAmount()!=null) return true;
			if (getCcpValuationCurrency()!=null) return true;
			if (getCcpValuationDatetime()!=null) return true;
			if (getCcpValuationType()!=null) return true;
			if (getTradeParty1ValuationAmount()!=null) return true;
			if (getTradeParty1ValuationCurrency()!=null) return true;
			if (getTradeParty1ValuationDatetime()!=null) return true;
			if (getTradeParty1ValuationType()!=null) return true;
			if (getTradeParty2ValuationAmount()!=null) return true;
			if (getTradeParty2ValuationCurrency()!=null) return true;
			if (getTradeParty2ValuationDatetime()!=null) return true;
			if (getTradeParty2ValuationType()!=null) return true;
			if (getExecutionType()!=null) return true;
			if (getStrikePriceCurrency()!=null) return true;
			if (getPayment2Amount()!=null) return true;
			if (getTradeParty2HkCounterpartyOrigin()!=null) return true;
			if (getTradeParty1CountryOfTheOtherCounterparty()!=null) return true;
			if (getTradeParty2CountryOfTheOtherCounterparty()!=null) return true;
			if (getTradeParty1BrokerId()!=null) return true;
			if (getTradeParty2BrokerId()!=null) return true;
			if (getTradeParty1BeneficiaryIdType()!=null) return true;
			if (getTradeParty1BeneficiaryId()!=null) return true;
			if (getTradeParty2BeneficiaryIdType()!=null) return true;
			if (getTradeParty2BeneficiaryId()!=null) return true;
			if (getTradeParty1CounterpartySide()!=null) return true;
			if (getTradeParty2CounterpartySide()!=null) return true;
			if (getTradeParty1CollateralPortfolioCode()!=null) return true;
			if (getTradeParty2CollateralPortfolioCode()!=null) return true;
			if (getContractType()!=null) return true;
			if (getEuUnderlyingAssetIdType()!=null) return true;
			if (getProductClassification()!=null) return true;
			if (getComplexTradeComponentId()!=null) return true;
			if (getPriceMultiplier()!=null) return true;
			if (getQuantity()!=null) return true;
			if (getMasterAgreementType()!=null) return true;
			if (getMasterAgreementVersion()!=null) return true;
			if (getConfirmationDatetime()!=null) return true;
			if (getClearingDatetime()!=null) return true;
			if (getMaturityDateOfTheUnderlying()!=null) return true;
			if (getLevel()!=null) return true;
			if (getProductClassificationType()!=null) return true;
			if (getProductIdentificationType()!=null) return true;
			if (getProductIdentification()!=null) return true;
			if (getEuUnderlyingAssetId()!=null) return true;
			if (getReportTrackingNumber()!=null) return true;
			if (getTradeParty1BrokerIdType()!=null) return true;
			if (getTradeParty2BrokerIdType()!=null) return true;
			if (getTradeParty2ClearingBrokerIdType()!=null) return true;
			if (getTradeParty2ClearingBrokerId()!=null) return true;
			if (getTradeParty1ClearingThreshold()!=null) return true;
			if (getTradeParty2ClearingThreshold()!=null) return true;
			if (getTradeParty1CorporateSectorType()!=null) return true;
			if (getTradeParty2CorporateSectorType()!=null) return true;
			if (getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator()!=null) return true;
			if (getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator()!=null) return true;
			if (getIntragroupIndicator()!=null) return true;
			if (getTradeParty1TradingCapacity1()!=null) return true;
			if (getTradeParty2TradingCapacity1()!=null) return true;
			if (getCurrencyOfPrice()!=null) return true;
			if (getTradeParty1CollateralPortfolio()!=null) return true;
			if (getTradeParty2CollateralPortfolio()!=null) return true;
			if (getExecutionVenueMicCode()!=null) return true;
			if (getPayment2Currency()!=null) return true;
			if (getExpirationDateTimeBusinessCenter()!=null) return true;
			if (getExpirationTime()!=null) return true;
			if (getExpirationTimeType()!=null) return true;
			if (getTradeParty1TraderLocation()!=null) return true;
			if (getTradeParty2TraderLocation()!=null) return true;
			if (getPayment3ResetFrequencyPeriodMultiplier()!=null) return true;
			if (getPayment3ResetFrequencyPeriod()!=null) return true;
			if (getPayment4ResetFrequencyPeriodMultiplier()!=null) return true;
			if (getPayment4ResetFrequencyPeriod()!=null) return true;
			if (getPayment5ResetFrequencyPeriodMultiplier()!=null) return true;
			if (getPayment5ResetFrequencyPeriod()!=null) return true;
			if (getPayment1Type()!=null) return true;
			if (getPayment1Reference()!=null) return true;
			if (getPayment2Type()!=null) return true;
			if (getPayment2Reference()!=null) return true;
			if (getPayment3Payer()!=null) return true;
			if (getPayment3Reference()!=null) return true;
			if (getPayment3FrequencyPeriod()!=null) return true;
			if (getPayment3FrequencyPeriodMultiplier()!=null) return true;
			if (getPayment3Date()!=null) return true;
			if (getPayment4Reference()!=null) return true;
			if (getPayment4Payer()!=null) return true;
			if (getPayment4FrequencyPeriod()!=null) return true;
			if (getPayment4FrequencyPeriodMultiplier()!=null) return true;
			if (getPayment4Date()!=null) return true;
			if (getPayment5Reference()!=null) return true;
			if (getPayment5Payer()!=null) return true;
			if (getPayment5FrequencyPeriod()!=null) return true;
			if (getPayment5FrequencyPeriodMultiplier()!=null) return true;
			if (getPayment5Date()!=null) return true;
			if (getPayment3Type()!=null) return true;
			if (getPremiumPayer()!=null) return true;
			if (getPremiumPaymentDateUnadjusted()!=null) return true;
			if (getTradeParty1NatureOfTheReportingCounterparty()!=null) return true;
			if (getTradeParty2NatureOfTheReportingCounterparty()!=null) return true;
			if (getReservedParticipantUse1()!=null) return true;
			if (getReservedParticipantUse2()!=null) return true;
			if (getReservedParticipantUse3()!=null) return true;
			if (getReservedParticipantUse4()!=null) return true;
			if (getReservedParticipantUse5()!=null) return true;
			if (getLeg1TerminationDate()!=null) return true;
			if (getAllocationType()!=null) return true;
			if (getCalculationBasis()!=null) return true;
			if (getClearingExceptionPartyId()!=null) return true;
			if (getClearingExceptionPartyIdType()!=null) return true;
			if (getClearingExceptionType()!=null) return true;
			if (getClearingMemberClientAccountId()!=null) return true;
			if (getClearingReceiptDatetime()!=null) return true;
			if (getClearingSwapSdrLeiId()!=null) return true;
			if (getClearingSwapUtiId()!=null) return true;
			if (getCollateralReportingDate()!=null) return true;
			if (getCollateralValuationDatetime()!=null) return true;
			if (getComment2()!=null) return true;
			if (getCommodityStrikePriceUnit()!=null) return true;
			if (getExecutionAgentMaskingIndicator()!=null) return true;
			if (getFeeInCurrency()!=null) return true;
			if (getFeeOutCurrency()!=null) return true;
			if (getFloatingRatePaymentFrequencyLeg1Multiplier()!=null) return true;
			if (getFloatingRatePaymentFrequencyLeg1TimePeriod()!=null) return true;
			if (getFloatingRatePaymentFrequencyLeg2Multiplier()!=null) return true;
			if (getFloatingRatePaymentFrequencyLeg2TimePeriod()!=null) return true;
			if (getFrequencyOfPayment()!=null) return true;
			if (getInteraffiliate()!=null) return true;
			if (getLargeTradeIndicator()!=null) return true;
			if (getLeg1EffectiveDateAdjusted()!=null) return true;
			if (getLeg1FinalValuationDate()!=null) return true;
			if (getLeg1SettlementPeriod()!=null) return true;
			if (getLeg2EffectiveDateAdjusted()!=null) return true;
			if (getLeg2PaymentTermsFrequencyPeriod()!=null) return true;
			if (getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier()!=null) return true;
			if (getLeg2SettlementType()!=null) return true;
			if (getLeg2UnderlyingAssetId()!=null) return true;
			if (getLeg2UnderlyingAssetIdType()!=null) return true;
			if (getLeg2UnderlyingAssetName()!=null) return true;
			if (getMaturityDate()!=null) return true;
			if (getOptionalEarlyTerminationDate()!=null) return true;
			if (getOptionCommodityCurrency()!=null) return true;
			if (getOptionCommodityExchangeId()!=null) return true;
			if (getOptionCommodityInstrumentId()!=null) return true;
			if (getOptionCommodityRateSource()!=null) return true;
			if (getOptionCommodityRateSourcePage()!=null) return true;
			if (getOptionCommodityUnderlyerDetails()!=null) return true;
			if (getOptionCommodityUnderlyerId()!=null) return true;
			if (getOptionCommodityUnitOfMeasure()!=null) return true;
			if (getOptionSpecifiedPrice()!=null) return true;
			if (getOptionSpreadAmount()!=null) return true;
			if (getOptionSpreadCurrency()!=null) return true;
			if (getOptionSpreadSchedule()!=null) return true;
			if (getOrigin()!=null) return true;
			if (getOriginalSwapSdrId()!=null) return true;
			if (getOriginalSwapSdrIdType()!=null) return true;
			if (getPaymentFrequencyPeriodLeg1()!=null) return true;
			if (getPaymentFrequencyPeriodLeg2()!=null) return true;
			if (getPaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getPaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getPremiumPayerPrefix()!=null) return true;
			if (getPrice1Currency()!=null) return true;
			if (getPrice2Price()!=null) return true;
			if (getPrice2Type()!=null) return true;
			if (getPrice2Units()!=null) return true;
			if (getPrice3Price()!=null) return true;
			if (getPrice3Type()!=null) return true;
			if (getPrice3Units()!=null) return true;
			if (getPrice4Price()!=null) return true;
			if (getPrice4Type()!=null) return true;
			if (getPrice4Units()!=null) return true;
			if (getPricingContext()!=null) return true;
			if (getPriorUsiType()!=null) return true;
			if (getPriorUtiType()!=null) return true;
			if (getRecoveryPrice()!=null) return true;
			if (getSendToDataCenterCode()!=null) return true;
			if (getStrikePriceType()!=null) return true;
			if (getSubAssetClassForOtherCommodity()!=null) return true;
			if (getTradeParty1CftcFinancialEntityStatus()!=null) return true;
			if (getTradeParty1CollateralAmount()!=null) return true;
			if (getTradeParty1CollateralCurrency()!=null) return true;
			if (getTradeParty1MandatoryDelegatedReporting()!=null) return true;
			if (getTradeParty1Role()!=null) return true;
			if (getTradeParty2CftcFinancialEntityStatus()!=null) return true;
			if (getTradeParty2CollateralAmount()!=null) return true;
			if (getTradeParty2CollateralCurrency()!=null) return true;
			if (getTradeParty2MandatoryDelegatedReporting()!=null) return true;
			if (getTradeParty2Role()!=null) return true;
			if (getUpfrontPayment()!=null) return true;
			if (getVerificationMethod()!=null) return true;
			if (getResponsibleDataSubmitterId()!=null) return true;
			if (getResponsibleDataSubmitterIdType()!=null) return true;
			if (getOriginalSwapUsi()!=null) return true;
			if (getOriginalSwapUti()!=null) return true;
			if (getCdeReceiverIdentifierLeg2()!=null) return true;
			if (getCounterparty1FederalEntityIndicator()!=null) return true;
			if (getCounterparty2FederalEntityIndicator()!=null) return true;
			if (getCustomBasketIndicator()!=null) return true;
			if (getNoaActionType()!=null) return true;
			if (getEventType()!=null) return true;
			if (getAmendmentIndicator()!=null) return true;
			if (getEventIdentifier()!=null) return true;
			if (getCdeCallAmountLeg1()!=null) return true;
			if (getCdeCallAmountLeg2()!=null) return true;
			if (getCdeCallCurrencyLeg1()!=null) return true;
			if (getCdeCallCurrencyLeg2()!=null) return true;
			if (getCdePutAmountLeg1()!=null) return true;
			if (getCdePutAmountLeg2()!=null) return true;
			if (getCdePutCurrencyLeg1()!=null) return true;
			if (getCdePutCurrencyLeg2()!=null) return true;
			if (getLeg2QuantityFrequency()!=null) return true;
			if (getQuantityFrequencyMultiplierLeg1()!=null) return true;
			if (getQuantityFrequencyMultiplierLeg2()!=null) return true;
			if (getCdeQuantityUnitOfMeasureLeg1()!=null) return true;
			if (getCdeQuantityUnitOfMeasureLeg2()!=null) return true;
			if (getPackageIndicator()!=null) return true;
			if (getCdePackageIdentifier()!=null) return true;
			if (getCdePackageTransactionPrice()!=null) return true;
			if (getCdePackageTransactionPriceCurrency()!=null) return true;
			if (getCdePackageTransactionPriceNotation()!=null) return true;
			if (getCdePackageTransactionSpread()!=null) return true;
			if (getCdePackageTransactionSpreadCurrency()!=null) return true;
			if (getCdePackageTransactionSpreadNotation()!=null) return true;
			if (getCdeFixedRateDayCountConventionLeg1()!=null) return true;
			if (getCdeFixedRateDayCountConventionLeg2()!=null) return true;
			if (getCdeFloatingRateDayCountConventionLeg1()!=null) return true;
			if (getCdeFloatingRateDayCountConventionLeg2()!=null) return true;
			if (getFixingDateLeg1()!=null) return true;
			if (getFixingDateLeg2()!=null) return true;
			if (getCdeFixedRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getCdeFixedRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getCdeFloatingRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getCdeFloatingRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getPostPricedSwapIndicator()!=null) return true;
			if (getCdePriceCurrency()!=null) return true;
			if (getCdePriceNotation()!=null) return true;
			if (getCdeSpreadNotationLeg1()!=null) return true;
			if (getCdeSpreadNotationLeg2()!=null) return true;
			if (getCdeStrikePriceCurrency2()!=null) return true;
			if (getCdeStrikePriceNotation()!=null) return true;
			if (getCdeFirstExerciseDate()!=null) return true;
			if (getCdeFinalContractualSettlementDate()!=null) return true;
			if (getCdeSettlementLocationLeg1()!=null) return true;
			if (getCdeSettlementLocationLeg2()!=null) return true;
			if (getCdeEffectiveDate()!=null) return true;
			if (getCdeExpirationDate()!=null) return true;
			if (getCdePlatformIdentifier()!=null) return true;
			if (getPrimeBrokerageTransactionIndicator()!=null) return true;
			if (getSwapReportingJurisdiction()!=null) return true;
			if (getNewSdrIdentifier()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg1()!=null) return true;
			if (getLastFloatingReferenceValueLeg1()!=null) return true;
			if (getLastFloatingReferenceResetDateLeg1()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg2()!=null) return true;
			if (getLastFloatingReferenceValueLeg2()!=null) return true;
			if (getLastFloatingReferenceResetDateLeg2()!=null) return true;
			if (getCdeDelta()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getLargeNotionalOffFacilitySwapElectionIndicator()!=null) return true;
			if (getSefOrDcmAnonymousExecutionIndicator()!=null) return true;
			if (getBlockTradeElectionIndicator()!=null) return true;
			if (getSefOrDcmIndicator()!=null) return true;
			if (getMandatoryClearingIndicator()!=null) return true;
			if (getSdMspIndicatorCounterparty1()!=null) return true;
			if (getSdMspIndicatorCounterparty2()!=null) return true;
			if (getPhysicalCommodityContractIndicator()!=null) return true;
			if (getChangeInNotionalAmount1()!=null) return true;
			if (getChangeInNotionalAmount2()!=null) return true;
			if (getChangeInLeg1NotionalQuantity()!=null) return true;
			if (getChangeInLeg2NotionalQuantity()!=null) return true;
			if (getCdeCryptoAssetUnderlyingIndicatorLeg1()!=null) return true;
			if (getCdeCryptoAssetUnderlyingIndicatorLeg2()!=null) return true;
			if (getCdeCustomBasketCode()!=null) return true;
			if (getUnderlierIdOtherLeg1()!=null) return true;
			if (getUnderlierIdOtherLeg2()!=null) return true;
			if (getUnderlierIdOtherSourceLeg1()!=null) return true;
			if (getUnderlierIdOtherSourceLeg2()!=null) return true;
			if (getCdeUnderlyingAssetTradingPlatformIdLeg1()!=null) return true;
			if (getCdeUnderlyingAssetTradingPlatformIdLeg2()!=null) return true;
			if (getCdeUnderlyingAssetPriceSourceLeg1()!=null) return true;
			if (getCdeUnderlyingAssetPriceSourceLeg2()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HarmonizedData.HarmonizedDataBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			HarmonizedData.HarmonizedDataBuilder o = (HarmonizedData.HarmonizedDataBuilder) other;
			
			
			merger.mergeBasic(getLeg2CommodityInstrumentId(), o.getLeg2CommodityInstrumentId(), this::setLeg2CommodityInstrumentId);
			merger.mergeBasic(getLeg2CommodityUnderlyerId(), o.getLeg2CommodityUnderlyerId(), this::setLeg2CommodityUnderlyerId);
			merger.mergeBasic(getLeg2CommodityUnderlyerDetails(), o.getLeg2CommodityUnderlyerDetails(), this::setLeg2CommodityUnderlyerDetails);
			merger.mergeBasic(getLeg2CommodityUnitOfMeasure(), o.getLeg2CommodityUnitOfMeasure(), this::setLeg2CommodityUnitOfMeasure);
			merger.mergeBasic(getLeg2CommodityCurrency(), o.getLeg2CommodityCurrency(), this::setLeg2CommodityCurrency);
			merger.mergeBasic(getLeg2CommodityExchangeId(), o.getLeg2CommodityExchangeId(), this::setLeg2CommodityExchangeId);
			merger.mergeBasic(getLeg1CommodityRateSource(), o.getLeg1CommodityRateSource(), this::setLeg1CommodityRateSource);
			merger.mergeBasic(getLeg1CommodityRateSourcePage(), o.getLeg1CommodityRateSourcePage(), this::setLeg1CommodityRateSourcePage);
			merger.mergeBasic(getLeg2SpecifiedPrice(), o.getLeg2SpecifiedPrice(), this::setLeg2SpecifiedPrice);
			merger.mergeBasic(getCommencementDateUnadjusted(), o.getCommencementDateUnadjusted(), this::setCommencementDateUnadjusted);
			merger.mergeBasic(getExerciseExpirationDateUnadjusted(), o.getExerciseExpirationDateUnadjusted(), this::setExerciseExpirationDateUnadjusted);
			merger.mergeBasic(getExpirationDateUnadjusted(), o.getExpirationDateUnadjusted(), this::setExpirationDateUnadjusted);
			merger.mergeBasic(getLeg2NotionalQuantityFrequency(), o.getLeg2NotionalQuantityFrequency(), this::setLeg2NotionalQuantityFrequency);
			merger.mergeBasic(getLeg2NotionalQuantity(), o.getLeg2NotionalQuantity(), this::setLeg2NotionalQuantity);
			merger.mergeBasic(getLeg2TotalNotionalQuantity(), o.getLeg2TotalNotionalQuantity(), this::setLeg2TotalNotionalQuantity);
			merger.mergeBasic(getLeg2SpreadAmount(), o.getLeg2SpreadAmount(), this::setLeg2SpreadAmount);
			merger.mergeBasic(getLeg2SpreadCurrency(), o.getLeg2SpreadCurrency(), this::setLeg2SpreadCurrency);
			merger.mergeBasic(getScheduledTerminationDateAdjusted(), o.getScheduledTerminationDateAdjusted(), this::setScheduledTerminationDateAdjusted);
			merger.mergeBasic(getLeg1PartyPayer(), o.getLeg1PartyPayer(), this::setLeg1PartyPayer);
			merger.mergeBasic(getLeg2PartyPayer(), o.getLeg2PartyPayer(), this::setLeg2PartyPayer);
			merger.mergeBasic(getLeg1CommodityInstrumentId(), o.getLeg1CommodityInstrumentId(), this::setLeg1CommodityInstrumentId);
			merger.mergeBasic(getLeg1CommodityUnderlyerId(), o.getLeg1CommodityUnderlyerId(), this::setLeg1CommodityUnderlyerId);
			merger.mergeBasic(getLeg1CommodityUnitOfMeasure(), o.getLeg1CommodityUnitOfMeasure(), this::setLeg1CommodityUnitOfMeasure);
			merger.mergeBasic(getLeg1CommodityExchangeId(), o.getLeg1CommodityExchangeId(), this::setLeg1CommodityExchangeId);
			merger.mergeBasic(getLeg2CommodityRateSource(), o.getLeg2CommodityRateSource(), this::setLeg2CommodityRateSource);
			merger.mergeBasic(getLeg1EffectiveDateUnadjusted(), o.getLeg1EffectiveDateUnadjusted(), this::setLeg1EffectiveDateUnadjusted);
			merger.mergeBasic(getLeg2EffectiveDateUnadjusted(), o.getLeg2EffectiveDateUnadjusted(), this::setLeg2EffectiveDateUnadjusted);
			merger.mergeBasic(getCoProductType(), o.getCoProductType(), this::setCoProductType);
			merger.mergeBasic(getTotalQuantityUnit(), o.getTotalQuantityUnit(), this::setTotalQuantityUnit);
			merger.mergeBasic(getTotalQuantity(), o.getTotalQuantity(), this::setTotalQuantity);
			merger.mergeBasic(getFixedPrice(), o.getFixedPrice(), this::setFixedPrice);
			merger.mergeBasic(getFixedPriceCurrency(), o.getFixedPriceCurrency(), this::setFixedPriceCurrency);
			merger.mergeBasic(getLeg1NotionalQuantityUnit(), o.getLeg1NotionalQuantityUnit(), this::setLeg1NotionalQuantityUnit);
			merger.mergeBasic(getLeg1NotionalQuantityFrequency(), o.getLeg1NotionalQuantityFrequency(), this::setLeg1NotionalQuantityFrequency);
			merger.mergeBasic(getLeg1NotionalQuantity(), o.getLeg1NotionalQuantity(), this::setLeg1NotionalQuantity);
			merger.mergeBasic(getLeg1TotalNotionalQuantity(), o.getLeg1TotalNotionalQuantity(), this::setLeg1TotalNotionalQuantity);
			merger.mergeBasic(getLeg1CommodityCurrency(), o.getLeg1CommodityCurrency(), this::setLeg1CommodityCurrency);
			merger.mergeBasic(getLeg1SpecifiedPrice(), o.getLeg1SpecifiedPrice(), this::setLeg1SpecifiedPrice);
			merger.mergeBasic(getLeg1SpreadCurrency(), o.getLeg1SpreadCurrency(), this::setLeg1SpreadCurrency);
			merger.mergeBasic(getLeg1SpreadAmount(), o.getLeg1SpreadAmount(), this::setLeg1SpreadAmount);
			merger.mergeBasic(getLeg2NotionalQuantityUnit(), o.getLeg2NotionalQuantityUnit(), this::setLeg2NotionalQuantityUnit);
			merger.mergeBasic(getLeg2PartyReceiver(), o.getLeg2PartyReceiver(), this::setLeg2PartyReceiver);
			merger.mergeBasic(getLeg1PartyReceiver(), o.getLeg1PartyReceiver(), this::setLeg1PartyReceiver);
			merger.mergeBasic(getCoalSource(), o.getCoalSource(), this::setCoalSource);
			merger.mergeBasic(getLeg2Quantity(), o.getLeg2Quantity(), this::setLeg2Quantity);
			merger.mergeBasic(getCommodityBase(), o.getCommodityBase(), this::setCommodityBase);
			merger.mergeBasic(getCommodityDetails(), o.getCommodityDetails(), this::setCommodityDetails);
			merger.mergeBasic(getInterconnectionPoint(), o.getInterconnectionPoint(), this::setInterconnectionPoint);
			merger.mergeBasic(getLoadType(), o.getLoadType(), this::setLoadType);
			merger.mergeBasic(getFixedPriceUnit(), o.getFixedPriceUnit(), this::setFixedPriceUnit);
			merger.mergeBasic(getExercisePaymentDateUnadjusted(), o.getExercisePaymentDateUnadjusted(), this::setExercisePaymentDateUnadjusted);
			merger.mergeBasic(getLeg1PaymentDatesUnadjusted(), o.getLeg1PaymentDatesUnadjusted(), this::setLeg1PaymentDatesUnadjusted);
			merger.mergeBasic(getLeg2PaymentDateUnadjusted(), o.getLeg2PaymentDateUnadjusted(), this::setLeg2PaymentDateUnadjusted);
			merger.mergeBasic(getSettlementDateUnadjusted(), o.getSettlementDateUnadjusted(), this::setSettlementDateUnadjusted);
			merger.mergeBasic(getDeliveryLocation(), o.getDeliveryLocation(), this::setDeliveryLocation);
			merger.mergeBasic(getLeg2QuantityUnit(), o.getLeg2QuantityUnit(), this::setLeg2QuantityUnit);
			merger.mergeBasic(getLeg1CommodityUnderlyerDetails(), o.getLeg1CommodityUnderlyerDetails(), this::setLeg1CommodityUnderlyerDetails);
			merger.mergeBasic(getLeg2CommodityRateSourcePage(), o.getLeg2CommodityRateSourcePage(), this::setLeg2CommodityRateSourcePage);
			merger.mergeBasic(getValueDate(), o.getValueDate(), this::setValueDate);
			merger.mergeBasic(getGtrQuantityUnit(), o.getGtrQuantityUnit(), this::setGtrQuantityUnit);
			merger.mergeBasic(getAttachmentPoint(), o.getAttachmentPoint(), this::setAttachmentPoint);
			merger.mergeBasic(getExhaustionPoint(), o.getExhaustionPoint(), this::setExhaustionPoint);
			merger.mergeBasic(getMthToDefault(), o.getMthToDefault(), this::setMthToDefault);
			merger.mergeBasic(getNthToDefault(), o.getNthToDefault(), this::setNthToDefault);
			merger.mergeBasic(getSeniority(), o.getSeniority(), this::setSeniority);
			merger.mergeBasic(getSeries(), o.getSeries(), this::setSeries);
			merger.mergeBasic(getCrversion(), o.getCrversion(), this::setCrversion);
			merger.mergeBasic(getTranche(), o.getTranche(), this::setTranche);
			merger.mergeBasic(getIndexFactor(), o.getIndexFactor(), this::setIndexFactor);
			merger.mergeBasic(getReferenceObligation(), o.getReferenceObligation(), this::setReferenceObligation);
			merger.mergeBasic(getReferenceObligationIdType(), o.getReferenceObligationIdType(), this::setReferenceObligationIdType);
			merger.mergeBasic(getUnderlyingFixedRatePayerBuyer(), o.getUnderlyingFixedRatePayerBuyer(), this::setUnderlyingFixedRatePayerBuyer);
			merger.mergeBasic(getUnderlyingFloatRatePayerSeller(), o.getUnderlyingFloatRatePayerSeller(), this::setUnderlyingFloatRatePayerSeller);
			merger.mergeBasic(getUnderlyingAssetExchangeId(), o.getUnderlyingAssetExchangeId(), this::setUnderlyingAssetExchangeId);
			merger.mergeBasic(getUnderlyingAssetNumberOfUnits(), o.getUnderlyingAssetNumberOfUnits(), this::setUnderlyingAssetNumberOfUnits);
			merger.mergeBasic(getOptionalEarlyTerminationType(), o.getOptionalEarlyTerminationType(), this::setOptionalEarlyTerminationType);
			merger.mergeBasic(getOptionalEarlyTerminationElectingPartyValue(), o.getOptionalEarlyTerminationElectingPartyValue(), this::setOptionalEarlyTerminationElectingPartyValue);
			merger.mergeBasic(getOptionalEarlyTerminationIndicator(), o.getOptionalEarlyTerminationIndicator(), this::setOptionalEarlyTerminationIndicator);
			merger.mergeBasic(getUnderlyingAssetFloatingAmountPayer(), o.getUnderlyingAssetFloatingAmountPayer(), this::setUnderlyingAssetFloatingAmountPayer);
			merger.mergeBasic(getUnderlyingAssetFloatingAmountReceiver(), o.getUnderlyingAssetFloatingAmountReceiver(), this::setUnderlyingAssetFloatingAmountReceiver);
			merger.mergeBasic(getFloatingRateOption(), o.getFloatingRateOption(), this::setFloatingRateOption);
			merger.mergeBasic(getUnderlyingAssetFloatingLegSpread(), o.getUnderlyingAssetFloatingLegSpread(), this::setUnderlyingAssetFloatingLegSpread);
			merger.mergeBasic(getLeg2DesignatedMaturityPeriod(), o.getLeg2DesignatedMaturityPeriod(), this::setLeg2DesignatedMaturityPeriod);
			merger.mergeBasic(getLeg2DesignatedMaturityPeriodMultiplier(), o.getLeg2DesignatedMaturityPeriodMultiplier(), this::setLeg2DesignatedMaturityPeriodMultiplier);
			merger.mergeBasic(getUnderlyingAssetEquityAmountPayer(), o.getUnderlyingAssetEquityAmountPayer(), this::setUnderlyingAssetEquityAmountPayer);
			merger.mergeBasic(getUnderlyingAssetEquityAmountReceiver(), o.getUnderlyingAssetEquityAmountReceiver(), this::setUnderlyingAssetEquityAmountReceiver);
			merger.mergeBasic(getUnderlyingAssetInitialPriceCurrency(), o.getUnderlyingAssetInitialPriceCurrency(), this::setUnderlyingAssetInitialPriceCurrency);
			merger.mergeBasic(getLeg1ValuationDates(), o.getLeg1ValuationDates(), this::setLeg1ValuationDates);
			merger.mergeBasic(getLeg1TypeOfReturn(), o.getLeg1TypeOfReturn(), this::setLeg1TypeOfReturn);
			merger.mergeBasic(getObservationStartDate(), o.getObservationStartDate(), this::setObservationStartDate);
			merger.mergeBasic(getVarianceAmount(), o.getVarianceAmount(), this::setVarianceAmount);
			merger.mergeBasic(getVolatilityStrikePrice(), o.getVolatilityStrikePrice(), this::setVolatilityStrikePrice);
			merger.mergeBasic(getVarianceStrikePrice(), o.getVarianceStrikePrice(), this::setVarianceStrikePrice);
			merger.mergeBasic(getVarianceCapFactor(), o.getVarianceCapFactor(), this::setVarianceCapFactor);
			merger.mergeBasic(getReferenceCurrency(), o.getReferenceCurrency(), this::setReferenceCurrency);
			merger.mergeBasic(getSpecialDividendsIndicator(), o.getSpecialDividendsIndicator(), this::setSpecialDividendsIndicator);
			merger.mergeBasic(getMaterialNoncashDividendIndicator(), o.getMaterialNoncashDividendIndicator(), this::setMaterialNoncashDividendIndicator);
			merger.mergeBasic(getNumberOfSharesUnits(), o.getNumberOfSharesUnits(), this::setNumberOfSharesUnits);
			merger.mergeBasic(getDividendAmountPayer(), o.getDividendAmountPayer(), this::setDividendAmountPayer);
			merger.mergeBasic(getDividendAmountReceiver(), o.getDividendAmountReceiver(), this::setDividendAmountReceiver);
			merger.mergeBasic(getFixedAmountPayer(), o.getFixedAmountPayer(), this::setFixedAmountPayer);
			merger.mergeBasic(getFixedAmountReceiver(), o.getFixedAmountReceiver(), this::setFixedAmountReceiver);
			merger.mergeBasic(getKnockInEvent(), o.getKnockInEvent(), this::setKnockInEvent);
			merger.mergeBasic(getKnockOutEvent(), o.getKnockOutEvent(), this::setKnockOutEvent);
			merger.mergeBasic(getKnockInPrice(), o.getKnockInPrice(), this::setKnockInPrice);
			merger.mergeBasic(getKnockOutPrice(), o.getKnockOutPrice(), this::setKnockOutPrice);
			merger.mergeBasic(getBarrierType(), o.getBarrierType(), this::setBarrierType);
			merger.mergeBasic(getEarliestExecutionTime(), o.getEarliestExecutionTime(), this::setEarliestExecutionTime);
			merger.mergeBasic(getExchangeRate(), o.getExchangeRate(), this::setExchangeRate);
			merger.mergeBasic(getExchangeRateBasisCurrency1(), o.getExchangeRateBasisCurrency1(), this::setExchangeRateBasisCurrency1);
			merger.mergeBasic(getExchangeRateBasisCurrency2(), o.getExchangeRateBasisCurrency2(), this::setExchangeRateBasisCurrency2);
			merger.mergeBasic(getExecutionPeriodStartDate(), o.getExecutionPeriodStartDate(), this::setExecutionPeriodStartDate);
			merger.mergeBasic(getPayoutStyle(), o.getPayoutStyle(), this::setPayoutStyle);
			merger.mergeBasic(getRateQuoteBasis1(), o.getRateQuoteBasis1(), this::setRateQuoteBasis1);
			merger.mergeBasic(getSettlementFixingDate(), o.getSettlementFixingDate(), this::setSettlementFixingDate);
			merger.mergeBasic(getSwapLinkId(), o.getSwapLinkId(), this::setSwapLinkId);
			merger.mergeBasic(getTriggerCondition(), o.getTriggerCondition(), this::setTriggerCondition);
			merger.mergeBasic(getTriggerCondition2(), o.getTriggerCondition2(), this::setTriggerCondition2);
			merger.mergeBasic(getTriggerRate(), o.getTriggerRate(), this::setTriggerRate);
			merger.mergeBasic(getTriggerRate2(), o.getTriggerRate2(), this::setTriggerRate2);
			merger.mergeBasic(getRateQuoteBasis2(), o.getRateQuoteBasis2(), this::setRateQuoteBasis2);
			merger.mergeBasic(getForwardExchangeRate(), o.getForwardExchangeRate(), this::setForwardExchangeRate);
			merger.mergeBasic(getBarrierType2(), o.getBarrierType2(), this::setBarrierType2);
			merger.mergeBasic(getCancelationOptionBuyer(), o.getCancelationOptionBuyer(), this::setCancelationOptionBuyer);
			merger.mergeBasic(getCancelationOptionCommencementDate(), o.getCancelationOptionCommencementDate(), this::setCancelationOptionCommencementDate);
			merger.mergeBasic(getCancelationOptionExerciseStyleType(), o.getCancelationOptionExerciseStyleType(), this::setCancelationOptionExerciseStyleType);
			merger.mergeBasic(getCancelationOptionExpirationDate(), o.getCancelationOptionExpirationDate(), this::setCancelationOptionExpirationDate);
			merger.mergeBasic(getCancelationOptionInitialFeeCurrency(), o.getCancelationOptionInitialFeeCurrency(), this::setCancelationOptionInitialFeeCurrency);
			merger.mergeBasic(getCancelationOptionInitialFeePayer(), o.getCancelationOptionInitialFeePayer(), this::setCancelationOptionInitialFeePayer);
			merger.mergeBasic(getCancelationOptionPremiumAmount(), o.getCancelationOptionPremiumAmount(), this::setCancelationOptionPremiumAmount);
			merger.mergeBasic(getCancelationOptionSeller(), o.getCancelationOptionSeller(), this::setCancelationOptionSeller);
			merger.mergeBasic(getCapRateInitial(), o.getCapRateInitial(), this::setCapRateInitial);
			merger.mergeBasic(getCouponType(), o.getCouponType(), this::setCouponType);
			merger.mergeBasic(getFinalPrincipalExchangeIndicatorAtTermination(), o.getFinalPrincipalExchangeIndicatorAtTermination(), this::setFinalPrincipalExchangeIndicatorAtTermination);
			merger.mergeBasic(getFloorRateInitial(), o.getFloorRateInitial(), this::setFloorRateInitial);
			merger.mergeBasic(getFraDiscountingType(), o.getFraDiscountingType(), this::setFraDiscountingType);
			merger.mergeBasic(getInflationIndexInitialLevel(), o.getInflationIndexInitialLevel(), this::setInflationIndexInitialLevel);
			merger.mergeBasic(getInflationIndexMainPublication(), o.getInflationIndexMainPublication(), this::setInflationIndexMainPublication);
			merger.mergeBasic(getInflationInterpolationMethod(), o.getInflationInterpolationMethod(), this::setInflationInterpolationMethod);
			merger.mergeBasic(getInflationLagDayType(), o.getInflationLagDayType(), this::setInflationLagDayType);
			merger.mergeBasic(getInflationLagPeriod(), o.getInflationLagPeriod(), this::setInflationLagPeriod);
			merger.mergeBasic(getInflationRateSourceName(), o.getInflationRateSourceName(), this::setInflationRateSourceName);
			merger.mergeBasic(getInitialPrincipalExchangeIndicator(), o.getInitialPrincipalExchangeIndicator(), this::setInitialPrincipalExchangeIndicator);
			merger.mergeBasic(getIntermediatePrincipalExchangeIndicator(), o.getIntermediatePrincipalExchangeIndicator(), this::setIntermediatePrincipalExchangeIndicator);
			merger.mergeBasic(getLeg1FloatingRateIndex(), o.getLeg1FloatingRateIndex(), this::setLeg1FloatingRateIndex);
			merger.mergeBasic(getLeg1FloatingRateInitialSpread(), o.getLeg1FloatingRateInitialSpread(), this::setLeg1FloatingRateInitialSpread);
			merger.mergeBasic(getLeg1FloatingRateMultiplierInitialValue(), o.getLeg1FloatingRateMultiplierInitialValue(), this::setLeg1FloatingRateMultiplierInitialValue);
			merger.mergeBasic(getLeg1FloatingRateTenorPeriod(), o.getLeg1FloatingRateTenorPeriod(), this::setLeg1FloatingRateTenorPeriod);
			merger.mergeBasic(getLeg1FloatingRateTenorPeriodMultiplier(), o.getLeg1FloatingRateTenorPeriodMultiplier(), this::setLeg1FloatingRateTenorPeriodMultiplier);
			merger.mergeBasic(getLeg1KnownAmount(), o.getLeg1KnownAmount(), this::setLeg1KnownAmount);
			merger.mergeBasic(getLeg1KnownAmountCurrency(), o.getLeg1KnownAmountCurrency(), this::setLeg1KnownAmountCurrency);
			merger.mergeBasic(getLeg1ReferenceCurrency(), o.getLeg1ReferenceCurrency(), this::setLeg1ReferenceCurrency);
			merger.mergeBasic(getLeg2FloatingRateIndex(), o.getLeg2FloatingRateIndex(), this::setLeg2FloatingRateIndex);
			merger.mergeBasic(getLeg2FloatingRateInitialSpread(), o.getLeg2FloatingRateInitialSpread(), this::setLeg2FloatingRateInitialSpread);
			merger.mergeBasic(getLeg2FloatingRateMultiplierInitialValue(), o.getLeg2FloatingRateMultiplierInitialValue(), this::setLeg2FloatingRateMultiplierInitialValue);
			merger.mergeBasic(getLeg2FloatingRateTenorPeriod(), o.getLeg2FloatingRateTenorPeriod(), this::setLeg2FloatingRateTenorPeriod);
			merger.mergeBasic(getLeg2FloatingRateTenorPeriodMultiplier(), o.getLeg2FloatingRateTenorPeriodMultiplier(), this::setLeg2FloatingRateTenorPeriodMultiplier);
			merger.mergeBasic(getLeg2KnownAmount(), o.getLeg2KnownAmount(), this::setLeg2KnownAmount);
			merger.mergeBasic(getLeg2KnownAmountCurrency(), o.getLeg2KnownAmountCurrency(), this::setLeg2KnownAmountCurrency);
			merger.mergeBasic(getLeg2ReferenceCurrency(), o.getLeg2ReferenceCurrency(), this::setLeg2ReferenceCurrency);
			merger.mergeBasic(getMandatoryEarlyTerminationDate(), o.getMandatoryEarlyTerminationDate(), this::setMandatoryEarlyTerminationDate);
			merger.mergeBasic(getMandatoryEarlyTerminationDateTenorPeriod(), o.getMandatoryEarlyTerminationDateTenorPeriod(), this::setMandatoryEarlyTerminationDateTenorPeriod);
			merger.mergeBasic(getMandatoryEarlyTerminationDateTenorPeriodMultiplier(), o.getMandatoryEarlyTerminationDateTenorPeriodMultiplier(), this::setMandatoryEarlyTerminationDateTenorPeriodMultiplier);
			merger.mergeBasic(getNotionalUnits(), o.getNotionalUnits(), this::setNotionalUnits);
			merger.mergeBasic(getOptionalEarlyTerminationCommencementDate(), o.getOptionalEarlyTerminationCommencementDate(), this::setOptionalEarlyTerminationCommencementDate);
			merger.mergeBasic(getOptionalEarlyTerminationExerciseStyle(), o.getOptionalEarlyTerminationExerciseStyle(), this::setOptionalEarlyTerminationExerciseStyle);
			merger.mergeBasic(getOptionalEarlyTerminationExpirationDate(), o.getOptionalEarlyTerminationExpirationDate(), this::setOptionalEarlyTerminationExpirationDate);
			merger.mergeBasic(getPremiumReceiver(), o.getPremiumReceiver(), this::setPremiumReceiver);
			merger.mergeBasic(getUnderlyingCouponRate(), o.getUnderlyingCouponRate(), this::setUnderlyingCouponRate);
			merger.mergeBasic(getUnderlyingMaturityDate(), o.getUnderlyingMaturityDate(), this::setUnderlyingMaturityDate);
			merger.mergeBasic(getUnderlyingProductId(), o.getUnderlyingProductId(), this::setUnderlyingProductId);
			merger.mergeBasic(getInflationLagPeriodMultiplier(), o.getInflationLagPeriodMultiplier(), this::setInflationLagPeriodMultiplier);
			merger.mergeBasic(getLeg1FixedRateNotation(), o.getLeg1FixedRateNotation(), this::setLeg1FixedRateNotation);
			merger.mergeBasic(getLeg2FixedRateNotation(), o.getLeg2FixedRateNotation(), this::setLeg2FixedRateNotation);
			merger.mergeBasic(getSwaptionStraddleIndicator(), o.getSwaptionStraddleIndicator(), this::setSwaptionStraddleIndicator);
			merger.mergeBasic(getSinglePartyEarlyTerminationBuyer(), o.getSinglePartyEarlyTerminationBuyer(), this::setSinglePartyEarlyTerminationBuyer);
			merger.mergeBasic(getLeg1EffectiveDate(), o.getLeg1EffectiveDate(), this::setLeg1EffectiveDate);
			merger.mergeBasic(getAction(), o.getAction(), this::setAction);
			merger.mergeBasic(getClearingStatus(), o.getClearingStatus(), this::setClearingStatus);
			merger.mergeBasic(getEffectiveDate1(), o.getEffectiveDate1(), this::setEffectiveDate1);
			merger.mergeBasic(getExecutionVenueType(), o.getExecutionVenueType(), this::setExecutionVenueType);
			merger.mergeBasic(getNonStandardTradeIndicator(), o.getNonStandardTradeIndicator(), this::setNonStandardTradeIndicator);
			merger.mergeBasic(getNotionalAmount1(), o.getNotionalAmount1(), this::setNotionalAmount1);
			merger.mergeBasic(getNotionalCurrency1(), o.getNotionalCurrency1(), this::setNotionalCurrency1);
			merger.mergeBasic(getPrice1Price(), o.getPrice1Price(), this::setPrice1Price);
			merger.mergeBasic(getPrice1Type(), o.getPrice1Type(), this::setPrice1Type);
			merger.mergeBasic(getPrice1Units(), o.getPrice1Units(), this::setPrice1Units);
			merger.mergeBasic(getScheduledTerminationDate1(), o.getScheduledTerminationDate1(), this::setScheduledTerminationDate1);
			merger.mergeBasic(getTradeDate(), o.getTradeDate(), this::setTradeDate);
			merger.mergeBasic(getTradeParty1CollateralizationType(), o.getTradeParty1CollateralizationType(), this::setTradeParty1CollateralizationType);
			merger.mergeBasic(getTradeParty1EventId(), o.getTradeParty1EventId(), this::setTradeParty1EventId);
			merger.mergeBasic(getTradeParty2CollateralizationType(), o.getTradeParty2CollateralizationType(), this::setTradeParty2CollateralizationType);
			merger.mergeBasic(getTradeParty2EventId(), o.getTradeParty2EventId(), this::setTradeParty2EventId);
			merger.mergeBasic(getEmbeddedOptionOnSwap(), o.getEmbeddedOptionOnSwap(), this::setEmbeddedOptionOnSwap);
			merger.mergeBasic(getExpirationDate(), o.getExpirationDate(), this::setExpirationDate);
			merger.mergeBasic(getNotionalAmount2(), o.getNotionalAmount2(), this::setNotionalAmount2);
			merger.mergeBasic(getNotionalCurrency2(), o.getNotionalCurrency2(), this::setNotionalCurrency2);
			merger.mergeBasic(getPremiumAmount(), o.getPremiumAmount(), this::setPremiumAmount);
			merger.mergeBasic(getPremiumCurrency(), o.getPremiumCurrency(), this::setPremiumCurrency);
			merger.mergeBasic(getVersion(), o.getVersion(), this::setVersion);
			merger.mergeBasic(getComment1(), o.getComment1(), this::setComment1);
			merger.mergeBasic(getOptionStyle(), o.getOptionStyle(), this::setOptionStyle);
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getSettlementCurrency1(), o.getSettlementCurrency1(), this::setSettlementCurrency1);
			merger.mergeBasic(getCommencementDate(), o.getCommencementDate(), this::setCommencementDate);
			merger.mergeBasic(getDayCountFraction1(), o.getDayCountFraction1(), this::setDayCountFraction1);
			merger.mergeBasic(getLeg2DayCountFraction(), o.getLeg2DayCountFraction(), this::setLeg2DayCountFraction);
			merger.mergeBasic(getLeg2EffectiveDate(), o.getLeg2EffectiveDate(), this::setLeg2EffectiveDate);
			merger.mergeBasic(getLeg2ResetFrequencyPeriod(), o.getLeg2ResetFrequencyPeriod(), this::setLeg2ResetFrequencyPeriod);
			merger.mergeBasic(getLeg2ResetFrequencyPeriodMultiplier(), o.getLeg2ResetFrequencyPeriodMultiplier(), this::setLeg2ResetFrequencyPeriodMultiplier);
			merger.mergeBasic(getLeg2SettlementCurrency(), o.getLeg2SettlementCurrency(), this::setLeg2SettlementCurrency);
			merger.mergeBasic(getLeg2ScheduledTerminationDate(), o.getLeg2ScheduledTerminationDate(), this::setLeg2ScheduledTerminationDate);
			merger.mergeBasic(getNumberOfOptions(), o.getNumberOfOptions(), this::setNumberOfOptions);
			merger.mergeBasic(getOptionEntitlement(), o.getOptionEntitlement(), this::setOptionEntitlement);
			merger.mergeBasic(getOriginalExecutionTimestamp(), o.getOriginalExecutionTimestamp(), this::setOriginalExecutionTimestamp);
			merger.mergeBasic(getPayment1Date(), o.getPayment1Date(), this::setPayment1Date);
			merger.mergeBasic(getPayment1FrequencyPeriod(), o.getPayment1FrequencyPeriod(), this::setPayment1FrequencyPeriod);
			merger.mergeBasic(getPayment1FrequencyPeriodMultiplier(), o.getPayment1FrequencyPeriodMultiplier(), this::setPayment1FrequencyPeriodMultiplier);
			merger.mergeBasic(getPayment2Date(), o.getPayment2Date(), this::setPayment2Date);
			merger.mergeBasic(getPayment2FrequencyPeriod(), o.getPayment2FrequencyPeriod(), this::setPayment2FrequencyPeriod);
			merger.mergeBasic(getPayment2FrequencyPeriodMultiplier(), o.getPayment2FrequencyPeriodMultiplier(), this::setPayment2FrequencyPeriodMultiplier);
			merger.mergeBasic(getResetFrequencyPeriod1(), o.getResetFrequencyPeriod1(), this::setResetFrequencyPeriod1);
			merger.mergeBasic(getResetFrequencyPeriodMultiplier1(), o.getResetFrequencyPeriodMultiplier1(), this::setResetFrequencyPeriodMultiplier1);
			merger.mergeBasic(getSettlementDate(), o.getSettlementDate(), this::setSettlementDate);
			merger.mergeBasic(getStrikePrice(), o.getStrikePrice(), this::setStrikePrice);
			merger.mergeBasic(getStrikePriceUnits(), o.getStrikePriceUnits(), this::setStrikePriceUnits);
			merger.mergeBasic(getAsOfDateTime(), o.getAsOfDateTime(), this::setAsOfDateTime);
			merger.mergeBasic(getClearingVenueId(), o.getClearingVenueId(), this::setClearingVenueId);
			merger.mergeBasic(getClearingVenueIdType(), o.getClearingVenueIdType(), this::setClearingVenueIdType);
			merger.mergeBasic(getCompressedTradeIndicator(), o.getCompressedTradeIndicator(), this::setCompressedTradeIndicator);
			merger.mergeBasic(getConfirmationMethod(), o.getConfirmationMethod(), this::setConfirmationMethod);
			merger.mergeBasic(getConfirmationPlatformId(), o.getConfirmationPlatformId(), this::setConfirmationPlatformId);
			merger.mergeBasic(getConfirmationPlatformTradeId(), o.getConfirmationPlatformTradeId(), this::setConfirmationPlatformTradeId);
			merger.mergeBasic(getExecutionVenueId(), o.getExecutionVenueId(), this::setExecutionVenueId);
			merger.mergeBasic(getExecutionVenueIdType(), o.getExecutionVenueIdType(), this::setExecutionVenueIdType);
			merger.mergeBasic(getPostTradeEffectiveDate(), o.getPostTradeEffectiveDate(), this::setPostTradeEffectiveDate);
			merger.mergeBasic(getPriorUsiId(), o.getPriorUsiId(), this::setPriorUsiId);
			merger.mergeBasic(getPriorUsiIdPrefix(), o.getPriorUsiIdPrefix(), this::setPriorUsiIdPrefix);
			merger.mergeBasic(getPriorUtiId(), o.getPriorUtiId(), this::setPriorUtiId);
			merger.mergeBasic(getPriorUtiIdPrefix(), o.getPriorUtiIdPrefix(), this::setPriorUtiIdPrefix);
			merger.mergeBasic(getTradeParty1BranchLocation(), o.getTradeParty1BranchLocation(), this::setTradeParty1BranchLocation);
			merger.mergeBasic(getTradeParty1ClearingBrokerId(), o.getTradeParty1ClearingBrokerId(), this::setTradeParty1ClearingBrokerId);
			merger.mergeBasic(getTradeParty1ClearingBrokerIdType(), o.getTradeParty1ClearingBrokerIdType(), this::setTradeParty1ClearingBrokerIdType);
			merger.mergeBasic(getTradeParty1DeskLocation(), o.getTradeParty1DeskLocation(), this::setTradeParty1DeskLocation);
			merger.mergeBasic(getTradeParty1Domicile(), o.getTradeParty1Domicile(), this::setTradeParty1Domicile);
			merger.mergeBasic(getTradeParty1IndustrialSectorType(), o.getTradeParty1IndustrialSectorType(), this::setTradeParty1IndustrialSectorType);
			merger.mergeBasic(getTradeParty2BranchLocation(), o.getTradeParty2BranchLocation(), this::setTradeParty2BranchLocation);
			merger.mergeBasic(getTradeParty2DeskLocation(), o.getTradeParty2DeskLocation(), this::setTradeParty2DeskLocation);
			merger.mergeBasic(getTradeParty2Domicile(), o.getTradeParty2Domicile(), this::setTradeParty2Domicile);
			merger.mergeBasic(getTradeParty2IndustrialSectorType(), o.getTradeParty2IndustrialSectorType(), this::setTradeParty2IndustrialSectorType);
			merger.mergeBasic(getSellerPayer2(), o.getSellerPayer2(), this::setSellerPayer2);
			merger.mergeBasic(getBuyerPayer1(), o.getBuyerPayer1(), this::setBuyerPayer1);
			merger.mergeBasic(getTradeParty1HkCounterpartyOrigin(), o.getTradeParty1HkCounterpartyOrigin(), this::setTradeParty1HkCounterpartyOrigin);
			merger.mergeBasic(getLeg2SettlementDate(), o.getLeg2SettlementDate(), this::setLeg2SettlementDate);
			merger.mergeBasic(getLeg1FixedRateInitial(), o.getLeg1FixedRateInitial(), this::setLeg1FixedRateInitial);
			merger.mergeBasic(getLeg2FixedRateInitial(), o.getLeg2FixedRateInitial(), this::setLeg2FixedRateInitial);
			merger.mergeBasic(getPayment1Amount(), o.getPayment1Amount(), this::setPayment1Amount);
			merger.mergeBasic(getPayment1Currency(), o.getPayment1Currency(), this::setPayment1Currency);
			merger.mergeBasic(getPayment1Payer(), o.getPayment1Payer(), this::setPayment1Payer);
			merger.mergeBasic(getPayment1Receiver(), o.getPayment1Receiver(), this::setPayment1Receiver);
			merger.mergeBasic(getPayment2Payer(), o.getPayment2Payer(), this::setPayment2Payer);
			merger.mergeBasic(getPostTradeTransactionDate(), o.getPostTradeTransactionDate(), this::setPostTradeTransactionDate);
			merger.mergeBasic(getSecondaryAssetClass(), o.getSecondaryAssetClass(), this::setSecondaryAssetClass);
			merger.mergeBasic(getSettlementType(), o.getSettlementType(), this::setSettlementType);
			merger.mergeBasic(getTradeParty1Name(), o.getTradeParty1Name(), this::setTradeParty1Name);
			merger.mergeBasic(getTradeParty2Name(), o.getTradeParty2Name(), this::setTradeParty2Name);
			merger.mergeBasic(getCcpValuationAmount(), o.getCcpValuationAmount(), this::setCcpValuationAmount);
			merger.mergeBasic(getCcpValuationCurrency(), o.getCcpValuationCurrency(), this::setCcpValuationCurrency);
			merger.mergeBasic(getCcpValuationDatetime(), o.getCcpValuationDatetime(), this::setCcpValuationDatetime);
			merger.mergeBasic(getCcpValuationType(), o.getCcpValuationType(), this::setCcpValuationType);
			merger.mergeBasic(getTradeParty1ValuationAmount(), o.getTradeParty1ValuationAmount(), this::setTradeParty1ValuationAmount);
			merger.mergeBasic(getTradeParty1ValuationCurrency(), o.getTradeParty1ValuationCurrency(), this::setTradeParty1ValuationCurrency);
			merger.mergeBasic(getTradeParty1ValuationDatetime(), o.getTradeParty1ValuationDatetime(), this::setTradeParty1ValuationDatetime);
			merger.mergeBasic(getTradeParty1ValuationType(), o.getTradeParty1ValuationType(), this::setTradeParty1ValuationType);
			merger.mergeBasic(getTradeParty2ValuationAmount(), o.getTradeParty2ValuationAmount(), this::setTradeParty2ValuationAmount);
			merger.mergeBasic(getTradeParty2ValuationCurrency(), o.getTradeParty2ValuationCurrency(), this::setTradeParty2ValuationCurrency);
			merger.mergeBasic(getTradeParty2ValuationDatetime(), o.getTradeParty2ValuationDatetime(), this::setTradeParty2ValuationDatetime);
			merger.mergeBasic(getTradeParty2ValuationType(), o.getTradeParty2ValuationType(), this::setTradeParty2ValuationType);
			merger.mergeBasic(getExecutionType(), o.getExecutionType(), this::setExecutionType);
			merger.mergeBasic(getStrikePriceCurrency(), o.getStrikePriceCurrency(), this::setStrikePriceCurrency);
			merger.mergeBasic(getPayment2Amount(), o.getPayment2Amount(), this::setPayment2Amount);
			merger.mergeBasic(getTradeParty2HkCounterpartyOrigin(), o.getTradeParty2HkCounterpartyOrigin(), this::setTradeParty2HkCounterpartyOrigin);
			merger.mergeBasic(getTradeParty1CountryOfTheOtherCounterparty(), o.getTradeParty1CountryOfTheOtherCounterparty(), this::setTradeParty1CountryOfTheOtherCounterparty);
			merger.mergeBasic(getTradeParty2CountryOfTheOtherCounterparty(), o.getTradeParty2CountryOfTheOtherCounterparty(), this::setTradeParty2CountryOfTheOtherCounterparty);
			merger.mergeBasic(getTradeParty1BrokerId(), o.getTradeParty1BrokerId(), this::setTradeParty1BrokerId);
			merger.mergeBasic(getTradeParty2BrokerId(), o.getTradeParty2BrokerId(), this::setTradeParty2BrokerId);
			merger.mergeBasic(getTradeParty1BeneficiaryIdType(), o.getTradeParty1BeneficiaryIdType(), this::setTradeParty1BeneficiaryIdType);
			merger.mergeBasic(getTradeParty1BeneficiaryId(), o.getTradeParty1BeneficiaryId(), this::setTradeParty1BeneficiaryId);
			merger.mergeBasic(getTradeParty2BeneficiaryIdType(), o.getTradeParty2BeneficiaryIdType(), this::setTradeParty2BeneficiaryIdType);
			merger.mergeBasic(getTradeParty2BeneficiaryId(), o.getTradeParty2BeneficiaryId(), this::setTradeParty2BeneficiaryId);
			merger.mergeBasic(getTradeParty1CounterpartySide(), o.getTradeParty1CounterpartySide(), this::setTradeParty1CounterpartySide);
			merger.mergeBasic(getTradeParty2CounterpartySide(), o.getTradeParty2CounterpartySide(), this::setTradeParty2CounterpartySide);
			merger.mergeBasic(getTradeParty1CollateralPortfolioCode(), o.getTradeParty1CollateralPortfolioCode(), this::setTradeParty1CollateralPortfolioCode);
			merger.mergeBasic(getTradeParty2CollateralPortfolioCode(), o.getTradeParty2CollateralPortfolioCode(), this::setTradeParty2CollateralPortfolioCode);
			merger.mergeBasic(getContractType(), o.getContractType(), this::setContractType);
			merger.mergeBasic(getEuUnderlyingAssetIdType(), o.getEuUnderlyingAssetIdType(), this::setEuUnderlyingAssetIdType);
			merger.mergeBasic(getProductClassification(), o.getProductClassification(), this::setProductClassification);
			merger.mergeBasic(getComplexTradeComponentId(), o.getComplexTradeComponentId(), this::setComplexTradeComponentId);
			merger.mergeBasic(getPriceMultiplier(), o.getPriceMultiplier(), this::setPriceMultiplier);
			merger.mergeBasic(getQuantity(), o.getQuantity(), this::setQuantity);
			merger.mergeBasic(getMasterAgreementType(), o.getMasterAgreementType(), this::setMasterAgreementType);
			merger.mergeBasic(getMasterAgreementVersion(), o.getMasterAgreementVersion(), this::setMasterAgreementVersion);
			merger.mergeBasic(getConfirmationDatetime(), o.getConfirmationDatetime(), this::setConfirmationDatetime);
			merger.mergeBasic(getClearingDatetime(), o.getClearingDatetime(), this::setClearingDatetime);
			merger.mergeBasic(getMaturityDateOfTheUnderlying(), o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying);
			merger.mergeBasic(getLevel(), o.getLevel(), this::setLevel);
			merger.mergeBasic(getProductClassificationType(), o.getProductClassificationType(), this::setProductClassificationType);
			merger.mergeBasic(getProductIdentificationType(), o.getProductIdentificationType(), this::setProductIdentificationType);
			merger.mergeBasic(getProductIdentification(), o.getProductIdentification(), this::setProductIdentification);
			merger.mergeBasic(getEuUnderlyingAssetId(), o.getEuUnderlyingAssetId(), this::setEuUnderlyingAssetId);
			merger.mergeBasic(getReportTrackingNumber(), o.getReportTrackingNumber(), this::setReportTrackingNumber);
			merger.mergeBasic(getTradeParty1BrokerIdType(), o.getTradeParty1BrokerIdType(), this::setTradeParty1BrokerIdType);
			merger.mergeBasic(getTradeParty2BrokerIdType(), o.getTradeParty2BrokerIdType(), this::setTradeParty2BrokerIdType);
			merger.mergeBasic(getTradeParty2ClearingBrokerIdType(), o.getTradeParty2ClearingBrokerIdType(), this::setTradeParty2ClearingBrokerIdType);
			merger.mergeBasic(getTradeParty2ClearingBrokerId(), o.getTradeParty2ClearingBrokerId(), this::setTradeParty2ClearingBrokerId);
			merger.mergeBasic(getTradeParty1ClearingThreshold(), o.getTradeParty1ClearingThreshold(), this::setTradeParty1ClearingThreshold);
			merger.mergeBasic(getTradeParty2ClearingThreshold(), o.getTradeParty2ClearingThreshold(), this::setTradeParty2ClearingThreshold);
			merger.mergeBasic(getTradeParty1CorporateSectorType(), o.getTradeParty1CorporateSectorType(), this::setTradeParty1CorporateSectorType);
			merger.mergeBasic(getTradeParty2CorporateSectorType(), o.getTradeParty2CorporateSectorType(), this::setTradeParty2CorporateSectorType);
			merger.mergeBasic(getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), o.getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), this::setTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator);
			merger.mergeBasic(getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), o.getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), this::setTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator);
			merger.mergeBasic(getIntragroupIndicator(), o.getIntragroupIndicator(), this::setIntragroupIndicator);
			merger.mergeBasic(getTradeParty1TradingCapacity1(), o.getTradeParty1TradingCapacity1(), this::setTradeParty1TradingCapacity1);
			merger.mergeBasic(getTradeParty2TradingCapacity1(), o.getTradeParty2TradingCapacity1(), this::setTradeParty2TradingCapacity1);
			merger.mergeBasic(getCurrencyOfPrice(), o.getCurrencyOfPrice(), this::setCurrencyOfPrice);
			merger.mergeBasic(getTradeParty1CollateralPortfolio(), o.getTradeParty1CollateralPortfolio(), this::setTradeParty1CollateralPortfolio);
			merger.mergeBasic(getTradeParty2CollateralPortfolio(), o.getTradeParty2CollateralPortfolio(), this::setTradeParty2CollateralPortfolio);
			merger.mergeBasic(getExecutionVenueMicCode(), o.getExecutionVenueMicCode(), this::setExecutionVenueMicCode);
			merger.mergeBasic(getPayment2Currency(), o.getPayment2Currency(), this::setPayment2Currency);
			merger.mergeBasic(getExpirationDateTimeBusinessCenter(), o.getExpirationDateTimeBusinessCenter(), this::setExpirationDateTimeBusinessCenter);
			merger.mergeBasic(getExpirationTime(), o.getExpirationTime(), this::setExpirationTime);
			merger.mergeBasic(getExpirationTimeType(), o.getExpirationTimeType(), this::setExpirationTimeType);
			merger.mergeBasic(getTradeParty1TraderLocation(), o.getTradeParty1TraderLocation(), this::setTradeParty1TraderLocation);
			merger.mergeBasic(getTradeParty2TraderLocation(), o.getTradeParty2TraderLocation(), this::setTradeParty2TraderLocation);
			merger.mergeBasic(getPayment3ResetFrequencyPeriodMultiplier(), o.getPayment3ResetFrequencyPeriodMultiplier(), this::setPayment3ResetFrequencyPeriodMultiplier);
			merger.mergeBasic(getPayment3ResetFrequencyPeriod(), o.getPayment3ResetFrequencyPeriod(), this::setPayment3ResetFrequencyPeriod);
			merger.mergeBasic(getPayment4ResetFrequencyPeriodMultiplier(), o.getPayment4ResetFrequencyPeriodMultiplier(), this::setPayment4ResetFrequencyPeriodMultiplier);
			merger.mergeBasic(getPayment4ResetFrequencyPeriod(), o.getPayment4ResetFrequencyPeriod(), this::setPayment4ResetFrequencyPeriod);
			merger.mergeBasic(getPayment5ResetFrequencyPeriodMultiplier(), o.getPayment5ResetFrequencyPeriodMultiplier(), this::setPayment5ResetFrequencyPeriodMultiplier);
			merger.mergeBasic(getPayment5ResetFrequencyPeriod(), o.getPayment5ResetFrequencyPeriod(), this::setPayment5ResetFrequencyPeriod);
			merger.mergeBasic(getPayment1Type(), o.getPayment1Type(), this::setPayment1Type);
			merger.mergeBasic(getPayment1Reference(), o.getPayment1Reference(), this::setPayment1Reference);
			merger.mergeBasic(getPayment2Type(), o.getPayment2Type(), this::setPayment2Type);
			merger.mergeBasic(getPayment2Reference(), o.getPayment2Reference(), this::setPayment2Reference);
			merger.mergeBasic(getPayment3Payer(), o.getPayment3Payer(), this::setPayment3Payer);
			merger.mergeBasic(getPayment3Reference(), o.getPayment3Reference(), this::setPayment3Reference);
			merger.mergeBasic(getPayment3FrequencyPeriod(), o.getPayment3FrequencyPeriod(), this::setPayment3FrequencyPeriod);
			merger.mergeBasic(getPayment3FrequencyPeriodMultiplier(), o.getPayment3FrequencyPeriodMultiplier(), this::setPayment3FrequencyPeriodMultiplier);
			merger.mergeBasic(getPayment3Date(), o.getPayment3Date(), this::setPayment3Date);
			merger.mergeBasic(getPayment4Reference(), o.getPayment4Reference(), this::setPayment4Reference);
			merger.mergeBasic(getPayment4Payer(), o.getPayment4Payer(), this::setPayment4Payer);
			merger.mergeBasic(getPayment4FrequencyPeriod(), o.getPayment4FrequencyPeriod(), this::setPayment4FrequencyPeriod);
			merger.mergeBasic(getPayment4FrequencyPeriodMultiplier(), o.getPayment4FrequencyPeriodMultiplier(), this::setPayment4FrequencyPeriodMultiplier);
			merger.mergeBasic(getPayment4Date(), o.getPayment4Date(), this::setPayment4Date);
			merger.mergeBasic(getPayment5Reference(), o.getPayment5Reference(), this::setPayment5Reference);
			merger.mergeBasic(getPayment5Payer(), o.getPayment5Payer(), this::setPayment5Payer);
			merger.mergeBasic(getPayment5FrequencyPeriod(), o.getPayment5FrequencyPeriod(), this::setPayment5FrequencyPeriod);
			merger.mergeBasic(getPayment5FrequencyPeriodMultiplier(), o.getPayment5FrequencyPeriodMultiplier(), this::setPayment5FrequencyPeriodMultiplier);
			merger.mergeBasic(getPayment5Date(), o.getPayment5Date(), this::setPayment5Date);
			merger.mergeBasic(getPayment3Type(), o.getPayment3Type(), this::setPayment3Type);
			merger.mergeBasic(getPremiumPayer(), o.getPremiumPayer(), this::setPremiumPayer);
			merger.mergeBasic(getPremiumPaymentDateUnadjusted(), o.getPremiumPaymentDateUnadjusted(), this::setPremiumPaymentDateUnadjusted);
			merger.mergeBasic(getTradeParty1NatureOfTheReportingCounterparty(), o.getTradeParty1NatureOfTheReportingCounterparty(), this::setTradeParty1NatureOfTheReportingCounterparty);
			merger.mergeBasic(getTradeParty2NatureOfTheReportingCounterparty(), o.getTradeParty2NatureOfTheReportingCounterparty(), this::setTradeParty2NatureOfTheReportingCounterparty);
			merger.mergeBasic(getReservedParticipantUse1(), o.getReservedParticipantUse1(), this::setReservedParticipantUse1);
			merger.mergeBasic(getReservedParticipantUse2(), o.getReservedParticipantUse2(), this::setReservedParticipantUse2);
			merger.mergeBasic(getReservedParticipantUse3(), o.getReservedParticipantUse3(), this::setReservedParticipantUse3);
			merger.mergeBasic(getReservedParticipantUse4(), o.getReservedParticipantUse4(), this::setReservedParticipantUse4);
			merger.mergeBasic(getReservedParticipantUse5(), o.getReservedParticipantUse5(), this::setReservedParticipantUse5);
			merger.mergeBasic(getLeg1TerminationDate(), o.getLeg1TerminationDate(), this::setLeg1TerminationDate);
			merger.mergeBasic(getAllocationType(), o.getAllocationType(), this::setAllocationType);
			merger.mergeBasic(getCalculationBasis(), o.getCalculationBasis(), this::setCalculationBasis);
			merger.mergeBasic(getClearingExceptionPartyId(), o.getClearingExceptionPartyId(), this::setClearingExceptionPartyId);
			merger.mergeBasic(getClearingExceptionPartyIdType(), o.getClearingExceptionPartyIdType(), this::setClearingExceptionPartyIdType);
			merger.mergeBasic(getClearingExceptionType(), o.getClearingExceptionType(), this::setClearingExceptionType);
			merger.mergeBasic(getClearingMemberClientAccountId(), o.getClearingMemberClientAccountId(), this::setClearingMemberClientAccountId);
			merger.mergeBasic(getClearingReceiptDatetime(), o.getClearingReceiptDatetime(), this::setClearingReceiptDatetime);
			merger.mergeBasic(getClearingSwapSdrLeiId(), o.getClearingSwapSdrLeiId(), this::setClearingSwapSdrLeiId);
			merger.mergeBasic(getClearingSwapUtiId(), o.getClearingSwapUtiId(), this::setClearingSwapUtiId);
			merger.mergeBasic(getCollateralReportingDate(), o.getCollateralReportingDate(), this::setCollateralReportingDate);
			merger.mergeBasic(getCollateralValuationDatetime(), o.getCollateralValuationDatetime(), this::setCollateralValuationDatetime);
			merger.mergeBasic(getComment2(), o.getComment2(), this::setComment2);
			merger.mergeBasic(getCommodityStrikePriceUnit(), o.getCommodityStrikePriceUnit(), this::setCommodityStrikePriceUnit);
			merger.mergeBasic(getExecutionAgentMaskingIndicator(), o.getExecutionAgentMaskingIndicator(), this::setExecutionAgentMaskingIndicator);
			merger.mergeBasic(getFeeInCurrency(), o.getFeeInCurrency(), this::setFeeInCurrency);
			merger.mergeBasic(getFeeOutCurrency(), o.getFeeOutCurrency(), this::setFeeOutCurrency);
			merger.mergeBasic(getFloatingRatePaymentFrequencyLeg1Multiplier(), o.getFloatingRatePaymentFrequencyLeg1Multiplier(), this::setFloatingRatePaymentFrequencyLeg1Multiplier);
			merger.mergeBasic(getFloatingRatePaymentFrequencyLeg1TimePeriod(), o.getFloatingRatePaymentFrequencyLeg1TimePeriod(), this::setFloatingRatePaymentFrequencyLeg1TimePeriod);
			merger.mergeBasic(getFloatingRatePaymentFrequencyLeg2Multiplier(), o.getFloatingRatePaymentFrequencyLeg2Multiplier(), this::setFloatingRatePaymentFrequencyLeg2Multiplier);
			merger.mergeBasic(getFloatingRatePaymentFrequencyLeg2TimePeriod(), o.getFloatingRatePaymentFrequencyLeg2TimePeriod(), this::setFloatingRatePaymentFrequencyLeg2TimePeriod);
			merger.mergeBasic(getFrequencyOfPayment(), o.getFrequencyOfPayment(), this::setFrequencyOfPayment);
			merger.mergeBasic(getInteraffiliate(), o.getInteraffiliate(), this::setInteraffiliate);
			merger.mergeBasic(getLargeTradeIndicator(), o.getLargeTradeIndicator(), this::setLargeTradeIndicator);
			merger.mergeBasic(getLeg1EffectiveDateAdjusted(), o.getLeg1EffectiveDateAdjusted(), this::setLeg1EffectiveDateAdjusted);
			merger.mergeBasic(getLeg1FinalValuationDate(), o.getLeg1FinalValuationDate(), this::setLeg1FinalValuationDate);
			merger.mergeBasic(getLeg1SettlementPeriod(), o.getLeg1SettlementPeriod(), this::setLeg1SettlementPeriod);
			merger.mergeBasic(getLeg2EffectiveDateAdjusted(), o.getLeg2EffectiveDateAdjusted(), this::setLeg2EffectiveDateAdjusted);
			merger.mergeBasic(getLeg2PaymentTermsFrequencyPeriod(), o.getLeg2PaymentTermsFrequencyPeriod(), this::setLeg2PaymentTermsFrequencyPeriod);
			merger.mergeBasic(getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier(), o.getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier(), this::setLeg2PaymentTermsPaymentFrequencyPeriodMultiplier);
			merger.mergeBasic(getLeg2SettlementType(), o.getLeg2SettlementType(), this::setLeg2SettlementType);
			merger.mergeBasic(getLeg2UnderlyingAssetId(), o.getLeg2UnderlyingAssetId(), this::setLeg2UnderlyingAssetId);
			merger.mergeBasic(getLeg2UnderlyingAssetIdType(), o.getLeg2UnderlyingAssetIdType(), this::setLeg2UnderlyingAssetIdType);
			merger.mergeBasic(getLeg2UnderlyingAssetName(), o.getLeg2UnderlyingAssetName(), this::setLeg2UnderlyingAssetName);
			merger.mergeBasic(getMaturityDate(), o.getMaturityDate(), this::setMaturityDate);
			merger.mergeBasic(getOptionalEarlyTerminationDate(), o.getOptionalEarlyTerminationDate(), this::setOptionalEarlyTerminationDate);
			merger.mergeBasic(getOptionCommodityCurrency(), o.getOptionCommodityCurrency(), this::setOptionCommodityCurrency);
			merger.mergeBasic(getOptionCommodityExchangeId(), o.getOptionCommodityExchangeId(), this::setOptionCommodityExchangeId);
			merger.mergeBasic(getOptionCommodityInstrumentId(), o.getOptionCommodityInstrumentId(), this::setOptionCommodityInstrumentId);
			merger.mergeBasic(getOptionCommodityRateSource(), o.getOptionCommodityRateSource(), this::setOptionCommodityRateSource);
			merger.mergeBasic(getOptionCommodityRateSourcePage(), o.getOptionCommodityRateSourcePage(), this::setOptionCommodityRateSourcePage);
			merger.mergeBasic(getOptionCommodityUnderlyerDetails(), o.getOptionCommodityUnderlyerDetails(), this::setOptionCommodityUnderlyerDetails);
			merger.mergeBasic(getOptionCommodityUnderlyerId(), o.getOptionCommodityUnderlyerId(), this::setOptionCommodityUnderlyerId);
			merger.mergeBasic(getOptionCommodityUnitOfMeasure(), o.getOptionCommodityUnitOfMeasure(), this::setOptionCommodityUnitOfMeasure);
			merger.mergeBasic(getOptionSpecifiedPrice(), o.getOptionSpecifiedPrice(), this::setOptionSpecifiedPrice);
			merger.mergeBasic(getOptionSpreadAmount(), o.getOptionSpreadAmount(), this::setOptionSpreadAmount);
			merger.mergeBasic(getOptionSpreadCurrency(), o.getOptionSpreadCurrency(), this::setOptionSpreadCurrency);
			merger.mergeBasic(getOptionSpreadSchedule(), o.getOptionSpreadSchedule(), this::setOptionSpreadSchedule);
			merger.mergeBasic(getOrigin(), o.getOrigin(), this::setOrigin);
			merger.mergeBasic(getOriginalSwapSdrId(), o.getOriginalSwapSdrId(), this::setOriginalSwapSdrId);
			merger.mergeBasic(getOriginalSwapSdrIdType(), o.getOriginalSwapSdrIdType(), this::setOriginalSwapSdrIdType);
			merger.mergeBasic(getPaymentFrequencyPeriodLeg1(), o.getPaymentFrequencyPeriodLeg1(), this::setPaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getPaymentFrequencyPeriodLeg2(), o.getPaymentFrequencyPeriodLeg2(), this::setPaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getPaymentFrequencyPeriodMultiplierLeg1(), o.getPaymentFrequencyPeriodMultiplierLeg1(), this::setPaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getPaymentFrequencyPeriodMultiplierLeg2(), o.getPaymentFrequencyPeriodMultiplierLeg2(), this::setPaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getPremiumPayerPrefix(), o.getPremiumPayerPrefix(), this::setPremiumPayerPrefix);
			merger.mergeBasic(getPrice1Currency(), o.getPrice1Currency(), this::setPrice1Currency);
			merger.mergeBasic(getPrice2Price(), o.getPrice2Price(), this::setPrice2Price);
			merger.mergeBasic(getPrice2Type(), o.getPrice2Type(), this::setPrice2Type);
			merger.mergeBasic(getPrice2Units(), o.getPrice2Units(), this::setPrice2Units);
			merger.mergeBasic(getPrice3Price(), o.getPrice3Price(), this::setPrice3Price);
			merger.mergeBasic(getPrice3Type(), o.getPrice3Type(), this::setPrice3Type);
			merger.mergeBasic(getPrice3Units(), o.getPrice3Units(), this::setPrice3Units);
			merger.mergeBasic(getPrice4Price(), o.getPrice4Price(), this::setPrice4Price);
			merger.mergeBasic(getPrice4Type(), o.getPrice4Type(), this::setPrice4Type);
			merger.mergeBasic(getPrice4Units(), o.getPrice4Units(), this::setPrice4Units);
			merger.mergeBasic(getPricingContext(), o.getPricingContext(), this::setPricingContext);
			merger.mergeBasic(getPriorUsiType(), o.getPriorUsiType(), this::setPriorUsiType);
			merger.mergeBasic(getPriorUtiType(), o.getPriorUtiType(), this::setPriorUtiType);
			merger.mergeBasic(getRecoveryPrice(), o.getRecoveryPrice(), this::setRecoveryPrice);
			merger.mergeBasic(getSendToDataCenterCode(), o.getSendToDataCenterCode(), this::setSendToDataCenterCode);
			merger.mergeBasic(getStrikePriceType(), o.getStrikePriceType(), this::setStrikePriceType);
			merger.mergeBasic(getSubAssetClassForOtherCommodity(), o.getSubAssetClassForOtherCommodity(), this::setSubAssetClassForOtherCommodity);
			merger.mergeBasic(getTradeParty1CftcFinancialEntityStatus(), o.getTradeParty1CftcFinancialEntityStatus(), this::setTradeParty1CftcFinancialEntityStatus);
			merger.mergeBasic(getTradeParty1CollateralAmount(), o.getTradeParty1CollateralAmount(), this::setTradeParty1CollateralAmount);
			merger.mergeBasic(getTradeParty1CollateralCurrency(), o.getTradeParty1CollateralCurrency(), this::setTradeParty1CollateralCurrency);
			merger.mergeBasic(getTradeParty1MandatoryDelegatedReporting(), o.getTradeParty1MandatoryDelegatedReporting(), this::setTradeParty1MandatoryDelegatedReporting);
			merger.mergeBasic(getTradeParty1Role(), o.getTradeParty1Role(), this::setTradeParty1Role);
			merger.mergeBasic(getTradeParty2CftcFinancialEntityStatus(), o.getTradeParty2CftcFinancialEntityStatus(), this::setTradeParty2CftcFinancialEntityStatus);
			merger.mergeBasic(getTradeParty2CollateralAmount(), o.getTradeParty2CollateralAmount(), this::setTradeParty2CollateralAmount);
			merger.mergeBasic(getTradeParty2CollateralCurrency(), o.getTradeParty2CollateralCurrency(), this::setTradeParty2CollateralCurrency);
			merger.mergeBasic(getTradeParty2MandatoryDelegatedReporting(), o.getTradeParty2MandatoryDelegatedReporting(), this::setTradeParty2MandatoryDelegatedReporting);
			merger.mergeBasic(getTradeParty2Role(), o.getTradeParty2Role(), this::setTradeParty2Role);
			merger.mergeBasic(getUpfrontPayment(), o.getUpfrontPayment(), this::setUpfrontPayment);
			merger.mergeBasic(getVerificationMethod(), o.getVerificationMethod(), this::setVerificationMethod);
			merger.mergeBasic(getResponsibleDataSubmitterId(), o.getResponsibleDataSubmitterId(), this::setResponsibleDataSubmitterId);
			merger.mergeBasic(getResponsibleDataSubmitterIdType(), o.getResponsibleDataSubmitterIdType(), this::setResponsibleDataSubmitterIdType);
			merger.mergeBasic(getOriginalSwapUsi(), o.getOriginalSwapUsi(), this::setOriginalSwapUsi);
			merger.mergeBasic(getOriginalSwapUti(), o.getOriginalSwapUti(), this::setOriginalSwapUti);
			merger.mergeBasic(getCdeReceiverIdentifierLeg2(), o.getCdeReceiverIdentifierLeg2(), this::setCdeReceiverIdentifierLeg2);
			merger.mergeBasic(getCounterparty1FederalEntityIndicator(), o.getCounterparty1FederalEntityIndicator(), this::setCounterparty1FederalEntityIndicator);
			merger.mergeBasic(getCounterparty2FederalEntityIndicator(), o.getCounterparty2FederalEntityIndicator(), this::setCounterparty2FederalEntityIndicator);
			merger.mergeBasic(getCustomBasketIndicator(), o.getCustomBasketIndicator(), this::setCustomBasketIndicator);
			merger.mergeBasic(getNoaActionType(), o.getNoaActionType(), this::setNoaActionType);
			merger.mergeBasic(getEventType(), o.getEventType(), this::setEventType);
			merger.mergeBasic(getAmendmentIndicator(), o.getAmendmentIndicator(), this::setAmendmentIndicator);
			merger.mergeBasic(getEventIdentifier(), o.getEventIdentifier(), this::setEventIdentifier);
			merger.mergeBasic(getCdeCallAmountLeg1(), o.getCdeCallAmountLeg1(), this::setCdeCallAmountLeg1);
			merger.mergeBasic(getCdeCallAmountLeg2(), o.getCdeCallAmountLeg2(), this::setCdeCallAmountLeg2);
			merger.mergeBasic(getCdeCallCurrencyLeg1(), o.getCdeCallCurrencyLeg1(), this::setCdeCallCurrencyLeg1);
			merger.mergeBasic(getCdeCallCurrencyLeg2(), o.getCdeCallCurrencyLeg2(), this::setCdeCallCurrencyLeg2);
			merger.mergeBasic(getCdePutAmountLeg1(), o.getCdePutAmountLeg1(), this::setCdePutAmountLeg1);
			merger.mergeBasic(getCdePutAmountLeg2(), o.getCdePutAmountLeg2(), this::setCdePutAmountLeg2);
			merger.mergeBasic(getCdePutCurrencyLeg1(), o.getCdePutCurrencyLeg1(), this::setCdePutCurrencyLeg1);
			merger.mergeBasic(getCdePutCurrencyLeg2(), o.getCdePutCurrencyLeg2(), this::setCdePutCurrencyLeg2);
			merger.mergeBasic(getLeg2QuantityFrequency(), o.getLeg2QuantityFrequency(), this::setLeg2QuantityFrequency);
			merger.mergeBasic(getQuantityFrequencyMultiplierLeg1(), o.getQuantityFrequencyMultiplierLeg1(), this::setQuantityFrequencyMultiplierLeg1);
			merger.mergeBasic(getQuantityFrequencyMultiplierLeg2(), o.getQuantityFrequencyMultiplierLeg2(), this::setQuantityFrequencyMultiplierLeg2);
			merger.mergeBasic(getCdeQuantityUnitOfMeasureLeg1(), o.getCdeQuantityUnitOfMeasureLeg1(), this::setCdeQuantityUnitOfMeasureLeg1);
			merger.mergeBasic(getCdeQuantityUnitOfMeasureLeg2(), o.getCdeQuantityUnitOfMeasureLeg2(), this::setCdeQuantityUnitOfMeasureLeg2);
			merger.mergeBasic(getPackageIndicator(), o.getPackageIndicator(), this::setPackageIndicator);
			merger.mergeBasic(getCdePackageIdentifier(), o.getCdePackageIdentifier(), this::setCdePackageIdentifier);
			merger.mergeBasic(getCdePackageTransactionPrice(), o.getCdePackageTransactionPrice(), this::setCdePackageTransactionPrice);
			merger.mergeBasic(getCdePackageTransactionPriceCurrency(), o.getCdePackageTransactionPriceCurrency(), this::setCdePackageTransactionPriceCurrency);
			merger.mergeBasic(getCdePackageTransactionPriceNotation(), o.getCdePackageTransactionPriceNotation(), this::setCdePackageTransactionPriceNotation);
			merger.mergeBasic(getCdePackageTransactionSpread(), o.getCdePackageTransactionSpread(), this::setCdePackageTransactionSpread);
			merger.mergeBasic(getCdePackageTransactionSpreadCurrency(), o.getCdePackageTransactionSpreadCurrency(), this::setCdePackageTransactionSpreadCurrency);
			merger.mergeBasic(getCdePackageTransactionSpreadNotation(), o.getCdePackageTransactionSpreadNotation(), this::setCdePackageTransactionSpreadNotation);
			merger.mergeBasic(getCdeFixedRateDayCountConventionLeg1(), o.getCdeFixedRateDayCountConventionLeg1(), this::setCdeFixedRateDayCountConventionLeg1);
			merger.mergeBasic(getCdeFixedRateDayCountConventionLeg2(), o.getCdeFixedRateDayCountConventionLeg2(), this::setCdeFixedRateDayCountConventionLeg2);
			merger.mergeBasic(getCdeFloatingRateDayCountConventionLeg1(), o.getCdeFloatingRateDayCountConventionLeg1(), this::setCdeFloatingRateDayCountConventionLeg1);
			merger.mergeBasic(getCdeFloatingRateDayCountConventionLeg2(), o.getCdeFloatingRateDayCountConventionLeg2(), this::setCdeFloatingRateDayCountConventionLeg2);
			merger.mergeBasic(getFixingDateLeg1(), o.getFixingDateLeg1(), this::setFixingDateLeg1);
			merger.mergeBasic(getFixingDateLeg2(), o.getFixingDateLeg2(), this::setFixingDateLeg2);
			merger.mergeBasic(getCdeFixedRatePaymentFrequencyPeriodLeg1(), o.getCdeFixedRatePaymentFrequencyPeriodLeg1(), this::setCdeFixedRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getCdeFixedRatePaymentFrequencyPeriodLeg2(), o.getCdeFixedRatePaymentFrequencyPeriodLeg2(), this::setCdeFixedRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getCdeFloatingRatePaymentFrequencyPeriodLeg1(), o.getCdeFloatingRatePaymentFrequencyPeriodLeg1(), this::setCdeFloatingRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getCdeFloatingRatePaymentFrequencyPeriodLeg2(), o.getCdeFloatingRatePaymentFrequencyPeriodLeg2(), this::setCdeFloatingRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(), o.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this::setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(), o.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this::setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), o.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this::setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), o.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this::setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getPostPricedSwapIndicator(), o.getPostPricedSwapIndicator(), this::setPostPricedSwapIndicator);
			merger.mergeBasic(getCdePriceCurrency(), o.getCdePriceCurrency(), this::setCdePriceCurrency);
			merger.mergeBasic(getCdePriceNotation(), o.getCdePriceNotation(), this::setCdePriceNotation);
			merger.mergeBasic(getCdeSpreadNotationLeg1(), o.getCdeSpreadNotationLeg1(), this::setCdeSpreadNotationLeg1);
			merger.mergeBasic(getCdeSpreadNotationLeg2(), o.getCdeSpreadNotationLeg2(), this::setCdeSpreadNotationLeg2);
			merger.mergeBasic(getCdeStrikePriceCurrency2(), o.getCdeStrikePriceCurrency2(), this::setCdeStrikePriceCurrency2);
			merger.mergeBasic(getCdeStrikePriceNotation(), o.getCdeStrikePriceNotation(), this::setCdeStrikePriceNotation);
			merger.mergeBasic(getCdeFirstExerciseDate(), o.getCdeFirstExerciseDate(), this::setCdeFirstExerciseDate);
			merger.mergeBasic(getCdeFinalContractualSettlementDate(), o.getCdeFinalContractualSettlementDate(), this::setCdeFinalContractualSettlementDate);
			merger.mergeBasic(getCdeSettlementLocationLeg1(), o.getCdeSettlementLocationLeg1(), this::setCdeSettlementLocationLeg1);
			merger.mergeBasic(getCdeSettlementLocationLeg2(), o.getCdeSettlementLocationLeg2(), this::setCdeSettlementLocationLeg2);
			merger.mergeBasic(getCdeEffectiveDate(), o.getCdeEffectiveDate(), this::setCdeEffectiveDate);
			merger.mergeBasic(getCdeExpirationDate(), o.getCdeExpirationDate(), this::setCdeExpirationDate);
			merger.mergeBasic(getCdePlatformIdentifier(), o.getCdePlatformIdentifier(), this::setCdePlatformIdentifier);
			merger.mergeBasic(getPrimeBrokerageTransactionIndicator(), o.getPrimeBrokerageTransactionIndicator(), this::setPrimeBrokerageTransactionIndicator);
			merger.mergeBasic(getSwapReportingJurisdiction(), o.getSwapReportingJurisdiction(), this::setSwapReportingJurisdiction);
			merger.mergeBasic(getNewSdrIdentifier(), o.getNewSdrIdentifier(), this::setNewSdrIdentifier);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg1(), o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1);
			merger.mergeBasic(getLastFloatingReferenceValueLeg1(), o.getLastFloatingReferenceValueLeg1(), this::setLastFloatingReferenceValueLeg1);
			merger.mergeBasic(getLastFloatingReferenceResetDateLeg1(), o.getLastFloatingReferenceResetDateLeg1(), this::setLastFloatingReferenceResetDateLeg1);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg2(), o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2);
			merger.mergeBasic(getLastFloatingReferenceValueLeg2(), o.getLastFloatingReferenceValueLeg2(), this::setLastFloatingReferenceValueLeg2);
			merger.mergeBasic(getLastFloatingReferenceResetDateLeg2(), o.getLastFloatingReferenceResetDateLeg2(), this::setLastFloatingReferenceResetDateLeg2);
			merger.mergeBasic(getCdeDelta(), o.getCdeDelta(), this::setCdeDelta);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getLargeNotionalOffFacilitySwapElectionIndicator(), o.getLargeNotionalOffFacilitySwapElectionIndicator(), this::setLargeNotionalOffFacilitySwapElectionIndicator);
			merger.mergeBasic(getSefOrDcmAnonymousExecutionIndicator(), o.getSefOrDcmAnonymousExecutionIndicator(), this::setSefOrDcmAnonymousExecutionIndicator);
			merger.mergeBasic(getBlockTradeElectionIndicator(), o.getBlockTradeElectionIndicator(), this::setBlockTradeElectionIndicator);
			merger.mergeBasic(getSefOrDcmIndicator(), o.getSefOrDcmIndicator(), this::setSefOrDcmIndicator);
			merger.mergeBasic(getMandatoryClearingIndicator(), o.getMandatoryClearingIndicator(), this::setMandatoryClearingIndicator);
			merger.mergeBasic(getSdMspIndicatorCounterparty1(), o.getSdMspIndicatorCounterparty1(), this::setSdMspIndicatorCounterparty1);
			merger.mergeBasic(getSdMspIndicatorCounterparty2(), o.getSdMspIndicatorCounterparty2(), this::setSdMspIndicatorCounterparty2);
			merger.mergeBasic(getPhysicalCommodityContractIndicator(), o.getPhysicalCommodityContractIndicator(), this::setPhysicalCommodityContractIndicator);
			merger.mergeBasic(getChangeInNotionalAmount1(), o.getChangeInNotionalAmount1(), this::setChangeInNotionalAmount1);
			merger.mergeBasic(getChangeInNotionalAmount2(), o.getChangeInNotionalAmount2(), this::setChangeInNotionalAmount2);
			merger.mergeBasic(getChangeInLeg1NotionalQuantity(), o.getChangeInLeg1NotionalQuantity(), this::setChangeInLeg1NotionalQuantity);
			merger.mergeBasic(getChangeInLeg2NotionalQuantity(), o.getChangeInLeg2NotionalQuantity(), this::setChangeInLeg2NotionalQuantity);
			merger.mergeBasic(getCdeCryptoAssetUnderlyingIndicatorLeg1(), o.getCdeCryptoAssetUnderlyingIndicatorLeg1(), this::setCdeCryptoAssetUnderlyingIndicatorLeg1);
			merger.mergeBasic(getCdeCryptoAssetUnderlyingIndicatorLeg2(), o.getCdeCryptoAssetUnderlyingIndicatorLeg2(), this::setCdeCryptoAssetUnderlyingIndicatorLeg2);
			merger.mergeBasic(getCdeCustomBasketCode(), o.getCdeCustomBasketCode(), this::setCdeCustomBasketCode);
			merger.mergeBasic(getUnderlierIdOtherLeg1(), o.getUnderlierIdOtherLeg1(), this::setUnderlierIdOtherLeg1);
			merger.mergeBasic(getUnderlierIdOtherLeg2(), o.getUnderlierIdOtherLeg2(), this::setUnderlierIdOtherLeg2);
			merger.mergeBasic(getUnderlierIdOtherSourceLeg1(), o.getUnderlierIdOtherSourceLeg1(), this::setUnderlierIdOtherSourceLeg1);
			merger.mergeBasic(getUnderlierIdOtherSourceLeg2(), o.getUnderlierIdOtherSourceLeg2(), this::setUnderlierIdOtherSourceLeg2);
			merger.mergeBasic(getCdeUnderlyingAssetTradingPlatformIdLeg1(), o.getCdeUnderlyingAssetTradingPlatformIdLeg1(), this::setCdeUnderlyingAssetTradingPlatformIdLeg1);
			merger.mergeBasic(getCdeUnderlyingAssetTradingPlatformIdLeg2(), o.getCdeUnderlyingAssetTradingPlatformIdLeg2(), this::setCdeUnderlyingAssetTradingPlatformIdLeg2);
			merger.mergeBasic(getCdeUnderlyingAssetPriceSourceLeg1(), o.getCdeUnderlyingAssetPriceSourceLeg1(), this::setCdeUnderlyingAssetPriceSourceLeg1);
			merger.mergeBasic(getCdeUnderlyingAssetPriceSourceLeg2(), o.getCdeUnderlyingAssetPriceSourceLeg2(), this::setCdeUnderlyingAssetPriceSourceLeg2);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HarmonizedData _that = getType().cast(o);
		
			if (!Objects.equals(leg2CommodityInstrumentId, _that.getLeg2CommodityInstrumentId())) return false;
			if (!Objects.equals(leg2CommodityUnderlyerId, _that.getLeg2CommodityUnderlyerId())) return false;
			if (!Objects.equals(leg2CommodityUnderlyerDetails, _that.getLeg2CommodityUnderlyerDetails())) return false;
			if (!Objects.equals(leg2CommodityUnitOfMeasure, _that.getLeg2CommodityUnitOfMeasure())) return false;
			if (!Objects.equals(leg2CommodityCurrency, _that.getLeg2CommodityCurrency())) return false;
			if (!Objects.equals(leg2CommodityExchangeId, _that.getLeg2CommodityExchangeId())) return false;
			if (!Objects.equals(leg1CommodityRateSource, _that.getLeg1CommodityRateSource())) return false;
			if (!Objects.equals(leg1CommodityRateSourcePage, _that.getLeg1CommodityRateSourcePage())) return false;
			if (!Objects.equals(leg2SpecifiedPrice, _that.getLeg2SpecifiedPrice())) return false;
			if (!Objects.equals(commencementDateUnadjusted, _that.getCommencementDateUnadjusted())) return false;
			if (!Objects.equals(exerciseExpirationDateUnadjusted, _that.getExerciseExpirationDateUnadjusted())) return false;
			if (!Objects.equals(expirationDateUnadjusted, _that.getExpirationDateUnadjusted())) return false;
			if (!Objects.equals(leg2NotionalQuantityFrequency, _that.getLeg2NotionalQuantityFrequency())) return false;
			if (!Objects.equals(leg2NotionalQuantity, _that.getLeg2NotionalQuantity())) return false;
			if (!Objects.equals(leg2TotalNotionalQuantity, _that.getLeg2TotalNotionalQuantity())) return false;
			if (!Objects.equals(leg2SpreadAmount, _that.getLeg2SpreadAmount())) return false;
			if (!Objects.equals(leg2SpreadCurrency, _that.getLeg2SpreadCurrency())) return false;
			if (!Objects.equals(scheduledTerm