package iso20022.dtcc.rds.harmonized.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class HarmonizedDataTypeFormatValidator implements Validator<HarmonizedData> {

	private List<ComparisonResult> getComparisonResults(HarmonizedData o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("leg2CommodityInstrumentId", o.getLeg2CommodityInstrumentId(), 0, of(150), empty()), 
				checkString("leg2CommodityUnderlyerId", o.getLeg2CommodityUnderlyerId(), 0, of(500), empty()), 
				checkString("leg2CommodityUnderlyerDetails", o.getLeg2CommodityUnderlyerDetails(), 0, of(50), empty()), 
				checkString("leg2CommodityUnitOfMeasure", o.getLeg2CommodityUnitOfMeasure(), 0, of(500), empty()), 
				checkString("leg2CommodityCurrency", o.getLeg2CommodityCurrency(), 0, of(500), empty()), 
				checkString("leg2CommodityExchangeId", o.getLeg2CommodityExchangeId(), 0, of(500), empty()), 
				checkString("leg1CommodityRateSource", o.getLeg1CommodityRateSource(), 0, of(500), empty()), 
				checkString("leg1CommodityRateSourcePage", o.getLeg1CommodityRateSourcePage(), 0, of(50), empty()), 
				checkString("leg2SpecifiedPrice", o.getLeg2SpecifiedPrice(), 0, of(500), empty()), 
				checkString("leg2NotionalQuantityFrequency", o.getLeg2NotionalQuantityFrequency(), 0, of(500), empty()), 
				checkString("leg2SpreadCurrency", o.getLeg2SpreadCurrency(), 0, of(500), empty()), 
				checkString("leg1PartyPayer", o.getLeg1PartyPayer(), 0, of(200), empty()), 
				checkString("leg2PartyPayer", o.getLeg2PartyPayer(), 0, of(200), empty()), 
				checkString("leg1CommodityInstrumentId", o.getLeg1CommodityInstrumentId(), 0, of(150), empty()), 
				checkString("leg1CommodityUnderlyerId", o.getLeg1CommodityUnderlyerId(), 0, of(500), empty()), 
				checkString("leg1CommodityUnitOfMeasure", o.getLeg1CommodityUnitOfMeasure(), 0, of(500), empty()), 
				checkString("leg1CommodityExchangeId", o.getLeg1CommodityExchangeId(), 0, of(500), empty()), 
				checkString("leg2CommodityRateSource", o.getLeg2CommodityRateSource(), 0, of(500), empty()), 
				checkString("coProductType", o.getCoProductType(), 0, of(500), empty()), 
				checkString("totalQuantityUnit", o.getTotalQuantityUnit(), 0, of(500), empty()), 
				checkString("fixedPriceCurrency", o.getFixedPriceCurrency(), 0, of(500), empty()), 
				checkString("leg1NotionalQuantityUnit", o.getLeg1NotionalQuantityUnit(), 0, of(500), empty()), 
				checkString("leg1NotionalQuantityFrequency", o.getLeg1NotionalQuantityFrequency(), 0, of(500), empty()), 
				checkString("leg1CommodityCurrency", o.getLeg1CommodityCurrency(), 0, of(500), empty()), 
				checkString("leg1SpecifiedPrice", o.getLeg1SpecifiedPrice(), 0, of(500), empty()), 
				checkString("leg1SpreadCurrency", o.getLeg1SpreadCurrency(), 0, of(500), empty()), 
				checkString("leg2NotionalQuantityUnit", o.getLeg2NotionalQuantityUnit(), 0, of(500), empty()), 
				checkString("leg2PartyReceiver", o.getLeg2PartyReceiver(), 0, of(200), empty()), 
				checkString("leg1PartyReceiver", o.getLeg1PartyReceiver(), 0, of(200), empty()), 
				checkString("coalSource", o.getCoalSource(), 0, of(50), empty()), 
				checkString("commodityBase", o.getCommodityBase(), 0, of(500), empty()), 
				checkString("commodityDetails", o.getCommodityDetails(), 0, of(500), empty()), 
				checkString("interconnectionPoint", o.getInterconnectionPoint(), 0, of(40), empty()), 
				checkString("loadType", o.getLoadType(), 0, of(500), empty()), 
				checkString("fixedPriceUnit", o.getFixedPriceUnit(), 0, of(500), empty()), 
				checkString("deliveryLocation", o.getDeliveryLocation(), 0, of(40), empty()), 
				checkString("leg2QuantityUnit", o.getLeg2QuantityUnit(), 0, of(500), empty()), 
				checkString("leg1CommodityUnderlyerDetails", o.getLeg1CommodityUnderlyerDetails(), 0, of(50), empty()), 
				checkString("leg2CommodityRateSourcePage", o.getLeg2CommodityRateSourcePage(), 0, of(50), empty()), 
				checkString("gtrQuantityUnit", o.getGtrQuantityUnit(), 0, of(500), empty()), 
				checkString("seniority", o.getSeniority(), 0, of(500), empty()), 
				checkString("tranche", o.getTranche(), 0, of(500), empty()), 
				checkString("referenceObligation", o.getReferenceObligation(), 0, of(200), empty()), 
				checkString("referenceObligationIdType", o.getReferenceObligationIdType(), 0, of(500), empty()), 
				checkString("underlyingFixedRatePayerBuyer", o.getUnderlyingFixedRatePayerBuyer(), 0, of(200), empty()), 
				checkString("underlyingFloatRatePayerSeller", o.getUnderlyingFloatRatePayerSeller(), 0, of(200), empty()), 
				checkString("underlyingAssetExchangeId", o.getUnderlyingAssetExchangeId(), 0, of(6450), empty()), 
				checkString("optionalEarlyTerminationType", o.getOptionalEarlyTerminationType(), 0, of(500), empty()), 
				checkString("optionalEarlyTerminationElectingPartyValue", o.getOptionalEarlyTerminationElectingPartyValue(), 0, of(200), empty()), 
				checkString("underlyingAssetFloatingAmountPayer", o.getUnderlyingAssetFloatingAmountPayer(), 0, of(200), empty()), 
				checkString("underlyingAssetFloatingAmountReceiver", o.getUnderlyingAssetFloatingAmountReceiver(), 0, of(200), empty()), 
				checkString("floatingRateOption", o.getFloatingRateOption(), 0, of(100), empty()), 
				checkString("leg2DesignatedMaturityPeriod", o.getLeg2DesignatedMaturityPeriod(), 0, of(500), empty()), 
				checkString("underlyingAssetEquityAmountPayer", o.getUnderlyingAssetEquityAmountPayer(), 0, of(200), empty()), 
				checkString("underlyingAssetEquityAmountReceiver", o.getUnderlyingAssetEquityAmountReceiver(), 0, of(200), empty()), 
				checkString("underlyingAssetInitialPriceCurrency", o.getUnderlyingAssetInitialPriceCurrency(), 0, of(500), empty()), 
				checkString("leg1TypeOfReturn", o.getLeg1TypeOfReturn(), 0, of(500), empty()), 
				checkString("referenceCurrency", o.getReferenceCurrency(), 0, of(500), empty()), 
				checkString("specialDividendsIndicator", o.getSpecialDividendsIndicator(), 0, of(500), empty()), 
				checkString("materialNoncashDividendIndicator", o.getMaterialNoncashDividendIndicator(), 0, of(500), empty()), 
				checkString("dividendAmountPayer", o.getDividendAmountPayer(), 0, of(200), empty()), 
				checkString("dividendAmountReceiver", o.getDividendAmountReceiver(), 0, of(200), empty()), 
				checkString("fixedAmountPayer", o.getFixedAmountPayer(), 0, of(200), empty()), 
				checkString("fixedAmountReceiver", o.getFixedAmountReceiver(), 0, of(200), empty()), 
				checkString("knockInEvent", o.getKnockInEvent(), 0, of(20), empty()), 
				checkString("knockOutEvent", o.getKnockOutEvent(), 0, of(20), empty()), 
				checkString("barrierType", o.getBarrierType(), 0, of(500), empty()), 
				checkString("exchangeRateBasisCurrency1", o.getExchangeRateBasisCurrency1(), 0, of(500), empty()), 
				checkString("exchangeRateBasisCurrency2", o.getExchangeRateBasisCurrency2(), 0, of(500), empty()), 
				checkString("payoutStyle", o.getPayoutStyle(), 0, of(500), empty()), 
				checkString("rateQuoteBasis1", o.getRateQuoteBasis1(), 0, of(500), empty()), 
				checkString("swapLinkId", o.getSwapLinkId(), 0, of(100), empty()), 
				checkString("triggerCondition", o.getTriggerCondition(), 0, of(500), empty()), 
				checkString("triggerCondition2", o.getTriggerCondition2(), 0, of(500), empty()), 
				checkString("rateQuoteBasis2", o.getRateQuoteBasis2(), 0, of(500), empty()), 
				checkString("barrierType2", o.getBarrierType2(), 0, of(500), empty()), 
				checkString("cancelationOptionBuyer", o.getCancelationOptionBuyer(), 0, of(200), empty()), 
				checkString("cancelationOptionExerciseStyleType", o.getCancelationOptionExerciseStyleType(), 0, of(20), empty()), 
				checkString("cancelationOptionInitialFeeCurrency", o.getCancelationOptionInitialFeeCurrency(), 0, of(500), empty()), 
				checkString("cancelationOptionInitialFeePayer", o.getCancelationOptionInitialFeePayer(), 0, of(200), empty()), 
				checkString("cancelationOptionSeller", o.getCancelationOptionSeller(), 0, of(200), empty()), 
				checkString("couponType", o.getCouponType(), 0, of(500), empty()), 
				checkString("fraDiscountingType", o.getFraDiscountingType(), 0, of(500), empty()), 
				checkString("inflationIndexMainPublication", o.getInflationIndexMainPublication(), 0, of(500), empty()), 
				checkString("inflationInterpolationMethod", o.getInflationInterpolationMethod(), 0, of(500), empty()), 
				checkString("inflationLagDayType", o.getInflationLagDayType(), 0, of(500), empty()), 
				checkString("inflationLagPeriod", o.getInflationLagPeriod(), 0, of(500), empty()), 
				checkString("inflationRateSourceName", o.getInflationRateSourceName(), 0, of(500), empty()), 
				checkString("leg1FloatingRateIndex", o.getLeg1FloatingRateIndex(), 0, of(100), empty()), 
				checkString("leg1FloatingRateTenorPeriod", o.getLeg1FloatingRateTenorPeriod(), 0, of(500), empty()), 
				checkString("leg1KnownAmountCurrency", o.getLeg1KnownAmountCurrency(), 0, of(500), empty()), 
				checkString("leg1ReferenceCurrency", o.getLeg1ReferenceCurrency(), 0, of(500), empty()), 
				checkString("leg2FloatingRateIndex", o.getLeg2FloatingRateIndex(), 0, of(100), empty()), 
				checkString("leg2FloatingRateTenorPeriod", o.getLeg2FloatingRateTenorPeriod(), 0, of(500), empty()), 
				checkString("leg2KnownAmountCurrency", o.getLeg2KnownAmountCurrency(), 0, of(500), empty()), 
				checkString("leg2ReferenceCurrency", o.getLeg2ReferenceCurrency(), 0, of(500), empty()), 
				checkString("mandatoryEarlyTerminationDateTenorPeriod", o.getMandatoryEarlyTerminationDateTenorPeriod(), 0, of(500), empty()), 
				checkString("mandatoryEarlyTerminationDateTenorPeriodMultiplier", o.getMandatoryEarlyTerminationDateTenorPeriodMultiplier(), 0, of(3), empty()), 
				checkString("optionalEarlyTerminationExerciseStyle", o.getOptionalEarlyTerminationExerciseStyle(), 0, of(500), empty()), 
				checkString("premiumReceiver", o.getPremiumReceiver(), 0, of(200), empty()), 
				checkString("underlyingProductId", o.getUnderlyingProductId(), 0, of(50), empty()), 
				checkString("inflationLagPeriodMultiplier", o.getInflationLagPeriodMultiplier(), 0, of(3), empty()), 
				checkString("leg1FixedRateNotation", o.getLeg1FixedRateNotation(), 0, of(500), empty()), 
				checkString("leg2FixedRateNotation", o.getLeg2FixedRateNotation(), 0, of(500), empty()), 
				checkString("swaptionStraddleIndicator", o.getSwaptionStraddleIndicator(), 0, of(500), empty()), 
				checkString("singlePartyEarlyTerminationBuyer", o.getSinglePartyEarlyTerminationBuyer(), 0, of(200), empty()), 
				checkString("action", o.getAction(), 0, of(500), empty()), 
				checkString("clearingStatus", o.getClearingStatus(), 0, of(500), empty()), 
				checkString("executionVenueType", o.getExecutionVenueType(), 0, of(500), empty()), 
				checkString("notionalCurrency1", o.getNotionalCurrency1(), 0, of(500), empty()), 
				checkString("price1Type", o.getPrice1Type(), 0, of(500), empty()), 
				checkString("price1Units", o.getPrice1Units(), 0, of(500), empty()), 
				checkString("tradeParty1CollateralizationType", o.getTradeParty1CollateralizationType(), 0, of(500), empty()), 
				checkString("tradeParty1EventId", o.getTradeParty1EventId(), 0, of(100), empty()), 
				checkString("tradeParty2CollateralizationType", o.getTradeParty2CollateralizationType(), 0, of(500), empty()), 
				checkString("tradeParty2EventId", o.getTradeParty2EventId(), 0, of(100), empty()), 
				checkString("embeddedOptionOnSwap", o.getEmbeddedOptionOnSwap(), 0, of(500), empty()), 
				checkString("notionalCurrency2", o.getNotionalCurrency2(), 0, of(500), empty()), 
				checkString("premiumCurrency", o.getPremiumCurrency(), 0, of(500), empty()), 
				checkString("version", o.getVersion(), 0, of(100), empty()), 
				checkString("comment1", o.getComment1(), 0, of(500), empty()), 
				checkString("optionStyle", o.getOptionStyle(), 0, of(500), empty()), 
				checkString("optionType", o.getOptionType(), 0, of(500), empty()), 
				checkString("settlementCurrency1", o.getSettlementCurrency1(), 0, of(500), empty()), 
				checkString("dayCountFraction1", o.getDayCountFraction1(), 0, of(40), empty()), 
				checkString("leg2DayCountFraction", o.getLeg2DayCountFraction(), 0, of(40), empty()), 
				checkString("leg2ResetFrequencyPeriod", o.getLeg2ResetFrequencyPeriod(), 0, of(500), empty()), 
				checkString("leg2SettlementCurrency", o.getLeg2SettlementCurrency(), 0, of(500), empty()), 
				checkString("payment1FrequencyPeriod", o.getPayment1FrequencyPeriod(), 0, of(500), empty()), 
				checkString("payment2FrequencyPeriod", o.getPayment2FrequencyPeriod(), 0, of(500), empty()), 
				checkString("resetFrequencyPeriod1", o.getResetFrequencyPeriod1(), 0, of(500), empty()), 
				checkString("strikePriceUnits", o.getStrikePriceUnits(), 0, of(500), empty()), 
				checkString("clearingVenueId", o.getClearingVenueId(), 0, of(20), empty()), 
				checkString("clearingVenueIdType", o.getClearingVenueIdType(), 0, of(500), empty()), 
				checkString("compressedTradeIndicator", o.getCompressedTradeIndicator(), 0, of(500), empty()), 
				checkString("confirmationMethod", o.getConfirmationMethod(), 0, of(500), empty()), 
				checkString("confirmationPlatformId", o.getConfirmationPlatformId(), 0, of(50), empty()), 
				checkString("confirmationPlatformTradeId", o.getConfirmationPlatformTradeId(), 0, of(40), empty()), 
				checkString("executionVenueId", o.getExecutionVenueId(), 0, of(200), empty()), 
				checkString("executionVenueIdType", o.getExecutionVenueIdType(), 0, of(500), empty()), 
				checkString("priorUsiId", o.getPriorUsiId(), 0, of(200), empty()), 
				checkString("priorUsiIdPrefix", o.getPriorUsiIdPrefix(), 0, of(40), empty()), 
				checkString("priorUtiId", o.getPriorUtiId(), 0, of(200), empty()), 
				checkString("priorUtiIdPrefix", o.getPriorUtiIdPrefix(), 0, of(40), empty()), 
				checkString("tradeParty1BranchLocation", o.getTradeParty1BranchLocation(), 0, of(500), empty()), 
				checkString("tradeParty1ClearingBrokerId", o.getTradeParty1ClearingBrokerId(), 0, of(200), empty()), 
				checkString("tradeParty1ClearingBrokerIdType", o.getTradeParty1ClearingBrokerIdType(), 0, of(500), empty()), 
				checkString("tradeParty1DeskLocation", o.getTradeParty1DeskLocation(), 0, of(500), empty()), 
				checkString("tradeParty1Domicile", o.getTradeParty1Domicile(), 0, of(500), empty()), 
				checkString("tradeParty1IndustrialSectorType", o.getTradeParty1IndustrialSectorType(), 0, of(500), empty()), 
				checkString("tradeParty2BranchLocation", o.getTradeParty2BranchLocation(), 0, of(500), empty()), 
				checkString("tradeParty2DeskLocation", o.getTradeParty2DeskLocation(), 0, of(500), empty()), 
				checkString("tradeParty2Domicile", o.getTradeParty2Domicile(), 0, of(500), empty()), 
				checkString("tradeParty2IndustrialSectorType", o.getTradeParty2IndustrialSectorType(), 0, of(500), empty()), 
				checkString("sellerPayer2", o.getSellerPayer2(), 0, of(200), empty()), 
				checkString("buyerPayer1", o.getBuyerPayer1(), 0, of(200), empty()), 
				checkString("tradeParty1HkCounterpartyOrigin", o.getTradeParty1HkCounterpartyOrigin(), 0, of(500), empty()), 
				checkString("payment1Currency", o.getPayment1Currency(), 0, of(500), empty()), 
				checkString("payment1Payer", o.getPayment1Payer(), 0, of(200), empty()), 
				checkString("payment1Receiver", o.getPayment1Receiver(), 0, of(200), empty()), 
				checkString("payment2Payer", o.getPayment2Payer(), 0, of(200), empty()), 
				checkString("secondaryAssetClass", o.getSecondaryAssetClass(), 0, of(500), empty()), 
				checkString("settlementType", o.getSettlementType(), 0, of(500), empty()), 
				checkString("tradeParty1Name", o.getTradeParty1Name(), 0, of(200), empty()), 
				checkString("tradeParty2Name", o.getTradeParty2Name(), 0, of(200), empty()), 
				checkString("ccpValuationCurrency", o.getCcpValuationCurrency(), 0, of(500), empty()), 
				checkString("ccpValuationType", o.getCcpValuationType(), 0, of(500), empty()), 
				checkString("tradeParty1ValuationCurrency", o.getTradeParty1ValuationCurrency(), 0, of(500), empty()), 
				checkString("tradeParty1ValuationType", o.getTradeParty1ValuationType(), 0, of(500), empty()), 
				checkString("tradeParty2ValuationCurrency", o.getTradeParty2ValuationCurrency(), 0, of(500), empty()), 
				checkString("tradeParty2ValuationType", o.getTradeParty2ValuationType(), 0, of(500), empty()), 
				checkString("executionType", o.getExecutionType(), 0, of(500), empty()), 
				checkString("strikePriceCurrency", o.getStrikePriceCurrency(), 0, of(500), empty()), 
				checkString("tradeParty2HkCounterpartyOrigin", o.getTradeParty2HkCounterpartyOrigin(), 0, of(500), empty()), 
				checkString("tradeParty1CountryOfTheOtherCounterparty", o.getTradeParty1CountryOfTheOtherCounterparty(), 0, of(500), empty()), 
				checkString("tradeParty2CountryOfTheOtherCounterparty", o.getTradeParty2CountryOfTheOtherCounterparty(), 0, of(500), empty()), 
				checkString("tradeParty1BrokerId", o.getTradeParty1BrokerId(), 0, of(200), empty()), 
				checkString("tradeParty2BrokerId", o.getTradeParty2BrokerId(), 0, of(200), empty()), 
				checkString("tradeParty1BeneficiaryIdType", o.getTradeParty1BeneficiaryIdType(), 0, of(500), empty()), 
				checkString("tradeParty1BeneficiaryId", o.getTradeParty1BeneficiaryId(), 0, of(200), empty()), 
				checkString("tradeParty2BeneficiaryIdType", o.getTradeParty2BeneficiaryIdType(), 0, of(500), empty()), 
				checkString("tradeParty2BeneficiaryId", o.getTradeParty2BeneficiaryId(), 0, of(200), empty()), 
				checkString("tradeParty1CounterpartySide", o.getTradeParty1CounterpartySide(), 0, of(500), empty()), 
				checkString("tradeParty2CounterpartySide", o.getTradeParty2CounterpartySide(), 0, of(500), empty()), 
				checkString("tradeParty1CollateralPortfolioCode", o.getTradeParty1CollateralPortfolioCode(), 0, of(52), empty()), 
				checkString("tradeParty2CollateralPortfolioCode", o.getTradeParty2CollateralPortfolioCode(), 0, of(52), empty()), 
				checkString("contractType", o.getContractType(), 0, of(500), empty()), 
				checkString("euUnderlyingAssetIdType", o.getEuUnderlyingAssetIdType(), 0, of(500), empty()), 
				checkString("productClassification", o.getProductClassification(), 0, of(6), empty()), 
				checkString("complexTradeComponentId", o.getComplexTradeComponentId(), 0, of(35), empty()), 
				checkString("masterAgreementType", o.getMasterAgreementType(), 0, of(100), empty()), 
				checkString("masterAgreementVersion", o.getMasterAgreementVersion(), 0, of(4), empty()), 
				checkString("level", o.getLevel(), 0, of(500), empty()), 
				checkString("productClassificationType", o.getProductClassificationType(), 0, of(500), empty()), 
				checkString("productIdentificationType", o.getProductIdentificationType(), 0, of(500), empty()), 
				checkString("productIdentification", o.getProductIdentification(), 0, of(48), empty()), 
				checkString("euUnderlyingAssetId", o.getEuUnderlyingAssetId(), 0, of(6499), empty()), 
				checkString("reportTrackingNumber", o.getReportTrackingNumber(), 0, of(52), empty()), 
				checkString("tradeParty1BrokerIdType", o.getTradeParty1BrokerIdType(), 0, of(500), empty()), 
				checkString("tradeParty2BrokerIdType", o.getTradeParty2BrokerIdType(), 0, of(500), empty()), 
				checkString("tradeParty2ClearingBrokerIdType", o.getTradeParty2ClearingBrokerIdType(), 0, of(500), empty()), 
				checkString("tradeParty2ClearingBrokerId", o.getTradeParty2ClearingBrokerId(), 0, of(200), empty()), 
				checkString("tradeParty1CorporateSectorType", o.getTradeParty1CorporateSectorType(), 0, of(255), empty()), 
				checkString("tradeParty2CorporateSectorType", o.getTradeParty2CorporateSectorType(), 0, of(255), empty()), 
				checkString("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator", o.getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), 0, of(500), empty()), 
				checkString("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator", o.getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(), 0, of(500), empty()), 
				checkString("tradeParty1TradingCapacity1", o.getTradeParty1TradingCapacity1(), 0, of(500), empty()), 
				checkString("tradeParty2TradingCapacity1", o.getTradeParty2TradingCapacity1(), 0, of(500), empty()), 
				checkString("currencyOfPrice", o.getCurrencyOfPrice(), 0, of(500), empty()), 
				checkString("tradeParty1CollateralPortfolio", o.getTradeParty1CollateralPortfolio(), 0, of(500), empty()), 
				checkString("tradeParty2CollateralPortfolio", o.getTradeParty2CollateralPortfolio(), 0, of(500), empty()), 
				checkString("executionVenueMicCode", o.getExecutionVenueMicCode(), 0, of(10), empty()), 
				checkString("payment2Currency", o.getPayment2Currency(), 0, of(500), empty()), 
				checkString("expirationDateTimeBusinessCenter", o.getExpirationDateTimeBusinessCenter(), 0, of(500), empty()), 
				checkString("expirationTimeType", o.getExpirationTimeType(), 0, of(500), empty()), 
				checkString("tradeParty1TraderLocation", o.getTradeParty1TraderLocation(), 0, of(500), empty()), 
				checkString("tradeParty2TraderLocation", o.getTradeParty2TraderLocation(), 0, of(500), empty()), 
				checkString("payment3ResetFrequencyPeriod", o.getPayment3ResetFrequencyPeriod(), 0, of(1), empty()), 
				checkString("payment4ResetFrequencyPeriod", o.getPayment4ResetFrequencyPeriod(), 0, of(1), empty()), 
				checkString("payment5ResetFrequencyPeriod", o.getPayment5ResetFrequencyPeriod(), 0, of(1), empty()), 
				checkString("payment1Type", o.getPayment1Type(), 0, of(500), empty()), 
				checkString("payment1Reference", o.getPayment1Reference(), 0, of(500), empty()), 
				checkString("payment2Type", o.getPayment2Type(), 0, of(500), empty()), 
				checkString("payment2Reference", o.getPayment2Reference(), 0, of(500), empty()), 
				checkString("payment3Payer", o.getPayment3Payer(), 0, of(200), empty()), 
				checkString("payment3Reference", o.getPayment3Reference(), 0, of(500), empty()), 
				checkString("payment3FrequencyPeriod", o.getPayment3FrequencyPeriod(), 0, of(500), empty()), 
				checkString("payment4Reference", o.getPayment4Reference(), 0, of(500), empty()), 
				checkString("payment4Payer", o.getPayment4Payer(), 0, of(200), empty()), 
				checkString("payment4FrequencyPeriod", o.getPayment4FrequencyPeriod(), 0, of(500), empty()), 
				checkString("payment5Reference", o.getPayment5Reference(), 0, of(500), empty()), 
				checkString("payment5Payer", o.getPayment5Payer(), 0, of(200), empty()), 
				checkString("payment5FrequencyPeriod", o.getPayment5FrequencyPeriod(), 0, of(500), empty()), 
				checkString("payment3Type", o.getPayment3Type(), 0, of(500), empty()), 
				checkString("premiumPayer", o.getPremiumPayer(), 0, of(500), empty()), 
				checkString("tradeParty1NatureOfTheReportingCounterparty", o.getTradeParty1NatureOfTheReportingCounterparty(), 0, of(500), empty()), 
				checkString("tradeParty2NatureOfTheReportingCounterparty", o.getTradeParty2NatureOfTheReportingCounterparty(), 0, of(500), empty()), 
				checkString("reservedParticipantUse1", o.getReservedParticipantUse1(), 0, of(100), empty()), 
				checkString("reservedParticipantUse2", o.getReservedParticipantUse2(), 0, of(100), empty()), 
				checkString("reservedParticipantUse3", o.getReservedParticipantUse3(), 0, of(100), empty()), 
				checkString("reservedParticipantUse4", o.getReservedParticipantUse4(), 0, of(100), empty()), 
				checkString("reservedParticipantUse5", o.getReservedParticipantUse5(), 0, of(100), empty()), 
				checkString("allocationType", o.getAllocationType(), 0, of(500), empty()), 
				checkString("calculationBasis", o.getCalculationBasis(), 0, of(40), empty()), 
				checkString("clearingExceptionPartyId", o.getClearingExceptionPartyId(), 0, of(200), empty()), 
				checkString("clearingExceptionPartyIdType", o.getClearingExceptionPartyIdType(), 0, of(500), empty()), 
				checkString("clearingExceptionType", o.getClearingExceptionType(), 0, of(500), empty()), 
				checkString("clearingMemberClientAccountId", o.getClearingMemberClientAccountId(), 0, of(200), empty()), 
				checkString("clearingSwapSdrLeiId", o.getClearingSwapSdrLeiId(), 0, of(20), empty()), 
				checkString("clearingSwapUtiId", o.getClearingSwapUtiId(), 0, of(3999), empty()), 
				checkString("comment2", o.getComment2(), 0, of(500), empty()), 
				checkString("commodityStrikePriceUnit", o.getCommodityStrikePriceUnit(), 0, of(500), empty()), 
				checkString("executionAgentMaskingIndicator", o.getExecutionAgentMaskingIndicator(), 0, of(500), empty()), 
				checkString("feeInCurrency", o.getFeeInCurrency(), 0, of(500), empty()), 
				checkString("feeOutCurrency", o.getFeeOutCurrency(), 0, of(500), empty()), 
				checkString("floatingRatePaymentFrequencyLeg1TimePeriod", o.getFloatingRatePaymentFrequencyLeg1TimePeriod(), 0, of(500), empty()), 
				checkString("floatingRatePaymentFrequencyLeg2TimePeriod", o.getFloatingRatePaymentFrequencyLeg2TimePeriod(), 0, of(500), empty()), 
				checkString("frequencyOfPayment", o.getFrequencyOfPayment(), 0, of(500), empty()), 
				checkString("leg1SettlementPeriod", o.getLeg1SettlementPeriod(), 0, of(500), empty()), 
				checkString("leg2PaymentTermsFrequencyPeriod", o.getLeg2PaymentTermsFrequencyPeriod(), 0, of(2), empty()), 
				checkString("leg2SettlementType", o.getLeg2SettlementType(), 0, of(500), empty()), 
				checkString("leg2UnderlyingAssetId", o.getLeg2UnderlyingAssetId(), 0, of(200), empty()), 
				checkString("leg2UnderlyingAssetIdType", o.getLeg2UnderlyingAssetIdType(), 0, of(500), empty()), 
				checkString("leg2UnderlyingAssetName", o.getLeg2UnderlyingAssetName(), 0, of(100), empty()), 
				checkString("optionalEarlyTerminationDate", o.getOptionalEarlyTerminationDate(), 0, of(500), empty()), 
				checkString("optionCommodityCurrency", o.getOptionCommodityCurrency(), 0, of(500), empty()), 
				checkString("optionCommodityExchangeId", o.getOptionCommodityExchangeId(), 0, of(500), empty()), 
				checkString("optionCommodityInstrumentId", o.getOptionCommodityInstrumentId(), 0, of(150), empty()), 
				checkString("optionCommodityRateSource", o.getOptionCommodityRateSource(), 0, of(500), empty()), 
				checkString("optionCommodityRateSourcePage", o.getOptionCommodityRateSourcePage(), 0, of(50), empty()), 
				checkString("optionCommodityUnderlyerDetails", o.getOptionCommodityUnderlyerDetails(), 0, of(50), empty()), 
				checkString("optionCommodityUnderlyerId", o.getOptionCommodityUnderlyerId(), 0, of(500), empty()), 
				checkString("optionCommodityUnitOfMeasure", o.getOptionCommodityUnitOfMeasure(), 0, of(500), empty()), 
				checkString("optionSpecifiedPrice", o.getOptionSpecifiedPrice(), 0, of(500), empty()), 
				checkString("optionSpreadCurrency", o.getOptionSpreadCurrency(), 0, of(500), empty()), 
				checkString("optionSpreadSchedule", o.getOptionSpreadSchedule(), 0, of(48), empty()), 
				checkString("origin", o.getOrigin(), 0, of(500), empty()), 
				checkString("originalSwapSdrId", o.getOriginalSwapSdrId(), 0, of(200), empty()), 
				checkString("originalSwapSdrIdType", o.getOriginalSwapSdrIdType(), 0, of(500), empty()), 
				checkString("paymentFrequencyPeriodLeg1", o.getPaymentFrequencyPeriodLeg1(), 0, of(500), empty()), 
				checkString("paymentFrequencyPeriodLeg2", o.getPaymentFrequencyPeriodLeg2(), 0, of(500), empty()), 
				checkString("premiumPayerPrefix", o.getPremiumPayerPrefix(), 0, of(500), empty()), 
				checkString("price1Currency", o.getPrice1Currency(), 0, of(500), empty()), 
				checkString("price2Type", o.getPrice2Type(), 0, of(500), empty()), 
				checkString("price2Units", o.getPrice2Units(), 0, of(500), empty()), 
				checkString("price3Type", o.getPrice3Type(), 0, of(500), empty()), 
				checkString("price3Units", o.getPrice3Units(), 0, of(500), empty()), 
				checkString("price4Type", o.getPrice4Type(), 0, of(500), empty()), 
				checkString("price4Units", o.getPrice4Units(), 0, of(500), empty()), 
				checkString("pricingContext", o.getPricingContext(), 0, of(500), empty()), 
				checkString("priorUsiType", o.getPriorUsiType(), 0, of(500), empty()), 
				checkString("priorUtiType", o.getPriorUtiType(), 0, of(500), empty()), 
				checkString("sendToDataCenterCode", o.getSendToDataCenterCode(), 0, of(50), empty()), 
				checkString("strikePriceType", o.getStrikePriceType(), 0, of(500), empty()), 
				checkString("subAssetClassForOtherCommodity", o.getSubAssetClassForOtherCommodity(), 0, of(500), empty()), 
				checkString("tradeParty1CftcFinancialEntityStatus", o.getTradeParty1CftcFinancialEntityStatus(), 0, of(500), empty()), 
				checkString("tradeParty1CollateralCurrency", o.getTradeParty1CollateralCurrency(), 0, of(500), empty()), 
				checkString("tradeParty1MandatoryDelegatedReporting", o.getTradeParty1MandatoryDelegatedReporting(), 0, of(500), empty()), 
				checkString("tradeParty1Role", o.getTradeParty1Role(), 0, of(500), empty()), 
				checkString("tradeParty2CftcFinancialEntityStatus", o.getTradeParty2CftcFinancialEntityStatus(), 0, of(500), empty()), 
				checkString("tradeParty2CollateralCurrency", o.getTradeParty2CollateralCurrency(), 0, of(500), empty()), 
				checkString("tradeParty2MandatoryDelegatedReporting", o.getTradeParty2MandatoryDelegatedReporting(), 0, of(500), empty()), 
				checkString("tradeParty2Role", o.getTradeParty2Role(), 0, of(500), empty()), 
				checkString("verificationMethod", o.getVerificationMethod(), 0, of(500), empty()), 
				checkString("responsibleDataSubmitterId", o.getResponsibleDataSubmitterId(), 0, of(200), empty()), 
				checkString("responsibleDataSubmitterIdType", o.getResponsibleDataSubmitterIdType(), 0, of(500), empty()), 
				checkString("originalSwapUsi", o.getOriginalSwapUsi(), 0, of(42), empty()), 
				checkString("originalSwapUti", o.getOriginalSwapUti(), 0, of(52), empty()), 
				checkString("cdeReceiverIdentifierLeg2", o.getCdeReceiverIdentifierLeg2(), 0, of(200), empty()), 
				checkString("noaActionType", o.getNoaActionType(), 0, of(500), empty()), 
				checkString("eventType", o.getEventType(), 0, of(500), empty()), 
				checkString("eventIdentifier", o.getEventIdentifier(), 0, of(52), empty()), 
				checkString("cdeCallCurrencyLeg1", o.getCdeCallCurrencyLeg1(), 0, of(500), empty()), 
				checkString("cdeCallCurrencyLeg2", o.getCdeCallCurrencyLeg2(), 0, of(500), empty()), 
				checkString("cdePutCurrencyLeg1", o.getCdePutCurrencyLeg1(), 0, of(500), empty()), 
				checkString("cdePutCurrencyLeg2", o.getCdePutCurrencyLeg2(), 0, of(500), empty()), 
				checkString("leg2QuantityFrequency", o.getLeg2QuantityFrequency(), 0, of(500), empty()), 
				checkString("cdeQuantityUnitOfMeasureLeg1", o.getCdeQuantityUnitOfMeasureLeg1(), 0, of(500), empty()), 
				checkString("cdeQuantityUnitOfMeasureLeg2", o.getCdeQuantityUnitOfMeasureLeg2(), 0, of(500), empty()), 
				checkString("cdePackageIdentifier", o.getCdePackageIdentifier(), 0, of(100), empty()), 
				checkString("cdePackageTransactionPriceCurrency", o.getCdePackageTransactionPriceCurrency(), 0, of(500), empty()), 
				checkString("cdePackageTransactionPriceNotation", o.getCdePackageTransactionPriceNotation(), 0, of(500), empty()), 
				checkString("cdePackageTransactionSpreadCurrency", o.getCdePackageTransactionSpreadCurrency(), 0, of(500), empty()), 
				checkString("cdePackageTransactionSpreadNotation", o.getCdePackageTransactionSpreadNotation(), 0, of(500), empty()), 
				checkString("cdeFixedRateDayCountConventionLeg1", o.getCdeFixedRateDayCountConventionLeg1(), 0, of(500), empty()), 
				checkString("cdeFixedRateDayCountConventionLeg2", o.getCdeFixedRateDayCountConventionLeg2(), 0, of(500), empty()), 
				checkString("cdeFloatingRateDayCountConventionLeg1", o.getCdeFloatingRateDayCountConventionLeg1(), 0, of(500), empty()), 
				checkString("cdeFloatingRateDayCountConventionLeg2", o.getCdeFloatingRateDayCountConventionLeg2(), 0, of(500), empty()), 
				checkString("cdeFixedRatePaymentFrequencyPeriodLeg1", o.getCdeFixedRatePaymentFrequencyPeriodLeg1(), 0, of(500), empty()), 
				checkString("cdeFixedRatePaymentFrequencyPeriodLeg2", o.getCdeFixedRatePaymentFrequencyPeriodLeg2(), 0, of(500), empty()), 
				checkString("cdeFloatingRatePaymentFrequencyPeriodLeg1", o.getCdeFloatingRatePaymentFrequencyPeriodLeg1(), 0, of(500), empty()), 
				checkString("cdeFloatingRatePaymentFrequencyPeriodLeg2", o.getCdeFloatingRatePaymentFrequencyPeriodLeg2(), 0, of(500), empty()), 
				checkString("cdePriceCurrency", o.getCdePriceCurrency(), 0, of(500), empty()), 
				checkString("cdePriceNotation", o.getCdePriceNotation(), 0, of(500), empty()), 
				checkString("cdeSpreadNotationLeg1", o.getCdeSpreadNotationLeg1(), 0, of(500), empty()), 
				checkString("cdeSpreadNotationLeg2", o.getCdeSpreadNotationLeg2(), 0, of(500), empty()), 
				checkString("cdeStrikePriceCurrency2", o.getCdeStrikePriceCurrency2(), 0, of(500), empty()), 
				checkString("cdeStrikePriceNotation", o.getCdeStrikePriceNotation(), 0, of(500), empty()), 
				checkString("cdeSettlementLocationLeg1", o.getCdeSettlementLocationLeg1(), 0, of(500), empty()), 
				checkString("cdeSettlementLocationLeg2", o.getCdeSettlementLocationLeg2(), 0, of(500), empty()), 
				checkString("cdePlatformIdentifier", o.getCdePlatformIdentifier(), 0, of(500), empty()), 
				checkString("swapReportingJurisdiction", o.getSwapReportingJurisdiction(), 0, of(500), empty()), 
				checkString("newSdrIdentifier", o.getNewSdrIdentifier(), 0, of(20), empty()), 
				checkString("initialMarginCollateralPortfolioCode", o.getInitialMarginCollateralPortfolioCode(), 0, of(52), empty()), 
				checkString("variationMarginCollateralPortfolioCode", o.getVariationMarginCollateralPortfolioCode(), 0, of(52), empty()), 
				checkString("cdeCustomBasketCode", o.getCdeCustomBasketCode(), 0, of(72), empty()), 
				checkString("underlierIdOtherLeg1", o.getUnderlierIdOtherLeg1(), 0, of(350), empty()), 
				checkString("underlierIdOtherLeg2", o.getUnderlierIdOtherLeg2(), 0, of(350), empty()), 
				checkString("underlierIdOtherSourceLeg1", o.getUnderlierIdOtherSourceLeg1(), 0, of(350), empty()), 
				checkString("underlierIdOtherSourceLeg2", o.getUnderlierIdOtherSourceLeg2(), 0, of(350), empty()), 
				checkString("cdeUnderlyingAssetTradingPlatformIdLeg1", o.getCdeUnderlyingAssetTradingPlatformIdLeg1(), 0, of(4), empty()), 
				checkString("cdeUnderlyingAssetTradingPlatformIdLeg2", o.getCdeUnderlyingAssetTradingPlatformIdLeg2(), 0, of(4), empty()), 
				checkString("cdeUnderlyingAssetPriceSourceLeg1", o.getCdeUnderlyingAssetPriceSourceLeg1(), 0, of(50), empty()), 
				checkString("cdeUnderlyingAssetPriceSourceLeg2", o.getCdeUnderlyingAssetPriceSourceLeg2(), 0, of(50), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, HarmonizedData o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("HarmonizedData", ValidationType.TYPE_FORMAT, "HarmonizedData", path, "", res.getError());
				}
				return success("HarmonizedData", ValidationType.TYPE_FORMAT, "HarmonizedData", path, "");
			})
			.collect(toList());
	}

}
