# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.Transfer import Transfer
from cdm.observable.asset.PriceTypeEnum import PriceTypeEnum
from cdm.base.math.FinancialUnitEnum import FinancialUnitEnum
from cdm.event.common.CalculateTransferInstruction import CalculateTransferInstruction
from cdm.base.staticdata.party.functions.ExtractCounterpartyByRole import ExtractCounterpartyByRole
from cdm.base.math.NonNegativeQuantity import NonNegativeQuantity
from cdm.observable.asset.functions.FilterPrice import FilterPrice
from cdm.base.math.functions.FilterQuantityByFinancialUnit import FilterQuantityByFinancialUnit

__all__ = ['Create_AssetTransfer']


@replaceable
def Create_AssetTransfer(instruction: CalculateTransferInstruction) -> Transfer:
    """
    Defines how Transfer that represents an exchange of asset based on an asset payout, should be constructed.
    
    Parameters 
    ----------
    instruction : CalculateTransferInstruction
    
    Returns
    -------
    transfer : Transfer
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_ShareUnits(self):
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "quantity"), "unit"), "financialUnit"), "=", rosetta_resolve_attr(FinancialUnitEnum, "SHARE"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "quantity")), _then_fn0, _else_fn0)
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    def _then_fn0():
        return rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "quantity")
    
    def _else_fn0():
        return NonNegativeQuantity(value=rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeQuantity"), "value"), unit=rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeQuantity"), "unit"))
    
    def _then_fn2():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "payer")), "partyReference")
    
    def _else_fn2():
        return True
    
    def _then_fn1():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "payerReceiver"), "payer")), "partyReference")
    
    def _else_fn1():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "payer")), _then_fn2, _else_fn2)
    
    def _then_fn3():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "receiver")), "partyReference")
    
    def _else_fn3():
        return True
    
    def _then_fn2():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "payerReceiver"), "receiver")), "partyReference")
    
    def _else_fn2():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "receiver")), _then_fn3, _else_fn3)
    
    def _then_fn3():
        return get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "product"), "contractualProduct"), "economicTerms"), "collateral"), "collateralPortfolio"), "collateralPosition"), "product"), "contractualProduct"), "economicTerms"), "payout"), "assetPayout"))
    
    def _else_fn3():
        return True
    
    assetPayout = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "product"), "contractualProduct"), "economicTerms"), "collateral"), "collateralPortfolio"), "collateralPosition"), "product"), "contractualProduct"), "economicTerms"), "payout"), "assetPayout"))
    tradeQuantity = get_only_element(FilterQuantityByFinancialUnit(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "tradeLot"), "priceQuantity"), "quantity"), rosetta_resolve_attr(FinancialUnitEnum, "SHARE")))
    securityQuantity = if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "quantity")), _then_fn0, _else_fn0)
    securityPrice = FilterPrice(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "tradeLot"), "priceQuantity"), "price"), rosetta_resolve_attr(PriceTypeEnum, "ASSET_PRICE"), [], [])
    transfer = _get_rosetta_object('Transfer', 'quantity', NonNegativeQuantity(value=rosetta_resolve_attr(rosetta_resolve_attr(self, "securityQuantity"), "value"), unit=rosetta_resolve_attr(rosetta_resolve_attr(self, "securityQuantity"), "unit")))
    transfer.add_rosetta_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, transfer), 'observable'), 'productIdentifier'), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "securityInformation"), "security"), "productIdentifier"))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'payerReceiver->payerPartyReference', if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "payerReceiver"), "payer")), _then_fn0, _else_fn0))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'payerReceiver->receiverPartyReference', if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "payerReceiver"), "payer")), _then_fn1, _else_fn1))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'settlementDate->adjustedDate', rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "date"))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'settlementOrigin->assetPayout', {if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "tradeState"), "trade"), "tradableProduct"), "product"), "contractualProduct"), "economicTerms"), "collateral"), "collateralPortfolio"), "collateralPosition"), "product"), "contractualProduct"), "economicTerms"), "payout"), "assetPayout")), _then_fn3, _else_fn3): True})
    
    
    return transfer

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
