# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.functions.Create_CashflowTermsChangeInstruction import Create_CashflowTermsChangeInstruction
from cdm.observable.asset.Money import Money
from cdm.product.common.settlement.ScheduledTransferEnum import ScheduledTransferEnum
from cdm.event.common.functions.Create_Cashflow import Create_Cashflow
from cdm.event.common.PrimitiveInstruction import PrimitiveInstruction
from cdm.product.common.settlement.CashflowType import CashflowType
from cdm.event.common.TradeState import TradeState
from cdm.product.common.settlement.SettlementDate import SettlementDate

__all__ = ['Create_OnDemandInterestPaymentPrimitiveInstruction']


@replaceable
def Create_OnDemandInterestPaymentPrimitiveInstruction(tradeState: TradeState, interestAmount: Money, settlementDate: SettlementDate) -> PrimitiveInstruction:
    """
    An instruction to make a interium interest payment by adding a payout leg to the deal.
    
    Parameters 
    ----------
    tradeState : TradeState
    The original trade to be modified.
    
    interestAmount : Money
    
    settlementDate : SettlementDate
    
    Returns
    -------
    instruction : PrimitiveInstruction
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_InterestRatePayoutExists(self):
        """
        Only a contractual product with a single interest rate payout can have an on-demand interest payment.
        """
        return rosetta_attr_exists(rosetta_resolve_attr(self, "interestRatePayout"))
    
    @rosetta_local_condition(_pre_registry)
    def condition_1_Currency(self):
        """
        The currency of the interest amount must match the currency of the original interest rate payout.
        """
        return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestAmount"), "unit"), "currency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "priceQuantity"), "quantitySchedule"), "unit"), "currency"))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    interestRatePayout = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradableProduct"), "product"), "contractualProduct"), "economicTerms"), "payout"), "interestRatePayout"))
    cashflow = Create_Cashflow(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestAmount"), "value"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "priceQuantity"), "quantitySchedule"), "unit"), "currency"), rosetta_resolve_attr(self, "settlementDate"), rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "payerReceiver"), CashflowType(cashflowType=rosetta_resolve_attr(ScheduledTransferEnum, "NET_INTEREST")), [])
    instruction =  PrimitiveInstruction(termsChange=Create_CashflowTermsChangeInstruction(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradableProduct"), "product"), "contractualProduct"), rosetta_resolve_attr(self, "cashflow")))
    
    
    return instruction

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
