# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.common.settlement.ScheduledTransferEnum import ScheduledTransferEnum
from cdm.event.common.functions.FilterClosedTradeStates import FilterClosedTradeStates
from cdm.event.common.BusinessEvent import BusinessEvent
from cdm.event.common.functions.FilterOpenTradeStates import FilterOpenTradeStates

__all__ = ['Qualify_OnDemandPayment']


@replaceable
def Qualify_OnDemandPayment(businessEvent: BusinessEvent) -> bool:
    """
    Qualification of a on-demand payment.
    
    Parameters 
    ----------
    businessEvent : BusinessEvent
    
    Returns
    -------
    is_event : boolean
    
    """
    self = inspect.currentframe()
    
    
    instruction = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction"))
    afterTradeStates = FilterOpenTradeStates(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after"))
    beforeCashFlow = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(FilterClosedTradeStates(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after"))), "trade"), "tradableProduct"), "product"), "contractualProduct"), "economicTerms"), "payout"), "cashflow")
    afterCashFlow = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(FilterOpenTradeStates(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after"))), "trade"), "tradableProduct"), "product"), "contractualProduct"), "economicTerms"), "payout"), "cashflow")
    is_event =  (((((all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction"), "before")), "=", 1) and all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after")), "=", 1)) and all_elements(rosetta_count(rosetta_resolve_attr(self, "afterTradeStates")), "=", 1)) and rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "primitiveInstruction"), "termsChange"))) and all_elements(rosetta_count(rosetta_resolve_attr(self, "afterCashFlow")), ">", rosetta_count(rosetta_resolve_attr(self, "beforeCashFlow")))) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "afterCashFlow"), "cashflowType"), "cashflowType"), "=", rosetta_resolve_attr(ScheduledTransferEnum, "NET_INTEREST")))
    
    
    return is_event

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
