# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.functions.QuantityDecreasedToZero import QuantityDecreasedToZero
from cdm.event.common.functions.TransfersForDate import TransfersForDate
from cdm.legaldocumentation.common.ClosedStateEnum import ClosedStateEnum
from cdm.event.common.BusinessEvent import BusinessEvent

__all__ = ['Qualify_FullReturn']


@replaceable
def Qualify_FullReturn(businessEvent: BusinessEvent) -> bool:
    """
    The qualification of a full return event from the fact that (i) a quantityChange primitive and a transfer primitive exists, (ii) an assetPayout exists, (iii) the remaining quantity = 0, and (iv) the closedState of the contract is Terminated.
    
    Parameters 
    ----------
    businessEvent : BusinessEvent
    
    Returns
    -------
    is_event : boolean
    
    """
    self = inspect.currentframe()
    
    
    transfer = get_only_element(TransfersForDate(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after"), "transferHistory"), "transfer"), rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "eventDate")))
    is_event =  (((((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "intent"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after"), "trade"), "tradableProduct"), "product"), "contractualProduct"), "economicTerms"), "collateral"), "collateralPortfolio"), "collateralPosition"), "product"), "contractualProduct"), "economicTerms"), "payout"), "assetPayout"))) and ((all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction")), "=", 1) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction"), "primitiveInstruction"), "quantityChange"))) or (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction"), "primitiveInstruction"), "quantityChange")) and rosetta_attr_exists(rosetta_resolve_attr(self, "transfer"))))) and all_elements(QuantityDecreasedToZero(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction"), "before"), rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after")), "=", True)) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after"), "state"), "closedState"), "state"), "=", rosetta_resolve_attr(ClosedStateEnum, "TERMINATED")))
    
    
    return is_event

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
