# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.template.EconomicTerms import EconomicTerms
from cdm.base.staticdata.asset.common.SecurityTypeEnum import SecurityTypeEnum
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum

__all__ = ['Qualify_AssetClass_Credit']


@replaceable
def Qualify_AssetClass_Credit(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as having the Asset Class classification Credit Default.
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return (((all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "security"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT"))) or Qualify_AssetClass_Credit(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "contractualProduct"), "economicTerms"))) or Qualify_AssetClass_Credit(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "security"), "economicTerms")))
    
    def _else_fn0():
        return False
    
    def _then_fn0():
        return (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "forwardUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "forwardUnderlier"), "security"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT")))
    
    def _else_fn0():
        return False
    
    def _then_fn0():
        return ((all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "performanceUnderlier"), "loan"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT")) or (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "performanceUnderlier"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "DEBT")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "performanceUnderlier"), "security"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT")))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "performanceUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT")))
    
    def _else_fn0():
        return True
    
    optionUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout")), "underlier")
    forwardUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout")), "underlier")
    performanceUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "performancePayout")), "underlier")
    is_product =  ((((rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "creditDefaultPayout")) or rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "creditDefaultPayout"))) or (rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout")) and if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "optionUnderlier")), _then_fn0, _else_fn0))) or (rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout")) and if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "forwardUnderlier")), _then_fn0, _else_fn0))) or (rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "interestRatePayout")) and if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "performanceUnderlier")), _then_fn0, _else_fn0)))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
