# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.template.EconomicTerms import EconomicTerms
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum

__all__ = ['Qualify_AssetClass_ForeignExchange']


@replaceable
def Qualify_AssetClass_ForeignExchange(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as having the Asset Class classification Foreign Exchange
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return Qualify_AssetClass_ForeignExchange(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "contractualProduct"), "economicTerms"))
    
    def _else_fn0():
        return False
    
    def _then_fn0():
        return Qualify_AssetClass_ForeignExchange(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "security"), "economicTerms"))
    
    def _else_fn0():
        return False
    
    optionUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout")), "underlier")
    forwardUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout")), "underlier")
    is_product =  ((((((((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout"), "underlier"), "foreignExchange")) or rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout"), "underlier"), "foreignExchange"))) or rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "performancePayout"), "observationTerms"), "observable"), "currencyPair"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "FOREIGN_EXCHANGE"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "security"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "FOREIGN_EXCHANGE"))) or if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "optionUnderlier")), _then_fn0, _else_fn0)) or if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "optionUnderlier")), _then_fn0, _else_fn0)) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "forwardUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "FOREIGN_EXCHANGE"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "forwardUnderlier"), "security"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "FOREIGN_EXCHANGE")))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
