# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.template.EconomicTerms import EconomicTerms
from cdm.product.qualification.functions.Qualify_AssetClass_Equity import Qualify_AssetClass_Equity

__all__ = ['Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex']


@replaceable
def Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as an Equity Forward with an index as underlier.
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    is_product =  (((all_elements(Qualify_AssetClass_Equity(rosetta_resolve_attr(self, "economicTerms")), "=", True) and rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout")), "underlier"), "index"))) and ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "nonStandardisedTerms"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "nonStandardisedTerms"), "=", False)))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
