# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.template.EconomicTerms import EconomicTerms
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum
from cdm.product.qualification.functions.Qualify_AssetClass_Credit import Qualify_AssetClass_Credit

__all__ = ['Qualify_TotalReturnSwap_Index']


@replaceable
def Qualify_TotalReturnSwap_Index(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as a Total Return Swap Index based on the following qualification criteria: 1) A product which qualifies as Credit, 2) has an interest rate leg and a performance leg, and 3) has performance leg underlier as Index.
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "performanceUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "CREDIT"))
    
    def _else_fn0():
        return True
    
    performanceUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "performancePayout")), "underlier")
    is_product =  (all_elements(Qualify_AssetClass_Credit(rosetta_resolve_attr(self, "economicTerms")), "=", True) and (rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "interestRatePayout")) and if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "performanceUnderlier")), _then_fn0, _else_fn0)))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
