package cdm.base.datetime.validation;

import cdm.base.datetime.DateRange;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class DateRangeTypeFormatValidator implements Validator<DateRange> {

	private List<ComparisonResult> getComparisonResults(DateRange o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DateRange o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DateRange", ValidationType.TYPE_FORMAT, "DateRange", path, "", res.getError());
				}
				return success("DateRange", ValidationType.TYPE_FORMAT, "DateRange", path, "");
			})
			.collect(toList());
	}

}
