package cdm.base.math.validation.datarule;

import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("NonNegativeQuantityScheduleNonNegativeQuantity_amount")
@ImplementedBy(NonNegativeQuantityScheduleNonNegativeQuantity_amount.Default.class)
public interface NonNegativeQuantityScheduleNonNegativeQuantity_amount extends Validator<NonNegativeQuantitySchedule> {
	
	String NAME = "NonNegativeQuantityScheduleNonNegativeQuantity_amount";
	String DEFINITION = "if value exists then value >= 0.0 and if datedValue exists then datedValue -> value all >= 0.0";
	
	class Default implements NonNegativeQuantityScheduleNonNegativeQuantity_amount {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonNegativeQuantitySchedule nonNegativeQuantitySchedule) {
			ComparisonResult result = executeDataRule(nonNegativeQuantitySchedule);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "NonNegativeQuantitySchedule", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "NonNegativeQuantitySchedule", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(NonNegativeQuantitySchedule nonNegativeQuantitySchedule) {
			try {
				if (exists(MapperS.of(nonNegativeQuantitySchedule).<BigDecimal>map("getValue", _nonNegativeQuantitySchedule -> _nonNegativeQuantitySchedule.getValue())).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult;
					if (exists(MapperS.of(nonNegativeQuantitySchedule).<DatedValue>mapC("getDatedValue", _nonNegativeQuantitySchedule -> _nonNegativeQuantitySchedule.getDatedValue())).getOrDefault(false)) {
						ifThenElseResult = greaterThanEquals(MapperS.of(nonNegativeQuantitySchedule).<DatedValue>mapC("getDatedValue", _nonNegativeQuantitySchedule -> _nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue()), MapperS.of(new BigDecimal("0.0")), CardinalityOperator.All);
					} else {
						ifThenElseResult = ComparisonResult.successEmptyOperand("");
					}
					return greaterThanEquals(MapperS.of(nonNegativeQuantitySchedule).<BigDecimal>map("getValue", _nonNegativeQuantitySchedule -> _nonNegativeQuantitySchedule.getValue()), MapperS.of(new BigDecimal("0.0")), CardinalityOperator.All).and(ifThenElseResult);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements NonNegativeQuantityScheduleNonNegativeQuantity_amount {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonNegativeQuantitySchedule nonNegativeQuantitySchedule) {
			return Collections.emptyList();
		}
	}
}
