package cdm.base.staticdata.asset.common.meta;

import cdm.base.staticdata.asset.common.AssetPool;
import cdm.base.staticdata.asset.common.validation.AssetPoolTypeFormatValidator;
import cdm.base.staticdata.asset.common.validation.AssetPoolValidator;
import cdm.base.staticdata.asset.common.validation.datarule.AssetPoolEffectiveDate;
import cdm.base.staticdata.asset.common.validation.exists.AssetPoolOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=AssetPool.class)
public class AssetPoolMeta implements RosettaMetaData<AssetPool> {

	@Override
	public List<Validator<? super AssetPool>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<AssetPool>create(AssetPoolEffectiveDate.class)
		);
	}
	
	@Override
	public List<Function<? super AssetPool, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super AssetPool> validator(ValidatorFactory factory) {
		return factory.<AssetPool>create(AssetPoolValidator.class);
	}

	@Override
	public Validator<? super AssetPool> typeFormatValidator(ValidatorFactory factory) {
		return factory.<AssetPool>create(AssetPoolTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super AssetPool> validator() {
		return new AssetPoolValidator();
	}

	@Deprecated
	@Override
	public Validator<? super AssetPool> typeFormatValidator() {
		return new AssetPoolTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super AssetPool, Set<String>> onlyExistsValidator() {
		return new AssetPoolOnlyExistsValidator();
	}
}
