package cdm.base.staticdata.asset.common.meta;

import cdm.base.staticdata.asset.common.Listing;
import cdm.base.staticdata.asset.common.validation.ListingTypeFormatValidator;
import cdm.base.staticdata.asset.common.validation.ListingValidator;
import cdm.base.staticdata.asset.common.validation.datarule.ListingRelatedExchange;
import cdm.base.staticdata.asset.common.validation.exists.ListingOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=Listing.class)
public class ListingMeta implements RosettaMetaData<Listing> {

	@Override
	public List<Validator<? super Listing>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<Listing>create(ListingRelatedExchange.class)
		);
	}
	
	@Override
	public List<Function<? super Listing, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super Listing> validator(ValidatorFactory factory) {
		return factory.<Listing>create(ListingValidator.class);
	}

	@Override
	public Validator<? super Listing> typeFormatValidator(ValidatorFactory factory) {
		return factory.<Listing>create(ListingTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super Listing> validator() {
		return new ListingValidator();
	}

	@Deprecated
	@Override
	public Validator<? super Listing> typeFormatValidator() {
		return new ListingTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super Listing, Set<String>> onlyExistsValidator() {
		return new ListingOnlyExistsValidator();
	}
}
