package cdm.base.staticdata.asset.common.validation;

import cdm.base.staticdata.asset.common.Bond;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class BondTypeFormatValidator implements Validator<Bond> {

	private List<ComparisonResult> getComparisonResults(Bond o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Bond o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Bond", ValidationType.TYPE_FORMAT, "Bond", path, "", res.getError());
				}
				return success("Bond", ValidationType.TYPE_FORMAT, "Bond", path, "");
			})
			.collect(toList());
	}

}
