package cdm.base.staticdata.asset.common.validation;

import cdm.base.staticdata.asset.common.IdentifiedProduct;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class IdentifiedProductValidator implements Validator<IdentifiedProduct> {

	private List<ComparisonResult> getComparisonResults(IdentifiedProduct o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("productIdentifier", (ProductIdentifier) o.getProductIdentifier() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, IdentifiedProduct o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("IdentifiedProduct", ValidationType.CARDINALITY, "IdentifiedProduct", path, "", res.getError());
				}
				return success("IdentifiedProduct", ValidationType.CARDINALITY, "IdentifiedProduct", path, "");
			})
			.collect(toList());
	}

}
