package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("IndexReferenceInformationIndexAttributes")
@ImplementedBy(IndexReferenceInformationIndexAttributes.Default.class)
public interface IndexReferenceInformationIndexAttributes extends Validator<IndexReferenceInformation> {
	
	String NAME = "IndexReferenceInformationIndexAttributes";
	String DEFINITION = "indexName exists or indexId exists";
	
	class Default implements IndexReferenceInformationIndexAttributes {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, IndexReferenceInformation indexReferenceInformation) {
			ComparisonResult result = executeDataRule(indexReferenceInformation);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "IndexReferenceInformation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "IndexReferenceInformation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(IndexReferenceInformation indexReferenceInformation) {
			try {
				return exists(MapperS.of(indexReferenceInformation).<FieldWithMetaString>map("getIndexName", _indexReferenceInformation -> _indexReferenceInformation.getIndexName())).or(exists(MapperS.of(indexReferenceInformation).<FieldWithMetaString>mapC("getIndexId", _indexReferenceInformation -> _indexReferenceInformation.getIndexId())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements IndexReferenceInformationIndexAttributes {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, IndexReferenceInformation indexReferenceInformation) {
			return Collections.emptyList();
		}
	}
}
