package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Listing;
import cdm.base.staticdata.party.LegalEntity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("ListingRelatedExchange")
@ImplementedBy(ListingRelatedExchange.Default.class)
public interface ListingRelatedExchange extends Validator<Listing> {
	
	String NAME = "ListingRelatedExchange";
	String DEFINITION = "if exchange is absent then relatedExchange is absent";
	
	class Default implements ListingRelatedExchange {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, Listing listing) {
			ComparisonResult result = executeDataRule(listing);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "Listing", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "Listing", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(Listing listing) {
			try {
				if (notExists(MapperS.of(listing).<LegalEntity>map("getExchange", _listing -> _listing.getExchange())).getOrDefault(false)) {
					return notExists(MapperS.of(listing).<LegalEntity>mapC("getRelatedExchange", _listing -> _listing.getRelatedExchange()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ListingRelatedExchange {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, Listing listing) {
			return Collections.emptyList();
		}
	}
}
