package cdm.event.common.meta;

import cdm.event.common.StockSplitInstruction;
import cdm.event.common.validation.StockSplitInstructionTypeFormatValidator;
import cdm.event.common.validation.StockSplitInstructionValidator;
import cdm.event.common.validation.exists.StockSplitInstructionOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=StockSplitInstruction.class)
public class StockSplitInstructionMeta implements RosettaMetaData<StockSplitInstruction> {

	@Override
	public List<Validator<? super StockSplitInstruction>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super StockSplitInstruction, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super StockSplitInstruction> validator(ValidatorFactory factory) {
		return factory.<StockSplitInstruction>create(StockSplitInstructionValidator.class);
	}

	@Override
	public Validator<? super StockSplitInstruction> typeFormatValidator(ValidatorFactory factory) {
		return factory.<StockSplitInstruction>create(StockSplitInstructionTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super StockSplitInstruction> validator() {
		return new StockSplitInstructionValidator();
	}

	@Deprecated
	@Override
	public Validator<? super StockSplitInstruction> typeFormatValidator() {
		return new StockSplitInstructionTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super StockSplitInstruction, Set<String>> onlyExistsValidator() {
		return new StockSplitInstructionOnlyExistsValidator();
	}
}
