package cdm.event.common.meta;

import cdm.event.common.ValuationInstruction;
import cdm.event.common.validation.ValuationInstructionTypeFormatValidator;
import cdm.event.common.validation.ValuationInstructionValidator;
import cdm.event.common.validation.exists.ValuationInstructionOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=ValuationInstruction.class)
public class ValuationInstructionMeta implements RosettaMetaData<ValuationInstruction> {

	@Override
	public List<Validator<? super ValuationInstruction>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ValuationInstruction, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ValuationInstruction> validator(ValidatorFactory factory) {
		return factory.<ValuationInstruction>create(ValuationInstructionValidator.class);
	}

	@Override
	public Validator<? super ValuationInstruction> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ValuationInstruction>create(ValuationInstructionTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ValuationInstruction> validator() {
		return new ValuationInstructionValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ValuationInstruction> typeFormatValidator() {
		return new ValuationInstructionTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ValuationInstruction, Set<String>> onlyExistsValidator() {
		return new ValuationInstructionOnlyExistsValidator();
	}
}
