package cdm.event.common.validation.datarule;

import cdm.event.common.SettlementOrigin;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("SettlementOriginOneOf0")
@ImplementedBy(SettlementOriginOneOf0.Default.class)
public interface SettlementOriginOneOf0 extends Validator<SettlementOrigin> {
	
	String NAME = "SettlementOriginOneOf0";
	String DEFINITION = "one-of";
	
	class Default implements SettlementOriginOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementOrigin settlementOrigin) {
			ComparisonResult result = executeDataRule(settlementOrigin);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SettlementOrigin", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "SettlementOrigin", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SettlementOrigin settlementOrigin) {
			try {
				return choice(MapperS.of(settlementOrigin), Arrays.asList("commodityPayout", "creditDefaultPayout", "forwardPayout", "interestRatePayout", "optionPayout", "assetPayout", "settlementTerms", "performancePayout", "fixedPricePayout"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SettlementOriginOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementOrigin settlementOrigin) {
			return Collections.emptyList();
		}
	}
}
