package cdm.event.workflow.meta;

import cdm.event.workflow.CreditLimitUtilisation;
import cdm.event.workflow.validation.CreditLimitUtilisationTypeFormatValidator;
import cdm.event.workflow.validation.CreditLimitUtilisationValidator;
import cdm.event.workflow.validation.exists.CreditLimitUtilisationOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=CreditLimitUtilisation.class)
public class CreditLimitUtilisationMeta implements RosettaMetaData<CreditLimitUtilisation> {

	@Override
	public List<Validator<? super CreditLimitUtilisation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super CreditLimitUtilisation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super CreditLimitUtilisation> validator(ValidatorFactory factory) {
		return factory.<CreditLimitUtilisation>create(CreditLimitUtilisationValidator.class);
	}

	@Override
	public Validator<? super CreditLimitUtilisation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<CreditLimitUtilisation>create(CreditLimitUtilisationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super CreditLimitUtilisation> validator() {
		return new CreditLimitUtilisationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super CreditLimitUtilisation> typeFormatValidator() {
		return new CreditLimitUtilisationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super CreditLimitUtilisation, Set<String>> onlyExistsValidator() {
		return new CreditLimitUtilisationOnlyExistsValidator();
	}
}
