package cdm.legaldocumentation.common.validation;

import cdm.legaldocumentation.common.OtherAgreementTerms;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class OtherAgreementTermsTypeFormatValidator implements Validator<OtherAgreementTerms> {

	private List<ComparisonResult> getComparisonResults(OtherAgreementTerms o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, OtherAgreementTerms o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("OtherAgreementTerms", ValidationType.TYPE_FORMAT, "OtherAgreementTerms", path, "", res.getError());
				}
				return success("OtherAgreementTerms", ValidationType.TYPE_FORMAT, "OtherAgreementTerms", path, "");
			})
			.collect(toList());
	}

}
