package cdm.legaldocumentation.common.validation.datarule;

import cdm.legaldocumentation.common.OtherAgreementTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("OtherAgreementTermsLegalDocumentSpecified")
@ImplementedBy(OtherAgreementTermsLegalDocumentSpecified.Default.class)
public interface OtherAgreementTermsLegalDocumentSpecified extends Validator<OtherAgreementTerms> {
	
	String NAME = "OtherAgreementTermsLegalDocumentSpecified";
	String DEFINITION = "if isSpecified = True then legalDocument exists";
	
	class Default implements OtherAgreementTermsLegalDocumentSpecified {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, OtherAgreementTerms otherAgreementTerms) {
			ComparisonResult result = executeDataRule(otherAgreementTerms);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "OtherAgreementTerms", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "OtherAgreementTerms", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(OtherAgreementTerms otherAgreementTerms) {
			try {
				if (areEqual(MapperS.of(otherAgreementTerms).<Boolean>map("getIsSpecified", _otherAgreementTerms -> _otherAgreementTerms.getIsSpecified()), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(otherAgreementTerms).<String>map("getLegalDocument", _otherAgreementTerms -> _otherAgreementTerms.getLegalDocument()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements OtherAgreementTermsLegalDocumentSpecified {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, OtherAgreementTerms otherAgreementTerms) {
			return Collections.emptyList();
		}
	}
}
