package cdm.legaldocumentation.master.validation;

import cdm.legaldocumentation.master.EquityMasterConfirmation;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class EquityMasterConfirmationValidator implements Validator<EquityMasterConfirmation> {

	private List<ComparisonResult> getComparisonResults(EquityMasterConfirmation o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, EquityMasterConfirmation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("EquityMasterConfirmation", ValidationType.CARDINALITY, "EquityMasterConfirmation", path, "", res.getError());
				}
				return success("EquityMasterConfirmation", ValidationType.CARDINALITY, "EquityMasterConfirmation", path, "");
			})
			.collect(toList());
	}

}
