package cdm.observable.asset.meta;

import cdm.observable.asset.BondChoiceModel;
import cdm.observable.asset.validation.BondChoiceModelTypeFormatValidator;
import cdm.observable.asset.validation.BondChoiceModelValidator;
import cdm.observable.asset.validation.datarule.BondChoiceModelOneOf0;
import cdm.observable.asset.validation.exists.BondChoiceModelOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=BondChoiceModel.class)
public class BondChoiceModelMeta implements RosettaMetaData<BondChoiceModel> {

	@Override
	public List<Validator<? super BondChoiceModel>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<BondChoiceModel>create(BondChoiceModelOneOf0.class)
		);
	}
	
	@Override
	public List<Function<? super BondChoiceModel, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super BondChoiceModel> validator(ValidatorFactory factory) {
		return factory.<BondChoiceModel>create(BondChoiceModelValidator.class);
	}

	@Override
	public Validator<? super BondChoiceModel> typeFormatValidator(ValidatorFactory factory) {
		return factory.<BondChoiceModel>create(BondChoiceModelTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super BondChoiceModel> validator() {
		return new BondChoiceModelValidator();
	}

	@Deprecated
	@Override
	public Validator<? super BondChoiceModel> typeFormatValidator() {
		return new BondChoiceModelTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super BondChoiceModel, Set<String>> onlyExistsValidator() {
		return new BondChoiceModelOnlyExistsValidator();
	}
}
