package cdm.observable.asset.meta;

import cdm.observable.asset.RateObservation;
import cdm.observable.asset.validation.RateObservationTypeFormatValidator;
import cdm.observable.asset.validation.RateObservationValidator;
import cdm.observable.asset.validation.datarule.RateObservationPositiveObservationWeight;
import cdm.observable.asset.validation.exists.RateObservationOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=RateObservation.class)
public class RateObservationMeta implements RosettaMetaData<RateObservation> {

	@Override
	public List<Validator<? super RateObservation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<RateObservation>create(RateObservationPositiveObservationWeight.class)
		);
	}
	
	@Override
	public List<Function<? super RateObservation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super RateObservation> validator(ValidatorFactory factory) {
		return factory.<RateObservation>create(RateObservationValidator.class);
	}

	@Override
	public Validator<? super RateObservation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<RateObservation>create(RateObservationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super RateObservation> validator() {
		return new RateObservationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super RateObservation> typeFormatValidator() {
		return new RateObservationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super RateObservation, Set<String>> onlyExistsValidator() {
		return new RateObservationOnlyExistsValidator();
	}
}
