package cdm.observable.asset.util;

import cdm.base.staticdata.asset.common.Bond;
import cdm.base.staticdata.asset.common.ConvertibleBond;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.observable.asset.BondChoiceModel;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

public class BondChoiceModelDeepPathUtil {
	public ProductIdentifier chooseProductIdentifier(BondChoiceModel bondChoiceModel) {
		final MapperS<Bond> bond = MapperS.of(bondChoiceModel).<Bond>map("getBond", _bondChoiceModel -> _bondChoiceModel.getBond());
		if (exists(bond).getOrDefault(false)) {
			return bond.<ProductIdentifier>map("getProductIdentifier", _bond -> _bond.getProductIdentifier()).get();
		}
		final MapperS<ConvertibleBond> convertibleBond = MapperS.of(bondChoiceModel).<ConvertibleBond>map("getConvertibleBond", _bondChoiceModel -> _bondChoiceModel.getConvertibleBond());
		if (exists(convertibleBond).getOrDefault(false)) {
			return convertibleBond.<ProductIdentifier>map("getProductIdentifier", _convertibleBond -> _convertibleBond.getProductIdentifier()).get();
		}
		return null;
	}
	
}
