package cdm.observable.asset.util;

import cdm.base.staticdata.asset.common.Equity;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.observable.asset.BondChoiceModel;
import cdm.observable.asset.BondEquityModel;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

public class BondEquityModelDeepPathUtil {
	private final BondChoiceModelDeepPathUtil bondChoiceModelDeepPathUtil;
	
	@Inject
	public BondEquityModelDeepPathUtil(BondChoiceModelDeepPathUtil bondChoiceModelDeepPathUtil) {
		this.bondChoiceModelDeepPathUtil = bondChoiceModelDeepPathUtil;
	}
	
	public ProductIdentifier chooseProductIdentifier(BondEquityModel bondEquityModel) {
		final MapperS<BondChoiceModel> bondchoiceModel = MapperS.of(bondEquityModel).<BondChoiceModel>map("getBondchoiceModel", _bondEquityModel -> _bondEquityModel.getBondchoiceModel());
		if (exists(bondchoiceModel).getOrDefault(false)) {
			return bondchoiceModel.<ProductIdentifier>map("chooseProductIdentifier", bondChoiceModel -> bondChoiceModelDeepPathUtil.chooseProductIdentifier(bondChoiceModel)).get();
		}
		final MapperS<Equity> equity = MapperS.of(bondEquityModel).<Equity>map("getEquity", _bondEquityModel -> _bondEquityModel.getEquity());
		if (exists(equity).getOrDefault(false)) {
			return equity.<ProductIdentifier>map("getProductIdentifier", _equity -> _equity.getProductIdentifier()).get();
		}
		return null;
	}
	
}
