package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.BondChoiceModel;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("BondChoiceModelOneOf0")
@ImplementedBy(BondChoiceModelOneOf0.Default.class)
public interface BondChoiceModelOneOf0 extends Validator<BondChoiceModel> {
	
	String NAME = "BondChoiceModelOneOf0";
	String DEFINITION = "one-of";
	
	class Default implements BondChoiceModelOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondChoiceModel bondChoiceModel) {
			ComparisonResult result = executeDataRule(bondChoiceModel);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "BondChoiceModel", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "BondChoiceModel", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(BondChoiceModel bondChoiceModel) {
			try {
				return choice(MapperS.of(bondChoiceModel), Arrays.asList("bond", "convertibleBond"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements BondChoiceModelOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondChoiceModel bondChoiceModel) {
			return Collections.emptyList();
		}
	}
}
