package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.FloatingRateOption;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("FloatingRateOptionFloatingRateIndex")
@ImplementedBy(FloatingRateOptionFloatingRateIndex.Default.class)
public interface FloatingRateOptionFloatingRateIndex extends Validator<FloatingRateOption> {
	
	String NAME = "FloatingRateOptionFloatingRateIndex";
	String DEFINITION = "optional choice floatingRateIndex, inflationRateIndex";
	
	class Default implements FloatingRateOptionFloatingRateIndex {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingRateOption floatingRateOption) {
			ComparisonResult result = executeDataRule(floatingRateOption);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FloatingRateOption", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "FloatingRateOption", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FloatingRateOption floatingRateOption) {
			try {
				return choice(MapperS.of(floatingRateOption), Arrays.asList("floatingRateIndex", "inflationRateIndex"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FloatingRateOptionFloatingRateIndex {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingRateOption floatingRateOption) {
			return Collections.emptyList();
		}
	}
}
