package cdm.observable.asset.validation.datarule;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaInflationRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("FloatingRateOptionIndexRefInfo")
@ImplementedBy(FloatingRateOptionIndexRefInfo.Default.class)
public interface FloatingRateOptionIndexRefInfo extends Validator<FloatingRateOption> {
	
	String NAME = "FloatingRateOptionIndexRefInfo";
	String DEFINITION = "if floatingRateIndex is absent and inflationRateIndex is absent then indexReferenceInformation exists";
	
	class Default implements FloatingRateOptionIndexRefInfo {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingRateOption floatingRateOption) {
			ComparisonResult result = executeDataRule(floatingRateOption);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FloatingRateOption", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "FloatingRateOption", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FloatingRateOption floatingRateOption) {
			try {
				if (notExists(MapperS.of(floatingRateOption).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", _floatingRateOption -> _floatingRateOption.getFloatingRateIndex())).and(notExists(MapperS.of(floatingRateOption).<FieldWithMetaInflationRateIndexEnum>map("getInflationRateIndex", _floatingRateOption -> _floatingRateOption.getInflationRateIndex()))).getOrDefault(false)) {
					return exists(MapperS.of(floatingRateOption).<IndexReferenceInformation>map("getIndexReferenceInformation", _floatingRateOption -> _floatingRateOption.getIndexReferenceInformation()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FloatingRateOptionIndexRefInfo {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingRateOption floatingRateOption) {
			return Collections.emptyList();
		}
	}
}
