package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.SecurityValuationModel;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("SecurityValuationModelOneOf0")
@ImplementedBy(SecurityValuationModelOneOf0.Default.class)
public interface SecurityValuationModelOneOf0 extends Validator<SecurityValuationModel> {
	
	String NAME = "SecurityValuationModelOneOf0";
	String DEFINITION = "one-of";
	
	class Default implements SecurityValuationModelOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SecurityValuationModel securityValuationModel) {
			ComparisonResult result = executeDataRule(securityValuationModel);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SecurityValuationModel", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "SecurityValuationModel", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SecurityValuationModel securityValuationModel) {
			try {
				return choice(MapperS.of(securityValuationModel), Arrays.asList("bondValuationModel", "unitContractValuationModel"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SecurityValuationModelOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SecurityValuationModel securityValuationModel) {
			return Collections.emptyList();
		}
	}
}
