package cdm.product.asset.validation.datarule;

import cdm.product.asset.CreditIndexReferenceInformation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("CreditIndexReferenceInformationIndexAnnexVersion")
@ImplementedBy(CreditIndexReferenceInformationIndexAnnexVersion.Default.class)
public interface CreditIndexReferenceInformationIndexAnnexVersion extends Validator<CreditIndexReferenceInformation> {
	
	String NAME = "CreditIndexReferenceInformationIndexAnnexVersion";
	String DEFINITION = "if indexAnnexVersion exists then indexAnnexVersion >= 0";
	
	class Default implements CreditIndexReferenceInformationIndexAnnexVersion {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditIndexReferenceInformation creditIndexReferenceInformation) {
			ComparisonResult result = executeDataRule(creditIndexReferenceInformation);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CreditIndexReferenceInformation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CreditIndexReferenceInformation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CreditIndexReferenceInformation creditIndexReferenceInformation) {
			try {
				if (exists(MapperS.of(creditIndexReferenceInformation).<Integer>map("getIndexAnnexVersion", _creditIndexReferenceInformation -> _creditIndexReferenceInformation.getIndexAnnexVersion())).getOrDefault(false)) {
					return greaterThanEquals(MapperS.of(creditIndexReferenceInformation).<Integer>map("getIndexAnnexVersion", _creditIndexReferenceInformation -> _creditIndexReferenceInformation.getIndexAnnexVersion()), MapperS.of(0), CardinalityOperator.All);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CreditIndexReferenceInformationIndexAnnexVersion {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditIndexReferenceInformation creditIndexReferenceInformation) {
			return Collections.emptyList();
		}
	}
}
