package cdm.product.asset.validation.datarule;

import cdm.base.staticdata.asset.common.metafields.FieldWithMetaProductIdentifier;
import cdm.observable.asset.Observable;
import cdm.product.asset.VolatilityReturnTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("VolatilityReturnTermsUnderlierMustBeSecurity")
@ImplementedBy(VolatilityReturnTermsUnderlierMustBeSecurity.Default.class)
public interface VolatilityReturnTermsUnderlierMustBeSecurity extends Validator<VolatilityReturnTerms> {
	
	String NAME = "VolatilityReturnTermsUnderlierMustBeSecurity";
	String DEFINITION = "if exchangeTradedContractNearest exists then exchangeTradedContractNearest -> productIdentifier exists";
	
	class Default implements VolatilityReturnTermsUnderlierMustBeSecurity {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityReturnTerms volatilityReturnTerms) {
			ComparisonResult result = executeDataRule(volatilityReturnTerms);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "VolatilityReturnTerms", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "VolatilityReturnTerms", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(VolatilityReturnTerms volatilityReturnTerms) {
			try {
				if (exists(MapperS.of(volatilityReturnTerms).<Observable>map("getExchangeTradedContractNearest", _volatilityReturnTerms -> _volatilityReturnTerms.getExchangeTradedContractNearest())).getOrDefault(false)) {
					return exists(MapperS.of(volatilityReturnTerms).<Observable>map("getExchangeTradedContractNearest", _volatilityReturnTerms -> _volatilityReturnTerms.getExchangeTradedContractNearest()).<FieldWithMetaProductIdentifier>mapC("getProductIdentifier", observable -> observable.getProductIdentifier()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements VolatilityReturnTermsUnderlierMustBeSecurity {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityReturnTerms volatilityReturnTerms) {
			return Collections.emptyList();
		}
	}
}
